/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.daeau.catchment.utils;

import fr.aquasys.daeau.catchment.constants.CatchmentConstant$;
import fr.aquasys.daeau.catchment.model.CatchmentOptionsState;
import fr.aquasys.daeau.catchment.model.CatchmentSumAnalysis;
import fr.aquasys.daeau.quality.chronicAnalysis.Analysis;
import fr.aquasys.daeau.quality.threshold.ParameterThreshold;
import fr.aquasys.daeau.quality.utils.AnalysisUtil$;
import java.io.Serializable;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CatchmentUtil$ {
    public static final CatchmentUtil$ MODULE$ = new CatchmentUtil$();

    public Option<Object> averageOfAnnualAverageSumPesticides(Seq<CatchmentSumAnalysis> listSumAnalysis) {
        Seq filteredList = (Seq)listSumAnalysis.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$averageOfAnnualAverageSumPesticides$1(a)));
        if (filteredList.nonEmpty()) {
            Map groupYear = filteredList.groupBy((Function1 & Serializable)x$1 -> ((DateTime)x$1.sampleDate().get()).year());
            Iterable annualAverages = (Iterable)groupYear.map((Function1 & Serializable)gy -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$averageOfAnnualAverageSumPesticides$3(gy)));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)annualAverages.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)annualAverages.size())));
        }
        return None$.MODULE$;
    }

    public Option<Object> maxAverageOfAnnualAverageByParameter(Seq<Analysis> listAnalysis) {
        Seq filteredList = (Seq)listAnalysis.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$maxAverageOfAnnualAverageByParameter$1(a)));
        if (filteredList.nonEmpty()) {
            Map groupParameter = filteredList.groupBy((Function1 & Serializable)x$4 -> (String)x$4.parameter().get());
            double max = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)groupParameter.map((Function1 & Serializable)gp -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$maxAverageOfAnnualAverageByParameter$3(gp)))).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
            return new Some((Object)BoxesRunTime.boxToDouble((double)max));
        }
        return None$.MODULE$;
    }

    public Option<Object> maxOfAnnualAverageSumPesticides(Seq<CatchmentSumAnalysis> listSumAnalysis) {
        Seq filteredList = (Seq)listSumAnalysis.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$maxOfAnnualAverageSumPesticides$1(a)));
        if (filteredList.nonEmpty()) {
            Map groupYear = filteredList.groupBy((Function1 & Serializable)x$8 -> ((DateTime)x$8.sampleDate().get()).year());
            Iterable annualAverages = (Iterable)groupYear.map((Function1 & Serializable)gy -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$maxOfAnnualAverageSumPesticides$3(gy)));
            return new Some(annualAverages.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        }
        return None$.MODULE$;
    }

    public Option<Object> maxSumPesticides(Seq<CatchmentSumAnalysis> listSumAnalysis) {
        Seq filteredList = (Seq)listSumAnalysis.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$maxSumPesticides$1(a)));
        if (filteredList.nonEmpty()) {
            return ((CatchmentSumAnalysis)filteredList.maxBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$maxSumPesticides$2(x$11)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).result();
        }
        return None$.MODULE$;
    }

    public Option<Object> nitratesNonConformityPercentage(Seq<Analysis> nitrates, CatchmentOptionsState options) {
        if (nitrates.isEmpty()) {
            return None$.MODULE$;
        }
        Map<String, Seq<Analysis>> groupOperations = AnalysisUtil$.MODULE$.groupByOperation(nitrates);
        int nbOperation = groupOperations.size();
        int nbExceed = groupOperations.count((Function1 & Serializable)go -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.MODULE$.isExceedNitrates((Seq<Analysis>)((Seq)go._2()), options)));
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)nbExceed / (double)nbOperation * (double)100)));
    }

    public Option<Object> substanceNonConformityPercentage(Seq<Analysis> pesticides, CatchmentOptionsState options) {
        if (pesticides.isEmpty()) {
            return None$.MODULE$;
        }
        Seq methods = (Seq)options.calculationMethod().filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$substanceNonConformityPercentage$1(m)));
        Map<String, Seq<Analysis>> groupOperations = AnalysisUtil$.MODULE$.groupByOperation(pesticides);
        int nbOperation = groupOperations.size();
        int nbExceed = methods.isEmpty() ? groupOperations.count((Function1 & Serializable)go -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.MODULE$.isExceedAverageSubstance((Seq<Analysis>)((Seq)go._2()), options))) : groupOperations.count((Function1 & Serializable)go -> BoxesRunTime.boxToBoolean((boolean)methods.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$substanceNonConformityPercentage$4(go, options$2, x0$1)))));
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)nbExceed / (double)nbOperation * (double)100)));
    }

    public Option<Object> sumPesticidesNonConformityPercentage(Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        if (sumPesticides.isEmpty()) {
            return None$.MODULE$;
        }
        Seq methods = (Seq)options.calculationMethod().filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$sumPesticidesNonConformityPercentage$1(m)));
        int nbOperation = sumPesticides.length();
        int nbExceed = methods.isEmpty() ? sumPesticides.count((Function1 & Serializable)sum -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.MODULE$.isExceedMaxSumSubstance((Seq<CatchmentSumAnalysis>)new .colon.colon((Object)sum, (List)Nil$.MODULE$), options))) : sumPesticides.count((Function1 & Serializable)sum -> BoxesRunTime.boxToBoolean((boolean)methods.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$sumPesticidesNonConformityPercentage$4(sum, options$3, x0$1)))));
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)nbExceed / (double)nbOperation * (double)100)));
    }

    public Option<Object> pesticidesNonConformityPercentage(Seq<Analysis> pesticides, Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        if (pesticides.isEmpty()) {
            return None$.MODULE$;
        }
        Map<String, Seq<Analysis>> groupOperations = AnalysisUtil$.MODULE$.groupByOperation(pesticides);
        int nbOperation = groupOperations.size();
        int nbExceed = groupOperations.count((Function1 & Serializable)go -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$pesticidesNonConformityPercentage$1(sumPesticides, options, go)));
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)nbExceed / (double)nbOperation * (double)100)));
    }

    public boolean isExceedNitrates(Seq<Analysis> nitrates, CatchmentOptionsState options) {
        if (nitrates.isEmpty()) {
            return false;
        }
        if (options.usedCriteria() == CatchmentConstant$.MODULE$.P90()) {
            return BoxesRunTime.unboxToDouble((Object)AnalysisUtil$.MODULE$.searchP90Result(nitrates).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY)) > options.thresholdNitrates();
        }
        return BoxesRunTime.unboxToDouble((Object)AnalysisUtil$.MODULE$.searchMaxResult(nitrates).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY)) > options.thresholdNitrates();
    }

    public String getNitratesState(Seq<Analysis> nitrates, CatchmentOptionsState options) {
        if (nitrates.isEmpty()) {
            return CatchmentConstant$.MODULE$.MISSING_DATA();
        }
        if (this.isExceedNitrates(nitrates, options)) {
            return CatchmentConstant$.MODULE$.EXCEEDING();
        }
        return CatchmentConstant$.MODULE$.NO_CONTAMINATION();
    }

    public boolean isExceedAverageSumSubstance(Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        if (sumPesticides.isEmpty()) {
            return false;
        }
        Seq filteredSumPesticides = (Seq)sumPesticides.filter((Function1 & Serializable)sp2 -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedAverageSumSubstance$1(sp2)));
        return BoxesRunTime.unboxToDouble((Object)filteredSumPesticides.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$12, x$13) -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$isExceedAverageSumSubstance$2(BoxesRunTime.unboxToDouble((Object)x$12), x$13)))) / (double)filteredSumPesticides.length() > options.thresholdPesticides2();
    }

    public boolean isExceedMaxSumSubstance(Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        if (sumPesticides.isEmpty()) {
            return false;
        }
        return BoxesRunTime.unboxToDouble((Object)((CatchmentSumAnalysis)sumPesticides.maxBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$isExceedMaxSumSubstance$1(x$14)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).result().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY)) > options.thresholdPesticides2();
    }

    public double getSpecificThreshold(String parameterCode, CatchmentOptionsState options) {
        return BoxesRunTime.unboxToDouble((Object)options.listThresholds().find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$getSpecificThreshold$1(parameterCode, t))).flatMap((Function1 & Serializable)t -> t.threshold1()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> options.thresholdPesticides1()));
    }

    public boolean isExceedAverageSubstance(Seq<Analysis> pesticides, CatchmentOptionsState options) {
        if (pesticides.isEmpty()) {
            return false;
        }
        Seq filteredSumPesticides = (Seq)pesticides.filter((Function1 & Serializable)sp2 -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedAverageSubstance$1(sp2)));
        Map groupParameter = filteredSumPesticides.groupBy((Function1 & Serializable)x$15 -> (String)x$15.parameter().get());
        return groupParameter.exists((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedAverageSubstance$3(options, gp)));
    }

    public boolean isExceedMaxSubstance(Seq<Analysis> pesticides, CatchmentOptionsState options) {
        if (pesticides.isEmpty()) {
            return false;
        }
        Seq filteredSumPesticides = (Seq)pesticides.filter((Function1 & Serializable)sp2 -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedMaxSubstance$1(sp2)));
        Map groupParameter = filteredSumPesticides.groupBy((Function1 & Serializable)x$18 -> (String)x$18.parameter().get());
        return groupParameter.exists((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedMaxSubstance$3(options, gp)));
    }

    public boolean isExceedPesticides(Seq<Analysis> pesticides, Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        Seq methods = (Seq)options.calculationMethod().filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedPesticides$1(m)));
        if (methods.isEmpty()) {
            boolean exceedSumPesticides = this.isExceedMaxSumSubstance(sumPesticides, options);
            boolean exceedAveragePesticides = this.isExceedAverageSubstance(pesticides, options);
            boolean res = exceedSumPesticides || exceedAveragePesticides;
            return res;
        }
        return methods.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$isExceedPesticides$2(pesticides, options, sumPesticides, x0$1)));
    }

    public String getPesticidesState(Seq<Analysis> pesticides, Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        if (pesticides.isEmpty()) {
            return CatchmentConstant$.MODULE$.MISSING_DATA();
        }
        if (this.isExceedPesticides(pesticides, sumPesticides, options)) {
            return CatchmentConstant$.MODULE$.EXCEEDING();
        }
        return CatchmentConstant$.MODULE$.NO_CONTAMINATION();
    }

    public String getContaminationState(Seq<Analysis> nitrates, Seq<Analysis> pesticides, Seq<CatchmentSumAnalysis> sumPesticides, CatchmentOptionsState options) {
        String nitratesState = this.getNitratesState(nitrates, options);
        String pesticidesState = this.getPesticidesState(pesticides, sumPesticides, options);
        String string = nitratesState;
        String string2 = CatchmentConstant$.MODULE$.MISSING_DATA();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = pesticidesState;
            String string4 = CatchmentConstant$.MODULE$.MISSING_DATA();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                return CatchmentConstant$.MODULE$.MISSING_DATA();
            }
        }
        String string5 = nitratesState;
        String string6 = CatchmentConstant$.MODULE$.EXCEEDING();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            String string7 = pesticidesState;
            String string8 = CatchmentConstant$.MODULE$.EXCEEDING();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                return CatchmentConstant$.MODULE$.NITRATES_PESTICIDES();
            }
        }
        String string9 = nitratesState;
        String string10 = CatchmentConstant$.MODULE$.EXCEEDING();
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            return CatchmentConstant$.MODULE$.NITRATES();
        }
        String string11 = pesticidesState;
        String string12 = CatchmentConstant$.MODULE$.EXCEEDING();
        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
            return CatchmentConstant$.MODULE$.PESTICIDES();
        }
        return CatchmentConstant$.MODULE$.NO_CONTAMINATION();
    }

    public Option<Object> getUsedValue(Seq<Analysis> list, CatchmentOptionsState options) {
        int n = options.usedCriteria();
        if (CatchmentConstant$.MODULE$.LAST_VALUE() == n) {
            return AnalysisUtil$.MODULE$.searchLastResult(list);
        }
        if (CatchmentConstant$.MODULE$.MAX() == n) {
            return AnalysisUtil$.MODULE$.searchMaxResult(list);
        }
        if (CatchmentConstant$.MODULE$.MIN() == n) {
            return AnalysisUtil$.MODULE$.searchMinResult(list);
        }
        if (CatchmentConstant$.MODULE$.P90() == n) {
            return AnalysisUtil$.MODULE$.searchP90Result(list);
        }
        if (CatchmentConstant$.MODULE$.AVERAGE() == n) {
            return AnalysisUtil$.MODULE$.calculateAverage(list, options.methodLQ(), options.lqValue());
        }
        return None$.MODULE$;
    }

    public Option<Object> calculateEvolution(Seq<Analysis> list, Seq<Analysis> compareList, CatchmentOptionsState options) {
        if (list.isEmpty() || compareList.isEmpty()) {
            return None$.MODULE$;
        }
        Option<Object> result = this.getUsedValue(list, options);
        Option<Object> compareResult = this.getUsedValue(compareList, options);
        if (result.isDefined() && compareResult.isDefined()) {
            double res = BoxesRunTime.unboxToDouble((Object)result.get()) != 0.0 ? (BoxesRunTime.unboxToDouble((Object)compareResult.get()) - BoxesRunTime.unboxToDouble((Object)result.get())) / BoxesRunTime.unboxToDouble((Object)result.get()) : 0.0;
            return new Some((Object)BoxesRunTime.boxToDouble((double)(res * (double)100)));
        }
        return None$.MODULE$;
    }

    public Option<Object> calculateSumPesticidesEvolution(Seq<CatchmentSumAnalysis> list, Seq<CatchmentSumAnalysis> compareList) {
        if (list.isEmpty() || compareList.isEmpty()) {
            return None$.MODULE$;
        }
        Option<Object> result = this.averageOfAnnualAverageSumPesticides(list);
        Option<Object> compareResult = this.averageOfAnnualAverageSumPesticides(compareList);
        if (result.isDefined() && compareResult.isDefined()) {
            double res = BoxesRunTime.unboxToDouble((Object)result.get()) != 0.0 ? (BoxesRunTime.unboxToDouble((Object)compareResult.get()) - BoxesRunTime.unboxToDouble((Object)result.get())) / BoxesRunTime.unboxToDouble((Object)result.get()) : 0.0;
            return new Some((Object)BoxesRunTime.boxToDouble((double)(res * (double)100)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$averageOfAnnualAverageSumPesticides$1(CatchmentSumAnalysis a) {
        return a.result().isDefined() && a.sampleDate().isDefined();
    }

    public static final /* synthetic */ double $anonfun$averageOfAnnualAverageSumPesticides$4(double x$2, CatchmentSumAnalysis x$3) {
        return x$2 + BoxesRunTime.unboxToDouble((Object)x$3.result().get());
    }

    public static final /* synthetic */ double $anonfun$averageOfAnnualAverageSumPesticides$3(Tuple2 gy) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)gy._2()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$2, x$3) -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$averageOfAnnualAverageSumPesticides$4(BoxesRunTime.unboxToDouble((Object)x$2), x$3)))) / (double)((SeqOps)gy._2()).length();
    }

    public static final /* synthetic */ boolean $anonfun$maxAverageOfAnnualAverageByParameter$1(Analysis a) {
        return a.result().isDefined() && a.sampleDate().isDefined() && a.parameter().isDefined();
    }

    public static final /* synthetic */ double $anonfun$maxAverageOfAnnualAverageByParameter$6(double x$6, Analysis x$7) {
        return x$6 + BoxesRunTime.unboxToDouble((Object)x$7.result().get());
    }

    public static final /* synthetic */ double $anonfun$maxAverageOfAnnualAverageByParameter$5(Tuple2 gy) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)gy._2()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$6, x$7) -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$maxAverageOfAnnualAverageByParameter$6(BoxesRunTime.unboxToDouble((Object)x$6), x$7)))) / (double)((SeqOps)gy._2()).length();
    }

    public static final /* synthetic */ double $anonfun$maxAverageOfAnnualAverageByParameter$3(Tuple2 gp) {
        Map groupYear = ((IterableOps)gp._2()).groupBy((Function1 & Serializable)x$5 -> ((DateTime)x$5.sampleDate().get()).year());
        Iterable annualAverages = (Iterable)groupYear.map((Function1 & Serializable)gy -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$maxAverageOfAnnualAverageByParameter$5(gy)));
        return BoxesRunTime.unboxToDouble((Object)annualAverages.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)annualAverages.size();
    }

    public static final /* synthetic */ boolean $anonfun$maxOfAnnualAverageSumPesticides$1(CatchmentSumAnalysis a) {
        return a.result().isDefined() && a.sampleDate().isDefined();
    }

    public static final /* synthetic */ double $anonfun$maxOfAnnualAverageSumPesticides$4(double x$9, CatchmentSumAnalysis x$10) {
        return x$9 + BoxesRunTime.unboxToDouble((Object)x$10.result().get());
    }

    public static final /* synthetic */ double $anonfun$maxOfAnnualAverageSumPesticides$3(Tuple2 gy) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)gy._2()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$9, x$10) -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$maxOfAnnualAverageSumPesticides$4(BoxesRunTime.unboxToDouble((Object)x$9), x$10)))) / (double)((SeqOps)gy._2()).length();
    }

    public static final /* synthetic */ boolean $anonfun$maxSumPesticides$1(CatchmentSumAnalysis a) {
        return a.result().isDefined();
    }

    public static final /* synthetic */ double $anonfun$maxSumPesticides$2(CatchmentSumAnalysis x$11) {
        return BoxesRunTime.unboxToDouble((Object)x$11.result().get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$substanceNonConformityPercentage$1(String m) {
        String string = m;
        String string2 = CatchmentConstant$.MODULE$.AVERAGE_SUBSTANCE();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = m;
        String string4 = CatchmentConstant$.MODULE$.MAX_SUBSTANCE();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$substanceNonConformityPercentage$4(Tuple2 go$1, CatchmentOptionsState options$2, String x0$1) {
        String string = x0$1;
        String string2 = CatchmentConstant$.MODULE$.AVERAGE_SUBSTANCE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return MODULE$.isExceedAverageSubstance((Seq<Analysis>)((Seq)go$1._2()), options$2);
        }
        String string4 = CatchmentConstant$.MODULE$.MAX_SUBSTANCE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return MODULE$.isExceedMaxSubstance((Seq<Analysis>)((Seq)go$1._2()), options$2);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$sumPesticidesNonConformityPercentage$1(String m) {
        String string = m;
        String string2 = CatchmentConstant$.MODULE$.AVERAGE_SUM();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = m;
        String string4 = CatchmentConstant$.MODULE$.MAX_SUM();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$sumPesticidesNonConformityPercentage$4(CatchmentSumAnalysis sum$1, CatchmentOptionsState options$3, String x0$1) {
        String string = x0$1;
        String string2 = CatchmentConstant$.MODULE$.AVERAGE_SUM();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return MODULE$.isExceedAverageSumSubstance((Seq<CatchmentSumAnalysis>)new .colon.colon((Object)sum$1, (List)Nil$.MODULE$), options$3);
        }
        String string4 = CatchmentConstant$.MODULE$.MAX_SUM();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return MODULE$.isExceedMaxSumSubstance((Seq<CatchmentSumAnalysis>)new .colon.colon((Object)sum$1, (List)Nil$.MODULE$), options$3);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$pesticidesNonConformityPercentage$2(Tuple2 go$2, CatchmentSumAnalysis s) {
        Object object = go$2._1();
        String string = new StringBuilder(1).append(s.qualitometer()).append(":").append(s.operation()).toString();
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$pesticidesNonConformityPercentage$1(Seq sumPesticides$1, CatchmentOptionsState options$4, Tuple2 go) {
        Seq sumAnalysis = (Seq)sumPesticides$1.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)CatchmentUtil$.$anonfun$pesticidesNonConformityPercentage$2(go, s)));
        return MODULE$.isExceedPesticides((Seq<Analysis>)((Seq)go._2()), (Seq<CatchmentSumAnalysis>)sumAnalysis, options$4);
    }

    public static final /* synthetic */ boolean $anonfun$isExceedAverageSumSubstance$1(CatchmentSumAnalysis sp2) {
        return sp2.result().isDefined();
    }

    public static final /* synthetic */ double $anonfun$isExceedAverageSumSubstance$2(double x$12, CatchmentSumAnalysis x$13) {
        return x$12 + BoxesRunTime.unboxToDouble((Object)x$13.result().get());
    }

    public static final /* synthetic */ double $anonfun$isExceedMaxSumSubstance$1(CatchmentSumAnalysis x$14) {
        return BoxesRunTime.unboxToDouble((Object)x$14.result().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY));
    }

    public static final /* synthetic */ boolean $anonfun$getSpecificThreshold$1(String parameterCode$1, ParameterThreshold t) {
        Object object = t.parameterCode().getOrElse((Function0 & Serializable)() -> "####");
        String string = parameterCode$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$isExceedAverageSubstance$1(Analysis sp2) {
        return sp2.result().isDefined() && sp2.parameter().isDefined();
    }

    public static final /* synthetic */ double $anonfun$isExceedAverageSubstance$4(double x$16, Analysis x$17) {
        return x$16 + BoxesRunTime.unboxToDouble((Object)x$17.result().get());
    }

    public static final /* synthetic */ boolean $anonfun$isExceedAverageSubstance$3(CatchmentOptionsState options$6, Tuple2 gp) {
        double th = MODULE$.getSpecificThreshold((String)gp._1(), options$6);
        double average = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)gp._2()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$16, x$17) -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$isExceedAverageSubstance$4(BoxesRunTime.unboxToDouble((Object)x$16), x$17)))) / (double)((SeqOps)gp._2()).length();
        return average > th;
    }

    public static final /* synthetic */ boolean $anonfun$isExceedMaxSubstance$1(Analysis sp2) {
        return sp2.parameter().isDefined();
    }

    public static final /* synthetic */ double $anonfun$isExceedMaxSubstance$4(Analysis x$19) {
        return BoxesRunTime.unboxToDouble((Object)x$19.result().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY));
    }

    public static final /* synthetic */ boolean $anonfun$isExceedMaxSubstance$3(CatchmentOptionsState options$7, Tuple2 gp) {
        double th = MODULE$.getSpecificThreshold((String)gp._1(), options$7);
        double max = BoxesRunTime.unboxToDouble((Object)((Analysis)((IterableOnceOps)gp._2()).maxBy((Function1 & Serializable)x$19 -> BoxesRunTime.boxToDouble((double)CatchmentUtil$.$anonfun$isExceedMaxSubstance$4(x$19)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).result().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY));
        return max > th;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isExceedPesticides$1(String m) {
        String string = m;
        String string2 = CatchmentConstant$.MODULE$.AVERAGE_SUBSTANCE();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = m;
        String string4 = CatchmentConstant$.MODULE$.MAX_SUBSTANCE();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = m;
        String string6 = CatchmentConstant$.MODULE$.AVERAGE_SUM();
        if (string5 == null) {
            if (string6 == null) return true;
        } else if (string5.equals(string6)) return true;
        String string7 = m;
        String string8 = CatchmentConstant$.MODULE$.MAX_SUM();
        if (string7 != null) {
            if (!string7.equals(string8)) return false;
            return true;
        }
        if (string8 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$isExceedPesticides$2(Seq pesticides$1, CatchmentOptionsState options$8, Seq sumPesticides$2, String x0$1) {
        String string = x0$1;
        String string2 = CatchmentConstant$.MODULE$.AVERAGE_SUBSTANCE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return MODULE$.isExceedAverageSubstance((Seq<Analysis>)pesticides$1, options$8);
        }
        String string4 = CatchmentConstant$.MODULE$.MAX_SUBSTANCE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return MODULE$.isExceedMaxSubstance((Seq<Analysis>)pesticides$1, options$8);
        }
        String string6 = CatchmentConstant$.MODULE$.AVERAGE_SUM();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return MODULE$.isExceedAverageSumSubstance((Seq<CatchmentSumAnalysis>)sumPesticides$2, options$8);
        }
        String string8 = CatchmentConstant$.MODULE$.MAX_SUM();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return MODULE$.isExceedMaxSumSubstance((Seq<CatchmentSumAnalysis>)sumPesticides$2, options$8);
        }
        return false;
    }

    private CatchmentUtil$() {
    }
}

