/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.daeau.piezometry.anorms;

import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.ToParameterValue$;
import anorm.ToSql$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import fr.aquasys.daeau.piezometry.domain.ControlError;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks$;
import fr.aquasys.daeau.piezometry.itf.PiezometerControl;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerSituationDao;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.situation.PiezoChronicSituation;
import fr.aquasys.daeau.piezometry.model.situation.PiezoMeasuresSituation;
import fr.aquasys.daeau.piezometry.model.situation.PiezoMeasuresSituation$;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSQLSituationHisto;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSQLSituationHisto$;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSQLSituationLast;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSQLSituationLast$;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSituationDayMeasure;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSituationDayMeasure$;
import fr.aquasys.daeau.piezometry.model.situation.PiezoSituationDays;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem$;
import fr.aquasys.daeau.station.links.aquifer.StationAquifer;
import fr.aquasys.daeau.station.links.arrangements.Arrangement;
import fr.aquasys.daeau.station.links.casings.Casing;
import fr.aquasys.daeau.station.links.contacts.StationContacts;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink;
import fr.aquasys.daeau.station.links.despoliationMode.DespoliationMode;
import fr.aquasys.daeau.station.links.functions.StationFunction;
import fr.aquasys.daeau.station.links.geo.GeoData;
import fr.aquasys.daeau.station.links.hydroEntity.StationHydroEntity;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.landmark.Landmark$;
import fr.aquasys.daeau.station.links.lithologicType.LithologicType;
import fr.aquasys.daeau.station.links.lithology.Lithology;
import fr.aquasys.daeau.station.links.locations.StationLocation;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod$;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.station.links.watermass.StationWatermass;
import fr.aquasys.daeau.station.links.work.StationWorkLink;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.utils.ThresholdUtil$;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001\u0002\u0007\u000e\u0001aA\u0001\"\n\u0001\u0003\u0002\u0003\u0006YA\n\u0005\ta\u0001\u0011\t\u0011)A\u0006c!A1\b\u0001B\u0001B\u0003-A\b\u0003\u0005@\u0001\t\u0005\t\u0015a\u0003A\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u001d\t\t\u0003\u0001C!\u0003GA\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011Q\u0014\u0001\u0005B\u0005}%aG!o_Jl\u0007+[3{_6,G/\u001a:TSR,\u0018\r^5p]\u0012\u000bwN\u0003\u0002\u000f\u001f\u00051\u0011M\\8s[NT!\u0001E\t\u0002\u0015ALWM_8nKR\u0014\u0018P\u0003\u0002\u0013'\u0005)A-Y3bk*\u0011A#F\u0001\bCF,\u0018m]=t\u0015\u00051\u0012A\u00014s\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001eI\u0007\u0002C)\u0011!eD\u0001\u0004SR4\u0017B\u0001\u0013\"\u0005Y\u0001\u0016.\u001a>p[\u0016$XM]*jiV\fG/[8o\t\u0006|\u0017\u0001\u00033bi\u0006\u0014\u0017m]3\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013A\u00013c\u0015\tYC&A\u0002ba&T\u0011!L\u0001\u0005a2\f\u00170\u0003\u00020Q\tAA)\u0019;bE\u0006\u001cX-A\u0007tC:$'/Z\"pI\u0016$\u0015m\u001c\t\u0003eej\u0011a\r\u0006\u0003iU\n1\u0001Z1p\u0015\t1t'\u0001\u0006tC:$'/Z\"pI\u0016T!\u0001O\t\u0002\u0019I,g-\u001a:f]RL\u0017\r\\:\n\u0005i\u001a$!D*b]\u0012\u0014XmQ8eK\u0012\u000bw.A\tQS\u0016Tx.\\3uKJ\u001cuN\u001c;s_2\u0004\"\u0001I\u001f\n\u0005y\n#!\u0005)jKj|W.\u001a;fe\u000e{g\u000e\u001e:pY\u0006!\u0002+[3{_6,G/\u001a:NK\u0006\u001cXO]3EC>\u0004\"\u0001I!\n\u0005\t\u000b#\u0001\u0006)jKj|W.\u001a;fe6+\u0017m];sK\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bR)a\tS%K\u0017B\u0011q\tA\u0007\u0002\u001b!)Q%\u0002a\u0002M!)\u0001'\u0002a\u0002c!)1(\u0002a\u0002y!)q(\u0002a\u0002\u0001\"\u0012Q!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000ba!\u001b8kK\u000e$(\"\u0001*\u0002\u000b)\fg/\u0019=\n\u0005Q{%AB%oU\u0016\u001cG/A\u0005jgBKWM_8EiR\u0011qK\u0017\t\u00035aK!!W\u000e\u0003\u000f\t{w\u000e\\3b]\")1L\u0002a\u00019\u0006\u0011A\r\u001e\t\u00045u{\u0016B\u00010\u001c\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY\u000e\u000e\u0003\rT!\u0001Z\f\u0002\rq\u0012xn\u001c;?\u0013\t17$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014\u001c\u0003I\u0019\u0007.Z2l\u0007>tGO]8m\u000bJ\u0014xN]:\u0015\u000b1\f\t\"!\b\u0015\u00055t\bc\u00018tm:\u0011q.\u001d\b\u0003EBL\u0011\u0001H\u0005\u0003en\tq\u0001]1dW\u0006<W-\u0003\u0002uk\n\u00191+Z9\u000b\u0005I\\\u0002CA<}\u001b\u0005A(BA={\u0003%\u0019\u0018\u000e^;bi&|gN\u0003\u0002|\u001f\u0005)Qn\u001c3fY&\u0011Q\u0010\u001f\u0002\u0016!&,'p\\\"ie>t\u0017nY*jiV\fG/[8o\u0011\u0019yx\u0001q\u0001\u0002\u0002\u0005\t1\r\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0007M\fHN\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u0002\u0014\u001d\u0001\r!!\u0006\u0002\u0007%$7\u000f\u0005\u0003og\u0006]\u0001c\u0001\u000e\u0002\u001a%\u0019\u00111D\u000e\u0003\u0007%sG\u000f\u0003\u0004\u0002 \u001d\u0001\r!\\\u0001\u000bg&$X/\u0019;j_:\u001c\u0018AI4fiBKWM_8nKR,'\u000fV=qK6+\u0017m];sKN\u001c\u0016\u000e^;bi&|g\u000eF\u0007n\u0003K\t\u0019$a\u0013\u0002P\u0005\u0015\u0014\u0011\u000e\u0005\b\u0003OA\u0001\u0019AA\u0015\u0003-\u0001\u0018.\u001a>p[\u0016$XM]:\u0011\t9\u001c\u00181\u0006\t\u0005\u0003[\ty#D\u0001{\u0013\r\t\tD\u001f\u0002\u000b!&,'p\\7fi\u0016\u0014\bbBA\u001b\u0011\u0001\u0007\u0011qG\u0001\bK:$G)\u0019;f!\u0011\tI$a\u0012\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\tA\u0001^5nK*!\u0011\u0011IA\"\u0003\u0011Qw\u000eZ1\u000b\u0005\u0005\u0015\u0013aA8sO&!\u0011\u0011JA\u001e\u0005!!\u0015\r^3US6,\u0007bBA'\u0011\u0001\u0007\u0011qC\u0001\u0007]\n$\u0015-_:\t\u000f\u0005E\u0003\u00021\u0001\u0002T\u0005QA\u000f\u001b:fg\"|G\u000eZ:\u0011\t9\u001c\u0018Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003%!\bN]3tQ>dGMC\u0002\u0002`E\tqa\u001d;bi&|g.\u0003\u0003\u0002d\u0005e#\u0001E*uCRLwN\u001c+ie\u0016\u001c\bn\u001c7e\u0011\u001d\t9\u0007\u0003a\u0001\u0003/\t\u0001\u0002Z1uCRK\b/\u001a\u0005\n\u0003WB\u0001\u0013!a\u0001\u0003[\n\u0001c^5uQ\u000e{g\u000e\u001e:pY\u000eCWmY6\u0011\u0007iiv+\u0001\u0017hKR\u0004\u0016.\u001a>p[\u0016$XM\u001d+za\u0016lU-Y:ve\u0016\u001c8+\u001b;vCRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u000f\u0016\u0005\u0003[\n)h\u000b\u0002\u0002xA!\u0011\u0011PAB\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014!C;oG\",7m[3e\u0015\r\t\tiG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAC\u0003w\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003y9W\r\u001e)jKj|W.\u001a;fe6+\u0017m];sKN\u001c\u0016\u000e^;bi&|g\u000e\u0006\u0003\u0002\f\u0006M\u0005\u0003\u00028t\u0003\u001b\u00032a^AH\u0013\r\t\t\n\u001f\u0002\u0017!&,'p\\'fCN,(/Z:TSR,\u0018\r^5p]\"9\u0011q\u0005\u0006A\u0002\u0005U\u0005\u0003\u00028t\u0003/\u00032AGAM\u0013\r\tYj\u0007\u0002\u0005\u0019>tw-A\u000ehKR\u0004\u0016.\u001a>p[\u0016$XM]:TSR,\u0018\r^5p]\u0012\u000b\u0017p\u001d\u000b\u000b\u0003C\u000bI+!,\u00020\u0006M\u0006\u0003\u00028t\u0003G\u00032a^AS\u0013\r\t9\u000b\u001f\u0002\u0013!&,'p\\*jiV\fG/[8o\t\u0006L8\u000fC\u0004\u0002,.\u0001\r!!\u0006\u0002\u0011ALWM_8JINDq!a\u001a\f\u0001\u0004\t9\u0002C\u0004\u00022.\u0001\r!a\u000e\u0002\t\u0011\fG/\u001a\u0005\b\u0003\u001bZ\u0001\u0019AA\f\u0001")
public class AnormPiezometerSituationDao
implements PiezometerSituationDao {
    private final Database database;
    private final SandreCodeDao sandreCodeDao;
    private final PiezometerControl PiezometerControl;
    private final PiezometerMeasureDao PiezometerMeasureDao;

    public boolean isPiezoDt(Option<String> dt) {
        return dt.isEmpty() || dt.contains((Object)"-1");
    }

    private Seq<PiezoChronicSituation> checkControlErrors(Seq<Object> ids, Seq<PiezoChronicSituation> situations, Connection c) {
        if (situations.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        StringContext stringContext = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT #", " from reperes WHERE codepiezometre IN (", ")"})));
        ParameterValue[] parameterValueArray = new ParameterValue[2];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)Landmark$.MODULE$.columns(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToSql$.MODULE$.seqToSql$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from(ids, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
        List landmarks = (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(Landmark$.MODULE$.parser().$times(), c);
        StringContext stringContext2 = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT #", " from systemes_altimetriques WHERE codepiezometre IN (", ")"})));
        ParameterValue[] parameterValueArray2 = new ParameterValue[2];
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[0] = ParameterValue$.MODULE$.from((Object)AltimetrySystem$.MODULE$.columns(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToSql$.MODULE$.seqToSql$default$1();
        parameterValueArray2[1] = ParameterValue$.MODULE$.from(ids, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
        List altis = (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray2)).as(AltimetrySystem$.MODULE$.parser().$times(), c);
        StringContext stringContext3 = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT #", " from modes_mesures WHERE codepiezometre IN (", ")"})));
        ParameterValue[] parameterValueArray3 = new ParameterValue[2];
        ToStatementPriority0.stringToStatement$ x$11 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray3[0] = ParameterValue$.MODULE$.from((Object)MeasureMethod$.MODULE$.columns(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToSql$.MODULE$.seqToSql$default$1();
        parameterValueArray3[1] = ParameterValue$.MODULE$.from(ids, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
        List measureMethods = (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext3, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray3)).as(MeasureMethod$.MODULE$.parser().$times(), c);
        Seq<SandreCode> periodicityList = this.sandreCodeDao.getSandreList("MODES_MESURES.PERIODICITE");
        Seq<Tuple2<Object, DateTime>> check6Errors = this.PiezometerMeasureDao.searchBadStatusAndQualification(ids);
        return (Seq)situations.map((Function1 & Serializable)situ -> {
            None$ x$13 = None$.MODULE$;
            Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)situ.piezometerId()));
            Some x$15 = new Some((Object)landmarks.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$checkControlErrors$2(situ, x$1))));
            Some x$16 = new Some((Object)altis.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$checkControlErrors$3(situ, x$2))));
            Some x$17 = new Some((Object)measureMethods.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$checkControlErrors$4(situ, x$3))));
            Option<String> x$18 = PiezometerWithLinks$.MODULE$.apply$default$3();
            Option<Object> x$19 = PiezometerWithLinks$.MODULE$.apply$default$4();
            Option<DateTime> x$20 = PiezometerWithLinks$.MODULE$.apply$default$5();
            Option<DateTime> x$21 = PiezometerWithLinks$.MODULE$.apply$default$6();
            Option<Object> x$22 = PiezometerWithLinks$.MODULE$.apply$default$7();
            Option<Object> x$23 = PiezometerWithLinks$.MODULE$.apply$default$8();
            Option<Object> x$24 = PiezometerWithLinks$.MODULE$.apply$default$9();
            Option<Object> x$25 = PiezometerWithLinks$.MODULE$.apply$default$10();
            Option<Object> x$26 = PiezometerWithLinks$.MODULE$.apply$default$11();
            Option<Object> x$27 = PiezometerWithLinks$.MODULE$.apply$default$12();
            Option<String> x$28 = PiezometerWithLinks$.MODULE$.apply$default$13();
            Option<String> x$29 = PiezometerWithLinks$.MODULE$.apply$default$14();
            Option<Object> x$30 = PiezometerWithLinks$.MODULE$.apply$default$15();
            Option<String> x$31 = PiezometerWithLinks$.MODULE$.apply$default$16();
            Option<String> x$32 = PiezometerWithLinks$.MODULE$.apply$default$17();
            Option<Object> x$33 = PiezometerWithLinks$.MODULE$.apply$default$18();
            Option<String> x$34 = PiezometerWithLinks$.MODULE$.apply$default$19();
            Option<String> x$35 = PiezometerWithLinks$.MODULE$.apply$default$20();
            Option<String> x$36 = PiezometerWithLinks$.MODULE$.apply$default$21();
            Option<String> x$37 = PiezometerWithLinks$.MODULE$.apply$default$22();
            Option<Object> x$38 = PiezometerWithLinks$.MODULE$.apply$default$23();
            Option<Object> x$39 = PiezometerWithLinks$.MODULE$.apply$default$24();
            Option<String> x$40 = PiezometerWithLinks$.MODULE$.apply$default$25();
            Option<DateTime> x$41 = PiezometerWithLinks$.MODULE$.apply$default$26();
            Option<Object> x$42 = PiezometerWithLinks$.MODULE$.apply$default$27();
            Option<String> x$43 = PiezometerWithLinks$.MODULE$.apply$default$28();
            Option<Seq<StationWorkLink>> x$44 = PiezometerWithLinks$.MODULE$.apply$default$29();
            Option<Seq<StationContributorLink>> x$45 = PiezometerWithLinks$.MODULE$.apply$default$30();
            Option<Seq<StationNetwork>> x$46 = PiezometerWithLinks$.MODULE$.apply$default$33();
            Option<Seq<DespoliationMode>> x$47 = PiezometerWithLinks$.MODULE$.apply$default$35();
            Option<Seq<StationWatermass>> x$48 = PiezometerWithLinks$.MODULE$.apply$default$36();
            Option<Seq<Lithology>> x$49 = PiezometerWithLinks$.MODULE$.apply$default$37();
            Option<Seq<LithologicType>> x$50 = PiezometerWithLinks$.MODULE$.apply$default$38();
            Option<Seq<Casing>> x$51 = PiezometerWithLinks$.MODULE$.apply$default$39();
            Option<Seq<StationFunction>> x$52 = PiezometerWithLinks$.MODULE$.apply$default$40();
            Option<Seq<Usage>> x$53 = PiezometerWithLinks$.MODULE$.apply$default$41();
            Option<Seq<Arrangement>> x$54 = PiezometerWithLinks$.MODULE$.apply$default$42();
            Option<Seq<Accessibilities>> x$55 = PiezometerWithLinks$.MODULE$.apply$default$43();
            Option<Seq<GeoData>> x$56 = PiezometerWithLinks$.MODULE$.apply$default$44();
            Option<Seq<StationContacts>> x$57 = PiezometerWithLinks$.MODULE$.apply$default$45();
            Option<Seq<StationLocation>> x$58 = PiezometerWithLinks$.MODULE$.apply$default$46();
            Option<Seq<StationAquifer>> x$59 = PiezometerWithLinks$.MODULE$.apply$default$47();
            Option<Seq<StationHydroEntity>> x$60 = PiezometerWithLinks$.MODULE$.apply$default$48();
            Option<Seq<StationTempRef>> x$61 = PiezometerWithLinks$.MODULE$.apply$default$49();
            Option<Seq<PointPrel>> x$62 = PiezometerWithLinks$.MODULE$.apply$default$50();
            Option<Seq<ControlError>> x$63 = PiezometerWithLinks$.MODULE$.apply$default$51();
            PiezometerWithLinks piezo = new PiezometerWithLinks((Option<String>)x$13, (Option<Object>)x$14, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, (Option<Seq<AltimetrySystem>>)x$16, (Option<Seq<Landmark>>)x$15, x$46, (Option<Seq<MeasureMethod>>)x$17, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63);
            PiezometerWithLinks piezoWithErrors = $this.PiezometerControl.checkControlErrors(piezo, (PiezoChronicSituation)situ, (Option<Seq<SandreCode>>)new Some((Object)periodicityList), (Option<Option<DateTime>>)new Some((Object)check6Errors.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$checkControlErrors$5(situ, x$4))).map((Function1 & Serializable)c -> (DateTime)c._2())));
            Option<Seq<ControlError>> x$64 = piezoWithErrors.controlErrors();
            int x$65 = situ.copy$default$1();
            Option<DateTime> x$66 = situ.copy$default$2();
            Option<DateTime> x$67 = situ.copy$default$3();
            Option<Object> x$68 = situ.copy$default$4();
            Option<Object> x$69 = situ.copy$default$5();
            Option<Object> x$70 = situ.copy$default$6();
            Option<Object> x$71 = situ.copy$default$7();
            Option<Object> x$72 = situ.copy$default$8();
            Option<Object> x$73 = situ.copy$default$9();
            Option<Object> x$74 = situ.copy$default$10();
            int x$75 = situ.copy$default$11();
            Option<String> x$76 = situ.copy$default$12();
            Option<String> x$77 = situ.copy$default$13();
            Option<DateTime> x$78 = situ.copy$default$15();
            return situ.copy(x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$64, x$78);
        });
    }

    @Override
    public Seq<PiezoChronicSituation> getPiezometerTypeMeasuresSituation(Seq<Piezometer> piezometers, DateTime endDate, int nbDays, Seq<StationThreshold> thresholds, int dataType, Option<Object> withControlCheck) {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> {
            if (piezometers.nonEmpty()) {
                Seq ids = (Seq)piezometers.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)p.id()));
                Date date = endDate.toDate();
                StringContext stringContext = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                     SELECT\n                         a.codepiezometre piezometerId,\n                         min(a.datemesure) startDate,\n                         max(a.datemesure) lastMeasureDate,\n                         min(coalesce(a.valeurmesurecorrigee, a.valeurmesure)),\n                         max(coalesce(a.valeurmesurecorrigee, a.valeurmesure)),\n                         count(*) measuresCount,\n                         aj.date_effet adesexport\n                     FROM\n                        chroniques_brutes a\n                        left join (select codepiezometre, codebss from piezometres where codepiezometre IN (", ")) p on p.codepiezometre = a.codepiezometre\n                        left join (select identifiant, min(date_effet) as date_effet from ades_journalisation group by identifiant) aj on aj.identifiant = p.codebss\n                     WHERE typeid=", " AND a.datemesure <= ", " AND a.codepiezometre IN (", ") GROUP BY a.codepiezometre, aj.date_effet\n                    "})));
                ParameterValue[] parameterValueArray = new ParameterValue[4];
                ToSql$.MODULE$.seqToSql$default$1();
                parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)ids, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
                ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
                Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)dataType), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                ToStatementPriority0.dateToStatement$ x$7 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
                ToSql$.MODULE$.seqToSql$default$1();
                parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)ids, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
                List situationsHisto = (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezoSQLSituationHisto$.MODULE$.parser().$times(), c);
                StringContext stringContext2 = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                     SELECT\n                            codepiezometre piezometerId,\n                            coalesce(valeurmesurecorrigee, valeurmesure) valeur,\n                            cotechronique cote,\n                            coalesce(valeurngfcorrigee, valeurngf) ngf,\n                            statutmesure,\n                            qualificationmesure\n                     FROM chroniques_brutes\n                     WHERE typeid=", " AND (codepiezometre, datemesure) IN\n                            ( SELECT codepiezometre, max(datemesure) FROM chroniques_brutes WHERE typeid=", " AND datemesure <= ", " AND codepiezometre IN (", ") GROUP BY codepiezometre)\n                    "})));
                ParameterValue[] parameterValueArray2 = new ParameterValue[4];
                ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
                Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray2[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)dataType), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
                ToStatementPriority0.intToStatement$ x$15 = ToStatement$.MODULE$.intToStatement();
                Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray2[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)dataType), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
                ToStatementPriority0.dateToStatement$ x$19 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray2[2] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
                ToSql$.MODULE$.seqToSql$default$1();
                parameterValueArray2[3] = ParameterValue$.MODULE$.from((Object)ids, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
                List situationsLast = (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray2)).as(PiezoSQLSituationLast$.MODULE$.parser().$times(), c);
                List situs = situationsHisto.flatMap((Function1 & Serializable)sHisto -> {
                    Option option = piezometers.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$getPiezometerTypeMeasuresSituation$4(sHisto, p)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Piezometer piezo = (Piezometer)some.value();
                        Option option2 = situationsLast.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$getPiezometerTypeMeasuresSituation$5(sHisto, s)));
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            PiezoSQLSituationLast sLast = (PiezoSQLSituationLast)some2.value();
                            Tuple2<Option<String>, Option<String>> tuple2 = ThresholdUtil$.MODULE$.getThresholdName((Seq<StationThreshold>)((Seq)thresholds.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)AnormPiezometerSituationDao.$anonfun$getPiezometerTypeMeasuresSituation$6(this, piezo, dataType, t)))), sLast.ngf().isDefined() ? sLast.ngf() : sLast.value());
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            Option threshold = (Option)tuple2._1();
                            Option color = (Option)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)threshold, (Object)color);
                            Option threshold2 = (Option)tuple22._1();
                            Option color2 = (Option)tuple22._2();
                            return new Some((Object)new PiezoChronicSituation((PiezoSQLSituationHisto)sHisto, sLast, (Option<String>)threshold2, (Option<String>)color2));
                        }
                        if (None$.MODULE$.equals(option2)) {
                            return None$.MODULE$;
                        }
                        throw new MatchError((Object)option2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)option);
                });
                if (dataType == -1 && withControlCheck.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    return this.checkControlErrors((Seq<Object>)ids, (Seq<PiezoChronicSituation>)situs, (Connection)c);
                }
                return situs;
            }
            return (Seq)Nil$.MODULE$;
        });
    }

    @Override
    public Option<Object> getPiezometerTypeMeasuresSituation$default$6() {
        return None$.MODULE$;
    }

    @Override
    public Seq<PiezoMeasuresSituation> getPiezometerMeasuresSituation(Seq<Object> piezometers) {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> {
            StringContext stringContext = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with STATS_BY_TYPE as(\n               select codepiezometre, typeid, min(datemesure) as mindate, max(datemesure) maxdate, count(valeurmesure) as nbmesure from chroniques_brutes cbstats\n               where cbstats.codepiezometre in (", ")\n               group by codepiezometre, typeid),\n               LAST_MESURE_BY_TYPE as (select cblastm.codepiezometre, cblastm.typeid, cblastm.datemesure as lastdate, coalesce(cblastm.valeurmesurecorrigee, cblastm.valeurmesure) as lastvaleur, coalesce(cblastm.valeurngfcorrigee, cblastm.valeurngf) as lastvaleurngf\n               from chroniques_brutes cblastm\n               where (cblastm.codepiezometre, cblastm.typeid, cblastm.datemesure) in\n               (select cblast.codepiezometre, cblast.typeid, max(cblast.datemesure) from chroniques_brutes cblast\n               where cblast.codepiezometre in (", ")\n               group by cblast.codepiezometre, cblast.typeid)\n               and cblastm.codepiezometre in (", ")),\n               MIN_MESURE_BY_TYPE as (select cbminm.codepiezometre, cbminm.typeid, min(cbminm.datemesure) as datemesuremin, coalesce(cbminm.valeurmesurecorrigee, cbminm.valeurmesure) as minmesure, coalesce(cbminm.valeurngfcorrigee, cbminm.valeurngf) as minmesurengf\n               from chroniques_brutes cbminm\n               where (cbminm.codepiezometre, cbminm.typeid, cbminm.valeurmesure) in\n               (select cbmin.codepiezometre, cbmin.typeid, min(cbmin.valeurmesure) from chroniques_brutes cbmin\n               where cbmin.codepiezometre in (", ")\n               group by cbmin.codepiezometre, cbmin.typeid)\n               and cbminm.codepiezometre in (", ")\n               group by cbminm.codepiezometre, cbminm.typeid, minmesure, minmesurengf),\n               MAX_MESURE_BY_TYPE as (select cbmaxm.codepiezometre, cbmaxm.typeid, min(cbmaxm.datemesure) as datemesuremax, coalesce(cbmaxm.valeurmesurecorrigee, cbmaxm.valeurmesure) as maxmesure, coalesce(cbmaxm.valeurngfcorrigee, cbmaxm.valeurngf) as maxmesurengf\n               from chroniques_brutes cbmaxm\n               where (cbmaxm.codepiezometre, cbmaxm.typeid, cbmaxm.valeurmesure) in\n               (select cbmax.codepiezometre, cbmax.typeid, max(cbmax.valeurmesure) from chroniques_brutes cbmax\n               where cbmax.codepiezometre in (", ")\n               group by cbmax.codepiezometre, cbmax.typeid)\n               and cbmaxm.codepiezometre in (", ")\n               group by cbmaxm.codepiezometre, cbmaxm.typeid, maxmesure, maxmesurengf)\n               select     distinct cb.codepiezometre, cb.typeid,\n                       sbt.mindate, sbt.maxdate, sbt.nbmesure,\n                       lmbt.lastdate, lmbt.lastvaleur , lmbt.lastvaleurngf,\n                       mimbt.datemesuremin, mimbt.minmesure, mimbt.minmesurengf,\n                       mambt.datemesuremax, mambt.maxmesure, mambt.maxmesurengf\n                       from chroniques_brutes cb\n                           left join STATS_BY_TYPE sbt on (cb.codepiezometre = sbt.codepiezometre and cb.typeid = sbt.typeid)\n                           left join LAST_MESURE_BY_TYPE lmbt on (cb.codepiezometre = lmbt.codepiezometre and cb.typeid = lmbt.typeid)\n                           left join MIN_MESURE_BY_TYPE mimbt on (cb.codepiezometre = mimbt.codepiezometre and cb.typeid = mimbt.typeid)\n                           left join MAX_MESURE_BY_TYPE mambt on (cb.codepiezometre = mambt.codepiezometre and cb.typeid = mambt.typeid)\n                       where cb.codepiezometre in (", ")\n               "})));
            ParameterValue[] parameterValueArray = new ParameterValue[8];
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[6] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            ToSql$.MODULE$.seqToSql$default$1();
            parameterValueArray[7] = ParameterValue$.MODULE$.from((Object)piezometers, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.longToStatement())));
            return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezoMeasuresSituation$.MODULE$.parser().$times(), c);
        });
    }

    @Override
    public Seq<PiezoSituationDays> getPiezometersSituationDays(Seq<Object> piezoIds, int dataType, DateTime date, int nbDays) {
        return (Seq)this.database.withTransaction((Function1 & Serializable)c -> {
            Date start = date.minusDays(nbDays).withTimeAtStartOfDay().toDate();
            Date end = date.withTime(23, 59, 59, 999).toDate();
            return (Seq)piezoIds.map((Function1 & Serializable)id -> AnormPiezometerSituationDao.$anonfun$getPiezometersSituationDays$2(dataType, end, start, c, BoxesRunTime.unboxToInt((Object)id)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkControlErrors$2(PiezoChronicSituation situ$1, Landmark x$1) {
        return (int)x$1.idStation() == situ$1.piezometerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkControlErrors$3(PiezoChronicSituation situ$1, AltimetrySystem x$2) {
        return x$2.idStation() == situ$1.piezometerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkControlErrors$4(PiezoChronicSituation situ$1, MeasureMethod x$3) {
        return x$3.idStation() == situ$1.piezometerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkControlErrors$5(PiezoChronicSituation situ$1, Tuple2 x$4) {
        return x$4._1$mcI$sp() == situ$1.piezometerId();
    }

    public static final /* synthetic */ boolean $anonfun$getPiezometerTypeMeasuresSituation$4(PiezoSQLSituationHisto sHisto$1, Piezometer p) {
        return p.id() == sHisto$1.piezometerId();
    }

    public static final /* synthetic */ boolean $anonfun$getPiezometerTypeMeasuresSituation$5(PiezoSQLSituationHisto sHisto$1, PiezoSQLSituationLast s) {
        return s.piezometerId() == sHisto$1.piezometerId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getPiezometerTypeMeasuresSituation$6(AnormPiezometerSituationDao $this, Piezometer piezo$1, int dataType$1, StationThreshold t) {
        String string = ((String)t.code().getOrElse((Function0 & Serializable)() -> "")).toLowerCase();
        String string2 = piezo$1.code().toLowerCase();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (dataType$1 == -1) {
            if ($this.isPiezoDt(t.dataType())) return true;
        }
        if (!t.dataType().contains((Object)Integer.toString(dataType$1))) return false;
        return true;
    }

    public static final /* synthetic */ PiezoSituationDays $anonfun$getPiezometersSituationDays$2(int dataType$2, Date end$1, Date start$1, Connection c$1, int id) {
        ParameterValue[] parameterValueArray = new ParameterValue[4];
        ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)dataType$2), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.intToStatement$ x$7 = ToStatement$.MODULE$.intToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)id), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.dateToStatement$ x$11 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)end$1, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToStatementPriority0.dateToStatement$ x$15 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)start$1, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
        return new PiezoSituationDays(id, (Seq<PiezoSituationDayMeasure>)((Seq)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT date_trunc('day', datemesure) date, max(statutmesure), count(*) from chroniques_brutes where typeid=", " and codepiezometre = ", "\n                  and datemesure <= ", " and datemesure >= ", " group by 1 order by date"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezoSituationDayMeasure$.MODULE$.parser().$times(), c$1)));
    }

    @Inject
    public AnormPiezometerSituationDao(Database database, SandreCodeDao sandreCodeDao, PiezometerControl PiezometerControl2, PiezometerMeasureDao PiezometerMeasureDao2) {
        this.database = database;
        this.sandreCodeDao = sandreCodeDao;
        this.PiezometerControl = PiezometerControl2;
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
    }
}

