/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.daeau.piezometry.anorms;

import anorm.Column$;
import anorm.ParameterMetaData;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToSql$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent$;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.db.Database;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\b\u0010\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006Y\u0001\u000b\u0005\u0006e\u0001!\ta\r\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u0006E\u0002!\te\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0002\u0001C!\u0003'A\u0011\"a\n\u0001#\u0003%\t!!\u000b\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\tY\u0006\u0001C!\u0003;\u0012q#\u00118pe6\u0004\u0016.\u001a>p[\u0016$(/_#wK:$H)Y8\u000b\u0005A\t\u0012AB1o_Jl7O\u0003\u0002\u0013'\u0005Q\u0001/[3{_6,GO]=\u000b\u0005Q)\u0012!\u00023bK\u0006,(B\u0001\f\u0018\u0003\u001d\t\u0017/^1tsNT\u0011\u0001G\u0001\u0003MJ\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0012\u0003\rIGOZ\u0005\u0003M\r\u0012!\u0003U5fu>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_\u0006AA-\u0019;bE\u0006\u001cX\r\u0005\u0002*a5\t!F\u0003\u0002,Y\u0005\u0011AM\u0019\u0006\u0003[9\n1!\u00199j\u0015\u0005y\u0013\u0001\u00029mCfL!!\r\u0016\u0003\u0011\u0011\u000bG/\u00192bg\u0016\fa\u0001P5oSRtD#\u0001\u001b\u0015\u0005U:\u0004C\u0001\u001c\u0001\u001b\u0005y\u0001\"B\u0014\u0003\u0001\bA\u0003F\u0001\u0002:!\tQt(D\u0001<\u0015\taT(\u0001\u0004j]*,7\r\u001e\u0006\u0002}\u0005)!.\u0019<bq&\u0011\u0001i\u000f\u0002\u0007\u0013:TWm\u0019;\u0002\u0007\u001d,G\u000fF\u0002D\u0019F\u00032\u0001\b#G\u0013\t)UD\u0001\u0004PaRLwN\u001c\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013F\tQ!\\8eK2L!a\u0013%\u0003\u001fAKWM_8nKR\u0014\u00180\u0012<f]RDQ!T\u0002A\u00029\u000b\u0011b\u001d;bi&|g.\u00133\u0011\u0005qy\u0015B\u0001)\u001e\u0005\rIe\u000e\u001e\u0005\u0006%\u000e\u0001\rAT\u0001\u0007]Vl'-\u001a:\u0002\u0013\u001d,G/\u0012<f]R\u001cHCA+b!\r1fL\u0012\b\u0003/rs!\u0001W.\u000e\u0003eS!AW\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012BA/\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0007M+\u0017O\u0003\u0002^;!)Q\n\u0002a\u0001\u001d\u0006\u0001r-\u001a;Fm\u0016tGo],ji\"LEm\u001d\u000b\u0003+\u0012DQ!Z\u0003A\u0002\u0019\f!b\u001d;bi&|g.\u00133t!\r1fLT\u0001\u001eO\u0016$8)Y7qC&<g\u000eV=qK^KG\u000f[\"p]:,7\r^5p]R\u0011\u0011. \u000b\u0003UN\u00042\u0001\b#l!\ta\u0007O\u0004\u0002n]B\u0011\u0001,H\u0005\u0003_v\ta\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011q.\b\u0005\u0006i\u001a\u0001\u001d!^\u0001\u0002GB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0004gFd'\"\u0001>\u0002\t)\fg/Y\u0005\u0003y^\u0014!bQ8o]\u0016\u001cG/[8o\u0011\u0015qh\u00011\u0001\u0000\u0003\tIG\rE\u0002\u001d\u0003\u0003I1!a\u0001\u001e\u0005\u0019!u.\u001e2mK\u0006\u0001r-\u001a;DC6\u0004\u0018-[4o\u000bZ,g\u000e\u001e\u000b\u0006+\u0006%\u0011Q\u0002\u0005\u0007\u0003\u00179\u0001\u0019A@\u0002\u0015\r\fW\u000e]1jO:LE\r\u0003\u0004\u0002\u0010\u001d\u0001\ra[\u0001\u0005kN,'/A\tbI\u0012$Vm\u00195oS\u000e\fG.\u0012<f]R$rATA\u000b\u0003/\tY\u0002C\u0003N\u0011\u0001\u0007q\u0010\u0003\u0004\u0002\u001a!\u0001\ra[\u0001\bG>lW.\u001a8u\u0011%\ti\u0002\u0003I\u0001\u0002\u0004\ty\"A\u0005tQ><xI]1qQB!A\u0004RA\u0011!\ra\u00121E\u0005\u0004\u0003Ki\"a\u0002\"p_2,\u0017M\\\u0001\u001cC\u0012$G+Z2i]&\u001c\u0017\r\\#wK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-\"\u0006BA\u0010\u0003[Y#!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003si\u0012AC1o]>$\u0018\r^5p]&!\u0011QHA\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014C\u0012$G+Z2i]&\u001c\u0017\r\\#wK:$xk\u0011\u000b\t\u0003\u0007\n9%!\u0013\u0002LQ\u0019a*!\u0012\t\u000bQT\u00019A;\t\u000b5S\u0001\u0019A@\t\r\u0005e!\u00021\u0001l\u0011%\tiB\u0003I\u0001\u0002\u0004\ty\"A\u000fbI\u0012$Vm\u00195oS\u000e\fG.\u0012<f]R<6\t\n3fM\u0006,H\u000e\u001e\u00134\u0003M\u0019X\r\u001e)jKj|W.\u001a;fe\u00163XM\u001c;t)\u0015q\u00151KA,\u0011\u0019\t)\u0006\u0004a\u0001+\u00061QM^3oiNDa!!\u0017\r\u0001\u0004q\u0015a\u00029jKj|\u0017\nZ\u0001\u0016g\u0016$\b+[3{_6,G/\u001a:Fm\u0016tGo],D)\u0019\ty&a\u0019\u0002fQ\u0019a*!\u0019\t\u000bQl\u00019A;\t\r\u0005US\u00021\u0001V\u0011\u0019\tI&\u0004a\u0001\u001d\u0002")
public class AnormPiezometryEventDao
implements PiezometryEventDao {
    private final Database database;

    @Override
    public Option<PiezometryEvent> get(int stationId, int number) {
        return (Option)this.database.withConnection((Function1 & Serializable)c -> {
            ParameterValue[] parameterValueArray = new ParameterValue[2];
            ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
            ToStatementPriority0.intToStatement$ x$7 = ToStatement$.MODULE$.intToStatement();
            Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)number), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
            return (Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select *\n          from evenements\n          where codepiezometre = ", " and numero = ", "\n      "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezometryEvent$.MODULE$.parser().singleOpt(), c);
        });
    }

    @Override
    public Seq<PiezometryEvent> getEvents(int stationId) {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> {
            ParameterValue[] parameterValueArray = new ParameterValue[1];
            ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
            return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select *\n          from evenements\n          where codepiezometre = ", "\n      "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezometryEvent$.MODULE$.parser().$times(), c);
        });
    }

    @Override
    public Seq<PiezometryEvent> getEventsWithIds(Seq<Object> stationIds) {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> {
            if (stationIds.nonEmpty()) {
                StringContext stringContext = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select *\n                from evenements\n                    where codepiezometre in (", ")\n                "})));
                ParameterValue[] parameterValueArray = new ParameterValue[1];
                ToSql$.MODULE$.seqToSql$default$1();
                parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)stationIds, ToParameterValue$.MODULE$.apply(ToSql$.MODULE$.seqToSql(null), ToStatement$.MODULE$.seqToStatement((ToStatement)ToStatement$.MODULE$.intToStatement())));
                return (Seq)package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezometryEvent$.MODULE$.parser().$times(), c);
            }
            return (Seq)Nil$.MODULE$;
        });
    }

    public Option<String> getCampaignTypeWithConnection(double id, Connection c) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.doubleToStatement$ x$3 = ToStatement$.MODULE$.doubleToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)id), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return (Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        select cs.mnemonique\n        from codes_sandre cs, campagnes c\n        where cs.code=c.typecampagne\n          and cs.champ='EVENEMENTS'\n          and c.codecampagne=", "\n    "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToString()).singleOpt(), c);
    }

    @Override
    public Seq<PiezometryEvent> getCampaignEvent(double campaignId, String user) {
        return (Seq)this.database.withConnection((Function1 & Serializable)c -> {
            ParameterValue[] parameterValueArray = new ParameterValue[5];
            ToStatementPriority0.doubleToStatement$ x$3 = ToStatement$.MODULE$.doubleToStatement();
            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)campaignId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
            ToStatement x$7 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.stringToStatement(), (ParameterMetaData)ParameterMetaData.StringParameterMetaData$.MODULE$);
            Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[1] = ParameterValue$.MODULE$.from(this.getCampaignTypeWithConnection(campaignId, (Connection)c), ToParameterValue$.MODULE$.apply(null, x$7));
            ToStatementPriority0.doubleToStatement$ x$11 = ToStatement$.MODULE$.doubleToStatement();
            Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)campaignId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
            ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)user, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
            ToStatementPriority0.stringToStatement$ x$19 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)user, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
            return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n            select e.*\n            from evenements e\n            where ((e.codecampagne = ", " and e.type = ", ") or e.type = 'P' or e.type = 'S')\n              and codepiezometre in (\n                select codesite\n                from campagnes_sites cs\n                         left join campagnes c on c.codecampagne = cs.codecampagne,\n                     utilisateurs u\n                where c.codecampagne = ", "\n                  and login = ", "\n                  and (isadmin = '1'\n                    or c.loginmaj = ", "\n                    or c.codeintervenant = u.codeintervenant::varchar\n                    or c.codecontact = u.codeintervenant\n                    or c.codegestionnaire = u.codeintervenant))\n        "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(PiezometryEvent$.MODULE$.parser().$times(), c);
        });
    }

    @Override
    public int addTechnicalEvent(double stationId, String comment, Option<Object> showGraph) {
        return BoxesRunTime.unboxToInt((Object)this.database.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)this.addTechnicalEventWC(stationId, comment, (Option<Object>)showGraph, c))));
    }

    @Override
    public Option<Object> addTechnicalEvent$default$3() {
        return None$.MODULE$;
    }

    @Override
    public int addTechnicalEventWC(double stationId, String comment, Option<Object> showGraph, Connection c) {
        ParameterValue parameterValue;
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.doubleToStatement$ x$3 = ToStatement$.MODULE$.doubleToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        double number = BoxesRunTime.unboxToDouble((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select coalesce(max(numero),0) from evenements where codepiezometre=", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToDouble()).single(), c)) + 1.0;
        Date date = DateTime.now().toDate();
        StringContext stringContext = package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into evenements (\n          codepiezometre,\n          numero,\n          dateevenement,\n          commentaires,\n          graphique,\n          exportbanque,\n          type,\n          heureevenement,\n          datemaj,\n          ns,\n          nc,\n          volt\n        ) values (\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          '0',\n          'T',\n          ", ",\n          ", ",\n          null,\n          null,\n          null\n        )"})));
        ParameterValue[] parameterValueArray2 = new ParameterValue[7];
        ToStatementPriority0.doubleToStatement$ x$7 = ToStatement$.MODULE$.doubleToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.doubleToStatement$ x$11 = ToStatement$.MODULE$.doubleToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)number), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToStatementPriority0.dateToStatement$ x$15 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[2] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
        ToStatementPriority0.stringToStatement$ x$19 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[3] = ParameterValue$.MODULE$.from((Object)comment, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
        if (showGraph.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            ToStatementPriority0.charToStatement$ x$23 = ToStatement$.MODULE$.charToStatement();
            Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValue = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToCharacter((char)'1'), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$23));
        } else {
            ToStatementPriority0.charToStatement$ x$27 = ToStatement$.MODULE$.charToStatement();
            Null$ x$28 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValue = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToCharacter((char)'0'), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$27));
        }
        parameterValueArray2[4] = parameterValue;
        ToStatementPriority0.dateToStatement$ x$31 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$32 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[5] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$31));
        ToStatementPriority0.dateToStatement$ x$35 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$36 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray2[6] = ParameterValue$.MODULE$.from((Object)date, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$35));
        return package.SqlStringInterpolation$.MODULE$.SQL$extension(stringContext, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray2)).executeUpdate(c);
    }

    @Override
    public Option<Object> addTechnicalEventWC$default$3() {
        return None$.MODULE$;
    }

    @Override
    public int setPiezometerEvents(Seq<PiezometryEvent> events, int piezoId) {
        return BoxesRunTime.unboxToInt((Object)this.database.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)this.setPiezometerEventsWC((Seq<PiezometryEvent>)events, piezoId, c))));
    }

    @Override
    public int setPiezometerEventsWC(Seq<PiezometryEvent> events, int piezoId, Connection c) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)piezoId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM evenements WHERE codepiezometre=", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
        IntRef number = IntRef.create((int)0);
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)events.map((Function1 & Serializable)e -> BoxesRunTime.boxToInteger((int)AnormPiezometryEventDao.$anonfun$setPiezometerEventsWC$1(number, piezoId, c, e)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$setPiezometerEventsWC$1(IntRef number$2, int piezoId$2, Connection c$1, PiezometryEvent e) {
        ++number$2.elem;
        ParameterValue[] parameterValueArray = new ParameterValue[9];
        ToStatementPriority0.intToStatement$ x$7 = ToStatement$.MODULE$.intToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)piezoId$2), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)number$2.elem), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ToStatement x$15 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.dateToStatement(), (ParameterMetaData)ParameterMetaData.DateParameterMetaData$.MODULE$);
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)e.date().map((Function1 & Serializable)x$1 -> x$1.toDate()), ToParameterValue$.MODULE$.apply(null, x$15));
        ToStatement x$19 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.stringToStatement(), (ParameterMetaData)ParameterMetaData.StringParameterMetaData$.MODULE$);
        Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[3] = ParameterValue$.MODULE$.from(e.comment(), ToParameterValue$.MODULE$.apply(null, x$19));
        ToStatement x$23 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.stringToStatement(), (ParameterMetaData)ParameterMetaData.StringParameterMetaData$.MODULE$);
        Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[4] = ParameterValue$.MODULE$.from(e.graph(), ToParameterValue$.MODULE$.apply(null, x$23));
        ToStatement x$27 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.stringToStatement(), (ParameterMetaData)ParameterMetaData.StringParameterMetaData$.MODULE$);
        Null$ x$28 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[5] = ParameterValue$.MODULE$.from(e.bankExport(), ToParameterValue$.MODULE$.apply(null, x$27));
        ToStatement x$31 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.stringToStatement(), (ParameterMetaData)ParameterMetaData.StringParameterMetaData$.MODULE$);
        Null$ x$32 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[6] = ParameterValue$.MODULE$.from(e.eventType(), ToParameterValue$.MODULE$.apply(null, x$31));
        ToStatement x$35 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.dateToStatement(), (ParameterMetaData)ParameterMetaData.DateParameterMetaData$.MODULE$);
        Null$ x$36 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[7] = ParameterValue$.MODULE$.from((Object)e.eventHour().map((Function1 & Serializable)x$2 -> x$2.toDate()), ToParameterValue$.MODULE$.apply(null, x$35));
        ToStatementPriority0.dateToStatement$ x$39 = ToStatement$.MODULE$.dateToStatement();
        Null$ x$40 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[8] = ParameterValue$.MODULE$.from((Object)new DateTime().toDate(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$39));
        return package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into evenements (\n          codepiezometre,\n          numero,\n          dateevenement,\n          commentaires,\n          graphique,\n          exportbanque,\n          type,\n          heureevenement,\n          datemaj\n        ) values (\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          ", ",\n          ", "\n        )"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c$1);
    }

    @Inject
    public AnormPiezometryEventDao(Database database) {
        this.database = database;
    }
}

