/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.daeau.piezometry.itf;

import fr.aquasys.daeau.piezometry.domain.ControlError;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.model.situation.PiezoChronicSituation;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.aquifer.StationAquifer;
import fr.aquasys.daeau.station.links.arrangements.Arrangement;
import fr.aquasys.daeau.station.links.casings.Casing;
import fr.aquasys.daeau.station.links.contacts.StationContacts;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink;
import fr.aquasys.daeau.station.links.despoliationMode.DespoliationMode;
import fr.aquasys.daeau.station.links.functions.StationFunction;
import fr.aquasys.daeau.station.links.geo.GeoData;
import fr.aquasys.daeau.station.links.hydroEntity.StationHydroEntity;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.lithologicType.LithologicType;
import fr.aquasys.daeau.station.links.lithology.Lithology;
import fr.aquasys.daeau.station.links.locations.StationLocation;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.station.links.watermass.StationWatermass;
import fr.aquasys.daeau.station.links.work.StationWorkLink;
import fr.aquasys.utils.PiezometryUtils$;
import fr.aquasys.utils.ReferentialUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006Y\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0006S!)1\u0007\u0001C\u0001i!)!\t\u0001C\u0001\u0007\"9\u0011\u0010AI\u0001\n\u0003Q\b\"CA\u0006\u0001E\u0005I\u0011AA\u0007\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002\u0002CA \u0001E\u0005I\u0011\u0001>\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u0011Q\u0002\u0005\b\u0003+\u0002A\u0011AA,\u0005E\u0001\u0016.\u001a>p[\u0016$XM]\"p]R\u0014x\u000e\u001c\u0006\u0003%M\t1!\u001b;g\u0015\t!R#\u0001\u0006qS\u0016Tx.\\3uefT!AF\f\u0002\u000b\u0011\fW-Y;\u000b\u0005aI\u0012aB1rk\u0006\u001c\u0018p\u001d\u0006\u00025\u0005\u0011aM]\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0015!&,'p\\7fi\u0016\u0014X*Z1tkJ,G)Y8\u0011\u0005\u00152S\"A\t\n\u0005\u001d\n\"\u0001\u0006)jKj|W.\u001a;fe6+\u0017m];sK\u0012\u000bw.A\u0007tC:$'/Z\"pI\u0016$\u0015m\u001c\t\u0003UEj\u0011a\u000b\u0006\u0003Y5\n1\u0001Z1p\u0015\tqs&\u0001\u0006tC:$'/Z\"pI\u0016T!\u0001M\u000b\u0002\u0019I,g-\u001a:f]RL\u0017\r\\:\n\u0005IZ#!D*b]\u0012\u0014XmQ8eK\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0002kQ\u0019ag\u000e\u001d\u0011\u0005\u0015\u0002\u0001\"B\u0012\u0004\u0001\b!\u0003\"\u0002\u0015\u0004\u0001\bI\u0003FA\u0002;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0004j]*,7\r\u001e\u0006\u0002\u007f\u0005)!.\u0019<bq&\u0011\u0011\t\u0010\u0002\u0007\u0013:TWm\u0019;\u0002%\rDWmY6D_:$(o\u001c7FeJ|'o\u001d\u000b\u0006\t*cUk\u001b\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fN\ta\u0001Z8nC&t\u0017BA%G\u0005M\u0001\u0016.\u001a>p[\u0016$XM],ji\"d\u0015N\\6t\u0011\u0015YE\u00011\u0001E\u0003\u0015\u0001\u0018.\u001a>p\u0011\u0015iE\u00011\u0001O\u0003%\u0019\u0018\u000e^;bi&|g\u000e\u0005\u0002P'6\t\u0001K\u0003\u0002N#*\u0011!kE\u0001\u0006[>$W\r\\\u0005\u0003)B\u0013Q\u0003U5fu>\u001c\u0005N]8oS\u000e\u001c\u0016\u000e^;bi&|g\u000eC\u0004W\tA\u0005\t\u0019A,\u0002+M\fg\u000e\u001a:f\u0019&\u001cH\u000fU3sS>$\u0017nY5usB\u0019a\u0004\u0017.\n\u0005e{\"AB(qi&|g\u000eE\u0002\\G\u001at!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}[\u0012A\u0002\u001fs_>$h(C\u0001!\u0013\t\u0011w$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'aA*fc*\u0011!m\b\t\u0003O&l\u0011\u0001\u001b\u0006\u0003%6J!A\u001b5\u0003\u0015M\u000bg\u000e\u001a:f\u0007>$W\rC\u0004m\tA\u0005\t\u0019A7\u0002\u0017\rDWmY67\r>,h\u000e\u001a\t\u0004=as\u0007c\u0001\u0010Y_B\u0011\u0001o^\u0007\u0002c*\u0011!o]\u0001\u0005i&lWM\u0003\u0002uk\u0006!!n\u001c3b\u0015\u00051\u0018aA8sO&\u0011\u00010\u001d\u0002\t\t\u0006$X\rV5nK\u0006a2\r[3dW\u000e{g\u000e\u001e:pY\u0016\u0013(o\u001c:tI\u0011,g-Y;mi\u0012\u001aT#A>+\u0005]c8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAd\u00195fG.\u001cuN\u001c;s_2,%O]8sg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0010)\u0012Q\u000e`\u0001\u0010G\",7m[02?NL8/\u00117uSR1\u0011QCA\u000f\u0003?\u0001BA\b-\u0002\u0018A\u0019Q)!\u0007\n\u0007\u0005maI\u0001\u0007D_:$(o\u001c7FeJ|'\u000fC\u0003L\u000f\u0001\u0007A\tC\u0003N\u000f\u0001\u0007a*\u0001\tdQ\u0016\u001c7n\u0018\u001a`Y\u0006tG-\\1sWR1\u0011QCA\u0013\u0003OAQa\u0013\u0005A\u0002\u0011CQ!\u0014\u0005A\u00029\u000bQc\u00195fG.|6gX'fCN,(/Z'fi\"|G\r\u0006\u0004\u0002\u0016\u00055\u0012q\u0006\u0005\u0006\u0017&\u0001\r\u0001\u0012\u0005\u0006\u001b&\u0001\rAT\u0001\u001cG\",7m[05?2\fg\u000eZ7be.\f5o]8dS\u0006$\u0018n\u001c8\u0015\t\u0005U\u0011Q\u0007\u0005\u0006\u0017*\u0001\r\u0001R\u0001\u001fG\",7m[06?B,'/[8eS\u000eLG/Z!dcVL7/\u001b;j_:$b!!\u0006\u0002<\u0005u\u0002\"B&\f\u0001\u0004!\u0005b\u0002,\f!\u0003\u0005\raV\u0001)G\",7m[06?B,'/[8eS\u000eLG/Z!dcVL7/\u001b;j_:$C-\u001a4bk2$HEM\u0001\u001dG\",7m[07?N$\u0018\r^;t?F,\u0018\r\\5gS\u000e\fG/[8o)!\t)\"!\u0012\u0002P\u0005E\u0003bBA$\u001b\u0001\u0007\u0011\u0011J\u0001\ba&,'p\\%e!\rq\u00121J\u0005\u0004\u0003\u001bz\"aA%oi\")Q*\u0004a\u0001\u001d\"9A.\u0004I\u0001\u0002\u0004i\u0017AJ2iK\u000e\\wLN0ti\u0006$Xo]0rk\u0006d\u0017NZ5dCRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u00113\r[3dW~;t\f\\1oI6\f'o[:J]\u0006cG/[*zgR,W\u000eR1uKN$B!!\u0006\u0002Z!)1j\u0004a\u0001\t\u0002")
public class PiezometerControl {
    private final PiezometerMeasureDao PiezometerMeasureDao;
    private final SandreCodeDao sandreCodeDao;

    public PiezometerWithLinks checkControlErrors(PiezometerWithLinks piezo, PiezoChronicSituation situation, Option<Seq<SandreCode>> sandreListPeriodicity, Option<Option<DateTime>> check6Found) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq errors = (Seq)new .colon.colon(this.check_1_sysAlti(piezo, situation), (List)new .colon.colon(this.check_2_landmark(piezo, situation), (List)new .colon.colon(this.check_3_MeasureMethod(piezo, situation), (List)new .colon.colon(this.check_4_landmarkAssociation(piezo), (List)new .colon.colon(this.check_5_periodiciteAcquisition(piezo, sandreListPeriodicity), (List)new .colon.colon(this.check_6_status_qualification(BoxesRunTime.unboxToInt((Object)piezo.id().get()), situation, check6Found), (List)new .colon.colon(this.check_7_landmarksInAltiSystemDates(piezo), (List)Nil$.MODULE$))))))).flatten(Predef$.MODULE$.$conforms());
            return errors;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq res = (Seq)success.value();
            Some x$1 = new Some((Object)res);
            Option<String> x$2 = piezo.copy$default$1();
            Option<Object> x$3 = piezo.copy$default$2();
            Option<String> x$4 = piezo.copy$default$3();
            Option<Object> x$5 = piezo.copy$default$4();
            Option<DateTime> x$6 = piezo.copy$default$5();
            Option<DateTime> x$7 = piezo.copy$default$6();
            Option<Object> x$8 = piezo.copy$default$7();
            Option<Object> x$9 = piezo.copy$default$8();
            Option<Object> x$10 = piezo.copy$default$9();
            Option<Object> x$11 = piezo.copy$default$10();
            Option<Object> x$12 = piezo.copy$default$11();
            Option<Object> x$13 = piezo.copy$default$12();
            Option<String> x$14 = piezo.copy$default$13();
            Option<String> x$15 = piezo.copy$default$14();
            Option<Object> x$16 = piezo.copy$default$15();
            Option<String> x$17 = piezo.copy$default$16();
            Option<String> x$18 = piezo.copy$default$17();
            Option<Object> x$19 = piezo.copy$default$18();
            Option<String> x$20 = piezo.copy$default$19();
            Option<String> x$21 = piezo.copy$default$20();
            Option<String> x$22 = piezo.copy$default$21();
            Option<String> x$23 = piezo.copy$default$22();
            Option<Object> x$24 = piezo.copy$default$23();
            Option<Object> x$25 = piezo.copy$default$24();
            Option<String> x$26 = piezo.copy$default$25();
            Option<DateTime> x$27 = piezo.copy$default$26();
            Option<Object> x$28 = piezo.copy$default$27();
            Option<String> x$29 = piezo.copy$default$28();
            Option<Seq<StationWorkLink>> x$30 = piezo.copy$default$29();
            Option<Seq<StationContributorLink>> x$31 = piezo.copy$default$30();
            Option<Seq<AltimetrySystem>> x$32 = piezo.copy$default$31();
            Option<Seq<Landmark>> x$33 = piezo.copy$default$32();
            Option<Seq<StationNetwork>> x$34 = piezo.copy$default$33();
            Option<Seq<MeasureMethod>> x$35 = piezo.copy$default$34();
            Option<Seq<DespoliationMode>> x$36 = piezo.copy$default$35();
            Option<Seq<StationWatermass>> x$37 = piezo.copy$default$36();
            Option<Seq<Lithology>> x$38 = piezo.copy$default$37();
            Option<Seq<LithologicType>> x$39 = piezo.copy$default$38();
            Option<Seq<Casing>> x$40 = piezo.copy$default$39();
            Option<Seq<StationFunction>> x$41 = piezo.copy$default$40();
            Option<Seq<Usage>> x$42 = piezo.copy$default$41();
            Option<Seq<Arrangement>> x$43 = piezo.copy$default$42();
            Option<Seq<Accessibilities>> x$44 = piezo.copy$default$43();
            Option<Seq<GeoData>> x$45 = piezo.copy$default$44();
            Option<Seq<StationContacts>> x$46 = piezo.copy$default$45();
            Option<Seq<StationLocation>> x$47 = piezo.copy$default$46();
            Option<Seq<StationAquifer>> x$48 = piezo.copy$default$47();
            Option<Seq<StationHydroEntity>> x$49 = piezo.copy$default$48();
            Option<Seq<StationTempRef>> x$50 = piezo.copy$default$49();
            Option<Seq<PointPrel>> x$51 = piezo.copy$default$50();
            return piezo.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, (Option<Seq<ControlError>>)x$1);
        }
        if (try_ instanceof Failure) {
            return piezo;
        }
        throw new MatchError((Object)try_);
    }

    public Option<Seq<SandreCode>> checkControlErrors$default$3() {
        return None$.MODULE$;
    }

    public Option<Option<DateTime>> checkControlErrors$default$4() {
        return None$.MODULE$;
    }

    public Option<ControlError> check_1_sysAlti(PiezometerWithLinks piezo, PiezoChronicSituation situation) {
        if (situation.startDate().isEmpty()) {
            return None$.MODULE$;
        }
        boolean foundStart = ((IterableOnceOps)piezo.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_1_sysAlti$2(situation, alt)));
        boolean foundEnd = ((IterableOnceOps)piezo.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_1_sysAlti$4(situation, alt)));
        if (foundStart && foundEnd) {
            return None$.MODULE$;
        }
        return new Some((Object)new ControlError(1, !foundStart ? situation.startDate() : situation.lastMeasureDate(), (Option<String>)new Some((Object)"Altimetry system not found for some measures")));
    }

    public Option<ControlError> check_2_landmark(PiezometerWithLinks piezo, PiezoChronicSituation situation) {
        if (situation.startDate().isEmpty()) {
            return None$.MODULE$;
        }
        boolean foundStart = ((IterableOnceOps)piezo.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_2_landmark$2(situation, alt)));
        boolean foundEnd = ((IterableOnceOps)piezo.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_2_landmark$4(situation, alt)));
        if (foundStart && foundEnd) {
            return None$.MODULE$;
        }
        return new Some((Object)new ControlError(2, !foundStart ? situation.startDate() : situation.lastMeasureDate(), (Option<String>)new Some((Object)"Landmarks not found for some measures")));
    }

    public Option<ControlError> check_3_MeasureMethod(PiezometerWithLinks piezo, PiezoChronicSituation situation) {
        if (situation.startDate().isEmpty()) {
            return None$.MODULE$;
        }
        boolean foundStart = ((IterableOnceOps)piezo.link_measureMethod().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_3_MeasureMethod$2(situation, alt)));
        boolean foundEnd = ((IterableOnceOps)piezo.link_measureMethod().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_3_MeasureMethod$4(situation, alt)));
        if (foundStart && foundEnd) {
            return None$.MODULE$;
        }
        return new Some((Object)new ControlError(3, !foundStart ? situation.startDate() : situation.lastMeasureDate(), (Option<String>)new Some((Object)"Measure method not found for some measures")));
    }

    public Option<ControlError> check_4_landmarkAssociation(PiezometerWithLinks piezo) {
        Seq badLandmarks = (Seq)((IterableOps)piezo.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_4_landmarkAssociation$2(piezo, l)));
        if (badLandmarks.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)new ControlError(4, ((Landmark)badLandmarks.head()).startDate(), (Option<String>)new Some((Object)"Landmark found without associated Altimetric System")));
    }

    public Option<ControlError> check_5_periodiciteAcquisition(PiezometerWithLinks piezo, Option<Seq<SandreCode>> sandreListPeriodicity) {
        if (((SeqOps)piezo.link_measureMethod().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).isEmpty()) {
            return None$.MODULE$;
        }
        Seq labels = (Seq)sandreListPeriodicity.getOrElse((Function0 & Serializable)() -> $this.sandreCodeDao.getSandreList("MODES_MESURES.PERIODICITE"));
        Seq badMeasureMethod = (Seq)((IterableOps)piezo.link_measureMethod().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).filter((Function1 & Serializable)mm -> BoxesRunTime.boxToBoolean((boolean)PiezometerControl.$anonfun$check_5_periodiciteAcquisition$4(labels, mm)));
        if (badMeasureMethod.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)new ControlError(5, ((MeasureMethod)badMeasureMethod.head()).startDate(), (Option<String>)new Some((Object)"Bad periodicty found")));
    }

    public Option<Seq<SandreCode>> check_5_periodiciteAcquisition$default$2() {
        return None$.MODULE$;
    }

    public Option<ControlError> check_6_status_qualification(int piezoId, PiezoChronicSituation situation, Option<Option<DateTime>> check6Found) {
        if (check6Found.isDefined()) {
            Option errorFound = (Option)check6Found.get();
            if (errorFound.isEmpty()) {
                return None$.MODULE$;
            }
            return new Some((Object)new ControlError(6, (Option<DateTime>)errorFound, (Option<String>)new Some((Object)"Bad couple status/qualification")));
        }
        if (situation.startDate().isEmpty()) {
            return None$.MODULE$;
        }
        Option<DateTime> errorFound = this.PiezometerMeasureDao.searchBadStatusAndQualification(piezoId);
        if (errorFound.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)new ControlError(6, errorFound, (Option<String>)new Some((Object)"Bad couple status/qualification")));
    }

    public Option<Option<DateTime>> check_6_status_qualification$default$3() {
        return None$.MODULE$;
    }

    public Option<ControlError> check_7_landmarksInAltiSystemDates(PiezometerWithLinks piezo) {
        return ((IterableOps)((IterableOps)piezo.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)l -> {
            Option<AltimetrySystem> option = PiezometryUtils$.MODULE$.getLandmarkSysAlti((Landmark)l, (Seq<AltimetrySystem>)((Seq)piezo.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)));
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                AltimetrySystem alti = (AltimetrySystem)some.value();
                if (((BaseDateTime)alti.startDate().get()).getMillis() > ((BaseDateTime)l.startDate().get()).getMillis()) {
                    return new Some((Object)new Tuple2(l.startDate().get(), (Object)"Landmark must have altimetric system defined before it"));
                }
                return None$.MODULE$;
            }
            throw new MatchError(option);
        })).headOption().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DateTime date = (DateTime)tuple2._1();
                String error = (String)tuple2._2();
                return new ControlError(7, (Option<DateTime>)new Some((Object)date), (Option<String>)new Some((Object)error));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$check_1_sysAlti$2(PiezoChronicSituation situation$2, AltimetrySystem alt) {
        return alt.altitude().isDefined() && alt.startDate().isDefined() && ((BaseDateTime)alt.startDate().get()).getMillis() <= ((BaseDateTime)situation$2.startDate().get()).getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$check_1_sysAlti$4(PiezoChronicSituation situation$2, AltimetrySystem alt) {
        return alt.altitude().isDefined() && (alt.endDate().isEmpty() || ((BaseDateTime)alt.endDate().get()).getMillis() >= ((BaseDateTime)situation$2.lastMeasureDate().get()).getMillis());
    }

    public static final /* synthetic */ boolean $anonfun$check_2_landmark$2(PiezoChronicSituation situation$3, Landmark alt) {
        return alt.height().isDefined() && alt.startDate().isDefined() && ((BaseDateTime)alt.startDate().get()).getMillis() <= ((BaseDateTime)situation$3.startDate().get()).getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$check_2_landmark$4(PiezoChronicSituation situation$3, Landmark alt) {
        return alt.height().isDefined() && (alt.endDate().isEmpty() || ((BaseDateTime)alt.endDate().get()).getMillis() >= ((BaseDateTime)situation$3.lastMeasureDate().get()).getMillis());
    }

    public static final /* synthetic */ boolean $anonfun$check_3_MeasureMethod$2(PiezoChronicSituation situation$4, MeasureMethod alt) {
        return alt.startDate().isDefined() && ((BaseDateTime)alt.startDate().get()).getMillis() <= ((BaseDateTime)situation$4.startDate().get()).getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$check_3_MeasureMethod$4(PiezoChronicSituation situation$4, MeasureMethod alt) {
        return alt.endDate().isEmpty() || ((BaseDateTime)alt.endDate().get()).getMillis() >= ((BaseDateTime)situation$4.lastMeasureDate().get()).getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$check_4_landmarkAssociation$2(PiezometerWithLinks piezo$2, Landmark l) {
        return PiezometryUtils$.MODULE$.getLandmarkSysAlti(l, (Seq<AltimetrySystem>)((Seq)piezo$2.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$))).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$check_5_periodiciteAcquisition$4(Seq labels$1, MeasureMethod mm) {
        return ReferentialUtil$.MODULE$.getSandreLabel("MODES_MESURES.PERIODICITE", BoxesRunTime.unboxToInt((Object)mm.periodicityAcqui().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), (Seq<SandreCode>)labels$1).length() > 7;
    }

    @Inject
    public PiezometerControl(PiezometerMeasureDao PiezometerMeasureDao2, SandreCodeDao sandreCodeDao) {
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
        this.sandreCodeDao = sandreCodeDao;
    }
}

