/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.daeau.piezometry.itf;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import fr.aquasys.daeau.piezometry.domain.PiezometerLinks;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.piezometry.model.measure.PiezometerChronicRawMeasure;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.model.DataType;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.PiezometryUtils$;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\u0005\n\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006Y\u0001\b\u0005\tA\u0001\u0011\t\u0011)A\u0006C!AA\u0005\u0001B\u0001B\u0003-Q\u0005C\u0003-\u0001\u0011\u0005Q\u0006C\u0003=\u0001\u0011\u0005Q\bC\u0003b\u0001\u0011\u0005!\rC\u0003r\u0001\u0011%!O\u0001\rQS\u0016Tx.\\3uKJd\u0015M\u001c3nCJ\\7\t[1oO\u0016T!AC\u0006\u0002\u0007%$hM\u0003\u0002\r\u001b\u0005Q\u0001/[3{_6,GO]=\u000b\u00059y\u0011!\u00023bK\u0006,(B\u0001\t\u0012\u0003\u001d\t\u0017/^1tsNT\u0011AE\u0001\u0003MJ\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fA\u0003U5fu>lW\r^3s\u001b\u0016\f7/\u001e:f\t\u0006|\u0007CA\u000f\u001f\u001b\u0005I\u0011BA\u0010\n\u0005Q\u0001\u0016.\u001a>p[\u0016$XM]'fCN,(/\u001a#b_\u0006\u0011\u0002+[3{_6,GO]=Fm\u0016tG\u000fR1p!\ti\"%\u0003\u0002$\u0013\t\u0011\u0002+[3{_6,GO]=Fm\u0016tG\u000fR1p\u0003-!\u0015\r^1UsB,G)Y8\u0011\u0005\u0019RS\"A\u0014\u000b\u0005)A#BA\u0015\u000e\u0003\u001d\u0019H/\u0019;j_:L!aK\u0014\u0003\u0017\u0011\u000bG/\u0019+za\u0016$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\"Ba\f\u00192eA\u0011Q\u0004\u0001\u0005\u00067\u0011\u0001\u001d\u0001\b\u0005\u0006A\u0011\u0001\u001d!\t\u0005\u0006I\u0011\u0001\u001d!\n\u0015\u0003\tQ\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\r%t'.Z2u\u0015\u0005I\u0014!\u00026bm\u0006D\u0018BA\u001e7\u0005\u0019IeN[3di\u0006q1\r[1oO\u0016d\u0015M\u001c3nCJ\\Gc\u0001 M)R\u0011qH\u0011\t\u0003-\u0001K!!Q\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0007\u0016\u0001\u001d\u0001R\u0001\u0002GB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0004gFd'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013!bQ8o]\u0016\u001cG/[8o\u0011\u0015iU\u00011\u0001O\u0003\u0015\u0001\u0018.\u001a>p!\ty%+D\u0001Q\u0015\t\t6\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003'B\u0013q\u0002U5fu>lW\r^3s\u0019&t7n\u001d\u0005\u0006+\u0016\u0001\rAV\u0001\u0005kN,'\u000f\u0005\u0002X=:\u0011\u0001\f\u0018\t\u00033^i\u0011A\u0017\u0006\u00037N\ta\u0001\u0010:p_Rt\u0014BA/\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u;\u0012AF2iC:<W\rT1oI6\f'o\u001b$peBKWM_8\u0015\u000b\r,gm\u001a7\u0015\u0005}\"\u0007\"B\"\u0007\u0001\b!\u0005\"B'\u0007\u0001\u0004q\u0005\"B+\u0007\u0001\u00041\u0006\"\u00025\u0007\u0001\u0004I\u0017A\u0002;za\u0016LE\r\u0005\u0002\u0017U&\u00111n\u0006\u0002\u0004\u0013:$\b\"B7\u0007\u0001\u0004q\u0017a\u00068fK\u0012,\u0006\u000fZ1uK2\u000bg\u000eZ7be.\u001cxJ\u001c7z!\t1r.\u0003\u0002q/\t9!i\\8mK\u0006t\u0017aD1qa2L8i\u001c:sK\u000e$hj\u0012$\u0015!M,\u0018\u0011BA\u0007\u0003#\t)\"!\u0007\u0002\u001e\u0005}ACA5u\u0011\u0015\u0019u\u0001q\u0001E\u0011\u00151x\u00011\u0001x\u0003\u0015\u0019w\u000e^3t!\u0011AX0!\u0001\u000f\u0005e\\hBA-{\u0013\u0005A\u0012B\u0001?\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!A`@\u0003\u0007M+\u0017O\u0003\u0002}/A!\u00010`A\u0002!\r1\u0012QA\u0005\u0004\u0003\u000f9\"A\u0002#pk\ndW\rC\u0004\u0002\f\u001d\u0001\r!!\u0001\u0002!A\u0014XM^5pkNd\u0015M\u001c3nCJ\\\u0007BBA\b\u000f\u0001\u0007\u0011.A\u0005ti\u0006$\u0018n\u001c8JI\"1\u00111C\u0004A\u0002%\fQaY8v]RDa!a\u0006\b\u0001\u0004q\u0017!\u00048fK\u0012,\u0006\u000fZ1uK:;e\t\u0003\u0004\u0002\u001c\u001d\u0001\rA\\\u0001\u0014]\u0016,G-\u00169eCR,G*\u00198e[\u0006\u00148n\u001d\u0005\u0006Q\u001e\u0001\r!\u001b\u0005\u0007\u0003C9\u0001\u0019A5\u0002\u0015I|WO\u001c3WC2,X\rK\u0002\b\u0003K\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W9\u0012AC1o]>$\u0018\r^5p]&!\u0011qFA\u0015\u0005\u001d!\u0018-\u001b7sK\u000e\u0004")
public class PiezometerLandmarkChange {
    private final PiezometerMeasureDao PiezometerMeasureDao;
    private final PiezometryEventDao PiezometryEventDao;
    private final DataTypeDao DataTypeDao;

    public void changeLandmark(PiezometerLinks piezo, String user, Connection c) {
        this.changeLandmarkForPiezo(piezo, user, -1, false, c);
        ((IterableOnceOps)this.DataTypeDao.getDataTypesByProject("SIES").filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)PiezometerLandmarkChange.$anonfun$changeLandmark$1(d)))).foreach((Function1 & Serializable)dt -> {
            this.changeLandmarkForPiezo(piezo, user, (int)dt.id(), false, c);
            return BoxedUnit.UNIT;
        });
    }

    public void changeLandmarkForPiezo(PiezometerLinks piezo, String user, int typeId, boolean needUpdateLandmarksOnly, Connection c) {
        Seq measures = (Seq)this.PiezometerMeasureDao.getPiezometerMeasuresFromType(piezo.idStation(), typeId, this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$3(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$4(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$5(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$6(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$7(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$8(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$9(), this.PiezometerMeasureDao.getPiezometerMeasuresFromType$default$10()).sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)PiezometerLandmarkChange.$anonfun$changeLandmarkForPiezo$1(x$1)), (Ordering)Ordering.Long$.MODULE$);
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.intToStatement$ x$32 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$32));
        int roundValue = BoxesRunTime.unboxToInt((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select nombresdecimales from parametrage_data where id=", " and projet= 'SIES'"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 3));
        boolean needUpdateNGF = needUpdateLandmarksOnly ? false : measures.exists((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PiezometerLandmarkChange.$anonfun$changeLandmarkForPiezo$3(piezo, roundValue, m)));
        boolean needUpdateLandmarks = measures.exists((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PiezometerLandmarkChange.$anonfun$changeLandmarkForPiezo$9(piezo, m)));
        if (needUpdateNGF || needUpdateLandmarks) {
            Seq cotes = (Seq)((SeqOps)((IterableOps)((IterableOps)piezo.link_landmarks().get()).flatMap((Function1 & Serializable)l -> PiezometryUtils$.MODULE$.getLandmarkSysAlti((Landmark)l, (Seq<AltimetrySystem>)((Seq)piezo.link_altimetrySystems().get())).map((Function1 & Serializable)alt -> new Tuple2(l, alt)))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Landmark l = (Landmark)tuple2._1();
                    AltimetrySystem alt = (AltimetrySystem)tuple2._2();
                    return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{((BaseDateTime)l.startDate().getOrElse((Function0 & Serializable)() -> {
                        throw new Exception("Rep\u00e8re avec une date de d\u00e9but vide !");
                    })).getMillis(), BoxesRunTime.unboxToDouble((Object)l.height().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble((Object)alt.altitude().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)), BoxesRunTime.unboxToDouble((Object)l.height().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)), BoxesRunTime.unboxToDouble((Object)alt.altitude().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))}));
                }
                throw new MatchError((Object)tuple2);
            })).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)PiezometerLandmarkChange.$anonfun$changeLandmarkForPiezo$22(x$3)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
            if (needUpdateNGF) {
                Predef$.MODULE$.println((Object)new StringBuilder(37).append("Updating NGF on measures for piezo : ").append(piezo.idStation()).toString());
            }
            if (needUpdateLandmarks) {
                Predef$.MODULE$.println((Object)new StringBuilder(55).append("Updating landmarks and refAlti on measures for piezo : ").append(piezo.idStation()).toString());
            }
            int updated = this.applyCorrectNGF((Seq<Seq<Object>>)((Seq)cotes.tail()), (Seq<Object>)((Seq)cotes.head()), piezo.idStation(), 0, needUpdateNGF, needUpdateLandmarks, typeId, roundValue, c);
            if (needUpdateNGF) {
                this.PiezometryEventDao.addTechnicalEvent(piezo.idStation(), new StringBuilder(58).append("Recalcul des NGF effectu\u00e9 le ").append(DateUtil$.MODULE$.getDateWithHour(new DateTime())).append(" par ").append(user).append(". ").append(updated).append(" ont \u00e9t\u00e9 mises \u00e0 jour.").toString(), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                return;
            }
            return;
        }
    }

    private int applyCorrectNGF(Seq<Seq<Object>> cotes, Seq<Object> previousLandmark, int stationId, int count, boolean needUpdateNGF, boolean needUpdateLandmarks, int typeId, int roundValue, Connection c) {
        List list;
        while (true) {
            int n;
            int resNGF;
            int n2;
            SeqOps seqOps;
            if (Nil$.MODULE$.equals(list = cotes)) {
                int n3;
                int resNGF2;
                int n4;
                SeqOps seqOps2;
                Seq seq = previousLandmark;
                if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 4) != 0) {
                    throw new MatchError(seq);
                }
                double startDateLong = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0));
                double cote = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1));
                double landmark = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2));
                double alti = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3));
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)startDateLong), (Object)BoxesRunTime.boxToDouble((double)cote), (Object)BoxesRunTime.boxToDouble((double)landmark), (Object)BoxesRunTime.boxToDouble((double)alti));
                double startDateLong2 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double cote2 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double landmark2 = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double alti2 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                Date start = new DateTime((long)startDateLong2).toDate();
                Date end = new DateTime().toDate();
                if (needUpdateNGF) {
                    ParameterValue[] parameterValueArray = new ParameterValue[6];
                    ToStatementPriority0.doubleToStatement$ x$3 = ToStatement$.MODULE$.doubleToStatement();
                    Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)cote2), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                    ToStatementPriority0.intToStatement$ x$7 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
                    ToStatementPriority0.dateToStatement$ x$11 = ToStatement$.MODULE$.dateToStatement();
                    Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)start, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
                    ToStatementPriority0.dateToStatement$ x$15 = ToStatement$.MODULE$.dateToStatement();
                    Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)end, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
                    ToStatementPriority0.intToStatement$ x$19 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
                    ToStatementPriority0.intToStatement$ x$23 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$23));
                    package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                     UPDATE chroniques_brutes set valeurngf = round((", " - valeurmesure)::numeric, ", ") where datemesure >= ", " and datemesure < ", " and codepiezometre = ", " and typeid = ", " and cotechronique != 1\n                   "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
                    ParameterValue[] parameterValueArray2 = new ParameterValue[6];
                    ToStatementPriority0.doubleToStatement$ x$27 = ToStatement$.MODULE$.doubleToStatement();
                    Null$ x$28 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray2[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)cote2), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$27));
                    ToStatementPriority0.intToStatement$ x$31 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$32 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray2[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$31));
                    ToStatementPriority0.dateToStatement$ x$35 = ToStatement$.MODULE$.dateToStatement();
                    Null$ x$36 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray2[2] = ParameterValue$.MODULE$.from((Object)start, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$35));
                    ToStatementPriority0.dateToStatement$ x$39 = ToStatement$.MODULE$.dateToStatement();
                    Null$ x$40 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray2[3] = ParameterValue$.MODULE$.from((Object)end, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$39));
                    ToStatementPriority0.intToStatement$ x$43 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$44 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray2[4] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$43));
                    ToStatementPriority0.intToStatement$ x$47 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$48 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray2[5] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$47));
                    n4 = package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                          UPDATE chroniques_brutes set valeurngfcorrigee = round((", " - valeurmesurecorrigee)::numeric, ", ") where valeurngfcorrigee is not null and datemesure >= ", " and datemesure < ", " and codepiezometre = ", " and typeid = ", " and cotechronique != 1\n                "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray2)).executeUpdate(c);
                } else {
                    n4 = resNGF2 = 0;
                }
                if (needUpdateLandmarks) {
                    ParameterValue[] parameterValueArray = new ParameterValue[8];
                    ToStatementPriority0.doubleToStatement$ x$51 = ToStatement$.MODULE$.doubleToStatement();
                    Null$ x$52 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)alti2), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$51));
                    ToStatementPriority0.intToStatement$ x$55 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$56 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$55));
                    ToStatementPriority0.doubleToStatement$ x$59 = ToStatement$.MODULE$.doubleToStatement();
                    Null$ x$60 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)landmark2), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$59));
                    ToStatementPriority0.intToStatement$ x$63 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$64 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$63));
                    ToStatementPriority0.dateToStatement$ x$67 = ToStatement$.MODULE$.dateToStatement();
                    Null$ x$68 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)start, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$67));
                    ToStatementPriority0.dateToStatement$ x$71 = ToStatement$.MODULE$.dateToStatement();
                    Null$ x$72 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)end, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$71));
                    ToStatementPriority0.intToStatement$ x$75 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$76 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[6] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$75));
                    ToStatementPriority0.intToStatement$ x$79 = ToStatement$.MODULE$.intToStatement();
                    Null$ x$80 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[7] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$79));
                    n3 = package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 UPDATE chroniques_brutes set referencealtimetrique = round((", ")::numeric, ", "), repere = round((", ")::numeric, ", ") where datemesure >= ", " and datemesure < ", " and codepiezometre = ", " and typeid = ", "\n               "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
                } else {
                    n3 = 0;
                }
                int resLandmarks = n3;
                return (resNGF2 > 0 ? resNGF2 : resLandmarks) + count;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            Seq head = (Seq)colon2.head();
            List tail = colon2.next$access$1();
            Seq seq = previousLandmark;
            if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) != 0) {
                throw new MatchError(seq);
            }
            double startDateLong = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
            double cote = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1));
            double landmark = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2));
            double alti = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3));
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)startDateLong), (Object)BoxesRunTime.boxToDouble((double)cote), (Object)BoxesRunTime.boxToDouble((double)landmark), (Object)BoxesRunTime.boxToDouble((double)alti));
            double startDateLong3 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double cote3 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double landmark3 = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double alti3 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            Date start = new DateTime((long)startDateLong3).toDate();
            Date end = new DateTime((long)BoxesRunTime.unboxToDouble((Object)head.head())).toDate();
            if (needUpdateNGF) {
                ParameterValue[] parameterValueArray = new ParameterValue[6];
                ToStatementPriority0.doubleToStatement$ x$83 = ToStatement$.MODULE$.doubleToStatement();
                Null$ x$84 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)cote3), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$83));
                ToStatementPriority0.intToStatement$ x$87 = ToStatement$.MODULE$.intToStatement();
                Null$ x$88 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$87));
                ToStatementPriority0.dateToStatement$ x$91 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$92 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)start, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$91));
                ToStatementPriority0.dateToStatement$ x$95 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$96 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)end, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$95));
                ToStatementPriority0.intToStatement$ x$99 = ToStatement$.MODULE$.intToStatement();
                Null$ x$100 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$99));
                ToStatementPriority0.intToStatement$ x$103 = ToStatement$.MODULE$.intToStatement();
                Null$ x$104 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$103));
                package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                     UPDATE chroniques_brutes set valeurngf = round((", " - valeurmesure)::numeric, ", ") where datemesure >= ", " and datemesure < ", " and codepiezometre = ", " and typeid = ", " and cotechronique != 1\n                   "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
                ParameterValue[] parameterValueArray3 = new ParameterValue[6];
                ToStatementPriority0.doubleToStatement$ x$107 = ToStatement$.MODULE$.doubleToStatement();
                Null$ x$108 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray3[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)cote3), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$107));
                ToStatementPriority0.intToStatement$ x$111 = ToStatement$.MODULE$.intToStatement();
                Null$ x$112 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray3[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$111));
                ToStatementPriority0.dateToStatement$ x$115 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$116 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray3[2] = ParameterValue$.MODULE$.from((Object)start, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$115));
                ToStatementPriority0.dateToStatement$ x$119 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$120 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray3[3] = ParameterValue$.MODULE$.from((Object)end, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$119));
                ToStatementPriority0.intToStatement$ x$123 = ToStatement$.MODULE$.intToStatement();
                Null$ x$124 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray3[4] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$123));
                ToStatementPriority0.intToStatement$ x$127 = ToStatement$.MODULE$.intToStatement();
                Null$ x$128 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray3[5] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$127));
                n2 = package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                          UPDATE chroniques_brutes set valeurngfcorrigee = round((", " - valeurmesurecorrigee)::numeric, ", ") where valeurngfcorrigee is not null and datemesure >= ", " and datemesure < ", " and codepiezometre = ", " and typeid = ", " and cotechronique != 1\n                "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray3)).executeUpdate(c);
            } else {
                n2 = resNGF = 0;
            }
            if (needUpdateLandmarks) {
                ParameterValue[] parameterValueArray = new ParameterValue[8];
                ToStatementPriority0.doubleToStatement$ x$131 = ToStatement$.MODULE$.doubleToStatement();
                Null$ x$132 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)alti3), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$131));
                ToStatementPriority0.intToStatement$ x$135 = ToStatement$.MODULE$.intToStatement();
                Null$ x$136 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$135));
                ToStatementPriority0.doubleToStatement$ x$139 = ToStatement$.MODULE$.doubleToStatement();
                Null$ x$140 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToDouble((double)landmark3), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$139));
                ToStatementPriority0.intToStatement$ x$143 = ToStatement$.MODULE$.intToStatement();
                Null$ x$144 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)roundValue), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$143));
                ToStatementPriority0.dateToStatement$ x$147 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$148 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[4] = ParameterValue$.MODULE$.from((Object)start, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$147));
                ToStatementPriority0.dateToStatement$ x$151 = ToStatement$.MODULE$.dateToStatement();
                Null$ x$152 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[5] = ParameterValue$.MODULE$.from((Object)end, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$151));
                ToStatementPriority0.intToStatement$ x$155 = ToStatement$.MODULE$.intToStatement();
                Null$ x$156 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[6] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)stationId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$155));
                ToStatementPriority0.intToStatement$ x$159 = ToStatement$.MODULE$.intToStatement();
                Null$ x$160 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[7] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$159));
                n = package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 UPDATE chroniques_brutes set referencealtimetrique = round((", ")::numeric, ", "), repere = round((", ")::numeric, ", ") where datemesure >= ", " and datemesure < ", " and codepiezometre = ", " and typeid = ", "\n               "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
            } else {
                n = 0;
            }
            int resLandmarks = n;
            count = (resNGF > 0 ? resNGF : resLandmarks) + count;
            previousLandmark = head;
            cotes = tail;
        }
        throw new MatchError(list);
    }

    public static final /* synthetic */ boolean $anonfun$changeLandmark$1(DataType d) {
        return (int)d.id() != -1 && d.monitoringChronicle().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ long $anonfun$changeLandmarkForPiezo$1(PiezometerChronicRawMeasure x$1) {
        return x$1.date().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$changeLandmarkForPiezo$3(PiezometerLinks piezo$2, int roundValue$1, PiezometerChronicRawMeasure m) {
        Some some;
        Tuple2 tuple2;
        if (m.cote().map((Function1)(JFunction1.mcID.sp & Serializable)x$2 -> (int)x$2).contains((Object)BoxesRunTime.boxToInteger((int)1))) {
            return false;
        }
        Option<Tuple2<Landmark, AltimetrySystem>> option = PiezometryUtils$.MODULE$.getMeasureLandmarkAndRefAlti(m, (Seq<Landmark>)((Seq)piezo$2.link_landmarks().get()), (Seq<AltimetrySystem>)((Seq)piezo$2.link_altimetrySystems().get()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            double second;
            Landmark l = (Landmark)tuple2._1();
            AltimetrySystem alt = (AltimetrySystem)tuple2._2();
            double first = MathUtil$.MODULE$.roundAt(roundValue$1, BoxesRunTime.unboxToDouble((Object)l.height().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble((Object)alt.altitude().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) - BoxesRunTime.unboxToDouble((Object)m.initialNGF().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
            if (MathUtil$.MODULE$.isReallyEquals(first, second = MathUtil$.MODULE$.roundAt(roundValue$1, BoxesRunTime.unboxToDouble((Object)m.initialValue().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))))) {
                return false;
            }
            Predef$.MODULE$.println((Object)new StringBuilder(61).append("Different measure found for piezo ").append(piezo$2.idStation()).append(" on : ").append(DateUtil$.MODULE$.getDate(m.date())).append(", fisrt : ").append(first).append(", second : ").append(second).toString());
            return true;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$changeLandmarkForPiezo$9(PiezometerLinks piezo$2, PiezometerChronicRawMeasure m) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<Landmark, AltimetrySystem>> option = PiezometryUtils$.MODULE$.getMeasureLandmarkAndRefAlti(m, (Seq<Landmark>)((Seq)piezo$2.link_landmarks().get()), (Seq<AltimetrySystem>)((Seq)piezo$2.link_altimetrySystems().get()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Landmark l = (Landmark)tuple2._1();
            AltimetrySystem alt = (AltimetrySystem)tuple2._2();
            return !MathUtil$.MODULE$.isReallyEquals(BoxesRunTime.unboxToDouble((Object)m.landmark().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)), BoxesRunTime.unboxToDouble((Object)l.height().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))) || !MathUtil$.MODULE$.isReallyEquals(BoxesRunTime.unboxToDouble((Object)m.refAlti().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)), BoxesRunTime.unboxToDouble((Object)alt.altitude().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ double $anonfun$changeLandmarkForPiezo$22(Seq x$3) {
        return BoxesRunTime.unboxToDouble((Object)x$3.head());
    }

    @Inject
    public PiezometerLandmarkChange(PiezometerMeasureDao PiezometerMeasureDao2, PiezometryEventDao PiezometryEventDao2, DataTypeDao DataTypeDao2) {
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
        this.PiezometryEventDao = PiezometryEventDao2;
        this.DataTypeDao = DataTypeDao2;
    }
}

