/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils;

import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DateUtil$ {
    public static final DateUtil$ MODULE$ = new DateUtil$();
    private static final DateTimeFormatter referencialDateParser = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
    private static final DateTimeFormatter referencialFullDateParser = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").withZoneUTC();
    private static final DateTimeFormatter campaignDateParser = DateTimeFormat.forPattern((String)"dd/MM/YYYY").withZoneUTC();
    private static final Ordering<DateTime> ordering = new Ordering<DateTime>(){
        private final DateTimeComparator dtComparer;

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<DateTime> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$((Ordering)this, other);
        }

        public <U> Ordering<U> on(Function1<U, DateTime> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering<DateTime> orElse(Ordering<DateTime> other) {
            return Ordering.orElse$((Ordering)this, other);
        }

        public <S> Ordering<DateTime> orElseBy(Function1<DateTime, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$((Ordering)this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        private DateTimeComparator dtComparer() {
            return this.dtComparer;
        }

        public int compare(DateTime x, DateTime y) {
            return this.dtComparer().compare((Object)x, (Object)y);
        }
        {
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
            this.dtComparer = DateTimeComparator.getInstance();
        }
    };
    private static final DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    private static final DateTimeFormatter dtfMid = DateTimeFormat.forPattern((String)"dd/MM/yyyyHH:mm");
    private static final DateTimeFormatter dtfFull = DateTimeFormat.forPattern((String)"dd/MM/yyyyHH:mm:ss");
    private static final DateTimeFormatter dtfInv = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
    private static final DateTimeFormatter dtfInvMid = DateTimeFormat.forPattern((String)"yyyy/MM/ddHH:mm");
    private static final DateTimeFormatter dtfInvFull = DateTimeFormat.forPattern((String)"yyyy/MM/ddHH:mm:ss");

    public DateTimeFormatter formatter(String format) {
        return DateTimeFormat.forPattern((String)format);
    }

    public Option<DateTime> fromString(String format, String date) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.formatter(format).parseDateTime(date)).toOption();
    }

    public String format(String format, DateTime date) {
        return this.formatter(format).print((ReadableInstant)date);
    }

    public DateTimeFormatter referencialDateParser() {
        return referencialDateParser;
    }

    public DateTimeFormatter referencialFullDateParser() {
        return referencialFullDateParser;
    }

    public DateTimeFormatter campaignDateParser() {
        return campaignDateParser;
    }

    public Option<DateTime> formatDate(Option<String> entry) {
        Option<String> option = entry;
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.referencialDateParser().parseDateTime(value)).toOption();
        }
        return None$.MODULE$;
    }

    public Option<DateTime> formatFullDate(Option<String> entry) {
        Option<String> option = entry;
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return new Some((Object)this.referencialFullDateParser().parseDateTime(value));
        }
        return None$.MODULE$;
    }

    public Option<DateTime> formatCampaignDate(Option<String> entry) {
        boolean bl = false;
        Some some = null;
        Option<String> option = entry;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string = (String)some.value();
            if ("".equals(string)) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            String value = (String)some.value();
            return new Some((Object)this.campaignDateParser().parseDateTime(value));
        }
        return None$.MODULE$;
    }

    public int weekNb(DateTime d) {
        return (int)Math.ceil(d.dayOfYear().get() / 7);
    }

    public String getDate(DateTime dateTime) {
        return dateTime.toString("dd/MM/YYYY");
    }

    public String getDate(Option<DateTime> dateTime) {
        return (String)dateTime.map((Function1 & Serializable)d -> d.toString("dd/MM/YYYY")).getOrElse((Function0 & Serializable)() -> "");
    }

    public String getDateWithHour(DateTime dateTime) {
        return dateTime.toString("dd/MM/YYYY HH:mm:ss");
    }

    public String getDateWithHourMini(DateTime dateTime) {
        return dateTime.toString("dd/MM/YYYY HH:mm");
    }

    public String getDateWithHour(Option<DateTime> dateTime) {
        return (String)dateTime.map((Function1 & Serializable)d -> d.toString("dd/MM/YYYY HH:mm:ss")).getOrElse((Function0 & Serializable)() -> "");
    }

    public String getDateRequest(DateTime date, DateTime hour, String dateKey, String hourKey) {
        return new StringBuilder(167).append(" extract(YEAR from ").append(dateKey).append(") = ").append(Integer.toString(date.year().get())).append(" and ").append(" extract(MONTH from ").append(dateKey).append(") = ").append(Integer.toString(date.monthOfYear().get())).append(" and ").append(" extract(DAY from ").append(dateKey).append(") = ").append(Integer.toString(date.dayOfMonth().get())).append(" and ").append(" extract(HOUR from ").append(hourKey).append(") = ").append(Integer.toString(hour.hourOfDay().get())).append(" and ").append(" extract(MINUTE from ").append(hourKey).append(") = ").append(Integer.toString(hour.minuteOfHour().get())).append(" and ").append(" extract(SECOND from ").append(hourKey).append(") = ").append(Integer.toString(hour.secondOfMinute().get())).toString();
    }

    public String getDateRequest$default$3() {
        return "datecreation";
    }

    public String getDateRequest$default$4() {
        return "heure";
    }

    public String getPostgreDate(DateTime date) {
        return new StringBuilder(2).append("'").append(date.toString("YYYY-MM-dd HH:mm:ss")).append("'").toString();
    }

    public String getPostgreDay(DateTime date) {
        return new StringBuilder(2).append("'").append(date.toString("YYYY-MM-dd")).append("'").toString();
    }

    public Option<DateTime> getFullDate(Option<DateTime> dateOpt, Option<DateTime> hourOpt) {
        Option<DateTime> option = dateOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            DateTime date = (DateTime)some.value();
            Option<DateTime> option2 = hourOpt;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                DateTime hour = (DateTime)some2.value();
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new DateTime((Object)date).withHourOfDay(hour.hourOfDay().get()).withMinuteOfHour(hour.minuteOfHour().get()).withSecondOfMinute(hour.secondOfMinute().get()).withMillisOfSecond(hour.millisOfSecond().get()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    DateTime newDate = (DateTime)success.value();
                    return new Some((Object)newDate);
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    if (exception.getMessage().contains("Illegal instant due to time zone offset transition")) {
                        return new Some((Object)new DateTime((Object)date));
                    }
                    throw exception;
                }
                throw new MatchError((Object)try_);
            }
            if (None$.MODULE$.equals(option2)) {
                return new Some((Object)date);
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public DateTime setMinDay(DateTime date) {
        return date.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0);
    }

    public DateTime setMaxDay(DateTime date) {
        return date.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59);
    }

    public DateTime setMaxDayOfMonth(DateTime date) {
        return date.plusMonths(1).withDayOfMonth(1).minusDays(1);
    }

    public Ordering<DateTime> ordering() {
        return ordering;
    }

    public String correctDateFormat(String dateFormat) {
        return dateFormat.replace("DD", "dd").replace("JJ", "dd").replace("jj", "dd").replace("hh", "HH").replace("aa", "YY").replace("AA", "YY");
    }

    public DateTimeFormatter dtf() {
        return dtf;
    }

    public DateTimeFormatter dtfMid() {
        return dtfMid;
    }

    public DateTimeFormatter dtfFull() {
        return dtfFull;
    }

    public DateTimeFormatter dtfInv() {
        return dtfInv;
    }

    public DateTimeFormatter dtfInvMid() {
        return dtfInvMid;
    }

    public DateTimeFormatter dtfInvFull() {
        return dtfInvFull;
    }

    public DateTime parseWithDTF(String date) {
        String dt = date.replace(" ", "").replace("-", "/");
        if (StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(dt), 4).contains("/")) {
            int n = dt.length();
            switch (n) {
                case 18: {
                    return this.dtfFull().parseDateTime(dt);
                }
                case 15: {
                    return this.dtfMid().parseDateTime(dt);
                }
            }
            return this.dtf().parseDateTime(dt);
        }
        int n = dt.length();
        switch (n) {
            case 18: {
                return this.dtfInvFull().parseDateTime(dt);
            }
            case 15: {
                return this.dtfInvMid().parseDateTime(dt);
            }
        }
        return this.dtfInv().parseDateTime(dt);
    }

    public String formatTimestamp(DateTime date) {
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
        return format.print((ReadableInstant)date);
    }

    private DateUtil$() {
    }
}

