/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils;

import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.charset.MalformedInputException;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.sys.package$;
import scala.sys.process.Process$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileUtil$ {
    public static final FileUtil$ MODULE$ = new FileUtil$();
    private static final String FORBIDDEN_CHARS = "[<>:\"/\\\\|?*\\x00-\\x1F]";
    private static final Pattern FORBIDDEN_PATTERN = Pattern.compile(MODULE$.FORBIDDEN_CHARS());

    public String toPath(String path) {
        return new StringBuilder(2).append("/").append(path).append("/").toString().replace("///", "/").replace("//", "/");
    }

    public String toUrl(String url) {
        return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(this.toPath(url)), 1)), 1).replace("https:/", "https://").replace("http:/", "http://");
    }

    public void createFileDirs(String path, String filePath) {
        block4: {
            List list;
            while (true) {
                boolean bl = false;
                .colon.colon colon2 = null;
                list = Predef$.MODULE$.wrapRefArray((Object[])filePath.split("/", 100)).toList();
                if (Nil$.MODULE$.equals(list)) {
                    break block4;
                }
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        break block4;
                    }
                }
                if (!bl) break;
                String head = (String)colon2.head();
                List tail = colon2.next$access$1();
                this.createDir(new StringBuilder(0).append(this.toPath(path)).append(head).toString());
                filePath = tail.mkString("/");
                path = this.toPath(new StringBuilder(0).append(this.toPath(path)).append(head).toString());
            }
            throw new MatchError((Object)list);
        }
    }

    public void createDir(String dirPathWithName) {
        File file = new File(dirPathWithName);
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new Exception(new StringBuilder(29).append("Unable to create directory : ").append(dirPathWithName).toString());
            }
            file.setReadable(true);
            file.setWritable(true);
            file.setExecutable(true);
            return;
        }
    }

    public BufferedSource readFileSource(String filePathWithName) {
        return this.readFileSourceRec(filePathWithName, (List<String>)new .colon.colon((Object)"UTF-8", (List)new .colon.colon((Object)"Cp1252", (List)new .colon.colon((Object)"ISO-8859-1", (List)new .colon.colon((Object)"ISO-8859-15", (List)Nil$.MODULE$)))));
    }

    public byte[] readFileToByteArray(String filePath) {
        File file = new File(filePath);
        FileInputStream fl = new FileInputStream(file);
        byte[] arr = new byte[(int)file.length()];
        fl.read(arr);
        fl.close();
        return arr;
    }

    public BufferedSource readFileSourceRec(String filePathWithName, List<String> encodings) {
        List list;
        block4: {
            Throwable e;
            Try try_;
            Failure failure;
            boolean bl;
            String head;
            while (true) {
                if (Nil$.MODULE$.equals(list = encodings)) {
                    throw new Exception("File encoding not supported");
                }
                if (!(list instanceof .colon.colon)) break block4;
                .colon.colon colon2 = (.colon.colon)list;
                head = (String)colon2.head();
                List tail = colon2.next$access$1();
                bl = false;
                failure = null;
                try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    BufferedSource source = Source$.MODULE$.fromFile(filePathWithName, head);
                    Option res = source.getLines().toList().headOption();
                    source.close();
                    return res;
                });
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                if (!(failure.exception() instanceof MalformedInputException)) break;
                encodings = tail;
            }
            if (bl && (e = failure.exception()) != null) {
                Throwable throwable = e;
                throw throwable;
            }
            if (try_ instanceof Success) {
                return Source$.MODULE$.fromFile(filePathWithName, head);
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError(list);
    }

    public String readBase64(String base64Str) {
        return Source$.MODULE$.fromBytes(Base64.decodeBase64((String)base64Str), Codec$.MODULE$.fallbackSystemCodec()).getLines().toSeq().mkString("\n");
    }

    public void writeFile(String filePathWithName, String s) {
        File file = new File(filePathWithName);
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(s);
        bw.close();
    }

    public String readFile(String filePathWithName) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Source$.MODULE$.fromFile(filePathWithName, Codec$.MODULE$.fallbackSystemCodec()).getLines().toSeq().mkString("\n"));
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof MalformedInputException) {
                throw new Exception(new StringBuilder(50).append("Probl\u00e8me d'encodage pendant la lecture du fichier ").append(filePathWithName).toString());
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw new Exception(new StringBuilder(37).append("Erreur pendant la lecture du fichier ").append(filePathWithName).toString(), e);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String result = (String)success.value();
            return result;
        }
        throw new MatchError((Object)try_);
    }

    public Seq<String> readFileLines(String filePathWithName) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Source$.MODULE$.fromFile(filePathWithName, Codec$.MODULE$.fallbackSystemCodec()).getLines().toSeq());
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof MalformedInputException) {
                throw new Exception(new StringBuilder(50).append("Probl\u00e8me d'encodage pendant la lecture du fichier ").append(filePathWithName).toString());
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw new Exception(new StringBuilder(37).append("Erreur pendant la lecture du fichier ").append(filePathWithName).toString(), e);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq result = (Seq)success.value();
            return result;
        }
        throw new MatchError((Object)try_);
    }

    public void rmFiles(String path) {
        String rm_cmd;
        String string = rm_cmd = this.isWindowsMode() ? "rd /s /q " : "rm -rf ";
        if (new File(path).exists()) {
            int processResult = Process$.MODULE$.apply(new StringBuilder(0).append(rm_cmd).append(path).toString()).$bang();
            if (processResult != 0) {
                throw new Exception(new StringBuilder(25).append("Unable to delete files : ").append(path).toString());
            }
            return;
        }
    }

    public void copyFile(String srcPathWithName, String destPathWithName) {
        File src = new File(srcPathWithName);
        File dest = new File(destPathWithName);
        new FileOutputStream(dest).getChannel().transferFrom(new FileInputStream(src).getChannel(), 0L, Long.MAX_VALUE);
    }

    public boolean isWindowsMode() {
        Some some;
        String string;
        Option option = package$.MODULE$.env().get((Object)"WINDOWS_MODE");
        return option instanceof Some && "true".equals(string = (String)(some = (Some)option).value());
    }

    public void runCMD(String cmd, LogUtil logUtil) {
        int processResult = Process$.MODULE$.apply(cmd).$bang();
        if (processResult != 0) {
            logUtil.error(new StringBuilder(40).append("Process finished with error exit code : ").append(cmd).toString(), logUtil.error$default$2());
            String output = Process$.MODULE$.apply(cmd).$bang$bang();
            logUtil.error(new StringBuilder(8).append("Error : ").append(output).toString(), logUtil.error$default$2());
            throw new Exception(new StringBuilder(40).append("Process finished with error exit code : ").append(cmd).toString());
        }
    }

    public String runCMDInScript(String dirPath, Seq<String> cmd, LogUtil logUtil) {
        if (!new File(dirPath).exists()) {
            throw new Exception(new StringBuilder(16).append(dirPath).append(" does not exists").toString());
        }
        new File(new StringBuilder(9).append(dirPath).append("script.sh").toString()).createNewFile();
        new File(new StringBuilder(9).append(dirPath).append("script.sh").toString()).setExecutable(true);
        new File(new StringBuilder(9).append(dirPath).append("script.sh").toString()).setWritable(true);
        String lines = new StringBuilder(17).append("#!/bin/bash\n\ncd ").append(dirPath).append("\n").append(cmd.mkString("\n")).toString();
        this.writeFile(new StringBuilder(9).append(dirPath).append("script.sh").toString(), lines);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Process$.MODULE$.apply(new StringBuilder(9).append(dirPath).append("script.sh").toString()).$bang$bang());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            e.printStackTrace();
            logUtil.printError(e);
            throw new Exception(new StringBuilder(32).append("Error while executing command : ").append(cmd.head()).toString());
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String result = (String)success.value();
            this.rmFiles(new StringBuilder(9).append(dirPath).append("script.sh").toString());
            return result;
        }
        throw new MatchError((Object)try_);
    }

    private String FORBIDDEN_CHARS() {
        return FORBIDDEN_CHARS;
    }

    private Pattern FORBIDDEN_PATTERN() {
        return FORBIDDEN_PATTERN;
    }

    private String extractExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            return filename.substring(lastDot);
        }
        return "";
    }

    public String sanitizeFileName(String filename, String replacement, int maxLength) {
        String sanitized;
        block1: {
            sanitized = filename.trim();
            sanitized = this.FORBIDDEN_PATTERN().matcher(sanitized).replaceAll(replacement);
            if ((sanitized = sanitized.replaceAll("^[.\\s]+|[.\\s]+$", "")).length() > maxLength) {
                String extension = this.extractExtension(sanitized);
                String nameOnly = sanitized.substring(0, sanitized.length() - extension.length());
                int maxNameLength = maxLength - extension.length();
                sanitized = new StringBuilder(0).append(nameOnly.substring(0, Math.min(nameOnly.length(), maxNameLength))).append(extension).toString();
            }
            if (!sanitized.isEmpty()) break block1;
            sanitized = "untitled";
        }
        return sanitized;
    }

    public String sanitizeFileName$default$2() {
        return "_";
    }

    public int sanitizeFileName$default$3() {
        return 255;
    }

    private FileUtil$() {
    }
}

