/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils.readFileUtil;

import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.readFileUtil.FileData;
import fr.aquasys.utils.readFileUtil.FileData$;
import fr.aquasys.utils.readFileUtil.ReadFileParams;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Source;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005A4AAB\u0004\u0001!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011\u0015)\u0003\u0001\"\u0001'\u0011\u0015!\u0004\u0001\"\u00016\u0011\u00159\u0007\u0001\"\u0001i\u0005\u001d\u0011V-\u00193D'ZS!\u0001C\u0005\u0002\u0019I,\u0017\r\u001a$jY\u0016,F/\u001b7\u000b\u0005)Y\u0011!B;uS2\u001c(B\u0001\u0007\u000e\u0003\u001d\t\u0017/^1tsNT\u0011AD\u0001\u0003MJ\u001c\u0001a\u0005\u0002\u0001#A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\fq\u0001\\8h+RLG\u000e\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005!Q\u000f^5m\u0015\ti2\"\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0013\ty\"DA\u0004M_\u001e,F/\u001b7\u0002\u0015){'\rT8h+RLG\u000e\u0005\u0002#G5\t\u0011\"\u0003\u0002%\u0013\tQ!j\u001c2M_\u001e,F/\u001b7\u0002\rqJg.\u001b;?)\r9\u0013F\u000b\t\u0003Q\u0001i\u0011a\u0002\u0005\u0006/\r\u0001\r\u0001\u0007\u0005\u0006A\r\u0001\r!\t\u0015\u0003\u00071\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\r%t'.Z2u\u0015\u0005\t\u0014!\u00026bm\u0006D\u0018BA\u001a/\u0005\u0019IeN[3di\u00069!/Z1e\u0007N3FC\u0002\u001cG\u001dbkv\fE\u00028\u007f\ts!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005mz\u0011A\u0002\u001fs_>$h(C\u0001\u0015\u0013\tq4#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%aA*fc*\u0011ah\u0005\t\u0004o}\u001a\u0005C\u0001\u0015E\u0013\t)uA\u0001\u0005GS2,G)\u0019;b\u0011\u00159E\u00011\u0001I\u00039\u0011WO\u001a4fe\u0016$7k\\;sG\u0016\u0004\"!\u0013'\u000e\u0003)S!aS\n\u0002\u0005%|\u0017BA'K\u0005\u0019\u0019v.\u001e:dK\")q\n\u0002a\u0001!\u0006Aa-\u001b7f\u001d\u0006lW\r\u0005\u0002R+:\u0011!k\u0015\t\u0003sMI!\u0001V\n\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)NAQ!\u0017\u0003A\u0002i\u000ba\u0001]1sC6\u001c\bC\u0001\u0015\\\u0013\tavA\u0001\bSK\u0006$g)\u001b7f!\u0006\u0014\u0018-\\:\t\u000by#\u0001\u0019\u0001)\u0002\u0017M$\u0018\r^5p]\u000e{G-\u001a\u0005\u0006A\u0012\u0001\r!Y\u0001\u000fU>\u0014W\t_3dkRLwN\\%e!\r\u0011\"\rZ\u0005\u0003GN\u0011aa\u00149uS>t\u0007C\u0001\nf\u0013\t17C\u0001\u0003M_:<\u0017\u0001D:fa\u0006\u0014\u0018\r^3MS:,GcA5m]B\u0019!C\u001b)\n\u0005-\u001c\"!B!se\u0006L\b\"B7\u0006\u0001\u0004\u0001\u0016\u0001\u00027j]\u0016DQa\\\u0003A\u0002i\u000bqAZ5mi\u0016\u00148\u000f")
public class ReadCSV {
    private final LogUtil logUtil;
    private final JobLogUtil JobLogUtil;

    public Seq<Seq<FileData>> readCSV(Source bufferedSource, String fileName, ReadFileParams params, String stationCode, Option<Object> jobExecutionId) {
        String dateFormat = ((String)params.dateFormat().getOrElse((Function0 & Serializable)() -> "dd/MM/YYYY")).trim();
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)DateUtil$.MODULE$.correctDateFormat(dateFormat));
        jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.START_DATA(), new StringBuilder(27).append("Begin integration of file: ").append(fileName).toString(), stationCode, fileName));
        int entete = params.hasHeader().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? BoxesRunTime.unboxToInt((Object)params.nbHeaders().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) : 0;
        jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.INFO(), new StringBuilder(12).append("skip ").append(entete).append("  line ").toString(), stationCode, fileName));
        int nbcolMax = BoxesRunTime.unboxToInt((Object)params.nbCols().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 30));
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq data = (Seq)((SeqOps)bufferedSource.getLines().drop(entete).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(acc, line) -> {
                String[] csvLine = this.separateLine((String)line, params);
                if (csvLine.length > 0) {
                    if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])csvLine), (Object)"&ERROR&")) {
                        jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.ERROR(), new StringBuilder(60).append("Error during file reading : ").append(fileName).append(", error : check error flag found").toString(), stationCode, fileName));
                    }
                    IndexedSeq indexedSeq = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nbcolMax).map((Function1 & Serializable)col -> ReadCSV.$anonfun$readCSV$9(csvLine, dtf, dateFormat, BoxesRunTime.unboxToInt((Object)col)));
                    return (Seq)acc.$plus$colon((Object)indexedSeq);
                }
                return acc;
            })).reverse();
            bufferedSource.close();
            return data;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq res = (Seq)success.value();
            return res;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable interupted = failure.exception();
            if (interupted instanceof InterruptedException) {
                InterruptedException interruptedException = (InterruptedException)interupted;
                throw interruptedException;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.ERROR(), new StringBuilder(38).append("Error during file reading : ").append(fileName).append(", error : ").append(err.getMessage()).toString(), stationCode, fileName));
            this.logUtil.error(new StringBuilder(38).append("Error during file reading : ").append(fileName).append(", error : ").append(err.getMessage()).toString(), this.logUtil.error$default$2());
            this.logUtil.printError(err);
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)Nil$.MODULE$;
    }

    public String[] separateLine(String line, ReadFileParams filters) {
        String[] split1 = BoxesRunTime.unboxToBoolean((Object)filters.commaSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? line.split(",", 10000) : (String[])((Object[])new String[]{line});
        String[] split2 = BoxesRunTime.unboxToBoolean((Object)filters.semicolonSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split1), (Function1 & Serializable)s -> s.split(";", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split1;
        String[] split3 = BoxesRunTime.unboxToBoolean((Object)filters.tabulationSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split2), (Function1 & Serializable)s -> s.split("\t", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split2;
        String[] split4 = BoxesRunTime.unboxToBoolean((Object)filters.spaceSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split3), (Function1 & Serializable)s -> s.split(" ", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split3;
        String[] split5 = filters.customSeparator().isDefined() ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split4), (Function1 & Serializable)s -> s.split(((String)filters.customSeparator().get()).replace("|", "\\|"), 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split4;
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])split5), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ FileData $anonfun$readCSV$9(String[] csvLine$1, DateTimeFormatter dtf$1, String dateFormat$1, int col) {
        return (FileData)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String stringValue = csvLine$1[col];
            Option dateValueFormat = StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(stringValue)) > 10 ? (Try$.MODULE$.apply((Function0 & Serializable)() -> DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss").parseDateTime(stringValue)).isSuccess() ? Try$.MODULE$.apply((Function0 & Serializable)() -> DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss").parseDateTime(stringValue)).toOption() : Try$.MODULE$.apply((Function0 & Serializable)() -> dtf$1.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(stringValue), dateFormat$1.length()))).toOption()) : Try$.MODULE$.apply((Function0 & Serializable)() -> dtf$1.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(stringValue), dateFormat$1.length()))).toOption();
            return new FileData((Option<String>)new Some((Object)stringValue), (Option<DateTime>)dateValueFormat, (Option<Object>)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue))).toOption());
        }).toOption().getOrElse((Function0 & Serializable)() -> new FileData(FileData$.MODULE$.$lessinit$greater$default$1(), FileData$.MODULE$.$lessinit$greater$default$2(), FileData$.MODULE$.$lessinit$greater$default$3()));
    }

    @Inject
    public ReadCSV(LogUtil logUtil, JobLogUtil JobLogUtil2) {
        this.logUtil = logUtil;
        this.JobLogUtil = JobLogUtil2;
    }
}

