/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils.readFileUtil;

import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.readFileUtil.FileData;
import fr.aquasys.utils.readFileUtil.FileData$;
import fr.aquasys.utils.readFileUtil.ReadFileParams;
import fr.aquasys.utils.readFileUtil.ReadOldXls;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\u0006\f\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u0003>\u0001\u0011\u0005a\bC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u00111\u000b\u0001\u0005\u0002\u0005U#a\u0002*fC\u0012DFn\u001d\u0006\u0003\u00195\tAB]3bI\u001aKG.Z+uS2T!AD\b\u0002\u000bU$\u0018\u000e\\:\u000b\u0005A\t\u0012aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002%\u0005\u0011aM]\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003vi&d'BA\u0011\u0010\u0003!\u0011\u0018M\u00192ji6\f\u0018BA\u0012\u001f\u0005\u001daunZ+uS2\f!BS8c\u0019><W\u000b^5m!\t1s%D\u0001\u000e\u0013\tASB\u0001\u0006K_\ndunZ+uS2\f!BU3bI>cG\r\u00177t!\tYC&D\u0001\f\u0013\ti3B\u0001\u0006SK\u0006$w\n\u001c3YYN\fa\u0001P5oSRtD\u0003\u0002\u00192eM\u0002\"a\u000b\u0001\t\u000bm!\u0001\u0019\u0001\u000f\t\u000b\u0011\"\u0001\u0019A\u0013\t\u000b%\"\u0001\u0019\u0001\u0016)\u0005\u0011)\u0004C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0019IgN[3di*\t!(A\u0003kCZ\f\u00070\u0003\u0002=o\t1\u0011J\u001c6fGR\fAbZ3u/>|'o\u001b2p_.$2aP'[!\t\u00015*D\u0001B\u0015\t\u00115)A\u0005vg\u0016\u0014Xn\u001c3fY*\u0011A)R\u0001\u0003gNT!AR$\u0002\u0007A|\u0017N\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'B\u0005!9vN]6c_>\\\u0007\"\u0002(\u0006\u0001\u0004y\u0015\u0001\u00024jY\u0016\u00042A\u0006)S\u0013\t\tvC\u0001\u0004PaRLwN\u001c\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b!![8\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\u0005\r&dW\rC\u0003\\\u000b\u0001\u0007A,\u0001\u0006cCN,g\u0007\u000e#bi\u0006\u00042A\u0006)^!\tqVM\u0004\u0002`GB\u0011\u0001mF\u0007\u0002C*\u0011!mE\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011<\u0012A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z\f\u0002\u000fI,\u0017\r\u001a-mgRa!n^=\u007f\u0003\u0003\ti!!\u0005\u0002\u0014A\u00191\u000e]:\u000f\u00051tgB\u00011n\u0013\u0005A\u0012BA8\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001d:\u0003\u0007M+\u0017O\u0003\u0002p/A\u00191\u000e\u001d;\u0011\u0005-*\u0018B\u0001<\f\u0005!1\u0015\u000e\\3ECR\f\u0007\"\u0002=\u0007\u0001\u0004i\u0016\u0001\u00034jY\u0016t\u0015-\\3\t\u000bi4\u0001\u0019A>\u0002\rA\f'/Y7t!\tYC0\u0003\u0002~\u0017\tq!+Z1e\r&dW\rU1sC6\u001c\b\"B@\u0007\u0001\u0004i\u0016aC:uCRLwN\\\"pI\u0016Dq!a\u0001\u0007\u0001\u0004\t)!\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\tY\u0001\u0016q\u0001\t\u0004-\u0005%\u0011bAA\u0006/\t!Aj\u001c8h\u0011\u0019\tyA\u0002a\u00019\u0006Aa-\u001b7f!\u0006$\b\u000eC\u0003\\\r\u0001\u0007A\fC\u0003O\r\u0001\u0007q*A\bhKR\u001cU\r\u001c7U_N#(/\u001b8h)\ra\u0016\u0011\u0004\u0005\b\u000379\u0001\u0019AA\u000f\u0003\u0005\u0019\u0007c\u0001!\u0002 %\u0019\u0011\u0011E!\u0003\t\r+G\u000e\\\u0001\u000eO\u0016$8)\u001a7m)>$\u0015\r^3\u0015\u0015\u0005\u001d\u0012\u0011HA\u001e\u0003\u0017\ny\u0005\u0005\u0003\u0017!\u0006%\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005i&lWMC\u0002\u00024%\u000bAA[8eC&!\u0011qGA\u0017\u0005!!\u0015\r^3US6,\u0007bBA\u000e\u0011\u0001\u0007\u0011Q\u0004\u0005\b\u0003{A\u0001\u0019AA \u0003\r!GO\u001a\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)!\u0011QIA\u0017\u0003\u00191wN]7bi&!\u0011\u0011JA\"\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\u0007\u0003\u001bB\u0001\u0019A/\u0002\u0015\u0011\fG/\u001a$pe6\fG\u000f\u0003\u0004\u0002R!\u0001\raP\u0001\u0003o\n\f\u0001#^:f\u0007>\u0014(/Z2u\r>\u0014X.\u0019;\u0015\u0011\u0005\u001d\u0012qKA.\u0003;Ba!!\u0017\n\u0001\u0004i\u0016a\u00033bi\u0016$v\u000eU1sg\u0016Da!!\u0014\n\u0001\u0004i\u0006bBA\u001f\u0013\u0001\u0007\u0011q\b")
public class ReadXls {
    private final LogUtil logUtil;
    private final JobLogUtil JobLogUtil;
    private final ReadOldXls ReadOldXls;

    public Workbook getWoorkbook(Option<File> file, Option<String> base64Data) {
        InputStream fis = (InputStream)file.map((Function1 & Serializable)f -> new FileInputStream((File)f)).getOrElse((Function0 & Serializable)() -> new ByteArrayInputStream(Base64.decodeBase64((String)((String)base64Data.get()))));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new XSSFWorkbook(fis));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            XSSFWorkbook wb = (XSSFWorkbook)success.value();
            return wb;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e1 = failure.exception();
            fis.close();
            InputStream fis2 = (InputStream)file.map((Function1 & Serializable)f -> new FileInputStream((File)f)).getOrElse((Function0 & Serializable)() -> new ByteArrayInputStream(Base64.decodeBase64((String)((String)base64Data.get()))));
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> new HSSFWorkbook(fis2));
            if (try_2 instanceof Success) {
                Success success = (Success)try_2;
                HSSFWorkbook wb = (HSSFWorkbook)success.value();
                return wb;
            }
            if (try_2 instanceof Failure) {
                Failure failure2 = (Failure)try_2;
                Throwable e2 = failure2.exception();
                this.logUtil.printError(e1);
                this.logUtil.printError(e2);
                fis2.close();
                throw e2;
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    public Seq<Seq<FileData>> readXls(String fileName, ReadFileParams params, String stationCode, Option<Object> jobExecutionId, Option<String> filePath, Option<String> base64Data, Option<File> file) {
        Seq seq;
        block5: {
            try {
                String dateFormat = ((String)params.dateFormat().getOrElse((Function0 & Serializable)() -> "dd/MM/YYYY")).trim();
                DateTimeFormatter dtf = DateTimeFormat.forPattern((String)DateUtil$.MODULE$.correctDateFormat(dateFormat));
                int nbCols = BoxesRunTime.unboxToInt((Object)params.nbCols().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 30));
                Workbook workbook = this.getWoorkbook(file, base64Data);
                Seq data = (Seq)Nil$.MODULE$;
                int entete = BoxesRunTime.unboxToBoolean((Object)params.hasHeader().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)) ? BoxesRunTime.unboxToInt((Object)params.nbHeaders().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) : 0;
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.INFO(), new StringBuilder(12).append("skip ").append(entete).append("  line ").toString(), stationCode, fileName));
                BooleanRef parsingErrorFound = BooleanRef.create((boolean)false);
                Sheet sheet = params.sheet().isDefined() ? workbook.getSheet((String)params.sheet().get()) : workbook.getSheetAt(0);
                for (Row row : sheet) {
                    IndexedSeq results;
                    if (row.getRowNum() < entete) continue;
                    IndexedSeq indexedSeq = results = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nbCols).map((Function1 & Serializable)col -> ReadXls.$anonfun$readXls$6(this, row, workbook, dtf, dateFormat, parsingErrorFound, jobExecutionId, fileName, stationCode, BoxesRunTime.unboxToInt((Object)col)));
                    data = (Seq)data.$plus$colon((Object)indexedSeq);
                }
                seq = (Seq)data.reverse();
            }
            catch (OldExcelFormatException e) {
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.WARNING(), new StringBuilder(14).append("Old Excel File").append(fileName).append(e.getMessage()).toString(), "", fileName));
                seq = this.ReadOldXls.readOldXls(fileName, params, stationCode, jobExecutionId, base64Data, file);
            }
            catch (Exception err) {
                if (err.getMessage().contains("Extern sheet is part of LinkTable") || err.getMessage().contains("Your file appears not to be a valid OLE2 document")) {
                    jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.WARNING(), new StringBuilder(14).append("Old Excel File").append(fileName).append(err.getMessage()).toString(), "", fileName));
                    Seq<Seq<FileData>> res = this.ReadOldXls.readOldXls(fileName, params, stationCode, jobExecutionId, base64Data, file);
                    seq = res;
                    break block5;
                }
                this.logUtil.error(new StringBuilder(38).append("Error during file reading : ").append(fileName).append(", error : ").append(err.getMessage()).toString(), this.logUtil.error$default$2());
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.ERROR(), new StringBuilder(38).append("Error during file reading : ").append(fileName).append(", error : ").append(err.getMessage()).toString(), stationCode, fileName));
                seq = (Seq)Nil$.MODULE$;
            }
        }
        return seq;
    }

    public Option<String> getCellToString(Cell c) {
        if (c != null) {
            CellType cellType;
            CellType cellType2 = cellType = c.getCellType();
            CellType cellType3 = CellType.STRING;
            if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
                return new Some((Object)c.getStringCellValue().trim());
            }
            CellType cellType4 = cellType;
            CellType cellType5 = CellType.NUMERIC;
            if (!(cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null)) {
                return new Some((Object)Integer.toString((int)c.getNumericCellValue()).trim());
            }
            CellType cellType6 = cellType;
            CellType cellType7 = CellType.BLANK;
            if (!(cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null)) {
                return new Some((Object)"");
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<DateTime> getCellToDate(Cell c, DateTimeFormatter dtf, String dateFormat, Workbook wb) {
        block5: {
            block7: {
                block6: {
                    CellType cellType;
                    if (c == null) break block5;
                    CellType cellType2 = cellType = c.getCellType();
                    CellType cellType3 = CellType.STRING;
                    if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
                        String stringValue = c.getStringCellValue().trim();
                        String string = stringValue.trim();
                        String string2 = "";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return None$.MODULE$;
                        }
                        return this.useCorrectFormat(stringValue, dateFormat, dtf);
                    }
                    CellType cellType4 = cellType;
                    CellType cellType5 = CellType.NUMERIC;
                    if (!(cellType4 == null ? cellType5 != null : !cellType4.equals(cellType5))) break block6;
                    CellType cellType6 = cellType;
                    CellType cellType7 = CellType.FORMULA;
                    if (cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null) break block7;
                }
                return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    CellStyle cellStyle = wb.createCellStyle();
                    CreationHelper createHelper = wb.getCreationHelper();
                    cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(dateFormat));
                    c.setCellStyle(cellStyle);
                    DataFormatter dataFormatter = new DataFormatter();
                    String cellStringValue = dataFormatter.formatCellValue(c).trim();
                    return this.useCorrectFormat(cellStringValue, dateFormat, dtf);
                }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<DateTime> useCorrectFormat(String dateToParse, String dateFormat, DateTimeFormatter dtf) {
        Option tryWithDtf = Try$.MODULE$.apply((Function0 & Serializable)() -> dtf.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(dateToParse), BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{dateFormat.length(), dateToParse.length()})).min((Ordering)Ordering.Int$.MODULE$))))).toOption();
        if (tryWithDtf.isDefined()) {
            return tryWithDtf;
        }
        return Try$.MODULE$.apply((Function0 & Serializable)() -> DateUtil$.MODULE$.parseWithDTF(dateToParse)).toOption();
    }

    public static final /* synthetic */ FileData $anonfun$readXls$6(ReadXls $this, Row row$1, Workbook workbook$1, DateTimeFormatter dtf$1, String dateFormat$1, BooleanRef parsingErrorFound$1, Option jobExecutionId$1, String fileName$1, String stationCode$1, int col) {
        FileData fileData;
        block6: {
            if (row$1.getCell(col) == null) {
                return new FileData(FileData$.MODULE$.$lessinit$greater$default$1(), FileData$.MODULE$.$lessinit$greater$default$2(), FileData$.MODULE$.$lessinit$greater$default$3());
            }
            CellType cellType = row$1.getCell(col).getCellType();
            CellType cellType2 = CellType.BLANK;
            if (!(cellType != null ? !cellType.equals(cellType2) : cellType2 != null)) {
                return new FileData(FileData$.MODULE$.$lessinit$greater$default$1(), FileData$.MODULE$.$lessinit$greater$default$2(), FileData$.MODULE$.$lessinit$greater$default$3());
            }
            try {
                Option dateValueFormat = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.getCellToDate(row$1.getCell(col), DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss"), "dd/MM/yyyy HH:mm:ss", workbook$1)).isSuccess() ? $this.getCellToDate(row$1.getCell(col), DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss"), "dd/MM/yyyy HH:mm:ss", workbook$1) : $this.getCellToDate(row$1.getCell(col), dtf$1, dateFormat$1, workbook$1);
                Option option = dateValueFormat.isDefined() ? dateValueFormat : Try$.MODULE$.apply((Function0 & Serializable)() -> new DateTime((Object)row$1.getCell(col).getDateCellValue())).toOption();
                Option numericValue = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> row$1.getCell(col).getNumericCellValue()).toOption();
                Option stringValue = Try$.MODULE$.apply((Function0 & Serializable)() -> row$1.getCell(col).getStringCellValue().trim()).toOption();
                Object object = numericValue.isEmpty() && stringValue.contains((Object)"") || numericValue.exists((Function1)(JFunction1.mcZD.sp & Serializable)x$1 -> Double.isNaN(x$1)) ? None$.MODULE$ : numericValue;
                fileData = new FileData($this.getCellToString(row$1.getCell(col)), (Option<DateTime>)option, (Option<Object>)object);
            }
            catch (Exception e) {
                if (e != null && e.getMessage() != null && e.getMessage().contains("Illegal instant due to time zone offset transition")) {
                    fileData = new FileData(FileData$.MODULE$.$lessinit$greater$default$1(), FileData$.MODULE$.$lessinit$greater$default$2(), FileData$.MODULE$.$lessinit$greater$default$3());
                    break block6;
                }
                if (e != null && e.getMessage() != null && !parsingErrorFound$1.elem) {
                    jobExecutionId$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> $this.JobLogUtil.log(je, JobState$.MODULE$.ERROR(), new StringBuilder(57).append("Error parsing value data in file ").append(fileName$1).append(" at the line ").append(row$1.getRowNum()).append(" , error : ").append(e.getMessage()).toString(), stationCode$1, fileName$1));
                    parsingErrorFound$1.elem = true;
                }
                fileData = new FileData(FileData$.MODULE$.$lessinit$greater$default$1(), FileData$.MODULE$.$lessinit$greater$default$2(), FileData$.MODULE$.$lessinit$greater$default$3());
            }
        }
        return fileData;
    }

    @Inject
    public ReadXls(LogUtil logUtil, JobLogUtil JobLogUtil2, ReadOldXls ReadOldXls2) {
        this.logUtil = logUtil;
        this.JobLogUtil = JobLogUtil2;
        this.ReadOldXls = ReadOldXls2;
    }
}

