/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csp;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import play.api.mvc.RequestHeader;
import play.api.mvc.request.RequestAttrKey$;
import play.filters.csp.CSPConfig;
import play.filters.csp.CSPDirective;
import play.filters.csp.CSPProcessor;
import play.filters.csp.CSPResult;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005}4A!\u0004\b\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u00042\u0001\t\u0007I\u0011\u0003\u001a\t\ru\u0002\u0001\u0015!\u00034\u0011\u001dq\u0004A1A\u0005\u0012}Baa\u0016\u0001!\u0002\u0013\u0001\u0005b\u0002-\u0001\u0005\u0004%\t\"\u0017\u0005\u00075\u0002\u0001\u000b\u0011B(\t\u000bm\u0003A\u0011\t/\t\u000b5\u0004A\u0011\u00038\t\u000bI\u0004A\u0011C:\t\u000bi\u0004A\u0011C>\u0003'\u0011+g-Y;mi\u000e\u001b\u0006\u000b\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005=\u0001\u0012aA2ta*\u0011\u0011CE\u0001\bM&dG/\u001a:t\u0015\u0005\u0019\u0012\u0001\u00029mCf\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005q\u0011BA\u0010\u000f\u00051\u00195\u000b\u0015)s_\u000e,7o]8s\u0003\u0019\u0019wN\u001c4jOB\u0011QDI\u0005\u0003G9\u0011\u0011bQ*Q\u0007>tg-[4\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u001e\u0001!)\u0001E\u0001a\u0001C!\u0012!!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\na!\u001b8kK\u000e$(\"\u0001\u0018\u0002\u000b)\fg/\u0019=\n\u0005AZ#AB%oU\u0016\u001cG/\u0001\u0007o_:\u001cW\rU1ui\u0016\u0014h.F\u00014!\t!4(D\u00016\u0015\t1t'A\u0003sK\u001e,\u0007P\u0003\u00029s\u0005!Q\u000f^5m\u0015\u0005Q\u0014\u0001\u00026bm\u0006L!\u0001P\u001b\u0003\u000fA\u000bG\u000f^3s]\u0006ian\u001c8dKB\u000bG\u000f^3s]\u0002\nA\u0002[1tQB\u000bG\u000f^3s]N,\u0012\u0001\u0011\t\u0004\u0003&ceB\u0001\"H\u001d\t\u0019e)D\u0001E\u0015\t)E#\u0001\u0004=e>|GOP\u0005\u00023%\u0011\u0001\nG\u0001\ba\u0006\u001c7.Y4f\u0013\tQ5JA\u0002TKFT!\u0001\u0013\r\u0011\t]i5gT\u0005\u0003\u001db\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001)U\u001d\t\t&\u000b\u0005\u0002D1%\u00111\u000bG\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T1\u0005i\u0001.Y:i!\u0006$H/\u001a:og\u0002\nqaY:q\u0019&tW-F\u0001P\u0003!\u00197\u000f\u001d'j]\u0016\u0004\u0013a\u00029s_\u000e,7o\u001d\u000b\u0003;\u000e\u00042a\u00060a\u0013\ty\u0006D\u0001\u0004PaRLwN\u001c\t\u0003;\u0005L!A\u0019\b\u0003\u0013\r\u001b\u0006KU3tk2$\b\"\u00023\n\u0001\u0004)\u0017!\u0004:fcV,7\u000f\u001e%fC\u0012,'\u000f\u0005\u0002gW6\tqM\u0003\u0002iS\u0006\u0019QN^2\u000b\u0005)\u0014\u0012aA1qS&\u0011An\u001a\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\u0002\u0019\u001d,g.\u001a:bi\u0016d\u0015N\\3\u0015\u0005={\u0007\"\u00029\u000b\u0001\u0004\t\u0018!\u00028p]\u000e,\u0007cA\f_\u001f\u0006\u0011r-\u001a8fe\u0006$X\rR5sK\u000e$\u0018N^3t)\tyE\u000fC\u0003v\u0017\u0001\u0007a/\u0001\u0006eSJ,7\r^5wKN\u00042!Q%x!\ti\u00020\u0003\u0002z\u001d\ta1i\u0015)ESJ,7\r^5wK\u0006\u0011s-\u001a8fe\u0006$XmQ8oi\u0016tGoU3dkJLG/\u001f)pY&\u001c\u0017PT8oG\u0016$\"a\u0014?\t\u000bud\u0001\u0019\u0001@\u0002\u00195\f\u0017PY3SKF,Xm\u001d;\u0011\u0007]qV\r")
public class DefaultCSPProcessor
implements CSPProcessor {
    private final CSPConfig config;
    private final Pattern noncePattern;
    private final Seq<Tuple2<Pattern, String>> hashPatterns;
    private final String cspLine;

    public Pattern noncePattern() {
        return this.noncePattern;
    }

    public Seq<Tuple2<Pattern, String>> hashPatterns() {
        return this.hashPatterns;
    }

    public String cspLine() {
        return this.cspLine;
    }

    @Override
    public Option<CSPResult> process(RequestHeader requestHeader) {
        None$ nonce;
        Object object = nonce = this.config.nonce().enabled() ? new Some((Object)this.generateContentSecurityPolicyNonce((Option<RequestHeader>)new Some((Object)requestHeader))) : None$.MODULE$;
        if (BoxesRunTime.unboxToBoolean((Object)this.config.shouldFilterRequest().apply((Object)requestHeader))) {
            return new Some((Object)new CSPResult((Option<String>)nonce, this.generateLine((Option<String>)nonce), this.config.reportOnly(), this.config.nonce().header()));
        }
        return None$.MODULE$;
    }

    public String generateLine(Option<String> nonce) {
        String cspLineWithNonce = (String)nonce.map((Function1 & Serializable)n -> this.noncePattern().matcher(this.cspLine()).replaceAll(Matcher.quoteReplacement("'nonce-" + n + "'"))).getOrElse((Function0 & Serializable)() -> this.cspLine());
        return (String)this.hashPatterns().foldLeft((Object)cspLineWithNonce, (Function2 & Serializable)(line, pair) -> ((Pattern)pair._1()).matcher((CharSequence)line).replaceAll(Matcher.quoteReplacement("'" + pair._2() + "'")));
    }

    public String generateDirectives(Seq<CSPDirective> directives) {
        return ((IterableOnceOps)directives.map((Function1 & Serializable)d -> d.name() + " " + d.value())).mkString("; ");
    }

    public String generateContentSecurityPolicyNonce(Option<RequestHeader> maybeRequest) {
        return (String)maybeRequest.flatMap((Function1 & Serializable)x$1 -> x$1.attrs().get(RequestAttrKey$.MODULE$.CSPNonce())).getOrElse((Function0 & Serializable)() -> {
            SecureRandom random = new SecureRandom();
            byte[] values = new byte[16];
            random.nextBytes(values);
            return Base64.getMimeEncoder().encodeToString(values);
        });
    }

    @Inject
    public DefaultCSPProcessor(CSPConfig config) {
        this.config = config;
        this.noncePattern = Pattern.compile(config.nonce().pattern(), 16);
        this.hashPatterns = (Seq)config.hashes().map((Function1 & Serializable)hashConfig -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Pattern.compile(hashConfig.pattern(), 16)), (Object)(hashConfig.algorithm() + "-" + hashConfig.hash())));
        this.cspLine = this.generateDirectives(config.directives());
    }
}

