/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csrf;

import com.typesafe.config.ConfigMemorySize;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.http.HttpConfiguration$;
import play.api.http.MimeTypes$;
import play.api.mvc.Cookie;
import play.api.mvc.RequestHeader;
import play.api.routing.Router;
import play.filters.csrf.CSRFConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CSRFConfig$
implements Serializable {
    public static final CSRFConfig$ MODULE$ = new CSRFConfig$();
    private static final Set<String> SafeMethods = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GET", "HEAD", "OPTIONS"}));

    public String $lessinit$greater$default$1() {
        return "csrfToken";
    }

    public Option<String> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$3() {
        return false;
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public Option<Cookie.SameSite> $lessinit$greater$default$5() {
        return new Some((Object)Cookie.SameSite$.Lax$.MODULE$);
    }

    public Function1<RequestHeader, Object> $lessinit$greater$default$6() {
        return (Function1 & Serializable)request -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.MODULE$.defaultCreateIfNotFound(request));
    }

    public long $lessinit$greater$default$7() {
        return 102400L;
    }

    public boolean $lessinit$greater$default$8() {
        return true;
    }

    public Function1<String, Object> $lessinit$greater$default$9() {
        return (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$$lessinit$greater$default$9$1(x$1));
    }

    public Function1<Option<String>, Object> $lessinit$greater$default$10() {
        return (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$$lessinit$greater$default$10$1(x$2));
    }

    public String $lessinit$greater$default$11() {
        return "Csrf-Token";
    }

    public Function1<RequestHeader, Object> $lessinit$greater$default$12() {
        return (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$$lessinit$greater$default$12$1(x$3));
    }

    public boolean $lessinit$greater$default$13() {
        return true;
    }

    private Set<String> SafeMethods() {
        return SafeMethods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean defaultCreateIfNotFound(RequestHeader request) {
        String string = request.method();
        String string2 = "GET";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = request.method();
            String string4 = "HEAD";
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
        }
        if (request.accepts(MimeTypes$.MODULE$.HTML())) return true;
        if (!request.accepts(MimeTypes$.MODULE$.XHTML())) return false;
        return true;
    }

    public CSRFConfig fromConfiguration(Configuration conf) {
        Configuration config = conf.getDeprecatedWithFallback("play.filters.csrf", "csrf", conf.getDeprecatedWithFallback$default$3());
        Set methodWhiteList = ((IterableOnceOps)config.get("method.whiteList", ConfigLoader$.MODULE$.seqStringLoader())).toSet();
        Set methodBlackList = ((IterableOnceOps)config.get("method.blackList", ConfigLoader$.MODULE$.seqStringLoader())).toSet();
        Function1 & Serializable checkMethod = methodWhiteList.nonEmpty() ? (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$fromConfiguration$1(methodWhiteList, x$7)) : (methodBlackList.isEmpty() ? (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$fromConfiguration$2(x$8)) : (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)methodBlackList.contains((Object)elem)));
        Set contentTypeWhiteList = ((IterableOnceOps)config.get("contentType.whiteList", ConfigLoader$.MODULE$.seqStringLoader())).toSet();
        Set contentTypeBlackList = ((IterableOnceOps)config.get("contentType.blackList", ConfigLoader$.MODULE$.seqStringLoader())).toSet();
        Function1 & Serializable checkContentType = contentTypeWhiteList.nonEmpty() ? (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$fromConfiguration$5(contentTypeWhiteList$1, x$10)))) : (contentTypeBlackList.isEmpty() ? (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$fromConfiguration$6(x$11)) : (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)contentTypeBlackList$1.contains((Object)elem)))));
        Seq whitelistModifiers = (Seq)config.get("routeModifiers.whiteList", ConfigLoader$.MODULE$.seqStringLoader());
        Seq blacklistModifiers = (Seq)config.get("routeModifiers.blackList", ConfigLoader$.MODULE$.seqStringLoader());
        Map protectHeaders = (Map)((Option)config.get("header.protectHeaders", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.mapLoader(ConfigLoader$.MODULE$.stringLoader())))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        Map bypassHeaders = (Map)((Option)config.get("header.bypassHeaders", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.mapLoader(ConfigLoader$.MODULE$.stringLoader())))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        Function1 & Serializable shouldProtect = (Function1 & Serializable)rh -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$fromConfiguration$14(whitelistModifiers, blacklistModifiers, protectHeaders, bypassHeaders, rh));
        String x$1 = (String)config.get("token.name", ConfigLoader$.MODULE$.stringLoader());
        Option x$2 = (Option)config.get("cookie.name", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        boolean x$3 = BoxesRunTime.unboxToBoolean((Object)config.get("cookie.secure", ConfigLoader$.MODULE$.booleanLoader()));
        boolean x$4 = BoxesRunTime.unboxToBoolean((Object)config.get("cookie.httpOnly", ConfigLoader$.MODULE$.booleanLoader()));
        Option x$5 = HttpConfiguration$.MODULE$.parseSameSite(config, "cookie.sameSite");
        long x$6 = ((ConfigMemorySize)config.get("body.bufferSize", ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        boolean x$72 = BoxesRunTime.unboxToBoolean((Object)config.get("token.sign", ConfigLoader$.MODULE$.booleanLoader()));
        Function1 & Serializable x$82 = checkMethod;
        Function1 & Serializable x$92 = checkContentType;
        String x$10 = (String)config.get("header.name", ConfigLoader$.MODULE$.stringLoader());
        Function1 & Serializable x$112 = shouldProtect;
        boolean x$122 = BoxesRunTime.unboxToBoolean((Object)config.get("bypassCorsTrustedOrigins", ConfigLoader$.MODULE$.booleanLoader()));
        Function1<RequestHeader, Object> x$13 = this.apply$default$6();
        return new CSRFConfig(x$1, (Option<String>)x$2, x$3, x$4, (Option<Cookie.SameSite>)x$5, x$13, x$6, x$72, (Function1<String, Object>)x$82, (Function1<Option<String>, Object>)x$92, x$10, (Function1<RequestHeader, Object>)x$112, x$122);
    }

    public CSRFConfig apply(String tokenName, Option<String> cookieName, boolean secureCookie, boolean httpOnlyCookie, Option<Cookie.SameSite> sameSiteCookie, Function1<RequestHeader, Object> createIfNotFound, long postBodyBuffer, boolean signTokens, Function1<String, Object> checkMethod, Function1<Option<String>, Object> checkContentType, String headerName, Function1<RequestHeader, Object> shouldProtect, boolean bypassCorsTrustedOrigins) {
        return new CSRFConfig(tokenName, cookieName, secureCookie, httpOnlyCookie, sameSiteCookie, createIfNotFound, postBodyBuffer, signTokens, checkMethod, checkContentType, headerName, shouldProtect, bypassCorsTrustedOrigins);
    }

    public String apply$default$1() {
        return "csrfToken";
    }

    public Function1<Option<String>, Object> apply$default$10() {
        return (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$apply$default$10$1(x$2));
    }

    public String apply$default$11() {
        return "Csrf-Token";
    }

    public Function1<RequestHeader, Object> apply$default$12() {
        return (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$apply$default$12$1(x$3));
    }

    public boolean apply$default$13() {
        return true;
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public boolean apply$default$3() {
        return false;
    }

    public boolean apply$default$4() {
        return false;
    }

    public Option<Cookie.SameSite> apply$default$5() {
        return new Some((Object)Cookie.SameSite$.Lax$.MODULE$);
    }

    public Function1<RequestHeader, Object> apply$default$6() {
        return (Function1 & Serializable)request -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.MODULE$.defaultCreateIfNotFound(request));
    }

    public long apply$default$7() {
        return 102400L;
    }

    public boolean apply$default$8() {
        return true;
    }

    public Function1<String, Object> apply$default$9() {
        return (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$apply$default$9$1(x$1));
    }

    public Option<Tuple13<String, Option<String>, Object, Object, Option<Cookie.SameSite>, Function1<RequestHeader, Object>, Object, Object, Function1<String, Object>, Function1<Option<String>, Object>, String, Function1<RequestHeader, Object>, Object>> unapply(CSRFConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple13((Object)x$0.tokenName(), x$0.cookieName(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.secureCookie()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.httpOnlyCookie()), x$0.sameSiteCookie(), x$0.createIfNotFound(), (Object)BoxesRunTime.boxToLong((long)x$0.postBodyBuffer()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.signTokens()), x$0.checkMethod(), x$0.checkContentType(), (Object)x$0.headerName(), x$0.shouldProtect(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.bypassCorsTrustedOrigins())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CSRFConfig$.class);
    }

    public static final /* synthetic */ boolean $anonfun$$lessinit$greater$default$9$1(String x$1) {
        return !MODULE$.SafeMethods().contains((Object)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$$lessinit$greater$default$10$1(Option x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$$lessinit$greater$default$12$1(RequestHeader x$3) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$1(Set methodWhiteList$1, String x$7) {
        return !methodWhiteList$1.contains((Object)x$7);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$2(String x$8) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$5(Set contentTypeWhiteList$1, String x$10) {
        return !contentTypeWhiteList$1.contains((Object)x$10);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$6(Option x$11) {
        return true;
    }

    private static final boolean checkRouteModifiers$1(RequestHeader rh, Seq whitelistModifiers$1, Seq blacklistModifiers$1) {
        if (whitelistModifiers$1.isEmpty()) {
            RequestHeader requestHeader;
            return blacklistModifiers$1.isEmpty() || blacklistModifiers$1.exists(arg_0 -> CSRFConfig$.$anonfun$fromConfiguration$9$adapted(requestHeader = Router.RequestImplicits$.MODULE$.WithHandlerDef(rh), arg_0));
        }
        RequestHeader requestHeader = Router.RequestImplicits$.MODULE$.WithHandlerDef(rh);
        return !whitelistModifiers$1.exists((Function1 & Serializable)modifier -> BoxesRunTime.boxToBoolean((boolean)Router.RequestImplicits$.WithHandlerDef$.MODULE$.hasRouteModifier$extension(requestHeader, modifier)));
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$13(RequestHeader rh$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("*".equals(string)) {
                return rh$1.headers().get(name).isDefined();
            }
        }
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            return rh$1.headers().get(name).contains((Object)value);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean foundHeaderValues$1(Map headersToCheck, RequestHeader rh$1) {
        return headersToCheck.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CSRFConfig$.$anonfun$fromConfiguration$13(rh$1, x0$1)));
    }

    private static final boolean checkHeaders$1(RequestHeader rh, Map protectHeaders$1, Map bypassHeaders$1) {
        return (protectHeaders$1.isEmpty() || CSRFConfig$.foundHeaderValues$1(protectHeaders$1, rh)) && !CSRFConfig$.foundHeaderValues$1(bypassHeaders$1, rh);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfiguration$14(Seq whitelistModifiers$1, Seq blacklistModifiers$1, Map protectHeaders$1, Map bypassHeaders$1, RequestHeader rh) {
        return CSRFConfig$.checkRouteModifiers$1(rh, whitelistModifiers$1, blacklistModifiers$1) && CSRFConfig$.checkHeaders$1(rh, protectHeaders$1, bypassHeaders$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$10$1(Option x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$12$1(RequestHeader x$3) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$9$1(String x$1) {
        return !MODULE$.SafeMethods().contains((Object)x$1);
    }

    private CSRFConfig$() {
    }

    public static final /* synthetic */ Object $anonfun$fromConfiguration$9$adapted(RequestHeader eta$0$1$1, String modifier) {
        return BoxesRunTime.boxToBoolean((boolean)Router.RequestImplicits$.WithHandlerDef$.MODULE$.hasRouteModifier$extension(eta$0$1$1, modifier));
    }
}

