/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csrf;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.inject.Inject;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorInfo;
import play.api.http.SessionConfiguration;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.mvc.Request;
import play.api.mvc.RequestHeader;
import play.filters.csrf.CSRF;
import play.filters.csrf.CSRFActionHelper;
import play.filters.csrf.CSRFConfig;
import play.filters.csrf.CSRFErrorHandler;
import play.filters.csrf.RequireCSRFCheck;
import play.inject.Injector;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;

public class RequireCSRFCheckAction
extends Action<RequireCSRFCheck> {
    private final CSRFConfig config;
    private final SessionConfiguration sessionConfiguration;
    private final CSRF.TokenProvider tokenProvider;
    private final CSRFTokenSigner tokenSigner;
    private Function<RequireCSRFCheck, CSRFErrorHandler> configurator;

    @Inject
    public RequireCSRFCheckAction(CSRFConfig cSRFConfig, SessionConfiguration sessionConfiguration, CSRF.TokenProvider tokenProvider, CSRFTokenSigner cSRFTokenSigner, Injector injector) {
        this(cSRFConfig, sessionConfiguration, tokenProvider, cSRFTokenSigner, (RequireCSRFCheck requireCSRFCheck) -> (CSRFErrorHandler)injector.instanceOf(requireCSRFCheck.error()));
    }

    public RequireCSRFCheckAction(CSRFConfig cSRFConfig, SessionConfiguration sessionConfiguration, CSRF.TokenProvider tokenProvider, CSRFTokenSigner cSRFTokenSigner, CSRFErrorHandler cSRFErrorHandler) {
        this(cSRFConfig, sessionConfiguration, tokenProvider, cSRFTokenSigner, (RequireCSRFCheck requireCSRFCheck) -> cSRFErrorHandler);
    }

    public RequireCSRFCheckAction(CSRFConfig cSRFConfig, SessionConfiguration sessionConfiguration, CSRF.TokenProvider tokenProvider, CSRFTokenSigner cSRFTokenSigner, Function<RequireCSRFCheck, CSRFErrorHandler> function) {
        this.config = cSRFConfig;
        this.sessionConfiguration = sessionConfiguration;
        this.tokenProvider = tokenProvider;
        this.tokenSigner = cSRFTokenSigner;
        this.configurator = function;
    }

    public CompletionStage<Result> call(Http.Request request) {
        CSRFActionHelper cSRFActionHelper = new CSRFActionHelper(this.sessionConfiguration, this.config, this.tokenSigner, this.tokenProvider);
        Request request2 = cSRFActionHelper.tagRequestFromHeader(request.asScala());
        if (!cSRFActionHelper.requiresCsrfCheck((RequestHeader)request2) || this.config.checkContentType().apply((Object)request.asScala().contentType()) != Boolean.TRUE && !cSRFActionHelper.hasInvalidContentType((RequestHeader)request.asScala())) {
            return this.delegate.call(request);
        }
        Option<String> option = cSRFActionHelper.getTokenToValidate((RequestHeader)request2);
        if (option.isDefined()) {
            Map map;
            String[] stringArray;
            String string = null;
            Option<String> option2 = cSRFActionHelper.getHeaderToken((RequestHeader)request2);
            if (option2.isDefined()) {
                string = (String)option2.get();
            } else if (request.body().asFormUrlEncoded() != null) {
                String[] stringArray2 = (String[])request.body().asFormUrlEncoded().get(this.config.tokenName());
                if (stringArray2 != null && stringArray2.length > 0) {
                    string = stringArray2[0];
                }
            } else if (request.body().asMultipartFormData() != null && (stringArray = (String[])(map = request.body().asMultipartFormData().asFormUrlEncoded()).get(this.config.tokenName())) != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            if (string != null) {
                if (this.tokenProvider.compareTokens(string, (String)option.get())) {
                    return this.delegate.call(request);
                }
                return this.handleTokenError(request, (RequestHeader)request2, "CSRF tokens don't match");
            }
            return this.handleTokenError(request, (RequestHeader)request2, "CSRF token not found in body or query string");
        }
        return this.handleTokenError(request, (RequestHeader)request2, "CSRF token not found in session");
    }

    private CompletionStage<Result> handleTokenError(Http.Request request, RequestHeader requestHeader, String string) {
        CSRFErrorHandler cSRFErrorHandler = this.configurator.apply((RequireCSRFCheck)this.configuration);
        return cSRFErrorHandler.handle(requestHeader.addAttr(HttpErrorHandler.Attrs$.MODULE$.HttpErrorInfo(), (Object)new HttpErrorInfo("csrf-filter")).asJava(), string).thenApply(result -> {
            if (CSRF.getToken(requestHeader).isEmpty()) {
                if (this.config.cookieName().isDefined()) {
                    Option option = this.sessionConfiguration.domain();
                    return result.discardingCookie((String)this.config.cookieName().get(), this.sessionConfiguration.path(), option.isDefined() ? (String)option.get() : null, this.config.secureCookie());
                }
                return result.removingFromSession(request, new String[]{this.config.tokenName()});
            }
            return result;
        });
    }
}

