/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.xid;

import javax.transaction.xa.Xid;
import tyrex.services.UUID;
import tyrex.tm.xid.BaseXid;

public final class ExternalXid
extends BaseXid {
    private final int _formatId;
    private final byte[] _global;
    private final byte[] _branch;

    public ExternalXid(int n, byte[] byArray, byte[] byArray2) {
        int n2;
        if (n == -1) {
            throw new IllegalArgumentException("Argument format is -1");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Argument global is null or an empty array");
        }
        this._formatId = n;
        StringBuffer stringBuffer = new StringBuffer(14);
        stringBuffer.append("xid:");
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 28 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 24 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 20 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 16 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 12 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 8 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n >> 4 & 0xF]);
        stringBuffer.append(BaseXid.HEX_DIGITS[n & 0xF]);
        stringBuffer.append('-');
        if (byArray == null || byArray.length == 0) {
            this._global = BaseXid.EMPTY_ARRAY;
        } else {
            this._global = byArray;
            n2 = byArray.length;
            while (n2-- > 0) {
                stringBuffer.append(BaseXid.HEX_DIGITS[(byArray[n2] & 0xF0) >> 4]);
                stringBuffer.append(BaseXid.HEX_DIGITS[byArray[n2] & 0xF]);
            }
        }
        if (byArray2 == null || byArray2.length == 0) {
            this._branch = BaseXid.EMPTY_ARRAY;
        } else {
            stringBuffer.append('-');
            this._branch = byArray2;
            n2 = byArray2.length;
            while (n2-- > 0) {
                stringBuffer.append(BaseXid.HEX_DIGITS[(byArray2[n2] & 0xF0) >> 4]);
                stringBuffer.append(BaseXid.HEX_DIGITS[byArray2[n2] & 0xF]);
            }
        }
        this._string = stringBuffer.toString();
    }

    public ExternalXid(Xid xid) {
        this(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    ExternalXid(String string, int n, byte[] byArray, byte[] byArray2) {
        this._formatId = n;
        this._string = string;
        this._global = byArray;
        this._branch = byArray2;
    }

    public int getFormatId() {
        return this._formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this._global;
    }

    public byte[] getBranchQualifier() {
        return this._branch;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BaseXid) {
            return this._string.equals(((BaseXid)object)._string);
        }
        if (object instanceof Xid) {
            int n;
            Xid xid = (Xid)object;
            if (xid.getFormatId() != this._formatId) {
                return false;
            }
            byte[] byArray = xid.getGlobalTransactionId();
            if (byArray == null) {
                if (this._global.length != 0) {
                    return false;
                }
            } else {
                if (byArray.length != this._global.length) {
                    return false;
                }
                n = byArray.length;
                while (n-- > 0) {
                    if (byArray[n] == this._global[n]) continue;
                    return false;
                }
            }
            if ((byArray = xid.getBranchQualifier()) == null) {
                if (this._branch.length != 0) {
                    return false;
                }
            } else {
                if (byArray.length != this._branch.length) {
                    return false;
                }
                n = byArray.length;
                while (n-- > 0) {
                    if (byArray[n] == this._branch[n]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Xid newBranch() {
        return new ExternalXid(this._formatId, this._global, UUID.createBinary());
    }
}

