/*
 * Decompiled with CFR 0.152.
 */
package au.id.jazzy.play.geojson;

import au.id.jazzy.play.geojson.CrsFormat;
import au.id.jazzy.play.geojson.LatLng;
import au.id.jazzy.play.geojson.SphericalMercator;
import au.id.jazzy.play.geojson.SphericalMercatorCrs$;
import java.io.Serializable;
import play.api.libs.json.Format;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SphericalMercator$
implements Serializable {
    public static final SphericalMercator$ MODULE$ = new SphericalMercator$();
    private static final Format<SphericalMercator> format = SphericalMercatorCrs$.MODULE$.format();
    private static final CrsFormat<SphericalMercator> crs = SphericalMercatorCrs$.MODULE$;
    private static final int RADIUS = 6378137;
    private static final double HALF_SIZE = Math.PI * (double)MODULE$.RADIUS();
    private static final List<Object> EXTENT = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-MODULE$.HALF_SIZE(), -MODULE$.HALF_SIZE(), MODULE$.HALF_SIZE(), MODULE$.HALF_SIZE()}));
    private static final List<Object> WORLD_EXTENT = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-180, -85, 180, 85}));

    public Format<SphericalMercator> format() {
        return format;
    }

    public CrsFormat<SphericalMercator> crs() {
        return crs;
    }

    public int RADIUS() {
        return RADIUS;
    }

    public double HALF_SIZE() {
        return HALF_SIZE;
    }

    public List<Object> EXTENT() {
        return EXTENT;
    }

    public List<Object> WORLD_EXTENT() {
        return WORLD_EXTENT;
    }

    public SphericalMercator fromEPSG4326(LatLng input, double factor) {
        double y = factor * package$.MODULE$.log(package$.MODULE$.tan(Math.PI * (input.lat() + (double)90) / (double)360));
        double x = factor * Math.PI * input.lng() / (double)180;
        return new SphericalMercator(x, y);
    }

    public double fromEPSG4326$default$2() {
        return this.RADIUS();
    }

    public LatLng toEPSG4326(SphericalMercator input, double factor) {
        double lat = (double)360 * package$.MODULE$.atan(package$.MODULE$.exp(input.y() / factor)) / Math.PI - (double)90;
        double lng = (double)180 * input.x() / (factor * Math.PI);
        return new LatLng(lat, lng);
    }

    public double toEPSG4326$default$2() {
        return this.RADIUS();
    }

    public SphericalMercator apply(double x, double y) {
        return new SphericalMercator(x, y);
    }

    public Option<Tuple2<Object, Object>> unapply(SphericalMercator x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcDD.sp(x$0.x(), x$0.y()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SphericalMercator$.class);
    }

    private SphericalMercator$() {
    }
}

