/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import dao.UserDao;
import dao.rpc.ContactDaoRPC;
import domain.EmailInput$;
import domain.LoginAndResetCodeInput$;
import domain.LoginInput$;
import domain.PasswordInput$;
import domain.PasswordInputMobile$;
import fr.aquasys.daeau.administration.itf.JournalDao;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.aquaparc.SIEauLicencesOutput$;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.daeau.user.model.UserHabilitation;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.application.constants.StatisticEventTypeConstants$;
import fr.aquasys.rabbitmq.api.application.constants.StatisticModuleConstants$;
import fr.aquasys.rabbitmq.api.constant.MailRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.rabbitmq.util.StatUtil;
import fr.aquasys.utils.StringUtil$;
import fr.aquasys.utils.UserUtil$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import licence.LicenceController;
import model.Contact;
import model.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pdi.jwt.Jwt$;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtClaim;
import play.api.http.Writeable$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.AbstractController;
import play.api.mvc.Action;
import play.api.mvc.AnyContent;
import play.api.mvc.ControllerComponents;
import play.api.mvc.Result;
import play.api.mvc.Results;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u0012$\u0001\u0019B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0011b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001]:\t\u0011U\u0004!\u0011!Q\u0001\nYDQ!\u001f\u0001\u0005\u0002iD\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005M\u0002\u0001)A\u0005\u0003GA\u0011\"!\u000e\u0001\u0005\u0004%I!!\t\t\u0011\u0005]\u0002\u0001)A\u0005\u0003GA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005U\u0003\u0001)A\u0005\u0003{A\u0011\"a\u0016\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005e\u0003\u0001)A\u0005\u0003{A\u0011\"a\u0017\u0001\u0005\u0004%\t!!\u0018\t\u0011\u0005]\u0004\u0001)A\u0005\u0003?Bq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u0011q\u0017\u0001\u0005\u0002\u0005%\u0006bBA]\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003w\u0003A\u0011AAU\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a5\u0001\t\u0013\t)\u000eC\u0004\u0002v\u0002!\t!a0\t\u000f\u0005]\b\u0001\"\u0001\u0002@\"9\u0011\u0011 \u0001\u0005\u0002\u0005}\u0006bBA~\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003{\u0004A\u0011AA`\u00059)6/\u001a:D_:$(o\u001c7mKJT\u0011\u0001J\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0007\u00019\u0013\u0007\u0005\u0002)_5\t\u0011F\u0003\u0002+W\u0005\u0019QN^2\u000b\u00051j\u0013aA1qS*\ta&\u0001\u0003qY\u0006L\u0018B\u0001\u0019*\u0005I\t%m\u001d;sC\u000e$8i\u001c8ue>dG.\u001a:\u0011\u0005IRT\"A\u001a\u000b\u00051\"$BA\u001b7\u0003!\u0011\u0018M\u00192ji6\f(BA\u001c9\u0003\u001d\t\u0017/^1tsNT\u0011!O\u0001\u0003MJL!aO\u001a\u0003\u0011A\u0013x\u000eZ;dKJ\fq!^:fe\u0012\u000bw\u000e\u0005\u0002?\u00036\tqHC\u0001A\u0003\r!\u0017m\\\u0005\u0003\u0005~\u0012q!V:fe\u0012\u000bw.\u0001\bvg\u0016\u00148\u000b^1uS>tG)Y8\u0011\u0005\u0015cU\"\u0001$\u000b\u0005\u001dC\u0015aA5uM*\u0011\u0011JS\u0001\u0005kN,'O\u0003\u0002Lm\u0005)A-Y3bk&\u0011QJ\u0012\u0002\u000f+N,'o\u0015;bi&|g\u000eR1p\u00035\u0019wN\u001c;bGR$\u0015m\u001c*Q\u0007B\u0011\u0001kU\u0007\u0002#*\u0011!kP\u0001\u0004eB\u001c\u0017B\u0001+R\u00055\u0019uN\u001c;bGR$\u0015m\u001c*Q\u0007\u0006\u00112/[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p!\t96,D\u0001Y\u0015\t9\u0015L\u0003\u0002[\u0015\u0006q\u0011\rZ7j]&\u001cHO]1uS>t\u0017B\u0001/Y\u0005I\u0019\u0016.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0002#1K7-\u001a8dK\u000e{g\u000e\u001e:pY2,'\u000f\u0005\u0002`E6\t\u0001MC\u0001b\u0003\u001da\u0017nY3oG\u0016L!a\u00191\u0003#1K7-\u001a8dK\u000e{g\u000e\u001e:pY2,'/\u0001\u0005ti\u0006$X\u000b^5m!\t1\u0017.D\u0001h\u0015\tAG'\u0001\u0003vi&d\u0017B\u00016h\u0005!\u0019F/\u0019;Vi&d\u0017A\u00036pkJt\u0017\r\u001c#b_B\u0011q+\\\u0005\u0003]b\u0013!BS8ve:\fG\u000eR1p\u0003\t\u00197\r\u0005\u0002)c&\u0011!/\u000b\u0002\u0015\u0007>tGO]8mY\u0016\u00148i\\7q_:,g\u000e^:\n\u0005Q|\u0013\u0001F2p]R\u0014x\u000e\u001c7fe\u000e{W\u000e]8oK:$8/A\u0004m_\u001e,F/\u001b7\u0011\u0005\u0019<\u0018B\u0001=h\u0005\u001daunZ+uS2\fa\u0001P5oSRtD\u0003E>~}~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006!\ta\b!D\u0001$\u0011\u0015a$\u00021\u0001>\u0011\u0015\u0019%\u00021\u0001E\u0011\u0015q%\u00021\u0001P\u0011\u0015)&\u00021\u0001W\u0011\u0015i&\u00021\u0001_\u0011\u0015!'\u00021\u0001f\u0011\u0015Y'\u00021\u0001m\u0011\u0015y'\u00021\u0001q\u0011\u0015)(\u00021\u0001wQ\rQ\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0019IgN[3di*\u0011\u0011\u0011D\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003;\t\u0019B\u0001\u0004J]*,7\r^\u0001\u0007Q\u0016\fG-\u001a:\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0005Y\u0006twM\u0003\u0002\u0002.\u0005!!.\u0019<b\u0013\u0011\t\t$a\n\u0003\rM#(/\u001b8h\u0003\u001dAW-\u00193fe\u0002\naa]3de\u0016$\u0018aB:fGJ,G\u000fI\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0005\u0005u\u0002\u0003BA \u0003#j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007M>\u0014X.\u0019;\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005i&lWM\u0003\u0003\u0002L\u00055\u0013\u0001\u00026pI\u0006T!!a\u0014\u0002\u0007=\u0014x-\u0003\u0003\u0002T\u0005\u0005#!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0006qA-\u0019;f\r>\u0014X.\u0019;uKJ\u0004\u0013a\u00053bi\u0016\u001c\u0016.\u001c9mK\u001a{'/\\1ui\u0016\u0014\u0018\u0001\u00063bi\u0016\u001c\u0016.\u001c9mK\u001a{'/\\1ui\u0016\u0014\b%\u0001\bn_\u0012,G\u000eR5sK\u000e$xN]=\u0016\u0005\u0005}\u0003\u0003BA1\u0003grA!a\u0019\u0002pA!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u0015\na\u0001\u0010:p_Rt$BAA7\u0003\u0015\u00198-\u00197b\u0013\u0011\t\t(a\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$!\u001e\u000b\t\u0005E\u00141N\u0001\u0010[>$W\r\u001c#je\u0016\u001cGo\u001c:zA\u0005qQM\u001c3ECR,\u0017j\u001d'bi\u0016\u0014H\u0003BA?\u0003\u000b\u0003B!a \u0002\u00026\u0011\u00111N\u0005\u0005\u0003\u0007\u000bYGA\u0004C_>dW-\u00198\t\u000f\u0005\u001dU\u00031\u0001\u0002\n\u00069QM\u001c3ECR,\u0007\u0003BAF\u0003\u001bk!!!\u0012\n\t\u0005=\u0015Q\t\u0002\t\t\u0006$X\rV5nK\u0006a\u0011n]!vi\"|'/\u001b>fIR1\u0011QPAK\u00033Cq!a&\u0017\u0001\u0004\ty&\u0001\u0004n_\u0012,H.\u001a\u0005\u0007\u0013Z\u0001\r!a'\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S!!!)\u0002\u000b5|G-\u001a7\n\t\u0005\u0015\u0016q\u0014\u0002\u0005+N,'/A\u0003m_\u001eLg.\u0006\u0002\u0002,B)\u0001&!,\u00022&\u0019\u0011qV\u0015\u0003\r\u0005\u001bG/[8o!\rA\u00131W\u0005\u0004\u0003kK#AC!os\u000e{g\u000e^3oi\u0006)1\r[3dW\u0006\u00112\r[3dW&\u001b\u0018\t\u001d9mS\u000e\fG/\u001b<f\u0003\u0019awnZ8vi\u0006)!/Z:fiV\u0011\u0011\u0011\u0019\t\u0006Q\u00055\u00161\u0019\t\u0005\u0003\u000b\fy-\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003\u0011Q7o\u001c8\u000b\u0007\u000557&\u0001\u0003mS\n\u001c\u0018\u0002BAi\u0003\u000f\u0014qAS:WC2,X-\u0001\rtK:$W*Y5m\u0003:$'+Z:fiB\u000b7o]<pe\u0012$\"\"a6\u0002d\u0006\u0015\u0018\u0011^Ay!\u0011\tI.a7\u000e\u0003\u0001IA!!8\u0002`\n11\u000b^1ukNL1!!9*\u0005\u001d\u0011Vm];miNDq!a*\u001d\u0001\u0004\ty\u0006C\u0004\u0002hr\u0001\r!a\u0018\u0002\u000b\u0015l\u0017-\u001b7\t\u000f\u0005]E\u00041\u0001\u0002lB1\u0011qPAw\u0003?JA!a<\u0002l\t1q\n\u001d;j_:Dq!a=\u001d\u0001\u0004\tY/A\u0004ve2\u001cVM\u001c3\u0002\u0019I,7/\u001a;Cs\u0016k\u0017-\u001b7\u0002\u001fY,'/\u001b4z%\u0016\u001cX\r^\"pI\u0016\fA\"\u001b8jiB\u000b7o]<pe\u0012\fa\"\u001e9eCR,\u0007+Y:to>\u0014H-\u0001\u000bva\u0012\fG/\u001a)bgN<xN\u001d3N_\nLG.\u001a")
public class UserController
extends AbstractController
implements Producer {
    private final UserDao userDao;
    private final UserStationDao userStationDao;
    private final ContactDaoRPC contactDaoRPC;
    private final SieauParametersDao sieauParametersDao;
    private final LicenceController LicenceController;
    private final StatUtil statUtil;
    private final JournalDao journalDao;
    private final LogUtil logUtil;
    private final String header;
    private final String secret;
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter dateSimpleFormatter;
    private final String modelDirectory;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        UserController userController = this;
        synchronized (userController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    private String header() {
        return this.header;
    }

    private String secret() {
        return this.secret;
    }

    private DateTimeFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private DateTimeFormatter dateSimpleFormatter() {
        return this.dateSimpleFormatter;
    }

    public String modelDirectory() {
        return this.modelDirectory;
    }

    public boolean endDateIsLater(DateTime endDate) {
        DateTime nowDateFormatted;
        String endDateFormatString = this.dateSimpleFormatter().print((ReadableInstant)endDate);
        String nowFormatString = this.dateSimpleFormatter().print((ReadableInstant)DateTime.now());
        DateTime endDateFormatted = DateTime.parse((String)endDateFormatString);
        return endDateFormatted.isEqual((ReadableInstant)(nowDateFormatted = DateTime.parse((String)nowFormatString))) || endDateFormatted.isAfter((ReadableInstant)nowDateFormatted);
    }

    public boolean isAuthorized(String module, User user) {
        boolean userHaveApplicativeUsers;
        boolean userNoAdmin = user.isAdmin().isEmpty() || ((String)user.isAdmin().get()).isEmpty() || ((String)user.isAdmin().get()).equals("0");
        boolean userNoMetadata = user.metadata().isEmpty() || ((String)user.metadata().get()).isEmpty() || ((String)user.metadata().get()).equals("0");
        boolean userNoLabo = user.labo().isEmpty() || ((String)user.labo().get()).isEmpty() || ((String)user.labo().get()).equals("0");
        boolean userNoConsultant = user.consultant().isEmpty() || ((String)user.consultant().get()).isEmpty() || ((String)user.consultant().get()).equals("0");
        Seq<UserHabilitation> userHabilitations = this.userDao.getAllUserHabilitations(user.login());
        boolean bl = userHaveApplicativeUsers = ((SeqOps)this.userDao.getAllApplicative().filter((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)userHabilitations.exists((Function1 & Serializable)habilitation -> BoxesRunTime.boxToBoolean((boolean)UserController.$anonfun$isAuthorized$2(u, habilitation)))))).length() > 0;
        if (module.equals("WEB")) {
            return !BoxesRunTime.unboxToBoolean((Object)user.isApplicative().get()) && !userHaveApplicativeUsers || userHaveApplicativeUsers && (!userNoAdmin || !userNoMetadata || !userNoLabo || !userNoConsultant);
        }
        String string = module;
        String string2 = "Observatoire";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return userHabilitations.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserController.$anonfun$isAuthorized$3(x$1)));
        }
        return !BoxesRunTime.unboxToBoolean((Object)user.isApplicative().get());
    }

    public Action<AnyContent> login() {
        return this.Action().apply((Function1 & Serializable)request -> {
            Option option = request.headers().get("Authorization");
            if (option instanceof Some) {
                Some some = (Some)option;
                String auth = (String)some.value();
                boolean bl = auth.split(" ")[0].equals("Basic");
                if (bl) {
                    String[] userAuth = new String(Base64.getDecoder().decode(auth.split(" ")[1])).split(":", 2);
                    String login = userAuth[0];
                    String password = userAuth[1];
                    if (password.length() > 128) {
                        return this.Forbidden();
                    }
                    String module = (String)request.headers().get("Module").getOrElse((Function0 & Serializable)() -> "WEB");
                    Option<User> option2 = $this.userDao.find(login);
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        User user = (User)some2.value();
                        if (this.isAuthorized(module, user)) {
                            int maxAttempts = $this.userDao.getMaximumConnexionAttempts();
                            if (BoxesRunTime.unboxToInt((Object)user.connexionAttempts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < maxAttempts) {
                                if (user.endDate().isEmpty() || this.endDateIsLater((DateTime)user.endDate().get())) {
                                    if (user.passwordHash().isEmpty()) {
                                        $this.logUtil.info("Unauthorized access", $this.logUtil.info$default$2());
                                        return this.Unauthorized();
                                    }
                                    if (UserUtil$.MODULE$.checkPassword(password, (String)user.passwordHash().get())) {
                                        $this.logUtil.info(new StringBuilder(17).append("User : ").append(user.login()).append(" is logged").toString(), $this.logUtil.info$default$2());
                                        JsObject payload = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)new DateTime().plusHours(12).getMillis()), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"login"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)user.login(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.dateFormatter().print((ReadableInstant)new DateTime()), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"license"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.toJson($this.LicenceController.licences(), Writes$.MODULE$.OptionWrites((Writes)SIEauLicencesOutput$.MODULE$.format())), Writes$.MODULE$.jsValueWrites()))}));
                                        String token = Jwt$.MODULE$.encode(this.header(), payload.toString(), this.secret(), (JwtAlgorithm)JwtAlgorithm.HS256$.MODULE$);
                                        $this.userDao.update(token, user.login());
                                        String module2 = (String)request.headers().get("Module").getOrElse((Function0 & Serializable)() -> "WEB");
                                        $this.statUtil.createStat(user.login(), StatisticEventTypeConstants$.MODULE$.LOGIN(), module2, module2, (Option)new Some((Object)StatisticModuleConstants$.MODULE$.SIEAU()));
                                        if (BoxesRunTime.unboxToInt((Object)user.connexionAttempts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) > 0) {
                                            $this.userDao.resetConnexionAttempts(login);
                                        }
                                        if (user.resetPassword().isDefined()) {
                                            $this.userDao.resetPassword(login, (Option<String>)None$.MODULE$);
                                        }
                                        $this.userStationDao.updateContributorsAndNetworkshabilitations(user.login(), "PIEZO", (String)user.isAdmin().getOrElse((Function0 & Serializable)() -> "0"));
                                        return this.Ok().apply((Object)Json$.MODULE$.toJson((Object)token, (Writes)Writes$.MODULE$.StringWrites()), Writeable$.MODULE$.writeableOf_JsValue());
                                    }
                                    $this.logUtil.info(new StringBuilder(26).append("Unauthorized access for : ").append(login).toString(), $this.logUtil.info$default$2());
                                    $this.userDao.incrementConnexionAttempt(login);
                                    if (BoxesRunTime.unboxToInt((Object)user.connexionAttempts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) == maxAttempts - 1) {
                                        return this.TooManyRequests();
                                    }
                                    return this.Unauthorized();
                                }
                                $this.logUtil.info(new StringBuilder(26).append("Unauthorized access for : ").append(login).toString(), $this.logUtil.info$default$2());
                                return this.Unauthorized();
                            }
                            $this.logUtil.info(new StringBuilder(34).append("Too many access requests for user ").append(userAuth[0]).toString(), $this.logUtil.info$default$2());
                            return this.TooManyRequests();
                        }
                        $this.logUtil.info(new StringBuilder(43).append("Unauthorized access for applicative user : ").append(login).toString(), $this.logUtil.info$default$2());
                        return this.Unauthorized();
                    }
                    $this.logUtil.info(new StringBuilder(26).append("Unauthorized access for : ").append(userAuth[0]).toString(), $this.logUtil.info$default$2());
                    return this.Unauthorized();
                }
                if (!bl) {
                    $this.logUtil.info(new StringBuilder(26).append("Unauthorized access for : ").append(auth).toString(), $this.logUtil.info$default$2());
                    return this.Unauthorized();
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.info("Unauthorized access", $this.logUtil.info$default$2());
                return this.Unauthorized();
            }
            throw new MatchError((Object)option);
        });
    }

    public Action<AnyContent> check() {
        return this.Action().apply((Function1 & Serializable)request -> {
            Some some;
            String token;
            Option option = request.headers().get("token");
            if (option instanceof Some && (token = (String)(some = (Some)option).value()) != null) {
                String login;
                String string = token;
                String[] tokenSplit = string.split(" ");
                String string2 = login = "Bearer".equals(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])tokenSplit))) && Jwt$.MODULE$.isValid(tokenSplit[1], this.secret(), (Seq)new .colon.colon((Object)JwtAlgorithm.HS256$.MODULE$, (List)Nil$.MODULE$)) ? (String)Jwt$.MODULE$.decode(tokenSplit[1], this.secret(), (Seq)new .colon.colon((Object)JwtAlgorithm.HS256$.MODULE$, (List)Nil$.MODULE$)).map((Function1 & Serializable)payload -> (String)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(payload.toJson())), "login").as((Reads)Reads$.MODULE$.StringReads())).getOrElse((Function0 & Serializable)() -> "") : "";
                if (!login.isEmpty() && $this.userDao.getToken(login).equals(tokenSplit[1])) {
                    return this.Ok();
                }
                $this.logUtil.error(new StringBuilder(26).append("Unauthorized access for : ").append(login).toString(), $this.logUtil.error$default$2());
                return this.Unauthorized();
            }
            if (None$.MODULE$.equals(option)) {
                return this.BadRequest();
            }
            throw new MatchError((Object)option);
        });
    }

    public Action<AnyContent> checkIsApplicative() {
        return this.Action().async((Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Some some;
            String token;
            Option option = request.headers().get("token");
            if (option instanceof Some && (token = (String)(some = (Some)option).value()) != null) {
                String string = token;
                String[] tokenSplit = string.split(" ");
                String login = "Bearer".equals(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])tokenSplit))) && Jwt$.MODULE$.isValid(tokenSplit[1], this.secret(), (Seq)new .colon.colon((Object)JwtAlgorithm.HS256$.MODULE$, (List)Nil$.MODULE$)) ? (String)Jwt$.MODULE$.decode(tokenSplit[1], this.secret(), (Seq)new .colon.colon((Object)JwtAlgorithm.HS256$.MODULE$, (List)Nil$.MODULE$)).map((Function1 & Serializable)payload -> (String)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(payload.toJson())), "login").as((Reads)Reads$.MODULE$.StringReads())).getOrElse((Function0 & Serializable)() -> "") : "";
                Option<User> option2 = $this.userDao.findLower(login);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    User user = (User)some2.value();
                    if (BoxesRunTime.unboxToBoolean((Object)user.isApplicative().get())) {
                        return this.Ok().apply((Object)Json$.MODULE$.toJson((Object)login, (Writes)Writes$.MODULE$.StringWrites()), Writeable$.MODULE$.writeableOf_JsValue());
                    }
                    return this.Forbidden();
                }
                $this.logUtil.info(new StringBuilder(21).append("User doesn't exist : ").append(login).toString(), $this.logUtil.info$default$2());
                return this.Unauthorized();
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.info("Unauthorized access", $this.logUtil.info$default$2());
                return this.Unauthorized();
            }
            throw new MatchError((Object)option);
        }, ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Action<AnyContent> logout() {
        return this.Action().async((Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Option option = request.headers().get("Authorization");
            if (option instanceof Some) {
                Some some = (Some)option;
                String auth = (String)some.value();
                boolean bl = auth.split(" ")[0].equals("Bearer");
                if (bl) {
                    String token = auth.split(" ")[1];
                    String payload = new String(Base64.getDecoder().decode(token.split("\\.")[1]));
                    Try try_ = Jwt$.MODULE$.decode(token, this.secret(), (Seq)new .colon.colon((Object)JwtAlgorithm.HS256$.MODULE$, (List)Nil$.MODULE$));
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        JwtClaim v = (JwtClaim)success.value();
                        String username = (String)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(v.toJson())), "login").as((Reads)Reads$.MODULE$.StringReads());
                        int n = $this.userDao.logout(auth.split(" ")[1]);
                        switch (n) {
                            case 1: {
                                $this.logUtil.info(new StringBuilder(10).append(username).append(" is logout").toString(), $this.logUtil.info$default$2());
                                String module = (String)request.headers().get("Module").getOrElse((Function0 & Serializable)() -> "WEB");
                                $this.statUtil.createStat(username, StatisticEventTypeConstants$.MODULE$.LOGOUT(), module, module, (Option)new Some((Object)StatisticModuleConstants$.MODULE$.SIEAU()));
                                return this.Ok();
                            }
                            case 0: {
                                $this.logUtil.error(new StringBuilder(23).append("Bad request for user : ").append(username).toString(), $this.logUtil.error$default$2());
                                return this.BadRequest();
                            }
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    if (try_ instanceof Failure) {
                        $this.userDao.logoutByLogin((String)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(payload)), "login").as((Reads)Reads$.MODULE$.StringReads()));
                        return this.Ok();
                    }
                    throw new MatchError((Object)try_);
                }
                if (!bl) {
                    $this.logUtil.error(new StringBuilder(26).append("Unauthorized access for : ").append(auth).toString(), $this.logUtil.error$default$2());
                    return this.Unauthorized();
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.error("Unauthorized access", $this.logUtil.error$default$2());
                return this.Unauthorized();
            }
            throw new MatchError((Object)option);
        }, ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Action<JsValue> reset() {
        return this.Action().async(this.parse().json(), (Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Results.Status)((JsValue)request.body()).validate(LoginInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.info(new StringBuilder(29).append("Error to parse email input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.info$default$2());
            return this.BadRequest();
        }, (Function1 & Serializable)loginInput -> (Results.Status)$this.userDao.find(loginInput.login()).map((Function1 & Serializable)user -> {
            Option<Object> option = user.contactCode();
            if (option instanceof Some) {
                Some some = (Some)option;
                double contactCode = BoxesRunTime.unboxToDouble((Object)some.value());
                int codeToInt = (int)contactCode;
                Option<String> option2 = $this.contactDaoRPC.getContact(codeToInt).email();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String email = (String)some2.value();
                    return this.sendMailAndResetPassword(loginInput.login(), email, loginInput.module(), loginInput.url());
                }
                if (None$.MODULE$.equals(option2)) {
                    return this.NotFound();
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return this.NotFound();
            }
            throw new MatchError(option);
        }).getOrElse((Function0 & Serializable)() -> this.NotFound())), ExecutionContext.Implicits$.MODULE$.global()));
    }

    private Results.Status sendMailAndResetPassword(String login, String email, Option<String> module, Option<String> urlSend) {
        URI uRI;
        Some some;
        String string;
        String string2;
        None$ applicationName;
        None$ none$;
        Option option = this.sieauParametersDao.get("applicationName", "SIEAU");
        if (option instanceof Some) {
            Some some2 = (Some)option;
            SieauParameters param = (SieauParameters)some2.value();
            none$ = param.value();
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        None$ none$2 = applicationName = none$;
        if (none$2 instanceof Some) {
            Some some3 = (Some)none$2;
            String name = (String)some3.value();
            string2 = new StringBuilder(24).append("[").append(name).append("] Mot de passe oubli\u00e9 ?").toString();
        } else if (None$.MODULE$.equals(none$2)) {
            string2 = "Mot de passe oubli\u00e9 ?";
        } else {
            throw new MatchError((Object)none$2);
        }
        String mailTitle = string2;
        Option<String> option2 = module;
        if (option2 instanceof Some && "MOBILE".equals(string = (String)(some = (Some)option2).value())) {
            URI uRI2;
            String code = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(Integer.toString((int)(Math.random() * (double)100000))), 4);
            this.userDao.resetPassword(login, (Option<String>)new Some((Object)code));
            URI defaultResource = this.getClass().getResource("/reset-password-with-code.html").toURI();
            Option option3 = package$.MODULE$.env().get((Object)this.modelDirectory());
            if (option3 instanceof Some) {
                Some some4 = (Some)option3;
                String directory = (String)some4.value();
                String path = new StringBuilder(33).append(directory).append(File.separator).append("MAIL").append(File.separator).append("reset-password-with-code.html").toString();
                File file = new File(path);
                uRI2 = file.exists() ? file.toURI() : defaultResource;
            } else if (None$.MODULE$.equals(option3)) {
                uRI2 = defaultResource;
            } else {
                throw new MatchError((Object)option3);
            }
            URI resource = uRI2;
            String message = Source$.MODULE$.fromFile(resource, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("").replace("{login}", login).replace("{code}", code);
            JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)mailTitle, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Properties$.MODULE$.envOrElse("MAIL_FROM", (Function0 & Serializable)() -> "noreply@aquasys.fr"), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
            this.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
            this.userDao.resetConnexionAttempts(login);
            this.journalDao.addLog(new StringBuilder(52).append("Envoi de mail de r\u00e9initialisation de mdp (mobile) : ").append(email).toString(), (Option)new Some((Object)login), (Option)new Some((Object)"RESET_PASSWORD"), this.journalDao.addLog$default$4());
            return this.Ok();
        }
        String uuid = UUID.randomUUID().toString();
        this.userDao.resetPassword(login, (Option<String>)new Some((Object)uuid));
        URI defaultResource = this.getClass().getResource("/reset-password.html").toURI();
        Option option4 = package$.MODULE$.env().get((Object)this.modelDirectory());
        if (option4 instanceof Some) {
            Some some5 = (Some)option4;
            String directory = (String)some5.value();
            String path = new StringBuilder(23).append(directory).append(File.separator).append("MAIL").append(File.separator).append("reset-password.html").toString();
            File file = new File(path);
            uRI = file.exists() ? file.toURI() : defaultResource;
        } else if (None$.MODULE$.equals(option4)) {
            uRI = defaultResource;
        } else {
            throw new MatchError((Object)option4);
        }
        URI resource = uRI;
        boolean isObservatory = ((String)module.getOrElse((Function0 & Serializable)() -> "WEB")).equals("Observatoire");
        String path = isObservatory ? "reset/" : "#/reset?token=";
        String defaultUrl = Properties$.MODULE$.envOrElse("SECOND_APPLICATION_URL", (Function0 & Serializable)() -> Properties$.MODULE$.envOrElse("APPLICATION_URL", (Function0 & Serializable)() -> ""));
        String url = isObservatory ? Properties$.MODULE$.envOrElse("OBSERVATOIRE_URL", (Function0 & Serializable)() -> defaultUrl) : defaultUrl;
        String message = Source$.MODULE$.fromFile(resource, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("").replace("{url}", StringUtil$.MODULE$.getPath((String)urlSend.getOrElse((Function0 & Serializable)() -> url))).replace("{login}", login).replace("{path}", path).replace("{token}", uuid);
        JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)mailTitle, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Properties$.MODULE$.envOrElse("MAIL_FROM", (Function0 & Serializable)() -> "noreply@aquasys.fr"), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
        this.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
        this.userDao.resetConnexionAttempts(login);
        this.journalDao.addLog(new StringBuilder(49).append("Envoi de mail de r\u00e9initialisation de mdp (web) : ").append(email).toString(), (Option)new Some((Object)login), (Option)new Some((Object)"RESET_PASSWORD"), this.journalDao.addLog$default$4());
        return this.Ok();
    }

    public Action<JsValue> resetByEmail() {
        return this.Action().async(this.parse().json(), (Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Result)((JsValue)request.body()).validate(EmailInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.info(new StringBuilder(29).append("Error to parse email input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.info$default$2());
            return this.BadRequest();
        }, (Function1 & Serializable)emailInput -> {
            String login = $this.userDao.getLoginByEmail(emailInput.email());
            if (login.equals("ErrorNotFound")) {
                return this.NotFound();
            }
            if (login.equals("ErrorMultiple")) {
                return this.EntityTooLarge();
            }
            return this.sendMailAndResetPassword(login, emailInput.email(), emailInput.module(), emailInput.url());
        }), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Action<JsValue> verifyResetCode() {
        return this.Action().async(this.parse().json(), (Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Result)((JsValue)request.body()).validate(LoginAndResetCodeInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.info(new StringBuilder(29).append("Error to parse login input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.info$default$2());
            return this.BadRequest();
        }, (Function1 & Serializable)loginAndResetCodeInput -> {
            int maxAttempts = $this.userDao.getMaximumConnexionAttempts();
            Option<User> option = $this.userDao.find(loginAndResetCodeInput.login());
            if (option instanceof Some) {
                Some some = (Some)option;
                User user = (User)some.value();
                if (BoxesRunTime.unboxToInt((Object)user.connexionAttempts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < maxAttempts) {
                    Option<User> option2 = $this.userDao.findByLoginAndReset(loginAndResetCodeInput.login(), loginAndResetCodeInput.resetCode());
                    if (option2 instanceof Some) {
                        return this.Ok();
                    }
                    $this.userDao.incrementConnexionAttempt(loginAndResetCodeInput.login());
                    if (BoxesRunTime.unboxToInt((Object)user.connexionAttempts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) == maxAttempts - 1) {
                        return this.TooManyRequests();
                    }
                    return this.NotFound();
                }
                return this.TooManyRequests();
            }
            return this.NotFound();
        }), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Action<JsValue> initPassword() {
        return this.Action().async(this.parse().json(), (Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Results.Status)((JsValue)request.body()).validate(LoginInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.info(new StringBuilder(29).append("Error to parse email input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.info$default$2());
            return this.BadRequest();
        }, (Function1 & Serializable)loginInput -> (Results.Status)$this.userDao.find(loginInput.login()).map((Function1 & Serializable)user -> {
            Option<Object> option = user.contactCode();
            if (option instanceof Some) {
                Some some = (Some)option;
                double contactCode = BoxesRunTime.unboxToDouble((Object)some.value());
                int codeToInt = (int)contactCode;
                Contact contact = $this.contactDaoRPC.getContact(codeToInt);
                Option<String> option2 = contact.email();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String email = (String)some2.value();
                    Option<String> option3 = user.resetPassword();
                    if (option3 instanceof Some) {
                        return this.Conflict();
                    }
                    if (None$.MODULE$.equals(option3)) {
                        URI uRI;
                        String string;
                        None$ applicationName;
                        None$ none$;
                        Option option4 = $this.sieauParametersDao.get("applicationName", "SIEAU");
                        if (option4 instanceof Some) {
                            Some some3 = (Some)option4;
                            SieauParameters param = (SieauParameters)some3.value();
                            none$ = param.value();
                        } else if (None$.MODULE$.equals(option4)) {
                            none$ = None$.MODULE$;
                        } else {
                            throw new MatchError((Object)option4);
                        }
                        None$ none$2 = applicationName = none$;
                        if (none$2 instanceof Some) {
                            Some some4 = (Some)none$2;
                            String name = (String)some4.value();
                            string = new StringBuilder(33).append("[").append(name).append("] Initialiser votre mot de passe").toString();
                        } else if (None$.MODULE$.equals(none$2)) {
                            string = "Initialiser votre mot de passe";
                        } else {
                            throw new MatchError((Object)none$2);
                        }
                        String mailTitle = string;
                        String uuid = UUID.randomUUID().toString();
                        $this.userDao.resetPassword(loginInput.login(), (Option<String>)new Some((Object)uuid));
                        URI defaultResource = this.getClass().getResource("/init-password.html").toURI();
                        Option option5 = package$.MODULE$.env().get((Object)this.modelDirectory());
                        if (option5 instanceof Some) {
                            Some some5 = (Some)option5;
                            String directory = (String)some5.value();
                            String path = new StringBuilder(22).append(directory).append(File.separator).append("MAIL").append(File.separator).append("init-password.html").toString();
                            File file = new File(path);
                            uRI = file.exists() ? file.toURI() : defaultResource;
                        } else if (None$.MODULE$.equals(option5)) {
                            uRI = defaultResource;
                        } else {
                            throw new MatchError((Object)option5);
                        }
                        URI resource = uRI;
                        String message = Source$.MODULE$.fromFile(resource, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("").replace("{url}", (CharSequence)loginInput.url().getOrElse((Function0 & Serializable)() -> Properties$.MODULE$.envOrElse("SECOND_APPLICATION_URL", (Function0 & Serializable)() -> Properties$.MODULE$.envOrElse("APPLICATION_URL", (Function0 & Serializable)() -> "")))).replace("{token}", uuid).replace("{login}", loginInput.login()).replace("{name}", contact.name());
                        JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)mailTitle, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Properties$.MODULE$.envOrElse("MAIL_FROM", (Function0 & Serializable)() -> "noreply@aquasys.fr"), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
                        this.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
                        return this.Ok();
                    }
                    throw new MatchError(option3);
                }
                if (None$.MODULE$.equals(option2)) {
                    return this.NotFound();
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return this.NotFound();
            }
            throw new MatchError(option);
        }).getOrElse((Function0 & Serializable)() -> this.NotFound())), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Action<JsValue> updatePassword() {
        return this.Action().async(this.parse().json(), (Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Result)((JsValue)request.body()).validate(PasswordInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.info(new StringBuilder(32).append("Error to parse password input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.info$default$2());
            return this.BadRequest();
        }, (Function1 & Serializable)passwordInput -> {
            if (passwordInput.password().length() > 128) {
                return this.Forbidden();
            }
            return (Result)$this.userDao.findByReset(passwordInput.token()).map((Function1 & Serializable)user -> {
                byte[] salt = user.login().concat(passwordInput.password()).getBytes();
                String hash = UserUtil$.MODULE$.hashPassword(passwordInput.password(), salt);
                $this.userDao.updatePassword(user.login(), hash);
                $this.userDao.resetPassword(user.login(), (Option<String>)None$.MODULE$);
                return this.Ok();
            }).getOrElse((Function0 & Serializable)() -> this.BadRequest());
        }), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Action<JsValue> updatePasswordMobile() {
        return this.Action().async(this.parse().json(), (Function1 & Serializable)request -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Result)((JsValue)request.body()).validate(PasswordInputMobile$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.info(new StringBuilder(32).append("Error to parse password input :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.info$default$2());
            return this.BadRequest();
        }, (Function1 & Serializable)passwordInput -> {
            if (passwordInput.password().length() > 128) {
                return this.Forbidden();
            }
            return (Result)$this.userDao.findByLoginAndReset(passwordInput.login(), passwordInput.resetCode()).map((Function1 & Serializable)user -> {
                byte[] salt = user.login().concat(passwordInput.password()).getBytes();
                String hash = UserUtil$.MODULE$.hashPassword(passwordInput.password(), salt);
                $this.userDao.updatePassword(user.login(), hash);
                $this.userDao.resetPassword(user.login(), (Option<String>)None$.MODULE$);
                return this.Ok();
            }).getOrElse((Function0 & Serializable)() -> this.BadRequest());
        }), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public static final /* synthetic */ boolean $anonfun$isAuthorized$2(User u$1, UserHabilitation habilitation) {
        return habilitation.habilitation().toLowerCase().equals(u$1.login().toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$isAuthorized$3(UserHabilitation x$1) {
        String string = x$1.habilitation();
        String string2 = "OBSERVATORY";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public UserController(UserDao userDao, UserStationDao userStationDao, ContactDaoRPC contactDaoRPC, SieauParametersDao sieauParametersDao, LicenceController LicenceController2, StatUtil statUtil, JournalDao journalDao, ControllerComponents cc, LogUtil logUtil) {
        this.userDao = userDao;
        this.userStationDao = userStationDao;
        this.contactDaoRPC = contactDaoRPC;
        this.sieauParametersDao = sieauParametersDao;
        this.LicenceController = LicenceController2;
        this.statUtil = statUtil;
        this.journalDao = journalDao;
        this.logUtil = logUtil;
        super(cc);
        Producer.$init$((Producer)this);
        this.header = "{\"alg\":\"HS256\",\"typ\":\"JWT\"}";
        this.secret = "Aqu@Sys2o06";
        this.dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        this.dateSimpleFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        this.modelDirectory = "MODELS_DIRECTORY";
    }
}

