/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Clock;
import javax.crypto.SecretKey;
import pdi.jwt.Jwt;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtClaim$;
import pdi.jwt.JwtCore;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtHeader$;
import pdi.jwt.JwtOptions;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.matching.Regex;

public final class Jwt$
implements JwtCore<JwtHeader, JwtClaim> {
    public static final Jwt$ MODULE$ = new Jwt$();
    private static final Regex extractAlgorithmRegex;
    private static final Regex extractIssuerRegex;
    private static final Regex extractSubjectRegex;
    private static final Regex extractExpirationRegex;
    private static final Regex extractNotBeforeRegex;
    private static final Regex extractIssuedAtRegex;
    private static final Regex extractJwtIdRegex;
    private static final Regex clearStartRegex;
    private static final Regex clearMiddleRegex;
    private static final Regex clearEndRegex;
    private static Clock clock;

    static {
        JwtCore.$init$(MODULE$);
        extractAlgorithmRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"alg\" *: *\"([a-zA-Z0-9]+)\""));
        extractIssuerRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"iss\" *: *\"([a-zA-Z0-9]*)\""));
        extractSubjectRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"sub\" *: *\"([a-zA-Z0-9]*)\""));
        extractExpirationRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"exp\" *: *([0-9]+)"));
        extractNotBeforeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"nbf\" *: *([0-9]+)"));
        extractIssuedAtRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"iat\" *: *([0-9]+)"));
        extractJwtIdRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"jti\" *: *\"([a-zA-Z0-9]*)\""));
        clearStartRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\{ *,"));
        clearMiddleRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(", *(?=,)"));
        clearEndRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(", *\\}"));
    }

    @Override
    public String encode(String header, String claim) {
        return JwtCore.encode$((JwtCore)this, header, claim);
    }

    @Override
    public String encode(String header, String claim, String key, JwtAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, header, claim, key, algorithm);
    }

    @Override
    public String encode(String header, String claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, header, claim, key, algorithm);
    }

    @Override
    public String encode(String header, String claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, header, claim, key, algorithm);
    }

    @Override
    public String encode(String claim) {
        return JwtCore.encode$((JwtCore)this, claim);
    }

    @Override
    public String encode(String claim, String key, JwtAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, claim, key, algorithm);
    }

    @Override
    public String encode(String claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, claim, key, algorithm);
    }

    @Override
    public String encode(String claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, claim, key, algorithm);
    }

    @Override
    public String encode(JwtClaim claim) {
        return JwtCore.encode$((JwtCore)this, claim);
    }

    @Override
    public String encode(JwtClaim claim, String key, JwtAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, claim, key, algorithm);
    }

    @Override
    public String encode(JwtClaim claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, claim, key, algorithm);
    }

    @Override
    public String encode(JwtClaim claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return JwtCore.encode$((JwtCore)this, claim, key, algorithm);
    }

    @Override
    public String encode(JwtHeader header, JwtClaim claim) {
        return JwtCore.encode$((JwtCore)this, header, claim);
    }

    @Override
    public String encode(JwtHeader header, JwtClaim claim, String key) {
        return JwtCore.encode$((JwtCore)this, header, claim, key);
    }

    @Override
    public String encode(JwtHeader header, JwtClaim claim, Key key) {
        return JwtCore.encode$((JwtCore)this, header, claim, key);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token) {
        return JwtCore.decodeRawAll$(this, token);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key) {
        return JwtCore.decodeRawAll$((JwtCore)this, token, key);
    }

    @Override
    public Try<String> decodeRaw(String token, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, options);
    }

    @Override
    public Try<String> decodeRaw(String token) {
        return JwtCore.decodeRaw$(this, token);
    }

    @Override
    public Try<String> decodeRaw(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<String> decodeRaw(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<String> decodeRaw(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<String> decodeRaw(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<String> decodeRaw(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<String> decodeRaw(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<String> decodeRaw(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<String> decodeRaw(String token, SecretKey key) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key);
    }

    @Override
    public Try<String> decodeRaw(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<String> decodeRaw(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<String> decodeRaw(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<String> decodeRaw(String token, PublicKey key) {
        return JwtCore.decodeRaw$((JwtCore)this, token, key);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token) {
        return JwtCore.decodeAll$(this, token);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, SecretKey key) {
        return JwtCore.decodeAll$((JwtCore)this, token, key);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decodeAll$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<Tuple3<JwtHeader, JwtClaim, String>> decodeAll(String token, PublicKey key) {
        return JwtCore.decodeAll$((JwtCore)this, token, key);
    }

    @Override
    public Try<JwtClaim> decode(String token, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, options);
    }

    @Override
    public Try<JwtClaim> decode(String token) {
        return JwtCore.decode$(this, token);
    }

    @Override
    public Try<JwtClaim> decode(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<JwtClaim> decode(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<JwtClaim> decode(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<JwtClaim> decode(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<JwtClaim> decode(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<JwtClaim> decode(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<JwtClaim> decode(String token, SecretKey key, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<JwtClaim> decode(String token, SecretKey key) {
        return JwtCore.decode$((JwtCore)this, token, key);
    }

    @Override
    public Try<JwtClaim> decode(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public Try<JwtClaim> decode(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.decode$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public Try<JwtClaim> decode(String token, PublicKey key, JwtOptions options) {
        return JwtCore.decode$((JwtCore)this, token, key, options);
    }

    @Override
    public Try<JwtClaim> decode(String token, PublicKey key) {
        return JwtCore.decode$((JwtCore)this, token, key);
    }

    @Override
    public void validateTiming(Object claim, JwtOptions options) {
        JwtCore.validateTiming$(this, claim, options);
    }

    @Override
    public boolean validateHmacAlgorithm(JwtHmacAlgorithm algorithm, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.validateHmacAlgorithm$(this, algorithm, algorithms);
    }

    @Override
    public boolean validateAsymmetricAlgorithm(JwtAsymmetricAlgorithm algorithm, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.validateAsymmetricAlgorithm$(this, algorithm, algorithms);
    }

    @Override
    public void validate(Object header, Object claim, String signature, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, header, claim, signature, options);
    }

    @Override
    public void validate(String header64, Object header, String claim64, Object claim, String signature, JwtOptions options, Function3 verify) {
        JwtCore.validate$(this, header64, header, claim64, claim, signature, options, verify);
    }

    @Override
    public void validate(String header64, Object header, String claim64, Object claim, String signature, String key, Seq algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, header64, header, claim64, claim, signature, key, algorithms, options);
    }

    @Override
    public void validate(String header64, Object header, String claim64, Object claim, String signature, String key, Function0 algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, header64, header, claim64, claim, signature, key, algorithms, options);
    }

    @Override
    public void validate(String header64, Object header, String claim64, Object claim, String signature, SecretKey key, Seq algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, header64, header, claim64, claim, signature, key, algorithms, options);
    }

    @Override
    public void validate(String header64, Object header, String claim64, Object claim, String signature, PublicKey key, Seq algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, header64, header, claim64, claim, signature, key, algorithms, options);
    }

    @Override
    public void validate(String token, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, options);
    }

    @Override
    public void validate(String token) {
        JwtCore.validate$(this, token);
    }

    @Override
    public void validate(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public void validate(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public void validate(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public void validate(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public void validate(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public void validate(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public void validate(String token, SecretKey key, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, key, options);
    }

    @Override
    public void validate(String token, SecretKey key) {
        JwtCore.validate$((JwtCore)this, token, key);
    }

    @Override
    public void validate(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public void validate(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        JwtCore.validate$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public void validate(String token, PublicKey key, JwtOptions options) {
        JwtCore.validate$((JwtCore)this, token, key, options);
    }

    @Override
    public void validate(String token, PublicKey key) {
        JwtCore.validate$((JwtCore)this, token, key);
    }

    @Override
    public boolean isValid(String token, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, options);
    }

    @Override
    public boolean isValid(String token) {
        return JwtCore.isValid$(this, token);
    }

    @Override
    public boolean isValid(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public boolean isValid(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public boolean isValid(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public boolean isValid(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public boolean isValid(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public boolean isValid(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public boolean isValid(String token, SecretKey key, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, key, options);
    }

    @Override
    public boolean isValid(String token, SecretKey key) {
        return JwtCore.isValid$((JwtCore)this, token, key);
    }

    @Override
    public boolean isValid(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms, options);
    }

    @Override
    public boolean isValid(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.isValid$((JwtCore)this, token, key, algorithms);
    }

    @Override
    public boolean isValid(String token, PublicKey key, JwtOptions options) {
        return JwtCore.isValid$((JwtCore)this, token, key, options);
    }

    @Override
    public boolean isValid(String token, PublicKey key) {
        return JwtCore.isValid$((JwtCore)this, token, key);
    }

    @Override
    public Clock clock() {
        return clock;
    }

    @Override
    public void pdi$jwt$JwtCore$_setter_$clock_$eq(Clock x$1) {
        clock = x$1;
    }

    public Jwt apply(Clock clock) {
        return new Jwt(clock);
    }

    private Regex extractAlgorithmRegex() {
        return extractAlgorithmRegex;
    }

    @Override
    public Option<JwtAlgorithm> extractAlgorithm(String header) {
        return this.extractAlgorithmRegex().findFirstMatchIn((CharSequence)header).map((Function1 & Serializable)x$1 -> x$1.group(1)).flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            String string = x0$1;
            if ("none".equals(string)) {
                none$ = None$.MODULE$;
            } else if (string != null) {
                String string2 = string;
                none$ = new Some((Object)JwtAlgorithm$.MODULE$.fromString(string2));
            } else {
                throw new MatchError((Object)string);
            }
            return none$;
        });
    }

    private Regex extractIssuerRegex() {
        return extractIssuerRegex;
    }

    public Option<String> extractIssuer(String claim) {
        return this.extractIssuerRegex().findFirstMatchIn((CharSequence)claim).map((Function1 & Serializable)x$2 -> x$2.group(1));
    }

    private Regex extractSubjectRegex() {
        return extractSubjectRegex;
    }

    public Option<String> extractSubject(String claim) {
        return this.extractSubjectRegex().findFirstMatchIn((CharSequence)claim).map((Function1 & Serializable)x$3 -> x$3.group(1));
    }

    private Regex extractExpirationRegex() {
        return extractExpirationRegex;
    }

    @Override
    public Option<Object> extractExpiration(String claim) {
        return this.extractExpirationRegex().findFirstMatchIn((CharSequence)claim).map((Function1 & Serializable)x$4 -> x$4.group(1)).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$5))));
    }

    private Regex extractNotBeforeRegex() {
        return extractNotBeforeRegex;
    }

    @Override
    public Option<Object> extractNotBefore(String claim) {
        return this.extractNotBeforeRegex().findFirstMatchIn((CharSequence)claim).map((Function1 & Serializable)x$6 -> x$6.group(1)).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7))));
    }

    private Regex extractIssuedAtRegex() {
        return extractIssuedAtRegex;
    }

    public Option<Object> extractIssuedAt(String claim) {
        return this.extractIssuedAtRegex().findFirstMatchIn((CharSequence)claim).map((Function1 & Serializable)x$8 -> x$8.group(1)).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9))));
    }

    private Regex extractJwtIdRegex() {
        return extractJwtIdRegex;
    }

    public Option<String> extractJwtId(String claim) {
        return this.extractJwtIdRegex().findFirstMatchIn((CharSequence)claim).map((Function1 & Serializable)x$10 -> x$10.group(1));
    }

    private Regex clearStartRegex() {
        return clearStartRegex;
    }

    public String clearStart(String json) {
        return this.clearStartRegex().replaceFirstIn((CharSequence)json, "{");
    }

    private Regex clearMiddleRegex() {
        return clearMiddleRegex;
    }

    public String clearMiddle(String json) {
        return this.clearMiddleRegex().replaceAllIn((CharSequence)json, "");
    }

    private Regex clearEndRegex() {
        return clearEndRegex;
    }

    public String clearEnd(String json) {
        return this.clearEndRegex().replaceFirstIn((CharSequence)json, "}");
    }

    public String clearRegex(String json, Regex regex) {
        return regex.replaceFirstIn((CharSequence)json, "");
    }

    public String clearAll(String json2) {
        String dirtyJson = (String)((LinearSeqOps)new .colon.colon((Object)this.extractIssuerRegex(), (List)new .colon.colon((Object)this.extractSubjectRegex(), (List)new .colon.colon((Object)this.extractExpirationRegex(), (List)new .colon.colon((Object)this.extractNotBeforeRegex(), (List)new .colon.colon((Object)this.extractIssuedAtRegex(), (List)new .colon.colon((Object)this.extractJwtIdRegex(), (List)Nil$.MODULE$))))))).foldLeft((Object)json2, (Function2 & Serializable)(json, regex) -> MODULE$.clearRegex((String)json, (Regex)regex));
        return this.clearStart(this.clearEnd(this.clearMiddle(dirtyJson)));
    }

    @Override
    public JwtHeader parseHeader(String header) {
        return JwtHeader$.MODULE$.apply(this.extractAlgorithm(header));
    }

    @Override
    public JwtClaim parseClaim(String claim) {
        String x$1 = this.clearAll(claim);
        Option<String> x$2 = this.extractIssuer(claim);
        Option<String> x$3 = this.extractSubject(claim);
        Option<Object> x$4 = this.extractExpiration(claim);
        Option<Object> x$5 = this.extractNotBefore(claim);
        Option<Object> x$6 = this.extractIssuedAt(claim);
        Option<String> x$7 = this.extractJwtId(claim);
        Option<Set<String>> x$8 = JwtClaim$.MODULE$.apply$default$4();
        return JwtClaim$.MODULE$.apply(x$1, x$2, x$3, x$8, x$4, x$5, x$6, x$7);
    }

    public String headerToJson(JwtHeader header) {
        return header.toJson();
    }

    public String claimToJson(JwtClaim claim) {
        return claim.toJson();
    }

    @Override
    public Option<JwtAlgorithm> extractAlgorithm(JwtHeader header) {
        return header.algorithm();
    }

    @Override
    public Option<Object> extractExpiration(JwtClaim claim) {
        return claim.expiration();
    }

    @Override
    public Option<Object> extractNotBefore(JwtClaim claim) {
        return claim.notBefore();
    }

    private Jwt$() {
    }
}

