/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.playframework.cachecontrol.CacheControlException;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.CurrentAgeCalculator$;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import org.playframework.cachecontrol.StoredResponse;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000554Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)a\u0004\u0001C\u0001s!)!\f\u0001C\u00017\")Q\f\u0001C\u0001=\u001e)\u0001\r\u0004E\u0001C\u001a)1\u0002\u0004E\u0001E\")!d\u0002C\u0001G\"9Am\u0002b\u0001\n\u0013)\u0007B\u00027\bA\u0003%aM\u0001\u000bDkJ\u0014XM\u001c;BO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u0003\u001b9\tAbY1dQ\u0016\u001cwN\u001c;s_2T!a\u0004\t\u0002\u001bAd\u0017-\u001f4sC6,wo\u001c:l\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011\u0001D\u0001\u0014G\u0006d7-\u001e7bi\u0016\u001cUO\u001d:f]R\fu-\u001a\u000b\u0006A\rBSf\u000e\t\u0003;\u0005J!A\t\u0007\u0003\u000fM+7m\u001c8eg\")AE\u0001a\u0001K\u00059!/Z9vKN$\bCA\u000f'\u0013\t9CB\u0001\u0007DC\u000eDWMU3rk\u0016\u001cH\u000fC\u0003*\u0005\u0001\u0007!&\u0001\u0005sKN\u0004xN\\:f!\ti2&\u0003\u0002-\u0019\tq1\u000b^8sK\u0012\u0014Vm\u001d9p]N,\u0007\"\u0002\u0018\u0003\u0001\u0004y\u0013a\u0003:fcV,7\u000f\u001e+j[\u0016\u0004\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\tQLW.\u001a\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014GA\u0007[_:,G\rR1uKRKW.\u001a\u0005\u0006q\t\u0001\raL\u0001\re\u0016\u001c\bo\u001c8tKRKW.\u001a\u000b\u0006Ai2\u0006,\u0017\u0005\u0006w\r\u0001\r\u0001P\u0001\bQ\u0016\fG-\u001a:t!\u0011iDi\u0012&\u000f\u0005y\u0012\u0005CA \u0017\u001b\u0005\u0001%BA!\u0013\u0003\u0019a$o\\8u}%\u00111IF\u0001\u0007!J,G-\u001a4\n\u0005\u00153%aA'ba*\u00111I\u0006\t\u0003;!K!!\u0013\u0007\u0003\u0015!+\u0017\rZ3s\u001d\u0006lW\rE\u0002L!Ns!\u0001\u0014(\u000f\u0005}j\u0015\"A\f\n\u0005=3\u0012a\u00029bG.\fw-Z\u0005\u0003#J\u00131aU3r\u0015\tye\u0003\u0005\u0002>)&\u0011QK\u0012\u0002\u0007'R\u0014\u0018N\\4\t\u000b]\u001b\u0001\u0019A\u0018\u0002\u00079|w\u000fC\u0003/\u0007\u0001\u0007q\u0006C\u00039\u0007\u0001\u0007q&A\tdC2\u001cW\u000f\\1uK\u0006;WMV1mk\u0016$\"\u0001\t/\t\u000bm\"\u0001\u0019\u0001\u001f\u0002%\r\fGnY;mCR,G)\u0019;f-\u0006dW/\u001a\u000b\u0003_}CQaO\u0003A\u0002q\nAcQ;se\u0016tG/Q4f\u0007\u0006d7-\u001e7bi>\u0014\bCA\u000f\b'\t9A\u0003F\u0001b\u0003\u0019awnZ4feV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002j!\u0005)1\u000f\u001c45U&\u00111\u000e\u001b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0001")
public class CurrentAgeCalculator {
    public Seconds calculateCurrentAge(CacheRequest request, StoredResponse response, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        return this.calculateCurrentAge(response.headers(), HttpDate$.MODULE$.now(), requestTime, responseTime);
    }

    public Seconds calculateCurrentAge(Map<HeaderName, Seq<String>> headers, ZonedDateTime now, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        Seconds currentAge;
        block1: {
            if (CurrentAgeCalculator$.MODULE$.org$playframework$cachecontrol$CurrentAgeCalculator$$logger().isTraceEnabled()) {
                CurrentAgeCalculator$.MODULE$.org$playframework$cachecontrol$CurrentAgeCalculator$$logger().trace("calculateCurrentAge(headers: " + headers + ", now: " + now + ", requestTime: " + requestTime + ", responseTime: " + responseTime + ")");
            }
            Seconds ageValue = this.calculateAgeValue(headers);
            ZonedDateTime dateValue = this.calculateDateValue(headers);
            Seconds apparentAge = responseTime.isAfter(dateValue) ? Seconds$.MODULE$.between(dateValue, responseTime) : Seconds$.MODULE$.ZERO();
            Seconds responseDelay = Seconds$.MODULE$.between(requestTime, responseTime);
            Seconds correctedAgeValue = ageValue.plus(responseDelay);
            long a = Math.max(apparentAge.seconds(), correctedAgeValue.seconds());
            Seconds correctedInitialAge = Seconds$.MODULE$.seconds(a);
            Seconds residentTime = Seconds$.MODULE$.between(responseTime, now);
            currentAge = correctedInitialAge.plus(residentTime);
            if (!CurrentAgeCalculator$.MODULE$.org$playframework$cachecontrol$CurrentAgeCalculator$$logger().isTraceEnabled()) break block1;
            CurrentAgeCalculator$.MODULE$.org$playframework$cachecontrol$CurrentAgeCalculator$$logger().trace("calculateCurrentAge: currentAge = " + currentAge);
        }
        return currentAge;
    }

    public Seconds calculateAgeValue(Map<HeaderName, Seq<String>> headers) {
        return (Seconds)headers.get((Object)HeaderNames$.MODULE$.Age()).flatMap((Function1 & Serializable)x$1 -> x$1.headOption()).map((Function1 & Serializable)age -> Seconds$.MODULE$.seconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(age)))).getOrElse((Function0 & Serializable)() -> Seconds$.MODULE$.ZERO());
    }

    public ZonedDateTime calculateDateValue(Map<HeaderName, Seq<String>> headers) {
        Option result = headers.get((Object)HeaderNames$.MODULE$.Date()).flatMap((Function1 & Serializable)dateValues -> dateValues.headOption().map((Function1 & Serializable)firstDateValue -> HttpDate$.MODULE$.parse((String)firstDateValue)));
        return (ZonedDateTime)result.getOrElse((Function0 & Serializable)() -> {
            String msg = "Date header is required for age calculation! (see RFC7231, 7.1.1.2)";
            throw new CacheControlException(msg);
        });
    }
}

