/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirective;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheDirectives$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.CacheResponse;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\b\u0010\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006E\u0001!\ta\t\u0005\bM\u0001\u0011\r\u0011\"\u0003(\u0011\u0019q\u0003\u0001)A\u0005Q!)q\u0006\u0001C\u0001a!)a\b\u0001C\u0001\u007f!)Q\t\u0001C\u0005\r\"9\u0001\u0010AI\u0001\n\u0013I\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u00026\u0001!\t!a\u000e\u0003'\u0019\u0013Xm\u001d5oKN\u001c8)\u00197dk2\fGo\u001c:\u000b\u0005A\t\u0012\u0001D2bG\",7m\u001c8ue>d'B\u0001\n\u0014\u00035\u0001H.Y=ge\u0006lWm^8sW*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\fQaY1dQ\u0016\u0004\"a\b\u0011\u000e\u0003=I!!I\b\u0003\u000b\r\u000b7\r[3\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002 \u0001!)QD\u0001a\u0001=\u00051An\\4hKJ,\u0012\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003WM\tQa\u001d7gi)L!!\f\u0016\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n!dY1mGVd\u0017\r^3Ge\u0016\u001c\bN\\3tg2Kg-\u001a;j[\u0016$2!\r\u001b:!\ty\"'\u0003\u00024\u001f\t91+Z2p]\u0012\u001c\b\"B\u001b\u0006\u0001\u00041\u0014a\u0002:fcV,7\u000f\u001e\t\u0003?]J!\u0001O\b\u0003\u0019\r\u000b7\r[3SKF,Xm\u001d;\t\u000bi*\u0001\u0019A\u001e\u0002\u0011I,7\u000f]8og\u0016\u0004\"a\b\u001f\n\u0005uz!!D\"bG\",'+Z:q_:\u001cX-A\u000fjg\u001a\u0013Xm\u001d5oKN\u001c\u0018J\u001c4pe6\fG/[8o\u0013:4\u0018\r\\5e)\r\u00015\t\u0012\t\u00031\u0005K!AQ\r\u0003\u000f\t{w\u000e\\3b]\")QG\u0002a\u0001m!)!H\u0002a\u0001w\u0005\u00112m\u001c8uC&t7\u000fR;qY&\u001c\u0017\r^3t)\r\u0001u\t\u0017\u0005\u0006\u0011\u001e\u0001\r!S\u0001\u000bI&\u0014Xm\u0019;jm\u0016\u001c\bc\u0001&S+:\u00111\n\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dV\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005EK\u0012a\u00029bG.\fw-Z\u0005\u0003'R\u00131aU3r\u0015\t\t\u0016\u0004\u0005\u0002 -&\u0011qk\u0004\u0002\u000f\u0007\u0006\u001c\u0007.\u001a#je\u0016\u001cG/\u001b<f\u0011\u001dIv\u0001%AA\u0002i\u000bAa]3f]B\u00191l\u00182\u000f\u0005qk\u0006C\u0001'\u001a\u0013\tq\u0016$\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u00141aU3u\u0015\tq\u0016\u0004\r\u0002dQB\u00191\f\u001a4\n\u0005\u0015\f'!B\"mCN\u001c\bCA4i\u0019\u0001!\u0011\"\u001b-\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\u0007}#\u0013'\u0005\u0002l]B\u0011\u0001\u0004\\\u0005\u0003[f\u0011qAT8uQ&tw\r\u0005\u0002\u0019_&\u0011\u0001/\u0007\u0002\u0004\u0003:L\bFA\u0004s!\t\u0019h/D\u0001u\u0015\t)\u0018$\u0001\u0006b]:|G/\u0019;j_:L!a\u001e;\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006a2m\u001c8uC&t7\u000fR;qY&\u001c\u0017\r^3tI\u0011,g-Y;mi\u0012\u0012T#\u0001>+\u0007m\f\t\u0001E\u0002\\?r\u0004$!`@\u0011\u0007m#g\u0010\u0005\u0002h\u007f\u0012I\u0011\u000eCA\u0001\u0002\u0003\u0015\tA[\u0016\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013!\u0018!C;oG\",7m[3e\u0013\u0011\ti!a\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fdC2\u001cW\u000f\\1uK\u001a\u0013Xm\u001d5oKN\u001chI]8n'6\u000b\u00070Q4f)\u0019\t\u0019\"!\u0007\u0002\u001cA!\u0001$!\u00062\u0013\r\t9\"\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bUJ\u0001\u0019\u0001\u001c\t\u000biJ\u0001\u0019A\u001e\u00029\r\fGnY;mCR,gI]3tQ:,7o\u001d$s_6l\u0015\r_!hKR1\u00111CA\u0011\u0003GAQ!\u000e\u0006A\u0002YBQA\u000f\u0006A\u0002m\nQdY1mGVd\u0017\r^3Ge\u0016\u001c\bN\\3tg\u001a\u0013x.\\#ya&\u0014Xm\u001d\u000b\u0007\u0003'\tI#a\u000b\t\u000bUZ\u0001\u0019\u0001\u001c\t\u000biZ\u0001\u0019A\u001e\u0002?\r\fGnY;mCR,gI]3tQ:,7o\u001d$s_6DU-\u001e:jgRL7\r\u0006\u0004\u0002\u0014\u0005E\u00121\u0007\u0005\u0006k1\u0001\rA\u000e\u0005\u0006u1\u0001\raO\u0001\u000bk:\f\u0007\u000f\u001d7z'\u0016\fH\u0003BA\n\u0003sAQ\u0001S\u0007A\u0002%\u0003")
public class FreshnessCalculator {
    private final Cache cache;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public Seconds calculateFreshnessLifetime(CacheRequest request, CacheResponse response) {
        None$ none$;
        if (this.logger().isTraceEnabled()) {
            this.logger().trace("calculateFreshnessLifetime: ");
        }
        if (this.isFreshnessInformationInvalid(request, response)) {
            none$ = None$.MODULE$;
        } else {
            Option freshnessLifetime = this.calculateFreshnessFromSMaxAge(request, response).orElse((Function0 & Serializable)() -> this.calculateFreshnessFromMaxAge(request, response)).orElse((Function0 & Serializable)() -> this.calculateFreshnessFromExpires(request, response)).orElse((Function0 & Serializable)() -> this.calculateFreshnessFromHeuristic(request, response));
            this.logger().debug("calculateFreshnessLifetime: freshnessLifetime = " + freshnessLifetime);
            none$ = freshnessLifetime;
        }
        None$ maybeResult = none$;
        Seconds result = (Seconds)maybeResult.getOrElse((Function0 & Serializable)() -> Seconds$.MODULE$.ZERO());
        this.logger().debug("calculateFreshnessLifetime: result = " + result);
        return result;
    }

    public boolean isFreshnessInformationInvalid(CacheRequest request, CacheResponse response) {
        Map<HeaderName, Seq<String>> responseHeaders = response.headers();
        Seq<CacheDirective> directives = response.directives();
        if (responseHeaders.get((Object)HeaderNames$.MODULE$.Expires()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FreshnessCalculator.$anonfun$isFreshnessInformationInvalid$1(x$1)))) {
            this.logger().debug("isFreshnessInformationInvalid: duplicate Expires headers found, returning true");
            return true;
        }
        if (this.containsDuplicates(directives, this.containsDuplicates$default$2())) {
            this.logger().debug("isFreshnessInformationInvalid: duplicate directives found in " + directives + ", returning true");
            return true;
        }
        return false;
    }

    private boolean containsDuplicates(Seq<CacheDirective> directives, Set<Class<?>> seen) {
        List list;
        while ((list = directives) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            CacheDirective x = (CacheDirective)colon2.head();
            List xs = colon2.next$access$1();
            if (seen.contains(x.getClass())) {
                return true;
            }
            seen = (Set)seen.$plus(x.getClass());
            directives = xs;
        }
        return false;
    }

    private Set<Class<?>> containsDuplicates$default$2() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public Option<Seconds> calculateFreshnessFromSMaxAge(CacheRequest request, CacheResponse response) {
        if (this.cache.isShared()) {
            return CacheDirectives$.MODULE$.sMaxAge(response.directives()).map((Function1 & Serializable)x$2 -> x$2.delta());
        }
        return None$.MODULE$;
    }

    public Option<Seconds> calculateFreshnessFromMaxAge(CacheRequest request, CacheResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).map((Function1 & Serializable)x$3 -> x$3.delta());
    }

    public Option<Seconds> calculateFreshnessFromExpires(CacheRequest request, CacheResponse response) {
        Map<HeaderName, Seq<String>> headers = response.headers();
        return headers.get((Object)HeaderNames$.MODULE$.Expires()).flatMap((Function1 & Serializable)expiresList -> {
            None$ none$;
            String dateString = (String)((IterableOps)headers.getOrElse((Object)HeaderNames$.MODULE$.Date(), (Function0 & Serializable)() -> {
                throw new RuntimeException("No Date header found!");
            })).head();
            try {
                ZonedDateTime expires = HttpDate$.MODULE$.parse((String)expiresList.head());
                ZonedDateTime date = HttpDate$.MODULE$.parse(dateString);
                Seconds expiresDuration = HttpDate$.MODULE$.diff(date, expires);
                this.logger().debug("calculateFreshnessFromExpires: expiresDuration = " + expiresDuration);
                none$ = new Some((Object)expiresDuration);
            }
            catch (Exception e) {
                this.logger().error("calculateFreshnessFromExpires: HTTP date parsing failed", (Throwable)e);
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request, CacheResponse response) {
        return this.cache.calculateFreshnessFromHeuristic(request, response);
    }

    public Option<Seconds> unapplySeq(Seq<CacheDirective> directives) {
        .colon.colon colon2;
        CacheDirective cacheDirective;
        Seq<CacheDirective> seq = directives;
        if (seq instanceof .colon.colon && (cacheDirective = (CacheDirective)(colon2 = (.colon.colon)seq).head()) instanceof CacheDirectives.SMaxAge) {
            CacheDirectives.SMaxAge sMaxAge2 = (CacheDirectives.SMaxAge)cacheDirective;
            Seconds delta = sMaxAge2.delta();
            return new Some((Object)delta);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$isFreshnessInformationInvalid$1(Seq x$1) {
        return x$1.size() > 1;
    }

    public FreshnessCalculator(Cache cache) {
        this.cache = cache;
        this.logger = LoggerFactory.getLogger((String)"org.playframework.cachecontrol.FreshnessCalculator");
    }
}

