/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$PROTOCOL_ERROR$;
import scala.runtime.Nothing$;

@InternalApi
public final class Http2Compliance$ {
    public static final Http2Compliance$ MODULE$ = new Http2Compliance$();

    public final Nothing$ missingHttpIdHeaderException() {
        throw new Http2Compliance.MissingHttpIdHeaderException();
    }

    public void validateMaxFrameSize(int value) {
        if (value < 16384) {
            throw new Http2Compliance.Http2ProtocolException(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, new StringBuilder(74).append("MAX_FRAME_SIZE MUST NOT be < than ").append(16384).append(", attempted setting to: ").append(value).append("!").toString());
        }
        if (value > 0xFFFFFF) {
            throw new Http2Compliance.Http2ProtocolException(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, new StringBuilder(77).append("MAX_FRAME_SIZE MUST NOT be > than ").append(0xFFFFFF).append(", attempted setting to: ").append(value).append("!").toString());
        }
    }

    public final void requireZeroStreamId(int id) {
        if (id != 0) {
            throw new Http2Compliance.IllegalHttp2StreamIdException(id, "MUST BE == 0.");
        }
    }

    public final void requireNonZeroStreamId(int id) {
        if (id == 0) {
            throw new Http2Compliance.Http2ProtocolException(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, "Stream ID MUST be > 0");
        }
    }

    public final void requirePositiveWindowUpdateIncrement(int streamId, int increment) {
        if (increment <= 0) {
            if (streamId == 0) {
                throw new Http2Compliance.Http2ProtocolException(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, new StringBuilder(32).append("WINDOW_UPDATE MUST be > 0, was: ").append(increment).toString());
            }
            throw new Http2Compliance.Http2ProtocolStreamException(streamId, Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, new StringBuilder(32).append("WINDOW_UPDATE MUST be > 0, was: ").append(increment).toString());
        }
    }

    public final boolean isClientInitiatedStreamId(int id) {
        return id % 2 != 0;
    }

    public final void requireFrameSize(int size, int max2) {
        if (size != max2) {
            throw new Http2Compliance.IllegalHttp2FrameSize(size, new StringBuilder(12).append("MUST BE == ").append(max2).append(".").toString());
        }
    }

    public final void requireNoSelfDependency(int id, int dependency) {
        if (id == dependency) {
            throw new Http2Compliance.IllegalHttp2StreamDependency(id);
        }
    }

    private Http2Compliance$() {
    }
}

