/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource;

import java.util.HashMap;
import java.util.Iterator;
import tyrex.resource.Resource;
import tyrex.resource.ResourceConfig;
import tyrex.resource.ResourceException;
import tyrex.tm.TransactionDomain;

public final class Resources {
    private final HashMap _config;
    private final HashMap _resources = new HashMap();
    private TransactionDomain _txDomain;

    public Resources() {
        this._config = new HashMap();
    }

    public void setTransactionDomain(TransactionDomain transactionDomain) {
        this._txDomain = transactionDomain;
    }

    public synchronized void addConfiguration(ResourceConfig resourceConfig) throws ResourceException {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("Argument config is null");
        }
        if (this._config.containsKey(resourceConfig.getName())) {
            throw new ResourceException("A resource with the name " + resourceConfig.getName() + " already installed");
        }
        this._config.put(resourceConfig.getName(), resourceConfig);
    }

    public Iterator listConfigurations() {
        return this._config.values().iterator();
    }

    public boolean hasResource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        return this._resources.containsKey(string);
    }

    public Iterator listResources() {
        return this._config.keySet().iterator();
    }

    public synchronized Resource getResource(String string) throws ResourceException {
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        Resource resource = (Resource)this._resources.get(string);
        if (resource == null) {
            ResourceConfig resourceConfig = (ResourceConfig)this._config.get(string);
            if (resourceConfig == null) {
                return null;
            }
            TransactionDomain transactionDomain = this._txDomain;
            if (transactionDomain == null) {
                throw new ResourceException("Must call setTransactionDomain() before calling getResource()");
            }
            resource = resourceConfig.createResource(transactionDomain);
            this._resources.put(string, resource);
        }
        return resource;
    }

    public synchronized void removeResource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        this._config.remove(string);
        Resource resource = (Resource)this._resources.remove(string);
        if (resource != null) {
            resource.destroy();
        }
    }
}

