/*
 * Decompiled with CFR 0.152.
 */
package play.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SourceProvider {
    public static final Object UNKNOWN_SOURCE = "[unknown source]";
    private final Set<String> classNamesToSkip;
    public static final SourceProvider DEFAULT_INSTANCE = new SourceProvider(Collections.singleton(SourceProvider.class.getName()));

    private SourceProvider(Collection<String> collection) {
        this.classNamesToSkip = Collections.unmodifiableSet(new HashSet<String>(collection));
    }

    public SourceProvider plusSkippedClasses(Class ... classArray) {
        HashSet<String> hashSet = new HashSet<String>(this.classNamesToSkip);
        hashSet.addAll(SourceProvider.asStrings(classArray));
        return new SourceProvider(hashSet);
    }

    private static List<String> asStrings(Class ... classArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Class clazz : classArray) {
            arrayList.add(clazz.getName());
        }
        return arrayList;
    }

    public StackTraceElement get() {
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            String string = stackTraceElement.getClassName();
            if (this.classNamesToSkip.contains(string)) continue;
            return stackTraceElement;
        }
        throw new AssertionError();
    }
}

