/*
 * Decompiled with CFR 0.152.
 */
package catchment.controller;

import catchment.constant.CatchmentExportConstants$;
import catchment.domain.ExportEvolutionParam;
import catchment.domain.ExportEvolutionParam$;
import catchment.itf.CatchmentExportDao;
import controllers.fileExport.XLSorCSVExportController;
import fr.aquasys.daeau.catchment.model.CatchmentPoint;
import fr.aquasys.daeau.export.ExportedData;
import fr.aquasys.daeau.export.ExportedData$;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.itf.UserHabilitationDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.util.Base64;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\u0006\f\u0001AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001\u0007\u0005\tI\u0001\u0011\t\u0011)A\u0006K!Aq\u0006\u0001B\u0001B\u0003-\u0001\u0007\u0003\u00054\u0001\t\u0005\t\u0015a\u00035\u0011!9\u0004A!A!\u0002\u0017A\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b1B!\t\u000b\u0019\u0003A\u0011A$\t\u000bi\u0003A\u0011B.\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\t\u00192)\u0019;dQ6,g\u000e^\"p]R\u0014x\u000e\u001c7fe*\u0011A\"D\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\b\u0002\u0013\r\fGo\u00195nK:$8\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u00033\tj\u0011A\u0007\u0006\u00037q\tA!\u001e;jY*\u0011QDH\u0001\te\u0006\u0014'-\u001b;nc*\u0011q\u0004I\u0001\bCF,\u0018m]=t\u0015\u0005\t\u0013A\u00014s\u0013\t\u0019#DA\u0004M_\u001e,F/\u001b7\u0002\u000fU\u001cXM\u001d#b_B\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0004SR4'B\u0001\u0016,\u0003\u0011)8/\u001a:\u000b\u00051r\u0012!\u00023bK\u0006,\u0018B\u0001\u0018(\u0005\u001d)6/\u001a:EC>\f1#^:fe\"\u000b'-\u001b7ji\u0006$\u0018n\u001c8EC>\u0004\"AJ\u0019\n\u0005I:#aE+tKJD\u0015MY5mSR\fG/[8o\t\u0006|\u0017AD;tKJ\u001cF/\u0019;j_:$\u0015m\u001c\t\u0003MUJ!AN\u0014\u0003\u001dU\u001bXM]*uCRLwN\u001c#b_\u0006A\u0002\u0010T*pe\u000e\u001bf+\u0012=q_J$8i\u001c8ue>dG.\u001a:\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014A\u00034jY\u0016,\u0005\u0010]8si*\tQ(A\u0006d_:$(o\u001c7mKJ\u001c\u0018BA ;\u0005aAFjU8s\u0007N3V\t\u001f9peR\u001cuN\u001c;s_2dWM]\u0001\u0013G\u0006$8\r[7f]R,\u0005\u0010]8si\u0012\u000bw\u000e\u0005\u0002C\t6\t1I\u0003\u0002)\u001b%\u0011Qi\u0011\u0002\u0013\u0007\u0006$8\r[7f]R,\u0005\u0010]8si\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0002\u0011R9\u0011j\u0013'N\u001d>\u0003\u0006C\u0001&\u0001\u001b\u0005Y\u0001\"B\f\b\u0001\bA\u0002\"\u0002\u0013\b\u0001\b)\u0003\"B\u0018\b\u0001\b\u0001\u0004\"B\u001a\b\u0001\b!\u0004\"B\u001c\b\u0001\bA\u0004\"\u0002!\b\u0001\b\t\u0005FA\u0004S!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0004j]*,7\r\u001e\u0006\u0002/\u0006)!.\u0019<bq&\u0011\u0011\f\u0016\u0002\u0007\u0013:TWm\u0019;\u0002\u0013\u001d,G\u000fU8j]R\u001cHc\u0001/poB\u0019Q,\u001a5\u000f\u0005y\u001bgBA0c\u001b\u0005\u0001'BA1\u0010\u0003\u0019a$o\\8u}%\tA#\u0003\u0002e'\u00059\u0001/Y2lC\u001e,\u0017B\u00014h\u0005\r\u0019V-\u001d\u0006\u0003IN\u0001\"![7\u000e\u0003)T!a\u001b7\u0002\u000b5|G-\u001a7\u000b\u00059Y\u0013B\u00018k\u00059\u0019\u0015\r^2i[\u0016tG\u000fU8j]RDQ\u0001\u001d\u0005A\u0002E\fa\u0001]1sC6\u001c\bC\u0001:v\u001b\u0005\u0019(B\u0001;\u000e\u0003\u0019!w.\\1j]&\u0011ao\u001d\u0002\u0015\u000bb\u0004xN\u001d;Fm>dW\u000f^5p]B\u000b'/Y7\t\u000b)B\u0001\u0019\u0001=\u0011\u0005elhB\u0001>|!\ty6#\u0003\u0002}'\u00051\u0001K]3eK\u001aL!A`@\u0003\rM#(/\u001b8h\u0015\ta8#A\bfqB|'\u000f^#w_2,H/[8o)%A\u0018QAA\u0011\u0003c\t)\u0004C\u0004\u0002\b%\u0001\r!!\u0003\u0002\u000f5,7o]1hKB!\u00111BA\u000f\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00026t_:TA!a\u0005\u0002\u0016\u0005!A.\u001b2t\u0015\u0011\t9\"!\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0002\u001c\u0005!\u0001\u000f\\1z\u0013\u0011\ty\"!\u0004\u0003\u000f)\u001bh+\u00197vK\"9\u00111E\u0005A\u0002\u0005\u0015\u0012a\u00025fC\u0012,'o\u001d\t\u0007s\u0006\u001d\u00020a\u000b\n\u0007\u0005%rPA\u0002NCB\u00042AEA\u0017\u0013\r\tyc\u0005\u0002\u0004\u0003:L\bBBA\u001a\u0013\u0001\u0007\u00010\u0001\u0004n_\u0012,H.\u001a\u0005\u0006U%\u0001\r\u0001\u001f\u0015\u0004\u0001\u0005e\u0002cA*\u0002<%\u0019\u0011Q\b+\u0003\u0013MKgn\u001a7fi>t\u0007")
public class CatchmentController {
    private final LogUtil logUtil;
    private final UserDao userDao;
    private final UserHabilitationDao userHabilitationDao;
    private final UserStationDao userStationDao;
    private final XLSorCSVExportController xLSorCSVExportController;
    private final CatchmentExportDao catchmentExportDao;

    private Seq<CatchmentPoint> getPoints(ExportEvolutionParam params, String user) {
        if (this.userDao.isAdmin(user)) {
            return this.catchmentExportDao.getAllQualitometerPoint(params);
        }
        if (this.userHabilitationDao.hasHabilitation(user, "CATCHMENT")) {
            Seq<CatchmentPoint> points = this.catchmentExportDao.getAllQualitometerPoint(params);
            if (this.userHabilitationDao.hasHabilitation(user, "CATCHMENT_ALL")) {
                return points;
            }
            Seq ids = (Seq)this.userStationDao.getCodes(user, StationTypeUtil$.MODULE$.CATCHMENT()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1))));
            return (Seq)points.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ids.contains((Object)BoxesRunTime.boxToInteger((int)p.id()))));
        }
        return (Seq)Nil$.MODULE$;
    }

    public String exportEvolution(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ExportEvolutionParam$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validate object for export evolution : ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Seq catchmentPoints = this.getPoints((ExportEvolutionParam)params, user);
            Map groupPoints = catchmentPoints.groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()));
            Seq filteredPoints = BoxesRunTime.unboxToBoolean((Object)params.useOnlyMainPoint().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (Seq)catchmentPoints.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)CatchmentController.$anonfun$exportEvolution$5(groupPoints, p))) : catchmentPoints;
            Seq<Seq<ExportedData>> data = $this.catchmentExportDao.getDataExportEvolution((ExportEvolutionParam)params, (Seq<CatchmentPoint>)filteredPoints, user);
            Seq seq = (Seq)CatchmentExportConstants$.MODULE$.exportEvolutionHeaders().map((Function1 & Serializable)l -> new ExportedData((Option)new Some(l), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()));
            Seq dataWithHeaders = (Seq)data.$plus$colon((Object)seq);
            byte[] formattedData = $this.xLSorCSVExportController.exportFile(params.exportType(), (Seq<Seq<ExportedData>>)dataWithHeaders);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"file"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"Comparaisons des \u00e9volutions des contaminations", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extension"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)params.exportType(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new String(Base64.getEncoder().encode(formattedData)), (Writes)Writes$.MODULE$.StringWrites()))})), (Writes)JsObject$.MODULE$.writes()))})).toString();
        });
    }

    public static final /* synthetic */ boolean $anonfun$exportEvolution$5(Map groupPoints$1, CatchmentPoint p) {
        return ((SeqOps)groupPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)p.id()))).length() == 1 || BoxesRunTime.unboxToBoolean((Object)p.mainPoint().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    @Inject
    public CatchmentController(LogUtil logUtil, UserDao userDao, UserHabilitationDao userHabilitationDao, UserStationDao userStationDao, XLSorCSVExportController xLSorCSVExportController, CatchmentExportDao catchmentExportDao) {
        this.logUtil = logUtil;
        this.userDao = userDao;
        this.userHabilitationDao = userHabilitationDao;
        this.userStationDao = userStationDao;
        this.xLSorCSVExportController = xLSorCSVExportController;
        this.catchmentExportDao = catchmentExportDao;
    }
}

