/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import constants.StationTypeConstants$;
import domain.GenerateModelPdf$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.JobLogUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.inject.Inject;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JsonDataSource;
import org.joda.time.DateTime;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.matching.Regex;
import util.ExportFileUtils$;

@ScalaSignature(bytes="\u0006\u0005I4A!\u0003\u0006\u0001\u001b!AA\u0003\u0001B\u0001B\u0003-Q\u0003\u0003\u0005\"\u0001\t\u0005\t\u0015a\u0003#\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u001dA\u0004A1A\u0005\u0002eBa!\u0015\u0001!\u0002\u0013Q\u0004\"\u0002*\u0001\t\u0003\u0019\u0006\"B3\u0001\t\u00131\u0007\"\u00027\u0001\t\u0003i'!F#ya>\u0014H/T8eK2\u001cuN\u001c;s_2dWM\u001d\u0006\u0002\u0017\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"AF\u0010\u000e\u0003]Q!\u0001G\r\u0002\tU$\u0018\u000e\u001c\u0006\u00035m\t\u0001B]1cE&$X.\u001d\u0006\u00039u\tq!Y9vCNL8OC\u0001\u001f\u0003\t1'/\u0003\u0002!/\t9Aj\\4Vi&d\u0017A\u0003&pE2{w-\u0016;jYB\u00111EJ\u0007\u0002I)\u0011QeG\u0001\u0006kRLGn]\u0005\u0003O\u0011\u0012!BS8c\u0019><W\u000b^5m\u0003\u0019a\u0014N\\5u}Q\t!\u0006F\u0002,[9\u0002\"\u0001\f\u0001\u000e\u0003)AQ\u0001F\u0002A\u0004UAQ!I\u0002A\u0004\tB#a\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014AB5oU\u0016\u001cGOC\u00016\u0003\u0015Q\u0017M^1y\u0013\t9$G\u0001\u0004J]*,7\r^\u0001\u0011gR\fG/[8o)f\u0004XMU3bIN,\u0012A\u000f\t\u0004w\u00113U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00026t_:T!a\u0010!\u0002\t1L'm\u001d\u0006\u0003\u0003\n\u000b1!\u00199j\u0015\u0005\u0019\u0015\u0001\u00029mCfL!!\u0012\u001f\u0003\u000bI+\u0017\rZ:\u0011\u0005\u001dseB\u0001%M!\tI\u0005#D\u0001K\u0015\tYE\"\u0001\u0004=e>|GOP\u0005\u0003\u001bB\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011Q\nE\u0001\u0012gR\fG/[8o)f\u0004XMU3bIN\u0004\u0013aE4fi6{G-\u001a7GS2,7OQ=UsB,G#\u0002$U3\u0006\u001c\u0007\"B+\u0007\u0001\u00041\u0016aB7fgN\fw-\u001a\t\u0003w]K!\u0001\u0017\u001f\u0003\u000f)\u001bh+\u00197vK\")!L\u0002a\u00017\u00069\u0001.Z1eKJ\u001c\b\u0003B$]\rzK!!\u0018)\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u0010?&\u0011\u0001\r\u0005\u0002\u0004\u0003:L\b\"\u00022\u0007\u0001\u00041\u0015AB7pIVdW\rC\u0003e\r\u0001\u0007a)\u0001\u0003vg\u0016\u0014\u0018AE3yiJ\f7\r\u001e&bgB,'OR5mKN$\"a\u001a6\u0011\u000b=AgI\u0012$\n\u0005%\u0004\"A\u0002+va2,7\u0007C\u0003l\u000f\u0001\u0007a)A\u0007n_\u0012,GNR5mK:\u000bW.Z\u0001\u0011O\u0016tWM]1uK6{G-\u001a7QI\u001a$RA\u00128paFDQ!\u0016\u0005A\u0002YCQA\u0017\u0005A\u0002mCQA\u0019\u0005A\u0002\u0019CQ\u0001\u001a\u0005A\u0002\u0019\u0003")
public class ExportModelController {
    private final LogUtil logUtil;
    private final JobLogUtil JobLogUtil;
    private final Reads<String> stationTypeReads;

    public Reads<String> stationTypeReads() {
        return this.stationTypeReads;
    }

    public String getModelFilesByType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.stationTypeReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Can't parse json on getting Model Files by type: ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.toJson((Object)Nil$.MODULE$, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString();
        }, (Function1 & Serializable)stationType -> {
            Option envDirectory = package$.MODULE$.env().get((Object)"MODELS_DIRECTORY");
            Option option = envDirectory;
            if (option instanceof Some) {
                String string;
                Some some = (Some)option;
                String directory = (String)some.value();
                String string2 = stationType;
                String string3 = StationTypeConstants$.MODULE$.STATION_TYPE_PIEZOMETER();
                String string4 = string2;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    string = new StringBuilder(12).append(directory).append("PIEZOMETRIE/").toString();
                } else {
                    String string5 = StationTypeConstants$.MODULE$.STATION_TYPE_QUALITOMETER();
                    String string6 = string2;
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        string = new StringBuilder(8).append(directory).append("QUALITE/").toString();
                    } else {
                        String string7 = StationTypeConstants$.MODULE$.STATION_TYPE_HYDROMETER();
                        String string8 = string2;
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            string = new StringBuilder(12).append(directory).append("HYDROMETRIE/").toString();
                        } else {
                            String string9 = StationTypeConstants$.MODULE$.STATION_TYPE_PLUVIOMETER();
                            String string10 = string2;
                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                string = new StringBuilder(13).append(directory).append("PLUVIOMETRIE/").toString();
                            } else {
                                String string11 = StationTypeConstants$.MODULE$.STATION_TYPE_QUALITOMETER_RESEARCH();
                                String string12 = string2;
                                string = !(string11 != null ? !string11.equals(string12) : string12 != null) ? new StringBuilder(15).append(directory).append("QUALITE/BILANS/").toString() : directory;
                            }
                        }
                    }
                }
                String modelsDirectory = string;
                File file = new File(modelsDirectory);
                if (file.exists() && file.isDirectory()) {
                    return Json$.MODULE$.toJson((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile()))), (Function1 & Serializable)x$2 -> x$2.getName(), ClassTag$.MODULE$.apply(String.class))).toList(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString();
                }
                return Json$.MODULE$.toJson((Object)Nil$.MODULE$, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.toJson((Object)Nil$.MODULE$, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    private Tuple3<String, String, String> extractJasperFiles(String modelFileName) {
        File modelFile = (File)ExportFileUtils$.MODULE$.getModelFile(new StringBuilder(4).append(modelFileName).append(".zip").toString(), "bulletins").getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(39).append("Can't find Jasper zip project on FTP : ").append(modelFileName).toString());
        });
        String zipDir = modelFile.getAbsolutePath().replace(modelFile.getName(), "");
        String exportTmpDir = new StringBuilder(4).append((String)package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> {
            throw new Exception("EXPORT_DIRECTORY is not in .env");
        })).append("tmp/").toString();
        String jasperDir = new StringBuilder(1).append(exportTmpDir).append(modelFile.getName().replace(".zip", "")).append("_").append(new DateTime().getMillis()).toString();
        String zipCMD = new StringBuilder(15).append("unzip -d \"").append(jasperDir).append("\" \"").append(modelFile.getName()).append("\" ").toString();
        this.logUtil.debug(new StringBuilder(29).append("Extract jasper cmd : ").append(zipCMD).append(" in dir ").append(zipDir).toString(), this.logUtil.debug$default$2());
        FileUtil$.MODULE$.runCMDInScript(zipDir, (Seq)new .colon.colon((Object)zipCMD, (List)Nil$.MODULE$), this.logUtil);
        File mainJasperFile = (File)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])new File(jasperDir).listFiles()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExportModelController.$anonfun$extractJasperFiles$3(modelFileName, x$3))).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(46).append("Unable to find the file ").append(modelFileName).append(".jasper on zip archive").toString());
        });
        this.logUtil.debug(new StringBuilder(36).append("path mainJapserFile : ").append(mainJasperFile.getAbsolutePath()).append(", jasperDir : ").append(jasperDir).toString(), this.logUtil.debug$default$2());
        return new Tuple3((Object)zipDir, (Object)mainJasperFile.getAbsolutePath(), (Object)jasperDir);
    }

    public String generateModelPdf(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(GenerateModelPdf$.MODULE$.generateModelPdfRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Can't parse json on getting Model Files by type: ").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.toJson((Object)Nil$.MODULE$, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString();
        }, (Function1 & Serializable)generateModelPdf -> {
            Object object;
            boolean jasperExists;
            HashMap params = new HashMap();
            ByteArrayInputStream targetStream = new ByteArrayInputStream(generateModelPdf.pdfJsonString().getBytes("UTF-8"));
            JsonDataSource jsonDataSource = new JsonDataSource((InputStream)targetStream);
            File file = new File(generateModelPdf.outFile());
            FileOutputStream outputStream = new FileOutputStream(file);
            if (generateModelPdf.jobExecutionId().isDefined()) {
                $this.JobLogUtil.log(BoxesRunTime.unboxToLong((Object)generateModelPdf.jobExecutionId().get()), JobState$.MODULE$.INFO(), "Start generating the pdf from the template", "", $this.JobLogUtil.log$default$5());
            }
            if (jasperExists = new File(generateModelPdf.fileNameJasper()).exists()) {
                JasperPrint jasperPrint = JasperFillManager.fillReport((String)generateModelPdf.fileNameJasper(), params, (JRDataSource)jsonDataSource);
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                object = BoxedUnit.UNIT;
            } else {
                Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("BULLETINS/(.*?)\\.jasper"));
                String fileNameJasper = (String)pattern.findFirstMatchIn((CharSequence)generateModelPdf.fileNameJasper()).map((Function1 & Serializable)x$4 -> x$4.group(1)).getOrElse((Function0 & Serializable)() -> "");
                Tuple3<String, String, String> tuple3 = this.extractJasperFiles(fileNameJasper);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                String zipDir = (String)tuple3._1();
                String mainJasperPath = (String)tuple3._2();
                String jasperDir = (String)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)zipDir, (Object)mainJasperPath, (Object)jasperDir);
                String zipDir2 = (String)tuple32._1();
                String mainJasperPath2 = (String)tuple32._2();
                String jasperDir2 = (String)tuple32._3();
                JasperPrint jasperPrint = JasperFillManager.fillReport((String)mainJasperPath2, params, (JRDataSource)jsonDataSource);
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                object = FileUtil$.MODULE$.runCMDInScript(zipDir2, (Seq)new .colon.colon((Object)new StringBuilder(10).append("rm -rf \"").append(jasperDir2).append("\" ").toString(), (List)Nil$.MODULE$), $this.logUtil);
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetPath"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)generateModelPdf.outFile(), (Writes)Writes$.MODULE$.StringWrites()))})).toString();
        });
    }

    public static final /* synthetic */ boolean $anonfun$extractJasperFiles$3(String modelFileName$1, File x$3) {
        String string = x$3.getName();
        String string2 = new StringBuilder(7).append(modelFileName$1).append(".jasper").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public ExportModelController(LogUtil logUtil, JobLogUtil JobLogUtil2) {
        this.logUtil = logUtil;
        this.JobLogUtil = JobLogUtil2;
        this.stationTypeReads = JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads());
    }
}

