/*
 * Decompiled with CFR 0.152.
 */
package controllers.exportTmp.stationModelFile;

import constants.ExtensionTypeConstants$;
import controllers.exportTmp.stationModelFile.ExportStationModelFileParams;
import controllers.exportTmp.stationModelFile.StationModelsGlobalParams;
import controllers.exportTmp.stationModelFile.StationModelsGlobalParams$;
import controllers.fileExport.JasperStationExportController;
import controllers.fileExport.ModelFileExportController;
import fr.aquasys.daeau.export.exportTmp.ExportTmp;
import fr.aquasys.daeau.export.exportTmp.ExportTmpDao;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.MathUtil$;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import util.ExportFileUtils$;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0002\u0005\u0001\u001f!Aa\u0003\u0001B\u0001B\u0003-q\u0003\u0003\u0005$\u0001\t\u0005\t\u0015a\u0003%\u0011!Q\u0003A!A!\u0002\u0017Y\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b1B\u001b\t\u000ba\u0002A\u0011A\u001d\t\u000b)\u0003A\u0011A&\u0003A\u0015C\bo\u001c:u'R\fG/[8o\u001b>$W\r\u001c$jY\u0016\u001cuN\u001c;s_2dWM\u001d\u0006\u0003\u0013)\t\u0001c\u001d;bi&|g.T8eK24\u0015\u000e\\3\u000b\u0005-a\u0011!C3ya>\u0014H\u000fV7q\u0015\u0005i\u0011aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\fq\u0001\\8h+RLG\u000e\u0005\u0002\u0019C5\t\u0011D\u0003\u0002\u001b7\u0005!Q\u000f^5m\u0015\taR$\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\tqr$A\u0004bcV\f7/_:\u000b\u0003\u0001\n!A\u001a:\n\u0005\tJ\"a\u0002'pOV#\u0018\u000e\\\u0001\u001a[>$W\r\u001c$jY\u0016,\u0005\u0010]8si\u000e{g\u000e\u001e:pY2,'\u000f\u0005\u0002&Q5\taE\u0003\u0002(\u0019\u0005Qa-\u001b7f\u000bb\u0004xN\u001d;\n\u0005%2#!G'pI\u0016dg)\u001b7f\u000bb\u0004xN\u001d;D_:$(o\u001c7mKJ\fA\"\u001a=q_J$H+\u001c9EC>\u0004\"\u0001\f\u001a\u000e\u00035R!a\u0003\u0018\u000b\u0005=\u0002\u0014AB3ya>\u0014HO\u0003\u00022;\u0005)A-Y3bk&\u00111'\f\u0002\r\u000bb\u0004xN\u001d;U[B$\u0015m\\\u0001\u001e\u0015\u0006\u001c\b/\u001a:Ti\u0006$\u0018n\u001c8FqB|'\u000f^\"p]R\u0014x\u000e\u001c7feB\u0011QEN\u0005\u0003o\u0019\u0012QDS1ta\u0016\u00148\u000b^1uS>tW\t\u001f9peR\u001cuN\u001c;s_2dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\"RaO\u001f?\u007f\u0001\u0003\"\u0001\u0010\u0001\u000e\u0003!AQAF\u0003A\u0004]AQaI\u0003A\u0004\u0011BQAK\u0003A\u0004-BQ\u0001N\u0003A\u0004UB#!\u0002\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015AB5oU\u0016\u001cGOC\u0001H\u0003\u0015Q\u0017M^1y\u0013\tIEI\u0001\u0004J]*,7\r^\u0001\u001bKb\u0004xN\u001d;Ti\u0006$\u0018n\u001c8t\u001b>$W\r\u001c$jY\u0016T\u0016\u000e\u001d\u000b\u0005\u0019^[\u0006\r\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fJi\u0011\u0001\u0015\u0006\u0003#:\ta\u0001\u0010:p_Rt\u0014BA*\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0013\u0002\"B\u0006\u0007\u0001\u0004A\u0006C\u0001\u0017Z\u0013\tQVFA\u0005FqB|'\u000f\u001e+na\")AL\u0002a\u0001;\u0006q!n\u001c2Fq\u0016\u001cW\u000f^5p]&#\u0007CA\t_\u0013\ty&C\u0001\u0003M_:<\u0007\"B1\u0007\u0001\u0004a\u0015\u0001B;tKJ\u0004")
public class ExportStationModelFileController {
    private final LogUtil logUtil;
    private final ModelFileExportController modelFileExportController;
    private final ExportTmpDao exportTmpDao;
    private final JasperStationExportController JasperStationExportController;

    public String exportStationsModelFileZip(ExportTmp exportTmp, long jobExecutionId, String user) {
        return (String)Json$.MODULE$.parse((String)exportTmp.params().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No params");
        })).validate(StationModelsGlobalParams$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(28).append("Bad parameters for export : ").append(error.toString()).toString(), "");
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            throw new Exception("Bad input");
        }, (Function1 & Serializable)params -> {
            String dirName = new StringBuilder(20).append("export_stationModel_").append(new DateTime().getMillis()).toString();
            if (new File(new StringBuilder(1).append(ExportFileUtils$.MODULE$.getTmpExportDirectoryName()).append("/").append(dirName).toString()).exists()) {
                FileUtil$.MODULE$.rmFiles(new StringBuilder(1).append(ExportFileUtils$.MODULE$.getTmpExportDirectoryName()).append("/").append(dirName).toString());
            }
            String dirCMD = new StringBuilder(6).append("mkdir ").append(dirName).toString();
            FileUtil$.MODULE$.runCMDInScript(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), (Seq)new .colon.colon((Object)dirCMD, (List)Nil$.MODULE$), $this.logUtil);
            if (params.exportData().isEmpty()) {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing to export", "");
                throw new Exception("Nothing to export");
            }
            String appUrl = (String)package$.MODULE$.env().getOrElse((Object)"URL_UTILS", (Function0 & Serializable)() -> {
                throw new Exception("URL_UTILS is not in env");
            });
            ((IterableOnceOps)params.exportData().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExportStationModelFileController.$anonfun$exportStationsModelFileZip$5(this, params, user, appUrl, dirName, jobExecutionId, exportTmp, x0$1)));
            String exportDir = (String)params.exportDir().getOrElse((Function0 & Serializable)() -> "EXPORT/tmp");
            if (params.noZip().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                FileUtil$.MODULE$.runCMDInScript(exportDir, (Seq)new .colon.colon((Object)new StringBuilder(8).append("mv ").append(dirName).append("/* ./").toString(), (List)Nil$.MODULE$), $this.logUtil);
                return "NOFILE";
            }
            String zipCMD = new StringBuilder(12).append("zip -r ").append(dirName).append(".zip ").append(dirName).toString();
            String rmCMD = new StringBuilder(6).append("rm -r ").append(dirName).toString();
            FileUtil$.MODULE$.runCMDInScript(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), (Seq)new .colon.colon((Object)zipCMD, (List)new .colon.colon((Object)rmCMD, (List)Nil$.MODULE$)), $this.logUtil);
            JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "Zip generated with success", "");
            String string = new StringBuilder(15).append("EXPORT/tmp/").append(dirName).append(".zip").toString();
            String string2 = new StringBuilder(5).append(exportDir).append("/").append(dirName).append(".zip").toString();
            Object object = (string == null ? string2 != null : !string.equals(string2)) ? FileUtil$.MODULE$.runCMDInScript((String)package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> {
                throw new Exception("UPLOAD_DIRECTORY is not in .env");
            }), (Seq)new .colon.colon((Object)new StringBuilder(24).append("mv EXPORT/tmp/").append(dirName).append(".zip ").append(exportDir).append("/").append(dirName).append(".zip").toString(), (List)Nil$.MODULE$), $this.logUtil) : BoxedUnit.UNIT;
            return new StringBuilder(5).append(exportDir).append("/").append(dirName).append(".zip").toString();
        });
    }

    public static final /* synthetic */ int $anonfun$exportStationsModelFileZip$7(ExportStationModelFileParams x$1) {
        return x$1.station().id();
    }

    public static final /* synthetic */ int $anonfun$exportStationsModelFileZip$5(ExportStationModelFileController $this, StationModelsGlobalParams params$1, String user$1, String appUrl$1, String dirName$1, long jobExecutionId$1, ExportTmp exportTmp$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ExportStationModelFileParams r = (ExportStationModelFileParams)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                boolean bl;
                String exportType;
                String string = exportType = (String)r.exportType().get();
                String string2 = ExtensionTypeConstants$.MODULE$.ZIP_FOR_JASPER();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    Right right;
                    Tuple2 tuple2;
                    Left left;
                    Tuple2 tuple22;
                    Option<DateTime> x$12 = params$1.startDate();
                    Option<DateTime> x$2 = params$1.endDate();
                    Option<Object> x$3 = params$1.threshold();
                    Option<String> x$4 = params$1.selectionCode();
                    Option<Seq<String>> x$5 = params$1.parameters();
                    Option<Seq<Object>> x$6 = params$1.producers();
                    Option<Object> x$7 = params$1.campaign();
                    Some x$8 = new Some(params$1.exportData().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ExportStationModelFileController.$anonfun$exportStationsModelFileZip$7(x$1))));
                    Option x$9 = QualityFilter$.MODULE$.$lessinit$greater$default$2();
                    Option x$10 = QualityFilter$.MODULE$.$lessinit$greater$default$3();
                    Option x$11 = QualityFilter$.MODULE$.$lessinit$greater$default$4();
                    Option x$122 = QualityFilter$.MODULE$.$lessinit$greater$default$5();
                    Option x$13 = QualityFilter$.MODULE$.$lessinit$greater$default$6();
                    Option x$14 = QualityFilter$.MODULE$.$lessinit$greater$default$9();
                    Option x$15 = QualityFilter$.MODULE$.$lessinit$greater$default$10();
                    Option x$16 = QualityFilter$.MODULE$.$lessinit$greater$default$12();
                    Option x$17 = QualityFilter$.MODULE$.$lessinit$greater$default$13();
                    Option x$18 = QualityFilter$.MODULE$.$lessinit$greater$default$14();
                    Option x$19 = QualityFilter$.MODULE$.$lessinit$greater$default$15();
                    Option x$20 = QualityFilter$.MODULE$.$lessinit$greater$default$16();
                    Option x$21 = QualityFilter$.MODULE$.$lessinit$greater$default$17();
                    Option x$22 = QualityFilter$.MODULE$.$lessinit$greater$default$18();
                    Option x$23 = QualityFilter$.MODULE$.$lessinit$greater$default$19();
                    Option x$24 = QualityFilter$.MODULE$.$lessinit$greater$default$22();
                    Option x$25 = QualityFilter$.MODULE$.$lessinit$greater$default$23();
                    Option x$26 = QualityFilter$.MODULE$.$lessinit$greater$default$25();
                    Option x$27 = QualityFilter$.MODULE$.$lessinit$greater$default$27();
                    Option x$28 = QualityFilter$.MODULE$.$lessinit$greater$default$28();
                    Option x$29 = QualityFilter$.MODULE$.$lessinit$greater$default$29();
                    Option x$30 = QualityFilter$.MODULE$.$lessinit$greater$default$30();
                    Option x$31 = QualityFilter$.MODULE$.$lessinit$greater$default$31();
                    Option x$32 = QualityFilter$.MODULE$.$lessinit$greater$default$32();
                    Option x$33 = QualityFilter$.MODULE$.$lessinit$greater$default$33();
                    Option x$34 = QualityFilter$.MODULE$.$lessinit$greater$default$34();
                    Option x$35 = QualityFilter$.MODULE$.$lessinit$greater$default$35();
                    Option x$36 = QualityFilter$.MODULE$.$lessinit$greater$default$36();
                    Option x$37 = QualityFilter$.MODULE$.$lessinit$greater$default$37();
                    QualityFilter qualityFilter = new QualityFilter((Option)x$8, x$9, x$10, x$11, x$122, x$13, x$5, x$3, x$14, x$15, x$6, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$12, x$2, x$24, x$25, x$4, x$26, x$7, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37);
                    Either<Tuple2<String, JsValue>, Tuple2<String, JsValue>> either = $this.JasperStationExportController.exportJasperModel(r.station().id(), r.station().stationType(), params$1.model().replace(".zip", "").replace(".ZIP", ""), user$1, params$1.startDate(), params$1.endDate(), (Option<QualityFilter>)new Some((Object)qualityFilter));
                    if (either instanceof Left && (tuple22 = (Tuple2)(left = (Left)either).value()) != null) {
                        String targetPath = (String)tuple22._1();
                        String stationPdfName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(targetPath), '/')));
                        String stationJsonName = stationPdfName.replace(".pdf", ".json");
                        .colon.colon cmd = appUrl$1.contains("dev.sieau.fr") || appUrl$1.contains("integration.sieau.fr") ? new .colon.colon((Object)new StringBuilder(5).append("mv ").append(stationPdfName).append(" ").append(dirName$1).append("/").append(stationPdfName).toString(), (List)new .colon.colon((Object)new StringBuilder(5).append("mv ").append(stationJsonName).append(" ").append(dirName$1).append("/").append(stationJsonName).toString(), (List)Nil$.MODULE$)) : new .colon.colon((Object)new StringBuilder(5).append("mv ").append(stationPdfName).append(" ").append(dirName$1).append("/").append(stationPdfName).toString(), (List)Nil$.MODULE$);
                        FileUtil$.MODULE$.runCMDInScript(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), (Seq)cmd, $this.logUtil);
                        return stationPdfName;
                    }
                    if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                        String error = (String)tuple2._1();
                        throw new Exception(error);
                    }
                    throw new MatchError(either);
                }
                String string4 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLS();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLSX();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        bl = true;
                    } else {
                        String string8 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLSM();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            bl = true;
                        } else {
                            String string10 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_WORD();
                            String string11 = string;
                            bl = !(string10 != null ? !string10.equals(string11) : string11 != null);
                        }
                    }
                }
                if (bl) {
                    String ext = new StringBuilder(1).append(".").append(exportType).toString();
                    String filename = (String)r.filename().get();
                    byte[] result = $this.modelFileExportController.prepareExportFile(r, params$1.model(), params$1.startDate(), params$1.endDate());
                    Option<File> file = ExportFileUtils$.MODULE$.getFile(new StringBuilder(1).append(ExportFileUtils$.MODULE$.getTmpExportDirectoryName()).append("/").append(dirName$1).toString(), new StringBuilder(0).append(filename).append(ext).toString());
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream((File)file.get()));
                    bos.write(result);
                    bos.close();
                    return new StringBuilder(0).append(filename).append(ext).toString();
                }
                $this.logUtil.error("No Export Type to export job :\n", $this.logUtil.error$default$2());
                return "error";
            });
            if (try_ instanceof Success) {
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(16).append("File exported : ").append(r.station().code().getOrElse((Function0 & Serializable)() -> "")).toString(), (String)r.station().code().getOrElse((Function0 & Serializable)() -> ""));
                return $this.exportTmpDao.setProgress(exportTmp$1.id(), MathUtil$.MODULE$.roundAt2((double)(100 * (index + 1) / params$1.exportData().length())));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                JobLogUtil$.MODULE$.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(34).append("Error during export for station : ").append(r.station().code().getOrElse((Function0 & Serializable)() -> "")).toString(), (String)r.station().code().getOrElse((Function0 & Serializable)() -> ""));
                $this.logUtil.printError(err);
                throw err;
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public ExportStationModelFileController(LogUtil logUtil, ModelFileExportController modelFileExportController, ExportTmpDao exportTmpDao, JasperStationExportController JasperStationExportController2) {
        this.logUtil = logUtil;
        this.modelFileExportController = modelFileExportController;
        this.exportTmpDao = exportTmpDao;
        this.JasperStationExportController = JasperStationExportController2;
    }
}

