/*
 * Decompiled with CFR 0.152.
 */
package controllers.fileExport;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import controllers.fileExport.ModelFileExportController;
import domain.modelExport.ModelExportInput;
import domain.modelExport.StationModelExport;
import domain.modelExport.StationModelExport$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.campaign.itf.CampaignDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.measure.PiezometerChronicRawMeasure;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.quality.chronicAnalysis.PrettyAnalysisLight;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.daeau.quality.domain.SelectionParameterOutput;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.itf.SelectionDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.quality.operation.QualityOperation;
import fr.aquasys.daeau.quality.threshold.ParameterThreshold;
import fr.aquasys.daeau.quality.threshold.ThresholdDao;
import fr.aquasys.daeau.referentials.methode.itf.MethodDao;
import fr.aquasys.daeau.referentials.methode.model.Method;
import fr.aquasys.daeau.referentials.parameter.domain.Parameter;
import fr.aquasys.daeau.referentials.parameter.domain.Selection;
import fr.aquasys.daeau.referentials.parameter.itf.ParameterDao;
import fr.aquasys.daeau.referentials.sandreCode.constants.SandreConstants$;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.referentials.unit.itf.UnitDao;
import fr.aquasys.daeau.referentials.unit.model.Unit;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.links.landmark.StationLandmarkDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.PiezometryUtils$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import model.bookmark.HydroBookmarkBuilder;
import model.bookmark.MapOfBookmarks;
import model.bookmark.PiezoBookmarkBuilder;
import model.bookmark.PluvioBookmarkBuilder;
import model.bookmark.QualitoBookmarkBuilder;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JsonDataSource;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import util.ExportFileUtils$;

@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B\u0010!\u0001\u0015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006Y!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0006\u0001\"AA\t\u0001B\u0001B\u0003-Q\t\u0003\u0005N\u0001\t\u0005\t\u0015a\u0003O\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b1\u0002,\t\u0011e\u0003!\u0011!Q\u0001\fiC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Y!\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0006[\"Aq\u000f\u0001B\u0001B\u0003-\u0001\u0010\u0003\u0005|\u0001\t\u0005\t\u0015a\u0003}\u0011)\t9\u0001\u0001B\u0001B\u0003-\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\f\u0005M\u0001BCA\u0010\u0001\t\u0005\t\u0015a\u0003\u0002\"!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006Y!!\u000e\t\u0015\u0005\r\u0003A!A!\u0002\u0017\t)\u0005\u0003\u0006\u0002T\u0001\u0011\t\u0011)A\u0006\u0003+B!\"!\u001a\u0001\u0005\u0003\u0005\u000b1BA4\u0011)\ti\u0007\u0001B\u0001B\u0003-\u0011q\u000e\u0005\b\u0003{\u0002A\u0011AA@\u0011%\ti\f\u0001b\u0001\n\u0003\ty\f\u0003\u0005\u0003\f\u0001\u0001\u000b\u0011BAa\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001fAqAa\r\u0001\t\u0003\u0011)\u0004C\u0004\u0003\u0000\u0001!\tA!!\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\"9!q\u0015\u0001\u0005\n\t%\u0006b\u0002BY\u0001\u0011%!1\u0017\u0005\b\u0005\u0003\u0004A\u0011\u0001Bb\u0011\u001d\u0011y\u000f\u0001C\u0001\u0005c\u0014QDS1ta\u0016\u00148\u000b^1uS>tW\t\u001f9peR\u001cuN\u001c;s_2dWM\u001d\u0006\u0003C\t\n!BZ5mK\u0016C\bo\u001c:u\u0015\u0005\u0019\u0013aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001aE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u00177\u001b\u0005q#BA\u00181\u0003\r\t\u0007/\u001b\u0006\u0003cI\n\u0001B]1cE&$X.\u001d\u0006\u0003gQ\nq!Y9vCNL8OC\u00016\u0003\t1'/\u0003\u00028]\tA\u0001K]8ek\u000e,'/A\u0004m_\u001e,F/\u001b7\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0002\u0014\u0001B;uS2L!AP\u001e\u0003\u000f1{w-\u0016;jY\u0006IRj\u001c3fY\u001aKG.Z#ya>\u0014HoQ8oiJ|G\u000e\\3s!\t\t%)D\u0001!\u0013\t\u0019\u0005EA\rN_\u0012,GNR5mK\u0016C\bo\u001c:u\u0007>tGO]8mY\u0016\u0014\u0018\u0001\u00069jKj|'i\\8l[\u0006\u00148NQ;jY\u0012,'\u000f\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006A!m\\8l[\u0006\u00148NC\u0001K\u0003\u0015iw\u000eZ3m\u0013\tauI\u0001\u000bQS\u0016TxNQ8pW6\f'o\u001b\"vS2$WM]\u0001\u0017cV\fG.\u001b;p\u0005>|7.\\1sW\n+\u0018\u000e\u001c3feB\u0011aiT\u0005\u0003!\u001e\u0013a#U;bY&$xNQ8pW6\f'o\u001b\"vS2$WM]\u0001\u0016a2,h/[8C_>\\W.\u0019:l\u0005VLG\u000eZ3s!\t15+\u0003\u0002U\u000f\n)\u0002\u000b\\;wS>\u0014un\\6nCJ\\')^5mI\u0016\u0014\u0018\u0001\u00065zIJ|'i\\8l[\u0006\u00148NQ;jY\u0012,'\u000f\u0005\u0002G/&\u0011\u0001l\u0012\u0002\u0015\u0011f$'o\u001c\"p_.l\u0017M]6Ck&dG-\u001a:\u0002\u001fE,\u0018\r\\5u_6,G/\u001a:EC>\u0004\"a\u00172\u000e\u0003qS!!\u00180\u0002\u0007%$hM\u0003\u0002`A\u00069\u0011/^1mSRL(BA13\u0003\u0015!\u0017-Z1v\u0013\t\u0019GLA\bRk\u0006d\u0017\u000e^8nKR,'\u000fR1p\u00035\u0001\u0018.\u001a>p[\u0016$XM\u001d#b_B\u0011aM[\u0007\u0002O*\u0011Q\f\u001b\u0006\u0003S\u0002\f!\u0002]5fu>lW\r\u001e:z\u0013\tYwMA\bQS\u0016Tx.\\3uKJ$\u0015-Z1v\u0003I\u0019H/\u0019;j_:d\u0015M\u001c3nCJ\\G)Y8\u0011\u00059,X\"A8\u000b\u0005A\f\u0018\u0001\u00037b]\u0012l\u0017M]6\u000b\u0005I\u001c\u0018!\u00027j].\u001c(B\u0001;a\u0003\u001d\u0019H/\u0019;j_:L!A^8\u0003%M#\u0018\r^5p]2\u000bg\u000eZ7be.$\u0015m\\\u0001\u0015a&,'p\\7fi\u0016\u0014X*Z1tkJ,G)Y8\u0011\u0005\u0019L\u0018B\u0001>h\u0005Q\u0001\u0016.\u001a>p[\u0016$XM]'fCN,(/\u001a#b_\u0006\u00112+[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p!\ri\u00181A\u0007\u0002}*\u0011Ql \u0006\u0004\u0003\u0003\u0001\u0017AD1e[&t\u0017n\u001d;sCRLwN\\\u0005\u0004\u0003\u000bq(AE*jK\u0006,\b+\u0019:b[\u0016$XM]:EC>\f!\"];bY&$\u0018\u0010R1p!\u0011\tY!!\u0004\u000e\u0003yK1!a\u0004_\u0005)\tV/\u00197jif$\u0015m\\\u0001\ri\"\u0014Xm\u001d5pY\u0012$\u0015m\u001c\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u00040\u0002\u0013QD'/Z:i_2$\u0017\u0002BA\u000f\u0003/\u0011A\u0002\u00165sKNDw\u000e\u001c3EC>\fA\u0002]1sC6,G/\u001a:EC>\u0004B!a\t\u000205\u0011\u0011Q\u0005\u0006\u0004;\u0006\u001d\"\u0002BA\u0015\u0003W\t\u0011\u0002]1sC6,G/\u001a:\u000b\u0007\u00055\u0002-\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7/\u0003\u0003\u00022\u0005\u0015\"\u0001\u0004)be\u0006lW\r^3s\t\u0006|\u0017aB;oSR$\u0015m\u001c\t\u0005\u0003o\ty$\u0004\u0002\u0002:)\u0019Q,a\u000f\u000b\t\u0005u\u00121F\u0001\u0005k:LG/\u0003\u0003\u0002B\u0005e\"aB+oSR$\u0015m\\\u0001\n[\u0016$\bn\u001c3EC>\u0004B!a\u0012\u0002P5\u0011\u0011\u0011\n\u0006\u0004;\u0006-#\u0002BA'\u0003W\tq!\\3uQ>$W-\u0003\u0003\u0002R\u0005%#!C'fi\"|G\rR1p\u00035\u0019\u0018M\u001c3sK\u000e{G-\u001a#b_B!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013a\u00013b_*!\u0011qLA\u0016\u0003)\u0019\u0018M\u001c3sK\u000e{G-Z\u0005\u0005\u0003G\nIFA\u0007TC:$'/Z\"pI\u0016$\u0015m\\\u0001\r'\u0016dWm\u0019;j_:$\u0015m\u001c\t\u00047\u0006%\u0014bAA69\na1+\u001a7fGRLwN\u001c#b_\u0006Y1)Y7qC&<g\u000eR1p!\u0011\t\t(!\u001f\u000e\u0005\u0005M$bA/\u0002v)\u0019\u0011q\u000f1\u0002\u0011\r\fW\u000e]1jO:LA!a\u001f\u0002t\tY1)Y7qC&<g\u000eR1p\u0003\u0019a\u0014N\\5u}Q\u0011\u0011\u0011\u0011\u000b)\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151TAO\u0003?\u000b\t+a)\u0002&\u0006\u001d\u0016\u0011\u0016\t\u0003\u0003\u0002AQ\u0001\u000f\u000bA\u0004eBQa\u0010\u000bA\u0004\u0001CQ\u0001\u0012\u000bA\u0004\u0015CQ!\u0014\u000bA\u00049CQ!\u0015\u000bA\u0004ICQ!\u0016\u000bA\u0004YCQ!\u0017\u000bA\u0004iCQ\u0001\u001a\u000bA\u0004\u0015DQ\u0001\u001c\u000bA\u00045DQa\u001e\u000bA\u0004aDQa\u001f\u000bA\u0004qDq!a\u0002\u0015\u0001\b\tI\u0001C\u0004\u0002\u0012Q\u0001\u001d!a\u0005\t\u000f\u0005}A\u0003q\u0001\u0002\"!9\u00111\u0007\u000bA\u0004\u0005U\u0002bBA\")\u0001\u000f\u0011Q\t\u0005\b\u0003'\"\u00029AA+\u0011\u001d\t)\u0007\u0006a\u0002\u0003OBq!!\u001c\u0015\u0001\b\ty\u0007K\u0002\u0015\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003o\u000bQA[1wCbLA!a/\u00022\n1\u0011J\u001c6fGR\fqB[1ta\u0016\u0014Xj\u001c3fYJ+\u0017\rZ\u000b\u0003\u0003\u0003\u0004b!a1\u0002T\u0006]WBAAc\u0015\u0011\t9-!3\u0002\t)\u001cxN\u001c\u0006\u0005\u0003\u0017\fi-\u0001\u0003mS\n\u001c(bA\u0018\u0002P*\u0011\u0011\u0011[\u0001\u0005a2\f\u00170\u0003\u0003\u0002V\u0006\u0015'!\u0002*fC\u0012\u001c\b#D\u0014\u0002Z\u0006u\u00171]Ar\u0003G\fI0C\u0002\u0002\\\"\u0012a\u0001V;qY\u0016,\u0004cA\u0014\u0002`&\u0019\u0011\u0011\u001d\u0015\u0003\u0007%sG\u000f\u0005\u0003\u0002f\u0006Mh\u0002BAt\u0003_\u00042!!;)\u001b\t\tYOC\u0002\u0002n\u0012\na\u0001\u0010:p_Rt\u0014bAAyQ\u00051\u0001K]3eK\u001aLA!!>\u0002x\n11\u000b\u001e:j]\u001eT1!!=)!\u00159\u00131`A\u0000\u0013\r\ti\u0010\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007Q1A!\u0002_\u0003=\u0019\u0007N]8oS\u000e\fe.\u00197zg&\u001c\u0018\u0002\u0002B\u0005\u0005\u0007\u0011Q\"U;bY&$\u0018PR5mi\u0016\u0014\u0018\u0001\u00056bgB,'/T8eK2\u0014V-\u00193!\u0003M)\u0007\u0010]8siN#\u0018\r^5p]*\u000b7\u000f]3s))\t\u0019O!\u0005\u0003\u001c\t-\"q\u0006\u0005\b\u0005'9\u0002\u0019\u0001B\u000b\u0003\u001diWm]:bO\u0016\u0004B!a1\u0003\u0018%!!\u0011DAc\u0005\u001dQ5OV1mk\u0016DqA!\b\u0018\u0001\u0004\u0011y\"A\u0004iK\u0006$WM]:\u0011\u0011\u0005\u0015(\u0011EAr\u0005KIAAa\t\u0002x\n\u0019Q*\u00199\u0011\u0007\u001d\u00129#C\u0002\u0003*!\u00121!\u00118z\u0011\u001d\u0011ic\u0006a\u0001\u0003G\fa!\\8ek2,\u0007b\u0002B\u0019/\u0001\u0007\u00111]\u0001\u0005kN,'/A\tfqB|'\u000f\u001e&bgB,'/T8eK2$\u0002Ca\u000e\u0003P\tM#q\u000bB.\u0005;\u00129Ha\u001f\u0011\u0011\te\"1\tB%\u0005\u0013rAAa\u000f\u0003@9!\u0011\u0011\u001eB\u001f\u0013\u0005I\u0013b\u0001B!Q\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B#\u0005\u000f\u0012a!R5uQ\u0016\u0014(b\u0001B!QA9qEa\u0013\u0002d\nU\u0011b\u0001B'Q\t1A+\u001e9mKJBqA!\u0015\u0019\u0001\u0004\ti.A\u0005ti\u0006$\u0018n\u001c8JI\"9!Q\u000b\rA\u0002\u0005\r\u0018aC:uCRLwN\u001c+za\u0016DqA!\u0017\u0019\u0001\u0004\t\u0019/A\u0007n_\u0012,GNR5mK:\u000bW.\u001a\u0005\b\u0005cA\u0002\u0019AAr\u0011\u001d\u0011y\u0006\u0007a\u0001\u0005C\n\u0011b\u001d;beR$\u0015\r^3\u0011\u000b\u001d\nYPa\u0019\u0011\t\t\u0015$1O\u0007\u0003\u0005ORAA!\u001b\u0003l\u0005!A/[7f\u0015\u0011\u0011iGa\u001c\u0002\t)|G-\u0019\u0006\u0003\u0005c\n1a\u001c:h\u0013\u0011\u0011)Ha\u001a\u0003\u0011\u0011\u000bG/\u001a+j[\u0016DqA!\u001f\u0019\u0001\u0004\u0011\t'A\u0004f]\u0012$\u0015\r^3\t\u000f\tu\u0004\u00041\u0001\u0002z\u0006i\u0011/^1mSRLh)\u001b7uKJ\f1\u0003]5fu>lU-Y:ve\u0016\u001cHk\u001c&t_:$BAa!\u0003\nB!\u00111\u0019BC\u0013\u0011\u00119)!2\u0003\u000f)\u001b\u0018I\u001d:bs\"9!1R\rA\u0002\t5\u0015\u0001C7fCN,(/Z:\u0011\r\te\"q\u0012BJ\u0013\u0011\u0011\tJa\u0012\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003\u0016\nuUB\u0001BL\u0015\u0011\u0011IJa'\u0002\u000f5,\u0017m];sK*\u0011!\n[\u0005\u0005\u0005?\u00139JA\u000eQS\u0016Tx.\\3uKJ\u001c\u0005N]8oS\u000e\u0014\u0016m^'fCN,(/Z\u0001\u0017a&,'p\\'fCN,(/Z:O\u000f\u001a#vNS:p]R!!1\u0011BS\u0011\u001d\u0011YI\u0007a\u0001\u0005\u001b\u000bAB[:TiJLgn\u001a(vY2$BA!\u0006\u0003,\"9!QV\u000eA\u0002\t=\u0016!C:ue&twm\u00149u!\u00159\u00131`Ar\u00031Q7OT;nE\u0016\u0014h*\u001e7m)\u0011\u0011)B!.\t\u000f\t]F\u00041\u0001\u0003:\u0006Ia.^7cKJ|\u0005\u000f\u001e\t\u0006O\u0005m(1\u0018\t\u0004O\tu\u0016b\u0001B`Q\t1Ai\\;cY\u0016\fa#];bY&$\u0018p\u00149fe\u0006$\u0018n\u001c8U_*\u001bxN\u001c\u000b\t\u0005\u0007\u0013)Ma6\u0003d\"9!qY\u000fA\u0002\t%\u0017AC8qKJ\fG/[8ogB1!\u0011\bBH\u0005\u0017\u0004BA!4\u0003T6\u0011!q\u001a\u0006\u0004\u0005#t\u0016!C8qKJ\fG/[8o\u0013\u0011\u0011)Na4\u0003!E+\u0018\r\\5us>\u0003XM]1uS>t\u0007b\u0002Bm;\u0001\u0007!1\\\u0001\tC:\fG._:jgB1!\u0011\bBH\u0005;\u0004BA!\u0001\u0003`&!!\u0011\u001dB\u0002\u0005M\u0001&/\u001a;us\u0006s\u0017\r\\=tSNd\u0015n\u001a5u\u0011\u001d\u0011)/\ba\u0001\u0005O\f!\u0002\u001e5sKNDw\u000e\u001c3t!\u0019\u0011IDa$\u0003jB!\u0011Q\u0003Bv\u0013\u0011\u0011i/a\u0006\u0003%A\u000b'/Y7fi\u0016\u0014H\u000b\u001b:fg\"|G\u000eZ\u0001%cV\fG.\u001b;z\u001fB,'/\u0019;j_:<\u0016\u000e\u001e5TK2,7\r^5p]N$vNS:p]Ra!1\u0011Bz\u0005k\u00149P!?\u0003~\"9!q\u0019\u0010A\u0002\t%\u0007b\u0002Bm=\u0001\u0007!1\u001c\u0005\b\u0005Kt\u0002\u0019\u0001Bt\u0011\u001d\u0011YP\ba\u0001\u0003G\f1\u0003]1sK:$8+\u001a7fGRLwN\\\"pI\u0016DqAa@\u001f\u0001\u0004\u0019\t!\u0001\u0006tK2,7\r^5p]N\u0004bA!\u000f\u0003\u0010\u000e\r\u0001\u0003BB\u0003\u0007\u0017i!aa\u0002\u000b\t\r%\u0011qE\u0001\u0007I>l\u0017-\u001b8\n\t\r51q\u0001\u0002\n'\u0016dWm\u0019;j_:\u0004")
public class JasperStationExportController
implements Producer {
    private final LogUtil logUtil;
    private final ModelFileExportController ModelFileExportController;
    private final PiezoBookmarkBuilder piezoBookmarkBuilder;
    private final QualitoBookmarkBuilder qualitoBookmarkBuilder;
    private final PluvioBookmarkBuilder pluvioBookmarkBuilder;
    private final HydroBookmarkBuilder hydroBookmarkBuilder;
    private final QualitometerDao qualitometerDao;
    private final PiezometerDaeau piezometerDao;
    private final StationLandmarkDao stationLandmarkDao;
    private final PiezometerMeasureDao piezometerMeasureDao;
    private final SieauParametersDao SieauParametersDao;
    private final QualityDao qualityDao;
    private final ThresholdDao thresholdDao;
    private final ParameterDao parameterDao;
    private final UnitDao unitDao;
    private final MethodDao methodDao;
    private final SandreCodeDao sandreCodeDao;
    private final SelectionDao SelectionDao;
    private final CampaignDao CampaignDao;
    private final Reads<Tuple5<Object, String, String, String, Option<QualityFilter>>> jasperModelRead;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        JasperStationExportController jasperStationExportController = this;
        synchronized (jasperStationExportController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Reads<Tuple5<Object, String, String, String, Option<QualityFilter>>> jasperModelRead() {
        return this.jasperModelRead;
    }

    public String exportStationJasper(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.jasperModelRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(38).append("Can't read inputs for Jasper export : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Right right;
            Tuple2 tuple2;
            Left left;
            Tuple2 tuple22;
            Tuple5 tuple5 = input;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            int stationId = BoxesRunTime.unboxToInt((Object)tuple5._1());
            String stationType = (String)tuple5._2();
            String modelFileName = (String)tuple5._3();
            String user = (String)tuple5._4();
            Option qualityFilter = (Option)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)stationId), (Object)stationType, (Object)modelFileName, (Object)user, (Object)qualityFilter);
            int stationId2 = BoxesRunTime.unboxToInt((Object)tuple52._1());
            String stationType2 = (String)tuple52._2();
            String modelFileName2 = (String)tuple52._3();
            String user2 = (String)tuple52._4();
            Option qualityFilter2 = (Option)tuple52._5();
            Either<Tuple2<String, JsValue>, Tuple2<String, JsValue>> either = this.exportJasperModel(stationId2, stationType2, modelFileName2, user2, (Option<DateTime>)None$.MODULE$, (Option<DateTime>)None$.MODULE$, (Option<QualityFilter>)qualityFilter2);
            if (either instanceof Left && (tuple22 = (Tuple2)(left = (Left)either).value()) != null) {
                String targetPath = (String)tuple22._1();
                JsValue fullJson = (JsValue)tuple22._2();
                return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetPath"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)targetPath.replace((CharSequence)scala.sys.package$.MODULE$.env().apply((Object)"UPLOAD_DIRECTORY"), ""), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"json"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)fullJson, Writes$.MODULE$.jsValueWrites()))})).toString();
            }
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                String error = (String)tuple2._1();
                JsValue fullJson = (JsValue)tuple2._2();
                return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"failed", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)error, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"json"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)fullJson, Writes$.MODULE$.jsValueWrites()))})).toString();
            }
            throw new MatchError(either);
        });
    }

    public Either<Tuple2<String, JsValue>, Tuple2<String, JsValue>> exportJasperModel(int stationId, String stationType, String modelFileName, String user, Option<DateTime> startDate, Option<DateTime> endDate, Option<QualityFilter> qualityFilter) {
        Right right;
        File file = (File)ExportFileUtils$.MODULE$.getModelFile(new StringBuilder(4).append(modelFileName).append(".zip").toString(), stationType).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(39).append("Can't find Jasper zip project on FTP : ").append(modelFileName).toString());
        });
        String zipDir = file.getAbsolutePath().replace(file.getName(), "");
        String exportTmpDir = FileUtil$.MODULE$.toPath(new StringBuilder(5).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> {
            throw new Exception("EXPORT_DIRECTORY is not in .env");
        })).append("/tmp/").toString());
        String jasperDir = new StringBuilder(1).append(exportTmpDir).append(file.getName().replace(".zip", "")).append("_").append(new DateTime().getMillis()).toString();
        String zipCMD = new StringBuilder(15).append("unzip -d \"").append(jasperDir).append("\" \"").append(file.getName()).append("\" ").toString();
        FileUtil$.MODULE$.runCMDInScript(zipDir, (scala.collection.immutable.Seq)new .colon.colon((Object)zipCMD, (List)Nil$.MODULE$), this.logUtil);
        JsNull$ fullJson = JsNull$.MODULE$;
        MapOfBookmarks m = new MapOfBookmarks();
        try {
            JsObject jsObject;
            File mainJasperFile = (File)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])new File(jasperDir).listFiles()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$exportJasperModel$3(modelFileName, x$2))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(46).append("Unable to find the file ").append(modelFileName).append(".jasper on zip archive").toString());
            });
            m.init();
            ModelExportInput modelExportInput = new ModelExportInput(user, Integer.toString(stationId), stationType, modelFileName, (Option<String>)new Some((Object)modelFileName));
            StationModelExport stationModelExport = (StationModelExport)this.ModelFileExportController.getStationModelExport(modelExportInput).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Unknown station type");
            });
            String string = StationTypeUtil$.MODULE$.StationType(stationType);
            String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                this.piezoBookmarkBuilder.getMarkers(m, stationModelExport);
                this.qualitometerDao.get(stationModelExport.code()).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Qualitometer)s)).foreach((Function1 & Serializable)qualitoFound -> {
                    JasperStationExportController.$anonfun$exportJasperModel$7(this, m, qualitoFound);
                    return BoxedUnit.UNIT;
                });
            } else {
                String string4 = StationTypeUtil$.MODULE$.QUALITY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    this.qualitoBookmarkBuilder.getMarkers(m, stationModelExport);
                    this.piezometerDao.find(stationModelExport.code()).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Piezometer)s)).foreach((Function1 & Serializable)piezoFound -> {
                        JasperStationExportController.$anonfun$exportJasperModel$10(this, m, piezoFound);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    String string6 = StationTypeUtil$.MODULE$.HYDROMETRY();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        this.hydroBookmarkBuilder.getMarkers(m, stationModelExport);
                    } else {
                        String string8 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            this.pluvioBookmarkBuilder.getMarkers(m, stationModelExport);
                        }
                    }
                }
            }
            JsObject json = (JsObject)((IterableOnceOps)m.bookmarks().keys().filter((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$exportJasperModel$12(k)))).foldLeft((Object)Json$.MODULE$.obj((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(acc, value) -> acc.$plus(new Tuple2(value, (Object)m.getToJson((String)value))));
            String string10 = StationTypeUtil$.MODULE$.StationType(stationType);
            String string11 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string12 = string10;
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                Tuple2 tuple2 = (Tuple2)this.stationLandmarkDao.getChartLandmarks((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{stationId}))).headOption().map((Function1 & Serializable)l -> new Tuple2((Object)l.lastlandmark(), (Object)l.groundRefAlti())).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option landmark = (Option)tuple2._1();
                Option groundAlti = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)landmark, (Object)groundAlti);
                Option landmark2 = (Option)tuple22._1();
                Option groundAlti2 = (Option)tuple22._2();
                String x$1 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                int x$22 = stationId;
                int x$3 = -1;
                Option<DateTime> x$42 = startDate;
                Option<DateTime> x$52 = endDate;
                Some x$62 = new Some((Object)"MAX");
                Some x$72 = new Some((Object)BoxesRunTime.boxToInteger((int)2));
                Option x$82 = landmark2;
                Option x$9 = groundAlti2;
                scala.collection.immutable.Seq x$10 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                Option x$11 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                Option x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
                Option x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                Option x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                Option x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                Option x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                Option x$222 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
                Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
                Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                scala.collection.immutable.Seq maxMeasures = PiezometryUtils$.MODULE$.getPiezoMeasures(new MeasuresParams(x$1, x$22, x$10, -1, x$11, x$42, x$52, x$12, x$13, x$14, (Option)x$62, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$222, x$23, x$24, x$25, (Option)x$72, x$82, x$9, x$26), this.piezometerMeasureDao, this.SieauParametersDao);
                long startYear = new DateTime().withDayOfYear(1).withTimeAtStartOfDay().getMillis();
                scala.collection.immutable.Seq maxYear = (scala.collection.immutable.Seq)maxMeasures.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$exportJasperModel$16(startYear, x$4)));
                Some startEnveloppe = new Some((Object)new DateTime().withDayOfYear(1).withTimeAtStartOfDay());
                Some endEnveloppe = new Some((Object)DateUtil$.MODULE$.setMaxDay(new DateTime().plusYears(1).withDayOfYear(1).minusDays(1)));
                String x$27 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                int x$28 = stationId;
                int x$29 = -1;
                Some x$30 = new Some((Object)"ENVELOPPE_MAX");
                Some x$31 = new Some((Object)BoxesRunTime.boxToInteger((int)2));
                Option x$32 = landmark2;
                Option x$33 = groundAlti2;
                Some x$34 = startEnveloppe;
                Some x$35 = endEnveloppe;
                scala.collection.immutable.Seq x$36 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                Option x$37 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                Option x$38 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
                Option x$39 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
                Option x$40 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
                Option x$41 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                Option x$422 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                Option x$43 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                Option x$44 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                Option x$45 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                Option x$46 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                Option x$47 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                Option x$48 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                Option x$49 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                Option x$50 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                Option x$51 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                Option x$522 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                scala.collection.immutable.Seq enveloppeMax = PiezometryUtils$.MODULE$.calculatePiezoMeasures(new MeasuresParams(x$27, x$28, x$36, -1, x$37, x$38, x$39, x$40, x$41, x$422, (Option)x$30, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, (Option)x$34, (Option)x$35, (Option)x$31, x$32, x$33, x$522), maxMeasures, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.SieauParametersDao);
                String x$53 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                int x$54 = stationId;
                int x$55 = -1;
                Some x$56 = new Some((Object)"ENVELOPPE_MIN");
                Some x$57 = new Some((Object)BoxesRunTime.boxToInteger((int)2));
                Option x$58 = landmark2;
                Option x$59 = groundAlti2;
                Some x$60 = startEnveloppe;
                Some x$61 = endEnveloppe;
                scala.collection.immutable.Seq x$622 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                Option x$63 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                Option x$64 = MeasuresParams$.MODULE$.$lessinit$greater$default$6();
                Option x$65 = MeasuresParams$.MODULE$.$lessinit$greater$default$7();
                Option x$66 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
                Option x$67 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                Option x$68 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                Option x$69 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                Option x$70 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                Option x$71 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                Option x$722 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                Option x$73 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                Option x$74 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                Option x$75 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                Option x$76 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                Option x$77 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                Option x$78 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                scala.collection.immutable.Seq enveloppeMin = PiezometryUtils$.MODULE$.calculatePiezoMeasures(new MeasuresParams(x$53, x$54, x$622, -1, x$63, x$64, x$65, x$66, x$67, x$68, (Option)x$56, x$69, x$70, x$71, x$722, x$73, x$74, x$75, x$76, x$77, (Option)x$60, (Option)x$61, (Option)x$57, x$58, x$59, x$78), maxMeasures, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.SieauParametersDao);
                jsObject = json.$plus(new Tuple2((Object)"CHRONIQUES", (Object)this.piezoMeasuresNGFToJson((scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)maxMeasures))).$plus(new Tuple2((Object)"CHRONIQUES_ANNEE", (Object)this.piezoMeasuresNGFToJson((scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)maxYear))).$plus(new Tuple2((Object)"CHRONIQUES_MAX", (Object)this.piezoMeasuresNGFToJson((scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)enveloppeMax))).$plus(new Tuple2((Object)"CHRONIQUES_MIN", (Object)this.piezoMeasuresNGFToJson((scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)enveloppeMin)));
            } else {
                String string13 = StationTypeUtil$.MODULE$.QUALITY();
                String string14 = string10;
                if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                    JsObject jsonWithCampaign;
                    Option selectedSelection = qualityFilter.flatMap((Function1 & Serializable)x$5 -> x$5.selectionCode());
                    QualityFilter qual$1 = (QualityFilter)qualityFilter.getOrElse((Function0 & Serializable)() -> new QualityFilter(QualityFilter$.MODULE$.apply$default$1(), QualityFilter$.MODULE$.apply$default$2(), QualityFilter$.MODULE$.apply$default$3(), QualityFilter$.MODULE$.apply$default$4(), QualityFilter$.MODULE$.apply$default$5(), QualityFilter$.MODULE$.apply$default$6(), QualityFilter$.MODULE$.apply$default$7(), QualityFilter$.MODULE$.apply$default$8(), QualityFilter$.MODULE$.apply$default$9(), QualityFilter$.MODULE$.apply$default$10(), QualityFilter$.MODULE$.apply$default$11(), QualityFilter$.MODULE$.apply$default$12(), QualityFilter$.MODULE$.apply$default$13(), QualityFilter$.MODULE$.apply$default$14(), QualityFilter$.MODULE$.apply$default$15(), QualityFilter$.MODULE$.apply$default$16(), QualityFilter$.MODULE$.apply$default$17(), QualityFilter$.MODULE$.apply$default$18(), QualityFilter$.MODULE$.apply$default$19(), QualityFilter$.MODULE$.apply$default$20(), QualityFilter$.MODULE$.apply$default$21(), QualityFilter$.MODULE$.apply$default$22(), QualityFilter$.MODULE$.apply$default$23(), QualityFilter$.MODULE$.apply$default$24(), QualityFilter$.MODULE$.apply$default$25(), QualityFilter$.MODULE$.apply$default$26(), QualityFilter$.MODULE$.apply$default$27(), QualityFilter$.MODULE$.apply$default$28(), QualityFilter$.MODULE$.apply$default$29(), QualityFilter$.MODULE$.apply$default$30(), QualityFilter$.MODULE$.apply$default$31(), QualityFilter$.MODULE$.apply$default$32(), QualityFilter$.MODULE$.apply$default$33(), QualityFilter$.MODULE$.apply$default$34(), QualityFilter$.MODULE$.apply$default$35(), QualityFilter$.MODULE$.apply$default$36(), QualityFilter$.MODULE$.apply$default$37()));
                    None$ x$79 = None$.MODULE$;
                    Option x$80 = Option$.MODULE$.apply((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{stationId})));
                    Option x$81 = qual$1.copy$default$2();
                    Option x$82 = qual$1.copy$default$3();
                    Option x$83 = qual$1.copy$default$4();
                    Option x$84 = qual$1.copy$default$5();
                    Option x$85 = qual$1.copy$default$6();
                    Option x$86 = qual$1.copy$default$7();
                    Option x$87 = qual$1.copy$default$8();
                    Option x$88 = qual$1.copy$default$9();
                    Option x$89 = qual$1.copy$default$10();
                    Option x$90 = qual$1.copy$default$11();
                    Option x$91 = qual$1.copy$default$12();
                    Option x$92 = qual$1.copy$default$13();
                    Option x$93 = qual$1.copy$default$14();
                    Option x$94 = qual$1.copy$default$15();
                    Option x$95 = qual$1.copy$default$16();
                    Option x$96 = qual$1.copy$default$17();
                    Option x$97 = qual$1.copy$default$18();
                    Option x$98 = qual$1.copy$default$19();
                    Option x$99 = qual$1.copy$default$20();
                    Option x$100 = qual$1.copy$default$21();
                    Option x$101 = qual$1.copy$default$22();
                    Option x$102 = qual$1.copy$default$23();
                    Option x$103 = qual$1.copy$default$25();
                    Option x$104 = qual$1.copy$default$26();
                    Option x$105 = qual$1.copy$default$27();
                    Option x$106 = qual$1.copy$default$28();
                    Option x$107 = qual$1.copy$default$29();
                    Option x$108 = qual$1.copy$default$30();
                    Option x$109 = qual$1.copy$default$31();
                    Option x$110 = qual$1.copy$default$32();
                    Option x$111 = qual$1.copy$default$33();
                    Option x$112 = qual$1.copy$default$34();
                    Option x$113 = qual$1.copy$default$35();
                    Option x$114 = qual$1.copy$default$36();
                    Option x$115 = qual$1.copy$default$37();
                    QualityFilter filter = qual$1.copy(x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, (Option)x$79, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115);
                    scala.collection.immutable.Seq operations = this.qualityDao.getOperations(filter);
                    scala.collection.immutable.Seq analysis = this.qualityDao.getPrettyAnalysisLight(filter);
                    scala.collection.immutable.Seq thresholds = filter.threshold().isDefined() ? this.thresholdDao.findParameterThresholds(BoxesRunTime.unboxToInt((Object)filter.threshold().get()), this.thresholdDao.findParameterThresholds$default$2()) : (scala.collection.immutable.Seq)Nil$.MODULE$;
                    scala.collection.immutable.Seq selections = selectedSelection.isDefined() ? this.SelectionDao.getAll() : (scala.collection.immutable.Seq)Nil$.MODULE$;
                    None$ campaignName = qualityFilter.flatMap((Function1 & Serializable)x$6 -> x$6.campaign()).isDefined() ? this.CampaignDao.get((double)((int)BoxesRunTime.unboxToDouble((Object)((QualityFilter)qualityFilter.get()).campaign().get())), user).flatMap((Function1 & Serializable)x$7 -> x$7.name()) : None$.MODULE$;
                    JsObject jsObject2 = jsonWithCampaign = campaignName.isDefined() ? json.$plus(new Tuple2((Object)"CAMPAGNE", (Object)new JsString((String)campaignName.get()))) : json;
                    jsObject = selectedSelection.nonEmpty() && selections.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$exportJasperModel$21(selectedSelection, x$8))) ? jsonWithCampaign.$plus(new Tuple2((Object)"PRELEVEMENTS", (Object)this.qualityOperationWithSelectionsToJson((scala.collection.immutable.Seq<QualityOperation>)operations, (scala.collection.immutable.Seq<PrettyAnalysisLight>)analysis, (scala.collection.immutable.Seq<ParameterThreshold>)thresholds, (String)selectedSelection.get(), (scala.collection.immutable.Seq<Selection>)selections))) : jsonWithCampaign.$plus(new Tuple2((Object)"PRELEVEMENTS", (Object)this.qualityOperationToJson((scala.collection.immutable.Seq<QualityOperation>)operations, (scala.collection.immutable.Seq<PrettyAnalysisLight>)analysis, (scala.collection.immutable.Seq<ParameterThreshold>)thresholds)));
                } else {
                    jsObject = json;
                }
            }
            fullJson = jsObject;
            String fullJsonString = Json$.MODULE$.toJson((Object)fullJson, Writes$.MODULE$.jsValueWrites()).toString();
            ByteArrayInputStream targetStream = new ByteArrayInputStream(fullJsonString.getBytes("UTF-8"));
            JsonDataSource jsonDataSource = new JsonDataSource((InputStream)targetStream);
            JasperPrint jasperPrint = JasperFillManager.fillReport((String)mainJasperFile.getAbsolutePath(), null, (JRDataSource)jsonDataSource);
            String targetPath = new StringBuilder(9).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> {
                throw new Exception("EXPORT_DIRECTORY is not in .env");
            })).append("tmp/").append(stationModelExport.code()).append("_").append(modelFileName).append(".pdf").toString();
            File output = new File(targetPath);
            FileOutputStream outputSteam = new FileOutputStream(output);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputSteam);
            FileUtil$.MODULE$.runCMDInScript(zipDir, (scala.collection.immutable.Seq)new .colon.colon((Object)new StringBuilder(10).append("rm -rf \"").append(jasperDir).append("\" ").toString(), (List)Nil$.MODULE$), this.logUtil);
            String appUrl = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"URL_UTILS", (Function0 & Serializable)() -> {
                throw new Exception("URL_UTILS is not in env");
            });
            if (appUrl.contains("dev.sieau.fr") || appUrl.contains("integration.sieau.fr")) {
                FileUtil$.MODULE$.writeFile(targetPath.replace(".pdf", ".json"), fullJsonString);
            }
            right = scala.package$.MODULE$.Left().apply((Object)new Tuple2((Object)targetPath, (Object)fullJson));
        }
        catch (JRException e) {
            this.logUtil.printError((Throwable)e);
            if (m.bookmarks() != null) {
                this.logUtil.error(new StringBuilder(15).append("List of keys : ").append(m.bookmarks().keys().toSeq().mkString(",")).toString(), this.logUtil.error$default$2());
            }
            FileUtil$.MODULE$.runCMDInScript(zipDir, (scala.collection.immutable.Seq)new .colon.colon((Object)new StringBuilder(10).append("rm -rf \"").append(jasperDir).append("\" ").toString(), (List)Nil$.MODULE$), this.logUtil);
            right = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)e.getMessage(), (Object)fullJson));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (m.bookmarks() != null) {
                this.logUtil.error(new StringBuilder(15).append("List of keys : ").append(m.bookmarks().keys().toSeq().mkString(",")).toString(), this.logUtil.error$default$2());
            }
            this.logUtil.printError((Throwable)e);
            FileUtil$.MODULE$.runCMDInScript(zipDir, (scala.collection.immutable.Seq)new .colon.colon((Object)new StringBuilder(10).append("rm -rf \"").append(jasperDir).append("\" ").toString(), (List)Nil$.MODULE$), this.logUtil);
            right = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)e.getMessage(), (Object)fullJson));
        }
        return right;
    }

    public JsArray piezoMeasuresToJson(scala.collection.immutable.Seq<PiezometerChronicRawMeasure> measures) {
        return JsArray$.MODULE$.apply((Seq)((IterableOps)((IterableOps)measures.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$piezoMeasuresToJson$1(x$9)))).flatMap((Function1 & Serializable)m -> {
            if (BoxesRunTime.unboxToInt((Object)m.initialPoint().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 2)) == 2) {
                return new .colon.colon(m, (List)Nil$.MODULE$);
            }
            DateTime x$1 = m.date().minusSeconds(1);
            None$ x$2 = None$.MODULE$;
            None$ x$3 = None$.MODULE$;
            int x$4 = m.copy$default$1();
            int x$5 = m.copy$default$2();
            Option x$6 = m.copy$default$4();
            Option x$7 = m.copy$default$5();
            Option x$8 = m.copy$default$6();
            Option x$9 = m.copy$default$8();
            Option x$10 = m.copy$default$9();
            Option x$11 = m.copy$default$10();
            Option x$12 = m.copy$default$11();
            Option x$13 = m.copy$default$12();
            Option x$14 = m.copy$default$14();
            Option x$15 = m.copy$default$15();
            Option x$16 = m.copy$default$16();
            Option x$17 = m.copy$default$17();
            Option x$18 = m.copy$default$18();
            Option x$19 = m.copy$default$19();
            Option x$20 = m.copy$default$20();
            Option x$21 = m.copy$default$21();
            Option x$22 = m.copy$default$22();
            int x$23 = m.copy$default$23();
            return new .colon.colon((Object)m.copy(x$4, x$5, x$1, x$6, x$7, x$8, (Option)x$2, x$9, x$10, x$11, x$12, x$13, (Option)x$3, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23), (List)new .colon.colon(m, (List)Nil$.MODULE$));
        })).map((Function1 & Serializable)m -> Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"measureDate"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(m.date().toString("dd/MM/yyyy HH:mm:ss")), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valeur"), (Object)(m.value().isDefined() ? Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(-BoxesRunTime.unboxToDouble((Object)m.value().get()))), Writes$.MODULE$.jsValueWrites()) : Json$.MODULE$.toJsFieldJsValueWrapper((Object)JsNull$.MODULE$, Writes$.MODULE$.jsValueWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pointInitial"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(m.initialPoint().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 2).toString()), Writes$.MODULE$.jsValueWrites()))}))));
    }

    public JsArray piezoMeasuresNGFToJson(scala.collection.immutable.Seq<PiezometerChronicRawMeasure> measures) {
        return JsArray$.MODULE$.apply((Seq)((IterableOps)((IterableOps)measures.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$piezoMeasuresNGFToJson$1(x$10)))).flatMap((Function1 & Serializable)m -> {
            if (BoxesRunTime.unboxToInt((Object)m.initialPoint().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 2)) == 2) {
                return new .colon.colon(m, (List)Nil$.MODULE$);
            }
            DateTime x$1 = m.date().minusSeconds(1);
            None$ x$2 = None$.MODULE$;
            None$ x$3 = None$.MODULE$;
            int x$4 = m.copy$default$1();
            int x$5 = m.copy$default$2();
            Option x$6 = m.copy$default$4();
            Option x$7 = m.copy$default$5();
            Option x$8 = m.copy$default$6();
            Option x$9 = m.copy$default$7();
            Option x$10 = m.copy$default$9();
            Option x$11 = m.copy$default$10();
            Option x$12 = m.copy$default$11();
            Option x$13 = m.copy$default$12();
            Option x$14 = m.copy$default$14();
            Option x$15 = m.copy$default$15();
            Option x$16 = m.copy$default$16();
            Option x$17 = m.copy$default$17();
            Option x$18 = m.copy$default$18();
            Option x$19 = m.copy$default$19();
            Option x$20 = m.copy$default$20();
            Option x$21 = m.copy$default$21();
            Option x$22 = m.copy$default$22();
            int x$23 = m.copy$default$23();
            return new .colon.colon((Object)m.copy(x$4, x$5, x$1, x$6, x$7, x$8, x$9, (Option)x$2, x$10, x$11, x$12, x$13, (Option)x$3, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23), (List)new .colon.colon(m, (List)Nil$.MODULE$));
        })).map((Function1 & Serializable)m -> Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"measureDate"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(m.date().toString("dd/MM/yyyy HH:mm:ss")), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valeur"), (Object)(m.NGF().isDefined() ? Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(BoxesRunTime.unboxToDouble((Object)m.NGF().get()))), Writes$.MODULE$.jsValueWrites()) : Json$.MODULE$.toJsFieldJsValueWrapper((Object)JsNull$.MODULE$, Writes$.MODULE$.jsValueWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pointInitial"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(m.initialPoint().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 2).toString()), Writes$.MODULE$.jsValueWrites()))}))));
    }

    private JsValue jsStringNull(Option<String> stringOpt) {
        if (stringOpt.isDefined()) {
            return new JsString((String)stringOpt.get());
        }
        return JsNull$.MODULE$;
    }

    private JsValue jsNumberNull(Option<Object> numberOpt) {
        if (numberOpt.isDefined()) {
            return new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(BoxesRunTime.unboxToDouble((Object)numberOpt.get())));
        }
        return JsNull$.MODULE$;
    }

    public JsArray qualityOperationToJson(scala.collection.immutable.Seq<QualityOperation> operations, scala.collection.immutable.Seq<PrettyAnalysisLight> analysis, scala.collection.immutable.Seq<ParameterThreshold> thresholds) {
        Map analysisGroupByOperation = analysis.groupBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11.operation()));
        scala.collection.immutable.Seq remarks = this.sandreCodeDao.getSandreList(SandreConstants$.MODULE$.REMARK_CODE());
        scala.collection.immutable.Seq qualifications = this.sandreCodeDao.getSandreList("ANALYSES.QUALIFICATION");
        scala.collection.immutable.Seq parameters = this.parameterDao.getAll();
        scala.collection.immutable.Seq units = this.unitDao.getAll();
        scala.collection.immutable.Seq methods = this.methodDao.getAll();
        return JsArray$.MODULE$.apply((Seq)((IterableOps)operations.filter((Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationToJson$2(analysisGroupByOperation, op)))).map((Function1 & Serializable)op -> Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateprelevement"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(op.date().toString("dd/MM/yyyy HH:mm:ss")), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultatsList"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)JsArray$.MODULE$.apply((Seq)((IterableOps)analysisGroupByOperation.getOrElse((Object)BoxesRunTime.boxToDouble((double)op.id()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).map((Function1 & Serializable)an -> {
            Option method = methods.find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationToJson$7(an, x$12)));
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)an.parameter()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parametre"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)parameters.find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationToJson$9(an, x$13))).map((Function1 & Serializable)x$14 -> x$14.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultat"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.result()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultatinterprete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)an.value()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unite"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)units.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationToJson$12(an, x$15))).flatMap((Function1 & Serializable)x$16 -> x$16.symbol())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remarque"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)remarks.find((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationToJson$15(an, x$17))).map((Function1 & Serializable)x$18 -> x$18.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qualification"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)qualifications.find((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationToJson$18(an, x$19))).map((Function1 & Serializable)x$20 -> x$20.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methode"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)method.flatMap((Function1 & Serializable)x$21 -> x$21.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"libmethode"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)method.flatMap((Function1 & Serializable)x$22 -> x$22.longLabel())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil1"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold1()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil2"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold2()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil3"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold3()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil4"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold4()), Writes$.MODULE$.jsValueWrites()))}));
        })), Writes$.MODULE$.jsValueWrites()))}))));
    }

    public JsArray qualityOperationWithSelectionsToJson(scala.collection.immutable.Seq<QualityOperation> operations, scala.collection.immutable.Seq<PrettyAnalysisLight> analysis, scala.collection.immutable.Seq<ParameterThreshold> thresholds, String parentSelectionCode, scala.collection.immutable.Seq<Selection> selections) {
        Map analysisGroupByOperation = analysis.groupBy((Function1 & Serializable)x$23 -> BoxesRunTime.boxToDouble((double)x$23.operation()));
        scala.collection.immutable.Seq remarks = this.sandreCodeDao.getSandreList(SandreConstants$.MODULE$.REMARK_CODE());
        scala.collection.immutable.Seq qualifications = this.sandreCodeDao.getSandreList("ANALYSES.QUALIFICATION");
        scala.collection.immutable.Seq parameters = this.parameterDao.getAll();
        scala.collection.immutable.Seq units = this.unitDao.getAll();
        scala.collection.immutable.Seq methods = this.methodDao.getAll();
        scala.collection.immutable.Seq selectionParameters = this.SelectionDao.getSelectionParameters(parentSelectionCode);
        Map parameterToSelectionMap = ((IterableOnceOps)((IterableOps)selectionParameters.filter((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$2(x$24)))).map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p.parameterCode().get()), p.childCode().get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return JsArray$.MODULE$.apply((Seq)((IterableOps)operations.filter((Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$4(analysisGroupByOperation, op)))).map((Function1 & Serializable)op -> {
            scala.collection.immutable.Seq opAnalysis = (scala.collection.immutable.Seq)analysisGroupByOperation.getOrElse((Object)BoxesRunTime.boxToDouble((double)op.id()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
            Map groupedBySelection = opAnalysis.groupBy((Function1 & Serializable)a -> (String)parameterToSelectionMap.getOrElse(a.parameter().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Analysis with no parameter found !");
            }), (Function0 & Serializable)() -> "divers"));
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateprelevement"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(op.date().toString("dd/MM/yyyy HH:mm:ss")), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"selectionList"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(groupedBySelection.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String selectionCode = (String)tuple2._1();
                    scala.collection.immutable.Seq anas = (scala.collection.immutable.Seq)tuple2._2();
                    return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"codeSelection"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString(selectionCode), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nomSelection"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new JsString((String)selections.find((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$12(selectionCode, x$25))).map((Function1 & Serializable)x$26 -> x$26.name()).getOrElse((Function0 & Serializable)() -> "divers")), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultatsList"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)JsArray$.MODULE$.apply((Seq)anas.map((Function1 & Serializable)an -> {
                        Option method = methods.find((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$16(an, x$27)));
                        return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)an.parameter()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parametre"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)parameters.find((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$18(an, x$28))).map((Function1 & Serializable)x$29 -> x$29.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultat"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.result()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultatinterprete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)an.value()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unite"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)units.find((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$21(an, x$30))).flatMap((Function1 & Serializable)x$31 -> x$31.symbol())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remarque"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)remarks.find((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$24(an, x$32))).map((Function1 & Serializable)x$33 -> x$33.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qualification"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)qualifications.find((Function1 & Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)JasperStationExportController.$anonfun$qualityOperationWithSelectionsToJson$27(an, x$34))).map((Function1 & Serializable)x$35 -> x$35.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methode"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)method.flatMap((Function1 & Serializable)x$36 -> x$36.name())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"libmethode"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsStringNull((Option<String>)method.flatMap((Function1 & Serializable)x$37 -> x$37.longLabel())), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil1"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold1()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil2"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold2()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil3"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold3()), Writes$.MODULE$.jsValueWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seuil4"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.jsNumberNull((Option<Object>)an.threshold4()), Writes$.MODULE$.jsValueWrites()))}));
                    })), Writes$.MODULE$.jsValueWrites()))}));
                }
                throw new MatchError((Object)tuple2);
            }), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)JsObject$.MODULE$.writes())))}));
        }));
    }

    public static final /* synthetic */ boolean $anonfun$exportJasperModel$3(String modelFileName$1, File x$2) {
        String string = x$2.getName();
        String string2 = new StringBuilder(7).append(modelFileName$1).append(".jasper").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$exportJasperModel$8(MapOfBookmarks m2$1, MapOfBookmarks m$1, String k) {
        String string = m2$1.get(k).trim();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = m$1.get(k).trim();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                m$1.add(k, (Object)m2$1.get(k));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$exportJasperModel$7(JasperStationExportController $this, MapOfBookmarks m$1, StationModelExport qualitoFound) {
        MapOfBookmarks m2 = new MapOfBookmarks();
        m2.init();
        $this.qualitoBookmarkBuilder.getMarkers(m2, qualitoFound);
        m2.bookmarks().keys().foreach((Function1 & Serializable)k -> {
            JasperStationExportController.$anonfun$exportJasperModel$8(m2, m$1, k);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$exportJasperModel$11(MapOfBookmarks m2$2, MapOfBookmarks m$1, String k) {
        String string = m2$2.get(k).trim();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = m$1.get(k).trim();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                m$1.add(k, (Object)m2$2.get(k));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$exportJasperModel$10(JasperStationExportController $this, MapOfBookmarks m$1, StationModelExport piezoFound) {
        MapOfBookmarks m2 = new MapOfBookmarks();
        m2.init();
        $this.piezoBookmarkBuilder.getMarkers(m2, piezoFound);
        m2.bookmarks().keys().foreach((Function1 & Serializable)k -> {
            JasperStationExportController.$anonfun$exportJasperModel$11(m2, m$1, k);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$exportJasperModel$12(String k) {
        return !k.contains("CMS");
    }

    public static final /* synthetic */ boolean $anonfun$exportJasperModel$16(long startYear$1, PiezometerChronicRawMeasure x$4) {
        return x$4.date().getMillis() > startYear$1;
    }

    public static final /* synthetic */ boolean $anonfun$exportJasperModel$21(Option selectedSelection$1, Selection x$8) {
        return x$8.parentCode().contains(selectedSelection$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$piezoMeasuresToJson$1(PiezometerChronicRawMeasure x$9) {
        return x$9.value().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$piezoMeasuresNGFToJson$1(PiezometerChronicRawMeasure x$10) {
        return x$10.value().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationToJson$2(Map analysisGroupByOperation$1, QualityOperation op) {
        return ((IterableOnceOps)analysisGroupByOperation$1.getOrElse((Object)BoxesRunTime.boxToDouble((double)op.id()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationToJson$7(PrettyAnalysisLight an$1, Method x$12) {
        String string = x$12.code();
        Object object = an$1.unit().getOrElse((Function0 & Serializable)() -> "");
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationToJson$9(PrettyAnalysisLight an$1, Parameter x$13) {
        String string = x$13.code();
        Object object = an$1.parameter().getOrElse((Function0 & Serializable)() -> "");
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationToJson$12(PrettyAnalysisLight an$1, Unit x$15) {
        String string = x$15.code();
        Object object = an$1.unit().getOrElse((Function0 & Serializable)() -> "");
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationToJson$15(PrettyAnalysisLight an$1, SandreCode x$17) {
        return x$17.code() == StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)an$1.remark().getOrElse((Function0 & Serializable)() -> "0")));
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationToJson$18(PrettyAnalysisLight an$1, SandreCode x$19) {
        return x$19.code() == StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)an$1.qualification().getOrElse((Function0 & Serializable)() -> "0")));
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$2(SelectionParameterOutput x$24) {
        return x$24.childCode().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$4(Map analysisGroupByOperation$2, QualityOperation op) {
        return ((IterableOnceOps)analysisGroupByOperation$2.getOrElse((Object)BoxesRunTime.boxToDouble((double)op.id()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$12(String selectionCode$1, Selection x$25) {
        String string = x$25.code();
        String string2 = selectionCode$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$16(PrettyAnalysisLight an$2, Method x$27) {
        String string = x$27.code();
        Object object = an$2.unit().getOrElse((Function0 & Serializable)() -> "");
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$18(PrettyAnalysisLight an$2, Parameter x$28) {
        String string = x$28.code();
        Object object = an$2.parameter().getOrElse((Function0 & Serializable)() -> "");
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$21(PrettyAnalysisLight an$2, Unit x$30) {
        String string = x$30.code();
        Object object = an$2.unit().getOrElse((Function0 & Serializable)() -> "");
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$24(PrettyAnalysisLight an$2, SandreCode x$32) {
        return x$32.code() == StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)an$2.remark().getOrElse((Function0 & Serializable)() -> "0")));
    }

    public static final /* synthetic */ boolean $anonfun$qualityOperationWithSelectionsToJson$27(PrettyAnalysisLight an$2, SandreCode x$34) {
        return x$34.code() == StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)an$2.qualification().getOrElse((Function0 & Serializable)() -> "0")));
    }

    @Inject
    public JasperStationExportController(LogUtil logUtil, ModelFileExportController ModelFileExportController2, PiezoBookmarkBuilder piezoBookmarkBuilder, QualitoBookmarkBuilder qualitoBookmarkBuilder, PluvioBookmarkBuilder pluvioBookmarkBuilder, HydroBookmarkBuilder hydroBookmarkBuilder, QualitometerDao qualitometerDao, PiezometerDaeau piezometerDao, StationLandmarkDao stationLandmarkDao, PiezometerMeasureDao piezometerMeasureDao, SieauParametersDao SieauParametersDao2, QualityDao qualityDao, ThresholdDao thresholdDao, ParameterDao parameterDao, UnitDao unitDao, MethodDao methodDao, SandreCodeDao sandreCodeDao, SelectionDao SelectionDao2, CampaignDao CampaignDao2) {
        this.logUtil = logUtil;
        this.ModelFileExportController = ModelFileExportController2;
        this.piezoBookmarkBuilder = piezoBookmarkBuilder;
        this.qualitoBookmarkBuilder = qualitoBookmarkBuilder;
        this.pluvioBookmarkBuilder = pluvioBookmarkBuilder;
        this.hydroBookmarkBuilder = hydroBookmarkBuilder;
        this.qualitometerDao = qualitometerDao;
        this.piezometerDao = piezometerDao;
        this.stationLandmarkDao = stationLandmarkDao;
        this.piezometerMeasureDao = piezometerMeasureDao;
        this.SieauParametersDao = SieauParametersDao2;
        this.qualityDao = qualityDao;
        this.thresholdDao = thresholdDao;
        this.parameterDao = parameterDao;
        this.unitDao = unitDao;
        this.methodDao = methodDao;
        this.sandreCodeDao = sandreCodeDao;
        this.SelectionDao = SelectionDao2;
        this.CampaignDao = CampaignDao2;
        Producer.$init$((Producer)this);
        this.jasperModelRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("stationId").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("modelFileName").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("qualityFilter").readNullable((Reads)QualityFilter$.MODULE$.reads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

