/*
 * Decompiled with CFR 0.152.
 */
package controllers.fileExport;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constants.ExtensionTypeConstants$;
import constants.StationTypeConstants$;
import controllers.exportTmp.stationModelFile.ExportStationModelFileParams;
import domain.modelExport.ModelExportInput;
import domain.modelExport.ModelExportInput$;
import domain.modelExport.StationModelExport;
import domain.modelExport.StationModelExport$;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.util.Base64;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import model.bookmark.ExcelBuilder;
import model.bookmark.HydroBookmarkBuilder;
import model.bookmark.MapOfBookmarks;
import model.bookmark.PiezoBookmarkBuilder;
import model.bookmark.PluvioBookmarkBuilder;
import model.bookmark.QualitoBookmarkBuilder;
import model.bookmark.WordBuilder;
import org.joda.time.DateTime;
import play.api.Environment;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\n\u0014\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006Y\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0006g!AQ\b\u0001B\u0001B\u0003-a\b\u0003\u0005F\u0001\t\u0005\t\u0015a\u0003G\u0011!i\u0005A!A!\u0002\u0017q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b1\u0002,\t\u0011y\u0003!\u0011!Q\u0001\f}C\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ya\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0006O\"A!\u000e\u0001B\u0001B\u0003-1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015a\u0003p\u0011\u00151\b\u0001\"\u0001x\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002.\u0002!\t!a,\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=(!G'pI\u0016dg)\u001b7f\u000bb\u0004xN\u001d;D_:$(o\u001c7mKJT!\u0001F\u000b\u0002\u0015\u0019LG.Z#ya>\u0014HOC\u0001\u0017\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0013&D\u0001\"\u0015\t\u00113%A\u0002ba&T!\u0001J\u0013\u0002\u0011I\f'MY5u[FT!AJ\u0014\u0002\u000f\u0005\fX/Y:zg*\t\u0001&\u0001\u0002ge&\u0011!&\t\u0002\t!J|G-^2fe\u00069An\\4Vi&d\u0007CA\u00171\u001b\u0005q#BA\u0018$\u0003\u0011)H/\u001b7\n\u0005Er#a\u0002'pOV#\u0018\u000e\\\u0001\u000ea&,'p\\7fi\u0016\u0014H)Y8\u0011\u0005QZT\"A\u001b\u000b\u0005Y:\u0014aA5uM*\u0011\u0001(O\u0001\u000ba&,'p\\7fiJL(B\u0001\u001e&\u0003\u0015!\u0017-Z1v\u0013\taTGA\bQS\u0016Tx.\\3uKJ$\u0015-Z1v\u0003=\tX/\u00197ji>lW\r^3s\t\u0006|\u0007CA D\u001b\u0005\u0001%B\u0001\u001cB\u0015\t\u0011\u0015(A\u0004rk\u0006d\u0017\u000e^=\n\u0005\u0011\u0003%aD)vC2LGo\\7fi\u0016\u0014H)Y8\u0002\u001dAdWO^5p[\u0016$XM\u001d#b_B\u0011qiS\u0007\u0002\u0011*\u0011a'\u0013\u0006\u0003\u0015f\n1\u0002\u001d7vm&|W.\u001a;ss&\u0011A\n\u0013\u0002\u000f!2,h/[8nKR,'\u000fR1p\u0003YA\u0017\u0010\u001a:pY><\u0017nY1m'R\fG/[8o\t\u0006|\u0007CA(T\u001b\u0005\u0001&B\u0001\u001cR\u0015\t\u0011\u0016(\u0001\u0006is\u0012\u0014x.\\3uefL!\u0001\u0016)\u0003-!KHM]8m_\u001eL7-\u00197Ti\u0006$\u0018n\u001c8EC>\fA\u0003]5fu>\u0014un\\6nCJ\\')^5mI\u0016\u0014\bCA,]\u001b\u0005A&BA-[\u0003!\u0011wn\\6nCJ\\'\"A.\u0002\u000b5|G-\u001a7\n\u0005uC&\u0001\u0006)jKj|'i\\8l[\u0006\u00148NQ;jY\u0012,'/\u0001\frk\u0006d\u0017\u000e^8C_>\\W.\u0019:l\u0005VLG\u000eZ3s!\t9\u0006-\u0003\u0002b1\n1\u0012+^1mSR|'i\\8l[\u0006\u00148NQ;jY\u0012,'/A\u000bqYV4\u0018n\u001c\"p_.l\u0017M]6Ck&dG-\u001a:\u0011\u0005]#\u0017BA3Y\u0005U\u0001F.\u001e<j_\n{wn[7be.\u0014U/\u001b7eKJ\fA\u0003[=ee>\u0014un\\6nCJ\\')^5mI\u0016\u0014\bCA,i\u0013\tI\u0007L\u0001\u000bIs\u0012\u0014xNQ8pW6\f'o\u001b\"vS2$WM]\u0001\r\u000bb\u001cW\r\u001c\"vS2$WM\u001d\t\u0003/2L!!\u001c-\u0003\u0019\u0015C8-\u001a7Ck&dG-\u001a:\u0002\u0017\u0015sg/\u001b:p]6,g\u000e\u001e\t\u0003aRl\u0011!\u001d\u0006\u0003EIT\u0011a]\u0001\u0005a2\f\u00170\u0003\u0002vc\nYQI\u001c<je>tW.\u001a8u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0010\u0006\nzwrlhp`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001C\u0001>\u0001\u001b\u0005\u0019\u0002\"B\u0016\r\u0001\ba\u0003\"\u0002\u001a\r\u0001\b\u0019\u0004\"B\u001f\r\u0001\bq\u0004\"B#\r\u0001\b1\u0005\"B'\r\u0001\bq\u0005\"B+\r\u0001\b1\u0006\"\u00020\r\u0001\by\u0006\"\u00022\r\u0001\b\u0019\u0007\"\u00024\r\u0001\b9\u0007\"\u00026\r\u0001\bY\u0007\"\u00028\r\u0001\by\u0007f\u0001\u0007\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0002\u001a\u0005)!.\u0019<bq&!\u0011QDA\n\u0005\u0019IeN[3di\u00061Q\r\u001f9peR$\"\"a\t\u0002:\u00055\u0013QLA1!\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003SYRBAA\u0016\u0015\r\ticF\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E2$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003cY\u0002bBA\u001e\u001b\u0001\u0007\u0011QH\u0001\b[\u0016\u001c8/Y4f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nAA[:p]*\u0019\u0011qI9\u0002\t1L'm]\u0005\u0005\u0003\u0017\n\tEA\u0004KgZ\u000bG.^3\t\u000f\u0005=S\u00021\u0001\u0002R\u00059\u0001.Z1eKJ\u001c\b\u0003CA\u0013\u0003'\n\u0019#a\u0016\n\t\u0005U\u0013q\u0007\u0002\u0004\u001b\u0006\u0004\bc\u0001\u000e\u0002Z%\u0019\u00111L\u000e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002`5\u0001\r!a\t\u0002\r5|G-\u001e7f\u0011\u001d\t\u0019'\u0004a\u0001\u0003G\tA!^:fe\u0006\t\u0002O]3qCJ,W\t\u001f9peR4\u0015\u000e\\3\u0015\u0015\u0005%\u0014QOAE\u0003\u0017\u000bI\u000bE\u0003\u001b\u0003W\ny'C\u0002\u0002nm\u0011Q!\u0011:sCf\u00042AGA9\u0013\r\t\u0019h\u0007\u0002\u0005\u0005f$X\rC\u0004\u0002x9\u0001\r!!\u001f\u0002\rA\f'/Y7t!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0001c\u001d;bi&|g.T8eK24\u0015\u000e\\3\u000b\u0007\u0005\rU#A\u0005fqB|'\u000f\u001e+na&!\u0011qQA?\u0005q)\u0005\u0010]8siN#\u0018\r^5p]6{G-\u001a7GS2,\u0007+\u0019:b[NDaa\u0017\bA\u0002\u0005\r\u0002bBAG\u001d\u0001\u0007\u0011qR\u0001\ngR\f'\u000f\u001e#bi\u0016\u0004RAGAI\u0003+K1!a%\u001c\u0005\u0019y\u0005\u000f^5p]B!\u0011qSAS\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015\u0001\u0002;j[\u0016TA!a(\u0002\"\u0006!!n\u001c3b\u0015\t\t\u0019+A\u0002pe\u001eLA!a*\u0002\u001a\nAA)\u0019;f)&lW\rC\u0004\u0002,:\u0001\r!a$\u0002\u000f\u0015tG\rR1uK\u0006)r-\u001a;D_:$XM\u001c;Cs\u0016CH/\u001a8tS>tGCDAY\u0003g\u000b9-!5\u0002V\u0006}\u0017\u0011\u001d\t\u00065\u0005E\u0015\u0011\u000e\u0005\b\u0003k{\u0001\u0019AA\\\u0003Aiw\u000eZ3m\u000bb\u0004xN\u001d;J]B,H\u000f\u0005\u0003\u0002:\u0006\rWBAA^\u0015\u0011\ti,a0\u0002\u00175|G-\u001a7FqB|'\u000f\u001e\u0006\u0003\u0003\u0003\fa\u0001Z8nC&t\u0017\u0002BAc\u0003w\u0013\u0001#T8eK2,\u0005\u0010]8si&s\u0007/\u001e;\t\u000f\u0005%w\u00021\u0001\u0002L\u0006\u00112\u000f^1uS>tWj\u001c3fY\u0016C\bo\u001c:u!\u0011\tI,!4\n\t\u0005=\u00171\u0018\u0002\u0013'R\fG/[8o\u001b>$W\r\\#ya>\u0014H\u000fC\u0004\u0002T>\u0001\r!a\t\u0002\u0013\u0015DH/\u001a8tS>t\u0007bBAl\u001f\u0001\u0007\u0011\u0011\\\u0001\u0002[B\u0019q+a7\n\u0007\u0005u\u0007L\u0001\bNCB|eMQ8pW6\f'o[:\t\u000f\u00055u\u00021\u0001\u0002\u0010\"9\u00111V\bA\u0002\u0005=\u0015\u0001D4fi\u0016CH/\u001a8tS>tG\u0003BAt\u0003S\u0004RAGAI\u0003GAq!a;\u0011\u0001\u0004\t9,A\u0003j]B,H/A\u000bhKR\u001cF/\u0019;j_:lu\u000eZ3m\u000bb\u0004xN\u001d;\u0015\t\u0005E\u00181\u001f\t\u00065\u0005E\u00151\u001a\u0005\b\u0003W\f\u0002\u0019AA\\\u0001")
public class ModelFileExportController
implements Producer {
    private final LogUtil logUtil;
    private final PiezometerDaeau piezometerDao;
    private final QualitometerDao qualitometerDao;
    private final PluviometerDao pluviometerDao;
    private final HydrologicalStationDao hydrologicalStationDao;
    private final PiezoBookmarkBuilder piezoBookmarkBuilder;
    private final QualitoBookmarkBuilder qualitoBookmarkBuilder;
    private final PluvioBookmarkBuilder pluvioBookmarkBuilder;
    private final HydroBookmarkBuilder hydroBookmarkBuilder;
    private final ExcelBuilder ExcelBuilder;
    private final Environment Environment;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        ModelFileExportController modelFileExportController = this;
        synchronized (modelFileExportController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public String export(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ModelExportInput$.MODULE$.modelExportInputWrites()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(53).append("Error validate message for export with file model : \u00b0").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            ModelExportInput modelExportInput = validate;
            MapOfBookmarks m = new MapOfBookmarks();
            Option<StationModelExport> option = this.getStationModelExport(modelExportInput);
            if (option instanceof Some) {
                Some some = (Some)option;
                StationModelExport stationModelExport = (StationModelExport)some.value();
                Option<String> option2 = this.getExtension(modelExportInput);
                if (option2 instanceof Some) {
                    String string;
                    Success success;
                    String res;
                    Some some2 = (Some)option2;
                    String extension = (String)some2.value();
                    m.init();
                    String string2 = stationModelExport.stationType();
                    String string3 = StationTypeConstants$.MODULE$.STATION_TYPE_PIEZOMETER();
                    String string4 = string2;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        $this.piezoBookmarkBuilder.getMarkers(m, stationModelExport);
                        $this.qualitometerDao.get(stationModelExport.code()).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Qualitometer)s)).foreach((Function1 & Serializable)qualitoFound -> {
                            ModelFileExportController.$anonfun$export$4(this, m, qualitoFound);
                            return BoxedUnit.UNIT;
                        });
                        $this.piezometerDao.find(stationModelExport.code()).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Piezometer)s)).foreach((Function1 & Serializable)piezoFound -> {
                            ModelFileExportController.$anonfun$export$7(this, m, piezoFound);
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        String string5 = StationTypeConstants$.MODULE$.STATION_TYPE_QUALITOMETER();
                        String string6 = string2;
                        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                            $this.qualitoBookmarkBuilder.getMarkers(m, stationModelExport);
                        } else {
                            String string7 = StationTypeConstants$.MODULE$.STATION_TYPE_HYDROMETER();
                            String string8 = string2;
                            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                                $this.hydroBookmarkBuilder.getMarkers(m, stationModelExport);
                            } else {
                                String string9 = StationTypeConstants$.MODULE$.STATION_TYPE_PLUVIOMETER();
                                String string10 = string2;
                                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                    $this.pluvioBookmarkBuilder.getMarkers(m, stationModelExport);
                                }
                            }
                        }
                    }
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                        Option<byte[]> option = this.getContentByExtension(modelExportInput, stationModelExport, extension, m, (Option<DateTime>)None$.MODULE$, (Option<DateTime>)None$.MODULE$);
                        if (!(option instanceof Some)) {
                            throw new Exception(new StringBuilder(67).append("Can't build content by extension for station with id : ").append(modelExportInput.stationId()).append(" and type : ").append(modelExportInput.stationType()).toString());
                        }
                        Some some = (Some)option;
                        byte[] content = (byte[])some.value();
                        byte[] result = content;
                        return new String(Base64.getEncoder().encode(result));
                    });
                    if (try_ instanceof Success && (res = (String)(success = (Success)try_).value()) != null) {
                        String string11;
                        string = string11 = res;
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        err.printStackTrace();
                        $this.logUtil.error(new StringBuilder(47).append("Error during model file generation : , error : ").append(err.getMessage()).toString(), $this.logUtil.error$default$2());
                        $this.logUtil.printError(err);
                        string = "";
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    String encodedContent = string;
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"file"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)modelExportInput.filenameModelExport(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)encodedContent, (Writes)Writes$.MODULE$.StringWrites()))})), (Writes)JsObject$.MODULE$.writes()))})).toString();
                }
                $this.logUtil.error(new StringBuilder(76).append("Extension not matching : ").append(modelExportInput.filenameModelExport()).append(" unable to export without .xlsm or .docx extensions").toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(51).append("No station found for station with id : ").append(modelExportInput.stationId()).append(" and type : ").append(modelExportInput.stationType()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public byte[] prepareExportFile(ExportStationModelFileParams params, String model, Option<DateTime> startDate, Option<DateTime> endDate) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ModelExportInput modelExportInput = ModelExportInput$.MODULE$.toModelExportInput(params, model);
            MapOfBookmarks m = new MapOfBookmarks();
            Option<StationModelExport> option = this.getStationModelExport(modelExportInput);
            if (option instanceof Some) {
                Some some = (Some)option;
                StationModelExport stationModelExport = (StationModelExport)some.value();
                Option<String> option2 = this.getExtension(modelExportInput);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String extension = (String)some2.value();
                    m.init();
                    String string = stationModelExport.stationType();
                    String string2 = StationTypeConstants$.MODULE$.STATION_TYPE_PIEZOMETER();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        $this.piezoBookmarkBuilder.getMarkers(m, stationModelExport);
                        $this.qualitometerDao.get(stationModelExport.code()).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Qualitometer)s)).foreach((Function1 & Serializable)qualitoFound -> {
                            ModelFileExportController.$anonfun$prepareExportFile$3(this, m, qualitoFound);
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        String string4 = StationTypeConstants$.MODULE$.STATION_TYPE_QUALITOMETER();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            $this.qualitoBookmarkBuilder.getMarkers(m, stationModelExport);
                            $this.piezometerDao.find(stationModelExport.code()).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Piezometer)s)).foreach((Function1 & Serializable)piezoFound -> {
                                ModelFileExportController.$anonfun$prepareExportFile$6(this, m, piezoFound);
                                return BoxedUnit.UNIT;
                            });
                        } else {
                            String string6 = StationTypeConstants$.MODULE$.STATION_TYPE_HYDROMETER();
                            String string7 = string;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                $this.hydroBookmarkBuilder.getMarkers(m, stationModelExport);
                            } else {
                                String string8 = StationTypeConstants$.MODULE$.STATION_TYPE_PLUVIOMETER();
                                String string9 = string;
                                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                    $this.pluvioBookmarkBuilder.getMarkers(m, stationModelExport);
                                }
                            }
                        }
                    }
                    Option<byte[]> option3 = this.getContentByExtension(modelExportInput, stationModelExport, extension, m, startDate, endDate);
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        byte[] content = (byte[])some3.value();
                        return content;
                    }
                    throw new Exception(new StringBuilder(67).append("Can't build content by extension for station with id : ").append(modelExportInput.stationId()).append(" and type : ").append(modelExportInput.stationType()).toString());
                }
                throw new Exception(new StringBuilder(51).append("No station found for station with id : ").append(modelExportInput.stationId()).append(" and type : ").append(modelExportInput.stationType()).toString());
            }
            throw new Exception(new StringBuilder(51).append("No station found for station with id : ").append(modelExportInput.stationId()).append(" and type : ").append(modelExportInput.stationType()).toString());
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] r = (byte[])success.value();
            return r;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logUtil.printError(e);
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public Option<byte[]> getContentByExtension(ModelExportInput modelExportInput, StationModelExport stationModelExport, String extension, MapOfBookmarks m, Option<DateTime> startDate, Option<DateTime> endDate) {
        boolean bl;
        String string = extension;
        String string2 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_WORD();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logUtil.debug("Start of Word Builder...", this.logUtil.debug$default$2());
            WordBuilder wordBuilder = new WordBuilder();
            this.logUtil.debug("End of Word Builder...", this.logUtil.debug$default$2());
            byte[] result = wordBuilder.buildDocument(m, modelExportInput.filenameModelExport(), (String)modelExportInput.resultFileName().getOrElse((Function0 & Serializable)() -> new StringBuilder(0).append(modelExportInput.filenameModelExport().split("\\.(?=[^\\.]+$)")[0]).append(ExtensionTypeConstants$.MODULE$.EXPORTED_POSTFIX()).toString()), stationModelExport.stationType(), this.Environment);
            return new Some((Object)result);
        }
        String string4 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLS();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
        } else {
            String string6 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLSX();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                bl = true;
            } else {
                String string8 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLSM();
                String string9 = string;
                bl = !(string8 != null ? !string8.equals(string9) : string9 != null);
            }
        }
        if (bl) {
            this.logUtil.debug("Start of Excel Builder...", this.logUtil.debug$default$2());
            this.logUtil.debug("End of Excel Builder...", this.logUtil.debug$default$2());
            byte[] result = this.ExcelBuilder.buildDocument(stationModelExport, m, modelExportInput.filenameModelExport(), (String)modelExportInput.resultFileName().getOrElse((Function0 & Serializable)() -> new StringBuilder(0).append(modelExportInput.filenameModelExport().split("\\.(?=[^\\.]+$)")[0]).append(ExtensionTypeConstants$.MODULE$.EXPORTED_POSTFIX()).toString()), extension, startDate, endDate);
            return new Some((Object)result);
        }
        throw new Exception(new StringBuilder(76).append("Extension not matching : ").append(modelExportInput.filenameModelExport()).append(" unable to export without .xlsm or .docx extensions").toString());
    }

    public Option<String> getExtension(ModelExportInput input) {
        String extension;
        String string = extension = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])input.filenameModelExport().split("\\.")));
        String string2 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_WORD();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new Some((Object)extension);
        }
        String string4 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_WORD_MODEL();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new Some((Object)extension);
        }
        String string6 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLS();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new Some((Object)extension);
        }
        String string8 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLSX();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new Some((Object)extension);
        }
        String string10 = ExtensionTypeConstants$.MODULE$.EXTENSION_TYPE_EXCEL_XLSM();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new Some((Object)extension);
        }
        return None$.MODULE$;
    }

    public Option<StationModelExport> getStationModelExport(ModelExportInput input) {
        String string = input.stationType();
        String string2 = StationTypeConstants$.MODULE$.STATION_TYPE_PIEZOMETER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.piezometerDao.find(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(input.stationId()))).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Piezometer)s));
        }
        String string4 = StationTypeConstants$.MODULE$.STATION_TYPE_QUALITOMETER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.qualitometerDao.get(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(input.stationId()))).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Qualitometer)s));
        }
        String string6 = StationTypeConstants$.MODULE$.STATION_TYPE_PLUVIOMETER();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.pluviometerDao.get(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(input.stationId()))).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((Pluviometer)s));
        }
        String string8 = StationTypeConstants$.MODULE$.STATION_TYPE_HYDROMETER();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.hydrologicalStationDao.get(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(input.stationId()))).map((Function1 & Serializable)s -> StationModelExport$.MODULE$.toStationModelExport((HydroStation)s));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$export$5(MapOfBookmarks m2$1, MapOfBookmarks m$1, String k) {
        String string = m2$1.get(k).trim();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = m$1.get(k).trim();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                m$1.add(k, (Object)m2$1.get(k));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$export$4(ModelFileExportController $this, MapOfBookmarks m$1, StationModelExport qualitoFound) {
        MapOfBookmarks m2 = new MapOfBookmarks();
        m2.init();
        $this.qualitoBookmarkBuilder.getMarkers(m2, qualitoFound);
        m2.bookmarks().keys().foreach((Function1 & Serializable)k -> {
            ModelFileExportController.$anonfun$export$5(m2, m$1, k);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$export$8(MapOfBookmarks m2$2, MapOfBookmarks m$1, String k) {
        String string = m2$2.get(k).trim();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = m$1.get(k).trim();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                m$1.add(k, (Object)m2$2.get(k));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$export$7(ModelFileExportController $this, MapOfBookmarks m$1, StationModelExport piezoFound) {
        MapOfBookmarks m2 = new MapOfBookmarks();
        m2.init();
        $this.piezoBookmarkBuilder.getMarkers(m2, piezoFound);
        m2.bookmarks().keys().foreach((Function1 & Serializable)k -> {
            ModelFileExportController.$anonfun$export$8(m2, m$1, k);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prepareExportFile$4(MapOfBookmarks m2$3, MapOfBookmarks m$2, String k) {
        String string = m2$3.get(k).trim();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = m$2.get(k).trim();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                m$2.add(k, (Object)m2$3.get(k));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$prepareExportFile$3(ModelFileExportController $this, MapOfBookmarks m$2, StationModelExport qualitoFound) {
        MapOfBookmarks m2 = new MapOfBookmarks();
        m2.init();
        $this.qualitoBookmarkBuilder.getMarkers(m2, qualitoFound);
        m2.bookmarks().keys().foreach((Function1 & Serializable)k -> {
            ModelFileExportController.$anonfun$prepareExportFile$4(m2, m$2, k);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prepareExportFile$7(MapOfBookmarks m2$4, MapOfBookmarks m$2, String k) {
        String string = m2$4.get(k).trim();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = m$2.get(k).trim();
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                m$2.add(k, (Object)m2$4.get(k));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$prepareExportFile$6(ModelFileExportController $this, MapOfBookmarks m$2, StationModelExport piezoFound) {
        MapOfBookmarks m2 = new MapOfBookmarks();
        m2.init();
        $this.piezoBookmarkBuilder.getMarkers(m2, piezoFound);
        m2.bookmarks().keys().foreach((Function1 & Serializable)k -> {
            ModelFileExportController.$anonfun$prepareExportFile$7(m2, m$2, k);
            return BoxedUnit.UNIT;
        });
    }

    @Inject
    public ModelFileExportController(LogUtil logUtil, PiezometerDaeau piezometerDao, QualitometerDao qualitometerDao, PluviometerDao pluviometerDao, HydrologicalStationDao hydrologicalStationDao, PiezoBookmarkBuilder piezoBookmarkBuilder, QualitoBookmarkBuilder qualitoBookmarkBuilder, PluvioBookmarkBuilder pluvioBookmarkBuilder, HydroBookmarkBuilder hydroBookmarkBuilder, ExcelBuilder ExcelBuilder2, Environment Environment2) {
        this.logUtil = logUtil;
        this.piezometerDao = piezometerDao;
        this.qualitometerDao = qualitometerDao;
        this.pluviometerDao = pluviometerDao;
        this.hydrologicalStationDao = hydrologicalStationDao;
        this.piezoBookmarkBuilder = piezoBookmarkBuilder;
        this.qualitoBookmarkBuilder = qualitoBookmarkBuilder;
        this.pluvioBookmarkBuilder = pluvioBookmarkBuilder;
        this.hydroBookmarkBuilder = hydroBookmarkBuilder;
        this.ExcelBuilder = ExcelBuilder2;
        this.Environment = Environment2;
        Producer.$init$((Producer)this);
    }
}

