/*
 * Decompiled with CFR 0.152.
 */
package controllers.fileExport;

import fr.aquasys.daeau.export.ExportedData;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import util.AquasysCellStyle;
import util.AquasysCellStyle$;
import util.ExcelBuilderUtil$;

@ScalaSignature(bytes="\u0006\u0005y3AAB\u0004\u0001\u0019!A1\u0003\u0001B\u0001B\u0003-A\u0003C\u0003!\u0001\u0011\u0005\u0011\u0005C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003Y\u0001\u0011\u0005\u0011\fC\u0003\\\u0001\u0011\u0005AL\u0001\rY\u0019N{'oQ*W\u000bb\u0004xN\u001d;D_:$(o\u001c7mKJT!\u0001C\u0005\u0002\u0015\u0019LG.Z#ya>\u0014HOC\u0001\u000b\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011QCH\u0007\u0002-)\u0011q\u0003G\u0001\u0005kRLGN\u0003\u0002\u001a5\u0005A!/\u00192cSRl\u0017O\u0003\u0002\u001c9\u00059\u0011-];bgf\u001c(\"A\u000f\u0002\u0005\u0019\u0014\u0018BA\u0010\u0017\u0005\u001daunZ+uS2\fa\u0001P5oSRtD#\u0001\u0012\u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u00059\u0001\"B\n\u0003\u0001\b!\u0002F\u0001\u0002(!\tAS&D\u0001*\u0015\tQ3&\u0001\u0004j]*,7\r\u001e\u0006\u0002Y\u0005)!.\u0019<bq&\u0011a&\u000b\u0002\u0007\u0013:TWm\u0019;\u0002\u0015\u0015D\bo\u001c:u\r&dW\rF\u00022o\u0011\u00032A\u0004\u001a5\u0013\t\u0019tBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000fk%\u0011ag\u0004\u0002\u0005\u0005f$X\rC\u00039\u0007\u0001\u0007\u0011(\u0001\u0006fqB|'\u000f\u001e+za\u0016\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f\u0010\u001b\u0005i$B\u0001 \f\u0003\u0019a$o\\8u}%\u0011\u0001iD\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A\u001f!)Qi\u0001a\u0001\r\u0006!A-\u0019;b!\r9Ej\u0014\b\u0003\u0011*s!\u0001P%\n\u0003AI!aS\b\u0002\u000fA\f7m[1hK&\u0011QJ\u0014\u0002\u0004'\u0016\f(BA&\u0010!\r9E\n\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000ba!\u001a=q_J$(BA+\u001b\u0003\u0015!\u0017-Z1v\u0013\t9&K\u0001\u0007FqB|'\u000f^3e\t\u0006$\u0018-A\u0005dgZ,\u0005\u0010]8siR\u0011\u0011G\u0017\u0005\u0006\u000b\u0012\u0001\rAR\u0001\nq2\u001cX\t\u001f9peR$\"!M/\t\u000b\u0015+\u0001\u0019\u0001$")
public class XLSorCSVExportController {
    private final LogUtil logUtil;

    public byte[] exportFile(String exportType, Seq<Seq<ExportedData>> data) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String string = exportType;
            switch (string == null ? 0 : string.hashCode()) {
                case 98822: {
                    if (!"csv".equals(string)) break;
                    return this.csvExport(data);
                }
                case 3682382: {
                    if (!"xlsm".equals(string)) break;
                    return this.xlsExport(data);
                }
                case 3682393: {
                    if (!"xlsx".equals(string)) break;
                    return this.xlsExport(data);
                }
            }
            throw new Exception("Unkwnown Export Type");
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] res = (byte[])success.value();
            return res;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            this.logUtil.error("Error during export", this.logUtil.error$default$2());
            this.logUtil.printError(err);
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public byte[] csvExport(Seq<Seq<ExportedData>> data) {
        scala.collection.mutable.StringBuilder content = new scala.collection.mutable.StringBuilder();
        data.foreach((Function1 & Serializable)dataRow -> {
            scala.collection.mutable.StringBuilder row = new scala.collection.mutable.StringBuilder("");
            IntRef rowIndex = IntRef.create((int)0);
            dataRow.foreach((Function1 & Serializable)dataCell -> {
                XLSorCSVExportController.$anonfun$csvExport$2(rowIndex, row, dataCell);
                return BoxedUnit.UNIT;
            });
            content.append(row);
            return content.append(System.lineSeparator());
        });
        return content.toString().getBytes();
    }

    public byte[] xlsExport(Seq<Seq<ExportedData>> data) {
        IntRef nbCols = IntRef.create((int)0);
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet worksheet = workbook.createSheet("Export");
        AquasysCellStyle ACS = new AquasysCellStyle((Workbook)workbook, AquasysCellStyle$.MODULE$.apply$default$2());
        Row firstRow = worksheet.createRow(0);
        Seq header = (Seq)data.head();
        Seq rest = (Seq)data.tail();
        this.logUtil.info("making headers", this.logUtil.info$default$2());
        HashMap colSize = new HashMap();
        header.foreach((Function1 & Serializable)dataCell -> {
            XLSorCSVExportController.$anonfun$xlsExport$2(firstRow, nbCols, workbook, colSize, dataCell);
            return BoxedUnit.UNIT;
        });
        this.logUtil.info("setting data", this.logUtil.info$default$2());
        Row row = worksheet.createRow(1);
        Cell cell = row.createCell(0);
        ExcelBuilderUtil$.MODULE$.setDataBookmarkInExcel(cell, (Seq<Seq<ExportedData>>)rest, ACS, ExcelBuilderUtil$.MODULE$.setDataBookmarkInExcel$default$4());
        this.logUtil.info("End filling rows and cells", this.logUtil.info$default$2());
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        workbook.write((OutputStream)byteOut);
        byteOut.close();
        workbook.dispose();
        return byteOut.toByteArray();
    }

    public static final /* synthetic */ void $anonfun$csvExport$2(IntRef rowIndex$1, scala.collection.mutable.StringBuilder row$1, ExportedData dataCell) {
        scala.collection.mutable.StringBuilder stringBuilder = rowIndex$1.elem != 0 ? row$1.append(new StringBuilder(1).append(";").append(((String)dataCell.value().getOrElse((Function0 & Serializable)() -> "")).replace("\n", " ").replace("\r", " ")).toString()) : row$1.append(((String)dataCell.value().getOrElse((Function0 & Serializable)() -> "")).replace("\n", " ").replace("\r", " "));
        ++rowIndex$1.elem;
    }

    private static final void setSize$1(int size, int col, HashMap colSize$1) {
        if (BoxesRunTime.unboxToInt((Object)colSize$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)col), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < size) {
            colSize$1.update((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)size));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$xlsExport$2(Row firstRow$1, IntRef nbCols$1, SXSSFWorkbook workbook$1, HashMap colSize$1, ExportedData dataCell) {
        Cell cell = firstRow$1.createCell(nbCols$1.elem);
        cell.setCellStyle(ExcelBuilderUtil$.MODULE$.setHeaderStyleCell((Workbook)workbook$1));
        String value = (String)dataCell.value().getOrElse((Function0 & Serializable)() -> "");
        XLSorCSVExportController.setSize$1(value.length() * 2, nbCols$1.elem, colSize$1);
        ExcelBuilderUtil$.MODULE$.setCellValue("string", value, cell, ExcelBuilderUtil$.MODULE$.setCellValue$default$4());
        cell.setCellType(ExcelBuilderUtil$.MODULE$.setHeaderTypeCell());
        ++nbCols$1.elem;
    }

    @Inject
    public XLSorCSVExportController(LogUtil logUtil) {
        this.logUtil = logUtil;
    }
}

