/*
 * Decompiled with CFR 0.152.
 */
package controllers.fileExport.researchExport;

import constants.ExtensionTypeConstants$;
import constants.StationTypeConstants$;
import controllers.fileExport.XLSorCSVExportController;
import dao.itf.AnalysisDao;
import domain.modelExport.ModelResearchExportInput;
import domain.modelExport.ModelResearchExportInput$;
import fr.aquasys.daeau.export.ExportedData;
import fr.aquasys.daeau.export.ExportedData$;
import fr.aquasys.daeau.export.exportTmp.ExportTmp;
import fr.aquasys.daeau.export.exportTmp.ExportTmpDao;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.domain.input.SearchAnalysisInput;
import fr.aquasys.daeau.quality.domain.input.SearchIndicesInput;
import fr.aquasys.daeau.quality.domain.input.SearchIndicesInput$;
import fr.aquasys.daeau.quality.domain.input.SearchStateInput;
import fr.aquasys.daeau.quality.domain.output.SearchIndicesOutput;
import fr.aquasys.daeau.quality.itf.IndicesDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.itf.QualityStateDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.quality.model.QualitometerState;
import fr.aquasys.daeau.quality.threshold.ParameterThreshold;
import fr.aquasys.daeau.quality.threshold.Threshold;
import fr.aquasys.daeau.quality.threshold.ThresholdDao;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.CityLight;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.fraction.itf.FractionDao;
import fr.aquasys.daeau.referentials.parameter.domain.Parameter;
import fr.aquasys.daeau.referentials.parameter.domain.ParameterLight;
import fr.aquasys.daeau.referentials.parameter.itf.ParameterDao;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.support.itf.SupportDao;
import fr.aquasys.daeau.referentials.unit.itf.UnitDao;
import fr.aquasys.daeau.referentials.unit.model.Unit;
import fr.aquasys.daeau.referentials.watermass.itf.WatermassDao;
import fr.aquasys.daeau.referentials.watershed.itf.WatershedDao;
import fr.aquasys.daeau.referentials.watershed.model.Watershed;
import fr.aquasys.daeau.station.links.watermass.StationWatermass;
import fr.aquasys.daeau.station.links.watermass.StationWatermassDao;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.ReferentialUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.inject.Inject;
import model.bookmark.ExcelBuilder;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import play.api.Environment;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import util.ExcelBuilderUtil$;
import util.ExportFileUtils$;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001\u0002\u0014(\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006YA\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0006\u0007\"Aq\n\u0001B\u0001B\u0003-\u0001\u000b\u0003\u0005X\u0001\t\u0005\t\u0015a\u0003Y\u0011!y\u0006A!A!\u0002\u0017\u0001\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b1\u00025\t\u0011=\u0004!\u0011!Q\u0001\fAD\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006Y!\u001f\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\f\u0005\u0015\u0001BCA\n\u0001\t\u0005\t\u0015a\u0003\u0002\u0016!Q\u00111\u0005\u0001\u0003\u0002\u0003\u0006Y!!\n\t\u0015\u0005M\u0002A!A!\u0002\u0017\t)\u0004\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0006\u0003\u0003B!\"a\u0014\u0001\u0005\u0003\u0005\u000b1BA)\u0011)\t\t\u0007\u0001B\u0001B\u0003-\u00111\r\u0005\u000b\u0003o\u0002!\u0011!Q\u0001\f\u0005e\u0004BCA@\u0001\t\u0005\t\u0015a\u0003\u0002\u0002\"Q\u0011q\u0011\u0001\u0003\u0002\u0003\u0006Y!!#\t\u0015\u0005U\u0005A!A!\u0002\u0017\t9\n\u0003\u0006\u0002 \u0002\u0011\t\u0011)A\u0006\u0003CCq!!-\u0001\t\u0003\t\u0019\fC\u0004\u0002v\u0002!\t!a>\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003\"\u0003BH\u0001E\u0005I\u0011\u0001BI\u0011%\u00119\u000bAI\u0001\n\u0003\u0011I\u000bC\u0004\u0003.\u0002!\tAa,\t\u0013\r]\u0001!%A\u0005\u0002\tE\u0005\"CB\r\u0001E\u0005I\u0011\u0001BU\u0011\u001d\u0019Y\u0002\u0001C\u0001\u0007;Aqaa\u0017\u0001\t\u0003\u0019i\u0006C\u0004\u0004h\u0001!\ta!\u001b\t\u000f\r=\u0004\u0001\"\u0001\u0004r!91q\u000f\u0001\u0005\u0002\re\u0004bBB@\u0001\u0011\u00051\u0011\u0011\u0005\b\u0007'\u0003A\u0011ABK\u0011\u001d\u0019i\n\u0001C\u0001\u0007?\u0013\u0001DU3tK\u0006\u00148\r[#ya>\u0014HoQ8oiJ|G\u000e\\3s\u0015\tA\u0013&\u0001\bsKN,\u0017M]2i\u000bb\u0004xN\u001d;\u000b\u0005)Z\u0013A\u00034jY\u0016,\u0005\u0010]8si*\tA&A\u0006d_:$(o\u001c7mKJ\u001c8\u0001A\n\u0003\u0001=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003o\u0001k\u0011\u0001\u000f\u0006\u0003si\nA!\u001e;jY*\u00111\bP\u0001\te\u0006\u0014'-\u001b;nc*\u0011QHP\u0001\bCF,\u0018m]=t\u0015\u0005y\u0014A\u00014s\u0013\t\t\u0005HA\u0004M_\u001e,F/\u001b7\u0002\u001f\r|g\u000e\u001e:jEV$xN]:EC>\u0004\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\u0007%$hM\u0003\u0002I\u0013\u0006Y1m\u001c8ue&\u0014W\u000f^8s\u0015\tQ5*\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7O\u0003\u0002My\u0005)A-Y3bk&\u0011a*\u0012\u0002\u0010\u0007>tGO]5ckR|'o\u001d#b_\u00069QO\\5u\t\u0006|\u0007CA)V\u001b\u0005\u0011&B\u0001$T\u0015\t!\u0016*\u0001\u0003v]&$\u0018B\u0001,S\u0005\u001d)f.\u001b;EC>\fA\u0002]1sC6,G/\u001a:EC>\u0004\"!W/\u000e\u0003iS!AR.\u000b\u0005qK\u0015!\u00039be\u0006lW\r^3s\u0013\tq&L\u0001\u0007QCJ\fW.\u001a;fe\u0012\u000bw.\u0001\u0006tkB\u0004xN\u001d;EC>\u0004\"!Y3\u000e\u0003\tT!AR2\u000b\u0005\u0011L\u0015aB:vaB|'\u000f^\u0005\u0003M\n\u0014!bU;qa>\u0014H\u000fR1p\u0003-1'/Y2uS>tG)Y8\u0011\u0005%lW\"\u00016\u000b\u0005\u0019['B\u00017J\u0003!1'/Y2uS>t\u0017B\u00018k\u0005-1%/Y2uS>tG)Y8\u0002\u0019\u0015C8-\u001a7Ck&dG-\u001a:\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00032p_.l\u0017M]6\u000b\u0003U\fQ!\\8eK2L!a\u001e:\u0003\u0019\u0015C8-\u001a7Ck&dG-\u001a:\u0002\u0019QD'/Z:i_2$G)Y8\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!\u0003;ie\u0016\u001c\bn\u001c7e\u0015\tq8*A\u0004rk\u0006d\u0017\u000e^=\n\u0007\u0005\u00051P\u0001\u0007UQJ,7\u000f[8mI\u0012\u000bw.A\u0006b]\u0006d\u0017p]5t\t\u0006|\u0007\u0003BA\u0004\u0003\u001fi!!!\u0003\u000b\u0007\u0019\u000bYA\u0003\u0002\u0002\u000e\u0005\u0019A-Y8\n\t\u0005E\u0011\u0011\u0002\u0002\f\u0003:\fG._:jg\u0012\u000bw.\u0001\u0007xCR,'o\u001d5fI\u0012\u000bw\u000e\u0005\u0003\u0002\u0018\u0005}QBAA\r\u0015\r1\u00151\u0004\u0006\u0004\u0003;I\u0015!C<bi\u0016\u00148\u000f[3e\u0013\u0011\t\t#!\u0007\u0003\u0019]\u000bG/\u001a:tQ\u0016$G)Y8\u0002\u001bM\fg\u000e\u001a:f\u0007>$W\rR1p!\u0011\t9#a\f\u000e\u0005\u0005%\"\u0002BA\u0007\u0003WQ1!!\fJ\u0003)\u0019\u0018M\u001c3sK\u000e{G-Z\u0005\u0005\u0003c\tICA\u0007TC:$'/Z\"pI\u0016$\u0015m\\\u0001\u0010cV\fG.\u001b;p[\u0016$XM\u001d#b_B!\u0011qGA\u001e\u001b\t\tID\u0003\u0002G{&!\u0011QHA\u001d\u0005=\tV/\u00197ji>lW\r^3s\t\u0006|\u0017aB2jif$\u0015m\u001c\t\u0005\u0003\u0007\nY%\u0004\u0002\u0002F)\u0019a)a\u0012\u000b\u0007\u0005%\u0013*\u0001\u0003dSRL\u0018\u0002BA'\u0003\u000b\u0012qaQ5us\u0012\u000bw.A\u0006f]ZL'o\u001c8nK:$\b\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0004CBL'BAA.\u0003\u0011\u0001H.Y=\n\t\u0005}\u0013Q\u000b\u0002\f\u000b:4\u0018N]8o[\u0016tG/A\nTi\u0006$\u0018n\u001c8XCR,'/\\1tg\u0012\u000bw\u000e\u0005\u0003\u0002f\u0005MTBAA4\u0015\u0011\tI'a\u001b\u0002\u0013]\fG/\u001a:nCN\u001c(\u0002BA7\u0003_\nQ\u0001\\5oWNT1!!\u001dL\u0003\u001d\u0019H/\u0019;j_:LA!!\u001e\u0002h\t\u00192\u000b^1uS>tw+\u0019;fe6\f7o\u001d#b_\u0006Q\u0011J\u001c3jG\u0016\u001cH)Y8\u0011\t\u0005]\u00121P\u0005\u0005\u0003{\nID\u0001\u0006J]\u0012L7-Z:EC>\fq\"U;bY&$\u0018p\u0015;bi\u0016$\u0015m\u001c\t\u0005\u0003o\t\u0019)\u0003\u0003\u0002\u0006\u0006e\"aD)vC2LG/_*uCR,G)Y8\u0002\u0019]\u000bG/\u001a:nCN\u001cH)Y8\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1ARAH\u0015\r\tI'S\u0005\u0005\u0003'\u000biI\u0001\u0007XCR,'/\\1tg\u0012\u000bw.\u0001\rY\u0019N{'oQ*W\u000bb\u0004xN\u001d;D_:$(o\u001c7mKJ\u0004B!!'\u0002\u001c6\t\u0011&C\u0002\u0002\u001e&\u0012\u0001\u0004\u0017'T_J\u001c5KV#ya>\u0014HoQ8oiJ|G\u000e\\3s\u00031)\u0005\u0010]8siRk\u0007\u000fR1p!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000b\u0011\"\u001a=q_J$H+\u001c9\u000b\u0007\u0005-6*\u0001\u0004fqB|'\u000f^\u0005\u0005\u0003_\u000b)K\u0001\u0007FqB|'\u000f\u001e+na\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003k#\"&a.\u0002<\u0006u\u0016qXAa\u0003\u0007\f)-a2\u0002J\u0006-\u0017QZAh\u0003#\f\u0019.!6\u0002X\u0006e\u00171\\Ao\u0003?\f\t\u000fE\u0002\u0002:\u0002i\u0011a\n\u0005\u0006kU\u0001\u001dA\u000e\u0005\u0006\u0005V\u0001\u001da\u0011\u0005\u0006\u001fV\u0001\u001d\u0001\u0015\u0005\u0006/V\u0001\u001d\u0001\u0017\u0005\u0006?V\u0001\u001d\u0001\u0019\u0005\u0006OV\u0001\u001d\u0001\u001b\u0005\u0006_V\u0001\u001d\u0001\u001d\u0005\u0006qV\u0001\u001d!\u001f\u0005\b\u0003\u0007)\u00029AA\u0003\u0011\u001d\t\u0019\"\u0006a\u0002\u0003+Aq!a\t\u0016\u0001\b\t)\u0003C\u0004\u00024U\u0001\u001d!!\u000e\t\u000f\u0005}R\u0003q\u0001\u0002B!9\u0011qJ\u000bA\u0004\u0005E\u0003bBA1+\u0001\u000f\u00111\r\u0005\b\u0003o*\u00029AA=\u0011\u001d\ty(\u0006a\u0002\u0003\u0003Cq!a\"\u0016\u0001\b\tI\tC\u0004\u0002\u0016V\u0001\u001d!a&\t\u000f\u0005}U\u0003q\u0001\u0002\"\"\u001aQ#!:\u0011\t\u0005\u001d\u0018\u0011_\u0007\u0003\u0003STA!a;\u0002n\u00061\u0011N\u001c6fGRT!!a<\u0002\u000b)\fg/\u0019=\n\t\u0005M\u0018\u0011\u001e\u0002\u0007\u0013:TWm\u0019;\u0002E\u0015D\bo\u001c:u#V\fG.\u001b;z%\u0016\u001cX-\u0019:dQ\u001a\u0013x.\\#ya>\u0014H\u000fV7q)\u0019\tIPa\u0004\u0003\u0018A!\u00111 B\u0005\u001d\u0011\tiP!\u0002\u0011\u0007\u0005}\u0018'\u0004\u0002\u0003\u0002)\u0019!1A\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\u00119!M\u0001\u0007!J,G-\u001a4\n\t\t-!Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\u001d\u0011\u0007C\u0004\u0002(Z\u0001\rA!\u0005\u0011\t\u0005\r&1C\u0005\u0005\u0005+\t)KA\u0005FqB|'\u000f\u001e+na\"9!\u0011\u0004\fA\u0002\tm\u0011A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u0004a\tu\u0011b\u0001B\u0010c\t!Aj\u001c8h\u0003e)\u0007\u0010]8siF+\u0018\r\\5usJ+7/Z1sG\"\u001c\u0016P\\2\u0015\u0015\u0005e(Q\u0005B\u001d\u0005\u0013\u0012i\u0005C\u0004\u0003(]\u0001\rA!\u000b\u0002\u000f5,7o]1hKB!!1\u0006B\u001b\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012\u0001\u00026t_:TAAa\r\u0002V\u0005!A.\u001b2t\u0013\u0011\u00119D!\f\u0003\u000f)\u001bh+\u00197vK\"9!1H\fA\u0002\tu\u0012a\u00025fC\u0012,'o\u001d\t\t\u0003w\u0014y$!?\u0003D%!!\u0011\tB\u0007\u0005\ri\u0015\r\u001d\t\u0004a\t\u0015\u0013b\u0001B$c\t\u0019\u0011I\\=\t\u000f\t-s\u00031\u0001\u0002z\u00061Qn\u001c3vY\u0016DqAa\u0014\u0018\u0001\u0004\tI0\u0001\u0003vg\u0016\u0014\u0018AD3ya>\u0014HOU3tK\u0006\u00148\r\u001b\u000b\t\u0005+\u00129Ga\u001f\u0003\fBA!q\u000bB1\u0003s\fIP\u0004\u0003\u0003Z\tuc\u0002BA\u0000\u00057J\u0011AM\u0005\u0004\u0005?\n\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0012)G\u0001\u0004FSRDWM\u001d\u0006\u0004\u0005?\n\u0004b\u0002B51\u0001\u0007!1N\u0001\u000bKb\u0004xN\u001d;ECR\f\u0007\u0003\u0002B7\u0005oj!Aa\u001c\u000b\t\tE$1O\u0001\f[>$W\r\\#ya>\u0014HO\u0003\u0002\u0003v\u00051Am\\7bS:LAA!\u001f\u0003p\tARj\u001c3fYJ+7/Z1sG\",\u0005\u0010]8si&s\u0007/\u001e;\t\u0013\tu\u0004\u0004%AA\u0002\t}\u0014aC3ya>\u0014H\u000fV7q\u0013\u0012\u0004R\u0001\rBA\u0005\u000bK1Aa!2\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001Ga\"\n\u0007\t%\u0015GA\u0002J]RD\u0011B!\u0007\u0019!\u0003\u0005\rA!$\u0011\u000bA\u0012\tIa\u0007\u00021\u0015D\bo\u001c:u%\u0016\u001cX-\u0019:dQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0014*\"!q\u0010BKW\t\u00119\n\u0005\u0003\u0003\u001a\n\rVB\u0001BN\u0015\u0011\u0011iJa(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BQc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015&1\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G3ya>\u0014HOU3tK\u0006\u00148\r\u001b\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0016\u0016\u0005\u0005\u001b\u0013)*A\u000bck&dGMU3tK\u0006\u00148\r\u001b#pGVlWM\u001c;\u0015-\tE&Q\u0017B\\\u0005\u0017\u0014YNa;\u0003p\nE8\u0011AB\n\u0007+!B!!?\u00034\"9\u0011qJ\u000eA\u0004\u0005E\u0003b\u0002B57\u0001\u0007!1\u000e\u0005\b\u0005s[\u0002\u0019\u0001B^\u0003Q\u0019X-\u0019:dQ\u0006s\u0017\r\\=tSN\u0014Vm];miB1!q\u000bB_\u0005\u0003LAAa0\u0003f\t\u00191+Z9\u0011\r\t]#Q\u0018Bb!\u0011\u0011)Ma2\u000e\u0005\u0005%\u0016\u0002\u0002Be\u0003S\u0013A\"\u0012=q_J$X\r\u001a#bi\u0006DqA!4\u001c\u0001\u0004\u0011y-A\u0007rk\u0006d\u0017\u000e^8nKR,'o\u001d\t\u0007\u0005/\u0012iL!5\u0011\t\tM'q[\u0007\u0003\u0005+T!!^?\n\t\te'Q\u001b\u0002\r#V\fG.\u001b;p[\u0016$XM\u001d\u0005\b\u0005;\\\u0002\u0019\u0001Bp\u0003\u0019\u0019\u0017\u000e^5fgBA\u00111 B \u0003s\u0014\t\u000f\u0005\u0003\u0003d\n\u001dXB\u0001Bs\u0015\r)\u0018qI\u0005\u0005\u0005S\u0014)OA\u0005DSRLH*[4ii\"9!Q^\u000eA\u0002\tm\u0016!C:fY\u0016\u001cG/[8o\u0011\u0019a8\u00041\u0001\u0003<\"9!1_\u000eA\u0002\tU\u0018A\u00039be\u0006lW\r^3sgBA\u00111 B \u0003s\u00149\u0010\u0005\u0003\u0003z\nuXB\u0001B~\u0015\r\u0011)hW\u0005\u0005\u0005\u007f\u0014YP\u0001\bQCJ\fW.\u001a;fe2Kw\r\u001b;\t\u000f\r\r1\u00041\u0001\u0004\u0006\u0005I1M]5uKJL\u0017m\u001d\t\u0005\u0007\u000f\u0019y!\u0004\u0002\u0004\n)!11BB\u0007\u0003\u0015Ig\u000e];u\u0015\r\u0011)(`\u0005\u0005\u0007#\u0019IAA\nTK\u0006\u00148\r[!oC2L8/[:J]B,H\u000fC\u0005\u0003~m\u0001\n\u00111\u0001\u0003\u0000!I!\u0011D\u000e\u0011\u0002\u0003\u0007!QR\u0001 EVLG\u000e\u001a*fg\u0016\f'o\u00195E_\u000e,X.\u001a8uI\u0011,g-Y;mi\u0012J\u0014\u0001\t2vS2$'+Z:fCJ\u001c\u0007\u000eR8dk6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cA\nAbZ3u/>|'o\u001b2p_.$Baa\b\u0004RA9\u0001g!\t\u0004&\r\u0005\u0013bAB\u0012c\t1A+\u001e9mKJ\u0002Baa\n\u0004>5\u00111\u0011\u0006\u0006\u0005\u0007W\u0019i#A\u0005vg\u0016\u0014Xn\u001c3fY*!1qFB\u0019\u0003\t\u00198O\u0003\u0003\u00044\rU\u0012a\u00019pS*!1qGB\u001d\u0003\u0019\t\u0007/Y2iK*\u001111H\u0001\u0004_J<\u0017\u0002BB \u0007S\u0011\u0001bV8sW\n|wn\u001b\t\u0005\u0007\u0007\u001ai%\u0004\u0002\u0004F)!1qIB%\u0003\tIwN\u0003\u0002\u0004L\u0005!!.\u0019<b\u0013\u0011\u0019ye!\u0012\u0003\u001f\u0019KG.Z%oaV$8\u000b\u001e:fC6Dqaa\u0015\u001f\u0001\u0004\u0019)&\u0001\u0003gS2,\u0007\u0003BB\"\u0007/JAa!\u0017\u0004F\t!a)\u001b7f\u0003)9W\r^%oI&\u001cWm\u001d\u000b\t\u0005w\u001byf!\u0019\u0004f!911A\u0010A\u0002\r\u0015\u0001bBB2?\u0001\u0007!qZ\u0001\tcV\fG.\u001b;pg\"9!1_\u0010A\u0002\tU\u0018!E4fiJ+7/\u001e7uCR\u001cH*[4iiR!!1XB6\u0011\u001d\u0019i\u0007\ta\u0001\u0005w\u000bA!\u00198bg\u0006Iq-\u001a;Ti\u0006$Xm\u001d\u000b\u0007\u0005w\u001b\u0019h!\u001e\t\u000f\r\r\u0011\u00051\u0001\u0004\u0006!911M\u0011A\u0002\t=\u0017!F4fiF+\u0018\r\\5u_6,G/\u001a:t\u0013:4wn\u001d\u000b\u0007\u0005w\u001bYh! \t\u000f\t5'\u00051\u0001\u0003P\"9!Q\u001c\u0012A\u0002\t}\u0017aE4fiRC'/Z:i_2$G)\u001a;bS2\u001cHC\u0002B^\u0007\u0007\u001b9\tC\u0004\u0004\u0006\u000e\u0002\rA!\"\u0002\u001bQD'/Z:i_2$7i\u001c3f\u0011\u001d\u0019Ii\ta\u0001\u0007\u0017\u000b1\u0003]1sC6,G/\u001a:UQJ,7\u000f[8mIN\u0004bAa\u0016\u0003>\u000e5\u0005c\u0001>\u0004\u0010&\u00191\u0011S>\u0003%A\u000b'/Y7fi\u0016\u0014H\u000b\u001b:fg\"|G\u000eZ\u0001\u001aO\u0016$\b+\u0019:b[\u0016$XM\u001d$s_6\u001cV\r\\3di&|g\u000e\u0006\u0003\u0003<\u000e]\u0005bBBMI\u0001\u000711T\u0001\u000fg\u0016dWm\u0019;fIB\u000b'/Y7t!\u0019\u00119F!0\u0002z\u0006)R\r\u001f9peR\u001c5O\u001e*fg\u0016\f'o\u00195Gk2dGCCA}\u0007C\u001b\u0019k!*\u0004(\"9!qE\u0013A\u0002\t%\u0002b\u0002B\u001eK\u0001\u0007!Q\b\u0005\b\u0005\u0017*\u0003\u0019AA}\u0011\u001d\u0011y%\na\u0001\u0003s\u0004")
public class ResearchExportController {
    private final LogUtil logUtil;
    private final UnitDao unitDao;
    private final ParameterDao parameterDao;
    private final ThresholdDao thresholdDao;
    private final AnalysisDao analysisDao;
    private final WatershedDao watershedDao;
    private final SandreCodeDao sandreCodeDao;
    private final QualitometerDao qualitometerDao;
    private final CityDao cityDao;
    private final Environment environment;
    private final StationWatermassDao StationWatermassDao;
    private final IndicesDao IndicesDao;
    private final QualityStateDao QualityStateDao;
    private final WatermassDao WatermassDao;
    private final XLSorCSVExportController XLSorCSVExportController;
    private final ExportTmpDao ExportTmpDao;

    public String exportQualityResearchFromExportTmp(ExportTmp exportTmp, long jobExecutionId) {
        return (String)Json$.MODULE$.parse((String)exportTmp.params().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("No params");
        })).validate(ModelResearchExportInput$.MODULE$.ModelResearchExportInputWrites()).fold((Function1 & Serializable)error -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(28).append("Bad parameters for export : ").append(error.toString()).toString(), "");
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            throw new Exception("Bad input");
        }, (Function1 & Serializable)exportData -> {
            JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.INFO(), "Starting quality research export", "");
            Either<String, String> either = this.exportResearch((ModelResearchExportInput)exportData, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)exportTmp.id())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)));
            if (either instanceof Left) {
                Left left = (Left)either;
                String targetPath = (String)left.value();
                JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "File exported with success", "");
                return new StringBuilder(11).append("EXPORT/tmp/").append(targetPath).toString();
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                String err = (String)right.value();
                JobLogUtil$.MODULE$.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Error during export : ").append(err).toString(), "");
                throw new Exception(new StringBuilder(39).append("Error during Quality Research export : ").append(err).toString());
            }
            throw new MatchError(either);
        });
    }

    public String exportQualityResearchSync(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ModelResearchExportInput$.MODULE$.ModelResearchExportInputWrites()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(53).append("Error validate message for export with file model : \u00b0").append(error).toString(), $this.logUtil.error$default$2());
            Predef$.MODULE$.println(error);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)exportData -> {
            Either<String, String> either = this.exportResearch((ModelResearchExportInput)exportData, this.exportResearch$default$2(), this.exportResearch$default$3());
            if (either instanceof Left) {
                Left left = (Left)either;
                String targetPath = (String)left.value();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetPath"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(11).append("EXPORT/tmp/").append(targetPath).toString(), (Writes)Writes$.MODULE$.StringWrites()))})).toString();
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                String err = (String)right.value();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)err, (Writes)Writes$.MODULE$.StringWrites()))})).toString();
            }
            throw new MatchError(either);
        });
    }

    public Either<String, String> exportResearch(ModelResearchExportInput exportData, Option<Object> exportTmpId, Option<Object> jobExecutionId) {
        Right right;
        try {
            Seq seq;
            this.logUtil.info("Model validation", this.logUtil.info$default$2());
            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Model validation", ""));
            Seq parameterThresholds = (Seq)exportData.researchCriterias().threshold().map((Function1 & Serializable)t -> this.thresholdDao.findParameterThresholds(BoxesRunTime.unboxToInt((Object)t), this.thresholdDao.findParameterThresholds$default$2())).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
            Seq<Seq<ExportedData>> threshold = exportData.researchCriterias().threshold().isDefined() ? this.getThresholdDetails(BoxesRunTime.unboxToInt((Object)exportData.researchCriterias().threshold().get()), (Seq<ParameterThreshold>)parameterThresholds) : (Seq<Seq<ExportedData>>)Nil$.MODULE$;
            Seq selection = (Seq)exportData.researchCriterias().selectionResults().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
            Seq<Seq<ExportedData>> selectedParamsDetails = selection.nonEmpty() ? this.getParameterFromSelection((Seq<String>)selection) : (Seq<Seq<ExportedData>>)Nil$.MODULE$;
            Seq qualitometers = this.qualitometerDao.getAll((Option)new Some(exportData.researchCriterias().stations().map((Function1)(JFunction1.mcDI.sp & Serializable)x$1 -> x$1)));
            Map parameters = AlgoUtil$.MODULE$.makeMapCode(this.parameterDao.getAllLight(), (Function1 & Serializable)p -> p.code());
            Map cities = AlgoUtil$.MODULE$.makeMapCode(this.cityDao.getAllLight(), (Function1 & Serializable)p -> p.code());
            this.logUtil.info("Quality researching", this.logUtil.info$default$2());
            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Quality researching", ""));
            exportTmpId.foreach((Function1)(JFunction1.mcII.sp & Serializable)tmpId -> $this.ExportTmpDao.setProgress(tmpId, 20.0));
            Seq headers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"codebss", "commune", "nom", "dateprlv", "lieuprlv", "labo", "dateAnalyse", "codeparametre", "nomParametre", "resultat", "codeUnite", "nomUnite", "support", "nomSupport", "codeFraction", "nomFraction", "codeRemarque", "remarque", "conformite", "statut", "qualification", "producteur", "preleveur", "codelieu", "hydroecoregion", "bassinVersant", "x", "y", "projection", "ld", "lq", "ldDefaut", "lqDefaut", "departement"})).map((Function1 & Serializable)v -> new ExportedData((Option)new Some(v), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()));
            if (exportData.researchCriterias().researchType().contains((Object)BoxesRunTime.boxToInteger((int)31))) {
                Seq seq2 = headers;
                seq = (Seq)this.analysisDao.exportAnalysisCSV(exportData.researchCriterias()).$plus$colon((Object)seq2);
            } else {
                seq = (Seq)Nil$.MODULE$;
            }
            Seq formatResult = seq;
            this.logUtil.info("Formatting research results", this.logUtil.info$default$2());
            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Formatting research results", ""));
            exportTmpId.foreach((Function1)(JFunction1.mcII.sp & Serializable)tmpId -> $this.ExportTmpDao.setProgress(tmpId, 50.0));
            FileUtil$.MODULE$.runCMDInScript(FileUtil$.MODULE$.toPath(ExportFileUtils$.MODULE$.getTmpExportDirectoryName()), (Seq)new .colon.colon((Object)"rm -f *.csv *.xls *.xlsx *.xlsm", (List)Nil$.MODULE$), this.logUtil);
            this.logUtil.info("Building excel document", this.logUtil.info$default$2());
            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Building excel document", ""));
            String res = this.buildResearchDocument(exportData, (Seq<Seq<ExportedData>>)formatResult, (Seq<Qualitometer>)qualitometers, (Map<String, CityLight>)cities, selectedParamsDetails, threshold, (Map<String, ParameterLight>)parameters, exportData.researchCriterias(), exportTmpId, jobExecutionId, this.environment);
            right = package$.MODULE$.Left().apply((Object)res);
        }
        catch (Exception e) {
            this.logUtil.printError((Throwable)e);
            e.printStackTrace();
            right = package$.MODULE$.Right().apply((Object)e.getMessage());
        }
        return right;
    }

    public Option<Object> exportResearch$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> exportResearch$default$3() {
        return None$.MODULE$;
    }

    public String buildResearchDocument(ModelResearchExportInput exportData, Seq<Seq<ExportedData>> searchAnalysisResult, Seq<Qualitometer> qualitometers, Map<String, CityLight> cities, Seq<Seq<ExportedData>> selection, Seq<Seq<ExportedData>> threshold, Map<String, ParameterLight> parameters, SearchAnalysisInput criterias, Option<Object> exportTmpId, Option<Object> jobExecutionId, Environment environment) {
        String ext = new StringBuilder(1).append(".").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(exportData.filenameModelExport()), '.')))).toString();
        Option<File> option = ExportFileUtils$.MODULE$.getModelFile(exportData.filenameModelExport(), StationTypeConstants$.MODULE$.STATION_TYPE_QUALITOMETER_RESEARCH());
        if (option instanceof Some) {
            Some some = (Some)option;
            File modelFile = (File)some.value();
            Tuple2<Workbook, FileInputStream> tuple2 = this.getWoorkbook(modelFile);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Workbook workbook = (Workbook)tuple2._1();
            FileInputStream excelFile = (FileInputStream)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)workbook, (Object)excelFile);
            Workbook workbook2 = (Workbook)tuple22._1();
            FileInputStream excelFile2 = (FileInputStream)tuple22._2();
            String resultFileName = (String)exportData.resultFileName().getOrElse((Function0 & Serializable)() -> new StringBuilder(0).append(exportData.filenameModelExport().split("\\.(?=[^\\.]+$)")[0]).append(ExtensionTypeConstants$.MODULE$.EXPORTED_POSTFIX()).toString());
            Option<File> option2 = ExportFileUtils$.MODULE$.getResultFile(resultFileName, ext);
            if (option2 instanceof Some) {
                File outputTmp = (File)ExportFileUtils$.MODULE$.getFile(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), new StringBuilder(0).append(resultFileName).append(ext).toString()).get();
                this.logUtil.info(new StringBuilder(20).append("Temp File created : ").append(resultFileName).append(ext).toString(), this.logUtil.info$default$2());
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), new StringBuilder(20).append("Temp File created : ").append(resultFileName).append(ext).toString(), ""));
                FileOutputStream fos = new FileOutputStream(outputTmp);
                workbook2.write((OutputStream)fos);
                fos.close();
                excelFile2.close();
                this.logUtil.info("reading model in temp file", this.logUtil.info$default$2());
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "reading model in temp file", ""));
                FileInputStream excelFile22 = new FileInputStream(outputTmp);
                XSSFWorkbook workbook22 = new XSSFWorkbook((InputStream)excelFile22);
                SXSSFWorkbook writeWorkbook = new SXSSFWorkbook(workbook22);
                excelFile22.close();
                FileUtil$.MODULE$.runCMDInScript(FileUtil$.MODULE$.toPath(ExportFileUtils$.MODULE$.getTmpExportDirectoryName()), (Seq)new .colon.colon((Object)new StringBuilder(6).append("rm -f ").append(resultFileName).append(ext).toString(), (List)Nil$.MODULE$), this.logUtil);
                this.logUtil.info(new StringBuilder(20).append("Temp File deleted : ").append(resultFileName).append(ext).toString(), this.logUtil.info$default$2());
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), new StringBuilder(20).append("Temp File deleted : ").append(resultFileName).append(ext).toString(), ""));
                CellStyle cellStyle = writeWorkbook.createCellStyle();
                CreationHelper createHelper = writeWorkbook.getCreationHelper();
                cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("m/d/yy h:mm"));
                Iterator sheetIterator = workbook22.iterator();
                exportTmpId.foreach((Function1)(JFunction1.mcII.sp & Serializable)tmpId -> $this.ExportTmpDao.setProgress(tmpId, 60.0));
                block9: while (sheetIterator.hasNext()) {
                    Sheet currentSheet = (Sheet)sheetIterator.next();
                    String currentSheetName = currentSheet.getSheetName().trim();
                    this.logUtil.info(new StringBuilder(16).append("Current sheet : ").append(currentSheetName).toString(), this.logUtil.info$default$2());
                    jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), new StringBuilder(16).append("Current sheet : ").append(currentSheetName).toString(), ""));
                    String string = currentSheet.getSheetName().trim();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1615959936: {
                            if (!"#RESULTATS".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(searchAnalysisResult, currentSheet, (Workbook)writeWorkbook, this.logUtil, false);
                            this.logUtil.info("Ending result sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending result sheet creation", ""));
                            continue block9;
                        }
                        case -1512376151: {
                            if (!"#SELECTION".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(selection, currentSheet, (Workbook)writeWorkbook, this.logUtil, ExcelBuilderUtil$.MODULE$.fillWorksheet$default$5());
                            this.logUtil.info("Ending selection sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending selection sheet creation", ""));
                            continue block9;
                        }
                        case -1030405406: {
                            if (!"#STATIONS".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(this.getQualitometersInfos(qualitometers, cities), currentSheet, (Workbook)writeWorkbook, this.logUtil, ExcelBuilderUtil$.MODULE$.fillWorksheet$default$5());
                            this.logUtil.info("Ending stations sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending stations sheet creation", ""));
                            continue block9;
                        }
                        case -854562224: {
                            if (!"#SEUILS".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(threshold, currentSheet, (Workbook)writeWorkbook, this.logUtil, ExcelBuilderUtil$.MODULE$.fillWorksheet$default$5());
                            this.logUtil.info("Ending threshold sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending threshold sheet creation", ""));
                            continue block9;
                        }
                        case -764773884: {
                            if (!"#INDICES".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(this.getIndices(criterias, qualitometers, parameters), currentSheet, (Workbook)writeWorkbook, this.logUtil, ExcelBuilderUtil$.MODULE$.fillWorksheet$default$5());
                            this.logUtil.info("Ending indice sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending indice sheet creation", ""));
                            continue block9;
                        }
                        case 1068310830: {
                            if (!"#ETATS".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(this.getStates(criterias, qualitometers), currentSheet, (Workbook)writeWorkbook, this.logUtil, ExcelBuilderUtil$.MODULE$.fillWorksheet$default$5());
                            this.logUtil.info("Ending states sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending states sheet creation", ""));
                            continue block9;
                        }
                        case 1187752055: {
                            if (!"#RESULTATS_LIGHT".equals(string)) continue block9;
                            ExcelBuilderUtil$.MODULE$.fillWorksheet(this.getResultatsLight(searchAnalysisResult), currentSheet, (Workbook)writeWorkbook, this.logUtil, false);
                            this.logUtil.info("Ending result sheet creation", this.logUtil.info$default$2());
                            jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending RESULTATS_LIGHT sheet creation", ""));
                            continue block9;
                        }
                    }
                }
                exportTmpId.foreach((Function1)(JFunction1.mcII.sp & Serializable)tmpId -> $this.ExportTmpDao.setProgress(tmpId, 90.0));
                this.logUtil.info("Ending bookmarks replacement", this.logUtil.info$default$2());
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Ending bookmarks replacement", ""));
                this.logUtil.info("Writting data to output file", this.logUtil.info$default$2());
                jobExecutionId.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)je -> JobLogUtil$.MODULE$.log(je, JobState$.MODULE$.INFO(), "Writting data to output file", ""));
                File finalOutput = (File)ExportFileUtils$.MODULE$.getFile(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), new StringBuilder(0).append(resultFileName).append(ext).toString()).get();
                FileOutputStream fos2 = new FileOutputStream(finalOutput);
                writeWorkbook.write((OutputStream)fos2);
                fos2.close();
                excelFile2.close();
                return new StringBuilder(0).append(resultFileName).append(ext).toString();
            }
            throw new Exception("Error here !");
        }
        throw new Exception("Error there !");
    }

    public Option<Object> buildResearchDocument$default$9() {
        return None$.MODULE$;
    }

    public Option<Object> buildResearchDocument$default$10() {
        return None$.MODULE$;
    }

    public Tuple2<Workbook, FileInputStream> getWoorkbook(File file) {
        FileInputStream fis = new FileInputStream(file);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new XSSFWorkbook((InputStream)fis));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            XSSFWorkbook wb = (XSSFWorkbook)success.value();
            return new Tuple2((Object)wb, (Object)fis);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e1 = failure.exception();
            FileInputStream fis2 = new FileInputStream(file);
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> new HSSFWorkbook((InputStream)fis2));
            if (try_2 instanceof Success) {
                Success success = (Success)try_2;
                HSSFWorkbook wb = (HSSFWorkbook)success.value();
                return new Tuple2((Object)wb, (Object)fis2);
            }
            if (try_2 instanceof Failure) {
                Failure failure2 = (Failure)try_2;
                Throwable e2 = failure2.exception();
                this.logUtil.printError(e1);
                this.logUtil.printError(e2);
                throw e2;
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    public Seq<Seq<ExportedData>> getIndices(SearchAnalysisInput criterias, Seq<Qualitometer> qualitos, Map<String, ParameterLight> parameters) {
        Seq header;
        Seq x$1 = (Seq)Nil$.MODULE$;
        String x$2 = "";
        Option x$3 = criterias.parameter();
        None$ x$4 = None$.MODULE$;
        Option x$5 = criterias.unit();
        Option x$6 = criterias.method();
        Option x$7 = criterias.producer();
        Option x$8 = criterias.status();
        Option x$9 = criterias.qualification();
        Option x$10 = criterias.startDate();
        Option x$11 = criterias.endDate();
        Option x$12 = criterias.selectionResults();
        Option x$13 = SearchIndicesInput$.MODULE$.$lessinit$greater$default$4();
        Option x$14 = SearchIndicesInput$.MODULE$.$lessinit$greater$default$6();
        Option x$15 = SearchIndicesInput$.MODULE$.$lessinit$greater$default$10();
        Seq indices = (Seq)this.IndicesDao.searchIndices(new SearchIndicesInput(x$1, "", x$3, x$13, (Option)x$4, x$14, x$5, x$6, x$7, x$15, x$8, x$9, x$10, x$11, x$12), qualitos).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ResearchExportController.$anonfun$getIndices$1(a, b)));
        Seq seq = header = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Code station", "Nom station", "Date", "Indice", "Statut", "Qualification", "Code Sandre", "Nom indice"})).map((Function1 & Serializable)h -> new ExportedData((Option)new Some(h), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()));
        return (Seq)((SeqOps)indices.map((Function1 & Serializable)indice -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExportedData[]{new ExportedData((Option)new Some((Object)indice.stationCode()), (Option)None$.MODULE$, (Option)new Some((Object)"string"), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.stationName(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.startDate().map((Function1 & Serializable)x$7 -> x$7.toString("dd/MM/YYYY")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.result().map((Function1 & Serializable)x$8 -> ResearchExportController.$anonfun$getIndices$15(BoxesRunTime.unboxToDouble((Object)x$8))), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.status(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.qualification(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.parameter(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(indice.parameter().flatMap((Function1 & Serializable)p -> parameters.get(p).map((Function1 & Serializable)x$9 -> x$9.name())), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4())})))).$plus$colon((Object)seq);
    }

    public Seq<Seq<ExportedData>> getResultatsLight(Seq<Seq<ExportedData>> anas) {
        Seq seq = (Seq)anas.head();
        return (Seq)((SeqOps)((IterableOps)anas.tail()).map((Function1 & Serializable)a -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExportedData[]{(ExportedData)a.head(), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(3), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(7), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(9), (ExportedData)a.apply(10), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(12), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(14), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(16), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), (ExportedData)a.apply(19), (ExportedData)a.apply(20), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"void"), ExportedData$.MODULE$.apply$default$4())})))).$plus$colon((Object)seq);
    }

    public Seq<Seq<ExportedData>> getStates(SearchAnalysisInput criterias, Seq<Qualitometer> qualitos) {
        Seq header;
        Seq codes = this.sandreCodeDao.getSandreList("ETATS.VALEURS");
        Seq states = (Seq)this.QualityStateDao.searchStates(new SearchStateInput(criterias.startDate(), criterias.endDate(), "", (Seq)qualitos.map((Function1 & Serializable)q -> q.code()))).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ResearchExportController.$anonfun$getStates$2(a, b)));
        Seq seq = header = (Seq)new .colon.colon((Object)"Code station", (List)new .colon.colon((Object)"Nom station", (List)new .colon.colon((Object)"Date", (List)new .colon.colon((Object)"Etat", (List)new .colon.colon((Object)"Classe", (List)new .colon.colon((Object)"Indice", (List)new .colon.colon((Object)"Commentaire", (List)Nil$.MODULE$))))))).map((Function1 & Serializable)h -> new ExportedData((Option)new Some(h), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()));
        return (Seq)((SeqOps)states.map((Function1 & Serializable)state -> {
            Option qualito = qualitos.find((Function1 & Serializable)q -> BoxesRunTime.boxToBoolean((boolean)ResearchExportController.$anonfun$getStates$15(state, q)));
            return new .colon.colon((Object)new ExportedData(qualito.map((Function1 & Serializable)x$14 -> x$14.code()), (Option)None$.MODULE$, (Option)new Some((Object)"string"), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData(qualito.flatMap((Function1 & Serializable)x$15 -> x$15.name()), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData(state.startDate().map((Function1 & Serializable)x$16 -> x$16.toString("dd/MM/YYYY")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData(state.stateName(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData(state.value().map((Function1 & Serializable)v -> ReferentialUtil$.MODULE$.getSandreLabel("ETATS.VALEURS", (long)BoxesRunTime.unboxToDouble((Object)v), codes)), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData(state.value().map((Function1 & Serializable)x$17 -> ResearchExportController.$anonfun$getStates$20(BoxesRunTime.unboxToDouble((Object)x$17))), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData(state.comment(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))))));
        })).$plus$colon((Object)seq);
    }

    public Seq<Seq<ExportedData>> getQualitometersInfos(Seq<Qualitometer> qualitometers, Map<String, CityLight> cities) {
        Seq watermassLinks = this.StationWatermassDao.getAll(StationTypeUtil$.MODULE$.QUALITY());
        Map watersheds = AlgoUtil$.MODULE$.makeMapId(this.watershedDao.getAll(), (Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ResearchExportController.$anonfun$getQualitometersInfos$1(p)));
        Map watermasses = AlgoUtil$.MODULE$.makeMapCode(this.WatermassDao.getAllLight(), (Function1 & Serializable)p -> p.id());
        Seq riverFr = this.sandreCodeDao.getSandreList("QUALITOMETRES.TYPE_FR.RIVIERE");
        Seq planFr = this.sandreCodeDao.getSandreList("QUALITOMETRES.TYPE_FR.PLAN");
        Seq headers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExportedData[]{new ExportedData((Option)new Some((Object)"Code station"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Nom station"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Code commune"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Commune"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Riviere"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Bassin versant"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Code masse eau"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Masse eau"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"TypeFR"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4())}));
        Seq stationsInfos = (Seq)qualitometers.map((Function1 & Serializable)station -> {
            Object object;
            Option watermass = watermassLinks.find((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ResearchExportController.$anonfun$getQualitometersInfos$4(station, x$18)));
            Option option = station.frType();
            if (option instanceof Some) {
                Some some = (Some)option;
                double f = BoxesRunTime.unboxToDouble((Object)some.value());
                int qualitoType = BoxesRunTime.unboxToInt((Object)station.qualitometerType().map((Function1)(JFunction1.mcID.sp & Serializable)x$19 -> (int)x$19).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                object = qualitoType == 1 ? new Some((Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.TYPE_FR.RIVIERE", (long)f, riverFr)) : (qualitoType != 0 ? new Some((Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.TYPE_FR.PLAN", (long)f, planFr)) : None$.MODULE$);
            } else {
                object = None$.MODULE$;
            }
            None$ frType = object;
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExportedData[]{new ExportedData((Option)new Some((Object)station.code()), (Option)None$.MODULE$, (Option)new Some((Object)"string"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(station.name().getOrElse((Function0 & Serializable)() -> "")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(station.townCode().getOrElse((Function0 & Serializable)() -> "")), (Option)None$.MODULE$, (Option)new Some((Object)"string"), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(station.townCode().flatMap((Function1 & Serializable)c -> cities.get(c)).flatMap((Function1 & Serializable)x$20 -> x$20.name()).getOrElse((Function0 & Serializable)() -> "")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(station.river().getOrElse((Function0 & Serializable)() -> "")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(station.watershed().flatMap((Function1 & Serializable)w -> watersheds.get((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)w))))).flatMap((Function1 & Serializable)x$21 -> x$21.name()).getOrElse((Function0 & Serializable)() -> "")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(watermass.map((Function1 & Serializable)w -> w.watermassCode()).getOrElse((Function0 & Serializable)() -> "")), (Option)new Some((Object)"string"), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(watermass.flatMap((Function1 & Serializable)w -> watermasses.get((Object)w.watermassCode())).flatMap((Function1 & Serializable)x$22 -> x$22.name()).getOrElse((Function0 & Serializable)() -> "")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some(frType.getOrElse((Function0 & Serializable)() -> "")), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4())}));
        });
        Seq seq = headers;
        return (Seq)stationsInfos.$plus$colon((Object)seq);
    }

    public Seq<Seq<ExportedData>> getThresholdDetails(int thresholdCode, Seq<ParameterThreshold> parameterThresholds) {
        Option threshold = this.thresholdDao.get(Predef$.MODULE$.int2Integer(thresholdCode), this.thresholdDao.get$default$2());
        if (threshold.isDefined()) {
            Seq headers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExportedData[]{new ExportedData((Option)new Some((Object)"Libelle seuil"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Code parametre"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Parametre"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Valeur1"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Valeur2"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Valeur3"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Valeur4"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Code unite"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)"Unite"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4())}));
            Seq data = (Seq)parameterThresholds.map((Function1 & Serializable)p -> {
                String string;
                String string2;
                Option option = $this.unitDao.getUnit((String)p.unit().getOrElse((Function0 & Serializable)() -> ""));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Unit unit = (Unit)some.value();
                    string2 = (String)unit.symbol().getOrElse((Function0 & Serializable)() -> "");
                } else {
                    string2 = "";
                }
                String unitName = string2;
                Option option2 = $this.parameterDao.get((String)p.parameterCode().getOrElse((Function0 & Serializable)() -> ""));
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Parameter param = (Parameter)some.value();
                    string = param.name();
                } else {
                    string = "";
                }
                String paramName = string;
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExportedData[]{new ExportedData((Option)new Some((Object)((Threshold)threshold.get()).name()), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(p.parameterCode(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)paramName), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)p.threshold1().getOrElse((Function0 & Serializable)() -> "").toString()), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)p.threshold2().getOrElse((Function0 & Serializable)() -> "").toString()), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)p.threshold3().getOrElse((Function0 & Serializable)() -> "").toString()), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)p.threshold4().getOrElse((Function0 & Serializable)() -> "").toString()), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData(p.unit(), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), new ExportedData((Option)new Some((Object)unitName), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4())}));
            });
            Seq seq = headers;
            return (Seq)data.$plus$colon((Object)seq);
        }
        return (Seq)Nil$.MODULE$;
    }

    public Seq<Seq<ExportedData>> getParameterFromSelection(Seq<String> selectedParams) {
        .colon.colon headers = new .colon.colon((Object)new ExportedData((Option)new Some((Object)"Code param\u00e8tre"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData((Option)new Some((Object)"Libelle"), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        Seq data = (Seq)selectedParams.map((Function1 & Serializable)param -> {
            None$ none$;
            Option option = $this.parameterDao.get(param);
            if (option instanceof Some) {
                Some some = (Some)option;
                Parameter p = (Parameter)some.value();
                none$ = new Some((Object)p.name());
            } else {
                none$ = None$.MODULE$;
            }
            None$ paramLabel = none$;
            return new .colon.colon((Object)new ExportedData((Option)new Some(param), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new ExportedData((Option)paramLabel, ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        });
        .colon.colon colon2 = headers;
        return (Seq)data.$plus$colon((Object)colon2);
    }

    public String exportCsvResearchFull(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ModelResearchExportInput$.MODULE$.ModelResearchExportInputWrites()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validating type or ids from message : \u00b0").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)exportData -> {
            String extension = (String)exportData.fileType().getOrElse((Function0 & Serializable)() -> "csv");
            String fileName = new StringBuilder(4).append((String)exportData.resultFileName().getOrElse((Function0 & Serializable)() -> "export_search_full")).append(".csv").toString().replace(".csv.csv", ".csv").replace(".csv", new StringBuilder(1).append(".").append(extension).toString());
            Option<File> previousFile = ExportFileUtils$.MODULE$.getFile(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), fileName);
            Object object = previousFile.isDefined() ? BoxesRunTime.boxToBoolean((boolean)((File)previousFile.get()).delete()) : BoxedUnit.UNIT;
            Seq headers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"codebss", "commune", "nom", "dateprlv", "lieuprlv", "labo", "dateAnalyse", "codeparametre", "nomParametre", "resultat", "codeUnite", "nomUnite", "support", "nomSupport", "codeFraction", "nomFraction", "codeRemarque", "remarque", "conformite", "statut", "qualification", "producteur", "preleveur", "codelieu", "hydroecoregion", "bassinVersant", "x", "y", "projection", "ld", "lq", "ldDefaut", "lqDefaut", "departement", "classeSeuil", "valeurSeuil"})).map((Function1 & Serializable)v -> new ExportedData((Option)new Some(v), ExportedData$.MODULE$.apply$default$2(), ExportedData$.MODULE$.apply$default$3(), ExportedData$.MODULE$.apply$default$4()));
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Launch export : ").append(DateUtil$.MODULE$.getDateWithHour(new DateTime())).toString());
            Seq<Seq<ExportedData>> searchResult = $this.analysisDao.exportAnalysisCSV(exportData.researchCriterias());
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("transform to byte : ").append(DateUtil$.MODULE$.getDateWithHour(new DateTime())).toString());
            Seq seq = headers;
            byte[] result = $this.XLSorCSVExportController.exportFile(extension, (Seq<Seq<ExportedData>>)((Seq)searchResult.$plus$colon((Object)seq)));
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("Write file : ").append(DateUtil$.MODULE$.getDateWithHour(new DateTime())).toString());
            Option<File> file = ExportFileUtils$.MODULE$.getFile(ExportFileUtils$.MODULE$.getTmpExportDirectoryName(), fileName);
            String targetPath = ((File)file.get()).getAbsolutePath();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream((File)file.get()));
            bos.write(result);
            bos.close();
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("return result : ").append(DateUtil$.MODULE$.getDateWithHour(new DateTime())).toString());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetPath"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)targetPath.replace((CharSequence)scala.sys.package$.MODULE$.env().apply((Object)"UPLOAD_DIRECTORY"), ""), (Writes)Writes$.MODULE$.StringWrites()))})).toString();
        });
    }

    public static final /* synthetic */ boolean $anonfun$getIndices$1(SearchIndicesOutput a, SearchIndicesOutput b) {
        if ((int)a.stationId() == (int)b.stationId()) {
            if (BoxesRunTime.equals((Object)a.startDate().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getMillis())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0), (Object)b.startDate().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getMillis())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))) {
                return BoxesRunTime.unboxToDouble((Object)a.result().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) < BoxesRunTime.unboxToDouble((Object)b.result().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            }
            return BoxesRunTime.unboxToLong((Object)a.startDate().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) < BoxesRunTime.unboxToLong((Object)b.startDate().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        return a.stationId() < b.stationId();
    }

    public static final /* synthetic */ String $anonfun$getIndices$15(double x$8) {
        return Double.toString(x$8);
    }

    public static final /* synthetic */ boolean $anonfun$getStates$2(QualitometerState a, QualitometerState b) {
        if ((int)a.qualitometer() == (int)b.qualitometer()) {
            if (BoxesRunTime.equals((Object)a.startDate().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.getMillis())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0), (Object)b.startDate().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.getMillis())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))) {
                return BoxesRunTime.unboxToDouble((Object)a.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) < BoxesRunTime.unboxToDouble((Object)b.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            }
            return BoxesRunTime.unboxToLong((Object)a.startDate().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) < BoxesRunTime.unboxToLong((Object)b.startDate().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        return a.qualitometer() < b.qualitometer();
    }

    public static final /* synthetic */ boolean $anonfun$getStates$15(QualitometerState state$1, Qualitometer q) {
        return q.id() == state$1.qualitometer();
    }

    public static final /* synthetic */ String $anonfun$getStates$20(double x$17) {
        return Integer.toString((int)x$17);
    }

    public static final /* synthetic */ int $anonfun$getQualitometersInfos$1(Watershed p) {
        return (int)p.id();
    }

    public static final /* synthetic */ boolean $anonfun$getQualitometersInfos$4(Qualitometer station$1, StationWatermass x$18) {
        return x$18.idStation() == station$1.id();
    }

    @Inject
    public ResearchExportController(LogUtil logUtil, ContributorsDao contributorsDao, UnitDao unitDao, ParameterDao parameterDao, SupportDao supportDao, FractionDao fractionDao, ExcelBuilder ExcelBuilder2, ThresholdDao thresholdDao, AnalysisDao analysisDao, WatershedDao watershedDao, SandreCodeDao sandreCodeDao, QualitometerDao qualitometerDao, CityDao cityDao, Environment environment, StationWatermassDao StationWatermassDao2, IndicesDao IndicesDao2, QualityStateDao QualityStateDao2, WatermassDao WatermassDao2, XLSorCSVExportController XLSorCSVExportController2, ExportTmpDao ExportTmpDao2) {
        this.logUtil = logUtil;
        this.unitDao = unitDao;
        this.parameterDao = parameterDao;
        this.thresholdDao = thresholdDao;
        this.analysisDao = analysisDao;
        this.watershedDao = watershedDao;
        this.sandreCodeDao = sandreCodeDao;
        this.qualitometerDao = qualitometerDao;
        this.cityDao = cityDao;
        this.environment = environment;
        this.StationWatermassDao = StationWatermassDao2;
        this.IndicesDao = IndicesDao2;
        this.QualityStateDao = QualityStateDao2;
        this.WatermassDao = WatermassDao2;
        this.XLSorCSVExportController = XLSorCSVExportController2;
        this.ExportTmpDao = ExportTmpDao2;
    }
}

