/*
 * Decompiled with CFR 0.152.
 */
package edilabo.controller;

import com.google.inject.Inject;
import dao.itf.QualitometerPointDao;
import edilabo.domain.EDILABOParamPlanning;
import edilabo.domain.EDILABOParamPlanning$;
import edilabo.util.XmlBuilder$;
import fr.aquasys.daeau.campaign.domain.CampaignEDILABO;
import fr.aquasys.daeau.campaign.domain.CampaignPlanEDILABO;
import fr.aquasys.daeau.campaign.itf.CampaignDao;
import fr.aquasys.daeau.campaign.itf.CampaignPlanningDao;
import fr.aquasys.daeau.contributor.domain.ContributorEDILABO;
import fr.aquasys.daeau.contributor.itf.ContributorDao;
import fr.aquasys.daeau.quality.domain.QualitometerEDILABO;
import fr.aquasys.daeau.referentials.parameter.itf.ParameterDao;
import fr.aquasys.daeau.referentials.support.itf.SupportDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StringUtil$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\u0006\f\u0001AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001\u0007\u0005\tI\u0001\u0011\t\u0011)A\u0006K!Aq\u0006\u0001B\u0001B\u0003-\u0001\u0007\u0003\u00058\u0001\t\u0005\t\u0015a\u00039\u0011!Y\u0004A!A!\u0002\u0017a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b1\u0002#\t\u00115\u0003!\u0011!Q\u0001\f9CQ!\u0016\u0001\u0005\u0002YCQ\u0001\u001c\u0001\u0005\u00025\u0014q#\u0012=q_J$X\tR%M\u0003\n{5i\u001c8ue>dG.\u001a:\u000b\u00051i\u0011AC2p]R\u0014x\u000e\u001c7fe*\ta\"A\u0004fI&d\u0017MY8\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011\u0011DI\u0007\u00025)\u00111\u0004H\u0001\u0005kRLGN\u0003\u0002\u001e=\u0005A!/\u00192cSRl\u0017O\u0003\u0002 A\u00059\u0011-];bgf\u001c(\"A\u0011\u0002\u0005\u0019\u0014\u0018BA\u0012\u001b\u0005\u001daunZ+uS2\fabY8oiJL'-\u001e;pe\u0012\u000bw\u000e\u0005\u0002'[5\tqE\u0003\u0002)S\u0005\u0019\u0011\u000e\u001e4\u000b\u0005)Z\u0013aC2p]R\u0014\u0018NY;u_JT!\u0001\f\u0010\u0002\u000b\u0011\fW-Y;\n\u00059:#AD\"p]R\u0014\u0018NY;u_J$\u0015m\\\u0001\fG\u0006l\u0007/Y5h]\u0012\u000bw\u000e\u0005\u00022k5\t!G\u0003\u0002)g)\u0011AgK\u0001\tG\u0006l\u0007/Y5h]&\u0011aG\r\u0002\f\u0007\u0006l\u0007/Y5h]\u0012\u000bw.A\ndC6\u0004\u0018-[4o!2\fgN\\5oO\u0012\u000bw\u000e\u0005\u00022s%\u0011!H\r\u0002\u0014\u0007\u0006l\u0007/Y5h]Bc\u0017M\u001c8j]\u001e$\u0015m\\\u0001\u0015cV\fG.\u001b;p[\u0016$XM\u001d)pS:$H)Y8\u0011\u0005u\nU\"\u0001 \u000b\u0005!z$\"\u0001!\u0002\u0007\u0011\fw.\u0003\u0002C}\t!\u0012+^1mSR|W.\u001a;feB{\u0017N\u001c;EC>\fA\u0002]1sC6,G/\u001a:EC>\u0004\"!R&\u000e\u0003\u0019S!\u0001K$\u000b\u0005!K\u0015!\u00039be\u0006lW\r^3s\u0015\tQ5&\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7/\u0003\u0002M\r\na\u0001+\u0019:b[\u0016$XM\u001d#b_\u0006Q1/\u001e9q_J$H)Y8\u0011\u0005=\u001bV\"\u0001)\u000b\u0005!\n&B\u0001*J\u0003\u001d\u0019X\u000f\u001d9peRL!\u0001\u0016)\u0003\u0015M+\b\u000f]8si\u0012\u000bw.\u0001\u0004=S:LGO\u0010\u000b\u0002/RA\u0001LW.];z{\u0006\r\u0005\u0002Z\u00015\t1\u0002C\u0003\u0018\u0011\u0001\u000f\u0001\u0004C\u0003%\u0011\u0001\u000fQ\u0005C\u00030\u0011\u0001\u000f\u0001\u0007C\u00038\u0011\u0001\u000f\u0001\bC\u0003<\u0011\u0001\u000fA\bC\u0003D\u0011\u0001\u000fA\tC\u0003N\u0011\u0001\u000fa\n\u000b\u0002\tEB\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u0007S:TWm\u0019;\u000b\u0005\u001dD\u0017AB4p_\u001edWMC\u0001j\u0003\r\u0019w.\\\u0005\u0003W\u0012\u0014a!\u00138kK\u000e$\u0018AD3ya>\u0014H\u000f\u00157b]:Lgn\u001a\u000b\t]f\fy!a\b\u0002$A\u0011qN\u001e\b\u0003aR\u0004\"!]\n\u000e\u0003IT!a]\b\u0002\rq\u0012xn\u001c;?\u0013\t)8#\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;\u0014\u0011\u0015Q\u0018\u00021\u0001|\u0003\u001diWm]:bO\u0016\u00042\u0001`A\u0006\u001b\u0005i(B\u0001@\u0000\u0003\u0011Q7o\u001c8\u000b\t\u0005\u0005\u00111A\u0001\u0005Y&\u00147O\u0003\u0003\u0002\u0006\u0005\u001d\u0011aA1qS*\u0011\u0011\u0011B\u0001\u0005a2\f\u00170C\u0002\u0002\u000eu\u0014qAS:WC2,X\rC\u0004\u0002\u0012%\u0001\r!a\u0005\u0002\u000f!,\u0017\rZ3sgB1q.!\u0006o\u00033I1!a\u0006y\u0005\ri\u0015\r\u001d\t\u0004%\u0005m\u0011bAA\u000f'\t\u0019\u0011I\\=\t\r\u0005\u0005\u0012\u00021\u0001o\u0003\u0019iw\u000eZ;mK\"1\u0011QE\u0005A\u00029\fA!^:fe\u0002")
public class ExportEDILABOController {
    private final LogUtil logUtil;
    private final ContributorDao contributorDao;
    private final CampaignDao campaignDao;
    private final CampaignPlanningDao campaignPlanningDao;
    private final QualitometerPointDao qualitometerPointDao;
    private final ParameterDao parameterDao;
    private final SupportDao supportDao;

    public String exportPlanning(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EDILABOParamPlanning$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(48).append("Error validate Json to get campaign plannings: \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"Wrong parameters", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
        }, (Function1 & Serializable)param -> {
            Option option = package$.MODULE$.env().get((Object)"EXPORT_EDILABO_DIRECTORY");
            if (option instanceof Some) {
                Some some = (Some)option;
                String directoryPath = (String)some.value();
                String baseDir = StringUtil$.MODULE$.getPath(directoryPath);
                String directory = StringUtil$.MODULE$.getPath(new StringBuilder(0).append(baseDir).append(param.exportPath().getOrElse((Function0 & Serializable)() -> "")).toString());
                boolean bl = new File(directory).mkdirs();
                if (bl) {
                    $this.logUtil.info(new StringBuilder(17).append("Create directory ").append(directory).toString(), $this.logUtil.info$default$2());
                }
                Option option2 = $this.campaignDao.getCampaignEDILABO((double)param.campaignId());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    CampaignEDILABO campaign = (CampaignEDILABO)some2.value();
                    Tuple2 tuple2 = new Tuple2((Object)$this.contributorDao.getEDILABO(param.sender()), (Object)$this.contributorDao.getEDILABO(param.receiver()));
                    if (tuple2 != null) {
                        Option option3 = (Option)tuple2._1();
                        Option option4 = (Option)tuple2._2();
                        if (option3 instanceof Some) {
                            Some some3 = (Some)option3;
                            ContributorEDILABO sender = (ContributorEDILABO)some3.value();
                            if (option4 instanceof Some) {
                                String string;
                                Some some4 = (Some)option4;
                                ContributorEDILABO receiver = (ContributorEDILABO)some4.value();
                                Seq plannings = $this.campaignPlanningDao.getPlanEDILABO((long)param.campaignId());
                                if (plannings.isEmpty()) {
                                    Seq<QualitometerEDILABO> stationsPlan = $this.qualitometerPointDao.getAllEDILABOByCampaign(campaign.id());
                                    Seq parametersPlan = $this.parameterDao.getAllParameterEDILABO(campaign.id());
                                    Seq supports = $this.supportDao.getAllSupportEDILABO(campaign.id());
                                    plannings = (Seq)plannings.appended((Object)new CampaignPlanEDILABO(-1L, (long)campaign.id(), param.startDate(), param.endDate(), (Option)None$.MODULE$, stationsPlan, parametersPlan, supports));
                                }
                                String requestType = (String)campaign.requestType().getOrElse((Function0 & Serializable)() -> "0");
                                String fileName = new StringBuilder(2).append(param.requestName()).append("_").append(param.campaignId()).append("_").append(DateTimeFormat.forPattern((String)"YYMMddHHmm").print((ReadableInstant)DateTime.now())).toString();
                                try {
                                    Node edilaboXml = XmlBuilder$.MODULE$.getXmlEDILABOPlannification(fileName, (EDILABOParamPlanning)param, requestType, sender, receiver, (Seq<CampaignPlanEDILABO>)plannings);
                                    XML$.MODULE$.save(new StringBuilder(4).append(directory).append(fileName).append(".xml").toString(), edilaboXml, "UTF-8", true, null);
                                    string = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                                }
                                catch (FileNotFoundException err) {
                                    $this.logUtil.error(new StringBuilder(44).append("Error while building file : path unknown (").append(directory).append(")\n").append(err.getMessage()).toString(), $this.logUtil.error$default$2());
                                    $this.logUtil.printError((Throwable)err);
                                    string = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(43).append("Error while building file : path unknown (").append(directory).append(")").toString(), (Writes)Writes$.MODULE$.StringWrites()))})).toString();
                                }
                                catch (Throwable e) {
                                    $this.logUtil.error(new StringBuilder(39).append("An error as occur while building file: ").append(e.getMessage()).toString(), $this.logUtil.error$default$2());
                                    $this.logUtil.printError(e);
                                    string = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"An error as occur while building file", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
                                }
                                return string;
                            }
                        }
                    }
                    $this.logUtil.error(new StringBuilder(57).append("Contributors for EDILABO (sender: ").append(param.sender()).append(", receiver: ").append(param.receiver()).append(") undefined").toString(), $this.logUtil.error$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"Cant found contributors", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
                }
                $this.logUtil.error(new StringBuilder(19).append("Campaign ").append(param.campaignId()).append(" undefined").toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"Campaign undefined", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
            }
            $this.logUtil.error("Export directory for EDILABO undefined", $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"Export directory for EDILABO undefined", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
        });
    }

    @Inject
    public ExportEDILABOController(LogUtil logUtil, ContributorDao contributorDao, CampaignDao campaignDao, CampaignPlanningDao campaignPlanningDao, QualitometerPointDao qualitometerPointDao, ParameterDao parameterDao, SupportDao supportDao) {
        this.logUtil = logUtil;
        this.contributorDao = contributorDao;
        this.campaignDao = campaignDao;
        this.campaignPlanningDao = campaignPlanningDao;
        this.qualitometerPointDao = qualitometerPointDao;
        this.parameterDao = parameterDao;
        this.supportDao = supportDao;
    }
}

