/*
 * Decompiled with CFR 0.152.
 */
package facebook.controllers;

import com.google.inject.Inject;
import facebook.dao.FacebookDao;
import facebook.domain.input.FacebookParameterInput;
import facebook.domain.input.FacebookParameterInput$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.itf.HydrometryEventDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.itf.PluviometryEventDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.itf.QualityEventDao;
import fr.aquasys.rabbitmq.domain.JobInput;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Base64;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006Y\u0001\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0006k!A1\b\u0001B\u0001B\u0003-A\b\u0003\u0005G\u0001\t\u0005\t\u0015a\u0003H\u0011!Q\u0005A!A!\u0002\u0017Y\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b1B*\t\u0011Y\u0003!\u0011!Q\u0001\f]C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ya\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0006G\"A!\u000e\u0001B\u0001B\u0003-1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015a\u0003p\u0011\u00151\b\u0001\"\u0001x\u0011%\t\u0019\u0003\u0001b\u0001\n\u0003\t)\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0014\u0011%\tI\u0004\u0001b\u0001\n\u0003\t)\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0014\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!!8\u0001\t\u0013\tyN\u0001\nGC\u000e,'m\\8l\u0007>tGO]8mY\u0016\u0014(B\u0001\u000f\u001e\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u0003y\t\u0001BZ1dK\n|wn[\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\tI#'D\u0001+\u0015\tYC&\u0001\u0003vi&d'BA\u0017/\u0003!\u0011\u0018M\u00192ji6\f(BA\u00181\u0003\u001d\t\u0017/^1tsNT\u0011!M\u0001\u0003MJL!a\r\u0016\u0003\u000f1{w-\u0016;jY\u0006Ya-Y2fE>|7\u000eR1p!\t1\u0014(D\u00018\u0015\tAT$A\u0002eC>L!AO\u001c\u0003\u0017\u0019\u000b7-\u001a2p_.$\u0015m\\\u0001\u0010a&,'p\\7fi\u0016\u0014H)Y3bkB\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u0004SR4'BA!C\u0003)\u0001\u0018.\u001a>p[\u0016$(/\u001f\u0006\u0003\u0007:\nQ\u0001Z1fCVL!!\u0012 \u0003\u001fAKWM_8nKR,'\u000fR1fCV\f!\u0003]5fu>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_B\u0011Q\bS\u0005\u0003\u0013z\u0012!\u0003U5fu>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_\u0006q\u0001\u000f\\;wS>lW\r^3s\t\u0006|\u0007C\u0001'Q\u001b\u0005i%BA O\u0015\ty%)A\u0006qYV4\u0018n\\7fiJL\u0018BA)N\u00059\u0001F.\u001e<j_6,G/\u001a:EC>\f!\u0003\u001d7vS>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_B\u0011A\nV\u0005\u0003+6\u00131\u0003\u00157vm&|W.\u001a;ss\u00163XM\u001c;EC>\fQ\u0002[=ee>lW\r^3s\t\u0006|\u0007C\u0001-]\u001b\u0005I&BA [\u0015\tY&)\u0001\u0006is\u0012\u0014x.\\3uefL!!X-\u0003-!KHM]8m_\u001eL7-\u00197Ti\u0006$\u0018n\u001c8EC>\f!\u0003[=ee>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_B\u0011\u0001\fY\u0005\u0003Cf\u0013!\u0003S=ee>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_\u0006y\u0011/^1mSR|W.\u001a;fe\u0012\u000bw\u000e\u0005\u0002eQ6\tQM\u0003\u0002@M*\u0011qMQ\u0001\bcV\fG.\u001b;z\u0013\tIWMA\bRk\u0006d\u0017\u000e^8nKR,'\u000fR1p\u0003=\tX/\u00197jif,e/\u001a8u\t\u0006|\u0007C\u00013m\u0013\tiWMA\bRk\u0006d\u0017\u000e^=Fm\u0016tG\u000fR1p\u0003I\u0019\u0018.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005A$X\"A9\u000b\u0005}\u0012(BA:C\u00039\tG-\\5oSN$(/\u0019;j_:L!!^9\u0003%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a$\"#_>}{z|\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\fA\u0011!\u0010A\u0007\u00027!)q\u0005\u0004a\u0002Q!)A\u0007\u0004a\u0002k!)1\b\u0004a\u0002y!)a\t\u0004a\u0002\u000f\")!\n\u0004a\u0002\u0017\")!\u000b\u0004a\u0002'\")a\u000b\u0004a\u0002/\")a\f\u0004a\u0002?\")!\r\u0004a\u0002G\")!\u000e\u0004a\u0002W\")a\u000e\u0004a\u0002_\"\u001aA\"a\u0004\u0011\t\u0005E\u0011qD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00051\u0011N\u001c6fGRTA!!\u0007\u0002\u001c\u00051qm\\8hY\u0016T!!!\b\u0002\u0007\r|W.\u0003\u0003\u0002\"\u0005M!AB%oU\u0016\u001cG/\u0001\u0003E\u001f:+UCAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0001\\1oO*\u0011\u0011\u0011G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0005-\"AB*ue&tw-A\u0003E\u001f:+\u0005%A\u0002F%J\u000bA!\u0012*SA\u00059Q\r_3dkR,G\u0003BA!\u0003\u000f\u00022AIA\"\u0013\r\t)e\t\u0002\u0005+:LG\u000fC\u0004\u0002JE\u0001\r!a\u0013\u0002\u0011)|'-\u00138qkR\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#b\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002V\u0005=#\u0001\u0003&pE&s\u0007/\u001e;\u0002%I,7-\u001e:tSZ,G*[:u\r&dWm\u001d\u000b\u0005\u00037\ni\u0007E\u0003#\u0003;\n\t'C\u0002\u0002`\r\u0012Q!\u0011:sCf\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\ny#\u0001\u0002j_&!\u00111NA3\u0005\u00111\u0015\u000e\\3\t\u000f\u0005=$\u00031\u0001\u0002b\u0005!a-\u001b7f\u0003A9W\r\u001e$jY\u0016,\u0005\u0010^3og&|g\u000e\u0006\u0003\u0002v\u0005%\u0005\u0003BA<\u0003\u000bsA!!\u001f\u0002\u0002B\u0019\u00111P\u0012\u000e\u0005\u0005u$bAA@?\u00051AH]8pizJ1!a!$\u0003\u0019\u0001&/\u001a3fM&!\u0011QGAD\u0015\r\t\u0019i\t\u0005\b\u0003\u0017\u001b\u0002\u0019AA;\u0003!1\u0017\u000e\\3OC6,\u0017A\u0003:f]\u0006lWMR5mKR1\u0011\u0011IAI\u0003'Cq!a\u001c\u0015\u0001\u0004\t\t\u0007C\u0004\u0002\u0016R\u0001\r!!\u001e\u0002\rM,hMZ5y\u0003=\u0001XO\u00197jg\"4\u0015mY3c_>\\G\u0003DAN\u0003C\u000b\u0019+a*\u0002,\u0006=\u0006#\u0002\u0012\u0002\u001e\u0006U\u0014bAAPG\t1q\n\u001d;j_:Dq!a\u001c\u0016\u0001\u0004\t\t\u0007C\u0004\u0002&V\u0001\r!!\u001e\u0002#%tG/\u001a:oC2\u0014VMZ3sK:\u001cW\rC\u0004\u0002*V\u0001\r!!\u001e\u0002\rA\fw-Z%e\u0011\u001d\ti+\u0006a\u0001\u0003k\n\u0011\"^:feR{7.\u001a8\t\u000f\u0005EV\u00031\u0001\u00024\u0006q!n\u001c2Fq\u0016\u001cW\u000f^5p]&#\u0007c\u0001\u0012\u00026&\u0019\u0011qW\u0012\u0003\t1{gnZ\u0001\u000fa>\u001cH\u000fU5fu>lW\r^3s))\t\t%!0\u0002@\u0006\u0005\u00171\u0019\u0005\b\u0003_2\u0002\u0019AA1\u0011\u001d\tIK\u0006a\u0001\u0003kBq!!,\u0017\u0001\u0004\t)\bC\u0004\u00022Z\u0001\r!a-\u0002\u001fA|7\u000f\u001e)mkZLw.\\3uKJ$\"\"!\u0011\u0002J\u0006-\u0017QZAh\u0011\u001d\tyg\u0006a\u0001\u0003CBq!!+\u0018\u0001\u0004\t)\bC\u0004\u0002.^\u0001\r!!\u001e\t\u000f\u0005Ev\u00031\u0001\u00024\u0006q\u0001o\\:u\u0011f$'o\\7fi\u0016\u0014HCCA!\u0003+\f9.!7\u0002\\\"9\u0011q\u000e\rA\u0002\u0005\u0005\u0004bBAU1\u0001\u0007\u0011Q\u000f\u0005\b\u0003[C\u0002\u0019AA;\u0011\u001d\t\t\f\u0007a\u0001\u0003g\u000b\u0001\u0003]8tiF+\u0018\r\\5u_6,G/\u001a:\u0015\u0015\u0005\u0005\u0013\u0011]Ar\u0003K\f9\u000fC\u0004\u0002pe\u0001\r!!\u0019\t\u000f\u0005%\u0016\u00041\u0001\u0002v!9\u0011QV\rA\u0002\u0005U\u0004bBAY3\u0001\u0007\u00111\u0017")
public class FacebookController {
    private final LogUtil logUtil;
    private final FacebookDao facebookDao;
    private final PiezometerDaeau piezometerDaeau;
    private final PiezometryEventDao piezometryEventDao;
    private final PluviometerDao pluviometerDao;
    private final PluviometryEventDao pluiometryEventDao;
    private final HydrologicalStationDao hydrometerDao;
    private final HydrometryEventDao hydrometryEventDao;
    private final QualitometerDao qualitometerDao;
    private final QualityEventDao qualityEventDao;
    private final SieauParametersDao sieauParametersDao;
    private final String DONE;
    private final String ERR;

    public String DONE() {
        return this.DONE;
    }

    public String ERR() {
        return this.ERR;
    }

    public void execute(JobInput jobInput) {
        ((IterableOnceOps)jobInput.parameters().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)param -> {
            FacebookController.$anonfun$execute$2(this, jobInput, param);
            return BoxedUnit.UNIT;
        });
    }

    private File[] recursiveListFiles(File file2) {
        File[] files = file2.listFiles();
        File[] good = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FacebookController.$anonfun$recursiveListFiles$1(this, f)));
        return (File[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])good), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))), (Function1 & Serializable)file -> this.recursiveListFiles((File)file), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class)), ClassTag$.MODULE$.apply(File.class));
    }

    private String getFileExtension(String fileName) {
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return fileName.substring(lastIndexOf + 1);
    }

    private void renameFile(File file, String suffix) {
        Files.move(file.toPath(), file.toPath().resolveSibling(new StringBuilder(0).append(suffix).append(file.getName()).toString()), new CopyOption[0]);
    }

    private Option<String> publishFacebook(File file, String internalReference, String pageId, String userToken, long jobExecutionId) {
        return (Option)this.facebookDao.postFacebook(Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath())), this.getFileExtension(file.getName()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"locationId"), (Object)internalReference)}))), pageId, userToken).validate(FacebookParameterInput$.MODULE$.resultPublish()).fold((Function1 & Serializable)error -> {
            this.renameFile(file, this.ERR());
            JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), "Publish failed", String.valueOf(error));
            $this.logUtil.error(new StringBuilder(40).append("Cant parse json to get facebook result: ").append(error).toString(), $this.logUtil.error$default$2());
            return None$.MODULE$;
        }, (Function1 & Serializable)result -> {
            if (((Option)result._1()).isDefined()) {
                this.renameFile(file, this.DONE());
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.INFO(), "Publish successful", file.getName());
                return (Option)result._1();
            }
            this.renameFile(file, this.ERR());
            JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.ERROR(), "Publish failed", (String)((Option)result._3()).getOrElse((Function0 & Serializable)() -> ""));
            $this.logUtil.error(new StringBuilder(38).append("Error when publishing on facebook: [").append(((Option)result._2()).getOrElse((Function0 & Serializable)() -> "")).append("] ").append(((Option)result._3()).getOrElse((Function0 & Serializable)() -> "")).toString(), $this.logUtil.error$default$2());
            return None$.MODULE$;
        });
    }

    private void postPiezometer(File file, String pageId, String userToken, long jobExecutionId) {
        Option option = this.piezometerDaeau.getPiezometerIdByFileName(file.getName());
        if (option instanceof Some) {
            Some some = (Some)option;
            int id = BoxesRunTime.unboxToInt((Object)some.value());
            Option option2 = this.piezometerDaeau.getInternalReference(id);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String ref = (String)some2.value();
                this.publishFacebook(file, ref, pageId, userToken, jobExecutionId).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)this.piezometryEventDao.addTechnicalEvent((double)id, "Publish image on facebook", this.piezometryEventDao.addTechnicalEvent$default$3())));
            } else {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Piezometer interval reference not found", file.getName());
                this.renameFile(file, this.ERR());
            }
            return;
        }
        JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Piezometer not found", file.getName());
        this.renameFile(file, this.ERR());
    }

    private void postPluviometer(File file, String pageId, String userToken, long jobExecutionId) {
        Option option = this.pluviometerDao.getPluviometerIdByFileName(file.getName());
        if (option instanceof Some) {
            Some some = (Some)option;
            int id = BoxesRunTime.unboxToInt((Object)some.value());
            Option option2 = this.pluviometerDao.getInternalReference(id);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String ref = (String)some2.value();
                this.publishFacebook(file, ref, pageId, userToken, jobExecutionId).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)this.pluiometryEventDao.addTechnicalEvent(id, "Publish image on facebook")));
            } else {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Pluviometer interval reference not found", file.getName());
                this.renameFile(file, this.ERR());
            }
            return;
        }
        JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Pluviometer not found", file.getName());
        this.renameFile(file, this.ERR());
    }

    private void postHydrometer(File file, String pageId, String userToken, long jobExecutionId) {
        Option option = this.hydrometerDao.getHydrometerIdByFileName(file.getName());
        if (option instanceof Some) {
            Some some = (Some)option;
            double id = BoxesRunTime.unboxToDouble((Object)some.value());
            Option option2 = this.hydrometerDao.getInternalReference(id);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String ref = (String)some2.value();
                this.publishFacebook(file, ref, pageId, userToken, jobExecutionId).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)this.hydrometryEventDao.addTechnicalEvent(id, "Publish image on facebook")));
            } else {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Hydrometer interval reference not found", file.getName());
                this.renameFile(file, this.ERR());
            }
            return;
        }
        JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Hydrometer not found", file.getName());
        this.renameFile(file, this.ERR());
    }

    private void postQualitometer(File file, String pageId, String userToken, long jobExecutionId) {
        Option option = this.qualitometerDao.getQualitometerIdByFileName(file.getName());
        if (option instanceof Some) {
            Some some = (Some)option;
            double id = BoxesRunTime.unboxToDouble((Object)some.value());
            Option option2 = this.qualitometerDao.getInternalReference(id);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String ref = (String)some2.value();
                this.publishFacebook(file, ref, pageId, userToken, jobExecutionId).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)this.qualityEventDao.addTechnicalEvent(id, "Publish image on facebook")));
            } else {
                JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Qualitometer interval reference not found", file.getName());
                this.renameFile(file, this.ERR());
            }
            return;
        }
        JobLogUtil$.MODULE$.log(jobExecutionId, JobLogUtil$.MODULE$.WARNING(), "Qualitometer not found", file.getName());
        this.renameFile(file, this.ERR());
    }

    public static final /* synthetic */ void $anonfun$execute$5(FacebookController $this, FacebookParameterInput facebookParam$1, Option pageId$1, Option userToken$1, JobInput jobInput$1, File file) {
        block6: {
            String string = facebookParam$1.stationType();
            switch (string == null ? 0 : string.hashCode()) {
                case -1520726014: {
                    if (!"piezometry".equals(string)) break;
                    $this.postPiezometer(file, (String)pageId$1.get(), (String)userToken$1.get(), jobInput$1.jobExecutionId());
                    break block6;
                }
                case 651215103: {
                    if (!"quality".equals(string)) break;
                    $this.postQualitometer(file, (String)pageId$1.get(), (String)userToken$1.get(), jobInput$1.jobExecutionId());
                    break block6;
                }
                case 943976499: {
                    if (!"hydrometry".equals(string)) break;
                    $this.postHydrometer(file, (String)pageId$1.get(), (String)userToken$1.get(), jobInput$1.jobExecutionId());
                    break block6;
                }
                case 1310932864: {
                    if (!"pluviometry".equals(string)) break;
                    $this.postPluviometer(file, (String)pageId$1.get(), (String)userToken$1.get(), jobInput$1.jobExecutionId());
                    break block6;
                }
            }
            JobLogUtil$.MODULE$.log(jobInput$1.jobExecutionId(), JobLogUtil$.MODULE$.WARNING(), "Unknown station type", facebookParam$1.stationType());
        }
    }

    public static final /* synthetic */ void $anonfun$execute$4(FacebookController $this, JobInput jobInput$1, FacebookParameterInput facebookParam) {
        block4: {
            try {
                Option pageId = $this.sieauParametersDao.getValue("facebookPageId");
                Option userToken = $this.sieauParametersDao.getValue("facebookToken");
                if (pageId.isDefined() && userToken.isDefined()) {
                    String path = new StringBuilder(0).append(System.getenv("UPLOAD_DIRECTORY")).append(facebookParam.directory()).toString();
                    File[] files = $this.recursiveListFiles(new File(path));
                    if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])files))) {
                        JobLogUtil$.MODULE$.log(jobInput$1.jobExecutionId(), JobLogUtil$.MODULE$.WARNING(), "No file to publish", facebookParam.directory());
                    }
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)file -> {
                        FacebookController.$anonfun$execute$5($this, facebookParam, pageId, userToken, jobInput$1, file);
                        return BoxedUnit.UNIT;
                    });
                    break block4;
                }
                JobLogUtil$.MODULE$.log(jobInput$1.jobExecutionId(), JobLogUtil$.MODULE$.WARNING(), "Can't find facebook user token or facebook page ID", "");
            }
            catch (Exception e) {
                $this.logUtil.error(e.getMessage(), $this.logUtil.error$default$2());
                JobLogUtil$.MODULE$.log(jobInput$1.jobExecutionId(), JobLogUtil$.MODULE$.WARNING(), "Can't find directory", facebookParam.directory());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$execute$2(FacebookController $this, JobInput jobInput$1, String param) {
        Json$.MODULE$.parse(param).validate(FacebookParameterInput$.MODULE$.jsonReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Cant parse json to get facebook parameter: ").append(error).toString(), $this.logUtil.error$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)facebookParam -> {
            FacebookController.$anonfun$execute$4($this, jobInput$1, facebookParam);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$recursiveListFiles$1(FacebookController $this, File f) {
        return !f.getPath().contains($this.DONE()) && !f.getPath().contains($this.ERR()) && !f.isDirectory();
    }

    @Inject
    public FacebookController(LogUtil logUtil, FacebookDao facebookDao, PiezometerDaeau piezometerDaeau, PiezometryEventDao piezometryEventDao, PluviometerDao pluviometerDao, PluviometryEventDao pluiometryEventDao, HydrologicalStationDao hydrometerDao, HydrometryEventDao hydrometryEventDao, QualitometerDao qualitometerDao, QualityEventDao qualityEventDao, SieauParametersDao sieauParametersDao) {
        this.logUtil = logUtil;
        this.facebookDao = facebookDao;
        this.piezometerDaeau = piezometerDaeau;
        this.piezometryEventDao = piezometryEventDao;
        this.pluviometerDao = pluviometerDao;
        this.pluiometryEventDao = pluiometryEventDao;
        this.hydrometerDao = hydrometerDao;
        this.hydrometryEventDao = hydrometryEventDao;
        this.qualitometerDao = qualitometerDao;
        this.qualityEventDao = qualityEventDao;
        this.sieauParametersDao = sieauParametersDao;
        this.DONE = "DONE_";
        this.ERR = "ERR_";
    }
}

