/*
 * Decompiled with CFR 0.152.
 */
package hydroportail;

import fr.aquasys.daeau.referentials.contributor.model.ContributorLight;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.model.SmallMeasure;
import fr.aquasys.utils.MathUtil$;
import hydroportail.HydroportailFilter;
import java.io.Serializable;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class HydroportailBuilder$ {
    public static final HydroportailBuilder$ MODULE$ = new HydroportailBuilder$();

    public Node getHydroportailNode(String stationCode, ContributorLight sender, List<SmallMeasure> measures, HydroportailFilter filters, scala.collection.immutable.Seq<PointPrel> points, String typeIdStr, String senderContactSandre) {
        List correctedMeasures;
        List correctedMeasures2;
        scala.collection.immutable.Seq bruteNodes;
        scala.collection.immutable.Seq validatedNodes;
        scala.collection.immutable.Seq seq;
        String string = typeIdStr;
        String string2 = "H";
        int typeId = !(string != null ? !string.equals(string2) : string2 != null) ? 4 : 5;
        String nowStr = this.toIso(new DateTime());
        if (!filters.validMeasures().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            seq = (scala.collection.immutable.Seq)Nil$.MODULE$;
        } else {
            List validatedMeasures = measures.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$1(m)));
            if (validatedMeasures.isEmpty()) {
                seq = (scala.collection.immutable.Seq)Nil$.MODULE$;
            } else {
                DateTime firstDate = ((SmallMeasure)validatedMeasures.head()).date();
                DateTime lastDate = ((SmallMeasure)validatedMeasures.last()).date();
                Map grouped = validatedMeasures.groupBy((Function1 & Serializable)m -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)m.codepoint()), (Object)m.date().toString("dd/MM/YYYY")));
                PointPrel firstPoint = (PointPrel)points.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$3(typeId, p))).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception(new StringBuilder(101).append("Point de pr\u00e9l\u00e8vement principal introuvable sur la station ").append(stationCode).append(". Veuillez corriger la description du point").toString());
                });
                scala.collection.immutable.Seq secPoints = (scala.collection.immutable.Seq)((IterableOps)((SeqOps)points.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$5(typeId, p)))).sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.point()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.point()));
                String codeStationToExport = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(firstPoint.code()), 10);
                Tuple2 tuple2 = this.processValidatedMeasures((Map<Tuple2<Object, String>, List<SmallMeasure>>)grouped, firstDate, lastDate, (List<SmallMeasure>)Nil$.MODULE$, firstPoint.point(), (scala.collection.immutable.Seq<Object>)secPoints, typeIdStr).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$8(x$3)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List validated = (List)tuple2._1();
                List preValidated = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)validated, (Object)preValidated);
                List validated2 = (List)tuple22._1();
                List preValidated2 = (List)tuple22._2();
                seq = validatedNodes = (scala.collection.immutable.Seq)new .colon.colon(this.measuresNode((scala.collection.immutable.Seq<SmallMeasure>)validated2, true, codeStationToExport, typeIdStr, nowStr), (List)new .colon.colon(this.measuresNode((scala.collection.immutable.Seq<SmallMeasure>)preValidated2, true, codeStationToExport, typeIdStr, nowStr), (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms());
            }
        }
        scala.collection.immutable.Seq seq2 = !filters.bruteMeasures().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? (scala.collection.immutable.Seq)Nil$.MODULE$ : (bruteNodes = (correctedMeasures2 = measures.map((Function1 & Serializable)m -> {
            double x$1 = m.initialValue();
            DateTime x$2 = m.copy$default$1();
            int x$3 = m.copy$default$3();
            int x$4 = m.copy$default$4();
            double x$5 = m.copy$default$5();
            Option x$6 = m.copy$default$6();
            int x$7 = m.copy$default$7();
            return m.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7);
        })).isEmpty() ? (scala.collection.immutable.Seq)Nil$.MODULE$ : ((IterableOnceOps)correctedMeasures2.groupBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.codepoint())).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int codepoint = tuple2._1$mcI$sp();
                List pointMeasures = (List)tuple2._2();
                List brutes = MODULE$.processMeasuresForHydroportail((List<SmallMeasure>)pointMeasures, (List<SmallMeasure>)Nil$.MODULE$, true, typeIdStr).map((Function1 & Serializable)m -> {
                    int x$8 = 4;
                    int x$9 = 16;
                    DateTime x$10 = m.copy$default$1();
                    double x$11 = m.copy$default$2();
                    double x$12 = m.copy$default$5();
                    Option x$13 = m.copy$default$6();
                    int x$14 = m.copy$default$7();
                    return m.copy(x$10, x$11, 4, 16, x$12, x$13, x$14);
                });
                String sensorCode = ((PointPrel)points.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$13(codepoint, x$6))).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception(new StringBuilder(35).append("Point Prel not found : ").append(codepoint).append(" on station ").append(stationCode).toString());
                })).code();
                if (sensorCode.length() != 12) {
                    throw new Exception(new StringBuilder(100).append("Le code du point du pr\u00e9l\u00e8vement (capteur) doit contenir strictement 12 caract\u00e8res. (code ").append(sensorCode).append(", station ").append(stationCode).append(")").toString());
                }
                return (scala.collection.immutable.Seq)new .colon.colon(MODULE$.measuresNode((scala.collection.immutable.Seq<SmallMeasure>)brutes, false, sensorCode, typeIdStr, nowStr), (List)Nil$.MODULE$).flatten(Predef$.MODULE$.$conforms());
            }
            throw new MatchError((Object)tuple2);
        })).toSeq());
        scala.collection.immutable.Seq correctedNodes = !filters.bruteMeasures().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? (scala.collection.immutable.Seq)Nil$.MODULE$ : ((correctedMeasures = measures.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$15(m)))).isEmpty() ? (scala.collection.immutable.Seq)Nil$.MODULE$ : ((IterableOnceOps)correctedMeasures.groupBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.codepoint())).flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int codepoint = tuple2._1$mcI$sp();
                List pointMeasures = (List)tuple2._2();
                List<SmallMeasure> corrected = MODULE$.processMeasuresForHydroportail((List<SmallMeasure>)pointMeasures, (List<SmallMeasure>)Nil$.MODULE$, false, typeIdStr);
                String sensorCode = ((PointPrel)points.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)HydroportailBuilder$.$anonfun$getHydroportailNode$18(codepoint, x$8))).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception(new StringBuilder(35).append("Point Prel not found : ").append(codepoint).append(" on station ").append(stationCode).toString());
                })).code();
                if (sensorCode.length() != 12) {
                    throw new Exception(new StringBuilder(100).append("Le code du point du pr\u00e9l\u00e8vement (capteur) doit contenir strictement 12 caract\u00e8res. (code ").append(sensorCode).append(", station ").append(stationCode).append(")").toString());
                }
                return (scala.collection.immutable.Seq)new .colon.colon(MODULE$.measuresNode((scala.collection.immutable.Seq<SmallMeasure>)corrected, false, sensorCode, typeIdStr, nowStr), (List)Nil$.MODULE$).flatten(Predef$.MODULE$.$conforms());
            }
            throw new MatchError((Object)tuple2);
        })).toSeq());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("hydrometrie"));
        $buf2.$amp$plus((Object)new Elem(null, "CodeScenario", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("2"));
        $buf2.$amp$plus((Object)new Elem(null, "VersionScenario", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Echange de donn\u00e9es hydrom\u00e9triques"));
        $buf2.$amp$plus((Object)new Elem(null, "NomScenario", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)nowStr);
        $buf2.$amp$plus((Object)new Elem(null, "DateHeureCreationFichier", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf2.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n                    "));
        $buf7.$amp$plus((Object)this.getContributor(sender));
        $buf7.$amp$plus((Object)new Text("\n                    "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("schemeAgencyID", (Seq)new Text("SANDRE"), (MetaData)$md);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)senderContactSandre);
        $buf7.$amp$plus((Object)new Elem(null, "CdContact", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n                "));
        $buf2.$amp$plus((Object)new Elem(null, "Emetteur", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf2.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                    "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("schemeAgencyID", (Seq)new Text("SANDRE"), (MetaData)$md2);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("1537"));
        $buf9.$amp$plus((Object)new Elem(null, "CdIntervenant", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n                "));
        $buf2.$amp$plus((Object)new Elem(null, "Destinataire", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf2.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "Scenario", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n                    "));
        $buf12.$amp$plus(((IterableOps)bruteNodes.$plus$plus((IterableOnce)correctedNodes)).$plus$plus((IterableOnce)validatedNodes));
        $buf12.$amp$plus((Object)new Text("\n                "));
        $buf11.$amp$plus((Object)new Elem(null, "SeriesObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "Donnees", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "hydrometrie", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Node getContributor(ContributorLight c) {
        if (c.sandreCode().isDefined()) {
            void var3_3;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("schemeAgencyID", (Seq)new Text("SANDRE"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(c.sandreCode().get());
            return new Elem(null, "CdIntervenant", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
        }
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("schemeAgencyID", (Seq)new Text("SIRET"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(c.siret().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(42).append("Contributor without sandreCode or siret : ").append(c.id().get()).toString());
        }));
        return new Elem(null, "CdIntervenant", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public String toIso(DateTime d) {
        return d.toString("yyyy-MM-dd'T'HH:mm:ss");
    }

    public Option<Node> measuresNode(scala.collection.immutable.Seq<SmallMeasure> measures, boolean isStation, String code, String typeIdStr, String nowStr) {
        if (measures.nonEmpty()) {
            Elem elem;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                    "));
            if (isStation) {
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)code);
                Elem elem2 = new Elem(null, "CdStationHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2));
                elem = elem2;
            } else {
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)code);
                Elem elem3 = new Elem(null, "CdCapteur", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3));
                elem = elem3;
            }
            $buf.$amp$plus((Object)elem);
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)typeIdStr);
            $buf.$amp$plus((Object)new Elem(null, "GrdSerieObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)this.toIso(((SmallMeasure)measures.head()).date()));
            $buf.$amp$plus((Object)new Elem(null, "DtDebSerieObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)this.toIso(((SmallMeasure)measures.last()).date()));
            $buf.$amp$plus((Object)new Elem(null, "DtFinSerieObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)nowStr);
            $buf.$amp$plus((Object)new Elem(null, "DtProdSerieObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n                        "));
            $buf8.$amp$plus(((IterableOps)measures.reverse()).map((Function1 & Serializable)m -> {
                void var1_1;
                Elem elem;
                void var3_3;
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n                            "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)MODULE$.toIso(m.date()));
                $buf.$amp$plus((Object)new Elem(null, "DtObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
                $buf.$amp$plus((Object)new Text("\n                            "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)BoxesRunTime.boxToDouble((double)m.value()));
                $buf.$amp$plus((Object)new Elem(null, "ResObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
                $buf.$amp$plus((Object)new Text("\n                            "));
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)m.qualification()));
                $buf.$amp$plus((Object)new Elem(null, "QualifObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
                $buf.$amp$plus((Object)new Text("\n                            "));
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("0"));
                $buf.$amp$plus((Object)new Elem(null, "MethObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
                $buf.$amp$plus((Object)new Text("\n                            "));
                if (m.intialPoint().contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                    NodeBuffer $buf6 = new NodeBuffer();
                    $buf6.$amp$plus((Object)new Text("1"));
                    Elem elem2 = new Elem(null, "ContObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6));
                    elem = elem2;
                } else {
                    NodeBuffer $buf7 = new NodeBuffer();
                    $buf7.$amp$plus((Object)new Text("0"));
                    Elem elem3 = new Elem(null, "ContObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7));
                    elem = elem3;
                }
                $buf.$amp$plus((Object)elem);
                $buf.$amp$plus((Object)new Text("\n                            "));
                NodeBuffer $buf8 = new NodeBuffer();
                $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)m.status()));
                $buf.$amp$plus((Object)new Elem(null, "StObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
                $buf.$amp$plus((Object)new Text("\n                        "));
                return new Elem(null, "ObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }));
            $buf8.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus((Object)new Elem(null, "ObssHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf.$amp$plus((Object)new Text("\n                "));
            return new Some((Object)new Elem(null, "SerieObsHydro", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        }
        return None$.MODULE$;
    }

    private List<SmallMeasure> processMeasuresForHydroportail(List<SmallMeasure> measures, List<SmallMeasure> built, boolean isBrute, String typeIdStr) {
        List list;
        while (true) {
            SmallMeasure m;
            int n;
            int n2;
            if (Nil$.MODULE$.equals(list = measures)) {
                return built.reverse();
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            SmallMeasure head = (SmallMeasure)colon2.head();
            List tail = colon2.next$access$1();
            int n3 = head.status();
            switch (n3) {
                case 2: {
                    n2 = 12;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 16;
                    break;
                }
                default: {
                    if (isBrute) {
                        n2 = 4;
                        break;
                    }
                    n2 = 8;
                    break;
                }
            }
            int x$1 = n2;
            int n4 = head.qualification();
            switch (n4) {
                case 1: {
                    n = 20;
                    break;
                }
                case 2: 
                case 3: {
                    n = 12;
                    break;
                }
                default: {
                    n = 16;
                    break;
                }
            }
            int x$2 = n;
            String string = typeIdStr;
            String string2 = "H";
            double x$3 = !(string != null ? !string.equals(string2) : string2 != null) ? MathUtil$.MODULE$.roundAt(3, head.value() * 1000.0) : MathUtil$.MODULE$.roundAt(3, head.value() / 3.6);
            DateTime x$4 = head.copy$default$1();
            double x$5 = head.copy$default$5();
            Option x$6 = head.copy$default$6();
            int x$7 = head.copy$default$7();
            SmallMeasure smallMeasure = m = head.copy(x$4, x$3, x$1, x$2, x$5, x$6, x$7);
            built = (List)built.$plus$colon((Object)smallMeasure);
            measures = tail;
        }
        throw new MatchError(list);
    }

    private List<SmallMeasure> processValidatedMeasures(Map<Tuple2<Object, String>, List<SmallMeasure>> measures, DateTime start, DateTime end, List<SmallMeasure> built, int firstPoint, scala.collection.immutable.Seq<Object> secPoints, String typeIdStr) {
        Option option;
        while (true) {
            if (start.getMillis() > end.getMillis()) {
                return built;
            }
            Option foundMeasure = measures.get((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)firstPoint), (Object)start.toString("dd/MM/YYYY"))).map((Function1 & Serializable)x$9 -> x$9.toList()).orElse((Function0 & Serializable)() -> (Option)secPoints.foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(acc, secPoint) -> HydroportailBuilder$.$anonfun$processValidatedMeasures$3(measures, start, acc, BoxesRunTime.unboxToInt((Object)secPoint))));
            option = foundMeasure;
            if (None$.MODULE$.equals(option)) {
                start = start.plusDays(1);
                continue;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            List measuresToExport = (List)some.value();
            List<SmallMeasure> processed = this.processMeasuresForHydroportail((List<SmallMeasure>)measuresToExport, (List<SmallMeasure>)Nil$.MODULE$, false, typeIdStr);
            built = (List)built.$plus$plus(processed);
            start = start.plusDays(1);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$1(SmallMeasure m) {
        return package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})).contains((Object)BoxesRunTime.boxToInteger((int)m.status()));
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$3(int typeId$1, PointPrel p) {
        return p.typePoint() == 1 && p.typeId() == typeId$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$5(int typeId$1, PointPrel p) {
        return p.typePoint() == 2 && p.typeId() == typeId$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$8(SmallMeasure x$3) {
        return x$3.status() == 16;
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$13(int codepoint$1, PointPrel x$6) {
        return x$6.point() == codepoint$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$15(SmallMeasure m) {
        return !package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})).contains((Object)BoxesRunTime.boxToInteger((int)m.status())) && m.value() != m.initialValue();
    }

    public static final /* synthetic */ boolean $anonfun$getHydroportailNode$18(int codepoint$2, PointPrel x$8) {
        return x$8.point() == codepoint$2;
    }

    public static final /* synthetic */ Option $anonfun$processValidatedMeasures$3(Map measures$1, DateTime start$1, Option acc, int secPoint) {
        if (acc.isDefined()) {
            return acc;
        }
        return measures$1.get((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)secPoint), (Object)start$1.toString("dd/MM/YYYY")));
    }

    private HydroportailBuilder$() {
    }
}

