/*
 * Decompiled with CFR 0.152.
 */
package hydroportail;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.export.hydroportail.HydroportailJournal;
import fr.aquasys.daeau.export.hydroportail.HydroportailJournalDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.referentials.contact.Contact;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.contributor.model.ContributorLight;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef;
import fr.aquasys.daeau.station.links.tempRef.StationTempRefDao;
import fr.aquasys.daeau.station.model.SmallMeasure;
import fr.aquasys.daeau.user.domain.UserFilterWithLinks;
import fr.aquasys.daeau.user.itf.UserFilterDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.ExportRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import fr.aquasys.utils.StringUtil$;
import hydroportail.HydroportailBuilder$;
import hydroportail.HydroportailFilter;
import hydroportail.HydroportailFilter$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\n\u0015\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006Y!\n\u0005\tc\u0001\u0011\t\u0011)A\u0006e!AA\b\u0001B\u0001B\u0003-Q\b\u0003\u0005E\u0001\t\u0005\t\u0015a\u0003F\u0011!a\u0005A!A!\u0002\u0017i\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b1\u0002+\t\u0011u\u0003!\u0011!Q\u0001\fyC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Y!\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0006a\"Aa\u000f\u0001B\u0001B\u0003-q\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBAI\u0001\u0011%\u00111\u0013\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!!<\u0001\t\u0003\tyO\u0001\fIs\u0012\u0014x\u000e]8si\u0006LGnQ8oiJ|G\u000e\\3s\u0015\u0005)\u0012\u0001\u00045zIJ|\u0007o\u001c:uC&d7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\r\t\u0007/[\u0005\u0003G\u0001\u0012Q!T8eK2\fq\u0001T8h+RLG\u000e\u0005\u0002'_5\tqE\u0003\u0002)S\u0005!Q\u000f^5m\u0015\tQ3&\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\taS&A\u0004bcV\f7/_:\u000b\u00039\n!A\u001a:\n\u0005A:#a\u0002'pOV#\u0018\u000e\\\u0001\u000ekN,'OR5mi\u0016\u0014H)Y8\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014aA5uM*\u0011q\u0007O\u0001\u0005kN,'O\u0003\u0002:W\u0005)A-Y3bk&\u00111\b\u000e\u0002\u000e+N,'OR5mi\u0016\u0014H)Y8\u0002-!KHM]8q_J$\u0018-\u001b7K_V\u0014h.\u00197EC>\u0004\"A\u0010\"\u000e\u0003}R!!\u0006!\u000b\u0005\u0005C\u0014AB3ya>\u0014H/\u0003\u0002D\u007f\t1\u0002*\u001f3s_B|'\u000f^1jY*{WO\u001d8bY\u0012\u000bw.\u0001\fIs\u0012\u0014x\u000e\\8hS\u000e\fGn\u0015;bi&|g\u000eR1p!\t1%*D\u0001H\u0015\t)\u0004J\u0003\u0002Jq\u0005Q\u0001.\u001f3s_6,GO]=\n\u0005-;%A\u0006%zIJ|Gn\\4jG\u0006d7\u000b^1uS>tG)Y8\u0002\u001f!KHM]8DQJ|g.[2EC>\u0004\"AT)\u000e\u0003=S!\u0001\u0015%\u0002\u000f\rD'o\u001c8jG&\u0011!k\u0014\u0002\u0010\u0011f$'o\\\"ie>t\u0017n\u0019#b_\u0006y1i\u001c8ue&\u0014W\u000f^8sg\u0012\u000bw\u000e\u0005\u0002V76\taK\u0003\u00026/*\u0011\u0001,W\u0001\fG>tGO]5ckR|'O\u0003\u0002[q\u0005a!/\u001a4fe\u0016tG/[1mg&\u0011AL\u0016\u0002\u0010\u0007>tGO]5ckR|'o\u001d#b_\u0006Q1i\u001c8uC\u000e$H)Y8\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005L\u0016aB2p]R\f7\r^\u0005\u0003G\u0002\u0014!bQ8oi\u0006\u001cG\u000fR1p\u00031\u0001v.\u001b8u!J,G\u000eR1p!\t1W.D\u0001h\u0015\tA\u0017.A\u0005q_&tG\u000f\u001d:fY*\u0011!n[\u0001\u0006Y&t7n\u001d\u0006\u0003Yb\nqa\u001d;bi&|g.\u0003\u0002oO\na\u0001k\\5oiB\u0013X\r\u001c#b_\u0006\t2\u000b^1uS>tG+Z7q%\u00164G)Y8\u0011\u0005E$X\"\u0001:\u000b\u0005ML\u0017a\u0002;f[B\u0014VMZ\u0005\u0003kJ\u0014\u0011c\u0015;bi&|g\u000eV3naJ+g\rR1p\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003qnl\u0011!\u001f\u0006\u0003u.\nQ!\u001e;jYNL!\u0001`=\u0003\u0015){'\rT8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002\u007fR1\u0012\u0011AA\u0003\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\u0002E\u0002\u0002\u0004\u0001i\u0011\u0001\u0006\u0005\u0006I-\u0001\u001d!\n\u0005\u0006c-\u0001\u001dA\r\u0005\u0006y-\u0001\u001d!\u0010\u0005\u0006\t.\u0001\u001d!\u0012\u0005\u0006\u0019.\u0001\u001d!\u0014\u0005\u0006'.\u0001\u001d\u0001\u0016\u0005\u0006;.\u0001\u001dA\u0018\u0005\u0006I.\u0001\u001d!\u001a\u0005\u0006_.\u0001\u001d\u0001\u001d\u0005\u0006m.\u0001\u001da\u001e\u0015\u0004\u0017\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0007S:TWm\u0019;\u000b\u0005\u0005\u0015\u0012!\u00026bm\u0006D\u0018\u0002BA\u0015\u0003?\u0011a!\u00138kK\u000e$\u0018aB3yK\u000e,H/\u001a\u000b\u0007\u0003_\t)$a\u0014\u0011\u0007e\t\t$C\u0002\u00024i\u0011A!\u00168ji\"9\u0011q\u0007\u0007A\u0002\u0005e\u0012A\u0003:pkRLgnZ&fsB!\u00111HA%\u001d\u0011\ti$!\u0012\u0011\u0007\u0005}\"$\u0004\u0002\u0002B)\u0019\u00111\t\f\u0002\rq\u0012xn\u001c;?\u0013\r\t9EG\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0013Q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d#\u0004C\u0004\u0002R1\u0001\r!a\u0015\u0002\u000f5,7o]1hKB!\u0011QKA3\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00026t_:TA!!\u0018\u0002`\u0005!A.\u001b2t\u0015\r\t\u0013\u0011\r\u0006\u0003\u0003G\nA\u0001\u001d7bs&!\u0011qMA,\u0005\u001dQ5OV1mk\u0016\fQbZ3u%>,H/\u001b8h\u0017\u0016LHCAA\u001d\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\r\u0005=\u0012\u0011OAD\u0011\u001d\t\u0019H\u0004a\u0001\u0003k\n\u0011!\u001a\t\u0005\u0003o\n\tI\u0004\u0003\u0002z\u0005ud\u0002BA \u0003wJ\u0011aG\u0005\u0004\u0003\u007fR\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\u000b)IA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u0011q\u0010\u000e\t\u000f\u0005%e\u00021\u0001\u0002\f\u0006q!n\u001c2Fq\u0016\u001cW\u000f^5p]&#\u0007cA\r\u0002\u000e&\u0019\u0011q\u0012\u000e\u0003\t1{gnZ\u0001\u001aKb,7-\u001e;f\u000bb\u0004xN\u001d;Is\u0012\u0014x\u000e]8si\u0006LG\u000e\u0006\u0003\u00020\u0005U\u0005bBA)\u001f\u0001\u0007\u00111K\u0001\u0014O\u0016$8+\u001a7fGR,Gm\u0015;bi&|gn\u001d\u000b\u0007\u00037\u000b9+!-\u0011\r\u0005]\u0014QTAQ\u0013\u0011\ty*!\"\u0003\u0007M+\u0017\u000fE\u0002\u001a\u0003GK1!!*\u001b\u0005\rIe\u000e\u001e\u0005\b\u0003S\u0003\u0002\u0019AAV\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!a\u0001\u0002.&\u0019\u0011q\u0016\u000b\u0003%!KHM]8q_J$\u0018-\u001b7GS2$XM\u001d\u0005\b\u0003\u0013\u0003\u0002\u0019AAF\u000399W\r^#ya>\u0014H\u000fR1uKN$\"\"a.\u0002`\u0006\u0005\u00181]Au!%I\u0012\u0011XA_\u0003{\u000b9.C\u0002\u0002<j\u0011a\u0001V;qY\u0016\u001c\u0004#B\r\u0002@\u0006\r\u0017bAAa5\t1q\n\u001d;j_:\u0004B!!2\u0002T6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-\u0001\u0003uS6,'\u0002BAg\u0003\u001f\fAA[8eC*\u0011\u0011\u0011[\u0001\u0004_J<\u0017\u0002BAk\u0003\u000f\u0014\u0001\u0002R1uKRKW.\u001a\t\u00063\u0005}\u0016\u0011\u001c\t\u0004}\u0005m\u0017bAAo\u007f\t\u0019\u0002*\u001f3s_B|'\u000f^1jY*{WO\u001d8bY\"9\u0011\u0011R\tA\u0002\u0005-\u0005bBAU#\u0001\u0007\u00111\u0016\u0005\b\u0003K\f\u0002\u0019AAt\u0003!Qw.\u001e:oC2\u001c\bCBA<\u0003;\u000bI\u000eC\u0004\u0002lF\u0001\r!!)\u0002\u000f!LHM]8JI\u0006)Ao\\+U\u0007R1\u0011\u0011_A\u0000\u0005\u0007\u0001b!a\u001e\u0002\u001e\u0006M\b\u0003BA{\u0003wl!!a>\u000b\u0007\u0005e8.A\u0003n_\u0012,G.\u0003\u0003\u0002~\u0006](\u0001D*nC2dW*Z1tkJ,\u0007b\u0002B\u0001%\u0001\u0007\u0011\u0011_\u0001\t[\u0016\f7/\u001e:fg\"11O\u0005a\u0001\u0005\u000b\u0001b!a\u001e\u0002\u001e\n\u001d\u0001cA9\u0003\n%\u0019!1\u0002:\u0003\u001dM#\u0018\r^5p]R+W\u000e\u001d*fM\u0002")
public class HydroportailController
implements Model {
    private final LogUtil LogUtil;
    private final UserFilterDao userFilterDao;
    private final HydroportailJournalDao HydroportailJournalDao;
    private final HydrologicalStationDao HydrologicalStationDao;
    private final HydroChronicDao HydroChronicDao;
    private final ContributorsDao ContributorsDao;
    private final ContactDao ContactDao;
    private final PointPrelDao PointPrelDao;
    private final StationTempRefDao StationTempRefDao;
    private final JobLogUtil JobLogUtil;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        HydroportailController hydroportailController = this;
        synchronized (hydroportailController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        HydroportailController hydroportailController = this;
        synchronized (hydroportailController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = ExportRouting$.MODULE$.EXPORT_HYDROPORTAIL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeExportHydroportail(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.logUtil().info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.logUtil().info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public String getRoutingKey() {
        return ExportRouting$.MODULE$.EXPORT_HYDROPORTAIL();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    private void executeExportHydroportail(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            HydroportailController.$anonfun$executeExportHydroportail$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParameters -> {
            HydroportailController.$anonfun$executeExportHydroportail$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Seq<Object> getSelectedStations(HydroportailFilter filters, long jobExecutionId) {
        Some some;
        String string;
        Option<String> option = filters.selectStationsMode();
        if (option instanceof Some && "STATIONS".equals(string = (String)(some = (Some)option).value())) {
            return (scala.collection.immutable.Seq)filters.stations().get();
        }
        scala.collection.immutable.Seq filtersStations = (scala.collection.immutable.Seq)filters.stationsFilter().map((Function1 & Serializable)filterCode -> HydroportailController.$anonfun$getSelectedStations$1(this, BoxesRunTime.unboxToInt((Object)filterCode))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(41).append("Found ").append(filtersStations.length()).append(" hydro stations matching criterias.").toString(), "", this.JobLogUtil.log$default$5());
        return filtersStations;
    }

    public Tuple3<Option<DateTime>, Option<DateTime>, Option<HydroportailJournal>> getExportDates(long jobExecutionId, HydroportailFilter filters, scala.collection.immutable.Seq<HydroportailJournal> journals, int hydroId) {
        String string;
        String string2;
        boolean bl = false;
        Some some = null;
        Option<String> option = filters.mode();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string3 = (String)some.value();
            if ("ALL".equals(string3)) {
                return new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)new DateTime()), (Object)None$.MODULE$);
            }
        }
        if (bl && "CUSTOM".equals(string2 = (String)some.value())) {
            return new Tuple3((Object)filters.startDate().map((Function1 & Serializable)x$5 -> x$5.withTimeAtStartOfDay()), filters.endDate(), (Object)None$.MODULE$);
        }
        if (bl && "DIFF".equals(string = (String)some.value())) {
            Option option2 = journals.find((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)HydroportailController.$anonfun$getExportDates$2(hydroId, j)));
            if (None$.MODULE$.equals(option2)) {
                return new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                HydroportailJournal j2 = (HydroportailJournal)some2.value();
                return new Tuple3((Object)new Some((Object)j2.oldestUpdate().withTimeAtStartOfDay()), (Object)None$.MODULE$, (Object)new Some((Object)j2));
            }
            throw new MatchError((Object)option2);
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Unknown export mode.", "", this.JobLogUtil.log$default$5());
        throw new Exception("Unknown export mode.");
    }

    public scala.collection.immutable.Seq<SmallMeasure> toUTC(scala.collection.immutable.Seq<SmallMeasure> measures, scala.collection.immutable.Seq<StationTempRef> tempRef) {
        if (tempRef.isEmpty()) {
            return measures;
        }
        if (tempRef.length() == 1) {
            int n = BoxesRunTime.unboxToInt((Object)((StationTempRef)tempRef.head()).tempRef().map((Function1)(JFunction1.mcIJ.sp & Serializable)x$6 -> (int)x$6).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
            switch (n) {
                case 1: {
                    return measures;
                }
                case 3: {
                    return (scala.collection.immutable.Seq)measures.map((Function1 & Serializable)m -> m.copy(m.date().minusHours(2), m.copy$default$2(), m.copy$default$3(), m.copy$default$4(), m.copy$default$5(), m.copy$default$6(), m.copy$default$7()));
                }
                case 4: {
                    return (scala.collection.immutable.Seq)measures.map((Function1 & Serializable)m -> m.copy(m.date().minusHours(1), m.copy$default$2(), m.copy$default$3(), m.copy$default$4(), m.copy$default$5(), m.copy$default$6(), m.copy$default$7()));
                }
            }
            throw new Exception("La r\u00e9f\u00e9rence temporelle 'Heure l\u00e9gale' n'est pas encore impl\u00e9ment\u00e9e. Veuillez contacter le support AQUASYS.");
        }
        Map groupByRef = measures.groupBy((Function1 & Serializable)m -> tempRef.find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)HydroportailController.$anonfun$toUTC$6(m, t))));
        return ((IterableOnceOps)groupByRef.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option tempRefOpt = (Option)tuple2._1();
                scala.collection.immutable.Seq tempMeasures = (scala.collection.immutable.Seq)tuple2._2();
                int n = BoxesRunTime.unboxToInt((Object)tempRefOpt.flatMap((Function1 & Serializable)x$7 -> x$7.tempRef()).map((Function1)(JFunction1.mcIJ.sp & Serializable)x$8 -> (int)x$8).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
                switch (n) {
                    case 1: {
                        return tempMeasures;
                    }
                    case 3: {
                        return (scala.collection.immutable.Seq)tempMeasures.map((Function1 & Serializable)m -> m.copy(m.date().minusHours(2), m.copy$default$2(), m.copy$default$3(), m.copy$default$4(), m.copy$default$5(), m.copy$default$6(), m.copy$default$7()));
                    }
                    case 4: {
                        return (scala.collection.immutable.Seq)tempMeasures.map((Function1 & Serializable)m -> m.copy(m.date().minusHours(1), m.copy$default$2(), m.copy$default$3(), m.copy$default$4(), m.copy$default$5(), m.copy$default$6(), m.copy$default$7()));
                    }
                }
                throw new Exception("La r\u00e9f\u00e9rence temporelle 'Heure l\u00e9gale' n'est pas encore impl\u00e9ment\u00e9e. Veuillez contacter le support AQUASYS.");
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    public static final /* synthetic */ void $anonfun$executeExportHydroportail$1(HydroportailController $this, Seq error) {
        Predef$.MODULE$.print((Object)error);
        $this.logUtil().error(new StringBuilder(22).append("Error validate Json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil().error$default$2());
    }

    public static final /* synthetic */ long $anonfun$executeExportHydroportail$12(SmallMeasure x$2) {
        return x$2.date().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$executeExportHydroportail$13(int typeId$1, StationTempRef t) {
        return t.typeId().isEmpty() || t.typeId().contains((Object)BoxesRunTime.boxToInteger((int)typeId$1));
    }

    public static final /* synthetic */ boolean $anonfun$executeExportHydroportail$16(HydroportailFilter filters$1, ContributorLight x$3) {
        return x$3.id().contains((Object)BoxesRunTime.boxToInteger((int)filters$1.sender()));
    }

    public static final /* synthetic */ void $anonfun$executeExportHydroportail$10(HydroportailController $this, long jobExecutionId$1, HydroportailFilter filters$1, scala.collection.immutable.Seq journals$1, int typeId$1, scala.collection.immutable.Seq contribs$1, String senderContactSandre$1, String user$1, String directory$1, HydroStation hydro) {
        block8: {
            String hydroCode = (String)hydro.code().getOrElse((Function0 & Serializable)() -> "unknown");
            String stationCode = hydroCode.length() > 10 ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hydroCode), 10) : (hydroCode.length() < 10 ? new StringBuilder(2).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hydroCode), 8)).append("01").toString() : hydroCode);
            try {
                Tuple3<Option<DateTime>, Option<DateTime>, Option<HydroportailJournal>> tuple3 = $this.getExportDates(jobExecutionId$1, filters$1, (scala.collection.immutable.Seq<HydroportailJournal>)journals$1, (int)hydro.id());
                if (tuple3 != null) {
                    Option option = (Option)tuple3._1();
                    Option option2 = (Option)tuple3._2();
                    if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(22).append("No data to export for ").append(hydroCode).toString(), hydroCode, $this.JobLogUtil.log$default$5());
                        break block8;
                    }
                }
                if (tuple3 != null) {
                    Option start = (Option)tuple3._1();
                    Option end = (Option)tuple3._2();
                    Option journalOpt = (Option)tuple3._3();
                    int x$1 = (int)hydro.id();
                    int x$22 = typeId$1;
                    Option x$32 = start;
                    Option x$4 = end;
                    String x$5 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
                    scala.collection.immutable.Seq x$6 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
                    Option x$7 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
                    Option x$8 = MeasuresParams$.MODULE$.$lessinit$greater$default$8();
                    Option x$9 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
                    Option x$10 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
                    Option x$11 = MeasuresParams$.MODULE$.$lessinit$greater$default$11();
                    Option x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
                    Option x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
                    Option x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
                    Option x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
                    Option x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
                    Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
                    Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$18();
                    Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$19();
                    Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
                    Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$21();
                    Option x$222 = MeasuresParams$.MODULE$.$lessinit$greater$default$22();
                    Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
                    Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
                    Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
                    Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
                    scala.collection.immutable.Seq<SmallMeasure> measures = $this.toUTC((scala.collection.immutable.Seq<SmallMeasure>)((scala.collection.immutable.Seq)$this.HydroChronicDao.getSmallMeasures(new MeasuresParams(x$5, x$1, x$6, x$22, x$7, x$32, x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$222, x$23, x$24, x$25, x$26)).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)HydroportailController.$anonfun$executeExportHydroportail$12(x$2)), (Ordering)Ordering.Long$.MODULE$)), (scala.collection.immutable.Seq<StationTempRef>)((scala.collection.immutable.Seq)$this.StationTempRefDao.getTempRefs(StationTypeUtil$.MODULE$.HYDROMETRY(), hydro.id()).filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)HydroportailController.$anonfun$executeExportHydroportail$13(typeId$1, t)))));
                    DateTime startFile = (DateTime)start.getOrElse((Function0 & Serializable)() -> ((SmallMeasure)measures.head()).date());
                    DateTime endFile = (DateTime)end.getOrElse((Function0 & Serializable)() -> ((SmallMeasure)measures.last()).date());
                    if (measures.isEmpty()) {
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(22).append("No measures found for ").append(hydroCode).toString(), hydroCode, $this.JobLogUtil.log$default$5());
                    } else {
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), "Building file", hydroCode, $this.JobLogUtil.log$default$5());
                        Node node = HydroportailBuilder$.MODULE$.getHydroportailNode(stationCode, (ContributorLight)contribs$1.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HydroportailController.$anonfun$executeExportHydroportail$16(filters$1, x$3))).getOrElse((Function0 & Serializable)() -> {
                            throw new Exception(new StringBuilder(35).append("Sender not found on contributors : ").append(filters$1.sender()).toString());
                        }), (List<SmallMeasure>)measures.toList(), filters$1, (scala.collection.immutable.Seq<PointPrel>)$this.PointPrelDao.getPoints(StationTypeUtil$.MODULE$.HYDROMETRY(), (int)hydro.id()), typeId$1 == 4 ? "H" : "Q", senderContactSandre$1);
                        Tuple2 tuple2 = $this.HydroportailJournalDao.sendExport(journalOpt, (int)hydro.id(), hydroCode, typeId$1, startFile, endFile, user$1, jobExecutionId$1, "create export file");
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        long num = tuple2._1$mcJ$sp();
                        String fileName = (String)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)num), (Object)fileName);
                        long num2 = tuple22._1$mcJ$sp();
                        String fileName2 = (String)tuple22._2();
                        XML$.MODULE$.save(new StringBuilder(0).append(directory$1).append(fileName2).toString(), node, "UTF-8", true, XML$.MODULE$.save$default$5());
                        FileUtil$.MODULE$.runCMDInScript(directory$1, (scala.collection.immutable.Seq)new .colon.colon((Object)new StringBuilder(5).append("gzip ").append(fileName2).toString(), (List)Nil$.MODULE$), $this.LogUtil);
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(37).append("File n\u00b0 ").append(num2).append(" : ").append(fileName2).append(".gz saved. (Data from ").append(DateUtil$.MODULE$.getDate(startFile)).append(" to ").append(DateUtil$.MODULE$.getDate(endFile)).toString(), hydroCode, new StringBuilder(3).append(fileName2).append(".gz").toString());
                        $this.JobLogUtil.setFileProcessed(new File(new StringBuilder(3).append(directory$1).append(fileName2).append(".gz").toString()), jobExecutionId$1);
                    }
                    break block8;
                }
                throw new MatchError(tuple3);
            }
            catch (Throwable err) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(28).append("Error while building file : ").append(err.getMessage()).toString(), hydroCode, $this.JobLogUtil.log$default$5());
                $this.logUtil().printError(err);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$executeExportHydroportail$2(HydroportailController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        try {
            String user = (String)jobParameters.user().getOrElse((Function0 & Serializable)() -> "unknown job");
            String baseDir = StringUtil$.MODULE$.getPath((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> {
                throw new Exception("EXPORT_DIRECTORY is not in env !");
            }));
            String directory = StringUtil$.MODULE$.getPath(new StringBuilder(0).append(baseDir).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString());
            HydroportailFilter filters = (HydroportailFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new HydroportailFilter(HydroportailFilter$.MODULE$.$lessinit$greater$default$1(), HydroportailFilter$.MODULE$.$lessinit$greater$default$2(), HydroportailFilter$.MODULE$.$lessinit$greater$default$3(), HydroportailFilter$.MODULE$.$lessinit$greater$default$4(), HydroportailFilter$.MODULE$.$lessinit$greater$default$5(), HydroportailFilter$.MODULE$.$lessinit$greater$default$6(), HydroportailFilter$.MODULE$.$lessinit$greater$default$7(), HydroportailFilter$.MODULE$.$lessinit$greater$default$8(), HydroportailFilter$.MODULE$.$lessinit$greater$default$9(), HydroportailFilter$.MODULE$.$lessinit$greater$default$10(), HydroportailFilter$.MODULE$.$lessinit$greater$default$11(), HydroportailFilter$.MODULE$.$lessinit$greater$default$12()), false, HydroportailFilter$.MODULE$.format());
            scala.collection.immutable.Seq<Object> stations = $this.getSelectedStations(filters, jobExecutionId);
            scala.collection.immutable.Seq hydros = $this.HydrologicalStationDao.getAll((Option)new Some(stations.map((Function1)(JFunction1.mcDI.sp & Serializable)x$1 -> x$1)));
            scala.collection.immutable.Seq contribs = $this.ContributorsDao.getAllLight();
            Contact senderContact = (Contact)$this.ContactDao.get(filters.senderContact()).getOrElse((Function0 & Serializable)() -> {
                throw new Exception(new StringBuilder(39).append("Contact \u00e9metteur introuvable en base : ").append(filters.senderContact()).toString());
            });
            String senderContactSandre = (String)senderContact.identifier().getOrElse((Function0 & Serializable)() -> {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Le contact \u00e9metteur ne poss\u00e8de pas de code SANDRE", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Veuillez le renseigner dans la partie R\u00e9f\u00e9rentiel > Contact > Fiche du Contact > Codification > Identifiant.", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Si il n'en poss\u00e8de pas, veuillez faire la demande aupr\u00e8s de la PHyC.", "", $this.JobLogUtil.log$default$5());
                throw new Exception("Le contact \u00e9metteur ne poss\u00e8de pas de code SANDRE");
            });
            scala.collection.immutable.Seq h = filters.height().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})) : (scala.collection.immutable.Seq)Nil$.MODULE$;
            scala.collection.immutable.Seq q = filters.flow().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})) : (scala.collection.immutable.Seq)Nil$.MODULE$;
            ((IterableOnceOps)h.$plus$plus((IterableOnce)q)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)typeId -> {
                scala.collection.immutable.Seq journals = $this.HydroportailJournalDao.getAll(typeId);
                hydros.foreach((Function1 & Serializable)hydro -> {
                    HydroportailController.$anonfun$executeExportHydroportail$10($this, jobExecutionId, filters, journals, typeId, contribs, senderContactSandre, user, directory, hydro);
                    return BoxedUnit.UNIT;
                });
            });
        }
        catch (Throwable err) {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(35).append("Error during Hydroportail export : ").append(err.getMessage()).toString(), "", $this.JobLogUtil.log$default$5());
            $this.logUtil().printError(err);
        }
    }

    public static final /* synthetic */ int $anonfun$getSelectedStations$3(Tuple2 res) {
        return (int)res._2$mcJ$sp();
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$getSelectedStations$1(HydroportailController $this, int filterCode) {
        UserFilterWithLinks foundFilter = $this.userFilterDao.get("SIH", Integer.toString(filterCode));
        return (scala.collection.immutable.Seq)$this.userFilterDao.execute((String)foundFilter.filterSelection().get(), (scala.collection.immutable.Seq)foundFilter.link_parameters().getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).map((Function1 & Serializable)res -> BoxesRunTime.boxToInteger((int)HydroportailController.$anonfun$getSelectedStations$3(res)));
    }

    public static final /* synthetic */ boolean $anonfun$getExportDates$2(int hydroId$1, HydroportailJournal j) {
        return j.id() == hydroId$1;
    }

    public static final /* synthetic */ boolean $anonfun$toUTC$6(SmallMeasure m$1, StationTempRef t) {
        return !(!t.startDate().isEmpty() && ((DateTime)t.startDate().get()).withTimeAtStartOfDay().getMillis() > m$1.date().getMillis() || !t.endDate().isEmpty() && DateUtil$.MODULE$.setMaxDay((DateTime)t.endDate().get()).getMillis() < m$1.date().getMillis());
    }

    @Inject
    public HydroportailController(LogUtil LogUtil2, UserFilterDao userFilterDao, HydroportailJournalDao HydroportailJournalDao2, HydrologicalStationDao HydrologicalStationDao2, HydroChronicDao HydroChronicDao2, ContributorsDao ContributorsDao2, ContactDao ContactDao2, PointPrelDao PointPrelDao2, StationTempRefDao StationTempRefDao2, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.userFilterDao = userFilterDao;
        this.HydroportailJournalDao = HydroportailJournalDao2;
        this.HydrologicalStationDao = HydrologicalStationDao2;
        this.HydroChronicDao = HydroChronicDao2;
        this.ContributorsDao = ContributorsDao2;
        this.ContactDao = ContactDao2;
        this.PointPrelDao = PointPrelDao2;
        this.StationTempRefDao = StationTempRefDao2;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

