/*
 * Decompiled with CFR 0.152.
 */
package model.bookmark;

import dao.itf.BookmarksExportSpecificDao;
import domain.modelExport.StationModelExport;
import fr.aquasys.daeau.cms.domain.output.CmsOutput;
import fr.aquasys.daeau.cms.itf.CmsDao;
import fr.aquasys.daeau.distribution_unit.domain.DistributionUnitWithLinks;
import fr.aquasys.daeau.distribution_unit.itf.DistributionUnitDao;
import fr.aquasys.daeau.installation.domain.BoreholeWithLinks;
import fr.aquasys.daeau.installation.itf.InstallationDao;
import fr.aquasys.daeau.installation.itf.borehole.InstallationBoreholeDao;
import fr.aquasys.daeau.installation.model.Installation;
import fr.aquasys.daeau.materiel.domain.model.central.CentralSituation;
import fr.aquasys.daeau.materiel.domain.model.sensor.SensorSituation;
import fr.aquasys.daeau.materiel.domain.output.CentralOutput;
import fr.aquasys.daeau.materiel.domain.output.SensorOutput;
import fr.aquasys.daeau.materiel.itf.central.CentralTypeDao;
import fr.aquasys.daeau.materiel.itf.central.MaterielCentralDao;
import fr.aquasys.daeau.materiel.itf.central.assignment.CentralPiezometerAssignmentDao;
import fr.aquasys.daeau.materiel.itf.sensor.MaterielSensorDao;
import fr.aquasys.daeau.materiel.itf.sensor.SensorTypeDao;
import fr.aquasys.daeau.materiel.itf.sensor.assignment.SensorPiezometerAssignmentDao;
import fr.aquasys.daeau.piezometry.chartOptions.PiezometerChartOptions;
import fr.aquasys.daeau.piezometry.chartOptions.PiezometerChartOptionsDao;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent;
import fr.aquasys.daeau.piezometry.model.measure.DataTypeStatistics;
import fr.aquasys.daeau.production_unit.itf.ProductionUnitDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.referentials.aquifer.itf.AquiferDao;
import fr.aquasys.daeau.referentials.aquifer.model.Aquifer;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.contact.Contact;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.contributor.model.ContributorWithLinks;
import fr.aquasys.daeau.referentials.hydroEntity.HydroEntity;
import fr.aquasys.daeau.referentials.hydroEntity.HydroEntityDao;
import fr.aquasys.daeau.referentials.managementUnits.itf.ManagementUnitsDao;
import fr.aquasys.daeau.referentials.managementUnits.model.ManagementUnitWithLinks;
import fr.aquasys.daeau.referentials.network.dao.NetworkDao;
import fr.aquasys.daeau.referentials.network.model.Network;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.referentials.watermass.itf.WatermassDao;
import fr.aquasys.daeau.referentials.watermass.model.Watermass;
import fr.aquasys.daeau.referentials.watershed.itf.WatershedDao;
import fr.aquasys.daeau.referentials.watershed.model.Watershed;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.arrangements.Arrangement;
import fr.aquasys.daeau.station.links.casings.Casing;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink;
import fr.aquasys.daeau.station.links.geo.GeoData;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.landmark.StationLandmarkDao;
import fr.aquasys.daeau.station.links.locations.StationLocation;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.station.links.work.StationWorkLink;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.rpc.file.FileOutput;
import fr.aquasys.rpc.file.FileRPC;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.PiezometryUtils$;
import fr.aquasys.utils.ReferentialUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import model.bookmark.BookmarksEnum$;
import model.bookmark.MapOfBookmarks;
import model.bookmark.piezo.PiezoBookmarkExportDao;
import model.bookmark.piezo.PiezoChartScaleUtil$;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=g\u0001B\u0012%\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006Y!\r\u0005\t{\u0001\u0011\t\u0011)A\u0006}!A!\n\u0001B\u0001B\u0003-1\n\u0003\u0005R\u0001\t\u0005\t\u0015a\u0003S\u0011!I\u0006A!A!\u0002\u0017Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b1\u00022\t\u0011%\u0004!\u0011!Q\u0001\f)D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ya\u001d\u0005\tu\u0002\u0011\t\u0011)A\u0006w\"Q\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006Y!a\u0002\t\u0015\u0005U\u0001A!A!\u0002\u0017\t9\u0002\u0003\u0006\u0002&\u0001\u0011\t\u0011)A\u0006\u0003OA!\"a\r\u0001\u0005\u0003\u0005\u000b1BA\u001b\u0011)\t\u0019\u0005\u0001B\u0001B\u0003-\u0011Q\t\u0005\u000b\u00033\u0002!\u0011!Q\u0001\f\u0005m\u0003BCA4\u0001\t\u0005\t\u0015a\u0003\u0002j!Q\u0011q\u000f\u0001\u0003\u0002\u0003\u0006Y!!\u001f\t\u0015\u0005\u001d\u0005A!A!\u0002\u0017\tI\t\u0003\u0006\u0002\u0018\u0002\u0011\t\u0011)A\u0006\u00033C!\"a(\u0001\u0005\u0003\u0005\u000b1BAQ\u0011)\ti\u000b\u0001B\u0001B\u0003-\u0011q\u0016\u0005\u000b\u0003w\u0003!\u0011!Q\u0001\f\u0005u\u0006BCAe\u0001\t\u0005\t\u0015a\u0003\u0002L\"Q\u0011Q\u001c\u0001\u0003\u0002\u0003\u0006Y!a8\t\u0015\u0005\u0015\bA!A!\u0002\u0017\t9\u000f\u0003\u0006\u0002t\u0002\u0011\t\u0011)A\u0006\u0003kD!B!\u0001\u0001\u0005\u0003\u0005\u000b1\u0002B\u0002\u0011)\u0011I\u0001\u0001B\u0001B\u0003-!1\u0002\u0005\u000b\u0005+\u0001!\u0011!Q\u0001\f\t]\u0001B\u0003B\u000f\u0001\t\u0005\t\u0015a\u0003\u0003 !Q!1\u0006\u0001\u0003\u0002\u0003\u0006YA!\f\t\u0015\tu\u0002A!A!\u0002\u0017\u0011y\u0004C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\t%\u0006\u0001\"\u0001\u0003,\n!\u0002+[3{_\n{wn[7be.\u0014U/\u001b7eKJT!!\n\u0014\u0002\u0011\t|wn[7be.T\u0011aJ\u0001\u0006[>$W\r\\\u0002\u0001'\t\u0001!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\t\u00114(D\u00014\u0015\t!T'\u0001\u0003vi&d'B\u0001\u001c8\u0003!\u0011\u0018M\u00192ji6\f(B\u0001\u001d:\u0003\u001d\t\u0017/^1tsNT\u0011AO\u0001\u0003MJL!\u0001P\u001a\u0003\u000f1{w-\u0016;jY\u000691-\u001b;z\t\u0006|\u0007CA I\u001b\u0005\u0001%BA!C\u0003\rIGO\u001a\u0006\u0003\u0007\u0012\u000bAaY5us*\u0011QIR\u0001\re\u00164WM]3oi&\fGn\u001d\u0006\u0003\u000f^\nQ\u0001Z1fCVL!!\u0013!\u0003\u000f\rKG/\u001f#b_\u0006Q1m\u001c8uC\u000e$H)Y8\u0011\u00051{U\"A'\u000b\u00059#\u0015aB2p]R\f7\r^\u0005\u0003!6\u0013!bQ8oi\u0006\u001cG\u000fR1p\u000319\u0018\r^3sg\",G\rR1p!\t\u0019v+D\u0001U\u0015\t\tUK\u0003\u0002W\t\u0006Iq/\u0019;feNDW\rZ\u0005\u00031R\u0013AbV1uKJ\u001c\b.\u001a3EC>\f!\"Y9vS\u001a,'\u000fR1p!\tYv,D\u0001]\u0015\t\tUL\u0003\u0002_\t\u00069\u0011-];jM\u0016\u0014\u0018B\u00011]\u0005)\t\u0015/^5gKJ$\u0015m\\\u0001\ro\u0006$XM]7bgN$\u0015m\u001c\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003\u0003\u0016T!A\u001a#\u0002\u0013]\fG/\u001a:nCN\u001c\u0018B\u00015e\u000519\u0016\r^3s[\u0006\u001c8\u000fR1p\u0003)qW\r^<pe.$\u0015m\u001c\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\f1\u0001Z1p\u0015\tyG)A\u0004oKR<xN]6\n\u0005Ed'A\u0003(fi^|'o\u001b#b_\u0006y1m\u001c8ue&\u0014W\u000f^8sg\u0012\u000bw\u000e\u0005\u0002uq6\tQO\u0003\u0002Bm*\u0011q\u000fR\u0001\fG>tGO]5ckR|'/\u0003\u0002zk\ny1i\u001c8ue&\u0014W\u000f^8sg\u0012\u000bw.A\u0007tC:$'/Z\"pI\u0016$\u0015m\u001c\t\u0004y\u0006\u0005Q\"A?\u000b\u00055t(BA@E\u0003)\u0019\u0018M\u001c3sK\u000e{G-Z\u0005\u0004\u0003\u0007i(!D*b]\u0012\u0014XmQ8eK\u0012\u000bw.A\u0007qS\u0016Tx.\\3uKJ$\u0015m\u001c\t\u0005\u0003\u0013\t\t\"\u0004\u0002\u0002\f)\u0019\u0011)!\u0004\u000b\u0007\u0005=a)\u0001\u0006qS\u0016Tx.\\3uefLA!a\u0005\u0002\f\ty\u0001+[3{_6,G/\u001a:EC\u0016\fW/A\bj]N$\u0018\r\u001c7bi&|g\u000eR1p!\u0011\tI\"!\t\u000e\u0005\u0005m!bA!\u0002\u001e)\u0019\u0011q\u0004$\u0002\u0019%t7\u000f^1mY\u0006$\u0018n\u001c8\n\t\u0005\r\u00121\u0004\u0002\u0010\u0013:\u001cH/\u00197mCRLwN\u001c#b_\u00069\u0012J\\:uC2d\u0017\r^5p]\n{'/\u001a5pY\u0016$\u0015m\u001c\t\u0005\u0003S\ty#\u0004\u0002\u0002,)!\u0011QFA\u000e\u0003!\u0011wN]3i_2,\u0017\u0002BA\u0019\u0003W\u0011q#\u00138ti\u0006dG.\u0019;j_:\u0014uN]3i_2,G)Y8\u0002%5\fg.Y4f[\u0016tG/\u00168jiN$\u0015m\u001c\t\u0005\u0003o\ty$\u0004\u0002\u0002:)\u0019\u0011)a\u000f\u000b\u0007\u0005uB)A\bnC:\fw-Z7f]R,f.\u001b;t\u0013\u0011\t\t%!\u000f\u0003%5\u000bg.Y4f[\u0016tG/\u00168jiN$\u0015m\\\u0001\u000fgR\fG/[8o\u0019&t7\u000eR1p!\u0011\t9%!\u0016\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n1b\u001d;bi&|g\u000e\\5oW*!\u0011qJA)\u0003\u0015a\u0017N\\6t\u0015\r\t\u0019FR\u0001\bgR\fG/[8o\u0013\u0011\t9&!\u0013\u0003\u001dM#\u0018\r^5p]2Kgn\u001b#b_\u0006\u00112\u000b^1uS>tG*\u00198e[\u0006\u00148\u000eR1p!\u0011\ti&a\u0019\u000e\u0005\u0005}#\u0002BA1\u0003\u001b\n\u0001\u0002\\1oI6\f'o[\u0005\u0005\u0003K\nyF\u0001\nTi\u0006$\u0018n\u001c8MC:$W.\u0019:l\t\u0006|\u0017a\u00053jgR\u0014\u0018NY;uS>tWK\\5u\t\u0006|\u0007\u0003BA6\u0003gj!!!\u001c\u000b\u0007\u0005\u000byGC\u0002\u0002r\u0019\u000b\u0011\u0003Z5tiJL'-\u001e;j_:|VO\\5u\u0013\u0011\t)(!\u001c\u0003'\u0011K7\u000f\u001e:jEV$\u0018n\u001c8V]&$H)Y8\u0002#A\u0014x\u000eZ;di&|g.\u00168ji\u0012\u000bw\u000e\u0005\u0003\u0002|\u0005\rUBAA?\u0015\r\t\u0015q\u0010\u0006\u0004\u0003\u00033\u0015a\u00049s_\u0012,8\r^5p]~+h.\u001b;\n\t\u0005\u0015\u0015Q\u0010\u0002\u0012!J|G-^2uS>tWK\\5u\t\u0006|\u0017AB2ng\u0012\u000bw\u000e\u0005\u0003\u0002\f\u0006MUBAAG\u0015\r\t\u0015q\u0012\u0006\u0004\u0003#3\u0015aA2ng&!\u0011QSAG\u0005\u0019\u0019Un\u001d#b_\u0006\u0011\u0002/[3{_6,GO]=Fm\u0016tG\u000fR1p!\u0011\tI!a'\n\t\u0005u\u00151\u0002\u0002\u0013!&,'p\\7fiJLXI^3oi\u0012\u000bw.\u0001\fQS\u0016TxNQ8pW6\f'o[#ya>\u0014H\u000fR1p!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATI\u0005)\u0001/[3{_&!\u00111VAS\u0005Y\u0001\u0016.\u001a>p\u0005>|7.\\1sW\u0016C\bo\u001c:u\t\u0006|\u0017A\u00045zIJ|WI\u001c;jif$\u0015m\u001c\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*\u0019\u0011Q\u0017#\u0002\u0017!LHM]8F]RLG/_\u0005\u0005\u0003s\u000b\u0019L\u0001\bIs\u0012\u0014x.\u00128uSRLH)Y8\u00023AKWM_8nKR,'o\u00115beR|\u0005\u000f^5p]N$\u0015m\u001c\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YA\u0007\u00031\u0019\u0007.\u0019:u\u001fB$\u0018n\u001c8t\u0013\u0011\t9-!1\u00033AKWM_8nKR,'o\u00115beR|\u0005\u000f^5p]N$\u0015m\\\u0001\u000bG\u0016tGO]1m\t\u0006|\u0007\u0003BAg\u00033l!!a4\u000b\t\u0005E\u00171[\u0001\bG\u0016tGO]1m\u0015\r\t\u0015Q\u001b\u0006\u0004\u0003/4\u0015\u0001C7bi\u0016\u0014\u0018.\u001a7\n\t\u0005m\u0017q\u001a\u0002\u0013\u001b\u0006$XM]5fY\u000e+g\u000e\u001e:bY\u0012\u000bw.\u0001\bDK:$(/\u00197UsB,G)Y8\u0011\t\u00055\u0017\u0011]\u0005\u0005\u0003G\fyM\u0001\bDK:$(/\u00197UsB,G)Y8\u0002\u001bM+gn]8s)f\u0004X\rR1p!\u0011\tI/a<\u000e\u0005\u0005-(\u0002BAw\u0003'\faa]3og>\u0014\u0018\u0002BAy\u0003W\u0014QbU3og>\u0014H+\u001f9f\t\u0006|\u0017AH2f]R\u0014\u0018\r\u001c)jKj|W.\u001a;fe\u0006\u001b8/[4o[\u0016tG\u000fR1p!\u0011\t90!@\u000e\u0005\u0005e(\u0002BA~\u0003\u001f\f!\"Y:tS\u001etW.\u001a8u\u0013\u0011\ty0!?\u0003=\r+g\u000e\u001e:bYBKWM_8nKR,'/Q:tS\u001etW.\u001a8u\t\u0006|\u0017!C:f]N|'\u000fR1p!\u0011\tIO!\u0002\n\t\t\u001d\u00111\u001e\u0002\u0012\u001b\u0006$XM]5fYN+gn]8s\t\u0006|\u0017!H:f]N|'\u000fU5fu>lW\r^3s\u0003N\u001c\u0018n\u001a8nK:$H)Y8\u0011\t\t5!\u0011C\u0007\u0003\u0005\u001fQA!a?\u0002l&!!1\u0003B\b\u0005u\u0019VM\\:peBKWM_8nKR,'/Q:tS\u001etW.\u001a8u\t\u0006|\u0017\u0001\u0006)jKj|W.\u001a;fe6+\u0017m];sK\u0012\u000bw\u000e\u0005\u0003\u0002\n\te\u0011\u0002\u0002B\u000e\u0003\u0017\u0011A\u0003U5fu>lW\r^3s\u001b\u0016\f7/\u001e:f\t\u0006|\u0017A\u0007\"p_.l\u0017M]6t\u000bb\u0004xN\u001d;Ta\u0016\u001c\u0017NZ5d\t\u0006|\u0007\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\u0007\u0005\u0013)CC\u0001n\u0013\u0011\u0011ICa\t\u00035\t{wn[7be.\u001cX\t\u001f9peR\u001c\u0006/Z2jM&\u001cG)Y8\u0002\u000f\u0019KG.\u001a*Q\u0007B!!q\u0006B\u001d\u001b\t\u0011\tD\u0003\u0003\u00034\tU\u0012\u0001\u00024jY\u0016T1Aa\u000e8\u0003\r\u0011\boY\u0005\u0005\u0005w\u0011\tDA\u0004GS2,'\u000bU\"\u0002\u001fE,\u0018\r\\5u_6,G/\u001a:EC>\u0004BA!\u0011\u0003J5\u0011!1\t\u0006\u0004\u0003\n\u0015#b\u0001B$\r\u00069\u0011/^1mSRL\u0018\u0002\u0002B&\u0005\u0007\u0012q\"U;bY&$x.\\3uKJ$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\tECC\u0011B*\u0005/\u0012IFa\u0017\u0003^\t}#\u0011\rB2\u0005K\u00129G!\u001b\u0003l\t5$q\u000eB9\u0005g\u0012)Ha\u001e\u0003z\tm$Q\u0010B@\u0005\u0003\u0013\u0019I!\"\u0003\b\n%%1\u0012BG\u0005\u001f\u0013\tJa%\u0003\u0016B\u0019!Q\u000b\u0001\u000e\u0003\u0011BQ\u0001M\u0011A\u0004EBQ!P\u0011A\u0004yBQAS\u0011A\u0004-CQ!U\u0011A\u0004ICQ!W\u0011A\u0004iCQ!Y\u0011A\u0004\tDQ![\u0011A\u0004)DQA]\u0011A\u0004MDQA_\u0011A\u0004mDq!!\u0002\"\u0001\b\t9\u0001C\u0004\u0002\u0016\u0005\u0002\u001d!a\u0006\t\u000f\u0005\u0015\u0012\u0005q\u0001\u0002(!9\u00111G\u0011A\u0004\u0005U\u0002bBA\"C\u0001\u000f\u0011Q\t\u0005\b\u00033\n\u00039AA.\u0011\u001d\t9'\ta\u0002\u0003SBq!a\u001e\"\u0001\b\tI\bC\u0004\u0002\b\u0006\u0002\u001d!!#\t\u000f\u0005]\u0015\u0005q\u0001\u0002\u001a\"9\u0011qT\u0011A\u0004\u0005\u0005\u0006bBAWC\u0001\u000f\u0011q\u0016\u0005\b\u0003w\u000b\u00039AA_\u0011\u001d\tI-\ta\u0002\u0003\u0017Dq!!8\"\u0001\b\ty\u000eC\u0004\u0002f\u0006\u0002\u001d!a:\t\u000f\u0005M\u0018\u0005q\u0001\u0002v\"9!\u0011A\u0011A\u0004\t\r\u0001b\u0002B\u0005C\u0001\u000f!1\u0002\u0005\b\u0005+\t\u00039\u0001B\f\u0011\u001d\u0011i\"\ta\u0002\u0005?AqAa\u000b\"\u0001\b\u0011i\u0003C\u0004\u0003>\u0005\u0002\u001dAa\u0010)\u0007\u0005\u0012I\n\u0005\u0003\u0003\u001c\n\u0015VB\u0001BO\u0015\u0011\u0011yJ!)\u0002\r%t'.Z2u\u0015\t\u0011\u0019+A\u0003kCZ\f\u00070\u0003\u0003\u0003(\nu%AB%oU\u0016\u001cG/\u0001\u0006hKRl\u0015M]6feN$bA!,\u00034\nu\u0006cA\u0016\u00030&\u0019!\u0011\u0017\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005k\u0013\u0003\u0019\u0001B\\\u0003\u0005i\u0007\u0003\u0002B+\u0005sK1Aa/%\u00059i\u0015\r](g\u0005>|7.\\1sWNDq!a\u0015#\u0001\u0004\u0011y\f\u0005\u0003\u0003B\n-WB\u0001Bb\u0015\u0011\u0011)Ma2\u0002\u00175|G-\u001a7FqB|'\u000f\u001e\u0006\u0003\u0005\u0013\fa\u0001Z8nC&t\u0017\u0002\u0002Bg\u0005\u0007\u0014!c\u0015;bi&|g.T8eK2,\u0005\u0010]8si\u0002")
public class PiezoBookmarkBuilder {
    private final CityDao cityDao;
    private final ContactDao contactDao;
    private final WatershedDao watershedDao;
    private final AquiferDao aquiferDao;
    private final WatermassDao watermassDao;
    private final NetworkDao networkDao;
    private final ContributorsDao contributorsDao;
    private final SandreCodeDao sandreCodeDao;
    private final PiezometerDaeau piezometerDao;
    private final InstallationDao installationDao;
    private final InstallationBoreholeDao InstallationBoreholeDao;
    private final ManagementUnitsDao managementUnitsDao;
    private final StationLinkDao stationLinkDao;
    private final DistributionUnitDao distributionUnitDao;
    private final CmsDao cmsDao;
    private final PiezometryEventDao piezometryEventDao;
    private final PiezoBookmarkExportDao PiezoBookmarkExportDao;
    private final HydroEntityDao hydroEntityDao;
    private final PiezometerChartOptionsDao PiezometerChartOptionsDao;
    private final MaterielCentralDao centralDao;
    private final CentralTypeDao CentralTypeDao;
    private final SensorTypeDao SensorTypeDao;
    private final CentralPiezometerAssignmentDao centralPiezometerAssignmentDao;
    private final MaterielSensorDao sensorDao;
    private final SensorPiezometerAssignmentDao sensorPiezometerAssignmentDao;
    private final PiezometerMeasureDao PiezometerMeasureDao;
    private final BookmarksExportSpecificDao BookmarksExportSpecificDao;
    private final FileRPC FileRPC;
    private final QualitometerDao qualitometerDao;

    public void getMarkers(MapOfBookmarks m, StationModelExport station) {
        Option option;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
        String dtfFormat = "dd/MM/YYYY";
        String htfFormat = "dd/MM/YYYY HH:mm:ss";
        Seq sandreCodes = this.sandreCodeDao.getAll();
        PiezometerWithLinks piezo = (PiezometerWithLinks)this.piezometerDao.getWithLinks((int)station.id()).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(25).append("Can't find piezo with id ").append(station.id()).toString());
        });
        Seq eventList = this.piezometryEventDao.getEvents((int)station.id());
        Seq linkedStations = this.stationLinkDao.get(station.code(), (long)StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.PIEZOMETRY()));
        Seq pictures = this.FileRPC.getStationPictures(station.code());
        if (pictures.nonEmpty()) {
            Seq picturesFormated = (Seq)((IterableOps)pictures.distinct()).map((Function1 & Serializable)pic -> {
                String[] splitted = (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(pic.name()), '_')), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$1), '.'), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
                return new Tuple2(pic, (Object)splitted);
            });
            this.sandreCodeDao.getSandreList("TYPE_PHOTO").foreach((Function1 & Serializable)picType -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$5(picturesFormated, m, picType);
                return BoxedUnit.UNIT;
            });
        }
        m.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.CODE_PIEZO(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.CODE_QUALITO(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.CODE_STATION(), (List)Nil$.MODULE$))), (Object)piezo.id());
        m.add(BookmarksEnum$.MODULE$.CODE_BSS(), (Object)piezo.code());
        m.add(BookmarksEnum$.MODULE$.CODE_INTER(), station.internQualitoCode());
        m.add(BookmarksEnum$.MODULE$.C_PAYS(), (Object)piezo.countryCode());
        m.add(BookmarksEnum$.MODULE$.DESIGNATION(), (Object)piezo.designation());
        m.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.NOM_PIEZO(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.NOM_QUALITO(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.NOM_STATION(), (List)Nil$.MODULE$))), (Object)piezo.name());
        piezo.nature().foreach((Function1)(JFunction1.mcVI.sp & Serializable)n -> {
            m.add(BookmarksEnum$.MODULE$.C_NATURE(), (Object)BoxesRunTime.boxToInteger((int)n));
            m.add(BookmarksEnum$.MODULE$.NATURE_OUVRAGE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.CODENATURE", (long)n, sandreCodes));
        });
        piezo.stateCode().foreach((Function1)(JFunction1.mcVD.sp & Serializable)s -> {
            m.add(BookmarksEnum$.MODULE$.CODE_ETAT(), (Object)BoxesRunTime.boxToDouble((double)s));
            m.add(BookmarksEnum$.MODULE$.LIB_ETAT(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.CODEETAT", (long)s, sandreCodes));
        });
        m.addDate(BookmarksEnum$.MODULE$.DATE_CREATION(), (Option<DateTime>)piezo.creation());
        m.addDate(BookmarksEnum$.MODULE$.DATE_FERMETURE(), (Option<DateTime>)piezo.close());
        m.add(BookmarksEnum$.MODULE$.COORDONNEE_X(), (Object)piezo.x().map((Function1 & Serializable)x$3 -> PiezoBookmarkBuilder.$anonfun$getMarkers$13(BoxesRunTime.unboxToDouble((Object)x$3))));
        m.add(BookmarksEnum$.MODULE$.COORDONNEE_Y(), (Object)piezo.y().map((Function1 & Serializable)x$4 -> PiezoBookmarkBuilder.$anonfun$getMarkers$14(BoxesRunTime.unboxToDouble((Object)x$4))));
        piezo.projection().foreach((Function1)(JFunction1.mcVI.sp & Serializable)proj -> {
            m.add(BookmarksEnum$.MODULE$.C_PROJECTION(), (Object)BoxesRunTime.boxToInteger((int)proj));
            m.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.TYPE_PROJECTION(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.PROJECTION(), (List)Nil$.MODULE$)), (Object)ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.TYPEPROJECTION", (long)proj, sandreCodes));
        });
        m.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.COMMENTAIRE(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.COMMENTAIRE_PIEZO(), (List)Nil$.MODULE$)), (Object)piezo.comment());
        this.qualitometerDao.get(station.code()).foreach((Function1 & Serializable)qualito -> {
            m.add(BookmarksEnum$.MODULE$.COMMENTAIRE_QUALITO(), (Object)qualito.comment());
            return BoxedUnit.UNIT;
        });
        m.add(BookmarksEnum$.MODULE$.ADRESSE(), (Object)piezo.address());
        m.add(BookmarksEnum$.MODULE$.LOCALISATION(), (Object)piezo.localization());
        piezo.townCode().foreach((Function1 & Serializable)city -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$17(this, m, city);
            return BoxedUnit.UNIT;
        });
        piezo.cote().foreach((Function1)(JFunction1.mcVI.sp & Serializable)cote -> {
            m.add(BookmarksEnum$.MODULE$.C_EXP_COTE(), (Object)BoxesRunTime.boxToInteger((int)cote));
            m.add(BookmarksEnum$.MODULE$.EXPRESSION_COTE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.EXPRESSIONCOTE", (long)cote, sandreCodes));
        });
        piezo.fieldMode().foreach((Function1)(JFunction1.mcVI.sp & Serializable)fieldMode -> {
            m.add(BookmarksEnum$.MODULE$.C_MODE_GIST(), (Object)BoxesRunTime.boxToInteger((int)fieldMode));
            m.add(BookmarksEnum$.MODULE$.MODE_GISEMENT(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.MODEGISEMENT", (long)fieldMode, sandreCodes));
        });
        (piezo.contactCode().isDefined() ? piezo.contactCode() : piezo.link_contacts().flatMap((Function1 & Serializable)x$5 -> x$5.headOption()).flatMap((Function1 & Serializable)x$6 -> x$6.contactCode())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)cId -> {
            m.add(BookmarksEnum$.MODULE$.C_CONTACT(), (Object)BoxesRunTime.boxToInteger((int)cId));
            $this.contactDao.get(cId).foreach((Function1 & Serializable)contact -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$24(this, m, contact);
                return BoxedUnit.UNIT;
            });
        });
        piezo.watershedCode().flatMap((Function1 & Serializable)w -> this.watershedDao.get(BoxesRunTime.unboxToDouble((Object)w))).foreach((Function1 & Serializable)watershed -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$33(m, watershed);
            return BoxedUnit.UNIT;
        });
        if (piezo.projection().isDefined() && piezo.x().isDefined() && piezo.y().isDefined()) {
            m.add(new StringBuilder(1).append(BookmarksEnum$.MODULE$.COORDONNEE_X().toString()).append("_").append(piezo.projection().get()).toString(), (Object)piezo.x().get().toString());
            m.add(new StringBuilder(1).append(BookmarksEnum$.MODULE$.COORDONNEE_Y().toString()).append("_").append(piezo.projection().get()).toString(), (Object)piezo.y().get().toString());
        }
        ((IterableOnceOps)piezo.link_locations().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)loc -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$35(m, loc);
            return BoxedUnit.UNIT;
        });
        if (eventList.nonEmpty()) {
            eventList.foreach((Function1 & Serializable)c -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$36(dtfFormat, m, c);
                return BoxedUnit.UNIT;
            });
        }
        piezo.link_hydroEntity().flatMap((Function1 & Serializable)l -> l.headOption().flatMap((Function1 & Serializable)e -> e.hydrologicalEntity())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)entity -> {
            m.add(BookmarksEnum$.MODULE$.C_CODE_HYDRO(), (Object)BoxesRunTime.boxToInteger((int)entity));
            $this.hydroEntityDao.get(entity).foreach((Function1 & Serializable)he -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$45(m, he);
                return BoxedUnit.UNIT;
            });
        });
        piezo.link_aquifers().flatMap((Function1 & Serializable)links -> links.headOption().flatMap((Function1 & Serializable)a -> a.aquiferCode())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)aquiferCode -> {
            m.add(BookmarksEnum$.MODULE$.C_AQUIFERE(), (Object)BoxesRunTime.boxToInteger((int)aquiferCode));
            $this.aquiferDao.getAquifer(Integer.toString(aquiferCode)).foreach((Function1 & Serializable)aq -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$49(m, aq);
                return BoxedUnit.UNIT;
            });
        });
        piezo.link_lithology().flatMap((Function1 & Serializable)l -> l.headOption().flatMap((Function1 & Serializable)lit -> lit.lithologyCode())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)l -> m.add(BookmarksEnum$.MODULE$.LITHOLOGIE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("LITHOLOGIE.CODE_LITHOLOGIE", (long)l, sandreCodes)));
        piezo.link_watermasses().flatMap((Function1 & Serializable)wat -> wat.headOption().map((Function1 & Serializable)w -> w.watermassCode())).foreach((Function1 & Serializable)w -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$55(this, m, w);
            return BoxedUnit.UNIT;
        });
        piezo.link_networks().foreach((Function1 & Serializable)networkLinks -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$57(this, m, networkLinks);
            return BoxedUnit.UNIT;
        });
        piezo.link_contributors().foreach((Function1 & Serializable)link_contribs -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$72(this, sandreCodes, m, link_contribs);
            return BoxedUnit.UNIT;
        });
        piezo.link_work().flatMap((Function1 & Serializable)x$12 -> x$12.headOption()).foreach((Function1 & Serializable)work -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$100(m, work);
            return BoxedUnit.UNIT;
        });
        Option installation = linkedStations.find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$101(x$13))).flatMap((Function1 & Serializable)link -> $this.installationDao.get(link.stationLinkedId()));
        BooleanRef hasCrepines = BooleanRef.create((boolean)false);
        installation.foreach((Function1 & Serializable)i -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$103(this, m, hasCrepines, i);
            return BoxedUnit.UNIT;
        });
        if (!hasCrepines.elem) {
            ((IterableOps)piezo.link_casings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).headOption().foreach((Function1 & Serializable)c -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$119(this, m, c);
                return BoxedUnit.UNIT;
            });
            ((IterableOps)piezo.link_casings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).lastOption().foreach((Function1 & Serializable)c -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$123(this, m, c);
                return BoxedUnit.UNIT;
            });
        }
        piezo.link_measureMethod().flatMap((Function1 & Serializable)x$15 -> x$15.headOption()).foreach((Function1 & Serializable)measureMethod -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$127(m, sandreCodes, piezo, measureMethod);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)piezo.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)landmark -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$153(piezo, m, sandreCodes, formatter, landmark);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)((SeqOps)piezo.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$165(x$26)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)lastLandmark -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$168(m, piezo, sandreCodes, formatter, lastLandmark);
            return BoxedUnit.UNIT;
        });
        Option option2 = ((IterableOps)((SeqOps)piezo.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$28 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$171(x$28)), (Ordering)Ordering.Long$.MODULE$)).lastOption().flatMap((Function1 & Serializable)x$30 -> x$30.altitude());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            double alt2 = BoxesRunTime.unboxToDouble((Object)some.value());
            m.add(BookmarksEnum$.MODULE$.COORDONNEE_Z(), (Object)BoxesRunTime.boxToDouble((double)alt2));
        } else {
            ((IterableOnceOps)piezo.link_locations().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$176(x$31))).flatMap((Function1 & Serializable)x$32 -> x$32.z()).foreach((Function1)(JFunction1.mcVD.sp & Serializable)z -> m.add(BookmarksEnum$.MODULE$.COORDONNEE_Z(), (Object)BoxesRunTime.boxToDouble((double)z)));
        }
        Seq allCms = (Seq)this.cmsDao.getAll().sortBy((Function1 & Serializable)x$33 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$179(x$33)), (Ordering)Ordering.Long$.MODULE$);
        allCms.lastOption().foreach((Function1 & Serializable)cms -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$182(m, cms);
            return BoxedUnit.UNIT;
        });
        allCms.foreach((Function1 & Serializable)cms -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$183(m, cms);
            return BoxedUnit.UNIT;
        });
        Option scale = this.PiezometerChartOptionsDao.getOptions((String)piezo.code().get()).find((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$184(x$35)));
        if (scale.isEmpty() || ((PiezometerChartOptions)scale.get()).minYear().isEmpty() || ((PiezometerChartOptions)scale.get()).maxYear().isEmpty()) {
            Option<Tuple2<Object, Object>> res = this.PiezoBookmarkExportDao.getMinMaxHisto(BoxesRunTime.unboxToInt((Object)piezo.id().get()));
            option = res.map((Function1 & Serializable)x0$15 -> {
                Tuple2 tuple2 = x0$15;
                if (tuple2 != null) {
                    double min = tuple2._1$mcD$sp();
                    double max = tuple2._2$mcD$sp();
                    return PiezoChartScaleUtil$.MODULE$.getYAutoScale((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{min, max}))));
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            option = None$.MODULE$;
        }
        Option minMax = option;
        Option min = scale.flatMap((Function1 & Serializable)x$36 -> x$36.minYear()).orElse((Function0 & Serializable)() -> minMax.map((Function1 & Serializable)x0$16 -> BoxesRunTime.boxToDouble((double)PiezoBookmarkBuilder.$anonfun$getMarkers$188(x0$16))));
        Option max = scale.flatMap((Function1 & Serializable)x$37 -> x$37.maxYear()).orElse((Function0 & Serializable)() -> minMax.map((Function1 & Serializable)x0$17 -> BoxesRunTime.boxToDouble((double)PiezoBookmarkBuilder.$anonfun$getMarkers$191(x0$17))));
        min.foreach((Function1)(JFunction1.mcVD.sp & Serializable)s -> {
            m.add(BookmarksEnum$.MODULE$.PZ_MIN_ANNEE(), (Object)BoxesRunTime.boxToDouble((double)s));
            m.add(BookmarksEnum$.MODULE$.PZ_MIN_HISTO(), (Object)BoxesRunTime.boxToDouble((double)s));
        });
        max.foreach((Function1)(JFunction1.mcVD.sp & Serializable)s -> {
            m.add(BookmarksEnum$.MODULE$.PZ_MAX_ANNEE(), (Object)BoxesRunTime.boxToDouble((double)s));
            m.add(BookmarksEnum$.MODULE$.PZ_MAX_HISTO(), (Object)BoxesRunTime.boxToDouble((double)s));
        });
        ((IterableOps)((SeqOps)piezo.link_accessibilities().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$38 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$195(x$38)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)access -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$198(m, sandreCodes, access);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)((SeqOps)piezo.link_arrangements().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$40 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$201(x$40)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)arrangement -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$204(this, m, sandreCodes, arrangement);
            return BoxedUnit.UNIT;
        });
        Option udiFromLinks = linkedStations.find((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$208(x$42))).flatMap((Function1 & Serializable)link -> $this.distributionUnitDao.get((int)link.stationLinkedId()));
        Option udi = udiFromLinks.isDefined() ? udiFromLinks : installation.flatMap((Function1 & Serializable)i -> $this.stationLinkDao.get((String)i.code().getOrElse((Function0 & Serializable)() -> ""), (long)StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.INSTALLATION())).find((Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$212(x$43)))).flatMap((Function1 & Serializable)udiLink -> $this.distributionUnitDao.get((int)udiLink.stationLinkedId()));
        udi.foreach((Function1 & Serializable)u -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$214(m, u);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)((SeqOps)piezo.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$44 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$216(x$44)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)alt -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$219(m, sandreCodes, alt);
            return BoxedUnit.UNIT;
        });
        Option ass2 = ((IterableOps)((SeqOps)this.centralPiezometerAssignmentDao.getPiezometerAssignements(BoxesRunTime.unboxToInt((Object)piezo.id().get())).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$221(s)))).sortBy((Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$222(s)), (Ordering)Ordering.Long$.MODULE$)).lastOption();
        ass2.flatMap((Function1 & Serializable)ass -> ass.idCentral()).flatMap((Function1 & Serializable)idCentral -> this.centralDao.getCentral(BoxesRunTime.unboxToInt((Object)idCentral))).foreach((Function1 & Serializable)central -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$226(this, m, ass2, central);
            return BoxedUnit.UNIT;
        });
        Option ass22 = ((IterableOps)((SeqOps)this.sensorPiezometerAssignmentDao.getPiezometerAssignements(BoxesRunTime.unboxToInt((Object)piezo.id().get())).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$231(s)))).sortBy((Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$232(s)), (Ordering)Ordering.Long$.MODULE$)).lastOption();
        ass22.flatMap((Function1 & Serializable)ass -> $this.sensorDao.getSensor(ass.idSensor())).foreach((Function1 & Serializable)sensor -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$235(this, m, ass22, sensor);
            return BoxedUnit.UNIT;
        });
        piezo.link_geo().flatMap((Function1 & Serializable)x$46 -> x$46.headOption()).foreach((Function1 & Serializable)geo -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$241(m, geo);
            return BoxedUnit.UNIT;
        });
        piezo.link_usages().flatMap((Function1 & Serializable)x$47 -> ((IterableOps)x$47.sortBy((Function1 & Serializable)x$48 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$243(x$48)), (Ordering)Ordering.Long$.MODULE$)).lastOption()).foreach((Function1 & Serializable)usage -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$246(m, sandreCodes, usage);
            return BoxedUnit.UNIT;
        });
        this.PiezometerMeasureDao.getPiezometerMeasureStats(BoxesRunTime.unboxToInt((Object)piezo.id().get())).find((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$248(x$50))).foreach((Function1 & Serializable)stats -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$249(m, stats);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getMarkers$6(SandreCode picType$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String[] attributes = (String[])tuple2._2();
        Option option = (Option)Predef$.MODULE$.wrapRefArray((Object[])attributes).lift().apply((Object)BoxesRunTime.boxToInteger((int)1));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        String t = (String)some.value();
        String string = ((String)picType$1.mnemonique().getOrElse((Function0 & Serializable)() -> picType$1.name())).toUpperCase();
        String string2 = t.toUpperCase();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = picType$1.name().toUpperCase();
        String string4 = t.toUpperCase();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ long $anonfun$getMarkers$9(Tuple2 x$2) {
        return ((FileOutput)x$2._1()).updateDate();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$10(SandreCode picType$1, MapOfBookmarks m$1, Tuple2 pic) {
        Predef$.MODULE$.println((Object)new StringBuilder(15).append(" add key PHOTO_").append(picType$1.code()).toString());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(6).append("PHOTO_").append(picType$1.code()).toString(), (List)new .colon.colon((Object)new StringBuilder(6).append("PHOTO_").append(picType$1.name().toUpperCase()).toString(), (List)Nil$.MODULE$)), ((FileOutput)pic._1()).url().replace(" ", "%20"));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$5(Seq picturesFormated$1, MapOfBookmarks m$1, SandreCode picType) {
        Seq picturesWithType = (Seq)picturesFormated$1.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$6(picType, x0$1)));
        ((IterableOps)((SeqOps)picturesWithType.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])p._2()), (Object)"1")))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$9(x$2)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)pic -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$10(picType, m$1, pic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$getMarkers$13(double x$3) {
        return Double.toString(x$3);
    }

    public static final /* synthetic */ String $anonfun$getMarkers$14(double x$4) {
        return Double.toString(x$4);
    }

    public static final /* synthetic */ void $anonfun$getMarkers$17(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, String city) {
        m$1.add(BookmarksEnum$.MODULE$.C_COMMUNE(), (Object)city);
        m$1.add(BookmarksEnum$.MODULE$.DEPARTEMENT(), (Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(city), 2));
        $this.cityDao.get(city).foreach((Function1 & Serializable)c -> {
            m$1.add(BookmarksEnum$.MODULE$.COMMUNE(), (Object)c.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$24(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Contact contact) {
        m$1.add(BookmarksEnum$.MODULE$.NOM_CONTACT(), (Object)contact.name());
        m$1.add(BookmarksEnum$.MODULE$.COMMENT_CONTACT(), (Object)contact.comment());
        m$1.add(BookmarksEnum$.MODULE$.ADRESSE_CONTACT(), (Object)contact.address());
        m$1.add(BookmarksEnum$.MODULE$.TEL_CONTACT(), (Object)contact.phoneTel().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.add(BookmarksEnum$.MODULE$.TEL2_CONTACT(), (Object)contact.phoneTelSecond().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.add(BookmarksEnum$.MODULE$.BUREAU_CONTACT(), (Object)contact.desktopTel().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.add(BookmarksEnum$.MODULE$.PORTABLE_CONTACT(), (Object)contact.mobile().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.add(BookmarksEnum$.MODULE$.FAX_CONTACT(), (Object)contact.fax().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.add(BookmarksEnum$.MODULE$.EMAIL_CONTACT(), (Object)contact.email());
        m$1.add(BookmarksEnum$.MODULE$.CP_CONTACT(), (Object)contact.postalBox());
        contact.cityCode().flatMap((Function1 & Serializable)cityCode -> $this.cityDao.get(cityCode)).foreach((Function1 & Serializable)c -> {
            m$1.add(BookmarksEnum$.MODULE$.VILLE_CONTACT(), (Object)c.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$33(MapOfBookmarks m$1, Watershed watershed) {
        m$1.add(BookmarksEnum$.MODULE$.C_BASSIN_VERSANT(), (Object)watershed.code());
        m$1.add(BookmarksEnum$.MODULE$.L_BASSIN_VERSANT(), (Object)watershed.name());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$35(MapOfBookmarks m$1, StationLocation loc) {
        Tuple3 tuple3 = new Tuple3((Object)loc.projection(), (Object)loc.x(), (Object)loc.y());
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                double proj = BoxesRunTime.unboxToDouble((Object)some.value());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    double x = BoxesRunTime.unboxToDouble((Object)some2.value());
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        double y = BoxesRunTime.unboxToDouble((Object)some3.value());
                        m$1.add(new StringBuilder(0).append(BookmarksEnum$.MODULE$.COORDONNEE_X_().toString()).append(Integer.toString((int)proj)).toString(), (Object)Double.toString(x));
                        m$1.add(new StringBuilder(0).append(BookmarksEnum$.MODULE$.COORDONNEE_Y_().toString()).append(Integer.toString((int)proj)).toString(), (Object)Double.toString(y));
                        return;
                    }
                }
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$getMarkers$36(String dtfFormat$1, MapOfBookmarks m$1, PiezometryEvent c) {
        String eventDate = (String)DateUtil$.MODULE$.getFullDate(c.date(), c.eventHour()).map((Function1 & Serializable)x$7 -> x$7.toString(dtfFormat$1)).getOrElse((Function0 & Serializable)() -> "");
        String eventInfos = new StringBuilder(3).append(c.eventType().map((Function1 & Serializable)t -> new StringBuilder(3).append("[").append((String)t).append("] ").toString()).getOrElse((Function0 & Serializable)() -> "")).append(eventDate).append(" - ").append(c.comment().getOrElse((Function0 & Serializable)() -> "")).toString();
        m$1.concat(BookmarksEnum$.MODULE$.EVENEMENTS(), eventInfos);
    }

    public static final /* synthetic */ void $anonfun$getMarkers$45(MapOfBookmarks m$1, HydroEntity he) {
        m$1.add(BookmarksEnum$.MODULE$.ENTITE_HYDRO(), (Object)he.name());
        m$1.add(BookmarksEnum$.MODULE$.CODE_HYDRO(), (Object)he.sandreCode());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$49(MapOfBookmarks m$1, Aquifer aq) {
        m$1.add(BookmarksEnum$.MODULE$.COMMENT_AQUIFERE(), (Object)aq.comment());
        m$1.add(BookmarksEnum$.MODULE$.AQUIFERE(), (Object)aq.name());
        m$1.add(BookmarksEnum$.MODULE$.C_MARGAT_AQUIFERE(), (Object)aq.margatCode());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$56(MapOfBookmarks m$1, Watermass watermass) {
        m$1.add(BookmarksEnum$.MODULE$.LIBELLE_MASSE_EAU(), (Object)watermass.label());
        m$1.add(BookmarksEnum$.MODULE$.CODE_MASSE_EAU_EU(), (Object)watermass.europeanCode());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$55(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, String w) {
        m$1.add(BookmarksEnum$.MODULE$.CODE_MASSE_EAU(), (Object)w);
        $this.watermassDao.get(w).foreach((Function1 & Serializable)watermass -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$56(m$1, watermass);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$getMarkers$60(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            StationNetwork n = (StationNetwork)tuple2._1();
            return BoxesRunTime.unboxToLong((Object)n.startDate().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$getMarkers$63(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Network n = (Network)tuple2._2();
            return n.code();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String printNet$1(Network n) {
        if (n.mnemonic().isDefined()) {
            return (String)n.mnemonic().get();
        }
        return (String)n.name().getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$68(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            StationNetwork link = (StationNetwork)tuple2._1();
            return link.endDate().isEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$70(Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            Network n = (Network)tuple2._2();
            return n.dce().isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)n.dce().get()));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getMarkers$57(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Seq networkLinks) {
        Seq networks = (Seq)networkLinks.flatMap((Function1 & Serializable)n -> $this.networkDao.getByIds(Option$.MODULE$.option2Iterable(n.idNetwork()).toSeq()).headOption().map((Function1 & Serializable)netFound -> new Tuple2(n, netFound)));
        if (networks.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)networks.maxBy((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$60(x0$2)), (Ordering)Ordering.Long$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Network lastNetwork = (Network)tuple2._2();
            Network lastNetwork2 = lastNetwork;
            m$1.add(BookmarksEnum$.MODULE$.C_RESEAU(), (Object)BoxesRunTime.boxToInteger((int)lastNetwork2.code()));
            m$1.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.L_RESEAU(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.RESEAU(), (List)Nil$.MODULE$)), (Object)lastNetwork2.name());
            m$1.add(BookmarksEnum$.MODULE$.M_RESEAU(), (Object)lastNetwork2.mnemonic());
            m$1.add(BookmarksEnum$.MODULE$.C_RESEAUX(), (Object)((IterableOnceOps)networks.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)PiezoBookmarkBuilder.$anonfun$getMarkers$63(x0$3)))).mkString(",\n\r"));
            m$1.add(BookmarksEnum$.MODULE$.L_RESEAUX(), (Object)((IterableOnceOps)networks.flatMap((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    Network n = (Network)tuple2._2();
                    return n.name();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n\r"));
            m$1.add(BookmarksEnum$.MODULE$.M_RESEAUX(), (Object)((IterableOnceOps)networks.flatMap((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    Network n = (Network)tuple2._2();
                    return n.mnemonic();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n\r"));
            m$1.add(BookmarksEnum$.MODULE$.COM_RESEAUX(), (Object)((IterableOnceOps)networks.flatMap((Function1 & Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 != null) {
                    Network n = (Network)tuple2._2();
                    return n.comment();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n\r"));
            Tuple2 tuple22 = networks.partition((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$68(x0$7)));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Seq actives = (Seq)tuple22._1();
            Seq ended = (Seq)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)actives, (Object)ended);
            Seq actives2 = (Seq)tuple23._1();
            Seq ended2 = (Seq)tuple23._2();
            if (actives2.nonEmpty()) {
                m$1.add(BookmarksEnum$.MODULE$.LISTE_RESEAUX(), (Object)((IterableOnceOps)actives2.map((Function1 & Serializable)x0$8 -> {
                    Tuple2 tuple2 = x0$8;
                    if (tuple2 != null) {
                        Network n = (Network)tuple2._2();
                        return PiezoBookmarkBuilder.printNet$1(n);
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(",\n\r"));
                if (actives2.exists((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$70(x0$9)))) {
                    m$1.add(BookmarksEnum$.MODULE$.DCE(), (Object)"X");
                }
            }
            if (ended2.nonEmpty()) {
                m$1.add(BookmarksEnum$.MODULE$.HISTO_RESEAUX(), (Object)((IterableOnceOps)ended2.map((Function1 & Serializable)x0$10 -> {
                    Tuple2 tuple2 = x0$10;
                    if (tuple2 != null) {
                        Network n = (Network)tuple2._2();
                        return PiezoBookmarkBuilder.printNet$1(n);
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(",\n\r"));
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$73(StationContributorLink l) {
        return l.contributorType().isDefined() && (l.endDate().isEmpty() || ((BaseDateTime)l.endDate().get()).getMillis() > new DateTime().getMillis());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$80(MapOfBookmarks m$1, String key$1, int cType$1, StationContributorLink link$2, ContributorWithLinks contrib) {
        m$1.add(new StringBuilder(2).append("C_").append(key$1).toString(), contrib.siret().getOrElse((Function0 & Serializable)() -> (String)contrib.sandre().getOrElse((Function0 & Serializable)() -> "")));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)key$1, (List)new .colon.colon((Object)new StringBuilder(4).append(key$1).append("_NOM").toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_NOM_").append(key$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_NOM_").append(cType$1).toString(), (List)Nil$.MODULE$)))), contrib.name());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(17).append("INTER_MNEMONIQUE_").append(key$1).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("INTER_MNEMONIQUE_").append(cType$1).toString(), (List)Nil$.MODULE$)), contrib.mnemonique());
        m$1.add(new StringBuilder(4).append("REF_").append(key$1).toString(), (Option<Object>)link$2.internalReference());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_BUR_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_BUR_").append(key$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_TEL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_TEL_").append(key$1).toString(), (List)Nil$.MODULE$)))), contrib.phoneTel().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(11).append("INTER_TEL2_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(11).append("INTER_TEL2_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.phoneTelSecond().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_FAX_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_FAX_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.fax().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(12).append("INTER_EMAIL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(12).append("INTER_EMAIL_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.email());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_MOB_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_MOB_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.mobile().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_ADD_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_ADD_").append(key$1).toString(), (List)Nil$.MODULE$)), ((IterableOnceOps)new .colon.colon((Object)contrib.postalBox(), (List)new .colon.colon((Object)contrib.road(), (List)new .colon.colon((Object)(contrib.postalCode().isDefined() ? contrib.postalCode() : contrib.department()), (List)new .colon.colon((Object)contrib.city(), (List)new .colon.colon((Object)contrib.addressComplement(), (List)Nil$.MODULE$))))).flatten(Predef$.MODULE$.$conforms())).mkString(", "));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(14).append("INTER_COMMUNE_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(14).append("INTER_COMMUNE_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.city());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$88(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, int cType$1, String key$1, Contact contact) {
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMENT_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMENT_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.comment());
        contact.cityCode().flatMap((Function1 & Serializable)city -> $this.cityDao.get(city)).foreach((Function1 & Serializable)city -> {
            m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMUNE_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMUNE_").append(key$1).toString(), (List)Nil$.MODULE$)), city.name());
            return BoxedUnit.UNIT;
        });
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_NOM_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_NOM_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.name());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_TEL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_TEL_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.phoneTel().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(14).append("INTER_CT_TEL2_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(14).append("INTER_CT_TEL2_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.phoneTelSecond().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_FAX_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_FAX_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.fax().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_MOB_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_MOB_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.mobile().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(15).append("INTER_CT_EMAIL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("INTER_CT_EMAIL_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.email());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_ADD_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_ADD_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.address());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$79(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Tuple3 x0$12) {
        Tuple3 tuple3 = x0$12;
        if (tuple3 != null) {
            StationContributorLink link = (StationContributorLink)tuple3._1();
            Option contribOpt = (Option)tuple3._2();
            String key = (String)tuple3._3();
            int cType = (int)BoxesRunTime.unboxToDouble((Object)link.contributorType().get());
            contribOpt.foreach((Function1 & Serializable)contrib -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$80(m$1, key, cType, link, contrib);
                return BoxedUnit.UNIT;
            });
            link.contactCode().flatMap((Function1 & Serializable)ctCode -> $this.contactDao.get((int)BoxesRunTime.unboxToLong((Object)ctCode))).foreach((Function1 & Serializable)contact -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$88($this, m$1, cType, key, contact);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$97(Tuple3 x$11) {
        return ((Option)x$11._2()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$72(PiezoBookmarkBuilder $this, Seq sandreCodes$1, MapOfBookmarks m$1, Seq link_contribs) {
        Seq contribs = (Seq)((IterableOps)((IterableOps)((IterableOps)link_contribs.filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$73(l)))).map((Function1 & Serializable)link -> {
            if (link.idContributor().isEmpty()) {
                return new Tuple2(link, (Object)None$.MODULE$);
            }
            return (Tuple2)$this.contributorsDao.getWithId((int)BoxesRunTime.unboxToLong((Object)link.idContributor().get())).map((Function1 & Serializable)contrib -> new Tuple2(link, (Object)new Some(contrib))).getOrElse((Function0 & Serializable)() -> new Tuple2(link, (Object)None$.MODULE$));
        })).map((Function1 & Serializable)x0$11 -> {
            Tuple2 tuple2 = x0$11;
            if (tuple2 != null) {
                StationContributorLink link = (StationContributorLink)tuple2._1();
                Option contrib = (Option)tuple2._2();
                return new Tuple3((Object)link, (Object)contrib, (Object)ReferentialUtil$.MODULE$.getSandreLabel("LIEN_PIEZO_INTERVENANTS.TYPEINTERVENANT", (long)BoxesRunTime.unboxToDouble((Object)link.contributorType().get()), sandreCodes$1).toUpperCase().replace(" ", "_").replace("'", "_"));
            }
            throw new MatchError((Object)tuple2);
        })).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)x$10._3()))));
        if (contribs.nonEmpty()) {
            contribs.foreach((Function1 & Serializable)x0$12 -> {
                PiezoBookmarkBuilder.$anonfun$getMarkers$79($this, m$1, x0$12);
                return BoxedUnit.UNIT;
            });
            Map groups = contribs.groupBy((Function1 & Serializable)x0$13 -> {
                Tuple3 tuple3 = x0$13;
                if (tuple3 != null) {
                    String key = (String)tuple3._3();
                    return key;
                }
                throw new MatchError((Object)tuple3);
            });
            groups.keys().foreach((Function1 & Serializable)key -> {
                m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(1).append(key).append("S").toString(), (List)new .colon.colon((Object)new StringBuilder(5).append(key).append("S_NOM").toString(), (List)Nil$.MODULE$)), ((IterableOnceOps)((IterableOps)((IterableOps)groups.apply((Object)key)).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$97(x$11)))).flatMap((Function1 & Serializable)x0$14 -> {
                    Tuple3 tuple3 = x0$14;
                    if (tuple3 != null) {
                        Option contrib = (Option)tuple3._2();
                        return ((ContributorWithLinks)contrib.get()).name();
                    }
                    throw new MatchError((Object)tuple3);
                })).mkString(", "));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getMarkers$100(MapOfBookmarks m$1, StationWorkLink work) {
        m$1.add(BookmarksEnum$.MODULE$.TYPE_STATION(), (Object)work.stationType());
        m$1.add(BookmarksEnum$.MODULE$.TYPE_CAPTEUR(), (Object)work.sensorType());
        m$1.add(BookmarksEnum$.MODULE$.TEL_STATION(), (Object)work.phone());
        m$1.add(BookmarksEnum$.MODULE$.NUM_SERIE(), (Object)work.serialNumber());
        m$1.add(BookmarksEnum$.MODULE$.PROFONDEUR(), (Object)work.workDepth());
        m$1.add(BookmarksEnum$.MODULE$.PROFONDEUR_CAPTEUR(), (Object)work.sensorDepth());
        m$1.add(BookmarksEnum$.MODULE$.DIAM_INTERNE(), (Object)work.internalDiameter());
        m$1.add(BookmarksEnum$.MODULE$.DIAM_EXTERNE(), (Object)work.externalDiameter());
        m$1.add(BookmarksEnum$.MODULE$.COM_OUVRAGE(), (Object)work.comment());
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$101(StationLinkDetailed x$13) {
        return (int)x$13.stationLinkedType() == StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.INSTALLATION());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$105(MapOfBookmarks m$1, ManagementUnitWithLinks uge) {
        m$1.add(BookmarksEnum$.MODULE$.UNITE_GESTION(), (Object)uge.id());
        m$1.add(BookmarksEnum$.MODULE$.NOM_UNITE_GESTION(), (Object)uge.name());
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$108(Casing x$14) {
        return x$14.strainers().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ double $anonfun$getMarkers$109(Casing c) {
        return BoxesRunTime.unboxToDouble((Object)c.startDepth().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble((Object)c.endDepth().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$112(PiezoBookmarkBuilder $this, BooleanRef hasCrepines$1, MapOfBookmarks m$1, Casing c) {
        hasCrepines$1.elem = true;
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_H_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$115(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Casing c) {
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_F_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$106(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Installation i$1, BooleanRef hasCrepines$1, BoreholeWithLinks borehole) {
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_REALISATION(), (Option<DateTime>)i$1.creationDate());
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_SERVICE(), (Option<DateTime>)borehole.serviceDate());
        m$1.add(BookmarksEnum$.MODULE$.DEBIT_EXPLOITE(), (Object)borehole.allowedHourWaterFlow());
        m$1.add(BookmarksEnum$.MODULE$.DEBIT_EXPLOITE_ANNEE(), (Object)borehole.yearWaterFlow());
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_ARRETE(), (Option<DateTime>)borehole.arrestDate());
        m$1.add(BookmarksEnum$.MODULE$.NUM_ARRETE(), (Object)borehole.arrestCode());
        m$1.add(BookmarksEnum$.MODULE$.VOL_ANNUEL_AUTORISE(), (Object)borehole.allowedYearWaterVolume());
        m$1.add(BookmarksEnum$.MODULE$.CIMENTATION_TUBAGE(), (Object)borehole.cementationTubing());
        m$1.add(BookmarksEnum$.MODULE$.TYPE_POMPE(), (Object)borehole.pumpType());
        Seq casings = (Seq)((SeqOps)((IterableOps)borehole.link_casings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$108(x$14)))).sortBy((Function1 & Serializable)c -> BoxesRunTime.boxToDouble((double)PiezoBookmarkBuilder.$anonfun$getMarkers$109(c)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        casings.headOption().foreach((Function1 & Serializable)c -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$112($this, hasCrepines$1, m$1, c);
            return BoxedUnit.UNIT;
        });
        casings.lastOption().foreach((Function1 & Serializable)c -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$115($this, m$1, c);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$103(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, BooleanRef hasCrepines$1, Installation i) {
        i.managementCode().flatMap((Function1 & Serializable)ugeCode -> $this.managementUnitsDao.getManagementUnit((int)BoxesRunTime.unboxToLong((Object)ugeCode))).foreach((Function1 & Serializable)uge -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$105(m$1, uge);
            return BoxedUnit.UNIT;
        });
        $this.InstallationBoreholeDao.getWithLinks((long)i.id()).foreach((Function1 & Serializable)borehole -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$106($this, m$1, i, hasCrepines$1, borehole);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$119(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Casing c) {
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_H_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$123(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Casing c) {
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_F_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$130(int periodicity$1, SandreCode s) {
        String string = s.field();
        String string2 = "MODES_MESURES.PERIODICITE";
        return !(string != null ? !string.equals(string2) : string2 != null) && s.code() == periodicity$1;
    }

    public static final /* synthetic */ void $anonfun$getMarkers$131(MapOfBookmarks m$1, SandreCode code) {
        m$1.add(BookmarksEnum$.MODULE$.C_PERIODICITE(), (Object)code.name());
        m$1.add(BookmarksEnum$.MODULE$.PERIODICITE(), (Object)code.comment());
    }

    public static final /* synthetic */ long $anonfun$getMarkers$133(Landmark x$16) {
        return BoxesRunTime.unboxToLong((Object)x$16.startDate().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$127(MapOfBookmarks m$1, Seq sandreCodes$1, PiezometerWithLinks piezo$1, MeasureMethod measureMethod) {
        measureMethod.method().foreach((Function1)(JFunction1.mcVD.sp & Serializable)meth -> {
            m$1.add(BookmarksEnum$.MODULE$.C_METHODE(), (Object)BoxesRunTime.boxToInteger((int)((int)meth)));
            m$1.add(BookmarksEnum$.MODULE$.METHODE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("MODES_MESURES.METHODE", (long)meth, sandreCodes$1));
        });
        measureMethod.periodicity().foreach((Function1)(JFunction1.mcVI.sp & Serializable)periodicity -> sandreCodes$1.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)PiezoBookmarkBuilder.$anonfun$getMarkers$130(periodicity, s))).foreach((Function1 & Serializable)code -> {
            PiezoBookmarkBuilder.$anonfun$getMarkers$131(m$1, code);
            return BoxedUnit.UNIT;
        }));
        m$1.addDate(BookmarksEnum$.MODULE$.DEB_MESURE(), (Option<DateTime>)measureMethod.startDate());
        m$1.addDate(BookmarksEnum$.MODULE$.FIN_MESURE(), (Option<DateTime>)measureMethod.endDate());
        m$1.add(BookmarksEnum$.MODULE$.COM_MESURE(), (Object)measureMethod.comment());
        m$1.add(BookmarksEnum$.MODULE$.PROF_NAPPE(), (Object)measureMethod.depth());
        m$1.add(BookmarksEnum$.MODULE$.PROF_NIV_STATIQUE(), (Object)measureMethod.depth());
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_NIV_STATIQUE(), (Option<DateTime>)measureMethod.startDate());
        ((IterableOps)((SeqOps)piezo$1.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)PiezoBookmarkBuilder.$anonfun$getMarkers$133(x$16)), (Ordering)Ordering.Long$.MODULE$)).lastOption().flatMap((Function1 & Serializable)x$18 -> x$18.height()).foreach((Function1)(JFunction1.mcVD.sp & Serializable)height -> m$1.add(BookmarksEnum$.MODULE$.NIV_STATIQUE(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)measureMethod.depth().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + height))));
    }

    private static final String printLandmark$1(Landmark landmark, AltimetrySystem systemAlti, Seq sandreCodes$1, DateTimeFormatter formatter$1) {
        String origin = (String)landmark.origin().map((Function1 & Serializable)o -> ReferentialUtil$.MODULE$.getSandreLabel("REPERES.ORIGINE", (long)BoxesRunTime.unboxToInt((Object)o), sandreCodes$1)).getOrElse((Function0 & Serializable)() -> "");
        String nature = (String)systemAlti.natureCode().map((Function1 & Serializable)n -> ReferentialUtil$.MODULE$.getSandreLabel("SYSTEME_ALTIMETRIQUE.CODENATURE", (long)BoxesRunTime.unboxToInt((Object)n), sandreCodes$1)).getOrElse((Function0 & Serializable)() -> "");
        String cote = landmark.height().isDefined() && systemAlti.altitude().isDefined() ? Double.toString(BoxesRunTime.unboxToDouble((Object)landmark.height().get()) + BoxesRunTime.unboxToDouble((Object)systemAlti.altitude().get())) : "";
        return new StringBuilder(22).append(landmark.startDate().map((Function1 & Serializable)x$19 -> x$19.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")).append(" | ").append(landmark.endDate().map((Function1 & Serializable)x$20 -> x$20.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")).append(" | ").append(nature).append(" | ").append(systemAlti.startDate().map((Function1 & Serializable)x$21 -> x$21.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")).append(" | ").append(landmark.height().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)).append(" | ").append(cote).append(" | ").append(origin).append(" || ").toString();
    }

    private static final String printLandmarkSimple$1(Landmark landmark, AltimetrySystem systemAlti, DateTimeFormatter formatter$1) {
        String cote = landmark.height().isDefined() && systemAlti.altitude().isDefined() ? Double.toString(MathUtil$.MODULE$.roundAt2(BoxesRunTime.unboxToDouble((Object)landmark.height().get()) + BoxesRunTime.unboxToDouble((Object)systemAlti.altitude().get()))) : "";
        return new StringBuilder(1).append(landmark.startDate().map((Function1 & Serializable)x$22 -> x$22.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")).append(" ").append(cote).toString();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$153(PiezometerWithLinks piezo$1, MapOfBookmarks m$1, Seq sandreCodes$1, DateTimeFormatter formatter$1, Landmark landmark) {
        Option option = PiezometryUtils$.MODULE$.getLandmarkSysAlti(landmark, (Seq)piezo$1.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        if (option instanceof Some) {
            Some some = (Some)option;
            AltimetrySystem systemAlti = (AltimetrySystem)some.value();
            m$1.concat(BookmarksEnum$.MODULE$.HISTO_REPERES(), PiezoBookmarkBuilder.printLandmark$1(landmark, systemAlti, sandreCodes$1, formatter$1));
            m$1.concat(BookmarksEnum$.MODULE$.HISTO_REPERES_SIMPLE(), PiezoBookmarkBuilder.printLandmarkSimple$1(landmark, systemAlti, formatter$1));
            return;
        }
        String origin = (String)landmark.origin().map((Function1 & Serializable)o -> ReferentialUtil$.MODULE$.getSandreLabel("REPERES.ORIGINE", (long)BoxesRunTime.unboxToInt((Object)o), sandreCodes$1)).getOrElse((Function0 & Serializable)() -> "");
        String landmarkInfos = new StringBuilder(13).append(landmark.startDate().map((Function1 & Serializable)x$23 -> x$23.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")).append(" | ").append(landmark.endDate().map((Function1 & Serializable)x$24 -> x$24.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")).append(" | ").append(landmark.height().getOrElse((Function0 & Serializable)() -> "").toString()).append(" | ").append(origin).append(" || ").toString();
        m$1.concat(BookmarksEnum$.MODULE$.HISTO_REPERES(), landmarkInfos);
        m$1.concat(BookmarksEnum$.MODULE$.HISTO_REPERES_SIMPLE(), String.valueOf(landmark.startDate().map((Function1 & Serializable)x$25 -> x$25.toString(formatter$1)).getOrElse((Function0 & Serializable)() -> "")));
    }

    public static final /* synthetic */ long $anonfun$getMarkers$165(Landmark x$26) {
        return BoxesRunTime.unboxToLong((Object)x$26.startDate().map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToLong((long)x$27.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$168(MapOfBookmarks m$1, PiezometerWithLinks piezo$1, Seq sandreCodes$1, DateTimeFormatter formatter$1, Landmark lastLandmark) {
        m$1.add(BookmarksEnum$.MODULE$.COORDONNEE_REPERE(), (Object)lastLandmark.height());
        Option option = PiezometryUtils$.MODULE$.getLandmarkSysAlti(lastLandmark, (Seq)piezo$1.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        if (option instanceof Some) {
            Some some = (Some)option;
            AltimetrySystem lastAlt = (AltimetrySystem)some.value();
            m$1.add(BookmarksEnum$.MODULE$.REPERE(), (Object)PiezoBookmarkBuilder.printLandmark$1(lastLandmark, lastAlt, sandreCodes$1, formatter$1));
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$getMarkers$171(AltimetrySystem x$28) {
        return BoxesRunTime.unboxToLong((Object)x$28.startDate().map((Function1 & Serializable)x$29 -> BoxesRunTime.boxToLong((long)x$29.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$176(StationLocation x$31) {
        return x$31.z().isDefined();
    }

    public static final /* synthetic */ long $anonfun$getMarkers$179(CmsOutput x$33) {
        return BoxesRunTime.unboxToLong((Object)x$33.updateDate().map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$182(MapOfBookmarks m$1, CmsOutput cms) {
        m$1.addDate(new StringBuilder(9).append("CMS_").append(cms.idCategory()).append("_DATE").toString(), (Option<DateTime>)cms.updateDate());
        m$1.add(new StringBuilder(11).append("CMS_").append(cms.idCategory()).append("_AUTEUR").toString(), (Option<Object>)cms.author());
        m$1.add(new StringBuilder(10).append("CMS_").append(cms.idCategory()).append("_TITRE").toString(), (Object)cms.title());
        m$1.add(new StringBuilder(14).append("CMS_").append(cms.idCategory()).append("_SOUSTITRE").toString(), (Option<Object>)cms.subtitle());
        m$1.add(new StringBuilder(16).append("CMS_").append(cms.idCategory()).append("_COMMENTAIRE").toString(), (Option<Object>)cms.comment());
        m$1.add(new StringBuilder(15).append("CMS_").append(cms.idCategory()).append("_PIEDDEPAGE").toString(), (Option<Object>)cms.footer());
        m$1.add(new StringBuilder(23).append("CMS_").append(cms.idCategory()).append("_CONTENU_PIEDDEPAGE").toString(), (Option<Object>)cms.footerContent());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$183(MapOfBookmarks m$1, CmsOutput cms) {
        m$1.addDate(new StringBuilder(10).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_DATE").toString(), (Option<DateTime>)cms.updateDate());
        m$1.add(new StringBuilder(12).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_AUTEUR").toString(), (Option<Object>)cms.author());
        m$1.add(new StringBuilder(11).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_TITRE").toString(), (Object)cms.title());
        m$1.add(new StringBuilder(15).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_SOUSTITRE").toString(), (Option<Object>)cms.subtitle());
        m$1.add(new StringBuilder(17).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_COMMENTAIRE").toString(), (Option<Object>)cms.comment());
        m$1.add(new StringBuilder(16).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_PIEDDEPAGE").toString(), (Option<Object>)cms.footer());
        m$1.add(new StringBuilder(24).append("CMS_").append(cms.idCategory()).append("_").append(cms.id()).append("_CONTENU_PIEDDEPAGE").toString(), (Option<Object>)cms.footerContent());
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$184(PiezometerChartOptions x$35) {
        return x$35.dataType().contains((Object)"-1");
    }

    public static final /* synthetic */ double $anonfun$getMarkers$188(Tuple2 x0$16) {
        Tuple2 tuple2 = x0$16;
        if (tuple2 != null) {
            double min = tuple2._1$mcD$sp();
            return min;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$getMarkers$191(Tuple2 x0$17) {
        Tuple2 tuple2 = x0$17;
        if (tuple2 != null) {
            double max = tuple2._2$mcD$sp();
            return max;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getMarkers$195(Accessibilities x$38) {
        return BoxesRunTime.unboxToLong((Object)x$38.startDate().map((Function1 & Serializable)x$39 -> BoxesRunTime.boxToLong((long)x$39.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$198(MapOfBookmarks m$1, Seq sandreCodes$1, Accessibilities access) {
        m$1.add(BookmarksEnum$.MODULE$.COND_ACCES(), (Object)access.description());
        access.codeCondition().foreach((Function1)(JFunction1.mcVD.sp & Serializable)cAccess -> {
            m$1.add(BookmarksEnum$.MODULE$.C_COND_ACCES(), (Object)BoxesRunTime.boxToDouble((double)cAccess));
            m$1.add(BookmarksEnum$.MODULE$.L_COND_ACCES(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("ACCESSIBILITES.TYPE_CONDITION", (long)cAccess, sandreCodes$1));
        });
    }

    public static final /* synthetic */ long $anonfun$getMarkers$201(Arrangement x$40) {
        return BoxesRunTime.unboxToLong((Object)x$40.startDate().map((Function1 & Serializable)x$41 -> BoxesRunTime.boxToLong((long)x$41.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$204(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Seq sandreCodes$1, Arrangement arrangement) {
        m$1.add(BookmarksEnum$.MODULE$.AMENAGEMENT(), (Object)arrangement.descriptive());
        arrangement.keyCode().flatMap((Function1 & Serializable)key -> $this.BookmarksExportSpecificDao.getMatKeyName(BoxesRunTime.unboxToDouble((Object)key))).foreach((Function1 & Serializable)keyLabel -> {
            m$1.add(BookmarksEnum$.MODULE$.CLE_ACCES(), (Object)keyLabel);
            return BoxedUnit.UNIT;
        });
        arrangement.arrangementType().foreach((Function1)(JFunction1.mcVD.sp & Serializable)typeArr -> {
            m$1.add(BookmarksEnum$.MODULE$.TYPE_AMENAGEMENT(), (Object)BoxesRunTime.boxToDouble((double)typeArr));
            m$1.add(BookmarksEnum$.MODULE$.L_TYPE_AMENAGEMENT(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("AMENAGEMENT.TYPE_AMENAGEMENT", (long)typeArr, sandreCodes$1));
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$208(StationLinkDetailed x$42) {
        return (int)x$42.stationLinkedType() == StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.DISTRIBUTION());
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$212(StationLinkDetailed x$43) {
        return x$43.stationLinkedType() == (long)StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.DISTRIBUTION());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$214(MapOfBookmarks m$1, DistributionUnitWithLinks u) {
        m$1.add(BookmarksEnum$.MODULE$.UNITE_DISTRIB(), (Object)u.code());
        m$1.add(BookmarksEnum$.MODULE$.NOM_UNITE_DISTRIB(), (Object)u.name());
    }

    public static final /* synthetic */ long $anonfun$getMarkers$216(AltimetrySystem x$44) {
        return BoxesRunTime.unboxToLong((Object)x$44.startDate().map((Function1 & Serializable)x$45 -> BoxesRunTime.boxToLong((long)x$45.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$219(MapOfBookmarks m$1, Seq sandreCodes$1, AltimetrySystem alt) {
        m$1.add(BookmarksEnum$.MODULE$.COMMENT_NIVEL(), (Object)alt.comment());
        m$1.add(BookmarksEnum$.MODULE$.NIVELLEMENT(), (Object)alt.altitude());
        alt.natureCode().foreach((Function1)(JFunction1.mcVI.sp & Serializable)n -> m$1.add(BookmarksEnum$.MODULE$.ORIGINE_NIVEL(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("REPERES.ORIGINE", (long)n, sandreCodes$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$221(CentralSituation s) {
        return s.situationEndDate().isEmpty() || ((BaseDateTime)s.situationEndDate().get()).getMillis() < new DateTime().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getMarkers$222(CentralSituation s) {
        return ((BaseDateTime)s.situationDate().getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1980))).getMillis();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$226(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Option ass$1, CentralOutput central) {
        m$1.add(BookmarksEnum$.MODULE$.CENTRALE(), (Object)central.serialNumber());
        m$1.add(BookmarksEnum$.MODULE$.CENTRALE_DATE(), (Object)((CentralSituation)ass$1.get()).situationDate());
        central.centralType().flatMap((Function1 & Serializable)ct -> $this.CentralTypeDao.getCentralType(BoxesRunTime.unboxToInt((Object)ct))).foreach((Function1 & Serializable)t -> {
            m$1.add(BookmarksEnum$.MODULE$.CENTRALE_TYPE(), (Object)t.name());
            return BoxedUnit.UNIT;
        });
        central.providerId().flatMap((Function1 & Serializable)provider -> $this.contributorsDao.getWithId(BoxesRunTime.unboxToInt((Object)provider))).foreach((Function1 & Serializable)provider -> {
            m$1.add(BookmarksEnum$.MODULE$.CENTRALE_FOURN(), (Object)provider.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$231(SensorSituation s) {
        return s.situationEndDate().isEmpty() || ((BaseDateTime)s.situationEndDate().get()).getMillis() < new DateTime().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getMarkers$232(SensorSituation s) {
        return ((BaseDateTime)s.situationDate().getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1980))).getMillis();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$235(PiezoBookmarkBuilder $this, MapOfBookmarks m$1, Option ass2$1, SensorOutput sensor) {
        m$1.add(BookmarksEnum$.MODULE$.CAPTEUR(), (Object)sensor.serialNumber());
        m$1.add(BookmarksEnum$.MODULE$.CAPTEUR_DATE(), (Object)((SensorSituation)ass2$1.get()).situationDate());
        sensor.sensorType().flatMap((Function1 & Serializable)ct -> $this.SensorTypeDao.getSensorType(BoxesRunTime.unboxToInt((Object)ct))).foreach((Function1 & Serializable)t -> {
            m$1.add(BookmarksEnum$.MODULE$.CAPTEUR_TYPE(), (Object)t.name());
            return BoxedUnit.UNIT;
        });
        sensor.providerId().flatMap((Function1 & Serializable)provider -> $this.contributorsDao.getWithId(BoxesRunTime.unboxToInt((Object)provider))).foreach((Function1 & Serializable)provider -> {
            m$1.add(BookmarksEnum$.MODULE$.CAPTEUR_FOURN(), (Object)provider.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$241(MapOfBookmarks m$1, GeoData geo) {
        m$1.add(BookmarksEnum$.MODULE$.CARTE_IGN(), (Object)geo.ignMap());
        m$1.add(BookmarksEnum$.MODULE$.PARCELLE(), (Object)geo.parcel());
        m$1.add(BookmarksEnum$.MODULE$.SECTION(), (Object)geo.section());
        m$1.add(BookmarksEnum$.MODULE$.CARTE_GEOLOGIQUE(), (Object)geo.section());
    }

    public static final /* synthetic */ long $anonfun$getMarkers$243(Usage x$48) {
        return BoxesRunTime.unboxToLong((Object)x$48.startDate().map((Function1 & Serializable)x$49 -> BoxesRunTime.boxToLong((long)x$49.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$246(MapOfBookmarks m$1, Seq sandreCodes$1, Usage usage) {
        m$1.add(BookmarksEnum$.MODULE$.DESC_USAGE(), (Object)usage.descriptive());
        usage.usageCode().foreach((Function1)(JFunction1.mcVI.sp & Serializable)uCode -> m$1.add(BookmarksEnum$.MODULE$.LIB_USAGE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("USAGES", (long)uCode, sandreCodes$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$248(DataTypeStatistics x$50) {
        return x$50.typeId() == -1;
    }

    public static final /* synthetic */ void $anonfun$getMarkers$249(MapOfBookmarks m$1, DataTypeStatistics stats) {
        m$1.addDate(BookmarksEnum$.MODULE$.ANNEE_DEBUT_MESURE(), (Option<DateTime>)stats.startDate());
        m$1.addDate(BookmarksEnum$.MODULE$.ANNEE_DEBUT_MESURE(), (Option<DateTime>)stats.endDate());
    }

    @Inject
    public PiezoBookmarkBuilder(LogUtil logUtil, CityDao cityDao, ContactDao contactDao, WatershedDao watershedDao, AquiferDao aquiferDao, WatermassDao watermassDao, NetworkDao networkDao, ContributorsDao contributorsDao, SandreCodeDao sandreCodeDao, PiezometerDaeau piezometerDao, InstallationDao installationDao, InstallationBoreholeDao InstallationBoreholeDao2, ManagementUnitsDao managementUnitsDao, StationLinkDao stationLinkDao, StationLandmarkDao StationLandmarkDao2, DistributionUnitDao distributionUnitDao, ProductionUnitDao productionUnitDao, CmsDao cmsDao, PiezometryEventDao piezometryEventDao, PiezoBookmarkExportDao PiezoBookmarkExportDao2, HydroEntityDao hydroEntityDao, PiezometerChartOptionsDao PiezometerChartOptionsDao2, MaterielCentralDao centralDao, CentralTypeDao CentralTypeDao2, SensorTypeDao SensorTypeDao2, CentralPiezometerAssignmentDao centralPiezometerAssignmentDao, MaterielSensorDao sensorDao, SensorPiezometerAssignmentDao sensorPiezometerAssignmentDao, PiezometerMeasureDao PiezometerMeasureDao2, BookmarksExportSpecificDao BookmarksExportSpecificDao2, FileRPC FileRPC2, QualitometerDao qualitometerDao) {
        this.cityDao = cityDao;
        this.contactDao = contactDao;
        this.watershedDao = watershedDao;
        this.aquiferDao = aquiferDao;
        this.watermassDao = watermassDao;
        this.networkDao = networkDao;
        this.contributorsDao = contributorsDao;
        this.sandreCodeDao = sandreCodeDao;
        this.piezometerDao = piezometerDao;
        this.installationDao = installationDao;
        this.InstallationBoreholeDao = InstallationBoreholeDao2;
        this.managementUnitsDao = managementUnitsDao;
        this.stationLinkDao = stationLinkDao;
        this.distributionUnitDao = distributionUnitDao;
        this.cmsDao = cmsDao;
        this.piezometryEventDao = piezometryEventDao;
        this.PiezoBookmarkExportDao = PiezoBookmarkExportDao2;
        this.hydroEntityDao = hydroEntityDao;
        this.PiezometerChartOptionsDao = PiezometerChartOptionsDao2;
        this.centralDao = centralDao;
        this.CentralTypeDao = CentralTypeDao2;
        this.SensorTypeDao = SensorTypeDao2;
        this.centralPiezometerAssignmentDao = centralPiezometerAssignmentDao;
        this.sensorDao = sensorDao;
        this.sensorPiezometerAssignmentDao = sensorPiezometerAssignmentDao;
        this.PiezometerMeasureDao = PiezometerMeasureDao2;
        this.BookmarksExportSpecificDao = BookmarksExportSpecificDao2;
        this.FileRPC = FileRPC2;
        this.qualitometerDao = qualitometerDao;
    }
}

