/*
 * Decompiled with CFR 0.152.
 */
package model.bookmark;

import dao.itf.BookmarksExportSpecificDao;
import dao.itf.ContributorLinkDao;
import dao.itf.LinkedStationDao;
import dao.itf.QualitometerPointDao;
import domain.modelExport.StationModelExport;
import fr.aquasys.daeau.installation.domain.BoreholeWithLinks;
import fr.aquasys.daeau.installation.itf.InstallationDao;
import fr.aquasys.daeau.installation.itf.borehole.InstallationBoreholeDao;
import fr.aquasys.daeau.installation.model.Installation;
import fr.aquasys.daeau.materiel.domain.model.central.CentralSituation;
import fr.aquasys.daeau.materiel.domain.model.sensor.SensorSituation;
import fr.aquasys.daeau.materiel.domain.output.CentralOutput;
import fr.aquasys.daeau.materiel.domain.output.SensorOutput;
import fr.aquasys.daeau.materiel.itf.central.CentralTypeDao;
import fr.aquasys.daeau.materiel.itf.central.MaterielCentralDao;
import fr.aquasys.daeau.materiel.itf.central.assignment.CentralQualitometerAssignmentDao;
import fr.aquasys.daeau.materiel.itf.sensor.MaterielSensorDao;
import fr.aquasys.daeau.materiel.itf.sensor.SensorTypeDao;
import fr.aquasys.daeau.materiel.itf.sensor.assignment.SensorQualitometerAssignmentDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.quality.QualityDao;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter;
import fr.aquasys.daeau.quality.chronicAnalysis.QualityFilter$;
import fr.aquasys.daeau.quality.domain.QualitometerWithLinks;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.itf.QualitometerEventDao;
import fr.aquasys.daeau.quality.model.QualitometerEvent;
import fr.aquasys.daeau.quality.operation.QualityOperation;
import fr.aquasys.daeau.referentials.aquifer.itf.AquiferDao;
import fr.aquasys.daeau.referentials.aquifer.model.Aquifer;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.CityWithLinks;
import fr.aquasys.daeau.referentials.contact.Contact;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.contributor.model.ContributorWithLinks;
import fr.aquasys.daeau.referentials.managementUnits.itf.ManagementUnitsDao;
import fr.aquasys.daeau.referentials.managementUnits.model.ManagementUnitWithLinks;
import fr.aquasys.daeau.referentials.network.dao.NetworkDao;
import fr.aquasys.daeau.referentials.network.model.Network;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.referentials.watermass.itf.WatermassDao;
import fr.aquasys.daeau.referentials.watermass.model.Watermass;
import fr.aquasys.daeau.referentials.watershed.itf.WatershedDao;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.aquifer.StationAquifer;
import fr.aquasys.daeau.station.links.arrangements.Arrangement;
import fr.aquasys.daeau.station.links.casings.Casing;
import fr.aquasys.daeau.station.links.contributor.QualitometerContributorWithSiret;
import fr.aquasys.daeau.station.links.contributor.StationContributorDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink;
import fr.aquasys.daeau.station.links.hydroEntity.StationHydroEntity;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.locations.StationLocation;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.station.links.work.StationWorkLink;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.rpc.file.FileOutput;
import fr.aquasys.rpc.file.FileRPC;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.ReferentialUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import model.QualitometerContributorLinkOutput;
import model.QualitometerPoint;
import model.bookmark.BookmarksEnum$;
import model.bookmark.MapOfBookmarks;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import util.ExportFileUtils$;

@ScalaSignature(bytes="\u0006\u0005\t%f\u0001B\u0011#\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ya\f\u0005\tw\u0001\u0011\t\u0011)A\u0006y!A\u0001\n\u0001B\u0001B\u0003-\u0011\n\u0003\u0005Q\u0001\t\u0005\t\u0015a\u0003R\u0011!9\u0006A!A!\u0002\u0017A\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b1\u00021\t\u0011\u001d\u0004!\u0011!Q\u0001\f!D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006Y\u0001\u001d\u0005\to\u0002\u0011\t\u0011)A\u0006q\"Iq\u0010\u0001B\u0001B\u0003-\u0011\u0011\u0001\u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\f\u0005%\u0001BCA\f\u0001\t\u0005\t\u0015a\u0003\u0002\u001a!Q\u0011q\u0004\u0001\u0003\u0002\u0003\u0006Y!!\t\t\u0015\u0005M\u0002A!A!\u0002\u0017\t)\u0004\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0006\u0003\u000bB!\"a\u0013\u0001\u0005\u0003\u0005\u000b1BA'\u0011)\t)\u0006\u0001B\u0001B\u0003-\u0011q\u000b\u0005\u000b\u0003;\u0002!\u0011!Q\u0001\f\u0005}\u0003BCA9\u0001\t\u0005\t\u0015a\u0003\u0002t!Q\u0011\u0011\u0010\u0001\u0003\u0002\u0003\u0006Y!a\u001f\t\u0015\u0005\u001d\u0005A!A!\u0002\u0017\tI\t\u0003\u0006\u0002\u0016\u0002\u0011\t\u0011)A\u0006\u0003/C!\"!(\u0001\u0005\u0003\u0005\u000b1BAP\u0011)\tI\u000b\u0001B\u0001B\u0003-\u00111\u0016\u0005\u000b\u0003w\u0003!\u0011!Q\u0001\f\u0005u\u0006BCAf\u0001\t\u0005\t\u0015a\u0003\u0002N\"Q\u0011\u0011\u001c\u0001\u0003\u0002\u0003\u0006Y!a7\t\u0015\u0005%\bA!A!\u0002\u0017\tY\u000f\u0003\u0006\u0002z\u0002\u0011\t\u0011)A\u0006\u0003wDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0003^\u0001!\tAa\u0018\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\n1\u0012+^1mSR|'i\\8l[\u0006\u00148NQ;jY\u0012,'O\u0003\u0002$I\u0005A!m\\8l[\u0006\u00148NC\u0001&\u0003\u0015iw\u000eZ3m\u0007\u0001\u0019\"\u0001\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"\u0001M\u001d\u000e\u0003ER!AM\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0003iU\n\u0001B]1cE&$X.\u001d\u0006\u0003m]\nq!Y9vCNL8OC\u00019\u0003\t1'/\u0003\u0002;c\t9Aj\\4Vi&d\u0017aB2jif$\u0015m\u001c\t\u0003{\u0019k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b1!\u001b;g\u0015\t\t%)\u0001\u0003dSRL(BA\"E\u00031\u0011XMZ3sK:$\u0018.\u00197t\u0015\t)U'A\u0003eC\u0016\fW/\u0003\u0002H}\t91)\u001b;z\t\u0006|\u0017AC1rk&4WM\u001d#b_B\u0011!JT\u0007\u0002\u0017*\u0011q\b\u0014\u0006\u0003\u001b\n\u000bq!Y9vS\u001a,'/\u0003\u0002P\u0017\nQ\u0011)];jM\u0016\u0014H)Y8\u0002\u0015\r|g\u000e^1di\u0012\u000bw\u000e\u0005\u0002S+6\t1K\u0003\u0002U\u0005\u000691m\u001c8uC\u000e$\u0018B\u0001,T\u0005)\u0019uN\u001c;bGR$\u0015m\\\u0001\u0015cV\fG.\u001b;p[\u0016$XM\u001d)pS:$H)Y8\u0011\u0005ekV\"\u0001.\u000b\u0005}Z&\"\u0001/\u0002\u0007\u0011\fw.\u0003\u0002_5\n!\u0012+^1mSR|W.\u001a;feB{\u0017N\u001c;EC>\fq\"];bY&$x.\\3uKJ$\u0015m\u001c\t\u0003C\u0016l\u0011A\u0019\u0006\u0003\u007f\rT!\u0001\u001a#\u0002\u000fE,\u0018\r\\5us&\u0011aM\u0019\u0002\u0010#V\fG.\u001b;p[\u0016$XM\u001d#b_\u0006aq/\u0019;feNDW\r\u001a#b_B\u0011\u0011.\\\u0007\u0002U*\u0011qh\u001b\u0006\u0003Y\n\u000b\u0011b^1uKJ\u001c\b.\u001a3\n\u00059T'\u0001D,bi\u0016\u00148\u000f[3e\t\u0006|\u0017!D:b]\u0012\u0014XmQ8eK\u0012\u000bw\u000e\u0005\u0002rk6\t!O\u0003\u0002]g*\u0011AOQ\u0001\u000bg\u0006tGM]3D_\u0012,\u0017B\u0001<s\u00055\u0019\u0016M\u001c3sK\u000e{G-\u001a#b_\u0006y1m\u001c8ue&\u0014W\u000f^8sg\u0012\u000bw\u000e\u0005\u0002z{6\t!P\u0003\u0002@w*\u0011APQ\u0001\fG>tGO]5ckR|'/\u0003\u0002\u007fu\ny1i\u001c8ue&\u0014W\u000f^8sg\u0012\u000bw.\u0001\tmS:\\W\rZ*uCRLwN\u001c#b_B\u0019\u0011,a\u0001\n\u0007\u0005\u0015!L\u0001\tMS:\\W\rZ*uCRLwN\u001c#b_\u0006Qa.\u001a;x_J\\G)Y8\u0011\t\u0005-\u00111C\u0007\u0003\u0003\u001bQ1\u0001XA\b\u0015\r\t\tBQ\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t)\"!\u0004\u0003\u00159+Go^8sW\u0012\u000bw.\u0001\nd_:$(/\u001b2vi>\u0014H*\u001b8l\t\u0006|\u0007cA-\u0002\u001c%\u0019\u0011Q\u0004.\u0003%\r{g\u000e\u001e:jEV$xN\u001d'j].$\u0015m\\\u0001\u0016gR\fG/[8o\u0007>tGO]5ckR|'\u000fR1p!\u0011\t\u0019#a\f\u000e\u0005\u0005\u0015\"b\u0001?\u0002()!\u0011\u0011FA\u0016\u0003\u0015a\u0017N\\6t\u0015\r\ti\u0003R\u0001\bgR\fG/[8o\u0013\u0011\t\t$!\n\u0003+M#\u0018\r^5p]\u000e{g\u000e\u001e:jEV$xN\u001d#b_\u0006aq/\u0019;fe6\f7o\u001d#b_B!\u0011qGA \u001b\t\tIDC\u0002@\u0003wQ1!!\u0010C\u0003%9\u0018\r^3s[\u0006\u001c8/\u0003\u0003\u0002B\u0005e\"\u0001D,bi\u0016\u0014X.Y:t\t\u0006|\u0017\u0001F9vC2LGo\\7fi\u0016\u0014XI^3oi\u0012\u000bw\u000eE\u0002b\u0003\u000fJ1!!\u0013c\u0005Q\tV/\u00197ji>lW\r^3s\u000bZ,g\u000e\u001e#b_\u0006Q\u0011/^1mSRLH)Y8\u0011\t\u0005=\u0013\u0011K\u0007\u0002G&\u0019\u00111K2\u0003\u0015E+\u0018\r\\5us\u0012\u000bw.\u0001\u000eC_>\\W.\u0019:lg\u0016C\bo\u001c:u'B,7-\u001b4jG\u0012\u000bw\u000eE\u0002Z\u00033J1!a\u0017[\u0005i\u0011un\\6nCJ\\7/\u0012=q_J$8\u000b]3dS\u001aL7\rR1p\u0003)\u0019WM\u001c;sC2$\u0015m\u001c\t\u0005\u0003C\ni'\u0004\u0002\u0002d)!\u0011QMA4\u0003\u001d\u0019WM\u001c;sC2T1aPA5\u0015\r\tY\u0007R\u0001\t[\u0006$XM]5fY&!\u0011qNA2\u0005Ii\u0015\r^3sS\u0016d7)\u001a8ue\u0006dG)Y8\u0002\u001d\r+g\u000e\u001e:bYRK\b/\u001a#b_B!\u0011\u0011MA;\u0013\u0011\t9(a\u0019\u0003\u001d\r+g\u000e\u001e:bYRK\b/\u001a#b_\u0006i1+\u001a8t_J$\u0016\u0010]3EC>\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b9'\u0001\u0004tK:\u001cxN]\u0005\u0005\u0003\u000b\u000byHA\u0007TK:\u001cxN\u001d+za\u0016$\u0015m\\\u0001!\u0007\u0016tGO]1m#V\fG.\u001b;p[\u0016$XM]!tg&<g.\\3oi\u0012\u000bw\u000e\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)a\u0019\u0002\u0015\u0005\u001c8/[4o[\u0016tG/\u0003\u0003\u0002\u0014\u00065%\u0001I\"f]R\u0014\u0018\r\\)vC2LGo\\7fi\u0016\u0014\u0018i]:jO:lWM\u001c;EC>\f\u0011b]3og>\u0014H)Y8\u0011\t\u0005u\u0014\u0011T\u0005\u0005\u00037\u000byHA\tNCR,'/[3m'\u0016t7o\u001c:EC>\fqdU3og>\u0014\u0018+^1mSR|W.\u001a;fe\u0006\u001b8/[4o[\u0016tG\u000fR1p!\u0011\t\t+!*\u000e\u0005\u0005\r&\u0002BAH\u0003\u007fJA!a*\u0002$\ny2+\u001a8t_J\fV/\u00197ji>lW\r^3s\u0003N\u001c\u0018n\u001a8nK:$H)Y8\u0002\u000f\u0019KG.\u001a*Q\u0007B!\u0011QVA\\\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016\u0001\u00024jY\u0016T1!!.6\u0003\r\u0011\boY\u0005\u0005\u0003s\u000byKA\u0004GS2,'\u000bU\"\u0002\u001fALWM_8nKR,'\u000fR1fCV\u0004B!a0\u0002H6\u0011\u0011\u0011\u0019\u0006\u0004\u007f\u0005\r'bAAc\t\u0006Q\u0001/[3{_6,GO]=\n\t\u0005%\u0017\u0011\u0019\u0002\u0010!&,'p\\7fi\u0016\u0014H)Y3bk\u0006q1\u000f^1uS>tG*\u001b8l\t\u0006|\u0007\u0003BAh\u0003+l!!!5\u000b\t\u0005M\u0017qE\u0001\fgR\fG/[8oY&t7.\u0003\u0003\u0002X\u0006E'AD*uCRLwN\u001c'j].$\u0015m\\\u0001\u0010S:\u001cH/\u00197mCRLwN\u001c#b_B!\u0011Q\\As\u001b\t\tyNC\u0002@\u0003CT1!a9E\u00031Ign\u001d;bY2\fG/[8o\u0013\u0011\t9/a8\u0003\u001f%s7\u000f^1mY\u0006$\u0018n\u001c8EC>\f!#\\1oC\u001e,W.\u001a8u+:LGo\u001d#b_B!\u0011Q^A{\u001b\t\tyOC\u0002@\u0003cT1!a=C\u0003=i\u0017M\\1hK6,g\u000e^+oSR\u001c\u0018\u0002BA|\u0003_\u0014!#T1oC\u001e,W.\u001a8u+:LGo\u001d#b_\u00069\u0012J\\:uC2d\u0017\r^5p]\n{'/\u001a5pY\u0016$\u0015m\u001c\t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*!!\u0011AAp\u0003!\u0011wN]3i_2,\u0017\u0002\u0002B\u0003\u0003\u007f\u0014q#\u00138ti\u0006dG.\u0019;j_:\u0014uN]3i_2,G)Y8\u0002\rqJg.\u001b;?)\t\u0011Y\u0001\u0006\u001f\u0003\u000e\tE!1\u0003B\u000b\u0005/\u0011IBa\u0007\u0003\u001e\t}!\u0011\u0005B\u0012\u0005K\u00119C!\u000b\u0003,\t5\"q\u0006B\u0019\u0005g\u0011)Da\u000e\u0003:\tm\"Q\bB \u0005\u0003\u0012\u0019E!\u0012\u0003H\t%\u0003c\u0001B\b\u00015\t!\u0005C\u0003/=\u0001\u000fq\u0006C\u0003<=\u0001\u000fA\bC\u0003I=\u0001\u000f\u0011\nC\u0003Q=\u0001\u000f\u0011\u000bC\u0003X=\u0001\u000f\u0001\fC\u0003`=\u0001\u000f\u0001\rC\u0003h=\u0001\u000f\u0001\u000eC\u0003p=\u0001\u000f\u0001\u000fC\u0003x=\u0001\u000f\u0001\u0010\u0003\u0004\u0000=\u0001\u000f\u0011\u0011\u0001\u0005\b\u0003\u000fq\u00029AA\u0005\u0011\u001d\t9B\ba\u0002\u00033Aq!a\b\u001f\u0001\b\t\t\u0003C\u0004\u00024y\u0001\u001d!!\u000e\t\u000f\u0005\rc\u0004q\u0001\u0002F!9\u00111\n\u0010A\u0004\u00055\u0003bBA+=\u0001\u000f\u0011q\u000b\u0005\b\u0003;r\u00029AA0\u0011\u001d\t\tH\ba\u0002\u0003gBq!!\u001f\u001f\u0001\b\tY\bC\u0004\u0002\bz\u0001\u001d!!#\t\u000f\u0005Ue\u0004q\u0001\u0002\u0018\"9\u0011Q\u0014\u0010A\u0004\u0005}\u0005bBAU=\u0001\u000f\u00111\u0016\u0005\b\u0003ws\u00029AA_\u0011\u001d\tYM\ba\u0002\u0003\u001bDq!!7\u001f\u0001\b\tY\u000eC\u0004\u0002jz\u0001\u001d!a;\t\u000f\u0005eh\u0004q\u0001\u0002|\"\u001aaD!\u0014\u0011\t\t=#\u0011L\u0007\u0003\u0005#RAAa\u0015\u0003V\u00051\u0011N\u001c6fGRT!Aa\u0016\u0002\u000b)\fg/\u0019=\n\t\tm#\u0011\u000b\u0002\u0007\u0013:TWm\u0019;\u0002\u0015\u001d,G/T1sW\u0016\u00148\u000f\u0006\u0004\u0003b\t\u001d$\u0011\u000f\t\u0004S\t\r\u0014b\u0001B3U\t!QK\\5u\u0011\u001d\u0011Ig\ba\u0001\u0005W\n\u0011!\u001c\t\u0005\u0005\u001f\u0011i'C\u0002\u0003p\t\u0012a\"T1q\u001f\u001a\u0014un\\6nCJ\\7\u000fC\u0004\u0003t}\u0001\rA!\u001e\u0002\u0003M\u0004BAa\u001e\u0003\u00026\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(A\u0006n_\u0012,G.\u0012=q_J$(B\u0001B@\u0003\u0019!w.\\1j]&!!1\u0011B=\u0005I\u0019F/\u0019;j_:lu\u000eZ3m\u000bb\u0004xN\u001d;\u0002\u001d\u001d,Go\u0015;bi&|g\u000eV=qKR!!\u0011\u0012BP!\u0011\u0011YI!'\u000f\t\t5%Q\u0013\t\u0004\u0005\u001fSSB\u0001BI\u0015\r\u0011\u0019JJ\u0001\u0007yI|w\u000e\u001e \n\u0007\t]%&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00057\u0013iJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005/S\u0003b\u0002BQA\u0001\u0007!1U\u0001\tif\u0004XmQ8eKB\u0019\u0011F!*\n\u0007\t\u001d&FA\u0002J]R\u0004")
public class QualitoBookmarkBuilder {
    private final LogUtil logUtil;
    private final CityDao cityDao;
    private final AquiferDao aquiferDao;
    private final ContactDao contactDao;
    private final QualitometerPointDao qualitometerPointDao;
    private final QualitometerDao qualitometerDao;
    private final WatershedDao watershedDao;
    private final SandreCodeDao sandreCodeDao;
    private final ContributorsDao contributorsDao;
    private final NetworkDao networkDao;
    private final ContributorLinkDao contributorLinkDao;
    private final StationContributorDao stationContributorDao;
    private final WatermassDao watermassDao;
    private final QualitometerEventDao qualitometerEventDao;
    private final QualityDao qualityDao;
    private final BookmarksExportSpecificDao BookmarksExportSpecificDao;
    private final MaterielCentralDao centralDao;
    private final CentralTypeDao CentralTypeDao;
    private final SensorTypeDao SensorTypeDao;
    private final CentralQualitometerAssignmentDao CentralQualitometerAssignmentDao;
    private final MaterielSensorDao sensorDao;
    private final SensorQualitometerAssignmentDao SensorQualitometerAssignmentDao;
    private final FileRPC FileRPC;
    private final PiezometerDaeau piezometerDaeau;
    private final StationLinkDao stationLinkDao;
    private final InstallationDao installationDao;
    private final ManagementUnitsDao managementUnitsDao;
    private final InstallationBoreholeDao InstallationBoreholeDao;

    public void getMarkers(MapOfBookmarks m, StationModelExport s2) {
        Option option;
        Seq pictures;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
        Seq sandreCodes = this.sandreCodeDao.getAll();
        QualitometerWithLinks qualito = (QualitometerWithLinks)this.qualitometerDao.getWithLinks((int)s2.id()).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(27).append("Can't find qualito with id ").append(s2.id()).toString());
        });
        Option lbv = s2.watershed().map((Function1 & Serializable)w -> QualitoBookmarkBuilder.$anonfun$getMarkers$2(this, BoxesRunTime.unboxToDouble((Object)w)));
        Option lbv2 = s2.watershed2().map((Function1 & Serializable)w -> QualitoBookmarkBuilder.$anonfun$getMarkers$5(this, BoxesRunTime.unboxToDouble((Object)w)));
        Option lbv3 = s2.watershed3().map((Function1 & Serializable)w -> QualitoBookmarkBuilder.$anonfun$getMarkers$8(this, BoxesRunTime.unboxToDouble((Object)w)));
        Option lbv4 = s2.watershed4().map((Function1 & Serializable)w -> QualitoBookmarkBuilder.$anonfun$getMarkers$11(this, BoxesRunTime.unboxToDouble((Object)w)));
        this.logUtil.debug("Watershed loading completed", this.logUtil.debug$default$2());
        this.logUtil.debug("Qualitometer point on Fish Support (41) loading completed", this.logUtil.debug$default$2());
        Seq linkedStations = this.stationLinkDao.get(s2.code(), (long)StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.QUALITY()));
        this.logUtil.debug("Qualitometer Linked station loading completed", this.logUtil.debug$default$2());
        Option linkedContributorOperator = this.stationContributorDao.getQualitoContributorByStationIdAndContactType((long)s2.id(), "EXPLOITANT");
        Option linkedContributorAuthority = this.stationContributorDao.getQualitoContributorByStationIdAndContactType((long)s2.id(), "MAITRE D");
        Option linkedContributorOwner = this.stationContributorDao.getQualitoContributorByStationIdAndContactType((long)s2.id(), "PROPRI\u00c9TAIRE");
        Seq linkedContributorProducers = this.stationContributorDao.getQualitoContributorProducersByStationIdAndBSS((long)s2.id(), s2.code());
        Seq<QualitometerContributorLinkOutput> qualitoContributorLink = this.contributorLinkDao.getByStationQualito((int)s2.id());
        Seq eventList = this.qualitometerEventDao.find((double)((int)s2.id()));
        m.add(BookmarksEnum$.MODULE$.DATE_EDITION(), (Object)formatter.print((ReadableInstant)new DateTime()));
        Seq seq = pictures = ExportFileUtils$.MODULE$.getTmpExportDirectoryName().contains("home/titouan") ? (Seq)Nil$.MODULE$ : this.FileRPC.getStationPictures(s2.code());
        if (pictures.nonEmpty()) {
            Seq picturesFormated = (Seq)((IterableOps)pictures.distinct()).map((Function1 & Serializable)pic -> {
                String[] splitted = pic.name().split("_", 1000);
                return new Tuple2(pic, (Object)splitted);
            });
            this.sandreCodeDao.getSandreList("TYPE_PHOTO").foreach((Function1 & Serializable)picType -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$15(picturesFormated, m, picType);
                return BoxedUnit.UNIT;
            });
        }
        this.logUtil.debug("Qualitometer pictures loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.CODE_INTER(), s2.internQualitoCode());
        m.add(BookmarksEnum$.MODULE$.CODE_QUALITO(), (Object)BoxesRunTime.boxToInteger((int)((int)s2.id())));
        m.add(BookmarksEnum$.MODULE$.CODE_BSS(), (Object)s2.code());
        m.add(BookmarksEnum$.MODULE$.CODE_STATION(), (Object)s2.code());
        m.add(BookmarksEnum$.MODULE$.DESIGNATION(), s2.designation());
        m.add(BookmarksEnum$.MODULE$.NOM_QUALITO(), s2.name());
        m.add(BookmarksEnum$.MODULE$.NOM_STATION(), s2.name());
        this.logUtil.debug("Qualitometer station codes, name, id loading completed", this.logUtil.debug$default$2());
        if (s2.nature().isDefined()) {
            m.add(BookmarksEnum$.MODULE$.C_NATURE(), (Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)s2.nature().get()))));
            m.add(BookmarksEnum$.MODULE$.NATURE_OUVRAGE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.CODENATURE", (long)BoxesRunTime.unboxToDouble((Object)s2.nature().get()), sandreCodes));
        }
        this.logUtil.debug("Qualitometer nature loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.DATE_CREATION(), (Object)s2.creation().map((Function1 & Serializable)x$6 -> formatter.print((ReadableInstant)x$6)));
        m.add(BookmarksEnum$.MODULE$.DATE_FERMETURE(), (Object)s2.close().map((Function1 & Serializable)x$7 -> formatter.print((ReadableInstant)x$7)));
        this.logUtil.debug("Qualitometer dates loading completed", this.logUtil.debug$default$2());
        if (qualito.projection().isDefined() && qualito.x().isDefined() && qualito.y().isDefined()) {
            m.add(new StringBuilder(1).append(BookmarksEnum$.MODULE$.COORDONNEE_X().toString()).append("_").append((int)BoxesRunTime.unboxToDouble((Object)qualito.projection().get())).toString(), (Object)qualito.x().get().toString());
            m.add(new StringBuilder(1).append(BookmarksEnum$.MODULE$.COORDONNEE_Y().toString()).append("_").append((int)BoxesRunTime.unboxToDouble((Object)qualito.projection().get())).toString(), (Object)qualito.y().get().toString());
        }
        ((IterableOnceOps)qualito.link_locations().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)loc -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$24(m, loc);
            return BoxedUnit.UNIT;
        });
        this.logUtil.debug("Qualitometer coordinates with projection loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.COORDONNEE_X(), (Object)qualito.x().map((Function1 & Serializable)x$8 -> QualitoBookmarkBuilder.$anonfun$getMarkers$25(BoxesRunTime.unboxToDouble((Object)x$8))));
        m.add(BookmarksEnum$.MODULE$.COORDONNEE_Y(), (Object)qualito.y().map((Function1 & Serializable)x$9 -> QualitoBookmarkBuilder.$anonfun$getMarkers$26(BoxesRunTime.unboxToDouble((Object)x$9))));
        m.add(BookmarksEnum$.MODULE$.COORDONNEE_Z(), (Object)qualito.altitude().map((Function1 & Serializable)x$10 -> QualitoBookmarkBuilder.$anonfun$getMarkers$27(BoxesRunTime.unboxToDouble((Object)x$10))));
        qualito.projection().foreach((Function1)(JFunction1.mcVD.sp & Serializable)proj -> {
            m.add(BookmarksEnum$.MODULE$.C_PROJECTION(), (Object)BoxesRunTime.boxToDouble((double)proj));
            m.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.TYPE_PROJECTION(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.PROJECTION(), (List)Nil$.MODULE$)), (Object)ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.TYPEPROJECTION", (long)proj, sandreCodes));
        });
        this.logUtil.debug("Qualitometer projection loading completed", this.logUtil.debug$default$2());
        if (s2.fieldMode().isDefined()) {
            String sandreFieldMode;
            m.add(BookmarksEnum$.MODULE$.C_MODE_GIST(), (Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)s2.fieldMode().get()))));
            String string = sandreFieldMode = ReferentialUtil$.MODULE$.getSandreLabel("PIEZOMETRES.MODEGISEMENT", (long)BoxesRunTime.unboxToDouble((Object)s2.fieldMode().get()), sandreCodes);
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                m.add(BookmarksEnum$.MODULE$.MODE_GISEMENT(), (Object)sandreFieldMode);
            } else {
                m.add(BookmarksEnum$.MODULE$.MODE_GISEMENT(), (Object)"test");
            }
        }
        this.logUtil.debug("Qualitometer gisement mode loading completed", this.logUtil.debug$default$2());
        if (eventList.nonEmpty()) {
            eventList.foreach((Function1 & Serializable)c -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$29(m, c);
                return BoxedUnit.UNIT;
            });
        }
        this.logUtil.debug("Qualitometer events loading completed", this.logUtil.debug$default$2());
        m.concat(BookmarksEnum$.MODULE$.COMMENTAIRE(), s2.comment());
        m.add(BookmarksEnum$.MODULE$.COMMENTAIRE_QUALITO(), s2.comment());
        this.piezometerDaeau.find(s2.code()).foreach((Function1 & Serializable)piezo -> {
            m.add(BookmarksEnum$.MODULE$.COMMENTAIRE_PIEZO(), (Object)piezo.comment());
            return BoxedUnit.UNIT;
        });
        this.logUtil.debug("Qualitometer comments loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.C_COMMUNE(), s2.townCode());
        m.add(BookmarksEnum$.MODULE$.ADRESSE(), s2.address());
        m.add(BookmarksEnum$.MODULE$.LOCALISATION(), s2.location());
        this.logUtil.debug("Qualitometer localisation loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.C_PAYS(), s2.countryCode());
        this.logUtil.debug("Qualitometer country code loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.C_BASSIN_VERSANT(), s2.watershed());
        m.add(BookmarksEnum$.MODULE$.C_BASSIN_VERSANT2(), s2.watershed2());
        m.add(BookmarksEnum$.MODULE$.C_BASSIN_VERSANT3(), s2.watershed3());
        m.add(BookmarksEnum$.MODULE$.C_BASSIN_VERSANT4(), s2.watershed4());
        this.logUtil.debug("Qualitometer watershed code loading completed", this.logUtil.debug$default$2());
        if (s2.watershed().isDefined() && lbv.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.L_BASSIN_VERSANT(), (Object)lbv);
        }
        if (s2.watershed().isDefined() && lbv2.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.L_BASSIN_VERSANT2(), (Object)lbv2);
        }
        if (s2.watershed().isDefined() && lbv3.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.L_BASSIN_VERSANT3(), (Object)lbv3);
        }
        if (s2.watershed().isDefined() && lbv4.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.L_BASSIN_VERSANT4(), (Object)lbv4);
        }
        m.add(BookmarksEnum$.MODULE$.SUP_BASSIN(), s2.watershedSurfaceArea());
        this.logUtil.debug("Qualitometer watershed label loading completed", this.logUtil.debug$default$2());
        if (qualito.stateCode().isDefined()) {
            String sandreEtat;
            m.add(BookmarksEnum$.MODULE$.CODE_ETAT(), (Object)qualito.stateCode());
            String string = sandreEtat = ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.CODEETAT", (long)BoxesRunTime.unboxToDouble((Object)qualito.stateCode().get()), sandreCodes);
            String string3 = "";
            if (string == null ? string3 != null : !string.equals(string3)) {
                m.add(BookmarksEnum$.MODULE$.LIB_ETAT(), (Object)sandreEtat);
            }
        }
        this.logUtil.debug("Qualitometer state loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.PROF_DEBUT(), s2.startDepth());
        m.add(BookmarksEnum$.MODULE$.PROF_FIN(), s2.endDepth());
        m.add(BookmarksEnum$.MODULE$.PROF_RECOMMANDEE(), s2.recommendDepth());
        this.logUtil.debug("Qualitometer depth loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.RIVIERE(), s2.river());
        m.add(BookmarksEnum$.MODULE$.FINALITE(), s2.finality());
        m.add(BookmarksEnum$.MODULE$.C_HER_NIVEAU1(), s2.her1());
        s2.her1().foreach((Function1)(JFunction1.mcVD.sp & Serializable)her1 -> m.add(BookmarksEnum$.MODULE$.HER_NIVEAU1(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.HER1", (long)her1, sandreCodes)));
        m.add(BookmarksEnum$.MODULE$.C_HER_NIVEAU2(), s2.her2());
        s2.her2().foreach((Function1)(JFunction1.mcVD.sp & Serializable)her2 -> m.add(BookmarksEnum$.MODULE$.HER_NIVEAU2(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.HER2", (long)her2, sandreCodes)));
        this.logUtil.debug("Qualitometer HER and Finality loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.PK(), s2.pk());
        if (s2.strahlerRank().isDefined()) {
            String sandreStrahler;
            m.add(BookmarksEnum$.MODULE$.C_RANG_STRAHLER(), s2.strahlerRank());
            m.add(BookmarksEnum$.MODULE$.VALEUR_STRAHLER(), s2.strahlerValue());
            String string = sandreStrahler = ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.RANG_STRAHLER", (long)BoxesRunTime.unboxToDouble((Object)s2.strahlerRank().get()), sandreCodes);
            String string4 = "";
            if (string == null ? string4 != null : !string.equals(string4)) {
                m.add(BookmarksEnum$.MODULE$.RANG_STRAHLER(), (Object)sandreStrahler);
            }
        }
        this.logUtil.debug("Qualitometer Strahler loading completed", this.logUtil.debug$default$2());
        m.add(BookmarksEnum$.MODULE$.PENTE(), s2.slope());
        m.add(BookmarksEnum$.MODULE$.C_TYPE_FR(), s2.frType());
        s2.frType().foreach((Function1)(JFunction1.mcVD.sp & Serializable)fr -> {
            if (qualito.stationType().contains((Object)"2")) {
                m.add(BookmarksEnum$.MODULE$.TYPE_FR(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.TYPE_FR.PLAN", (long)fr, sandreCodes));
                return;
            }
            m.add(BookmarksEnum$.MODULE$.TYPE_FR(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.TYPE_FR.RIVIERE", (long)fr, sandreCodes));
        });
        s2.qualitometerType().foreach((Function1)(JFunction1.mcVD.sp & Serializable)qt -> m.add(BookmarksEnum$.MODULE$.TYPE_QUALITO(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("TYPE_QUALITOMETRE", (long)qt, sandreCodes)));
        m.add(BookmarksEnum$.MODULE$.NIV_TYPOLOGIQUE_THEO(), s2.niveautypologiquetheo());
        m.add(BookmarksEnum$.MODULE$.C_CALCIUM(), s2.calciumClass());
        s2.calciumClass().foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> m.add(BookmarksEnum$.MODULE$.CALCIUM(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("CALCIUM", (long)c, sandreCodes)));
        m.add(BookmarksEnum$.MODULE$.C_CTX_PISCICOLE(), s2.fishCode());
        s2.fishCode().foreach((Function1)(JFunction1.mcVI.sp & Serializable)fish -> m.add(BookmarksEnum$.MODULE$.CTX_PISCICOLE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("QUALITOMETRES.CONTEXTEPISCICOLE", (long)fish, sandreCodes)));
        if (s2.contactCode().isDefined()) {
            m.add(BookmarksEnum$.MODULE$.C_CONTACT(), (Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)s2.contactCode().get()))));
            Option contact = this.contactDao.get((int)BoxesRunTime.unboxToDouble((Object)s2.contactCode().get()));
            if (contact.isDefined()) {
                m.add(BookmarksEnum$.MODULE$.NOM_CONTACT(), (Object)((Contact)contact.get()).name());
                m.add(BookmarksEnum$.MODULE$.COMMENT_CONTACT(), (Object)((Contact)contact.get()).comment());
                m.add(BookmarksEnum$.MODULE$.ADRESSE_CONTACT(), (Object)((Contact)contact.get()).address());
                m.add(BookmarksEnum$.MODULE$.TEL_CONTACT(), (Object)((Contact)contact.get()).phoneTel());
                m.add(BookmarksEnum$.MODULE$.BUREAU_CONTACT(), (Object)((Contact)contact.get()).desktopTel());
                m.add(BookmarksEnum$.MODULE$.PORTABLE_CONTACT(), (Object)((Contact)contact.get()).mobile());
                m.add(BookmarksEnum$.MODULE$.EMAIL_CONTACT(), (Object)((Contact)contact.get()).email());
                if (((Contact)contact.get()).cityCode().isDefined()) {
                    Option option2 = this.cityDao.get((String)((Contact)contact.get()).cityCode().get());
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        CityWithLinks c2 = (CityWithLinks)some.value();
                        m.add(BookmarksEnum$.MODULE$.VILLE_CONTACT(), (Object)c2.name());
                    } else if (None$.MODULE$.equals(option2)) {
                    } else {
                        throw new MatchError((Object)option2);
                    }
                }
            }
        }
        this.logUtil.debug("Qualitometer contact loading completed", this.logUtil.debug$default$2());
        Option<String> option3 = s2.townCode();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String t = (String)some.value();
            String dep = t.substring(0, 2);
            m.add(BookmarksEnum$.MODULE$.DEPARTEMENT(), (Object)dep);
            Option option4 = this.cityDao.get((String)s2.townCode().get());
            if (option4 instanceof Some) {
                Some some2 = (Some)option4;
                CityWithLinks c3 = (CityWithLinks)some2.value();
                m.add(BookmarksEnum$.MODULE$.COMMUNE(), (Object)c3.name());
            } else if (None$.MODULE$.equals(option4)) {
            } else {
                throw new MatchError((Object)option4);
            }
        }
        this.logUtil.debug("Qualitometer city loading completed", this.logUtil.debug$default$2());
        Seq linkedWaterMass = (Seq)qualito.link_watermasses().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        Seq altimetryList = (Seq)((SeqOps)qualito.link_altimetrySystems().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$39(x$11)), (Ordering)Ordering.Long$.MODULE$);
        Seq linkedNetworks = (Seq)((SeqOps)qualito.link_networks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$43(x$13)), (Ordering)Ordering.Long$.MODULE$);
        Seq hydroEntity = (Seq)qualito.link_hydroEntity().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        Option aquifer = ((IterableOps)qualito.link_aquifers().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).headOption();
        QualityFilter filter = new QualityFilter((Option)new Some((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{(int)s2.id()}))), QualityFilter$.MODULE$.$lessinit$greater$default$2(), QualityFilter$.MODULE$.$lessinit$greater$default$3(), QualityFilter$.MODULE$.$lessinit$greater$default$4(), QualityFilter$.MODULE$.$lessinit$greater$default$5(), QualityFilter$.MODULE$.$lessinit$greater$default$6(), QualityFilter$.MODULE$.$lessinit$greater$default$7(), QualityFilter$.MODULE$.$lessinit$greater$default$8(), QualityFilter$.MODULE$.$lessinit$greater$default$9(), QualityFilter$.MODULE$.$lessinit$greater$default$10(), QualityFilter$.MODULE$.$lessinit$greater$default$11(), QualityFilter$.MODULE$.$lessinit$greater$default$12(), QualityFilter$.MODULE$.$lessinit$greater$default$13(), QualityFilter$.MODULE$.$lessinit$greater$default$14(), QualityFilter$.MODULE$.$lessinit$greater$default$15(), QualityFilter$.MODULE$.$lessinit$greater$default$16(), QualityFilter$.MODULE$.$lessinit$greater$default$17(), QualityFilter$.MODULE$.$lessinit$greater$default$18(), QualityFilter$.MODULE$.$lessinit$greater$default$19(), QualityFilter$.MODULE$.$lessinit$greater$default$20(), QualityFilter$.MODULE$.$lessinit$greater$default$21(), QualityFilter$.MODULE$.$lessinit$greater$default$22(), QualityFilter$.MODULE$.$lessinit$greater$default$23(), QualityFilter$.MODULE$.$lessinit$greater$default$24(), QualityFilter$.MODULE$.$lessinit$greater$default$25(), QualityFilter$.MODULE$.$lessinit$greater$default$26(), QualityFilter$.MODULE$.$lessinit$greater$default$27(), QualityFilter$.MODULE$.$lessinit$greater$default$28(), QualityFilter$.MODULE$.$lessinit$greater$default$29(), QualityFilter$.MODULE$.$lessinit$greater$default$30(), QualityFilter$.MODULE$.$lessinit$greater$default$31(), QualityFilter$.MODULE$.$lessinit$greater$default$32(), QualityFilter$.MODULE$.$lessinit$greater$default$33(), QualityFilter$.MODULE$.$lessinit$greater$default$34(), QualityFilter$.MODULE$.$lessinit$greater$default$35(), QualityFilter$.MODULE$.$lessinit$greater$default$36(), QualityFilter$.MODULE$.$lessinit$greater$default$37());
        Seq operations = (Seq)this.qualityDao.getOperations(filter).sortBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$48(x$15)), (Ordering)Ordering.Long$.MODULE$);
        Option qPoint_water = ((IterableOps)((SeqOps)this.qualitometerPointDao.find(s2.id(), (Option<String>)Option$.MODULE$.apply((Object)"031")).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$50(x$16)), (Ordering)Ordering.Long$.MODULE$)).headOption();
        Option qPoint_fish = ((IterableOps)((SeqOps)this.qualitometerPointDao.find(s2.id(), (Option<String>)Option$.MODULE$.apply((Object)"41")).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$54(x$18)), (Ordering)Ordering.Long$.MODULE$)).headOption();
        if (operations.nonEmpty()) {
            m.add(BookmarksEnum$.MODULE$.OP_MIN(), (Object)DateUtil$.MODULE$.getDate(((QualityOperation)operations.head()).date()));
            m.add(BookmarksEnum$.MODULE$.OP_MAX(), (Object)DateUtil$.MODULE$.getDate(((QualityOperation)operations.last()).date()));
            m.add(BookmarksEnum$.MODULE$.OP_NB(), (Object)BoxesRunTime.boxToInteger((int)operations.length()));
        }
        if ((option = aquifer) instanceof Some) {
            Some some = (Some)option;
            StationAquifer a = (StationAquifer)some.value();
            m.add(BookmarksEnum$.MODULE$.C_AQUIFERE(), (Object)a.aquiferCode());
            m.add(BookmarksEnum$.MODULE$.COMMENT_AQUIFERE(), (Object)a.comment());
            Option completeAquifer = this.aquiferDao.getAquifer(a.aquiferCode().get().toString());
            if (completeAquifer.isDefined()) {
                m.add(BookmarksEnum$.MODULE$.AQUIFERE(), ((Aquifer)completeAquifer.get()).name().getOrElse((Function0 & Serializable)() -> ""));
                m.add(BookmarksEnum$.MODULE$.C_MARGAT_AQUIFERE(), ((Aquifer)completeAquifer.get()).margatCode().getOrElse((Function0 & Serializable)() -> ""));
            }
        }
        qualito.link_watermasses().flatMap((Function1 & Serializable)wat -> wat.headOption().map((Function1 & Serializable)w -> w.watermassCode())).foreach((Function1 & Serializable)w -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$61(this, m, w);
            return BoxedUnit.UNIT;
        });
        m.add(BookmarksEnum$.MODULE$.C_CODE_HYDRO(), s2.hydroCode());
        if (hydroEntity.nonEmpty()) {
            m.add(BookmarksEnum$.MODULE$.ENTITE_HYDRO(), (Object)((StationHydroEntity)hydroEntity.head()).hydrologicalEntity().getOrElse((Function0 & Serializable)() -> "").toString());
        }
        if (qPoint_water.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.PROF_RECOMMANDEE_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).recommendedDepth());
            m.add(BookmarksEnum$.MODULE$.PROF_FIN_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).endDepth());
            m.add(BookmarksEnum$.MODULE$.PROF_DEBUT_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).startDepth());
            m.add(BookmarksEnum$.MODULE$.X_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).xWater());
            m.add(BookmarksEnum$.MODULE$.Y_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).yWater());
            m.add(BookmarksEnum$.MODULE$.COMMENTAIRE_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).comment());
            m.add(BookmarksEnum$.MODULE$.X_AMONT_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).xUphill());
            m.add(BookmarksEnum$.MODULE$.Y_AMONT_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).yUphill());
            m.add(BookmarksEnum$.MODULE$.X_AVAL_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).xDownstream());
            m.add(BookmarksEnum$.MODULE$.Y_AVAL_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).yDownstream());
            m.add(BookmarksEnum$.MODULE$.LARGEUR_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).totalLength());
            m.add(BookmarksEnum$.MODULE$.LONGUEUR_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).flowWidth());
            m.add(BookmarksEnum$.MODULE$.RECOM_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).recommendation());
            m.add(BookmarksEnum$.MODULE$.OBJET_EAU(), ((QualitometerPoint)Option$.MODULE$.option2Iterable(qPoint_water).head()).mainItem());
        }
        this.logUtil.debug("Qualitometer point on Water Support (031) attributes loading completed", this.logUtil.debug$default$2());
        if (qPoint_fish.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.PROF_RECOMMANDEE_POI(), ((QualitometerPoint)qPoint_fish.get()).recommendedDepth());
            m.add(BookmarksEnum$.MODULE$.PROF_FIN_POI(), ((QualitometerPoint)qPoint_fish.get()).endDepth());
            m.add(BookmarksEnum$.MODULE$.PROF_DEBUT_POI(), ((QualitometerPoint)qPoint_fish.get()).startDepth());
            m.add(BookmarksEnum$.MODULE$.X_POI(), ((QualitometerPoint)qPoint_fish.get()).xWater());
            m.add(BookmarksEnum$.MODULE$.Y_POI(), ((QualitometerPoint)qPoint_fish.get()).yWater());
            m.add(BookmarksEnum$.MODULE$.COMMENTAIRE_POI(), ((QualitometerPoint)qPoint_fish.get()).comment());
            m.add(BookmarksEnum$.MODULE$.X_AMONT_POI(), ((QualitometerPoint)qPoint_fish.get()).xUphill());
            m.add(BookmarksEnum$.MODULE$.Y_AMONT_POI(), ((QualitometerPoint)qPoint_fish.get()).yUphill());
            m.add(BookmarksEnum$.MODULE$.X_AVAL_POI(), ((QualitometerPoint)qPoint_fish.get()).xDownstream());
            m.add(BookmarksEnum$.MODULE$.Y_AVAL_POI(), ((QualitometerPoint)qPoint_fish.get()).yDownstream());
            m.add(BookmarksEnum$.MODULE$.LARGEUR_POI(), ((QualitometerPoint)qPoint_fish.get()).totalLength());
            m.add(BookmarksEnum$.MODULE$.LONGUEUR_POI(), ((QualitometerPoint)qPoint_fish.get()).flowWidth());
            m.add(BookmarksEnum$.MODULE$.RECOM_POI(), ((QualitometerPoint)qPoint_fish.get()).recommendation());
            m.add(BookmarksEnum$.MODULE$.OBJET_POI(), ((QualitometerPoint)qPoint_fish.get()).mainItem());
        }
        this.logUtil.debug("Qualitometer point on Fish Support (031) attributes loading completed", this.logUtil.debug$default$2());
        qualito.link_networks().foreach((Function1 & Serializable)networkLinks -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$64(this, m, networkLinks);
            return BoxedUnit.UNIT;
        });
        qualito.link_contributors().foreach((Function1 & Serializable)link_contribs -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$79(this, sandreCodes, m, link_contribs);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)((SeqOps)qualito.link_arrangements().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$107(x$24)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)arrangement -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$110(this, m, sandreCodes, arrangement);
            return BoxedUnit.UNIT;
        });
        if (linkedContributorProducers.nonEmpty()) {
            String producers = ((IterableOnceOps)linkedContributorProducers.map((Function1 & Serializable)x$26 -> (String)x$26.name().getOrElse((Function0 & Serializable)() -> ""))).mkString(",");
            m.add(BookmarksEnum$.MODULE$.PRODUCTEURS_NOM(), (Object)producers);
        }
        ((IterableOps)((SeqOps)qualito.link_accessibilities().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$27 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$117(x$27)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)access -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$120(m, sandreCodes, access);
            return BoxedUnit.UNIT;
        });
        qualito.link_usages().flatMap((Function1 & Serializable)x$29 -> ((IterableOps)x$29.sortBy((Function1 & Serializable)x$30 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$123(x$30)), (Ordering)Ordering.Long$.MODULE$)).lastOption()).foreach((Function1 & Serializable)usage -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$126(m, sandreCodes, usage);
            return BoxedUnit.UNIT;
        });
        qualito.link_measureMethod().flatMap((Function1 & Serializable)x$32 -> x$32.headOption()).foreach((Function1 & Serializable)measureMethod -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$129(m, sandreCodes, qualito, measureMethod);
            return BoxedUnit.UNIT;
        });
        qualito.link_work().flatMap((Function1 & Serializable)x$36 -> x$36.headOption()).foreach((Function1 & Serializable)work -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$142(m, work);
            return BoxedUnit.UNIT;
        });
        Option installation = linkedStations.find((Function1 & Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$143(x$37))).flatMap((Function1 & Serializable)link -> $this.installationDao.get(link.stationLinkedId()));
        BooleanRef hasCrepines = BooleanRef.create((boolean)false);
        installation.foreach((Function1 & Serializable)i -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$145(this, m, hasCrepines, i);
            return BoxedUnit.UNIT;
        });
        if (!hasCrepines.elem) {
            ((IterableOps)qualito.link_casings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).headOption().foreach((Function1 & Serializable)c -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$161(this, m, c);
                return BoxedUnit.UNIT;
            });
            ((IterableOps)qualito.link_casings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).lastOption().foreach((Function1 & Serializable)c -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$165(this, m, c);
                return BoxedUnit.UNIT;
            });
        }
        Option ass2 = ((IterableOps)((SeqOps)this.CentralQualitometerAssignmentDao.getQualitometerAssignements((int)BoxesRunTime.unboxToDouble((Object)qualito.id().get())).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$168(s)))).sortBy((Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$169(s)), (Ordering)Ordering.Long$.MODULE$)).lastOption();
        ass2.flatMap((Function1 & Serializable)ass -> ass.idCentral()).flatMap((Function1 & Serializable)idCentral -> this.centralDao.getCentral(BoxesRunTime.unboxToInt((Object)idCentral))).foreach((Function1 & Serializable)central -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$173(this, m, ass2, central);
            return BoxedUnit.UNIT;
        });
        Option ass22 = ((IterableOps)((SeqOps)this.SensorQualitometerAssignmentDao.getQualitometerAssignements((int)BoxesRunTime.unboxToDouble((Object)qualito.id().get())).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$178(s)))).sortBy((Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$179(s)), (Ordering)Ordering.Long$.MODULE$)).lastOption();
        ass22.flatMap((Function1 & Serializable)ass -> $this.sensorDao.getSensor(ass.idSensor())).foreach((Function1 & Serializable)sensor -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$182(this, m, ass22, sensor);
            return BoxedUnit.UNIT;
        });
        if (linkedContributorOperator.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.REF_CONTRAT(), (Object)((QualitometerContributorWithSiret)linkedContributorOperator.get()).internalReference());
            m.add(BookmarksEnum$.MODULE$.EXPLOITANT(), (Object)((QualitometerContributorWithSiret)linkedContributorOperator.get()).name());
            m.add(BookmarksEnum$.MODULE$.EXPLOITANT_NOM(), (Object)((QualitometerContributorWithSiret)linkedContributorOperator.get()).name());
            m.add(BookmarksEnum$.MODULE$.EXPLOITANT_SIRET(), (Object)((QualitometerContributorWithSiret)linkedContributorOperator.get()).siret());
        }
        if (linkedContributorAuthority.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.MAITRE_OUVRAGE_NOM(), (Object)((QualitometerContributorWithSiret)linkedContributorAuthority.get()).name());
            m.add(BookmarksEnum$.MODULE$.MAITRE_OUVRAGE_SIRET(), (Object)((QualitometerContributorWithSiret)linkedContributorAuthority.get()).siret());
        }
        if (linkedContributorOwner.isDefined()) {
            m.add(BookmarksEnum$.MODULE$.PROPRIETAIRE_NOM(), (Object)((QualitometerContributorWithSiret)linkedContributorOwner.get()).name());
            m.add(BookmarksEnum$.MODULE$.PROPRIETAIRE_SIRET(), (Object)((QualitometerContributorWithSiret)linkedContributorOwner.get()).siret());
        }
        this.logUtil.debug("Qualitometer installation loading completed", this.logUtil.debug$default$2());
    }

    public String getStationType(int typeCode) {
        int n;
        int n2 = n = typeCode;
        switch (n2) {
            case 0: {
                return new StringBuilder(24).append("Point eau souterraine [").append(n).append("]").toString();
            }
            case 1: {
                return new StringBuilder(14).append("Cours d'eau [").append(n).append("]").toString();
            }
            case 2: {
                return new StringBuilder(13).append("Plan d'eau [").append(n).append("]").toString();
            }
            case 3: {
                return new StringBuilder(20).append("Grand cours d'eau [").append(n).append("]").toString();
            }
            case 4: {
                return new StringBuilder(15).append("Milieu marin [").append(n).append("]").toString();
            }
            case 5: {
                return new StringBuilder(31).append("Autre cours d'eau et ravines [").append(n).append("]").toString();
            }
            case 6: {
                return new StringBuilder(9).append("Source [").append(n).append("]").toString();
            }
            case 7: {
                return new StringBuilder(17).append("Eau distribu\u00e9e [").append(n).append("]").toString();
            }
            case 8: {
                return new StringBuilder(14).append("Eau trait\u00e9e [").append(n).append("]").toString();
            }
            case 9: {
                return new StringBuilder(24).append("Unit\u00e9 de distribution [").append(n).append("]").toString();
            }
            case 10: {
                return new StringBuilder(21).append("Unit\u00e9 de production[").append(n).append("]").toString();
            }
            case 11: {
                return new StringBuilder(12).append("R\u00e9servoir [").append(n).append("]").toString();
            }
        }
        return "";
    }

    public static final /* synthetic */ String $anonfun$getMarkers$2(QualitoBookmarkBuilder $this, double w) {
        return (String)$this.watershedDao.get(w).flatMap((Function1 & Serializable)x$1 -> x$1.name()).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ String $anonfun$getMarkers$5(QualitoBookmarkBuilder $this, double w) {
        return (String)$this.watershedDao.get(w).flatMap((Function1 & Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ String $anonfun$getMarkers$8(QualitoBookmarkBuilder $this, double w) {
        return (String)$this.watershedDao.get(w).flatMap((Function1 & Serializable)x$3 -> x$3.name()).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ String $anonfun$getMarkers$11(QualitoBookmarkBuilder $this, double w) {
        return (String)$this.watershedDao.get(w).flatMap((Function1 & Serializable)x$4 -> x$4.name()).getOrElse((Function0 & Serializable)() -> "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getMarkers$16(SandreCode picType$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String[] attributes = (String[])tuple2._2();
        Option option = (Option)Predef$.MODULE$.wrapRefArray((Object[])attributes).lift().apply((Object)BoxesRunTime.boxToInteger((int)1));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        String t = (String)some.value();
        String string = ((String)picType$1.mnemonique().getOrElse((Function0 & Serializable)() -> picType$1.name())).toUpperCase();
        String string2 = t.toUpperCase();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = picType$1.name().toUpperCase();
        String string4 = t.toUpperCase();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ long $anonfun$getMarkers$19(Tuple2 x$5) {
        return ((FileOutput)x$5._1()).updateDate();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$20(SandreCode picType$1, MapOfBookmarks m$1, Tuple2 pic) {
        Predef$.MODULE$.println((Object)new StringBuilder(15).append(" add key PHOTO_").append(picType$1.code()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(15).append(" add key PHOTO_").append(picType$1.name().toUpperCase()).toString());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(6).append("PHOTO_").append(picType$1.code()).toString(), (List)new .colon.colon((Object)new StringBuilder(6).append("PHOTO_").append(picType$1.name().toUpperCase()).toString(), (List)Nil$.MODULE$)), ((FileOutput)pic._1()).url().replace(" ", "%20"));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$15(Seq picturesFormated$1, MapOfBookmarks m$1, SandreCode picType) {
        Seq picturesWithType = (Seq)picturesFormated$1.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$16(picType, x0$1)));
        ((IterableOps)((SeqOps)picturesWithType.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])p._2()), (Object)"1")))).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$19(x$5)), (Ordering)Ordering.Long$.MODULE$)).lastOption().foreach((Function1 & Serializable)pic -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$20(picType, m$1, pic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$24(MapOfBookmarks m$1, StationLocation loc) {
        Tuple3 tuple3 = new Tuple3((Object)loc.projection(), (Object)loc.x(), (Object)loc.y());
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                double proj = BoxesRunTime.unboxToDouble((Object)some.value());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    double x = BoxesRunTime.unboxToDouble((Object)some2.value());
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        double y = BoxesRunTime.unboxToDouble((Object)some3.value());
                        m$1.add(new StringBuilder(0).append(BookmarksEnum$.MODULE$.COORDONNEE_X_().toString()).append(Integer.toString((int)proj)).toString(), (Object)Double.toString(x));
                        m$1.add(new StringBuilder(0).append(BookmarksEnum$.MODULE$.COORDONNEE_Y_().toString()).append(Integer.toString((int)proj)).toString(), (Object)Double.toString(y));
                        return;
                    }
                }
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ String $anonfun$getMarkers$25(double x$8) {
        return Double.toString(x$8);
    }

    public static final /* synthetic */ String $anonfun$getMarkers$26(double x$9) {
        return Double.toString(x$9);
    }

    public static final /* synthetic */ String $anonfun$getMarkers$27(double x$10) {
        return Double.toString(x$10);
    }

    public static final /* synthetic */ void $anonfun$getMarkers$29(MapOfBookmarks m$1, QualitometerEvent c) {
        Option eventDate = DateUtil$.MODULE$.getFullDate(c.date(), c.eventHour());
        String eventInfos = new StringBuilder(8).append("[").append(c.eventType()).append("] - ").append(eventDate.toString()).append(" - ").append(c.comment()).toString();
        m$1.concat(BookmarksEnum$.MODULE$.EVENEMENTS(), eventInfos);
    }

    public static final /* synthetic */ long $anonfun$getMarkers$39(AltimetrySystem x$11) {
        return BoxesRunTime.unboxToLong((Object)x$11.startDate().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$getMarkers$43(StationNetwork x$13) {
        return BoxesRunTime.unboxToLong((Object)x$13.startDate().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$getMarkers$48(QualityOperation x$15) {
        return x$15.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getMarkers$50(QualitometerPoint x$16) {
        return BoxesRunTime.unboxToLong((Object)x$16.start().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$getMarkers$54(QualitometerPoint x$18) {
        return BoxesRunTime.unboxToLong((Object)x$18.start().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$62(MapOfBookmarks m$1, Watermass watermass) {
        m$1.add(BookmarksEnum$.MODULE$.LIBELLE_MASSE_EAU(), (Object)watermass.label());
        m$1.add(BookmarksEnum$.MODULE$.CODE_MASSE_EAU_EU(), (Object)watermass.europeanCode());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$61(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, String w) {
        m$1.add(BookmarksEnum$.MODULE$.CODE_MASSE_EAU(), (Object)w);
        $this.watermassDao.get(w).foreach((Function1 & Serializable)watermass -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$62(m$1, watermass);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$getMarkers$67(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            StationNetwork n = (StationNetwork)tuple2._1();
            return BoxesRunTime.unboxToLong((Object)n.startDate().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$getMarkers$70(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Network n = (Network)tuple2._2();
            return n.code();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String printNet$1(Network n) {
        if (n.mnemonic().isDefined()) {
            return (String)n.mnemonic().get();
        }
        return (String)n.name().getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$75(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            StationNetwork link = (StationNetwork)tuple2._1();
            return link.endDate().isEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$77(Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            Network n = (Network)tuple2._2();
            return n.dce().isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)n.dce().get()));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getMarkers$64(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Seq networkLinks) {
        Seq networks = (Seq)networkLinks.flatMap((Function1 & Serializable)n -> $this.networkDao.getByIds(Option$.MODULE$.option2Iterable(n.idNetwork()).toSeq()).headOption().map((Function1 & Serializable)netFound -> new Tuple2(n, netFound)));
        if (networks.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)networks.maxBy((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$67(x0$2)), (Ordering)Ordering.Long$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Network lastNetwork = (Network)tuple2._2();
            Network lastNetwork2 = lastNetwork;
            m$1.add(BookmarksEnum$.MODULE$.C_RESEAU(), (Object)BoxesRunTime.boxToInteger((int)lastNetwork2.code()));
            m$1.add((Seq<Enumeration.Value>)new .colon.colon((Object)BookmarksEnum$.MODULE$.L_RESEAU(), (List)new .colon.colon((Object)BookmarksEnum$.MODULE$.RESEAU(), (List)Nil$.MODULE$)), (Object)lastNetwork2.name());
            m$1.add(BookmarksEnum$.MODULE$.M_RESEAU(), (Object)lastNetwork2.mnemonic());
            m$1.add(BookmarksEnum$.MODULE$.C_RESEAUX(), (Object)((IterableOnceOps)networks.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)QualitoBookmarkBuilder.$anonfun$getMarkers$70(x0$3)))).mkString(",\n\r"));
            m$1.add(BookmarksEnum$.MODULE$.L_RESEAUX(), (Object)((IterableOnceOps)networks.flatMap((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    Network n = (Network)tuple2._2();
                    return n.name();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n\r"));
            m$1.add(BookmarksEnum$.MODULE$.M_RESEAUX(), (Object)((IterableOnceOps)networks.flatMap((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    Network n = (Network)tuple2._2();
                    return n.mnemonic();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n\r"));
            m$1.add(BookmarksEnum$.MODULE$.COM_RESEAUX(), (Object)((IterableOnceOps)networks.flatMap((Function1 & Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 != null) {
                    Network n = (Network)tuple2._2();
                    return n.comment();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n\r"));
            Tuple2 tuple22 = networks.partition((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$75(x0$7)));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Seq actives = (Seq)tuple22._1();
            Seq ended = (Seq)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)actives, (Object)ended);
            Seq actives2 = (Seq)tuple23._1();
            Seq ended2 = (Seq)tuple23._2();
            if (actives2.nonEmpty()) {
                m$1.add(BookmarksEnum$.MODULE$.LISTE_RESEAUX(), (Object)((IterableOnceOps)actives2.map((Function1 & Serializable)x0$8 -> {
                    Tuple2 tuple2 = x0$8;
                    if (tuple2 != null) {
                        Network n = (Network)tuple2._2();
                        return QualitoBookmarkBuilder.printNet$1(n);
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(",\n\r"));
                if (actives2.exists((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$77(x0$9)))) {
                    m$1.add(BookmarksEnum$.MODULE$.DCE(), (Object)"X");
                }
            }
            if (ended2.nonEmpty()) {
                m$1.add(BookmarksEnum$.MODULE$.HISTO_RESEAUX(), (Object)((IterableOnceOps)ended2.map((Function1 & Serializable)x0$10 -> {
                    Tuple2 tuple2 = x0$10;
                    if (tuple2 != null) {
                        Network n = (Network)tuple2._2();
                        return QualitoBookmarkBuilder.printNet$1(n);
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(",\n\r"));
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$80(StationContributorLink l) {
        return l.contributorType().isDefined() && (l.endDate().isEmpty() || ((BaseDateTime)l.endDate().get()).getMillis() > new DateTime().getMillis());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$87(MapOfBookmarks m$1, String key$1, int cType$1, StationContributorLink link$2, ContributorWithLinks contrib) {
        m$1.add(new StringBuilder(2).append("C_").append(key$1).toString(), contrib.siret().getOrElse((Function0 & Serializable)() -> (String)contrib.sandre().getOrElse((Function0 & Serializable)() -> "")));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)key$1, (List)new .colon.colon((Object)new StringBuilder(4).append(key$1).append("_NOM").toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_NOM_").append(key$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_NOM_").append(cType$1).toString(), (List)Nil$.MODULE$)))), contrib.name());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(17).append("INTER_MNEMONIQUE_").append(key$1).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("INTER_MNEMONIQUE_").append(cType$1).toString(), (List)Nil$.MODULE$)), contrib.mnemonique());
        m$1.add(new StringBuilder(4).append("REF_").append(key$1).toString(), (Option<Object>)link$2.internalReference());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_BUR_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_BUR_").append(key$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_TEL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_TEL_").append(key$1).toString(), (List)Nil$.MODULE$)))), contrib.phoneTel().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(11).append("INTER_TEL2_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(11).append("INTER_TEL2_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.phoneTelSecond().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_FAX_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_FAX_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.fax().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(12).append("INTER_EMAIL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(12).append("INTER_EMAIL_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.email());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_MOB_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_MOB_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.mobile().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(10).append("INTER_ADD_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("INTER_ADD_").append(key$1).toString(), (List)Nil$.MODULE$)), ((IterableOnceOps)new .colon.colon((Object)contrib.postalBox(), (List)new .colon.colon((Object)contrib.road(), (List)new .colon.colon((Object)(contrib.postalCode().isDefined() ? contrib.postalCode() : contrib.department()), (List)new .colon.colon((Object)contrib.city(), (List)new .colon.colon((Object)contrib.addressComplement(), (List)Nil$.MODULE$))))).flatten(Predef$.MODULE$.$conforms())).mkString(", "));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(14).append("INTER_COMMUNE_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(14).append("INTER_COMMUNE_").append(key$1).toString(), (List)Nil$.MODULE$)), contrib.city());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$95(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, int cType$1, String key$1, Contact contact) {
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMENT_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMENT_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.comment());
        contact.cityCode().flatMap((Function1 & Serializable)city -> $this.cityDao.get(city)).foreach((Function1 & Serializable)city -> {
            m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMUNE_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("INTER_CT_COMMUNE_").append(key$1).toString(), (List)Nil$.MODULE$)), city.name());
            return BoxedUnit.UNIT;
        });
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_NOM_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_NOM_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.name());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_TEL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_TEL_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.phoneTel().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(14).append("INTER_CT_TEL2_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(14).append("INTER_CT_TEL2_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.phoneTelSecond().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_FAX_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_FAX_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.fax().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_MOB_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_MOB_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.mobile().map((Function1 & Serializable)s -> new StringBuilder(1).append("'").append((String)s).toString()));
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(15).append("INTER_CT_EMAIL_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("INTER_CT_EMAIL_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.email());
        m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_ADD_").append(cType$1).toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("INTER_CT_ADD_").append(key$1).toString(), (List)Nil$.MODULE$)), contact.address());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$86(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Tuple3 x0$12) {
        Tuple3 tuple3 = x0$12;
        if (tuple3 != null) {
            StationContributorLink link = (StationContributorLink)tuple3._1();
            Option contribOpt = (Option)tuple3._2();
            String key = (String)tuple3._3();
            int cType = (int)BoxesRunTime.unboxToDouble((Object)link.contributorType().get());
            contribOpt.foreach((Function1 & Serializable)contrib -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$87(m$1, key, cType, link, contrib);
                return BoxedUnit.UNIT;
            });
            link.contactCode().flatMap((Function1 & Serializable)ctCode -> $this.contactDao.get((int)BoxesRunTime.unboxToLong((Object)ctCode))).foreach((Function1 & Serializable)contact -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$95($this, m$1, cType, key, contact);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$104(Tuple3 x$23) {
        return ((Option)x$23._2()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$79(QualitoBookmarkBuilder $this, Seq sandreCodes$1, MapOfBookmarks m$1, Seq link_contribs) {
        Seq contribs = (Seq)((IterableOps)((IterableOps)((IterableOps)link_contribs.filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$80(l)))).map((Function1 & Serializable)link -> {
            if (link.idContributor().isEmpty()) {
                return new Tuple2(link, (Object)None$.MODULE$);
            }
            return (Tuple2)$this.contributorsDao.getWithId((int)BoxesRunTime.unboxToLong((Object)link.idContributor().get())).map((Function1 & Serializable)contrib -> new Tuple2(link, (Object)new Some(contrib))).getOrElse((Function0 & Serializable)() -> new Tuple2(link, (Object)None$.MODULE$));
        })).map((Function1 & Serializable)x0$11 -> {
            Tuple2 tuple2 = x0$11;
            if (tuple2 != null) {
                StationContributorLink link = (StationContributorLink)tuple2._1();
                Option contrib = (Option)tuple2._2();
                return new Tuple3((Object)link, (Object)contrib, (Object)ReferentialUtil$.MODULE$.getSandreLabel("LIEN_PIEZO_INTERVENANTS.TYPEINTERVENANT", (long)BoxesRunTime.unboxToDouble((Object)link.contributorType().get()), sandreCodes$1).toUpperCase().replace(" ", "_").replace("'", "_"));
            }
            throw new MatchError((Object)tuple2);
        })).filter((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)x$22._3()))));
        if (contribs.nonEmpty()) {
            contribs.foreach((Function1 & Serializable)x0$12 -> {
                QualitoBookmarkBuilder.$anonfun$getMarkers$86($this, m$1, x0$12);
                return BoxedUnit.UNIT;
            });
            Map groups = contribs.groupBy((Function1 & Serializable)x0$13 -> {
                Tuple3 tuple3 = x0$13;
                if (tuple3 != null) {
                    String key = (String)tuple3._3();
                    return key;
                }
                throw new MatchError((Object)tuple3);
            });
            groups.keys().foreach((Function1 & Serializable)key -> {
                m$1.addMulti((Seq<String>)new .colon.colon((Object)new StringBuilder(1).append(key).append("S").toString(), (List)new .colon.colon((Object)new StringBuilder(5).append(key).append("S_NOM").toString(), (List)Nil$.MODULE$)), ((IterableOnceOps)((IterableOps)((IterableOps)groups.apply((Object)key)).filter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$104(x$23)))).flatMap((Function1 & Serializable)x0$14 -> {
                    Tuple3 tuple3 = x0$14;
                    if (tuple3 != null) {
                        Option contrib = (Option)tuple3._2();
                        return ((ContributorWithLinks)contrib.get()).name();
                    }
                    throw new MatchError((Object)tuple3);
                })).mkString(", "));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$getMarkers$107(Arrangement x$24) {
        return BoxesRunTime.unboxToLong((Object)x$24.startDate().map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$110(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Seq sandreCodes$1, Arrangement arrangement) {
        m$1.add(BookmarksEnum$.MODULE$.AMENAGEMENT(), (Object)arrangement.descriptive());
        arrangement.keyCode().flatMap((Function1 & Serializable)key -> $this.BookmarksExportSpecificDao.getMatKeyName(BoxesRunTime.unboxToDouble((Object)key))).foreach((Function1 & Serializable)keyLabel -> {
            m$1.add(BookmarksEnum$.MODULE$.CLE_ACCES(), (Object)keyLabel);
            return BoxedUnit.UNIT;
        });
        arrangement.arrangementType().foreach((Function1)(JFunction1.mcVD.sp & Serializable)typeArr -> {
            m$1.add(BookmarksEnum$.MODULE$.TYPE_AMENAGEMENT(), (Object)BoxesRunTime.boxToDouble((double)typeArr));
            m$1.add(BookmarksEnum$.MODULE$.L_TYPE_AMENAGEMENT(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("AMENAGEMENT.TYPE_AMENAGEMENT", (long)typeArr, sandreCodes$1));
        });
    }

    public static final /* synthetic */ long $anonfun$getMarkers$117(Accessibilities x$27) {
        return BoxesRunTime.unboxToLong((Object)x$27.startDate().map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToLong((long)x$28.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$120(MapOfBookmarks m$1, Seq sandreCodes$1, Accessibilities access) {
        m$1.add(BookmarksEnum$.MODULE$.COND_ACCES(), (Object)access.description());
        access.codeCondition().foreach((Function1)(JFunction1.mcVD.sp & Serializable)cAccess -> {
            m$1.add(BookmarksEnum$.MODULE$.C_COND_ACCES(), (Object)BoxesRunTime.boxToDouble((double)cAccess));
            m$1.add(BookmarksEnum$.MODULE$.L_COND_ACCES(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("ACCESSIBILITES.TYPE_CONDITION", (long)cAccess, sandreCodes$1));
        });
    }

    public static final /* synthetic */ long $anonfun$getMarkers$123(Usage x$30) {
        return BoxesRunTime.unboxToLong((Object)x$30.startDate().map((Function1 & Serializable)x$31 -> BoxesRunTime.boxToLong((long)x$31.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$126(MapOfBookmarks m$1, Seq sandreCodes$1, Usage usage) {
        m$1.add(BookmarksEnum$.MODULE$.DESC_USAGE(), (Object)usage.descriptive());
        usage.usageCode().foreach((Function1)(JFunction1.mcVI.sp & Serializable)uCode -> m$1.add(BookmarksEnum$.MODULE$.LIB_USAGE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("USAGES", (long)uCode, sandreCodes$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$132(int periodicity$1, SandreCode s) {
        String string = s.field();
        String string2 = "MODES_MESURES.PERIODICITE";
        return !(string != null ? !string.equals(string2) : string2 != null) && s.code() == periodicity$1;
    }

    public static final /* synthetic */ void $anonfun$getMarkers$133(MapOfBookmarks m$1, SandreCode code) {
        m$1.add(BookmarksEnum$.MODULE$.C_PERIODICITE(), (Object)code.name());
        m$1.add(BookmarksEnum$.MODULE$.PERIODICITE(), (Object)code.comment());
    }

    public static final /* synthetic */ long $anonfun$getMarkers$135(Landmark x$33) {
        return BoxesRunTime.unboxToLong((Object)x$33.startDate().map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$129(MapOfBookmarks m$1, Seq sandreCodes$1, QualitometerWithLinks qualito$1, MeasureMethod measureMethod) {
        measureMethod.method().foreach((Function1)(JFunction1.mcVD.sp & Serializable)meth -> {
            m$1.add(BookmarksEnum$.MODULE$.C_METHODE(), (Object)BoxesRunTime.boxToInteger((int)((int)meth)));
            m$1.add(BookmarksEnum$.MODULE$.METHODE(), (Object)ReferentialUtil$.MODULE$.getSandreLabel("MODES_MESURES.METHODE", (long)meth, sandreCodes$1));
        });
        measureMethod.periodicity().foreach((Function1)(JFunction1.mcVI.sp & Serializable)periodicity -> sandreCodes$1.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$132(periodicity, s))).foreach((Function1 & Serializable)code -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$133(m$1, code);
            return BoxedUnit.UNIT;
        }));
        m$1.addDate(BookmarksEnum$.MODULE$.DEB_MESURE(), (Option<DateTime>)measureMethod.startDate());
        m$1.addDate(BookmarksEnum$.MODULE$.FIN_MESURE(), (Option<DateTime>)measureMethod.endDate());
        m$1.add(BookmarksEnum$.MODULE$.COM_MESURE(), (Object)measureMethod.comment());
        m$1.add(BookmarksEnum$.MODULE$.PROF_NAPPE(), (Object)measureMethod.depth());
        m$1.add(BookmarksEnum$.MODULE$.PROF_NIV_STATIQUE(), (Object)measureMethod.depth());
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_NIV_STATIQUE(), (Option<DateTime>)measureMethod.startDate());
        ((IterableOps)((SeqOps)qualito$1.link_landmarks().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable)x$33 -> BoxesRunTime.boxToLong((long)QualitoBookmarkBuilder.$anonfun$getMarkers$135(x$33)), (Ordering)Ordering.Long$.MODULE$)).lastOption().flatMap((Function1 & Serializable)x$35 -> x$35.height()).foreach((Function1)(JFunction1.mcVD.sp & Serializable)height -> m$1.add(BookmarksEnum$.MODULE$.NIV_STATIQUE(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)measureMethod.depth().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + height))));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$142(MapOfBookmarks m$1, StationWorkLink work) {
        m$1.add(BookmarksEnum$.MODULE$.TYPE_STATION(), (Object)work.stationType());
        m$1.add(BookmarksEnum$.MODULE$.TYPE_CAPTEUR(), (Object)work.sensorType());
        m$1.add(BookmarksEnum$.MODULE$.TEL_STATION(), (Object)work.phone());
        m$1.add(BookmarksEnum$.MODULE$.NUM_SERIE(), (Object)work.serialNumber());
        m$1.add(BookmarksEnum$.MODULE$.PROFONDEUR(), (Object)work.workDepth());
        m$1.add(BookmarksEnum$.MODULE$.PROFONDEUR_CAPTEUR(), (Object)work.sensorDepth());
        m$1.add(BookmarksEnum$.MODULE$.DIAM_INTERNE(), (Object)work.internalDiameter());
        m$1.add(BookmarksEnum$.MODULE$.DIAM_EXTERNE(), (Object)work.externalDiameter());
        m$1.add(BookmarksEnum$.MODULE$.COM_OUVRAGE(), (Object)work.comment());
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$143(StationLinkDetailed x$37) {
        return (int)x$37.stationLinkedType() == StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.INSTALLATION());
    }

    public static final /* synthetic */ void $anonfun$getMarkers$147(MapOfBookmarks m$1, ManagementUnitWithLinks uge) {
        m$1.add(BookmarksEnum$.MODULE$.UNITE_GESTION(), (Object)uge.id());
        m$1.add(BookmarksEnum$.MODULE$.NOM_UNITE_GESTION(), (Object)uge.name());
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$150(Casing x$38) {
        return x$38.strainers().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ double $anonfun$getMarkers$151(Casing c) {
        return BoxesRunTime.unboxToDouble((Object)c.startDepth().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble((Object)c.endDepth().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ void $anonfun$getMarkers$154(QualitoBookmarkBuilder $this, BooleanRef hasCrepines$1, MapOfBookmarks m$1, Casing c) {
        hasCrepines$1.elem = true;
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_H_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$157(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Casing c) {
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_F_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$148(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Installation i$1, BooleanRef hasCrepines$1, BoreholeWithLinks borehole) {
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_REALISATION(), (Option<DateTime>)i$1.creationDate());
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_SERVICE(), (Option<DateTime>)borehole.serviceDate());
        m$1.add(BookmarksEnum$.MODULE$.DEBIT_EXPLOITE(), (Object)borehole.allowedHourWaterFlow());
        m$1.add(BookmarksEnum$.MODULE$.DEBIT_EXPLOITE_ANNEE(), (Object)borehole.yearWaterFlow());
        m$1.addDate(BookmarksEnum$.MODULE$.DATE_ARRETE(), (Option<DateTime>)borehole.arrestDate());
        m$1.add(BookmarksEnum$.MODULE$.NUM_ARRETE(), (Object)borehole.arrestCode());
        m$1.add(BookmarksEnum$.MODULE$.VOL_ANNUEL_AUTORISE(), (Object)borehole.allowedYearWaterVolume());
        m$1.add(BookmarksEnum$.MODULE$.CIMENTATION_TUBAGE(), (Object)borehole.cementationTubing());
        m$1.add(BookmarksEnum$.MODULE$.TYPE_POMPE(), (Object)borehole.pumpType());
        Seq casings = (Seq)((SeqOps)((IterableOps)borehole.link_casings().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).filter((Function1 & Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)QualitoBookmarkBuilder.$anonfun$getMarkers$150(x$38)))).sortBy((Function1 & Serializable)c -> BoxesRunTime.boxToDouble((double)QualitoBookmarkBuilder.$anonfun$getMarkers$151(c)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        casings.headOption().foreach((Function1 & Serializable)c -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$154($this, hasCrepines$1, m$1, c);
            return BoxedUnit.UNIT;
        });
        casings.lastOption().foreach((Function1 & Serializable)c -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$157($this, m$1, c);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$145(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, BooleanRef hasCrepines$1, Installation i) {
        i.managementCode().flatMap((Function1 & Serializable)ugeCode -> $this.managementUnitsDao.getManagementUnit((int)BoxesRunTime.unboxToLong((Object)ugeCode))).foreach((Function1 & Serializable)uge -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$147(m$1, uge);
            return BoxedUnit.UNIT;
        });
        $this.InstallationBoreholeDao.getWithLinks((long)i.id()).foreach((Function1 & Serializable)borehole -> {
            QualitoBookmarkBuilder.$anonfun$getMarkers$148($this, m$1, i, hasCrepines$1, borehole);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$161(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Casing c) {
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_H_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_H_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getMarkers$165(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Casing c) {
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_DEBUT(), (Object)c.startDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_PROF_FIN(), (Object)c.endDepth());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_TOIT_AQUI(), (Object)c.aquiferRoof());
        m$1.add(BookmarksEnum$.MODULE$.CREP_F_FOND_AQUI(), (Object)c.aquiferFloor());
        c.aquiferCode().flatMap((Function1 & Serializable)a -> $this.aquiferDao.getAquifer(Integer.toString(BoxesRunTime.unboxToInt((Object)a)))).foreach((Function1 & Serializable)aq -> {
            m$1.add(BookmarksEnum$.MODULE$.CREP_F_AQUIFERE(), (Object)aq.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$168(CentralSituation s) {
        return s.situationEndDate().isEmpty() || ((BaseDateTime)s.situationEndDate().get()).getMillis() < new DateTime().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getMarkers$169(CentralSituation s) {
        return ((BaseDateTime)s.situationDate().getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1980))).getMillis();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$173(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Option ass$1, CentralOutput central) {
        m$1.add(BookmarksEnum$.MODULE$.CENTRALE(), (Object)central.serialNumber());
        m$1.add(BookmarksEnum$.MODULE$.CENTRALE_DATE(), (Object)((CentralSituation)ass$1.get()).situationDate());
        central.centralType().flatMap((Function1 & Serializable)ct -> $this.CentralTypeDao.getCentralType(BoxesRunTime.unboxToInt((Object)ct))).foreach((Function1 & Serializable)t -> {
            m$1.add(BookmarksEnum$.MODULE$.CENTRALE_TYPE(), (Object)t.name());
            return BoxedUnit.UNIT;
        });
        central.providerId().flatMap((Function1 & Serializable)provider -> $this.contributorsDao.getWithId(BoxesRunTime.unboxToInt((Object)provider))).foreach((Function1 & Serializable)provider -> {
            m$1.add(BookmarksEnum$.MODULE$.CENTRALE_FOURN(), (Object)provider.name());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMarkers$178(SensorSituation s) {
        return s.situationEndDate().isEmpty() || ((BaseDateTime)s.situationEndDate().get()).getMillis() < new DateTime().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getMarkers$179(SensorSituation s) {
        return ((BaseDateTime)s.situationDate().getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1980))).getMillis();
    }

    public static final /* synthetic */ void $anonfun$getMarkers$182(QualitoBookmarkBuilder $this, MapOfBookmarks m$1, Option ass2$1, SensorOutput sensor) {
        m$1.add(BookmarksEnum$.MODULE$.CAPTEUR(), (Object)sensor.serialNumber());
        m$1.add(BookmarksEnum$.MODULE$.CAPTEUR_DATE(), (Object)((SensorSituation)ass2$1.get()).situationDate());
        sensor.sensorType().flatMap((Function1 & Serializable)ct -> $this.SensorTypeDao.getSensorType(BoxesRunTime.unboxToInt((Object)ct))).foreach((Function1 & Serializable)t -> {
            m$1.add(BookmarksEnum$.MODULE$.CAPTEUR_TYPE(), (Object)t.name());
            return BoxedUnit.UNIT;
        });
        sensor.providerId().flatMap((Function1 & Serializable)provider -> $this.contributorsDao.getWithId(BoxesRunTime.unboxToInt((Object)provider))).foreach((Function1 & Serializable)provider -> {
            m$1.add(BookmarksEnum$.MODULE$.CAPTEUR_FOURN(), (Object)provider.name());
            return BoxedUnit.UNIT;
        });
    }

    @Inject
    public QualitoBookmarkBuilder(LogUtil logUtil, CityDao cityDao, AquiferDao aquiferDao, ContactDao contactDao, QualitometerPointDao qualitometerPointDao, QualitometerDao qualitometerDao, WatershedDao watershedDao, SandreCodeDao sandreCodeDao, ContributorsDao contributorsDao, LinkedStationDao linkedStationDao, NetworkDao networkDao, ContributorLinkDao contributorLinkDao, StationContributorDao stationContributorDao, WatermassDao watermassDao, QualitometerEventDao qualitometerEventDao, QualityDao qualityDao, BookmarksExportSpecificDao BookmarksExportSpecificDao2, MaterielCentralDao centralDao, CentralTypeDao CentralTypeDao2, SensorTypeDao SensorTypeDao2, CentralQualitometerAssignmentDao CentralQualitometerAssignmentDao2, MaterielSensorDao sensorDao, SensorQualitometerAssignmentDao SensorQualitometerAssignmentDao2, FileRPC FileRPC2, PiezometerDaeau piezometerDaeau, StationLinkDao stationLinkDao, InstallationDao installationDao, ManagementUnitsDao managementUnitsDao, InstallationBoreholeDao InstallationBoreholeDao2) {
        this.logUtil = logUtil;
        this.cityDao = cityDao;
        this.aquiferDao = aquiferDao;
        this.contactDao = contactDao;
        this.qualitometerPointDao = qualitometerPointDao;
        this.qualitometerDao = qualitometerDao;
        this.watershedDao = watershedDao;
        this.sandreCodeDao = sandreCodeDao;
        this.contributorsDao = contributorsDao;
        this.networkDao = networkDao;
        this.contributorLinkDao = contributorLinkDao;
        this.stationContributorDao = stationContributorDao;
        this.watermassDao = watermassDao;
        this.qualitometerEventDao = qualitometerEventDao;
        this.qualityDao = qualityDao;
        this.BookmarksExportSpecificDao = BookmarksExportSpecificDao2;
        this.centralDao = centralDao;
        this.CentralTypeDao = CentralTypeDao2;
        this.SensorTypeDao = SensorTypeDao2;
        this.CentralQualitometerAssignmentDao = CentralQualitometerAssignmentDao2;
        this.sensorDao = sensorDao;
        this.SensorQualitometerAssignmentDao = SensorQualitometerAssignmentDao2;
        this.FileRPC = FileRPC2;
        this.piezometerDaeau = piezometerDaeau;
        this.stationLinkDao = stationLinkDao;
        this.installationDao = installationDao;
        this.managementUnitsDao = managementUnitsDao;
        this.InstallationBoreholeDao = InstallationBoreholeDao2;
    }
}

