/*
 * Decompiled with CFR 0.152.
 */
package qesout.controller;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import dao.itf.AnalysisDao;
import fr.aquasys.daeau.export.qesout.QuesoutJournal;
import fr.aquasys.daeau.export.qesout.QuesoutJournalDao;
import fr.aquasys.daeau.job.itf.JobFileDao;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.PiezometerCode;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent;
import fr.aquasys.daeau.piezometry.model.measure.PiezometerChronicRawMeasure;
import fr.aquasys.daeau.quality.domain.input.SearchAnalysisInput;
import fr.aquasys.daeau.quality.domain.input.SearchAnalysisInput$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.quality.model.QualitometerLight;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.network.dao.NetworkDao;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.altimetrySystem.StationAltimetrySystemDao;
import fr.aquasys.daeau.station.links.despoliationMode.DespoliationMode;
import fr.aquasys.daeau.station.links.despoliationMode.StationDespoliationModeDao;
import fr.aquasys.daeau.station.links.functions.StationFunction;
import fr.aquasys.daeau.station.links.functions.StationFunctionDao;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.landmark.StationLandmarkDao;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.measureMethod.StationMeasureMethodDao;
import fr.aquasys.daeau.station.links.network.StationNetworkDao;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef;
import fr.aquasys.daeau.station.links.tempRef.StationTempRefDao;
import fr.aquasys.daeau.station.links.usages.StationUsageDao;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.user.domain.UserFilterWithLinks;
import fr.aquasys.daeau.user.itf.UserFilterDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.ExportRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.PiezometryUtils$;
import fr.aquasys.utils.StationTypeUtil$;
import fr.aquasys.utils.StringUtil$;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.db.Database;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import qesout.adesExportDao.AdesExportDao;
import qesout.model.ExportQesoutAnalysisOutput;
import qesout.model.ExportQesoutSampleOutput;
import qesout.model.QesoutFilter;
import qesout.model.QesoutFilter$;
import qesout.util.QesoutBuilder;
import qesout.util.QesoutMeasuresPiezoUtil$;
import qesout.util.QesoutQuality;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0005\r%e\u0001B\u0013'\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006Y!\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0006\r\"AA\n\u0001B\u0001B\u0003-Q\n\u0003\u0005S\u0001\t\u0005\t\u0015a\u0003T\u0011!i\u0006A!A!\u0002\u0017q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b1\u00022\t\u00111\u0004!\u0011!Q\u0001\f5D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006Y\u0001\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0006w\"Q\u00111\u0001\u0001\u0003\u0002\u0003\u0006Y!!\u0002\t\u0015\u0005]\u0001A!A!\u0002\u0017\tI\u0002\u0003\u0006\u0002&\u0001\u0011\t\u0011)A\u0006\u0003OA!\"a\r\u0001\u0005\u0003\u0005\u000b1BA\u001b\u0011)\t\u0019\u0005\u0001B\u0001B\u0003-\u0011Q\t\u0005\u000b\u0003\u0017\u0002!\u0011!Q\u0001\f\u00055\u0003BCA.\u0001\t\u0005\t\u0015a\u0003\u0002^!Q\u0011\u0011\u000e\u0001\u0003\u0002\u0003\u0006Y!a\u001b\t\u0015\u0005e\u0004A!A!\u0002\u0017\tY\b\u0003\u0006\u0002\n\u0002\u0011\t\u0011)A\u0006\u0003\u0017C!\"!%\u0001\u0005\u0003\u0005\u000b1BAJ\u0011)\t\t\u000b\u0001B\u0001B\u0003-\u00111\u0015\u0005\u000b\u0003_\u0003!\u0011!Q\u0001\f\u0005E\u0006BCA_\u0001\t\u0005\t\u0015a\u0003\u0002@\"Q\u00111\u001a\u0001\u0003\u0002\u0003\u0006Y!!4\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9!1\u0006\u0001\u0005B\t5\u0002b\u0002B2\u0001\u0011\u0005#Q\r\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011i\u0007\u0001C\u0007\u0005_BqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!91Q\u0002\u0001\u0005\u0002\rm\u0002bBB'\u0001\u0011\u00051q\n\u0005\b\u0007g\u0002A\u0011AB;\u0011\u001d\u0019I\b\u0001C!\u0007w\u0012\u0001#U3t_V$8i\u001c8ue>dG.\u001a:\u000b\u0005\u001dB\u0013AC2p]R\u0014x\u000e\u001c7fe*\t\u0011&\u0001\u0004rKN|W\u000f^\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\n1!\u00199j\u0013\t9DGA\u0003N_\u0012,G.A\u0004M_\u001e,F/\u001b7\u0011\u0005i\u001aU\"A\u001e\u000b\u0005qj\u0014\u0001B;uS2T!AP \u0002\u0011I\f'MY5u[FT!\u0001Q!\u0002\u000f\u0005\fX/Y:zg*\t!)\u0001\u0002ge&\u0011Ai\u000f\u0002\b\u0019><W\u000b^5m\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013~\nQ!\u001e;jYNL!a\u0013%\u0003\u0015){'\rT8h+RLG.A\u0007RKN|W\u000f\u001e\"vS2$WM\u001d\t\u0003\u001dBk\u0011a\u0014\u0006\u0003y!J!!U(\u0003\u001bE+7o\\;u\u0005VLG\u000eZ3s\u0003=\u0001\u0018.\u001a>p[\u0016$XM\u001d#bK\u0006,\bC\u0001+\\\u001b\u0005)&B\u0001,X\u0003\rIGO\u001a\u0006\u00031f\u000b!\u0002]5fu>lW\r\u001e:z\u0015\tQv(A\u0003eC\u0016\fW/\u0003\u0002]+\ny\u0001+[3{_6,G/\u001a:EC\u0016\fW/\u0001\u000bqS\u0016Tx.\\3uKJlU-Y:ve\u0016$\u0015m\u001c\t\u0003)~K!\u0001Y+\u0003)AKWM_8nKR,'/T3bgV\u0014X\rR1p\u0003I\tG\u000e^5nKR\u0014\u0018pU=ti\u0016lG)Y8\u0011\u0005\rTW\"\u00013\u000b\u0005\u00154\u0017aD1mi&lW\r\u001e:z'f\u001cH/Z7\u000b\u0005\u001dD\u0017!\u00027j].\u001c(BA5Z\u0003\u001d\u0019H/\u0019;j_:L!a\u001b3\u00033M#\u0018\r^5p]\u0006cG/[7fiJL8+_:uK6$\u0015m\\\u0001\fY\u0006tG-\\1sW\u0012\u000bw\u000e\u0005\u0002oc6\tqN\u0003\u0002qM\u0006AA.\u00198e[\u0006\u00148.\u0003\u0002s_\n\u00112\u000b^1uS>tG*\u00198e[\u0006\u00148\u000eR1p\u0003AiW-Y:ve\u0016lU\r\u001e5pI\u0012\u000bw\u000e\u0005\u0002vq6\taO\u0003\u0002xM\u0006iQ.Z1tkJ,W*\u001a;i_\u0012L!!\u001f<\u0003/M#\u0018\r^5p]6+\u0017m];sK6+G\u000f[8e\t\u0006|\u0017!E*uCRLwN\u001c(fi^|'o\u001b#b_B\u0011Ap`\u0007\u0002{*\u0011aPZ\u0001\b]\u0016$xo\u001c:l\u0013\r\t\t! \u0002\u0012'R\fG/[8o\u001d\u0016$xo\u001c:l\t\u0006|\u0017A\u0003(fi^|'o\u001b#b_B!\u0011qAA\n\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011a\u00013b_*\u0019a0a\u0004\u000b\u0007\u0005E\u0011,\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7/\u0003\u0003\u0002\u0016\u0005%!A\u0003(fi^|'o\u001b#b_\u000612\u000f^1uS>tG)Z:q_2L\u0017\r^5p]\u0012\u000bw\u000e\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyBZ\u0001\u0011I\u0016\u001c\bo\u001c7jCRLwN\\'pI\u0016LA!a\t\u0002\u001e\tQ2\u000b^1uS>tG)Z:q_2L\u0017\r^5p]6{G-\u001a#b_\u0006\t2\u000f^1uS>tG+Z7q%\u00164G)Y8\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fg\u0003\u001d!X-\u001c9SK\u001aLA!!\r\u0002,\t\t2\u000b^1uS>tG+Z7q%\u00164G)Y8\u0002\u001bU\u001cXM\u001d$jYR,'\u000fR1p!\u0011\t9$a\u0010\u000e\u0005\u0005e\"b\u0001,\u0002<)\u0019\u0011QH-\u0002\tU\u001cXM]\u0005\u0005\u0003\u0003\nIDA\u0007Vg\u0016\u0014h)\u001b7uKJ$\u0015m\\\u0001\u0013a&,'p\\7fiJLXI^3oi\u0012\u000bw\u000eE\u0002U\u0003\u000fJ1!!\u0013V\u0005I\u0001\u0016.\u001a>p[\u0016$(/_#wK:$H)Y8\u0002\u001f\r|g\u000e\u001e:jEV$xN]:EC>\u0004B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0004-\u0006M#\u0002BA+\u0003\u001f\t1bY8oiJL'-\u001e;pe&!\u0011\u0011LA)\u0005=\u0019uN\u001c;sS\n,Ho\u001c:t\t\u0006|\u0017\u0001D1oC2L8/[:EC>\u0014\u0004\u0003BA0\u0003Kj!!!\u0019\u000b\u0007Y\u000b\u0019G\u0003\u0002\u0002\f%!\u0011qMA1\u0005-\te.\u00197zg&\u001cH)Y8\u0002\u001fE,\u0018\r\\5u_6,G/\u001a:EC>\u0004B!!\u001c\u0002v5\u0011\u0011q\u000e\u0006\u0004-\u0006E$bAA:3\u00069\u0011/^1mSRL\u0018\u0002BA<\u0003_\u0012q\"U;bY&$x.\\3uKJ$\u0015m\\\u0001\u000bU>\u0014g)\u001b7f\t\u0006|\u0007\u0003BA?\u0003\u000bk!!a \u000b\u0007Y\u000b\tIC\u0002\u0002\u0004f\u000b1A[8c\u0013\u0011\t9)a \u0003\u0015){'MR5mK\u0012\u000bw.A\u0007RKN|W\u000f^)vC2LG/\u001f\t\u0004\u001d\u00065\u0015bAAH\u001f\ni\u0011+Z:pkR\fV/\u00197jif\f\u0011#];fg>,HOS8ve:\fG\u000eR1p!\u0011\t)*!(\u000e\u0005\u0005]%bA\u0015\u0002\u001a*\u0019\u00111T-\u0002\r\u0015D\bo\u001c:u\u0013\u0011\ty*a&\u0003#E+Xm]8vi*{WO\u001d8bY\u0012\u000bw.A\u0007BI\u0016\u001cX\t\u001f9peR$\u0015m\u001c\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016\u0015\u0002\u001b\u0005$Wm]#ya>\u0014H\u000fR1p\u0013\u0011\ti+a*\u0003\u001b\u0005#Wm]#ya>\u0014H\u000fR1p\u0003I\u0019F/\u0019;j_:4UO\\2uS>tG)Y8\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.g\u0003%1WO\\2uS>t7/\u0003\u0003\u0002<\u0006U&AE*uCRLwN\u001c$v]\u000e$\u0018n\u001c8EC>\fqb\u0015;bi&|g.V:bO\u0016$\u0015m\u001c\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u0019\u0011Q\u00194\u0002\rU\u001c\u0018mZ3t\u0013\u0011\tI-a1\u0003\u001fM#\u0018\r^5p]V\u001b\u0018mZ3EC>\f\u0001\u0002Z1uC\n\f7/\u001a\t\u0005\u0003\u001f\fY.\u0004\u0002\u0002R*!\u00111[Ak\u0003\t!'MC\u00026\u0003/T!!!7\u0002\tAd\u0017-_\u0005\u0005\u0003;\f\tN\u0001\u0005ECR\f'-Y:f\u0003\u0019a\u0014N\\5u}Q\u0011\u00111\u001d\u000b3\u0003K\fI/a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)Aa\u0002\u0003\n\t-!Q\u0002B\b\u0005#\u0011\u0019B!\u0006\u0003\u0018A\u0019\u0011q\u001d\u0001\u000e\u0003\u0019BQ\u0001O\rA\u0004eBQ!R\rA\u0004\u0019CQ\u0001T\rA\u00045CQAU\rA\u0004MCQ!X\rA\u0004yCQ!Y\rA\u0004\tDQ\u0001\\\rA\u00045DQa]\rA\u0004QDQA_\rA\u0004mDq!a\u0001\u001a\u0001\b\t)\u0001C\u0004\u0002\u0018e\u0001\u001d!!\u0007\t\u000f\u0005\u0015\u0012\u0004q\u0001\u0002(!9\u00111G\rA\u0004\u0005U\u0002bBA\"3\u0001\u000f\u0011Q\t\u0005\b\u0003\u0017J\u00029AA'\u0011\u001d\tY&\u0007a\u0002\u0003;Bq!!\u001b\u001a\u0001\b\tY\u0007C\u0004\u0002ze\u0001\u001d!a\u001f\t\u000f\u0005%\u0015\u0004q\u0001\u0002\f\"9\u0011\u0011S\rA\u0004\u0005M\u0005bBAQ3\u0001\u000f\u00111\u0015\u0005\b\u0003_K\u00029AAY\u0011\u001d\ti,\u0007a\u0002\u0003\u007fCq!a3\u001a\u0001\b\ti\rK\u0002\u001a\u00057\u0001BA!\b\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0005K\tQA[1wCbLAA!\u000b\u0003 \t1\u0011J\u001c6fGR\fq!\u001a=fGV$X\r\u0006\u0004\u00030\tU\"q\n\t\u0004[\tE\u0012b\u0001B\u001a]\t!QK\\5u\u0011\u001d\u00119D\u0007a\u0001\u0005s\t!B]8vi&twmS3z!\u0011\u0011YD!\u0013\u000f\t\tu\"Q\t\t\u0004\u0005\u007fqSB\u0001B!\u0015\r\u0011\u0019EK\u0001\u0007yI|w\u000e\u001e \n\u0007\t\u001dc&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0017\u0012iE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u000fr\u0003b\u0002B)5\u0001\u0007!1K\u0001\b[\u0016\u001c8/Y4f!\u0011\u0011)Fa\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\nAA[:p]*!!QLAk\u0003\u0011a\u0017NY:\n\t\t\u0005$q\u000b\u0002\b\u0015N4\u0016\r\\;f\u000359W\r\u001e*pkRLgnZ&fsR\u0011!\u0011H\u0001\u000eKb,7-\u001e;f#\u0016\u001bv*\u0016+\u0015\t\t=\"1\u000e\u0005\b\u0005#b\u0002\u0019\u0001B*\u0003e9W\r^)fg>,H/T3bgV\u0014Xm\u001d\"zke+\u0017M]:\u0015!\tE$1\u0013BV\u0005_\u0013IL!2\u0003J\nM\u0007C\u0002B:\u0005{\u0012\u0019I\u0004\u0003\u0003v\ted\u0002\u0002B \u0005oJ\u0011aL\u0005\u0004\u0005wr\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005\u007f\u0012\tIA\u0002TKFT1Aa\u001f/!\u0011\u0011)Ia$\u000e\u0005\t\u001d%\u0002\u0002BE\u0005\u0017\u000bq!\\3bgV\u0014XMC\u0002\u0003\u000e^\u000bQ!\\8eK2LAA!%\u0003\b\nY\u0002+[3{_6,G/\u001a:DQJ|g.[2SC^lU-Y:ve\u0016DqA!&\u001e\u0001\u0004\u00119*A\u0003ti\u0006\u0014H\u000f\u0005\u0003\u0003\u001a\n\u001dVB\u0001BN\u0015\u0011\u0011iJa(\u0002\tQLW.\u001a\u0006\u0005\u0005C\u0013\u0019+\u0001\u0003k_\u0012\f'B\u0001BS\u0003\ry'oZ\u0005\u0005\u0005S\u0013YJ\u0001\u0005ECR,G+[7f\u0011\u001d\u0011i+\ba\u0001\u0005/\u000b1!\u001a8e\u0011\u001d\u0011\t,\ba\u0001\u0005g\u000bq\u0001]5fu>LE\rE\u0002.\u0005kK1Aa./\u0005\rIe\u000e\u001e\u0005\b\u0005wk\u0002\u0019\u0001B_\u00035!Wm\u001d9pY&\fG/[8ogB1!1\u000fB?\u0005\u007f\u0003B!a\u0007\u0003B&!!1YA\u000f\u0005A!Um\u001d9pY&\fG/[8o\u001b>$W\rC\u0004\u0003Hv\u0001\rA!\u001d\u0002\u000b\t,\u0018\u000e\u001c;\t\u000f\t-W\u00041\u0001\u0003N\u0006I!M];uK6{G-\u001a\t\u0004[\t=\u0017b\u0001Bi]\t9!i\\8mK\u0006t\u0007b\u0002Bk;\u0001\u0007!QZ\u0001\u000eCV$x.\\1uS\u000elu\u000eZ3)\u0007u\u0011I\u000e\u0005\u0003\u0003\\\n\u0005XB\u0001Bo\u0015\r\u0011yNL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Br\u0005;\u0014q\u0001^1jYJ,7-\u0001\u000bfq\u0016\u001cW\u000f^3R\u000bN{U\u000bV)vC2LG/\u001a\u000b\u0005\u0005_\u0011I\u000fC\u0004\u0003Ry\u0001\rAa\u0015\u0002'\u001d,GoU3mK\u000e$X\rZ*uCRLwN\\:\u0015\u0011\t=(\u0011\u001fB\u0000\u0007\u0013\u0001bAa\u001d\u0003~\tM\u0006b\u0002Bz?\u0001\u0007!Q_\u0001\bM&dG/\u001a:t!\u0011\u00119Pa?\u000e\u0005\te(b\u0001BGQ%!!Q B}\u00051\tVm]8vi\u001aKG\u000e^3s\u0011\u001d\u0019\ta\ba\u0001\u0007\u0007\taB[8c\u000bb,7-\u001e;j_:LE\rE\u0002.\u0007\u000bI1aa\u0002/\u0005\u0011auN\\4\t\u000f\r-q\u00041\u0001\u0003:\u0005\u0019A/\u001f9\u00021\u001d,Go\u0015;bi&|gNV1mS\u0012LG/_#se>\u00148\u000f\u0006\u0006\u0004\u0012\rM1qDB\u0012\u0007_\u0001bAa\u001d\u0003~\te\u0002bBB\u000bA\u0001\u00071qC\u0001\u0006a&,'p\u001c\t\u0005\u00073\u0019Y\"\u0004\u0002\u0003\f&!1Q\u0004BF\u0005)\u0001\u0016.\u001a>p[\u0016$XM\u001d\u0005\b\u0007C\u0001\u0003\u0019\u0001B9\u0003!iW-Y:ve\u0016\u001c\bbBB\u0013A\u0001\u00071qE\u0001\nY\u0006tG-\\1sWN\u0004bAa\u001d\u0003~\r%\u0002c\u00018\u0004,%\u00191QF8\u0003\u00111\u000bg\u000eZ7be.Dqa!\r!\u0001\u0004\u0019\u0019$\u0001\tbYRLW.\u001a;ssNK8\u000f^3ngB1!1\u000fB?\u0007k\u00012aYB\u001c\u0013\r\u0019I\u0004\u001a\u0002\u0010\u00032$\u0018.\\3uef\u001c\u0016p\u001d;f[RA1\u0011CB\u001f\u0007\u0003\u001aY\u0005C\u0004\u0004@\u0005\u0002\rA!\u000f\u0002\t\r|G-\u001a\u0005\b\u0007C\t\u0003\u0019AB\"!\u0019\u0011\u0019H! \u0004FA!!q_B$\u0013\u0011\u0019IE!?\u00031\u0015C\bo\u001c:u#\u0016\u001cx.\u001e;TC6\u0004H.Z(viB,H\u000fC\u0004\u0003t\u0006\u0002\rA!>\u0002\u001d\u001d,G/\u0012=q_J$H)\u0019;fgRQ1\u0011KB3\u0007O\u001aIga\u001c\u0011\u00135\u001a\u0019fa\u0016\u0004X\ru\u0013bAB+]\t1A+\u001e9mKN\u0002R!LB-\u0005/K1aa\u0017/\u0005\u0019y\u0005\u000f^5p]B)Qf!\u0017\u0004`A!\u0011QSB1\u0013\u0011\u0019\u0019'a&\u0003\u001dE+Xm]8vi*{WO\u001d8bY\"91\u0011\u0001\u0012A\u0002\r\r\u0001b\u0002BzE\u0001\u0007!Q\u001f\u0005\b\u0007W\u0012\u0003\u0019AB7\u0003!Qw.\u001e:oC2\u001c\bC\u0002B:\u0005{\u001ay\u0006C\u0004\u0004r\t\u0002\rA!\u000f\u0002\u000f\t\u001c8oQ8eK\u0006!R\r_3dkR,\u0017iY6o_2,GmZ7f]R$BAa\f\u0004x!9!\u0011K\u0012A\u0002\tM\u0013a\u00035b]\u0012dW-\u0012:s_J$bAa\f\u0004~\r\u001d\u0005bBB@I\u0001\u00071\u0011Q\u0001\u0002KB!!1OBB\u0013\u0011\u0019)I!!\u0003\u0013\u0015C8-\u001a9uS>t\u0007bBB\u0001I\u0001\u000711\u0001")
public class QesoutController
implements Model {
    private final JobLogUtil JobLogUtil;
    private final QesoutBuilder QesoutBuilder;
    private final PiezometerDaeau piezometerDaeau;
    private final PiezometerMeasureDao piezometerMeasureDao;
    private final StationAltimetrySystemDao altimetrySystemDao;
    private final StationLandmarkDao landmarkDao;
    private final StationMeasureMethodDao measureMethodDao;
    private final StationNetworkDao StationNetworkDao;
    private final NetworkDao NetworkDao;
    private final StationDespoliationModeDao stationDespoliationDao;
    private final StationTempRefDao stationTempRefDao;
    private final UserFilterDao userFilterDao;
    private final PiezometryEventDao piezometryEventDao;
    private final ContributorsDao contributorsDao;
    private final AnalysisDao analysisDao2;
    private final QualitometerDao qualitometerDao;
    private final JobFileDao jobFileDao;
    private final QesoutQuality QesoutQuality;
    private final QuesoutJournalDao quesoutJournalDao;
    private final AdesExportDao AdesExportDao;
    private final StationFunctionDao StationFunctionDao;
    private final StationUsageDao StationUsageDao;
    private final Database database;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, com.rabbitmq.client.Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (com.rabbitmq.client.Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        QesoutController qesoutController = this;
        synchronized (qesoutController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        QesoutController qesoutController = this;
        synchronized (qesoutController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = ExportRouting$.MODULE$.EXPORT_QESOUT();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeQESOUT(message);
            return;
        }
        String string4 = ExportRouting$.MODULE$.EXPORT_QESOUT_QUALITO();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            this.executeQESOUTQualite(message);
            return;
        }
        String string6 = ExportRouting$.MODULE$.EXPORT_QESOUT_ACK();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            this.executeAcknoledgment(message);
            return;
        }
        if (string != null) {
            String string8 = string;
            this.logUtil().info(new StringBuilder(19).append("Bad routing key => ").append(string8).toString(), this.logUtil().info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public String getRoutingKey() {
        return ExportRouting$.MODULE$.QESOUT_TOPIC();
    }

    private void executeQESOUT(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            QesoutController.$anonfun$executeQESOUT$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParameters -> {
            QesoutController.$anonfun$executeQESOUT$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    private final scala.collection.immutable.Seq<PiezometerChronicRawMeasure> getQesoutMeasuresBy5Years(DateTime start, DateTime end, int piezoId, scala.collection.immutable.Seq<DespoliationMode> despoliations, scala.collection.immutable.Seq<PiezometerChronicRawMeasure> built, boolean bruteMode, boolean automaticMode) {
        while (start.getMillis() <= end.getMillis()) {
            Option lastDay;
            DateTime plus5 = start.plusYears(5);
            DateTime nextStart = start.plusYears(5).plusDays(1);
            scala.collection.immutable.Seq measures = (scala.collection.immutable.Seq)this.piezometerMeasureDao.getPiezometerBruteMeasures(piezoId, (Option)new Some((Object)start.withTimeAtStartOfDay()), (Option)new Some((Object)DateUtil$.MODULE$.setMaxDay(plus5))).sortBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$getQesoutMeasuresBy5Years$3(x$6)), (Ordering)Ordering.Long$.MODULE$);
            Tuple2 tuple2 = measures.partition(arg_0 -> QesoutController.$anonfun$getQesoutMeasuresBy5Years$5$adapted(lastDay = measures.lastOption().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$getQesoutMeasuresBy5Years$4(x$7))), arg_0));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Seq before = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq after = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)before, (Object)after);
            scala.collection.immutable.Seq before2 = (scala.collection.immutable.Seq)tuple22._1();
            scala.collection.immutable.Seq after2 = (scala.collection.immutable.Seq)tuple22._2();
            scala.collection.immutable.Seq measuresToCalculate = (scala.collection.immutable.Seq)before2.$plus$plus((IterableOnce)(bruteMode && !automaticMode ? (after2.forall((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PiezometryUtils$.MODULE$.isValidQESOUT(m))) ? after2 : Nil$.MODULE$) : after2));
            scala.collection.immutable.Seq calculated = QesoutMeasuresPiezoUtil$.MODULE$.calculateDailyQesoutValues((scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)measuresToCalculate, despoliations, bruteMode);
            scala.collection.immutable.Seq toAdd = bruteMode ? calculated : (scala.collection.immutable.Seq)calculated.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PiezometryUtils$.MODULE$.isValidQESOUT(m)));
            built = (scala.collection.immutable.Seq)built.$plus$plus((IterableOnce)toAdd);
            start = nextStart;
        }
        return (scala.collection.immutable.Seq)((SeqOps)built.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getQesoutMeasuresBy5Years$1(end, x$4)))).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$getQesoutMeasuresBy5Years$2(x$5)), (Ordering)Ordering.Long$.MODULE$);
    }

    private void executeQESOUTQualite(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            QesoutController.$anonfun$executeQESOUTQualite$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParameters -> {
            QesoutController.$anonfun$executeQESOUTQualite$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Seq<Object> getSelectedStations(QesoutFilter filters, long jobExecutionId, String typ) {
        scala.collection.immutable.Seq filtersStations;
        scala.collection.immutable.Seq cityStations;
        Some some;
        String string;
        Option<String> option = filters.selectStationsMode();
        if (option instanceof Some && "STATIONS".equals(string = (String)(some = (Some)option).value())) {
            return (scala.collection.immutable.Seq)filters.stations().get();
        }
        scala.collection.immutable.Seq networkStations = (scala.collection.immutable.Seq)filters.network().map((Function1 & Serializable)networkId -> QesoutController.$anonfun$getSelectedStations$1(this, typ, BoxesRunTime.unboxToInt((Object)networkId))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
        .colon.colon seqAllStations = new .colon.colon((Object)networkStations, (List)new .colon.colon((Object)(cityStations = typ.equalsIgnoreCase(StationTypeUtil$.MODULE$.QUALITY()) ? (scala.collection.immutable.Seq)filters.city().map((Function1 & Serializable)townCode -> (scala.collection.immutable.Seq)$this.qualitometerDao.getCodesFromCity(townCode).map((Function1 & Serializable)pz -> BoxesRunTime.boxToInteger((int)QesoutController.$anonfun$getSelectedStations$5(pz)))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)filters.city().map((Function1 & Serializable)townCode -> (scala.collection.immutable.Seq)$this.piezometerDaeau.getCodesFromCity(townCode).map((Function1 & Serializable)pz -> BoxesRunTime.boxToInteger((int)QesoutController.$anonfun$getSelectedStations$8(pz)))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)), (List)new .colon.colon((Object)(filtersStations = typ.equalsIgnoreCase(StationTypeUtil$.MODULE$.QUALITY()) ? (scala.collection.immutable.Seq)filters.stationsFilter().map((Function1 & Serializable)filterCode -> QesoutController.$anonfun$getSelectedStations$10(this, BoxesRunTime.unboxToInt((Object)filterCode))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)filters.stationsFilter().map((Function1 & Serializable)filterCode -> QesoutController.$anonfun$getSelectedStations$14(this, BoxesRunTime.unboxToInt((Object)filterCode))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        if (seqAllStations.forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEmpty()))) {
            return (scala.collection.immutable.Seq)Nil$.MODULE$;
        }
        scala.collection.immutable.Seq firstNonEmpty = (scala.collection.immutable.Seq)seqAllStations.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.nonEmpty())).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Seq stations = (scala.collection.immutable.Seq)((IterableOnceOps)seqAllStations.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nonEmpty()))).foldLeft((Object)firstNonEmpty, (Function2 & Serializable)(acc, v) -> (scala.collection.immutable.Seq)acc.intersect((Seq)v));
        if (typ.equalsIgnoreCase(StationTypeUtil$.MODULE$.QUALITY())) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(35).append("Found ").append(stations.length()).append(" qualitos matching criterias.").toString(), "", this.JobLogUtil.log$default$5());
        } else {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(38).append("Found ").append(stations.length()).append(" piezometers matching criterias.").toString(), "", this.JobLogUtil.log$default$5());
        }
        return (scala.collection.immutable.Seq)stations.distinct();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public scala.collection.immutable.Seq<String> getStationValidityErrors(Piezometer piezo, scala.collection.immutable.Seq<PiezometerChronicRawMeasure> measures, scala.collection.immutable.Seq<Landmark> landmarks, scala.collection.immutable.Seq<AltimetrySystem> altimetrySystems) {
        None$ none$;
        None$ none$2;
        Some some;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> landmarks.find((Function1 & Serializable)landmark -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getStationValidityErrors$2(altimetrySystems, landmark))));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            some = new Some((Object)new StringBuilder(59).append("RG1: Error while reading landmarks and altimetric systems: ").append(error.getMessage()).toString());
        } else {
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            Success success = (Success)try_;
            Option opt = (Option)success.value();
            Option option = opt;
            if (option instanceof Some) {
                Some some2 = (Some)option;
                Landmark landmark = (Landmark)some2.value();
                some = new Some((Object)new StringBuilder(65).append("RG1: Landmark starting ").append(DateUtil$.MODULE$.getDate(landmark.startDate())).append(" doesn't have associated altimetric system").toString());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                some = None$.MODULE$;
            }
        }
        Option option = measures.find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getStationValidityErrors$4(landmarks, altimetrySystems, m)));
        if (option instanceof Some) {
            Some some3 = (Some)option;
            PiezometerChronicRawMeasure measure = (PiezometerChronicRawMeasure)some3.value();
            Option option2 = PiezometryUtils$.MODULE$.getMeasureLandmarkAndRefAlti(measure, landmarks, altimetrySystems);
            if (None$.MODULE$.equals(option2)) {
                none$2 = new Some((Object)new StringBuilder(65).append("RG2: Can't find landmark or altimetric system on measure at date ").append(DateUtil$.MODULE$.getDate(measure.date())).toString());
            } else {
                Some some4;
                Tuple2 tuple2;
                if (!(option2 instanceof Some) || (tuple2 = (Tuple2)(some4 = (Some)option2).value()) == null) throw new MatchError((Object)option2);
                Landmark l2 = (Landmark)tuple2._1();
                AltimetrySystem alt = (AltimetrySystem)tuple2._2();
                none$2 = l2.height().isEmpty() ? new Some((Object)new StringBuilder(52).append("RG2: landmark has undefined field 'hauteur' at date ").append(DateUtil$.MODULE$.getDate(measure.date())).toString()) : (alt.altitude().isEmpty() ? new Some((Object)new StringBuilder(62).append("RG2: altimetric system has undefined field 'altitude' at date ").append(DateUtil$.MODULE$.getDate(measure.date())).toString()) : new Some((Object)new StringBuilder(73).append("RG2: altimetric system has undefined field 'systemealtimetrique' at date ").append(DateUtil$.MODULE$.getDate(measure.date())).toString()));
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            none$2 = None$.MODULE$;
        }
        scala.collection.immutable.Seq measureMethods = this.measureMethodDao.getMeasureMethods(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
        Option option3 = measures.find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getStationValidityErrors$5(measureMethods, m)));
        if (option3 instanceof Some) {
            Some some5 = (Some)option3;
            PiezometerChronicRawMeasure measure = (PiezometerChronicRawMeasure)some5.value();
            none$ = new Some((Object)new StringBuilder(50).append("RG3: Can't find measure method on measure at date ").append(DateUtil$.MODULE$.getDate(measure.date())).toString());
            return (scala.collection.immutable.Seq)new .colon.colon((Object)some, (List)new .colon.colon((Object)none$2, (List)new .colon.colon((Object)none$, (List)new .colon.colon((Object)((IterableOps)measures.flatMap(QesoutController::$anonfun$getStationValidityErrors$6)).headOption(), (List)new .colon.colon(piezo.code().toLowerCase().startsWith("bss") || piezo.designation().isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)piezo.designation().get())) ? None$.MODULE$ : new Some((Object)"RG5: Station must have designation."), (List)new .colon.colon(piezo.waterSourceType().isEmpty() || piezo.waterSourceType().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isEmpty())) ? new Some((Object)"RG6: 'typepointeau' must be defined") : None$.MODULE$, (List)new .colon.colon((Object)((IterableOps)landmarks.flatMap((Function1 & Serializable)l -> {
                Option option = PiezometryUtils$.MODULE$.getLandmarkSysAlti(l, altimetrySystems);
                if (None$.MODULE$.equals(option)) {
                    return None$.MODULE$;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AltimetrySystem alti = (AltimetrySystem)some.value();
                    if (((BaseDateTime)alti.startDate().get()).getMillis() > ((BaseDateTime)l.startDate().get()).getMillis()) {
                        return new Some((Object)new StringBuilder(61).append("RG7: Landmark on ").append(DateUtil$.MODULE$.getDate((DateTime)l.startDate().get())).append(" must have altimetric system defined before ").append(DateUtil$.MODULE$.getDate((DateTime)l.startDate().get())).toString());
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            })).headOption(), (List)Nil$.MODULE$))))))).flatten(Predef$.MODULE$.$conforms());
        } else {
            if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
            none$ = None$.MODULE$;
        }
        return (scala.collection.immutable.Seq)new .colon.colon((Object)some, (List)new .colon.colon((Object)none$2, (List)new .colon.colon((Object)none$, (List)new .colon.colon((Object)((IterableOps)measures.flatMap(QesoutController::$anonfun$getStationValidityErrors$6)).headOption(), (List)new .colon.colon(piezo.code().toLowerCase().startsWith("bss") || piezo.designation().isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)piezo.designation().get())) ? None$.MODULE$ : new Some((Object)"RG5: Station must have designation."), (List)new .colon.colon(piezo.waterSourceType().isEmpty() || piezo.waterSourceType().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isEmpty())) ? new Some((Object)"RG6: 'typepointeau' must be defined") : None$.MODULE$, (List)new .colon.colon((Object)((IterableOps)landmarks.flatMap((Function1 & Serializable)l -> {
            Option option = PiezometryUtils$.MODULE$.getLandmarkSysAlti(l, altimetrySystems);
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                AltimetrySystem alti = (AltimetrySystem)some.value();
                if (((BaseDateTime)alti.startDate().get()).getMillis() > ((BaseDateTime)l.startDate().get()).getMillis()) {
                    return new Some((Object)new StringBuilder(61).append("RG7: Landmark on ").append(DateUtil$.MODULE$.getDate((DateTime)l.startDate().get())).append(" must have altimetric system defined before ").append(DateUtil$.MODULE$.getDate((DateTime)l.startDate().get())).toString());
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        })).headOption(), (List)Nil$.MODULE$))))))).flatten(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Seq<String> getStationValidityErrors(String code, scala.collection.immutable.Seq<ExportQesoutSampleOutput> measures, QesoutFilter filters) {
        return (scala.collection.immutable.Seq)new .colon.colon((Object)((scala.collection.immutable.Seq)measures.flatMap((Function1 & Serializable)sample -> {
            scala.collection.immutable.Seq<ExportQesoutAnalysisOutput> analyses = $this.analysisDao2.export_qesout_analyses((int)sample.numprelevement(), code, filters.campaignIds());
            return (scala.collection.immutable.Seq)analyses.flatMap((Function1 & Serializable)ana -> {
                if (ana.labo().isEmpty()) {
                    return new Some((Object)new StringBuilder(49).append(" Labo must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$13 -> QesoutController.$anonfun$getStationValidityErrors$11(BoxesRunTime.unboxToDouble((Object)x$13))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.parameter().isEmpty()) {
                    return new Some((Object)new StringBuilder(54).append(" Parameter must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$14 -> QesoutController.$anonfun$getStationValidityErrors$13(BoxesRunTime.unboxToDouble((Object)x$14))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.fraction().isEmpty()) {
                    return new Some((Object)new StringBuilder(53).append(" Fraction must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$15 -> QesoutController.$anonfun$getStationValidityErrors$15(BoxesRunTime.unboxToDouble((Object)x$15))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.status().isEmpty()) {
                    return new Some((Object)new StringBuilder(51).append(" Status must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$16 -> QesoutController.$anonfun$getStationValidityErrors$17(BoxesRunTime.unboxToDouble((Object)x$16))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.result().isEmpty() && ana.remark().isDefined() && !((String)ana.remark().get()).equalsIgnoreCase("10") && !((String)ana.remark().get()).equalsIgnoreCase("0")) {
                    return new Some((Object)new StringBuilder(51).append(" Result must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$17 -> QesoutController.$anonfun$getStationValidityErrors$19(BoxesRunTime.unboxToDouble((Object)x$17))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.result().isEmpty() && ana.remark().isDefined() && ((String)ana.remark().get()).equalsIgnoreCase("10") && ana.quantitationLimit().isEmpty()) {
                    return new Some((Object)new StringBuilder(60).append(" Detection Limit must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$18 -> QesoutController.$anonfun$getStationValidityErrors$21(BoxesRunTime.unboxToDouble((Object)x$18))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.unit().isEmpty()) {
                    return new Some((Object)new StringBuilder(49).append(" Unit must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$19 -> QesoutController.$anonfun$getStationValidityErrors$23(BoxesRunTime.unboxToDouble((Object)x$19))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                if (ana.remark().isEmpty()) {
                    return new Some((Object)new StringBuilder(51).append(" Remark must be defined in analysis ").append((int)ana.id()).append(" and operation ").append(sample.codeoperation().map((Function1 & Serializable)x$20 -> QesoutController.$anonfun$getStationValidityErrors$25(BoxesRunTime.unboxToDouble((Object)x$20))).getOrElse((Function0 & Serializable)() -> "unknown")).toString());
                }
                return None$.MODULE$;
            });
        })), (List)Nil$.MODULE$).flatten(Predef$.MODULE$.$conforms());
    }

    public Tuple3<Option<DateTime>, Option<DateTime>, Option<QuesoutJournal>> getExportDates(long jobExecutionId, QesoutFilter filters, scala.collection.immutable.Seq<QuesoutJournal> journals, String bssCode) {
        Some some;
        String string;
        Some some2;
        String string2;
        String string3;
        boolean bl = false;
        Some some3 = null;
        Option<String> option = filters.mode();
        if (option instanceof Some) {
            bl = true;
            some3 = (Some)option;
            String string4 = (String)some3.value();
            if ("ALL".equals(string4)) {
                return new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)new DateTime()), (Object)None$.MODULE$);
            }
        }
        if (bl && "CUSTOM".equals(string3 = (String)some3.value())) {
            return new Tuple3((Object)filters.startDate().map((Function1 & Serializable)x$21 -> x$21.withTimeAtStartOfDay()), filters.endDate(), (Object)None$.MODULE$);
        }
        if (option instanceof Some && "DIFF".equals(string2 = (String)(some2 = (Some)option).value()) ? true : option instanceof Some && "UPDATE_DATE".equals(string = (String)(some = (Some)option).value())) {
            scala.collection.immutable.Seq journalNotSent = (scala.collection.immutable.Seq)journals.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getExportDates$2(bssCode, j)));
            if (journalNotSent.isEmpty()) {
                scala.collection.immutable.Seq journalSentButNotAcked = (scala.collection.immutable.Seq)journals.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getExportDates$3(bssCode, j)));
                if (journalSentButNotAcked.isEmpty()) {
                    return new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
                }
                return new Tuple3((Object)((QuesoutJournal)journalSentButNotAcked.head()).oldestUpdateWithSent().map((Function1 & Serializable)x$22 -> x$22.withTimeAtStartOfDay()), (Object)None$.MODULE$, (Object)new Some(journalSentButNotAcked.head()));
            }
            if (journalNotSent.length() > 1) {
                QuesoutJournal journalChosen = (QuesoutJournal)journalNotSent.minBy((Function1 & Serializable)x$23 -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$getExportDates$5(x$23)), (Ordering)Ordering.Long$.MODULE$);
                return new Tuple3((Object)journalChosen.oldestUpdateWithSent().map((Function1 & Serializable)x$25 -> x$25.withTimeAtStartOfDay()), (Object)None$.MODULE$, (Object)new Some((Object)journalChosen));
            }
            return new Tuple3((Object)((QuesoutJournal)journalNotSent.head()).oldestUpdateWithSent().map((Function1 & Serializable)x$26 -> x$26.withTimeAtStartOfDay()), (Object)None$.MODULE$, (Object)new Some(journalNotSent.head()));
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Unknown export mode.", "", this.JobLogUtil.log$default$5());
        throw new Exception("Unknown export mode.");
    }

    public void executeAcknoledgment(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            QesoutController.$anonfun$executeAcknoledgment$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParameters -> {
            QesoutController.$anonfun$executeAcknoledgment$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$executeQESOUT$1(QesoutController $this, Seq error) {
        Predef$.MODULE$.print((Object)error);
        $this.logUtil().error(new StringBuilder(22).append("Error validate Json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil().error$default$2());
    }

    public static final /* synthetic */ int $anonfun$executeQESOUT$8(Connection c) {
        return BoxesRunTime.unboxToInt((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select nombresdecimales from parametrage_data where id=-1 and projet= 'SIES'"}))), (scala.collection.immutable.Seq)Nil$.MODULE$).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 3));
    }

    public static final /* synthetic */ long $anonfun$executeQESOUT$12(PiezometerChronicRawMeasure x$1) {
        return x$1.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$executeQESOUT$13(PiezometerChronicRawMeasure x$2) {
        return x$2.date().withTimeAtStartOfDay().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$executeQESOUT$14(Option lastDay$1, PiezometerChronicRawMeasure m) {
        return m.date().getMillis() < BoxesRunTime.unboxToLong((Object)lastDay$1.get());
    }

    private final scala.collection.immutable.Seq calculateClassic$1(Piezometer piezo$1, Option start$1, Option end$1, QesoutFilter filters$1, scala.collection.immutable.Seq despoliations$1) {
        Option lastDay;
        scala.collection.immutable.Seq measures = (scala.collection.immutable.Seq)this.piezometerMeasureDao.getPiezometerBruteMeasures(piezo$1.id(), start$1, end$1).sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$executeQESOUT$12(x$1)), (Ordering)Ordering.Long$.MODULE$);
        Tuple2 tuple2 = measures.partition(arg_0 -> QesoutController.$anonfun$executeQESOUT$14$adapted(lastDay = measures.lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$executeQESOUT$13(x$2))), arg_0));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq before = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq after = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)before, (Object)after);
        scala.collection.immutable.Seq before2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq after2 = (scala.collection.immutable.Seq)tuple22._2();
        scala.collection.immutable.Seq measuresToCalculate = (scala.collection.immutable.Seq)before2.$plus$plus((IterableOnce)(filters$1.bruteMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && !filters$1.mode().contains((Object)"CUSTOM") ? (after2.forall((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PiezometryUtils$.MODULE$.isValidQESOUT(m))) ? after2 : Nil$.MODULE$) : after2));
        scala.collection.immutable.Seq calculated = QesoutMeasuresPiezoUtil$.MODULE$.calculateDailyQesoutValues((scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)measuresToCalculate, (scala.collection.immutable.Seq<DespoliationMode>)despoliations$1, filters$1.bruteMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        scala.collection.immutable.Seq toAdd = filters$1.bruteMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? calculated : (scala.collection.immutable.Seq)calculated.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)PiezometryUtils$.MODULE$.isValidQESOUT(m)));
        return toAdd;
    }

    public static final /* synthetic */ boolean $anonfun$executeQESOUT$17(DateTime d) {
        return d.year().get() < new DateTime().year().get() - 2;
    }

    public static final /* synthetic */ int $anonfun$executeQESOUT$20(Piezometer piezo$1, String minDateReq$1, Connection c) {
        ParameterValue[] parameterValueArray = new ParameterValue[2];
        ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)piezo$1.id()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)minDateReq$1, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        return BoxesRunTime.unboxToInt((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select count(*) from chroniques_brutes where typeid=-1 and codepiezometre=", " #", ""}))), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ long $anonfun$executeQESOUT$26(PiezometerChronicRawMeasure m) {
        return m.date().getMillis();
    }

    public static final /* synthetic */ DateTime $anonfun$executeQESOUT$25(scala.collection.immutable.Seq dailyValue$1) {
        return ((PiezometerChronicRawMeasure)dailyValue$1.minBy((Function1 & Serializable)m -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$executeQESOUT$26(m)), (Ordering)Ordering.Long$.MODULE$)).date();
    }

    public static final /* synthetic */ boolean $anonfun$executeQESOUT$28(PiezometryEvent e) {
        return e.bankExport().contains((Object)"1");
    }

    public static final /* synthetic */ boolean $anonfun$executeQESOUT$32(MeasureMethod m) {
        return m.periodicityAcqui().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$executeQESOUT$10(QesoutController $this, long jobExecutionId$1, QesoutFilter filters$1, scala.collection.immutable.Seq journals$1, String user$1, int roundValue$1, String directory$1, Piezometer piezo) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple3<Option<DateTime>, Option<DateTime>, Option<QuesoutJournal>> tuple3 = $this.getExportDates(jobExecutionId$1, filters$1, (scala.collection.immutable.Seq<QuesoutJournal>)journals$1, piezo.code().toUpperCase());
            if (tuple3 != null) {
                Option option = (Option)tuple3._1();
                Option option2 = (Option)tuple3._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(22).append("No data to export for ").append(piezo.code()).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple3 != null) {
                scala.collection.immutable.Seq<PiezometerChronicRawMeasure> dailyValue;
                String minDateReq;
                int count;
                Option start = (Option)tuple3._1();
                Option end = (Option)tuple3._2();
                Option journalOpt = (Option)tuple3._3();
                scala.collection.immutable.Seq despoliations = $this.stationDespoliationDao.getDespoliationModes(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
                Object object = start.exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeQESOUT$17(d))) ? ((count = BoxesRunTime.unboxToInt((Object)$this.database.withConnection(arg_0 -> QesoutController.$anonfun$executeQESOUT$20$adapted(piezo, minDateReq = (String)start.map((Function1 & Serializable)m -> new StringBuilder(19).append(" AND datemesure >= ").append(DateUtil$.MODULE$.getPostgreDate(m)).toString()).getOrElse((Function0 & Serializable)() -> ""), arg_0)))) > 50000 ? $this.getQesoutMeasuresBy5Years(((DateTime)start.getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1970))).withTimeAtStartOfDay(), DateUtil$.MODULE$.setMaxDay((DateTime)end.getOrElse((Function0 & Serializable)() -> new DateTime())), piezo.id(), (scala.collection.immutable.Seq<DespoliationMode>)despoliations, (scala.collection.immutable.Seq<PiezometerChronicRawMeasure>)((scala.collection.immutable.Seq)Nil$.MODULE$), filters$1.bruteMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)), !filters$1.mode().contains((Object)"CUSTOM")) : $this.calculateClassic$1(piezo, start, end, filters$1, despoliations)) : (dailyValue = $this.calculateClassic$1(piezo, start, end, filters$1, despoliations));
                if (dailyValue.nonEmpty()) {
                    DateTime minDate = (DateTime)journalOpt.flatMap((Function1 & Serializable)j -> j.oldestUpdateWithSent()).getOrElse(() -> QesoutController.$anonfun$executeQESOUT$25((scala.collection.immutable.Seq)dailyValue));
                    DateTime maxDate = (DateTime)end.getOrElse((Function0 & Serializable)() -> new DateTime());
                    scala.collection.immutable.Seq landmarks = $this.landmarkDao.getLandmarks(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
                    scala.collection.immutable.Seq timeReferences = $this.stationTempRefDao.getTempRefs(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
                    scala.collection.immutable.Seq measureMethods = $this.measureMethodDao.getMeasureMethods(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
                    scala.collection.immutable.Seq altimetrySystems = $this.altimetrySystemDao.getAltimetrySystems(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
                    scala.collection.immutable.Seq functions = $this.StationFunctionDao.getFunctions(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezo.id());
                    scala.collection.immutable.Seq usages = $this.StationUsageDao.getUsages(StationTypeUtil$.MODULE$.PIEZOMETRY(), (long)piezo.id());
                    scala.collection.immutable.Seq events = (scala.collection.immutable.Seq)$this.piezometryEventDao.getEvents(piezo.id()).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeQESOUT$28(e)));
                    Map validatorsMap = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)$this.contributorsDao.getCodesWithIds((scala.collection.immutable.Seq)((SeqOps)dailyValue.flatMap((Function1 & Serializable)m -> m.validator())).distinct()).flatMap((Function1 & Serializable)c -> {
                        boolean bl = true;
                        if (c.sandre().isDefined()) {
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)c.id())), c.sandre().get()));
                        }
                        if (c.siret().isDefined()) {
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)c.id())), c.siret().get()));
                        }
                        return None$.MODULE$;
                    }));
                    scala.collection.immutable.Seq<String> validityErrors = $this.getStationValidityErrors(piezo, dailyValue, (scala.collection.immutable.Seq<Landmark>)landmarks, (scala.collection.immutable.Seq<AltimetrySystem>)altimetrySystems);
                    if (validityErrors.nonEmpty()) {
                        validityErrors.foreach((Function1 & Serializable)error -> {
                            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), error, piezo.code(), $this.JobLogUtil.log$default$5());
                            return BoxedUnit.UNIT;
                        });
                        Object object2 = journalOpt.isEmpty() ? $this.quesoutJournalDao.updateJournal(minDate, piezo.code(), user$1, "erreur RG lors de la g\u00e9n\u00e9ration du fichier", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1)), false) : BoxedUnit.UNIT;
                        $this.quesoutJournalDao.setExportFailed(piezo.code(), minDate, maxDate, new DateTime(), user$1, (String)validityErrors.head(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1)), false);
                        return BoxedUnit.UNIT;
                    }
                    $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(35).append("Station ").append(piezo.code()).append(" is valid. Building file...").toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                    Node qesout = $this.QesoutBuilder.getQesoutNode(minDate, maxDate, filters$1.siret(), piezo, (scala.collection.immutable.Seq<Landmark>)landmarks, (scala.collection.immutable.Seq<AltimetrySystem>)altimetrySystems, (scala.collection.immutable.Seq<StationTempRef>)timeReferences, (scala.collection.immutable.Seq<DespoliationMode>)despoliations, (scala.collection.immutable.Seq<MeasureMethod>)measureMethods, dailyValue, (scala.collection.immutable.Seq<PiezometryEvent>)events, (Map<Object, String>)validatorsMap, (scala.collection.immutable.Seq<StationFunction>)functions, (scala.collection.immutable.Seq<Usage>)usages, roundValue$1);
                    DateTime sendDate = new DateTime().withMillisOfSecond(0);
                    double num = $this.quesoutJournalDao.setSendDate(piezo.code().toUpperCase(), journalOpt, minDate, maxDate, sendDate, user$1, "generating file / set send date", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1)), false);
                    String fileName = new StringBuilder(14).append("QESOUT_").append((int)num).append("_").append(piezo.code()).append("_").append(sendDate.toString("ddMMYYYY-HHmmss")).append("_.xml").toString();
                    if (piezo.stateCode().isEmpty()) {
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(67).append("Station ").append(piezo.code()).append(" has field 'codeetat' undefined. Exporting value 0: Inconnu").toString(), piezo.code(), fileName);
                    }
                    if (piezo.waterSourceType().isEmpty() || piezo.waterSourceType().contains((Object)"")) {
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(71).append("Station ").append(piezo.code()).append(" has field 'codepointeau' undefined. Exporting value 0: Inconnu").toString(), piezo.code(), fileName);
                    }
                    if (measureMethods.exists((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeQESOUT$32(m)))) {
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(96).append("Station ").append(piezo.code()).append(" has measure method field <PeriodiciteAcquisition> undefined. Exporting value 0: Inconnu").toString(), piezo.code(), fileName);
                    }
                    XML$.MODULE$.save(new StringBuilder(0).append(directory$1).append(fileName).toString(), qesout, "UTF-8", XML$.MODULE$.save$default$4(), XML$.MODULE$.save$default$5());
                    File file = new File(new StringBuilder(0).append(directory$1).append(fileName).toString());
                    $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("File ").append(fileName).append(" saved. (Data from ").append(DateUtil$.MODULE$.getDate(start)).append(" to ").append(DateUtil$.MODULE$.getDate(end)).toString(), piezo.code(), fileName);
                    $this.JobLogUtil.setFileProcessed(file, jobExecutionId$1);
                    return BoxesRunTime.boxToInteger((int)$this.jobFileDao.add(jobExecutionId$1, file, 1));
                }
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(22).append("No data to export for ").append(piezo.code()).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
                return BoxedUnit.UNIT;
            }
            throw new MatchError(tuple3);
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(28).append("Error while building file : ").append(err.getMessage()).toString(), piezo.code(), $this.JobLogUtil.log$default$5());
            $this.quesoutJournalDao.setExportFailed(piezo.code(), new DateTime(), new DateTime(), new DateTime(), user$1, new StringBuilder(28).append("Error while building file : ").append(err.getMessage()).toString(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1)), false);
            $this.logUtil().printError(err);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$executeQESOUT$2(QesoutController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        String user = (String)jobParameters.user().getOrElse((Function0 & Serializable)() -> "unknown job");
        String baseDir = StringUtil$.MODULE$.getPath((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> ""));
        String directory = StringUtil$.MODULE$.getPath(new StringBuilder(0).append(baseDir).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString());
        QesoutFilter filters = (QesoutFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new QesoutFilter("", QesoutFilter$.MODULE$.$lessinit$greater$default$2(), QesoutFilter$.MODULE$.$lessinit$greater$default$3(), QesoutFilter$.MODULE$.$lessinit$greater$default$4(), QesoutFilter$.MODULE$.$lessinit$greater$default$5(), QesoutFilter$.MODULE$.$lessinit$greater$default$6(), QesoutFilter$.MODULE$.$lessinit$greater$default$7(), QesoutFilter$.MODULE$.$lessinit$greater$default$8(), QesoutFilter$.MODULE$.$lessinit$greater$default$9(), QesoutFilter$.MODULE$.$lessinit$greater$default$10(), QesoutFilter$.MODULE$.$lessinit$greater$default$11(), QesoutFilter$.MODULE$.$lessinit$greater$default$12(), QesoutFilter$.MODULE$.$lessinit$greater$default$13()), JobUtil$.MODULE$.getFilters$default$5(), QesoutFilter$.MODULE$.format());
        scala.collection.immutable.Seq<Object> stations = $this.getSelectedStations(filters, jobExecutionId, StationTypeUtil$.MODULE$.PIEZOMETRY());
        if (filters.mode().contains((Object)"UPDATE_DATE")) {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(70).append("Updating ades_journalisation with data whose update dates is after ").append(DateUtil$.MODULE$.getDate((DateTime)filters.updateDateModeDate().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Update date must be defined on job parameters");
            }))).append("...").toString(), "", $this.JobLogUtil.log$default$5());
            int updatedPoints = $this.AdesExportDao.updateAdesJournalisationWithUpdateDate(stations, (DateTime)filters.updateDateModeDate().get(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), user, false);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(40).append(updatedPoints).append(" stations updated in ades_journalisation").toString(), "", $this.JobLogUtil.log$default$5());
        }
        scala.collection.immutable.Seq journals = $this.quesoutJournalDao.getAllUnsent(false);
        scala.collection.immutable.Seq piezos = $this.piezometerDaeau.getAll((Option)new Some(stations));
        Map networksMap = AlgoUtil$.MODULE$.makeMapId($this.NetworkDao.getAll(), (Function1 & Serializable)n -> BoxesRunTime.boxToInteger((int)n.code()));
        int roundValue = BoxesRunTime.unboxToInt((Object)$this.database.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)QesoutController.$anonfun$executeQESOUT$8(c))));
        piezos.foreach((Function1 & Serializable)piezo -> {
            QesoutController.$anonfun$executeQESOUT$10($this, jobExecutionId, filters, journals, user, roundValue, directory, piezo);
            return BoxedUnit.UNIT;
        });
        if (piezos.isEmpty()) {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No station to export", "", $this.JobLogUtil.log$default$5());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getQesoutMeasuresBy5Years$1(DateTime end$2, PiezometerChronicRawMeasure x$4) {
        return x$4.date().withTimeAtStartOfDay().getMillis() < end$2.getMillis();
    }

    public static final /* synthetic */ long $anonfun$getQesoutMeasuresBy5Years$2(PiezometerChronicRawMeasure x$5) {
        return x$5.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getQesoutMeasuresBy5Years$3(PiezometerChronicRawMeasure x$6) {
        return x$6.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$getQesoutMeasuresBy5Years$4(PiezometerChronicRawMeasure x$7) {
        return x$7.date().withTimeAtStartOfDay().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$getQesoutMeasuresBy5Years$5(Option lastDay$2, PiezometerChronicRawMeasure m) {
        return m.date().getMillis() < BoxesRunTime.unboxToLong((Object)lastDay$2.get());
    }

    public static final /* synthetic */ void $anonfun$executeQESOUTQualite$1(QesoutController $this, Seq error) {
        Predef$.MODULE$.print((Object)error);
        $this.logUtil().error(new StringBuilder(22).append("Error validate Json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil().error$default$2());
    }

    public static final /* synthetic */ long $anonfun$executeQESOUTQualite$12(ExportQesoutSampleOutput m) {
        return ((BaseDateTime)m.datedebut().get()).getMillis();
    }

    public static final /* synthetic */ void $anonfun$executeQESOUTQualite$2(QesoutController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        String user = (String)jobParameters.user().getOrElse((Function0 & Serializable)() -> "unknown job");
        String baseDir = StringUtil$.MODULE$.getPath((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> ""));
        String directory = StringUtil$.MODULE$.getPath(new StringBuilder(0).append(baseDir).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString());
        QesoutFilter filters = (QesoutFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new QesoutFilter("", QesoutFilter$.MODULE$.$lessinit$greater$default$2(), QesoutFilter$.MODULE$.$lessinit$greater$default$3(), QesoutFilter$.MODULE$.$lessinit$greater$default$4(), QesoutFilter$.MODULE$.$lessinit$greater$default$5(), QesoutFilter$.MODULE$.$lessinit$greater$default$6(), QesoutFilter$.MODULE$.$lessinit$greater$default$7(), QesoutFilter$.MODULE$.$lessinit$greater$default$8(), QesoutFilter$.MODULE$.$lessinit$greater$default$9(), QesoutFilter$.MODULE$.$lessinit$greater$default$10(), QesoutFilter$.MODULE$.$lessinit$greater$default$11(), QesoutFilter$.MODULE$.$lessinit$greater$default$12(), QesoutFilter$.MODULE$.$lessinit$greater$default$13()), JobUtil$.MODULE$.getFilters$default$5(), QesoutFilter$.MODULE$.format());
        scala.collection.immutable.Seq<Object> qualitos = $this.getSelectedStations(filters, jobExecutionId, StationTypeUtil$.MODULE$.QUALITY());
        Map networksMap = AlgoUtil$.MODULE$.makeMapId($this.NetworkDao.getAll(), (Function1 & Serializable)n -> BoxesRunTime.boxToInteger((int)n.code()));
        if (filters.mode().contains((Object)"UPDATE_DATE")) {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(70).append("Updating ades_journalisation with data whose update dates is after ").append(DateUtil$.MODULE$.getDate((DateTime)filters.updateDateModeDate().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Update date must be defined on job parameters");
            }))).append("...").toString(), "", $this.JobLogUtil.log$default$5());
            int updatedPoints = $this.AdesExportDao.updateAdesJournalisationWithUpdateDate(qualitos, (DateTime)filters.updateDateModeDate().get(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), user, true);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(40).append(updatedPoints).append(" stations updated in ades_journalisation").toString(), "", $this.JobLogUtil.log$default$5());
        }
        scala.collection.immutable.Seq journals = $this.quesoutJournalDao.getAllUnsent(true);
        qualitos.foreach((Function1)(JFunction1.mcVI.sp & Serializable)qualit -> {
            Option qualito = $this.qualitometerDao.get(qualit);
            if (qualito.isDefined()) {
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Tuple3<Option<DateTime>, Option<DateTime>, Option<QuesoutJournal>> tuple3 = $this.getExportDates(jobExecutionId, filters, (scala.collection.immutable.Seq<QuesoutJournal>)journals, ((Qualitometer)qualito.get()).code().toUpperCase());
                    if (tuple3 != null) {
                        Option option = (Option)tuple3._1();
                        Option option2 = (Option)tuple3._2();
                        if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(22).append("No data to export for ").append(((Qualitometer)qualito.get()).code()).toString(), ((Qualitometer)qualito.get()).code(), $this.JobLogUtil.log$default$5());
                            return;
                        }
                    }
                    if (tuple3 != null) {
                        Option x$30;
                        Option x$29;
                        scala.collection.immutable.Seq x$28;
                        Option x$27;
                        Option x$26;
                        String x$25;
                        Option x$24;
                        Option x$23;
                        Option x$22;
                        Option x$21;
                        Option x$20;
                        Option x$19;
                        Option x$18;
                        Option x$17;
                        Option x$16;
                        Option x$15;
                        Option x$14;
                        Option x$13;
                        Option x$12;
                        Option x$11;
                        Option x$10;
                        Option x$9;
                        Option x$8;
                        Option x$7;
                        Option x$6;
                        Option x$5;
                        Option start = (Option)tuple3._1();
                        Option end = (Option)tuple3._2();
                        Option journalOpt = (Option)tuple3._3();
                        Option x$1 = start;
                        Option x$2 = end;
                        Option<Object> x$3 = filters.producer();
                        Option x$4 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$1();
                        SearchAnalysisInput criterias = new SearchAnalysisInput(x$4, x$5 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$2(), x$6 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$3(), x$7 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$4(), x$8 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$5(), x$9 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$6(), x$10 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$7(), x$11 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$8(), x$12 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$9(), x$13 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$10(), x$14 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$11(), x$15 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$12(), x$3, x$16 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$14(), x$17 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$15(), x$18 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$16(), x$19 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$17(), x$20 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$18(), x$21 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$19(), x$22 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$20(), x$23 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$21(), x$24 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$22(), x$1, x$2, x$25 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$25(), x$26 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$26(), x$27 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$27(), x$28 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$28(), x$29 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$29(), x$30 = SearchAnalysisInput$.MODULE$.$lessinit$greater$default$30());
                        scala.collection.immutable.Seq<ExportQesoutSampleOutput> samples = $this.analysisDao2.export_qesout_prelevements(criterias, ((Qualitometer)qualito.get()).code(), filters.campaignIds());
                        if (samples.nonEmpty()) {
                            DateTime minDate = (DateTime)journalOpt.flatMap((Function1 & Serializable)j -> j.oldestUpdateWithSent()).getOrElse((Function0 & Serializable)() -> (DateTime)((ExportQesoutSampleOutput)samples.minBy((Function1 & Serializable)m -> BoxesRunTime.boxToLong((long)QesoutController.$anonfun$executeQESOUTQualite$12(m)), (Ordering)Ordering.Long$.MODULE$)).datedebut().get());
                            DateTime maxDate = (DateTime)end.getOrElse((Function0 & Serializable)() -> new DateTime());
                            scala.collection.immutable.Seq<String> validityErrors = $this.getStationValidityErrors(((Qualitometer)qualito.get()).code(), samples, filters);
                            if (validityErrors.nonEmpty()) {
                                validityErrors.foreach((Function1 & Serializable)error -> {
                                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), error, ((Qualitometer)qualito.get()).code(), $this.JobLogUtil.log$default$5());
                                    return BoxedUnit.UNIT;
                                });
                                Object object = journalOpt.isEmpty() ? $this.quesoutJournalDao.updateJournal(minDate, ((Qualitometer)qualito.get()).code(), user, "erreur RG lors de la g\u00e9n\u00e9ration du fichier", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), true) : BoxedUnit.UNIT;
                                $this.quesoutJournalDao.setExportFailed(((Qualitometer)qualito.get()).code(), minDate, maxDate, new DateTime(), user, (String)validityErrors.head(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), true);
                                return;
                            }
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(35).append("Station ").append(((Qualitometer)qualito.get()).code()).append(" is valid. Building file...").toString(), ((Qualitometer)qualito.get()).code(), $this.JobLogUtil.log$default$5());
                            Node qesout = $this.QesoutQuality.getNode_Quality((Qualitometer)qualito.get(), samples, filters.siret(), filters.campaignIds());
                            DateTime sendDate = new DateTime().withMillisOfSecond(0);
                            double num = $this.quesoutJournalDao.setSendDate(((Qualitometer)qualito.get()).code().toUpperCase(), journalOpt, minDate, maxDate, sendDate, user, "generating file / set send date", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), true);
                            String fileName = new StringBuilder(14).append("QESOUT_").append((int)num).append("_").append(((Qualitometer)qualito.get()).code()).append("_").append(sendDate.toString("ddMMYYYY-HHmmss")).append("_.xml").toString();
                            if (((Qualitometer)qualito.get()).stateCode().isEmpty()) {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(67).append("Station ").append(((Qualitometer)qualito.get()).code()).append(" has field 'codeetat' undefined. Exporting value 0: Inconnu").toString(), ((Qualitometer)qualito.get()).code(), fileName);
                            }
                            if (((Qualitometer)qualito.get()).waterSourceType().isEmpty() || ((Qualitometer)qualito.get()).waterSourceType().contains((Object)"")) {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(71).append("Station ").append(((Qualitometer)qualito.get()).code()).append(" has field 'codepointeau' undefined. Exporting value 0: Inconnu").toString(), ((Qualitometer)qualito.get()).code(), fileName);
                            }
                            XML$.MODULE$.save(new StringBuilder(0).append(directory).append(fileName).toString(), qesout, "UTF-8", XML$.MODULE$.save$default$4(), XML$.MODULE$.save$default$5());
                            File file = new File(new StringBuilder(0).append(directory).append(fileName).toString());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("File ").append(fileName).append(" saved. (Data from ").append(DateUtil$.MODULE$.getDate(start)).append(" to ").append(DateUtil$.MODULE$.getDate(end)).toString(), ((Qualitometer)qualito.get()).code(), fileName);
                            $this.JobLogUtil.setFileProcessed(file, jobExecutionId);
                            return;
                        }
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(22).append("No data to export for ").append(((Qualitometer)qualito.get()).code()).toString(), ((Qualitometer)qualito.get()).code(), $this.JobLogUtil.log$default$5());
                        return;
                    }
                    throw new MatchError(tuple3);
                });
                if (try_ instanceof Success) {
                    return;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(28).append("Error while building file : ").append(err.getMessage()).toString(), ((Qualitometer)qualito.get()).code(), $this.JobLogUtil.log$default$5());
                    $this.quesoutJournalDao.setExportFailed(((Qualitometer)qualito.get()).code(), new DateTime(), new DateTime(), new DateTime(), user, new StringBuilder(28).append("Error while building file : ").append(err.getMessage()).toString(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), true);
                    $this.logUtil().printError(err);
                    return;
                }
                throw new MatchError((Object)try_);
            }
        });
        if (qualitos.isEmpty()) {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No station to export", "", $this.JobLogUtil.log$default$5());
            return;
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$getSelectedStations$1(QesoutController $this, String typ$1, int networkId) {
        return (scala.collection.immutable.Seq)$this.StationNetworkDao.getStations(typ$1, networkId).map((Function1 & Serializable)nl -> BoxesRunTime.boxToInteger((int)nl.idStation()));
    }

    public static final /* synthetic */ int $anonfun$getSelectedStations$5(QualitometerLight pz) {
        return (int)pz.id();
    }

    public static final /* synthetic */ int $anonfun$getSelectedStations$8(PiezometerCode pz) {
        return (int)pz.id();
    }

    public static final /* synthetic */ int $anonfun$getSelectedStations$12(Tuple2 res) {
        return (int)res._2$mcJ$sp();
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$getSelectedStations$10(QesoutController $this, int filterCode) {
        UserFilterWithLinks foundFilter = $this.userFilterDao.get("SIQ", Integer.toString(filterCode));
        return (scala.collection.immutable.Seq)$this.userFilterDao.execute((String)foundFilter.filterSelection().get(), (scala.collection.immutable.Seq)foundFilter.link_parameters().getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).map((Function1 & Serializable)res -> BoxesRunTime.boxToInteger((int)QesoutController.$anonfun$getSelectedStations$12(res)));
    }

    public static final /* synthetic */ int $anonfun$getSelectedStations$16(Tuple2 res) {
        return (int)res._2$mcJ$sp();
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$getSelectedStations$14(QesoutController $this, int filterCode) {
        UserFilterWithLinks foundFilter = $this.userFilterDao.get("SIES", Integer.toString(filterCode));
        return (scala.collection.immutable.Seq)$this.userFilterDao.execute((String)foundFilter.filterSelection().get(), (scala.collection.immutable.Seq)foundFilter.link_parameters().getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).map((Function1 & Serializable)res -> BoxesRunTime.boxToInteger((int)QesoutController.$anonfun$getSelectedStations$16(res)));
    }

    public static final /* synthetic */ boolean $anonfun$getStationValidityErrors$3(Landmark landmark$1, AltimetrySystem alt) {
        return BoxesRunTime.unboxToInt((Object)alt.natureCode().get()) == BoxesRunTime.unboxToInt((Object)landmark$1.altimetrySystemNature().get()) && ((BaseDateTime)alt.startDate().get()).getMillis() == ((BaseDateTime)landmark$1.altimetrySystemDate().get()).getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$getStationValidityErrors$2(scala.collection.immutable.Seq altimetrySystems$1, Landmark landmark) {
        return !altimetrySystems$1.exists((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getStationValidityErrors$3(landmark, alt)));
    }

    public static final /* synthetic */ boolean $anonfun$getStationValidityErrors$4(scala.collection.immutable.Seq landmarks$1, scala.collection.immutable.Seq altimetrySystems$1, PiezometerChronicRawMeasure m) {
        Some some;
        Tuple2 tuple2;
        Option option = PiezometryUtils$.MODULE$.getMeasureLandmarkAndRefAlti(m, landmarks$1, altimetrySystems$1);
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Landmark l = (Landmark)tuple2._1();
            AltimetrySystem alt = (AltimetrySystem)tuple2._2();
            return !l.height().isDefined() || !alt.altitude().isDefined() || !alt.altimetrySystem().isDefined();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getStationValidityErrors$5(scala.collection.immutable.Seq measureMethods$1, PiezometerChronicRawMeasure m) {
        return PiezometryUtils$.MODULE$.getMeasureMethod(m, measureMethods$1).isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$getStationValidityErrors$6(PiezometerChronicRawMeasure m) {
        block11: {
            block12: {
                block10: {
                    var3_1 = new Tuple2((Object)m.status(), (Object)m.qualification());
                    if (var3_1 != null) {
                        var4_2 = (Option)var3_1._1();
                        var5_3 = (Option)var3_1._2();
                        if (var4_2 instanceof Some) {
                            var6_4 = (Some)var4_2;
                            status = BoxesRunTime.unboxToInt((Object)var6_4.value());
                            if (var5_3 instanceof Some) {
                                var8_6 = (Some)var5_3;
                                qualification = BoxesRunTime.unboxToInt((Object)var8_6.value());
                                if (status == 1) {
                                    if (scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 4})).contains((Object)BoxesRunTime.boxToInteger((int)qualification))) {
                                        return None$.MODULE$;
                                    }
                                    return new Some((Object)new StringBuilder(71).append("RG4: measure status 1 must have qualification 0 or 4. Found on measure ").append(DateUtil$.MODULE$.getDate(m.date())).toString());
                                }
                                if (scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})).contains((Object)BoxesRunTime.boxToInteger((int)status))) {
                                    if (scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})).contains((Object)BoxesRunTime.boxToInteger((int)qualification))) {
                                        return None$.MODULE$;
                                    }
                                    return new Some((Object)new StringBuilder(72).append("RG4: status 2, 3, 4 must have qualification 1, 2 or 3. Found on measure ").append(DateUtil$.MODULE$.getDate(m.date())).toString());
                                }
                                return new Some((Object)new StringBuilder(55).append("RG4: invalid status or qualification. Found on measure ").append(DateUtil$.MODULE$.getDate(m.date())).toString());
                            }
                        }
                    }
                    if (var3_1 == null) break block10;
                    var10_8 = (Option)var3_1._1();
                    var11_9 = (Option)var3_1._2();
                    if (!(var10_8 instanceof Some) || 1 != (var13_11 = BoxesRunTime.unboxToInt((Object)(var12_10 = (Some)var10_8).value())) || !None$.MODULE$.equals(var11_9)) break block10;
                    v0 = true;
                    break block11;
                }
                if (var3_1 == null) break block12;
                var14_12 = (Option)var3_1._1();
                var15_13 = (Option)var3_1._2();
                if (!None$.MODULE$.equals(var14_12) || !(var15_13 instanceof Some) || 4 != (var17_15 = BoxesRunTime.unboxToInt((Object)(var16_14 = (Some)var15_13).value()))) break block12;
                v0 = true;
                break block11;
            }
            if (var3_1 == null) ** GOTO lbl-1000
            var18_16 = (Option)var3_1._1();
            var19_17 = (Option)var3_1._2();
            if (None$.MODULE$.equals(var18_16) && None$.MODULE$.equals(var19_17)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            return None$.MODULE$;
        }
        return new Some((Object)new StringBuilder(65).append("RG4: measure status or qualification undefined. Found on measure ").append(DateUtil$.MODULE$.getDate(m.date())).toString());
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$11(double x$13) {
        return Integer.toString((int)x$13);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$13(double x$14) {
        return Integer.toString((int)x$14);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$15(double x$15) {
        return Integer.toString((int)x$15);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$17(double x$16) {
        return Integer.toString((int)x$16);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$19(double x$17) {
        return Integer.toString((int)x$17);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$21(double x$18) {
        return Integer.toString((int)x$18);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$23(double x$19) {
        return Integer.toString((int)x$19);
    }

    public static final /* synthetic */ String $anonfun$getStationValidityErrors$25(double x$20) {
        return Integer.toString((int)x$20);
    }

    public static final /* synthetic */ boolean $anonfun$getExportDates$2(String bssCode$1, QuesoutJournal j) {
        String string = j.bssCode();
        String string2 = bssCode$1;
        return !(string != null ? !string.equals(string2) : string2 != null) && j.sendDate().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getExportDates$3(String bssCode$1, QuesoutJournal j) {
        String string = j.bssCode();
        String string2 = bssCode$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$getExportDates$5(QuesoutJournal x$23) {
        return BoxesRunTime.unboxToLong((Object)x$23.oldestUpdateWithSent().map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)x$24.getMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$executeAcknoledgment$1(QesoutController $this, Seq error) {
        Predef$.MODULE$.print((Object)error);
        $this.logUtil().error(new StringBuilder(22).append("Error validate Json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil().error$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$executeAcknoledgment$10(String starts$1, String ends$1, File f) {
        return f.getName().startsWith(starts$1) && f.getName().endsWith(ends$1);
    }

    public static final /* synthetic */ boolean $anonfun$executeAcknoledgment$11(scala.collection.immutable.Seq processedFiles$1, File f) {
        return !processedFiles$1.contains((Object)f.getName());
    }

    private final void manageFile$1(boolean withJournal, boolean quality, File f$1, String code$2, String num$1, DateTime sendDate$1, String user$3, long jobExecutionId$3, boolean deletePositiveFiles$1, String directory$3, String fileName$1) {
        block6: {
            Elem xmlResult = (Elem)XML$.MODULE$.loadFile(f$1);
            NodeSeq arNode = xmlResult.$bslash("AccuseReception");
            String string = arNode.$bslash("Acceptation").text();
            switch (string == null ? 0 : string.hashCode()) {
                case 49: {
                    if (!"1".equals(string)) break;
                    int n = withJournal ? this.quesoutJournalDao.positiveAck(code$2, StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num$1)), sendDate$1, user$3, "positive ACK", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$3)), quality) : this.quesoutJournalDao.positiveAckHistory(code$2, StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num$1)), sendDate$1, user$3, "positive ACK", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$3)), quality);
                    this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.SUCCESS(), new StringBuilder(62).append("Integration from ").append(DateUtil$.MODULE$.getDate(sendDate$1)).append(" n\u00b0").append(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(num$1))).append(", station ").append(code$2).append(" has been exported successfully.").toString(), code$2, this.JobLogUtil.log$default$5());
                    if (!deletePositiveFiles$1) break block6;
                    String exportName = f$1.getName().replace("_ACK", "");
                    if (f$1.delete()) {
                        this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.INFO(), new StringBuilder(15).append("File deleted : ").append(f$1.getName()).toString(), code$2, this.JobLogUtil.log$default$5());
                    }
                    if (Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> new File(new StringBuilder(1).append(directory$3).append("/").append(exportName).toString()).delete()).toOption().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                        this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.INFO(), new StringBuilder(15).append("File deleted : ").append(exportName).toString(), code$2, this.JobLogUtil.log$default$5());
                    }
                    break block6;
                }
                case 50: {
                    if (!"2".equals(string)) break;
                    int n = withJournal ? this.quesoutJournalDao.negativeAck(code$2, StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num$1)), sendDate$1, user$3, "negative ACK", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$3)), quality) : this.quesoutJournalDao.negativeAckHistory(code$2, StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num$1)), sendDate$1, user$3, "negative ACK", (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$3)), quality);
                    NodeSeq errors = arNode.$bslash$bslash("Erreur").$bslash("DescriptifErreur");
                    errors.groupBy((Function1 & Serializable)node -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])node.text().split(" ")))).foreach((Function1 & Serializable)couple -> {
                        this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.ERROR(), new StringBuilder(4).append((String)couple._1()).append(" [").append(((NodeSeq)couple._2()).length()).append("] ").append(((Node)((IterableOps)couple._2()).head()).text()).toString(), code$2, this.JobLogUtil.log$default$5());
                        return BoxedUnit.UNIT;
                    });
                    break block6;
                }
            }
            this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Unknown ack status  : ").append(string).toString(), code$2, fileName$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$executeAcknoledgment$17(long sendDateMillis$1, QuesoutJournal j) {
        return ((BaseDateTime)j.sendDate().get()).getMillis() == sendDateMillis$1;
    }

    public static final /* synthetic */ boolean $anonfun$executeAcknoledgment$18(long sendDateMillis$1, QuesoutJournal j) {
        return ((BaseDateTime)j.sendDate().get()).getMillis() == sendDateMillis$1;
    }

    public static final /* synthetic */ void $anonfun$executeAcknoledgment$12(QesoutController $this, DateTimeFormatter dtf$1, String user$3, long jobExecutionId$3, boolean deletePositiveFiles$1, String directory$3, scala.collection.immutable.Seq waitingToAckQuality$1, scala.collection.immutable.Seq waitingToAckPiezo$1, File f) {
        String fileName = f.getName();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            List list;
            String code;
            String num;
            block10: {
                List list2;
                block9: {
                    .colon.colon colon2;
                    List list3;
                    list2 = Predef$.MODULE$.wrapRefArray((Object[])fileName.split("_")).toList();
                    if (!(list2 instanceof .colon.colon) || !((list3 = (colon2 = (.colon.colon)list2).next$access$1()) instanceof .colon.colon)) break block9;
                    .colon.colon colon3 = (.colon.colon)list3;
                    num = (String)colon3.head();
                    List list4 = colon3.next$access$1();
                    if (!(list4 instanceof .colon.colon)) break block9;
                    .colon.colon colon4 = (.colon.colon)list4;
                    code = (String)colon4.head();
                    list = colon4.next$access$1();
                    if (list instanceof .colon.colon) break block10;
                }
                throw new MatchError((Object)list2);
            }
            .colon.colon colon5 = (.colon.colon)list;
            String sendDateStr = (String)colon5.head();
            Tuple3 tuple3 = new Tuple3((Object)num, (Object)code, (Object)sendDateStr);
            String num2 = (String)tuple3._1();
            String code2 = (String)tuple3._2();
            String sendDateStr2 = (String)tuple3._3();
            DateTime sendDate = dtf$1.parseDateTime(sendDateStr2).withMillisOfSecond(0);
            long sendDateMillis = sendDate.getMillis();
            boolean quality = $this.AdesExportDao.isAdesQualite(code2, StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num2)));
            if (quality && waitingToAckQuality$1.exists((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeAcknoledgment$17(sendDateMillis, j)))) {
                $this.manageFile$1(true, quality, f, code2, num2, sendDate, user$3, jobExecutionId$3, deletePositiveFiles$1, directory$3, fileName);
            } else if (!quality && waitingToAckPiezo$1.exists((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeAcknoledgment$18(sendDateMillis, j)))) {
                $this.manageFile$1(true, quality, f, code2, num2, sendDate, user$3, jobExecutionId$3, deletePositiveFiles$1, directory$3, fileName);
            } else if ($this.AdesExportDao.findHistory(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num2)), quality).isDefined()) {
                $this.manageFile$1(false, quality, f, code2, num2, sendDate, user$3, jobExecutionId$3, deletePositiveFiles$1, directory$3, fileName);
            } else {
                $this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.ERROR(), "Can't find exported file on ades_historique", code2, fileName);
            }
            $this.JobLogUtil.setFileProcessed(f, jobExecutionId$3);
        });
        if (try_ instanceof Success) {
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.logUtil().printError(e);
            $this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.ERROR(), new StringBuilder(58).append("Can't read file data, possible corrupted file : ").append(fileName).append(", error : ").append(e.getMessage()).toString(), fileName, fileName);
        } else {
            throw new MatchError((Object)try_);
        }
        Thread.sleep(1L);
    }

    public static final /* synthetic */ void $anonfun$executeAcknoledgment$4(QesoutController $this, JobParameters jobParameters$1, long jobExecutionId$3, String user$3) {
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"ddMMYYYY-HHmmss");
        String baseDir = StringUtil$.MODULE$.getPath((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"EXPORT_DIRECTORY", (Function0 & Serializable)() -> ""));
        String directory = StringUtil$.MODULE$.getPath(new StringBuilder(0).append(baseDir).append(jobParameters$1.path().getOrElse((Function0 & Serializable)() -> "")).toString());
        scala.collection.immutable.Seq processedFiles = $this.JobLogUtil.getProcessedFileNames(jobExecutionId$3);
        scala.collection.immutable.Seq waitingToAckPiezo = $this.quesoutJournalDao.getAllSentWaitingAck(false);
        scala.collection.immutable.Seq waitingToAckQuality = $this.quesoutJournalDao.getAllSentWaitingAck(true);
        String filter = (String)jobParameters$1.pathType().getOrElse((Function0 & Serializable)() -> "*_ACK.xml");
        boolean deletePositiveFiles = jobParameters$1.propertiesFile().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
        IndexedSeq splitted = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filter.split("\\*"));
        String starts = splitted.nonEmpty() ? (String)splitted.head() : filter;
        String ends = splitted.length() > 1 ? (String)splitted.apply(1) : "";
        List testFiles = (List)Try$.MODULE$.apply((Function0 & Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])new File(directory).listFiles()).toList()).toOption().getOrElse((Function0 & Serializable)() -> {
            throw new Exception("Erreur lors de la localisation du r\u00e9pertoire d'export");
        });
        List files = testFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeAcknoledgment$10(starts, ends, f)));
        List filesToProcess = files.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeAcknoledgment$11(processedFiles, f)));
        if (filesToProcess.nonEmpty()) {
            filesToProcess.foreach((Function1 & Serializable)f -> {
                QesoutController.$anonfun$executeAcknoledgment$12($this, dtf, user$3, jobExecutionId$3, deletePositiveFiles, directory, waitingToAckQuality, waitingToAckPiezo, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
        $this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.NOTHING_TO_DO(), "No files to process.", "", $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$executeAcknoledgment$2(QesoutController $this, JobParameters jobParameters) {
        String user;
        long jobExecutionId = jobParameters.jobExecutionId();
        Try try_ = Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> QesoutController.$anonfun$executeAcknoledgment$4($this, jobParameters, jobExecutionId, user = (String)jobParameters.user().getOrElse((Function0 & Serializable)() -> "unknown ack job"))));
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.logUtil().printError(e);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(8).append("Error : ").append(e.getMessage()).toString(), "", $this.JobLogUtil.log$default$5());
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Inject
    public QesoutController(LogUtil LogUtil2, JobLogUtil JobLogUtil2, QesoutBuilder QesoutBuilder2, PiezometerDaeau piezometerDaeau, PiezometerMeasureDao piezometerMeasureDao, StationAltimetrySystemDao altimetrySystemDao, StationLandmarkDao landmarkDao, StationMeasureMethodDao measureMethodDao, StationNetworkDao StationNetworkDao2, NetworkDao NetworkDao2, StationDespoliationModeDao stationDespoliationDao, StationTempRefDao stationTempRefDao, UserFilterDao userFilterDao, PiezometryEventDao piezometryEventDao, ContributorsDao contributorsDao, AnalysisDao analysisDao2, QualitometerDao qualitometerDao, JobFileDao jobFileDao, QesoutQuality QesoutQuality2, QuesoutJournalDao quesoutJournalDao, AdesExportDao AdesExportDao2, StationFunctionDao StationFunctionDao2, StationUsageDao StationUsageDao2, Database database) {
        this.JobLogUtil = JobLogUtil2;
        this.QesoutBuilder = QesoutBuilder2;
        this.piezometerDaeau = piezometerDaeau;
        this.piezometerMeasureDao = piezometerMeasureDao;
        this.altimetrySystemDao = altimetrySystemDao;
        this.landmarkDao = landmarkDao;
        this.measureMethodDao = measureMethodDao;
        this.StationNetworkDao = StationNetworkDao2;
        this.NetworkDao = NetworkDao2;
        this.stationDespoliationDao = stationDespoliationDao;
        this.stationTempRefDao = stationTempRefDao;
        this.userFilterDao = userFilterDao;
        this.piezometryEventDao = piezometryEventDao;
        this.contributorsDao = contributorsDao;
        this.analysisDao2 = analysisDao2;
        this.qualitometerDao = qualitometerDao;
        this.jobFileDao = jobFileDao;
        this.QesoutQuality = QesoutQuality2;
        this.quesoutJournalDao = quesoutJournalDao;
        this.AdesExportDao = AdesExportDao2;
        this.StationFunctionDao = StationFunctionDao2;
        this.StationUsageDao = StationUsageDao2;
        this.database = database;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$getQesoutMeasuresBy5Years$5$adapted(Option lastDay$2, PiezometerChronicRawMeasure m) {
        return BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$getQesoutMeasuresBy5Years$5(lastDay$2, m));
    }

    public static final /* synthetic */ Object $anonfun$executeQESOUT$14$adapted(Option lastDay$1, PiezometerChronicRawMeasure m) {
        return BoxesRunTime.boxToBoolean((boolean)QesoutController.$anonfun$executeQESOUT$14(lastDay$1, m));
    }

    public static final /* synthetic */ Object $anonfun$executeQESOUT$20$adapted(Piezometer piezo$1, String minDateReq$1, Connection c) {
        return BoxesRunTime.boxToInteger((int)QesoutController.$anonfun$executeQESOUT$20(piezo$1, minDateReq$1, c));
    }
}

