/*
 * Decompiled with CFR 0.152.
 */
package qesout.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.despoliationMode.DespoliationMode;
import fr.aquasys.daeau.station.links.functions.StationFunction;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Reads;
import qesout.util.XmlBuilder$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\u0004\b\u00011A\u0001b\b\u0001\u0003\u0002\u0003\u0006Y\u0001\t\u0005\tK\u0001\u0011\t\u0011)A\u0006M!)!\u0007\u0001C\u0001g!)!\t\u0001C\u0001\u0007\"9\u0011Q\n\u0001\u0005\u0002\u0005=#!E)fg>,H\u000fR3tGJL\u0007\u000f^5p]*\u0011\u0001\"C\u0001\u0005kRLGNC\u0001\u000b\u0003\u0019\tXm]8vi\u000e\u00011c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000f\u000e\u0003UQ!AF\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u00193\u0005A!/\u00192cSRl\u0017O\u0003\u0002\u001b7\u00059\u0011-];bgf\u001c(\"\u0001\u000f\u0002\u0005\u0019\u0014\u0018B\u0001\u0010\u0016\u0005!\u0001&o\u001c3vG\u0016\u0014\u0018a\u00027pOV#\u0018\u000e\u001c\t\u0003C\rj\u0011A\t\u0006\u0003\u0011]I!\u0001\n\u0012\u0003\u000f1{w-\u0016;jY\u0006i1+\u00198ee\u0016\u001cu\u000eZ3EC>\u0004\"a\n\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0007\u0011\fwN\u0003\u0002,Y\u0005Q1/\u00198ee\u0016\u001cu\u000eZ3\u000b\u00055r\u0013\u0001\u0004:fM\u0016\u0014XM\u001c;jC2\u001c(BA\u0018\u001a\u0003\u0015!\u0017-Z1v\u0013\t\t\u0004FA\u0007TC:$'/Z\"pI\u0016$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\"2!N\u001c9!\t1\u0004!D\u0001\b\u0011\u0015y2\u0001q\u0001!\u0011\u0015)3\u0001q\u0001'Q\t\u0019!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u00051\u0011N\u001c6fGRT\u0011aP\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0003r\u0012a!\u00138kK\u000e$\u0018\u0001E4fi:{G-Z0Q_&tG/R1v)9!%\n\u00167v}\u0006=\u0011\u0011EA\u0017\u0003{\u0001\"!\u0012%\u000e\u0003\u0019S!aR\b\u0002\u0007alG.\u0003\u0002J\r\n!aj\u001c3f\u0011\u0015YE\u00011\u0001M\u0003\u0015\u0001\u0018.\u001a>p!\ti%+D\u0001O\u0015\ty\u0005+A\u0003n_\u0012,GN\u0003\u0002R]\u0005Q\u0001/[3{_6,GO]=\n\u0005Ms%A\u0003)jKj|W.\u001a;fe\")Q\u000b\u0002a\u0001-\u0006IA.\u00198e[\u0006\u00148n\u001d\t\u0004/~\u0013gB\u0001-^\u001d\tIF,D\u0001[\u0015\tY6\"\u0001\u0004=e>|GOP\u0005\u0002!%\u0011alD\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0017MA\u0002TKFT!AX\b\u0011\u0005\rTW\"\u00013\u000b\u0005\u00154\u0017\u0001\u00037b]\u0012l\u0017M]6\u000b\u0005\u001dD\u0017!\u00027j].\u001c(BA5/\u0003\u001d\u0019H/\u0019;j_:L!a\u001b3\u0003\u00111\u000bg\u000eZ7be.DQ!\u001c\u0003A\u00029\f\u0001#\u00197uS6,GO]=TsN$X-\\:\u0011\u0007]{v\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002sM\u0006y\u0011\r\u001c;j[\u0016$(/_*zgR,W.\u0003\u0002uc\ny\u0011\t\u001c;j[\u0016$(/_*zgR,W\u000eC\u0003w\t\u0001\u0007q/\u0001\buS6,'+\u001a4fe\u0016t7-Z:\u0011\u0007]{\u0006\u0010\u0005\u0002zy6\t!P\u0003\u0002|M\u00069A/Z7q%\u00164\u0017BA?{\u00059\u0019F/\u0019;j_:$V-\u001c9SK\u001aDaa \u0003A\u0002\u0005\u0005\u0011!\u00053fgB|G.[1uS>tWj\u001c3fgB!qkXA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005M\u0006\u0001B-Z:q_2L\u0017\r^5p]6{G-Z\u0005\u0005\u0003\u001b\t9A\u0001\tEKN\u0004x\u000e\\5bi&|g.T8eK\"9\u0011\u0011\u0003\u0003A\u0002\u0005M\u0011AD7fCN,(/Z'fi\"|Gm\u001d\t\u0005/~\u000b)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBZ\u0001\u000e[\u0016\f7/\u001e:f\u001b\u0016$\bn\u001c3\n\t\u0005}\u0011\u0011\u0004\u0002\u000e\u001b\u0016\f7/\u001e:f\u001b\u0016$\bn\u001c3\t\u000f\u0005\rB\u00011\u0001\u0002&\u00051QM^3oiN\u0004BaV0\u0002(A\u0019Q*!\u000b\n\u0007\u0005-bJA\bQS\u0016Tx.\\3uef,e/\u001a8u\u0011\u001d\ty\u0003\u0002a\u0001\u0003c\t\u0011BZ;oGRLwN\\:\u0011\t]{\u00161\u0007\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0019\u0011q\u00064\n\t\u0005m\u0012q\u0007\u0002\u0010'R\fG/[8o\rVt7\r^5p]\"9\u0011q\b\u0003A\u0002\u0005\u0005\u0013AB;tC\u001e,7\u000f\u0005\u0003X?\u0006\r\u0003\u0003BA#\u0003\u0013j!!a\u0012\u000b\u0007\u0005}b-\u0003\u0003\u0002L\u0005\u001d#!B+tC\u001e,\u0017\u0001F4fi\u000e{G-\u001a\"z\t\u0016\u001c\u0018n\u001a8bi&|g\u000e\u0006\u0003\u0002R\u0005\u0005\u0004\u0003BA*\u00037rA!!\u0016\u0002XA\u0011\u0011lD\u0005\u0004\u00033z\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002^\u0005}#AB*ue&twMC\u0002\u0002Z=AQaS\u0003A\u00021\u0003")
public class QesoutDescription
implements Producer {
    private final SandreCodeDao SandreCodeDao;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        QesoutDescription qesoutDescription = this;
        synchronized (qesoutDescription) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Node getNode_PointEau(Piezometer piezo, scala.collection.immutable.Seq<Landmark> landmarks, scala.collection.immutable.Seq<AltimetrySystem> altimetrySystems, scala.collection.immutable.Seq<StationTempRef> timeReferences, scala.collection.immutable.Seq<DespoliationMode> despoliationModes, scala.collection.immutable.Seq<MeasureMethod> measureMethods, scala.collection.immutable.Seq<PiezometryEvent> events, scala.collection.immutable.Seq<StationFunction> functions, scala.collection.immutable.Seq<Usage> usages) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Comment(" A: Ajout\u00e9, M: Modifi\u00e9, S: Supprim\u00e9"));
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("schemeID", (Seq)new Text("PTE"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.getCodeByDesignation(piezo));
        $buf.$amp$plus((Object)new Elem(null, "CdNationalPointEau", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("listID", (Seq)new Text("188"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(piezo.waterSourceType().getOrElse((Function0 & Serializable)() -> "0"));
        $buf.$amp$plus((Object)new Elem(null, "TypDePointEau", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus(piezo.name().getOrElse((Function0 & Serializable)() -> ""));
        $buf.$amp$plus((Object)new Elem(null, "LbPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus(piezo.altitude().getOrElse((Function0 & Serializable)() -> ""));
        $buf.$amp$plus((Object)new Elem(null, "AltitudePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus(piezo.address().getOrElse((Function0 & Serializable)() -> ""));
        $buf.$amp$plus((Object)new Elem(null, "AdPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)piezo.updateDate()));
        $buf.$amp$plus((Object)new Elem(null, "DateMAJPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus(piezo.fieldMode().map((Function1 & Serializable)fm -> QesoutDescription.$anonfun$getNode_PointEau$5(BoxesRunTime.unboxToInt((Object)fm))).getOrElse((Function0 & Serializable)() -> ""));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus(piezo.x().getOrElse((Function0 & Serializable)() -> ""));
        $buf8.$amp$plus((Object)new Elem(null, "CoordXPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus(piezo.y().getOrElse((Function0 & Serializable)() -> ""));
        $buf8.$amp$plus((Object)new Elem(null, "CoordYPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("listID", (Seq)new Text("22"), (MetaData)$md3);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus(piezo.projection().getOrElse((Function0 & Serializable)() -> ""));
        $buf8.$amp$plus((Object)new Elem(null, "ProjCoordPointEau", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "CoordPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n                "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("listID", (Seq)new Text("146"), (MetaData)$md4);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus(piezo.stateCode().getOrElse((Function0 & Serializable)() -> "0"));
        $buf12.$amp$plus((Object)new Elem(null, "CdEtatPointEau", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "EtatPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n                "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("listID", (Seq)new Text("149"), (MetaData)$md5);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus(piezo.nature().getOrElse((Function0 & Serializable)() -> ""));
        $buf14.$amp$plus((Object)new Elem(null, "CdNaturePointEau", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf14.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "NaturePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus(piezo.townCode().getOrElse((Function0 & Serializable)() -> ""));
        $buf16.$amp$plus((Object)new Elem(null, "CdCommune", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf16.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "Commune", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus(events.map((Function1 & Serializable)e -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)new Some(e.date().getOrElse((Function0 & Serializable)() -> (DateTime)e.startDate().get()))));
            $buf.$amp$plus((Object)new Elem(null, "DateEvenementPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n                        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(e.comment().getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Elem(null, "DsEvenementPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            return new Elem(null, "EvenementPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus(landmarks.map((Function1 & Serializable)landmark -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)landmark.startDate()));
            $buf.$amp$plus((Object)new Elem(null, "DateDebValiditeReperePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(landmark.endDate().map((Function1 & Serializable)d -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)new Some(d)));
                return new Elem(null, "DateFinValiditeReperePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(landmark.height().get());
            $buf.$amp$plus((Object)new Elem(null, "HauteurReperePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(landmark.comment().map((Function1 & Serializable)c -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(c);
                return new Elem(null, "ComReperePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(((IterableOps)altimetrySystems.filter((Function1 & Serializable)alt -> BoxesRunTime.boxToBoolean((boolean)QesoutDescription.$anonfun$getNode_PointEau$21(landmark, alt)))).map((Function1 & Serializable)alt -> {
                void var1_1;
                void var3_3;
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n                                "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)alt.startDate()));
                $buf.$amp$plus((Object)new Elem(null, "DateDebValiditeRefAltimetrique", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
                $buf.$amp$plus((Object)new Text("\n                                "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n                                    "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("listID", (Seq)new Text("171"), (MetaData)$md);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus(alt.natureCode().get());
                $buf3.$amp$plus((Object)new Elem(null, "CdNatureRefAltimetrique", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
                $buf3.$amp$plus((Object)new Text("\n                                "));
                $buf.$amp$plus((Object)new Elem(null, "NatureRefAltimetrique", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
                $buf.$amp$plus((Object)new Text("\n                            "));
                return new Elem(null, "RefAltimetriquePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }));
            $buf.$amp$plus((Object)new Text("\n                "));
            return new Elem(null, "ReperePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
        }));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus(((IterableOps)functions.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QesoutDescription.$anonfun$getNode_PointEau$23(x$1)))).map((Function1 & Serializable)fun -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)fun.startDate()));
            $buf.$amp$plus((Object)new Elem(null, "DateDebUtilisationPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(fun.endDate().map((Function1 & Serializable)d -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)new Some(d)));
                return new Elem(null, "DateFinUtilisationPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf3 = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("listID", (Seq)new Text("148"), (MetaData)$md);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus(fun.functionCode().get());
            $buf3.$amp$plus((Object)new Elem(null, "CdFctionPointEau", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Elem(null, "FctionPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                "));
            return new Elem(null, "PeriodeUtilisationPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus(altimetrySystems.map((Function1 & Serializable)alt -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("listID", (Seq)new Text("171"), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(alt.natureCode().get());
            $buf2.$amp$plus((Object)new Elem(null, "CdNatureRefAltimetrique", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n                        "));
            $buf2.$amp$plus($this.SandreCodeDao.findByCode("SYSTEME_ALTIMETRIQUE.CODENATURE", BoxesRunTime.unboxToInt((Object)alt.natureCode().get())).map((Function1 & Serializable)lib -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)lib.name());
                return new Elem(null, "LbNatureRefAltimetrique", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf2.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus((Object)new Elem(null, "NatureRefAltimetrique", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)alt.startDate()));
            $buf.$amp$plus((Object)new Elem(null, "DateDebValiditeRefAltimetrique", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(alt.endDate().map((Function1 & Serializable)d -> {
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)alt.endDate()));
                return new Elem(null, "DateFinValiditeRefAltimetrique", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus(alt.altitude().get());
            $buf.$amp$plus((Object)new Elem(null, "AltitudeRefAltimetriquePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("listID", (Seq)new Text("76"), (MetaData)$md2);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus(alt.altimetrySystem().get());
            $buf.$amp$plus((Object)new Elem(null, "SystAltimetriqueRefPointEau", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(alt.productionMode().map((Function1 & Serializable)prod -> QesoutDescription.$anonfun$getNode_PointEau$32(BoxesRunTime.unboxToInt((Object)prod))).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(alt.comment().map((Function1 & Serializable)com -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(com);
                return new Elem(null, "ComRefAltimetriquePointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                "));
            return new Elem(null, "RefAltiPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
        }));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus(((IterableOps)usages.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QesoutDescription.$anonfun$getNode_PointEau$36(x$2)))).map((Function1 & Serializable)us -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)us.startDate()));
            $buf.$amp$plus((Object)new Elem(null, "DateDebUtilisationEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus(us.endDate().map((Function1 & Serializable)d -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)new Some(d)));
                return new Elem(null, "DateFinUtilisationEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            NodeBuffer $buf3 = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("listID", (Seq)new Text("481"), (MetaData)$md);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus(us.usageCode().get());
            $buf3.$amp$plus((Object)new Elem(null, "CdUsageEau", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Elem(null, "UsageEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                "));
            return new Elem(null, "PeriodeUtilisationEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n                "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("listID", (Seq)new Text("170"), (MetaData)$md6);
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("2"));
        $buf18.$amp$plus((Object)new Elem(null, "ExpCoteChroniquePiezometre", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf18.$amp$plus((Object)new Text("\n                "));
        $buf18.$amp$plus(piezo.comment().map((Function1 & Serializable)comment -> {
            void var1_1;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(comment);
            return new Elem(null, "ComPiezometre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }).getOrElse((Function0 & Serializable)() -> ""));
        $buf18.$amp$plus((Object)new Text("\n                "));
        $buf18.$amp$plus(timeReferences.map((Function1 & Serializable)timeRef -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)timeRef.startDate()));
            $buf.$amp$plus((Object)new Elem(null, "DateDebValiditeRefTemporelle", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(timeRef.endDate().map((Function1 & Serializable)d -> {
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)timeRef.endDate()));
                return new Elem(null, "DateFinValiditeRefTemporelle", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n                            "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("listID", (Seq)new Text("187"), (MetaData)$md);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus(timeRef.tempRef().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("R\u00e9f\u00e9rence temporelle incompl\u00e8te. Veuillez la rensigner correctement dans la description du point.");
            }));
            $buf3.$amp$plus((Object)new Elem(null, "CdRefTemporelle", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf3.$amp$plus((Object)new Text("\n                            "));
            $buf3.$amp$plus($this.SandreCodeDao.findByCode("REF_TEMPORELLES", (int)BoxesRunTime.unboxToLong((Object)timeRef.tempRef().get())).map((Function1 & Serializable)lib -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)lib.name());
                return new Elem(null, "LbRefTemporelle", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf3.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus((Object)new Elem(null, "RefTemporelle", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf.$amp$plus((Object)new Text("\n                    "));
            return new Elem(null, "PeriodeValiditeRefTemporelle", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
        }));
        $buf18.$amp$plus((Object)new Text("\n                "));
        $buf18.$amp$plus(despoliationModes.map((Function1 & Serializable)mode -> {
            void var1_1;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)new Some((Object)mode.startDate())));
            $buf.$amp$plus((Object)new Elem(null, "DateDebUtilisationDepuillement", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(mode.endDate().map((Function1 & Serializable)d -> {
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)mode.endDate()));
                return new Elem(null, "DateFinUtilisationDepuillement", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("listID", (Seq)new Text("164"), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(mode.despoliationMode().get());
            $buf.$amp$plus((Object)new Elem(null, "MethodeDepouillement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(mode.comment().map((Function1 & Serializable)com -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(com);
                return new Elem(null, "ComModeDepouillement", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                    "));
            return new Elem(null, "ModeDepouillementPiezo", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf18.$amp$plus((Object)new Text("\n                "));
        $buf18.$amp$plus(measureMethods.map((Function1 & Serializable)meth2 -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)meth2.startDate()));
            $buf.$amp$plus((Object)new Elem(null, "DateDebUtilisationModeMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(meth2.endDate().map((Function1 & Serializable)d -> {
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)meth2.endDate()));
                return new Elem(null, "DateFinUtilisationModeMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(meth2.method().map((Function1 & Serializable)m -> QesoutDescription.$anonfun$getNode_PointEau$56(BoxesRunTime.unboxToDouble((Object)m))).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(meth2.periodicity().flatMap((Function1 & Serializable)periodicity -> QesoutDescription.$anonfun$getNode_PointEau$58(this, BoxesRunTime.unboxToInt((Object)periodicity))).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(meth2.comment().map((Function1 & Serializable)com -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(com);
                return new Elem(null, "ComModeMesurePiezo", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(meth2.precision().map((Function1 & Serializable)meth -> QesoutDescription.$anonfun$getNode_PointEau$64(BoxesRunTime.unboxToInt((Object)meth))).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n                        "));
            $buf.$amp$plus(meth2.periodicityAcqui().map((Function1 & Serializable)acqui -> QesoutDescription.$anonfun$getNode_PointEau$66(BoxesRunTime.unboxToInt((Object)acqui))).getOrElse((Function0 & Serializable)() -> {
                void var0;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("0"));
                return new Elem(null, "PeriodiciteAcquisition", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var0));
            }));
            $buf.$amp$plus((Object)new Text("\n                    "));
            return new Elem(null, "ModeMesurePiezo", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
        }));
        $buf18.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "Piezometre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "PointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public String getCodeByDesignation(Piezometer piezo) {
        if (piezo.code().toUpperCase().startsWith("BSS")) {
            return piezo.code();
        }
        Object object = piezo.designation().getOrElse((Function0 & Serializable)() -> "");
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            return new StringBuilder(1).append(piezo.code()).append("/").append(piezo.designation().getOrElse((Function0 & Serializable)() -> "")).toString();
        }
        return piezo.code();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$getNode_PointEau$5(int fm) {
        void var2_2;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("listID", (Seq)new Text("81"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)fm));
        return new Elem(null, "ModeGisement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getNode_PointEau$21(Landmark landmark$1, AltimetrySystem alt) {
        if (BoxesRunTime.unboxToInt((Object)alt.natureCode().get()) != BoxesRunTime.unboxToInt((Object)landmark$1.altimetrySystemNature().get())) return false;
        String string = XmlBuilder$.MODULE$.getDate((Option<DateTime>)alt.startDate());
        String string2 = XmlBuilder$.MODULE$.getDate((Option<DateTime>)landmark$1.altimetrySystemDate());
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getNode_PointEau$23(StationFunction x$1) {
        return x$1.functionCode().isDefined();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$getNode_PointEau$32(int prod) {
        void var2_2;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("listID", (Seq)new Text("172"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)prod));
        return new Elem(null, "ModeObtentionAltitude", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public static final /* synthetic */ boolean $anonfun$getNode_PointEau$36(Usage x$2) {
        return x$2.usageCode().isDefined();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$getNode_PointEau$56(double m) {
        void var3_2;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("listID", (Seq)new Text("79"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)((int)m)));
        return new Elem(null, "MethodeMesure", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_2));
    }

    public static final /* synthetic */ boolean $anonfun$getNode_PointEau$59(SandreCode x$3) {
        return x$3.name().length() == 7;
    }

    public static final /* synthetic */ Option $anonfun$getNode_PointEau$58(QesoutDescription $this, int periodicity) {
        return $this.SandreCodeDao.findByCode("MODES_MESURES.PERIODICITE", periodicity).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)QesoutDescription.$anonfun$getNode_PointEau$59(x$3))).map((Function1 & Serializable)p -> {
            void var1_1;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)p.name());
            return new Elem(null, "PeriodiciteMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$getNode_PointEau$64(int meth) {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)meth));
        return new Elem(null, "PrecisionMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$getNode_PointEau$66(int acqui) {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)acqui));
        return new Elem(null, "PeriodiciteAcquisition", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
    }

    @Inject
    public QesoutDescription(LogUtil logUtil, SandreCodeDao SandreCodeDao2) {
        this.SandreCodeDao = SandreCodeDao2;
        Producer.$init$((Producer)this);
    }
}

