/*
 * Decompiled with CFR 0.152.
 */
package qesout.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.measure.PiezometerChronicRawMeasure;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.PiezometryUtils$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Reads;
import qesout.util.XmlBuilder$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\u0004\b\u00011A\u0001b\b\u0001\u0003\u0002\u0003\u0006Y\u0001\t\u0005\u0006K\u0001!\tA\n\u0005\u0006i\u0001!\t!\u000e\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\u0011a\"U3t_V$\u0018+^1oi&$\u0018P\u0003\u0002\t\u0013\u0005!Q\u000f^5m\u0015\u0005Q\u0011AB9fg>,Ho\u0001\u0001\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)ui\u0011!\u0006\u0006\u0003-]\t1!\u00199j\u0015\tA\u0012$\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\tQ2$A\u0004bcV\f7/_:\u000b\u0003q\t!A\u001a:\n\u0005y)\"\u0001\u0003)s_\u0012,8-\u001a:\u0002\u000f1|w-\u0016;jYB\u0011\u0011eI\u0007\u0002E)\u0011\u0001bF\u0005\u0003I\t\u0012q\u0001T8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002OQ\u0011\u0001F\u000b\t\u0003S\u0001i\u0011a\u0002\u0005\u0006?\t\u0001\u001d\u0001\t\u0015\u0003\u00051\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\r%t'.Z2u\u0015\u0005\t\u0014!\u00026bm\u0006D\u0018BA\u001a/\u0005\u0019IeN[3di\u0006\u0001r-\u001a;O_\u0012,w,U;b]RLG/\u001a\u000b\tmqBE,\u001b:\u0002\u0006A\u0011qGO\u0007\u0002q)\u0011\u0011hD\u0001\u0004q6d\u0017BA\u001e9\u0005\u0011qu\u000eZ3\t\u000bu\u001a\u0001\u0019\u0001 \u0002\u000bALWM_8\u0011\u0005}2U\"\u0001!\u000b\u0005\u0005\u0013\u0015!B7pI\u0016d'BA\"E\u0003)\u0001\u0018.\u001a>p[\u0016$(/\u001f\u0006\u0003\u000bf\tQ\u0001Z1fCVL!a\u0012!\u0003\u0015AKWM_8nKR,'\u000fC\u0003J\u0007\u0001\u0007!*\u0001\u0005nK\u0006\u001cXO]3t!\rY5K\u0016\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!aT\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001*\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0007M+\u0017O\u0003\u0002S\u001fA\u0011qKW\u0007\u00021*\u0011\u0011\fQ\u0001\b[\u0016\f7/\u001e:f\u0013\tY\u0006LA\u000eQS\u0016Tx.\\3uKJ\u001c\u0005N]8oS\u000e\u0014\u0016m^'fCN,(/\u001a\u0005\u0006;\u000e\u0001\rAX\u0001\nY\u0006tG-\\1sWN\u00042aS*`!\t\u0001w-D\u0001b\u0015\t\u00117-\u0001\u0005mC:$W.\u0019:l\u0015\t!W-A\u0003mS:\\7O\u0003\u0002g\t\u000691\u000f^1uS>t\u0017B\u00015b\u0005!a\u0015M\u001c3nCJ\\\u0007\"\u00026\u0004\u0001\u0004Y\u0017!B1mi&\u001c\bcA&TYB\u0011Q\u000e]\u0007\u0002]*\u0011qnY\u0001\u0010C2$\u0018.\\3uef\u001c\u0016p\u001d;f[&\u0011\u0011O\u001c\u0002\u0010\u00032$\u0018.\\3uef\u001c\u0016p\u001d;f[\")1o\u0001a\u0001i\u0006Qa/\u00197jI\u0006$xN]:\u0011\tULHp \b\u0003m^\u0004\"!T\b\n\u0005a|\u0011A\u0002)sK\u0012,g-\u0003\u0002{w\n\u0019Q*\u00199\u000b\u0005a|\u0001C\u0001\b~\u0013\tqxBA\u0002J]R\u00042!^A\u0001\u0013\r\t\u0019a\u001f\u0002\u0007'R\u0014\u0018N\\4\t\r\u0005\u001d1\u00011\u0001}\u0003)\u0011x.\u001e8e-\u0006dW/Z\u0001\u001fO\u0016$hj\u001c3f?\u000eC'o\u001c8jcV,\u0007+[3{_6,GO]5rk\u0016$B\"!\u0004\u0002\u0014\u0005U\u0011qCA\r\u00037\u00012aNA\b\u0013\r\t\t\u0002\u000f\u0002\b\u001d>$WmU3r\u0011\u0015IE\u00011\u0001K\u0011\u0015iF\u00011\u0001_\u0011\u0015QG\u00011\u0001l\u0011\u0015\u0019H\u00011\u0001u\u0011\u0019\t9\u0001\u0002a\u0001y\u0006!r-\u001a;D_\u0012,')\u001f#fg&<g.\u0019;j_:$2a`A\u0011\u0011\u0015iT\u00011\u0001?\u0001")
public class QesoutQuantity
implements Producer {
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        QesoutQuantity qesoutQuantity = this;
        synchronized (qesoutQuantity) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Node getNode_Quantite(Piezometer piezo, scala.collection.immutable.Seq<PiezometerChronicRawMeasure> measures, scala.collection.immutable.Seq<Landmark> landmarks, scala.collection.immutable.Seq<AltimetrySystem> altis, Map<Object, String> validators, int roundValue) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("listID", (Seq)new Text("170"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("2"));
        $buf.$amp$plus((Object)new Elem(null, "ExpCoteChroniquePiezometre", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n                "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("schemeID", (Seq)new Text("PTE"), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)this.getCodeByDesignation(piezo));
        $buf3.$amp$plus((Object)new Elem(null, "CdNationalPointEau", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n                "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus(piezo.name().getOrElse((Function0 & Serializable)() -> ""));
        $buf3.$amp$plus((Object)new Elem(null, "LbPointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)new Elem(null, "PointEau", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)this.getNode_ChroniquePiezometrique(measures, landmarks, altis, validators, roundValue));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "Quantite", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public NodeSeq getNode_ChroniquePiezometrique(scala.collection.immutable.Seq<PiezometerChronicRawMeasure> measures, scala.collection.immutable.Seq<Landmark> landmarks, scala.collection.immutable.Seq<AltimetrySystem> altis, Map<Object, String> validators, int roundValue) {
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)((IterableOps)measures.sortBy((Function1 & Serializable)m -> BoxesRunTime.boxToLong((long)QesoutQuantity.$anonfun$getNode_ChroniquePiezometrique$1(m)), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)measure -> {
            Tuple2 tuple2 = (Tuple2)PiezometryUtils$.MODULE$.getMeasureLandmarkAndRefAlti(measure, landmarks, altis).get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Landmark landmark = (Landmark)tuple2._1();
            AltimetrySystem refAlti = (AltimetrySystem)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)landmark, (Object)refAlti);
            Landmark landmark2 = (Landmark)tuple22._1();
            AltimetrySystem refAlti2 = (AltimetrySystem)tuple22._2();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("Action", (Seq)new Text("A"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)XmlBuilder$.MODULE$.getDate((Option<DateTime>)new Some((Object)measure.date())));
            $buf.$amp$plus((Object)new Elem(null, "DateMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)XmlBuilder$.MODULE$.getHour((Option<DateTime>)new Some((Object)measure.date())));
            $buf.$amp$plus((Object)new Elem(null, "HeureMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)BoxesRunTime.boxToDouble((double)MathUtil$.MODULE$.roundAt(roundValue, BoxesRunTime.unboxToDouble((Object)refAlti2.altitude().get()) + BoxesRunTime.unboxToDouble((Object)landmark2.height().get()) - PiezometryUtils$.MODULE$.getNGF(measure))));
            $buf.$amp$plus((Object)new Elem(null, "ValeurMesure", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n                "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("listID", (Seq)new Text("72"), (MetaData)$md2);
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus(measure.initialPoint().getOrElse((Function0 & Serializable)() -> "2"));
            $buf.$amp$plus((Object)new Elem(null, "CdContinuiteMesure", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf.$amp$plus((Object)new Text("\n                "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("listID", (Seq)new Text("180"), (MetaData)$md3);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus(measure.measureMode().getOrElse((Function0 & Serializable)() -> "0"));
            $buf.$amp$plus((Object)new Elem(null, "ModeObtentionMesure", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("listID", (Seq)new Text("414"), (MetaData)$md4);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus(measure.qualification().getOrElse((Function0 & Serializable)() -> "4"));
            $buf.$amp$plus((Object)new Elem(null, "ConformiteAcqMesure", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf.$amp$plus((Object)new Text("\n                "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("listID", (Seq)new Text("415"), (MetaData)$md5);
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus(measure.status().getOrElse((Function0 & Serializable)() -> "1"));
            $buf.$amp$plus((Object)new Elem(null, "StatutAcqMesure", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf.$amp$plus((Object)new Text("\n                "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("listID", (Seq)new Text("604"), (MetaData)$md6);
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus(measure.nature().getOrElse((Function0 & Serializable)() -> "0"));
            $buf.$amp$plus((Object)new Elem(null, "NatureMesure", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
            $buf.$amp$plus((Object)new Text("\n                "));
            $buf.$amp$plus(measure.validator().flatMap((Function1 & Serializable)v -> validators.get((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)v)))).map((Function1 & Serializable)validator -> {
                if (validator.length() > 10) {
                    void var1_1;
                    void var3_3;
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n                                "));
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("schemeAgencyID", (Seq)new Text("SIRET"), (MetaData)$md);
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus(validator);
                    $buf.$amp$plus((Object)new Elem(null, "CdIntervenant", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
                    $buf.$amp$plus((Object)new Text("\n                            "));
                    return new Elem(null, "Intervenant", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
                }
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n                                "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("schemeAgencyID", (Seq)new Text("SANDRE"), (MetaData)$md);
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus(validator);
                $buf.$amp$plus((Object)new Elem(null, "CdIntervenant", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                $buf.$amp$plus((Object)new Text("\n                            "));
                return new Elem(null, "Intervenant", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            }).getOrElse((Function0 & Serializable)() -> ""));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "ChroniquePiezometrique", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
    }

    public String getCodeByDesignation(Piezometer piezo) {
        if (piezo.code().toUpperCase().startsWith("BSS")) {
            return piezo.code();
        }
        Object object = piezo.designation().getOrElse((Function0 & Serializable)() -> "");
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            return new StringBuilder(1).append(piezo.code()).append("/").append(piezo.designation().getOrElse((Function0 & Serializable)() -> "")).toString();
        }
        return piezo.code();
    }

    public static final /* synthetic */ long $anonfun$getNode_ChroniquePiezometrique$1(PiezometerChronicRawMeasure m) {
        return m.date().getMillis();
    }

    @Inject
    public QesoutQuantity(LogUtil logUtil) {
        Producer.$init$((Producer)this);
    }
}

