/*
 * Decompiled with CFR 0.152.
 */
package util;

import fr.aquasys.daeau.export.ExportedData;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.awt.Color;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.matching.Regex;
import util.AquasysCellStyle;
import util.AquasysCellStyle$;

public final class ExcelBuilderUtil$ {
    public static final ExcelBuilderUtil$ MODULE$ = new ExcelBuilderUtil$();

    public void setDataBookmarkInExcel(Cell currentCell, Seq<Seq<ExportedData>> data, AquasysCellStyle ACS, Option<HashMap<Object, Object>> colSizeMap) {
        Sheet currentSheet = currentCell.getSheet();
        int firstCellIndice = currentCell.getColumnIndex();
        IntRef rowIndex = IntRef.create((int)currentCell.getRowIndex());
        if (data.isEmpty()) {
            Row row = currentSheet.getRow(rowIndex.elem);
            if (row == null) {
                row = currentSheet.createRow(rowIndex.elem);
            }
            this.makeCellValue("", row.createCell(firstCellIndice), ACS, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, this.makeCellValue$default$6(), this.makeCellValue$default$7());
            return;
        }
        HashMap colSize = (HashMap)colSizeMap.getOrElse((Function0 & Serializable)() -> new HashMap());
        data.foreach((Function1 & Serializable)line -> {
            ExcelBuilderUtil$.$anonfun$setDataBookmarkInExcel$3(currentSheet, rowIndex, firstCellIndice, ACS, colSize, line);
            return BoxedUnit.UNIT;
        });
        int j = firstCellIndice;
        while (j <= ((SeqOps)data.head()).length()) {
            if (!currentSheet.isColumnBroken(j)) {
                int newSize = BoxesRunTime.unboxToInt((Object)colSize.getOrElse((Object)BoxesRunTime.boxToInteger((int)j), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) * 300;
                currentSheet.setColumnHidden(j, false);
                currentSheet.setColumnWidth(j, newSize < 65280 ? newSize : 65280);
                ++j;
                continue;
            }
            ++j;
        }
    }

    public Option<HashMap<Object, Object>> setDataBookmarkInExcel$default$4() {
        return None$.MODULE$;
    }

    public void fillWorksheet(Seq<Seq<ExportedData>> data, Sheet worksheet, Workbook workbook, LogUtil logUtil, boolean autosizing) {
        if (data.nonEmpty()) {
            IntRef nbCols = IntRef.create((int)0);
            AquasysCellStyle ACS = new AquasysCellStyle(workbook, AquasysCellStyle$.MODULE$.apply$default$2());
            Row firstRow = worksheet.createRow(0);
            Seq header = (Seq)data.head();
            Seq rest = (Seq)data.tail();
            logUtil.info("making headers", logUtil.info$default$2());
            HashMap colSize = new HashMap();
            header.foreach((Function1 & Serializable)dataCell -> {
                ExcelBuilderUtil$.$anonfun$fillWorksheet$2(firstRow, nbCols, workbook, colSize, dataCell);
                return BoxedUnit.UNIT;
            });
            logUtil.info("setting data", logUtil.info$default$2());
            Row row = worksheet.createRow(1);
            Cell cell = row.createCell(0);
            this.setDataBookmarkInExcel(cell, (Seq<Seq<ExportedData>>)rest, ACS, this.setDataBookmarkInExcel$default$4());
            logUtil.info("End filling rows and cells", logUtil.info$default$2());
            return;
        }
    }

    public boolean fillWorksheet$default$5() {
        return true;
    }

    public CellStyle setHeaderStyleCell(Workbook workbook) {
        Font defaultFont = workbook.createFont();
        defaultFont.setBold(true);
        XSSFCellStyle cellStyle = (XSSFCellStyle)workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setFont(defaultFont);
        return cellStyle;
    }

    public CellStyle getDefaultStyle(Workbook workbook) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        return cellStyle;
    }

    public CellStyle setStyleCell(String cellType, String color, Workbook workbook, CellStyle cellStyle, Option<String> cellFormat) {
        XSSFCellStyle cellStyle2;
        block30: {
            XSSFColor finalColor;
            Option option;
            XSSFColor xSSFColor;
            block29: {
                String string = color;
                String string2 = "white";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String string3 = cellType;
                    String string4 = "string";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        return cellStyle;
                    }
                }
                cellStyle2 = (XSSFCellStyle)workbook.createCellStyle();
                String string5 = cellType;
                switch (string5 == null ? 0 : string5.hashCode()) {
                    case -1034364087: {
                        String string6;
                        if (!"number".equals(string5)) break;
                        Option<String> option2 = cellFormat;
                        if (option2 instanceof Some) {
                            String f;
                            Some some = (Some)option2;
                            string6 = f = (String)some.value();
                        } else if (None$.MODULE$.equals(option2)) {
                            string6 = "#,##0.000";
                        } else {
                            throw new MatchError(option2);
                        }
                        String format = string6;
                        cellStyle2.setDataFormat(workbook.createDataFormat().getFormat(format));
                        cellStyle2.setAlignment(HorizontalAlignment.RIGHT);
                        break block29;
                    }
                    case 3076014: {
                        String string7;
                        if (!"date".equals(string5)) break;
                        Option<String> option3 = cellFormat;
                        if (option3 instanceof Some) {
                            String f;
                            Some some = (Some)option3;
                            string7 = f = (String)some.value();
                        } else if (None$.MODULE$.equals(option3)) {
                            string7 = "dd/MM/yyyy";
                        } else {
                            throw new MatchError(option3);
                        }
                        String format = string7;
                        cellStyle2.setDataFormat(workbook.createDataFormat().getFormat(format));
                        break block29;
                    }
                    case 108511772: {
                        if (!"right".equals(string5)) break;
                        cellStyle2.setAlignment(HorizontalAlignment.RIGHT);
                        break block29;
                    }
                }
                cellStyle2.setAlignment(HorizontalAlignment.LEFT);
            }
            cellStyle2.setBorderBottom(BorderStyle.THIN);
            cellStyle2.setBorderTop(BorderStyle.THIN);
            cellStyle2.setBorderRight(BorderStyle.THIN);
            cellStyle2.setBorderLeft(BorderStyle.THIN);
            Regex hexaPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("#.*"));
            String string = color;
            if ("red".equals(string)) {
                xSSFColor = new XSSFColor(new Color(254, 0, 2), null);
            } else if ("blue".equals(string)) {
                xSSFColor = new XSSFColor(new Color(0, 255, 255), null);
            } else if ("green".equals(string)) {
                xSSFColor = new XSSFColor(new Color(0, 254, 0), null);
            } else if ("yellow".equals(string)) {
                xSSFColor = new XSSFColor(new Color(255, 254, 0), null);
            } else if ("orange".equals(string)) {
                xSSFColor = new XSSFColor(new Color(255, 153, 0), null);
            } else if ("gray".equals(string)) {
                xSSFColor = new XSSFColor(new Color(128, 128, 128), null);
            } else if (string != null && !(option = hexaPattern.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String hexaColor = (String)((LinearSeqOps)option.get()).apply(0);
                xSSFColor = new XSSFColor(Color.decode(hexaColor.replace("#", "")), null);
            } else {
                XSSFColor color2 = new XSSFColor(new Color(128, 128, 128), null);
                color2.setAuto(true);
                xSSFColor = finalColor = color2;
            }
            if (finalColor.isAuto()) break block30;
            cellStyle2.setFillForegroundColor(finalColor);
            cellStyle2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        return cellStyle2;
    }

    public Option<String> setStyleCell$default$5() {
        return None$.MODULE$;
    }

    public CellType setHeaderTypeCell() {
        return CellType.STRING;
    }

    public CellType setTypeCell(String cType, String value) {
        String string = value;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return CellType.BLANK;
        }
        String string3 = cType;
        switch (string3 == null ? 0 : string3.hashCode()) {
            case -1034364087: {
                if (!"number".equals(string3)) break;
                return CellType.NUMERIC;
            }
            case 3076014: {
                if (!"date".equals(string3)) break;
                return CellType.NUMERIC;
            }
        }
        return CellType.STRING;
    }

    public void setCellValue(String cellType, String value, Cell cell, Option<String> format) {
        block7: {
            if (value.equals("") || value.equals("[object Object]")) {
                cell.setCellValue("");
                return;
            }
            String string = cellType;
            switch (string == null ? 0 : string.hashCode()) {
                case -1034364087: {
                    if (!"number".equals(string)) break;
                    cell.setCellValue(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value)));
                    break block7;
                }
                case 3076014: {
                    String string2;
                    if (!"date".equals(string)) break;
                    Option<String> option = format;
                    if (option instanceof Some) {
                        String f;
                        Some some = (Some)option;
                        string2 = f = (String)some.value();
                    } else {
                        string2 = "dd/MM/yyyy";
                    }
                    String formatDate = string2;
                    SimpleDateFormat dateParser = new SimpleDateFormat(formatDate);
                    Date cellValue = dateParser.parse(value);
                    cell.setCellValue(cellValue);
                    break block7;
                }
            }
            cell.setCellValue(value);
        }
    }

    public Option<String> setCellValue$default$4() {
        return None$.MODULE$;
    }

    public String calculateCellType(String value) {
        return (String)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value))).toOption().map((Function1 & Serializable)x$1 -> ExcelBuilderUtil$.$anonfun$calculateCellType$2(BoxesRunTime.unboxToInt((Object)x$1))).getOrElse((Function0 & Serializable)() -> (String)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value))).toOption().map((Function1 & Serializable)x$2 -> ExcelBuilderUtil$.$anonfun$calculateCellType$5(BoxesRunTime.unboxToDouble((Object)x$2))).getOrElse((Function0 & Serializable)() -> {
            if (value.matches("\\d\\d\\/\\d\\d\\/\\d\\d\\d\\d\\ \\d\\d:\\d\\d:\\d\\d")) {
                return "datehour";
            }
            if (value.matches("\\d\\d\\/\\d\\d\\/\\d\\d\\d\\d")) {
                return "date";
            }
            return "string";
        }));
    }

    public void makeCellValue(String value, Cell cell, AquasysCellStyle ACS, Option<String> cellType, Option<String> cellFormat, Option<String> color, Option<Tuple3<Object, Object, Object>> rgb) {
        block10: {
            if (value.equals("") || value.equals("[object Object]")) {
                cell.setCellValue("");
                return;
            }
            String string = (String)cellType.getOrElse((Function0 & Serializable)() -> MODULE$.calculateCellType(value));
            switch (string == null ? 0 : string.hashCode()) {
                case -1034364087: {
                    if (!"number".equals(string)) break;
                    cell.setCellStyle(ACS.getStyle("number", cellFormat, color, rgb));
                    cell.setCellValue(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value)));
                    cell.setCellType(CellType.NUMERIC);
                    break block10;
                }
                case 3076014: {
                    if (!"date".equals(string)) break;
                    cell.setCellStyle(ACS.getStyle("date", cellFormat, color, rgb));
                    SimpleDateFormat dateParser = new SimpleDateFormat((String)cellFormat.getOrElse((Function0 & Serializable)() -> "dd/MM/yyyy"));
                    Date cellValue = dateParser.parse(value);
                    cell.setCellValue(cellValue);
                    cell.setCellType(CellType.NUMERIC);
                    break block10;
                }
                case 108511772: {
                    if (!"right".equals(string)) break;
                    cell.setCellStyle(ACS.getStyle("right", cellFormat, color, rgb));
                    cell.setCellValue(value);
                    cell.setCellType(CellType.STRING);
                    break block10;
                }
                case 1793351314: {
                    if (!"datehour".equals(string)) break;
                    cell.setCellStyle(ACS.getStyle("datehour", cellFormat, color, rgb));
                    SimpleDateFormat dateParser = new SimpleDateFormat((String)cellFormat.getOrElse((Function0 & Serializable)() -> "dd/MM/yyyy HH:mm:ss"));
                    Date cellValue = dateParser.parse(value);
                    cell.setCellValue(cellValue);
                    cell.setCellType(CellType.NUMERIC);
                    break block10;
                }
                case 1958052158: {
                    if (!"integer".equals(string)) break;
                    cell.setCellStyle(ACS.getStyle("integer", cellFormat, color, rgb));
                    cell.setCellValue(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value)));
                    cell.setCellType(CellType.NUMERIC);
                    break block10;
                }
            }
            if (cellFormat.isEmpty() && color.isEmpty() && rgb.isEmpty()) {
                cell.setCellValue(value);
            } else {
                cell.setCellStyle(ACS.getStyle("string", cellFormat, color, rgb));
                cell.setCellValue(value);
                cell.setCellType(CellType.STRING);
            }
        }
    }

    public Option<String> makeCellValue$default$4() {
        return None$.MODULE$;
    }

    public Option<String> makeCellValue$default$5() {
        return None$.MODULE$;
    }

    public Option<String> makeCellValue$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple3<Object, Object, Object>> makeCellValue$default$7() {
        return None$.MODULE$;
    }

    private static final void setSize$1(int size, int col, HashMap colSize$1) {
        if (BoxesRunTime.unboxToInt((Object)colSize$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)col), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < size) {
            colSize$1.update((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)size));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$setDataBookmarkInExcel$4(IntRef colIndex$1, ObjectRef row$1, AquasysCellStyle ACS$1, HashMap colSize$1, ExportedData dataCell) {
        if (!dataCell.cellType().contains((Object)"void")) {
            String value = (String)dataCell.value().getOrElse((Function0 & Serializable)() -> "");
            ExcelBuilderUtil$.setSize$1(value.length(), colIndex$1.elem, colSize$1);
            MODULE$.makeCellValue(value, ((Row)row$1.elem).createCell(colIndex$1.elem), ACS$1, (Option<String>)dataCell.cellType(), (Option<String>)dataCell.format(), (Option<String>)dataCell.color(), MODULE$.makeCellValue$default$7());
        }
        ++colIndex$1.elem;
    }

    public static final /* synthetic */ void $anonfun$setDataBookmarkInExcel$3(Sheet currentSheet$1, IntRef rowIndex$1, int firstCellIndice$1, AquasysCellStyle ACS$1, HashMap colSize$1, Seq line) {
        ObjectRef row = ObjectRef.create((Object)currentSheet$1.getRow(rowIndex$1.elem));
        if ((Row)row.elem == null) {
            row.elem = currentSheet$1.createRow(rowIndex$1.elem);
        }
        IntRef colIndex = IntRef.create((int)firstCellIndice$1);
        line.foreach((Function1 & Serializable)dataCell -> {
            ExcelBuilderUtil$.$anonfun$setDataBookmarkInExcel$4(colIndex, row, ACS$1, colSize$1, dataCell);
            return BoxedUnit.UNIT;
        });
        ++rowIndex$1.elem;
    }

    private static final void setSize$2(int size, int col, HashMap colSize$2) {
        if (BoxesRunTime.unboxToInt((Object)colSize$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)col), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < size) {
            colSize$2.update((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)size));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$fillWorksheet$2(Row firstRow$1, IntRef nbCols$1, Workbook workbook$1, HashMap colSize$2, ExportedData dataCell) {
        Cell cell = firstRow$1.createCell(nbCols$1.elem);
        cell.setCellStyle(MODULE$.setHeaderStyleCell(workbook$1));
        String value = (String)dataCell.value().getOrElse((Function0 & Serializable)() -> "");
        ExcelBuilderUtil$.setSize$2(value.length() * 2, nbCols$1.elem, colSize$2);
        MODULE$.setCellValue("string", value, cell, MODULE$.setCellValue$default$4());
        cell.setCellType(MODULE$.setHeaderTypeCell());
        ++nbCols$1.elem;
    }

    public static final /* synthetic */ String $anonfun$calculateCellType$2(int x$1) {
        return "integer";
    }

    public static final /* synthetic */ String $anonfun$calculateCellType$5(double x$2) {
        return "number";
    }

    private ExcelBuilderUtil$() {
    }
}

