/*
 * Decompiled with CFR 0.152.
 */
package fr.aquasys.utils;

import fr.aquasys.daeau.piezometry.domain.MeasureThresholdState;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import java.io.Serializable;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ThresholdUtil$ {
    public static final ThresholdUtil$ MODULE$ = new ThresholdUtil$();

    public Tuple2<Option<String>, Option<String>> getThresholdName(Seq<StationThreshold> thresholds, Option<Object> valueNGF) {
        if (!thresholds.isEmpty() && !valueNGF.isEmpty()) {
            Tuple2 tuple2 = thresholds.partition((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ThresholdUtil$.$anonfun$getThresholdName$1(t)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq overrunThresholds = (Seq)tuple2._1();
            Seq normalThresholds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)overrunThresholds, (Object)normalThresholds);
            Seq overrunThresholds2 = (Seq)tuple22._1();
            Seq normalThresholds2 = (Seq)tuple22._2();
            if (normalThresholds2.nonEmpty()) {
                Seq foundThresholds = (Seq)normalThresholds2.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ThresholdUtil$.$anonfun$getThresholdName$3(valueNGF, t)));
                if (foundThresholds.nonEmpty()) {
                    StationThreshold selected = (StationThreshold)foundThresholds.minBy((Function1 & Serializable)t -> t.value(), Ordering$.MODULE$.Option((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
                    return new Tuple2((Object)new Some((Object)new StringBuilder(2).append("< ").append(selected.name().getOrElse((Function0 & Serializable)() -> "")).toString()), (Object)selected.htmlColor().orElse((Function0 & Serializable)() -> selected.color().map((Function1 & Serializable)c -> ThresholdUtil$.MODULE$.thresholdColor(BoxesRunTime.unboxToDouble((Object)c)))));
                }
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (overrunThresholds2.nonEmpty()) {
                Seq foundThresholds = (Seq)overrunThresholds2.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ThresholdUtil$.$anonfun$getThresholdName$9(valueNGF, t)));
                if (foundThresholds.nonEmpty()) {
                    StationThreshold selected = (StationThreshold)foundThresholds.maxBy((Function1 & Serializable)t -> t.value(), Ordering$.MODULE$.Option((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
                    return new Tuple2((Object)new Some((Object)new StringBuilder(2).append("> ").append(selected.name().getOrElse((Function0 & Serializable)() -> "")).toString()), (Object)selected.htmlColor().orElse((Function0 & Serializable)() -> selected.color().map((Function1 & Serializable)c -> ThresholdUtil$.MODULE$.thresholdColor(BoxesRunTime.unboxToDouble((Object)c)))));
                }
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    public MeasureThresholdState getMeasureThresholdState(double value, DateTime date, Seq<StationThreshold> thresholds) {
        Tuple2 tuple2 = thresholds.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ThresholdUtil$.$anonfun$getMeasureThresholdState$1(x$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq overThresholds = (Seq)tuple2._1();
        Seq normalThresholds = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)overThresholds, (Object)normalThresholds);
        Seq overThresholds2 = (Seq)tuple22._1();
        Seq normalThresholds2 = (Seq)tuple22._2();
        Tuple2 tuple23 = overThresholds2.partition((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ThresholdUtil$.$anonfun$getMeasureThresholdState$2(value, date, t)));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq supOver = (Seq)tuple23._1();
        Seq infOver = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)supOver, (Object)infOver);
        Seq supOver2 = (Seq)tuple24._1();
        Seq infOver2 = (Seq)tuple24._2();
        Tuple2 tuple25 = normalThresholds2.partition((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ThresholdUtil$.$anonfun$getMeasureThresholdState$3(value, date, t)));
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        Seq supNormal = (Seq)tuple25._1();
        Seq infNormal = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)supNormal, (Object)infNormal);
        Seq supNormal2 = (Seq)tuple26._1();
        Seq infNormal2 = (Seq)tuple26._2();
        return new MeasureThresholdState(value, (Seq<StationThreshold>)((Seq)supOver2.$plus$plus((IterableOnce)supNormal2)), (Seq<StationThreshold>)((Seq)infOver2.$plus$plus((IterableOnce)infNormal2)), (Seq<StationThreshold>)((Seq)supOver2.$plus$plus((IterableOnce)infNormal2)), (Seq<StationThreshold>)((Seq)infOver2.$plus$plus((IterableOnce)supNormal2)));
    }

    public double getThresholdValue(StationThreshold threshold, DateTime date) {
        int n = date.monthOfYear().get();
        switch (n) {
            case 1: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month01().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 2: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month02().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 3: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month03().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 4: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month04().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 5: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month05().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 6: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month06().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 7: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month07().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 8: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month08().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 9: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month09().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 10: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month10().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 11: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month11().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
            case 12: {
                return BoxesRunTime.unboxToDouble((Object)threshold.month12().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))));
            }
        }
        return BoxesRunTime.unboxToDouble((Object)threshold.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public String thresholdColor(double colorNb) {
        return (String)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"black", "blue", "green", "cyan", "red", "darkmagenta", "yellow", "white", "grey", "lightblue", "lightgreen", "lightcyan", "indianred", "magenta", "lightyellow", "whitesmoke"})).apply((int)colorNb);
    }

    public static final /* synthetic */ boolean $anonfun$getThresholdName$1(StationThreshold t) {
        Object object = t.isOverrunThreshold().getOrElse((Function0 & Serializable)() -> "");
        String string = "1";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$getThresholdName$3(Option valueNGF$1, StationThreshold t) {
        return BoxesRunTime.unboxToDouble((Object)t.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) > BoxesRunTime.unboxToDouble((Object)valueNGF$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$getThresholdName$9(Option valueNGF$1, StationThreshold t) {
        return BoxesRunTime.unboxToDouble((Object)t.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) < BoxesRunTime.unboxToDouble((Object)valueNGF$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$getMeasureThresholdState$1(StationThreshold x$2) {
        return x$2.isOverrunThreshold().contains((Object)"1");
    }

    public static final /* synthetic */ boolean $anonfun$getMeasureThresholdState$2(double value$1, DateTime date$1, StationThreshold t) {
        return value$1 > MODULE$.getThresholdValue(t, date$1);
    }

    public static final /* synthetic */ boolean $anonfun$getMeasureThresholdState$3(double value$1, DateTime date$1, StationThreshold t) {
        return value$1 > MODULE$.getThresholdValue(t, date$1);
    }

    private ThresholdUtil$() {
    }
}

