/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.renderers.BatikAWTFontFamily;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFontFamily;

public class BatikFontFamilyResolver
implements FontFamilyResolver {
    private final JasperReportsContext jasperReportsContext;
    private final FontUtil fontUtil;
    private final Map<String, GVTFontFamily> resolvedFontFamilies = new HashMap<String, GVTFontFamily>();

    private BatikFontFamilyResolver(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.fontUtil = FontUtil.getInstance(jasperReportsContext);
    }

    public static BatikFontFamilyResolver getInstance(JasperReportsContext jasperReportsContext) {
        return new BatikFontFamilyResolver(jasperReportsContext);
    }

    public GVTFontFamily resolve(String familyName, FontFace fontFace) {
        return DefaultFontFamilyResolver.SINGLETON.resolve(familyName, fontFace);
    }

    public GVTFontFamily loadFont(InputStream in, FontFace ff) throws Exception {
        return DefaultFontFamilyResolver.SINGLETON.loadFont(in, ff);
    }

    public GVTFontFamily resolve(String familyName) {
        Object gvtFontFamily = this.resolvedFontFamilies.get(familyName);
        if (gvtFontFamily == null) {
            int localeSeparatorPos;
            FontInfo fontInfo = this.fontUtil.getFontInfo(familyName, true, null);
            if (fontInfo == null && (localeSeparatorPos = familyName.lastIndexOf("_-")) > 0) {
                String family = familyName.substring(0, localeSeparatorPos);
                fontInfo = this.fontUtil.getFontInfo(family, true, null);
            }
            if (fontInfo != null) {
                gvtFontFamily = new BatikAWTFontFamily(this.jasperReportsContext, familyName);
                this.resolvedFontFamilies.put(familyName, (GVTFontFamily)gvtFontFamily);
            } else {
                return DefaultFontFamilyResolver.SINGLETON.resolve(familyName);
            }
        }
        return gvtFontFamily;
    }

    public GVTFontFamily getFamilyThatCanDisplay(char c) {
        return DefaultFontFamilyResolver.SINGLETON.getFamilyThatCanDisplay(c);
    }

    public GVTFontFamily getDefault() {
        return DefaultFontFamilyResolver.SINGLETON.getDefault();
    }
}

