@REM export launcher script
@REM
@REM Environment:
@REM JAVA_HOME - location of a JDK home dir (optional if java on path)
@REM CFG_OPTS  - JVM options (optional)
@REM Configuration:
@REM EXPORT_config.txt found in the EXPORT_HOME.
@setlocal enabledelayedexpansion
@setlocal enableextensions

@echo off


if "%EXPORT_HOME%"=="" (
  set "APP_HOME=%~dp0\\.."

  rem Also set the old env name for backwards compatibility
  set "EXPORT_HOME=%~dp0\\.."
) else (
  set "APP_HOME=%EXPORT_HOME%"
)

set "APP_LIB_DIR=%APP_HOME%\lib\"

rem Detect if we were double clicked, although theoretically A user could
rem manually run cmd /c
for %%x in (!cmdcmdline!) do if %%~x==/c set DOUBLECLICKED=1

rem FIRST we load the config file of extra options.
set "CFG_FILE=%APP_HOME%\EXPORT_config.txt"
set CFG_OPTS=
call :parse_config "%CFG_FILE%" CFG_OPTS

rem We use the value of the JAVA_OPTS environment variable if defined, rather than the config.
set _JAVA_OPTS=%JAVA_OPTS%
if "!_JAVA_OPTS!"=="" set _JAVA_OPTS=!CFG_OPTS!

rem We keep in _JAVA_PARAMS all -J-prefixed and -D-prefixed arguments
rem "-J" is stripped, "-D" is left as is, and everything is appended to JAVA_OPTS
set _JAVA_PARAMS=
set _APP_ARGS=

set "APP_CLASSPATH=%APP_LIB_DIR%\..\conf\;%APP_LIB_DIR%\fr.aquasys.export-1.0-sans-externalized.jar;%APP_LIB_DIR%\org.scala-lang.scala-library-2.13.12.jar;%APP_LIB_DIR%\org.playframework.twirl.twirl-api_2.13-2.0.3.jar;%APP_LIB_DIR%\org.playframework.play-server_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-logback_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-pekko-http-server_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-filters-helpers_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-guice_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-ahc-ws_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-jdbc_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.anorm.anorm_2.13-2.7.0.jar;%APP_LIB_DIR%\org.playframework.play-cache_2.13-3.0.1.jar;%APP_LIB_DIR%\org.postgresql.postgresql-42.7.2.jar;%APP_LIB_DIR%\fr.aquasys.rabbitmqapi_2.13-4.1.184.jar;%APP_LIB_DIR%\fr.aquasys.daeau_2.13-4.1.849.jar;%APP_LIB_DIR%\net.sf.jasperreports.jasperreports-6.20.0.jar;%APP_LIB_DIR%\net.sf.jasperreports.jasperreports-fonts-6.20.0.jar;%APP_LIB_DIR%\net.sf.jasperreports.jasperreports-chart-customizers-6.20.0.jar;%APP_LIB_DIR%\net.sf.jasperreports.jasperreports-functions-6.20.0.jar;%APP_LIB_DIR%\com.lowagie.itext-2.1.7.jar;%APP_LIB_DIR%\org.scala-lang.modules.scala-parallel-collections_2.13-1.0.4.jar;%APP_LIB_DIR%\org.codehaus.janino.janino-3.1.12.jar;%APP_LIB_DIR%\org.apache.xmlbeans.xmlbeans-5.2.0.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-bridge-1.16.jar;%APP_LIB_DIR%\org.scala-lang.modules.scala-xml_2.13-2.2.0.jar;%APP_LIB_DIR%\org.playframework.play_2.13-3.0.1.jar;%APP_LIB_DIR%\ch.qos.logback.logback-classic-1.4.14.jar;%APP_LIB_DIR%\org.playframework.play-streams_2.13-3.0.1.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-http-core_2.13-1.0.0.jar;%APP_LIB_DIR%\com.google.inject.guice-6.0.0.jar;%APP_LIB_DIR%\com.google.inject.extensions.guice-assistedinject-6.0.0.jar;%APP_LIB_DIR%\org.playframework.play-ws_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-ahc-ws-standalone_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.shaded-asynchttpclient-3.0.1.jar;%APP_LIB_DIR%\org.playframework.shaded-oauth-3.0.1.jar;%APP_LIB_DIR%\javax.cache.cache-api-1.1.1.jar;%APP_LIB_DIR%\org.playframework.play-jdbc-api_2.13-3.0.1.jar;%APP_LIB_DIR%\com.zaxxer.HikariCP-5.0.1.jar;%APP_LIB_DIR%\com.googlecode.usc.jdbcdslog-1.0.6.2.jar;%APP_LIB_DIR%\tyrex.tyrex-1.0.1.jar;%APP_LIB_DIR%\org.playframework.anorm.anorm-tokenizer_2.13-2.7.0.jar;%APP_LIB_DIR%\joda-time.joda-time-2.12.7.jar;%APP_LIB_DIR%\org.joda.joda-convert-2.2.2.jar;%APP_LIB_DIR%\org.scala-lang.modules.scala-parser-combinators_2.13-1.1.2.jar;%APP_LIB_DIR%\org.checkerframework.checker-qual-3.42.0.jar;%APP_LIB_DIR%\com.rabbitmq.amqp-client-5.20.0.jar;%APP_LIB_DIR%\au.id.jazzy.play-geojson_2.13-1.7.0.jar;%APP_LIB_DIR%\org.apache.poi.poi-5.2.5.jar;%APP_LIB_DIR%\org.apache.poi.poi-ooxml-5.2.5.jar;%APP_LIB_DIR%\org.apache.poi.poi-ooxml-full-5.2.5.jar;%APP_LIB_DIR%\net.sourceforge.jexcelapi.jxl-2.6.12.jar;%APP_LIB_DIR%\com.pauldijou.jwt-play-json_2.13-5.0.0.jar;%APP_LIB_DIR%\ai.x.play-json-extensions_2.13-0.42.0.jar;%APP_LIB_DIR%\com.google.auth.google-auth-library-oauth2-http-1.19.0.jar;%APP_LIB_DIR%\commons-beanutils.commons-beanutils-1.9.4.jar;%APP_LIB_DIR%\commons-digester.commons-digester-2.1.jar;%APP_LIB_DIR%\commons-logging.commons-logging-1.2.jar;%APP_LIB_DIR%\org.apache.commons.commons-collections4-4.4.jar;%APP_LIB_DIR%\org.jfree.jcommon-1.0.23.jar;%APP_LIB_DIR%\org.jfree.jfreechart-1.0.19.jar;%APP_LIB_DIR%\org.eclipse.jdt.ecj-3.21.0.jar;%APP_LIB_DIR%\com.fasterxml.jackson.core.jackson-core-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.core.jackson-databind-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.core.jackson-annotations-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.dataformat.jackson-dataformat-xml-2.13.3.jar;%APP_LIB_DIR%\bouncycastle.bcmail-jdk14-138.jar;%APP_LIB_DIR%\bouncycastle.bcprov-jdk14-138.jar;%APP_LIB_DIR%\org.codehaus.janino.commons-compiler-3.1.12.jar;%APP_LIB_DIR%\org.apache.logging.log4j.log4j-api-2.21.1.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-anim-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-awt-util-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-css-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-dom-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-gvt-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-parser-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-script-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-shared-resources-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-svg-dom-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-util-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-xml-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.xmlgraphics-commons-2.7.jar;%APP_LIB_DIR%\xml-apis.xml-apis-ext-1.3.04.jar;%APP_LIB_DIR%\org.playframework.play-build-link-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-configuration_2.13-3.0.1.jar;%APP_LIB_DIR%\org.slf4j.slf4j-api-2.0.9.jar;%APP_LIB_DIR%\org.slf4j.jul-to-slf4j-2.0.9.jar;%APP_LIB_DIR%\org.slf4j.jcl-over-slf4j-2.0.9.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-actor_2.13-1.0.2.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-actor-typed_2.13-1.0.2.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-slf4j_2.13-1.0.2.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-serialization-jackson_2.13-1.0.2.jar;%APP_LIB_DIR%\com.fasterxml.jackson.datatype.jackson-datatype-jdk8-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.datatype.jackson-datatype-jsr310-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.dataformat.jackson-dataformat-cbor-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.module.jackson-module-parameter-names-2.14.3.jar;%APP_LIB_DIR%\com.fasterxml.jackson.module.jackson-module-scala_2.13-2.14.3.jar;%APP_LIB_DIR%\io.jsonwebtoken.jjwt-api-0.11.5.jar;%APP_LIB_DIR%\io.jsonwebtoken.jjwt-impl-0.11.5.jar;%APP_LIB_DIR%\io.jsonwebtoken.jjwt-jackson-0.11.5.jar;%APP_LIB_DIR%\org.playframework.play-json_2.13-3.0.1.jar;%APP_LIB_DIR%\com.google.guava.guava-32.1.3-jre.jar;%APP_LIB_DIR%\javax.inject.javax.inject-1.jar;%APP_LIB_DIR%\com.typesafe.ssl-config-core_2.13-0.6.1.jar;%APP_LIB_DIR%\ch.qos.logback.logback-core-1.4.14.jar;%APP_LIB_DIR%\org.reactivestreams.reactive-streams-1.0.4.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-stream_2.13-1.0.2.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-parsing_2.13-1.0.0.jar;%APP_LIB_DIR%\org.parboiled.parboiled_2.13-2.5.0.jar;%APP_LIB_DIR%\jakarta.inject.jakarta.inject-api-2.0.1.jar;%APP_LIB_DIR%\aopalliance.aopalliance-1.0.jar;%APP_LIB_DIR%\com.google.errorprone.error_prone_annotations-2.21.1.jar;%APP_LIB_DIR%\org.playframework.play-ws-standalone_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-ws-standalone-xml_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.play-ws-standalone-json_2.13-3.0.1.jar;%APP_LIB_DIR%\org.playframework.cachecontrol_2.13-3.0.0.jar;%APP_LIB_DIR%\org.scala-lang.scala-reflect-2.13.12.jar;%APP_LIB_DIR%\commons-codec.commons-codec-1.16.0.jar;%APP_LIB_DIR%\org.apache.commons.commons-math3-3.6.1.jar;%APP_LIB_DIR%\commons-io.commons-io-2.15.0.jar;%APP_LIB_DIR%\com.zaxxer.SparseBitSet-1.3.jar;%APP_LIB_DIR%\org.apache.poi.poi-ooxml-lite-5.2.5.jar;%APP_LIB_DIR%\org.apache.commons.commons-compress-1.25.0.jar;%APP_LIB_DIR%\com.github.virtuald.curvesapi-1.08.jar;%APP_LIB_DIR%\log4j.log4j-1.2.14.jar;%APP_LIB_DIR%\com.pauldijou.jwt-json-common_2.13-5.0.0.jar;%APP_LIB_DIR%\com.typesafe.play.play-json_2.13-2.9.1.jar;%APP_LIB_DIR%\com.google.auto.value.auto-value-annotations-1.10.1.jar;%APP_LIB_DIR%\com.google.code.findbugs.jsr305-3.0.2.jar;%APP_LIB_DIR%\com.google.auth.google-auth-library-credentials-1.19.0.jar;%APP_LIB_DIR%\com.google.http-client.google-http-client-1.42.3.jar;%APP_LIB_DIR%\com.google.http-client.google-http-client-gson-1.42.3.jar;%APP_LIB_DIR%\commons-collections.commons-collections-3.2.2.jar;%APP_LIB_DIR%\org.codehaus.woodstox.stax2-api-4.2.1.jar;%APP_LIB_DIR%\com.fasterxml.woodstox.woodstox-core-6.2.7.jar;%APP_LIB_DIR%\org.bouncycastle.bctsp-jdk14-1.38.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-ext-1.16.jar;%APP_LIB_DIR%\xml-apis.xml-apis-1.4.01.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-constants-1.16.jar;%APP_LIB_DIR%\org.apache.xmlgraphics.batik-i18n-1.16.jar;%APP_LIB_DIR%\org.playframework.play-exceptions-3.0.1.jar;%APP_LIB_DIR%\com.typesafe.config-1.4.3.jar;%APP_LIB_DIR%\org.lz4.lz4-java-1.8.0.jar;%APP_LIB_DIR%\com.thoughtworks.paranamer.paranamer-2.8.jar;%APP_LIB_DIR%\org.playframework.play-functional_2.13-3.0.1.jar;%APP_LIB_DIR%\com.google.guava.failureaccess-1.0.1.jar;%APP_LIB_DIR%\com.google.guava.listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_LIB_DIR%\com.google.j2objc.j2objc-annotations-2.8.jar;%APP_LIB_DIR%\org.apache.pekko.pekko-protobuf-v3_2.13-1.0.2.jar;%APP_LIB_DIR%\com.pauldijou.jwt-core_2.13-5.0.0.jar;%APP_LIB_DIR%\com.typesafe.play.play-functional_2.13-2.9.1.jar;%APP_LIB_DIR%\org.apache.httpcomponents.httpclient-4.5.13.jar;%APP_LIB_DIR%\org.apache.httpcomponents.httpcore-4.4.15.jar;%APP_LIB_DIR%\io.opencensus.opencensus-api-0.31.1.jar;%APP_LIB_DIR%\io.opencensus.opencensus-contrib-http-util-0.31.1.jar;%APP_LIB_DIR%\com.google.code.gson.gson-2.10.jar;%APP_LIB_DIR%\org.bouncycastle.bcprov-jdk14-1.38.jar;%APP_LIB_DIR%\org.bouncycastle.bcmail-jdk14-1.38.jar;%APP_LIB_DIR%\io.grpc.grpc-context-1.27.2.jar;%APP_LIB_DIR%\fr.aquasys.export-1.0-assets.jar"
set "APP_MAIN_CLASS=play.core.server.ProdServerStart"
set "SCRIPT_CONF_FILE=%APP_HOME%\conf\application.ini"

rem Bundled JRE has priority over standard environment variables
if defined BUNDLED_JVM (
  set "_JAVACMD=%BUNDLED_JVM%\bin\java.exe"
) else (
  if "%JAVACMD%" neq "" (
    set "_JAVACMD=%JAVACMD%"
  ) else (
    if "%JAVA_HOME%" neq "" (
      if exist "%JAVA_HOME%\bin\java.exe" set "_JAVACMD=%JAVA_HOME%\bin\java.exe"
    )
  )
)

if "%_JAVACMD%"=="" set _JAVACMD=java

rem Detect if this java is ok to use.
for /F %%j in ('"%_JAVACMD%" -version  2^>^&1') do (
  if %%~j==java set JAVAINSTALLED=1
  if %%~j==openjdk set JAVAINSTALLED=1
)

rem BAT has no logical or, so we do it OLD SCHOOL! Oppan Redmond Style
set JAVAOK=true
if not defined JAVAINSTALLED set JAVAOK=false

if "%JAVAOK%"=="false" (
  echo.
  echo A Java JDK is not installed or can't be found.
  if not "%JAVA_HOME%"=="" (
    echo JAVA_HOME = "%JAVA_HOME%"
  )
  echo.
  echo Please go to
  echo   http://www.oracle.com/technetwork/java/javase/downloads/index.html
  echo and download a valid Java JDK and install before running export.
  echo.
  echo If you think this message is in error, please check
  echo your environment variables to see if "java.exe" and "javac.exe" are
  echo available via JAVA_HOME or PATH.
  echo.
  if defined DOUBLECLICKED pause
  exit /B 1
)

rem if configuration files exist, prepend their contents to the script arguments so it can be processed by this runner
call :parse_config "%SCRIPT_CONF_FILE%" SCRIPT_CONF_ARGS

call :process_args %SCRIPT_CONF_ARGS% %%*

set _JAVA_OPTS=!_JAVA_OPTS! !_JAVA_PARAMS!

if defined CUSTOM_MAIN_CLASS (
    set MAIN_CLASS=!CUSTOM_MAIN_CLASS!
) else (
    set MAIN_CLASS=!APP_MAIN_CLASS!
)

rem Call the application and pass all arguments unchanged.
"%_JAVACMD%" !_JAVA_OPTS! !EXPORT_OPTS! -cp "%APP_CLASSPATH%" %MAIN_CLASS% !_APP_ARGS!

@endlocal

exit /B %ERRORLEVEL%


rem Loads a configuration file full of default command line options for this script.
rem First argument is the path to the config file.
rem Second argument is the name of the environment variable to write to.
:parse_config
  set _PARSE_FILE=%~1
  set _PARSE_OUT=
  if exist "%_PARSE_FILE%" (
    FOR /F "tokens=* eol=# usebackq delims=" %%i IN ("%_PARSE_FILE%") DO (
      set _PARSE_OUT=!_PARSE_OUT! %%i
    )
  )
  set %2=!_PARSE_OUT!
exit /B 0


:add_java
  set _JAVA_PARAMS=!_JAVA_PARAMS! %*
exit /B 0


:add_app
  set _APP_ARGS=!_APP_ARGS! %*
exit /B 0


rem Processes incoming arguments and places them in appropriate global variables
:process_args
  :param_loop
  call set _PARAM1=%%1
  set "_TEST_PARAM=%~1"

  if ["!_PARAM1!"]==[""] goto param_afterloop


  rem ignore arguments that do not start with '-'
  if "%_TEST_PARAM:~0,1%"=="-" goto param_java_check
  set _APP_ARGS=!_APP_ARGS! !_PARAM1!
  shift
  goto param_loop

  :param_java_check
  if "!_TEST_PARAM:~0,2!"=="-J" (
    rem strip -J prefix
    set _JAVA_PARAMS=!_JAVA_PARAMS! !_TEST_PARAM:~2!
    shift
    goto param_loop
  )

  if "!_TEST_PARAM:~0,2!"=="-D" (
    rem test if this was double-quoted property "-Dprop=42"
    for /F "delims== tokens=1,*" %%G in ("!_TEST_PARAM!") DO (
      if not ["%%H"] == [""] (
        set _JAVA_PARAMS=!_JAVA_PARAMS! !_PARAM1!
      ) else if [%2] neq [] (
        rem it was a normal property: -Dprop=42 or -Drop="42"
        call set _PARAM1=%%1=%%2
        set _JAVA_PARAMS=!_JAVA_PARAMS! !_PARAM1!
        shift
      )
    )
  ) else (
    if "!_TEST_PARAM!"=="-main" (
      call set CUSTOM_MAIN_CLASS=%%2
      shift
    ) else (
      set _APP_ARGS=!_APP_ARGS! !_PARAM1!
    )
  )
  shift
  goto param_loop
  :param_afterloop

exit /B 0
