/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import domain.FileTree;
import domain.FileTree$;
import domain.input.FileTreeInput$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Base64;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\t\u0013\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006Y!\b\u0005\u0006S\u0001!\tA\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019)\u0005\u0001)A\u0005u!)a\t\u0001C\u0001\u000f\")!\r\u0001C\u0005G\")a\u0010\u0001C\u0005\u007f\"I\u0011Q\u0001\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\n!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011%\t)\u0004\u0001b\u0001\n\u0003\t9\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001d\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u0014\u0001\t\u0003\t\tF\u0001\tTsN$X-\\\"p]R\u0014x\u000e\u001c7fe*\t1#A\u0006d_:$(o\u001c7mKJ\u001c8\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\nA!\u001e;jY*\u0011!eI\u0001\te\u0006\u0014'-\u001b;nc*\u0011A%J\u0001\bCF,\u0018m]=t\u0015\u00051\u0013A\u00014s\u0013\tAsDA\u0004M_\u001e,F/\u001b7\u0002\rqJg.\u001b;?)\u0005YCC\u0001\u0017/!\ti\u0003!D\u0001\u0013\u0011\u0015a\"\u0001q\u0001\u001eQ\t\u0011\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u00051\u0011N\u001c6fGRT\u0011!N\u0001\u0006U\u00064\u0018\r_\u0005\u0003oI\u0012a!\u00138kK\u000e$\u0018!C<pe.\u001c\u0006/Y2f+\u0005Q\u0004CA\u001eC\u001d\ta\u0004\t\u0005\u0002>15\taH\u0003\u0002@)\u00051AH]8pizJ!!\u0011\r\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003b\t!b^8sWN\u0003\u0018mY3!\u0003-9W\r\u001e$jY\u0016$&/Z3\u0015\u000biBeK\u00181\t\u000b%+\u0001\u0019\u0001&\u0002\u000f5,7o]1hKB\u00111\nV\u0007\u0002\u0019*\u0011QJT\u0001\u0005UN|gN\u0003\u0002P!\u0006!A.\u001b2t\u0015\t\t&+A\u0002ba&T\u0011aU\u0001\u0005a2\f\u00170\u0003\u0002V\u0019\n9!j\u001d,bYV,\u0007\"B,\u0006\u0001\u0004A\u0016a\u00025fC\u0012,'o\u001d\t\u0005weS4,\u0003\u0002[\t\n\u0019Q*\u00199\u0011\u0005]a\u0016BA/\u0019\u0005\r\te.\u001f\u0005\u0006?\u0016\u0001\rAO\u0001\u0007[>$W\u000f\\3\t\u000b\u0005,\u0001\u0019\u0001\u001e\u0002\tU\u001cXM]\u0001\faJ|7-Z:t)J,W\r\u0006\u0003eURL\bCA3i\u001b\u00051'\"A4\u0002\r\u0011|W.Y5o\u0013\tIgM\u0001\u0005GS2,GK]3f\u0011\u0015Yg\u00011\u0001m\u0003\u001d\u0019WO\u001d:f]R\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u0005%|'\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014AAR5mK\")QO\u0002a\u0001m\u0006Iq/\u001b;i\r&dWm\u001d\t\u0003/]L!\u0001\u001f\r\u0003\u000f\t{w\u000e\\3b]\")!P\u0002a\u0001w\u0006Ia-\u001b7f\u0019&l\u0017\u000e\u001e\t\u0003/qL!! \r\u0003\u0007%sG/A\u0006hKR4\u0015\u000e\\3UsB,Gc\u0001\u001e\u0002\u0002!1\u00111A\u0004A\u0002i\nAA\\1nK\u0006A\u0001/\u0019;i%\u0016\fG-\u0006\u0002\u0002\nA!1*a\u0003;\u0013\r\ti\u0001\u0014\u0002\u0006%\u0016\fGm]\u0001\na\u0006$\bNU3bI\u0002\nQb\u0019:fCR,G)\u001b:DC2dG#\u0003\u001e\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0011\u0015I%\u00021\u0001K\u0011\u00159&\u00021\u0001Y\u0011\u0015y&\u00021\u0001;\u0011\u0015\t'\u00021\u0001;\u00039!W\r\\3uK\u001aKG.Z\"bY2$\u0012BOA\u0011\u0003G\t)#a\n\t\u000b%[\u0001\u0019\u0001&\t\u000b][\u0001\u0019\u0001-\t\u000b}[\u0001\u0019\u0001\u001e\t\u000b\u0005\\\u0001\u0019\u0001\u001e\u0002\u001b\u0011,G.\u001a;f\t&\u00148)\u00197m)%Q\u0014QFA\u0018\u0003c\t\u0019\u0004C\u0003J\u0019\u0001\u0007!\nC\u0003X\u0019\u0001\u0007\u0001\fC\u0003`\u0019\u0001\u0007!\bC\u0003b\u0019\u0001\u0007!(A\bva2|\u0017\r\u001a$jY\u0016Le\u000e];u+\t\tI\u0004E\u0003L\u0003\u0017\tY\u0004\u0005\u0004\u0018\u0003{Q$HO\u0005\u0004\u0003\u007fA\"A\u0002+va2,7'\u0001\tva2|\u0017\r\u001a$jY\u0016Le\u000e];uA\u0005qQ\u000f\u001d7pC\u00124\u0015\u000e\\3DC2dG#\u0003\u001e\u0002H\u0005%\u00131JA'\u0011\u0015Iu\u00021\u0001K\u0011\u00159v\u00021\u0001Y\u0011\u0015yv\u00021\u0001;\u0011\u0015\tw\u00021\u0001;\u0003\u001d\u0011XNR5mKN$B!a\u0015\u0002ZA\u0019q#!\u0016\n\u0007\u0005]\u0003D\u0001\u0003V]&$\bBBA.!\u0001\u0007!(\u0001\u0003qCRD\u0007")
public class SystemController {
    private final LogUtil logUtil;
    private final String workSpace;
    private final Reads<String> pathRead;
    private final Reads<Tuple3<String, String, String>> uploadFileInput;

    public String workSpace() {
        return this.workSpace;
    }

    public String getFileTree(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(FileTreeInput$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't validate json input : ").append(error).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            String rootDir = (String)input.rootDir().getOrElse((Function0 & Serializable)() -> "/");
            String absoluteRootDir = FileUtil$.MODULE$.toPath(new StringBuilder(0).append(this.workSpace()).append(rootDir).toString());
            File dirFile = new File(absoluteRootDir);
            if (!dirFile.exists()) {
                return ErrorUtil$.MODULE$.jsonError(new StringBuilder(22).append("Dir does not exists : ").append(absoluteRootDir).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            if (!dirFile.isDirectory()) {
                return ErrorUtil$.MODULE$.jsonError(new StringBuilder(23).append("Dir is not directory : ").append(absoluteRootDir).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            return Json$.MODULE$.toJson((Object)this.processTree(dirFile, BoxesRunTime.unboxToBoolean((Object)input.withFiles().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), BoxesRunTime.unboxToInt((Object)input.fileLimit().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 100))), FileTree$.MODULE$.format()).toString();
        });
    }

    private FileTree processTree(File current, boolean withFiles, int fileLimit) {
        Tuple2 tuple2 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])current.listFiles())).partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq files = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)files);
        scala.collection.immutable.Seq dirs2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq files2 = (scala.collection.immutable.Seq)tuple22._2();
        Seq usedFiles = !withFiles ? (Seq)Nil$.MODULE$ : (Seq)files2.take(fileLimit);
        scala.collection.immutable.Seq dirsTree = (scala.collection.immutable.Seq)dirs2.map((Function1 & Serializable)d -> this.processTree((File)d, withFiles, fileLimit));
        Seq filesTree = (Seq)usedFiles.map((Function1 & Serializable)f -> new FileTree(f.getAbsolutePath().replace(this.workSpace(), ""), f.getName(), this.getFileType(f.getName()), FileTree$.MODULE$.apply$default$4()));
        return new FileTree(current.getAbsolutePath().replace(this.workSpace(), ""), new StringBuilder(1).append(current.getName()).append(" ").append((Object)(withFiles && files2.nonEmpty() ? new StringBuilder(11).append("(").append(files2.length()).append(" fichiers)").toString() : "")).toString(), "folder", (Option<Seq<FileTree>>)new Some(dirsTree.$plus$plus((IterableOnce)filesTree)));
    }

    private String getFileType(String name) {
        block23: {
            block25: {
                block24: {
                    String string = ((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(name), '.')))).toLowerCase();
                    switch (string == null ? 0 : string.hashCode()) {
                        case 98822: {
                            if ("csv".equals(string)) {
                                return "csv";
                            }
                            break block23;
                        }
                        case 99640: {
                            if (!"doc".equals(string)) break block23;
                            break block24;
                        }
                        case 105441: {
                            if (!"jpg".equals(string)) break block23;
                            break block25;
                        }
                        case 109886: {
                            if (!"ods".equals(string)) break block23;
                            break block24;
                        }
                        case 109887: {
                            if (!"odt".equals(string)) break block23;
                            break block24;
                        }
                        case 110834: {
                            if ("pdf".equals(string)) {
                                return "pdf";
                            }
                            break block23;
                        }
                        case 111145: {
                            if (!"png".equals(string)) break block23;
                            break block25;
                        }
                        case 114276: {
                            if (!"svg".equals(string)) break block23;
                            break block25;
                        }
                        case 115312: {
                            if (!"txt".equals(string)) break block23;
                            break block24;
                        }
                        case 118783: {
                            if ("xls".equals(string)) {
                                break;
                            }
                            break block23;
                        }
                        case 120609: {
                            if ("zip".equals(string)) {
                                return "zip";
                            }
                            break block23;
                        }
                        case 3088960: {
                            if (!"docx".equals(string)) break block23;
                            break block24;
                        }
                        case 3268712: {
                            if (!"jpeg".equals(string)) break block23;
                            break block25;
                        }
                        case 3682382: {
                            if ("xlsm".equals(string)) {
                                break;
                            }
                            break block23;
                        }
                        case 3682393: {
                            if ("xlsx".equals(string)) {
                                break;
                            }
                            break block23;
                        }
                        default: {
                            break block23;
                        }
                    }
                    return "excel";
                }
                return "doc";
            }
            return "image";
        }
        return "inconnu";
    }

    public Reads<String> pathRead() {
        return this.pathRead;
    }

    public String createDirCall(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pathRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't validate json input : ").append(error).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)path -> {
            if (path.contains("..") || path.contains(" ")) {
                return ErrorUtil$.MODULE$.jsonError("Bad path on input", ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            String absoluteRootDir = FileUtil$.MODULE$.toPath(new StringBuilder(0).append(this.workSpace()).append((String)path).toString());
            ErrorUtil$.MODULE$.jsonError(absoluteRootDir, ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteFileCall(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pathRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't validate json input : ").append(error).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)path -> {
            if (path.contains("..")) {
                return ErrorUtil$.MODULE$.jsonError("Bad path on input", ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            String absolutePath = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(FileUtil$.MODULE$.toPath(new StringBuilder(0).append(this.workSpace()).append((String)path).toString())), 1);
            File file = new File(absolutePath);
            if (!file.exists()) {
                return ErrorUtil$.MODULE$.jsonError("File not found", 404, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            if (!file.isFile()) {
                return ErrorUtil$.MODULE$.jsonError("Not a file", 500, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            if (!file.delete()) {
                return ErrorUtil$.MODULE$.jsonError("Error during file delete (permission acces ?)", ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteDirCall(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pathRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't validate json input : ").append(error).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)path -> {
            if (path.contains("..") || path.contains(" ")) {
                return ErrorUtil$.MODULE$.jsonError("Bad path on input", ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            if (!new File(new StringBuilder(0).append(this.workSpace()).append((String)path).toString()).exists()) {
                return ErrorUtil$.MODULE$.jsonError("Dir not found", 404, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            if (!new File(new StringBuilder(0).append(this.workSpace()).append((String)path).toString()).isDirectory()) {
                return ErrorUtil$.MODULE$.jsonError("Not a Dir", 500, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            String absolutePath = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(FileUtil$.MODULE$.toPath(new StringBuilder(0).append(this.workSpace()).append((String)path).toString())), 1);
            this.rmFiles(absolutePath);
            return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple3<String, String, String>> uploadFileInput() {
        return this.uploadFileInput;
    }

    public String uploadFileCall(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.uploadFileInput()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(46).append("Can't validate json input (uploadChainFile) : ").append(error).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            String string;
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String dirPath = (String)tuple3._1();
            String filename = (String)tuple3._2();
            String contenu = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)dirPath, (Object)filename, (Object)contenu);
            String dirPath2 = (String)tuple32._1();
            String filename2 = (String)tuple32._2();
            String contenu2 = (String)tuple32._3();
            if (dirPath2.contains("..") || dirPath2.contains(" ") || filename2.contains("..")) {
                return ErrorUtil$.MODULE$.jsonError("Bad path on input", ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            String absoluteRootDir = FileUtil$.MODULE$.toPath(new StringBuilder(0).append(this.workSpace()).append(dirPath2).toString());
            try {
                ArraySeq.ofRef content = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(contenu2), ','));
                byte[] data = Base64.getDecoder().decode(contenu2.contains(",") ? (String)content.apply(1) : contenu2);
                FileOutputStream stream = new FileOutputStream(FileUtil$.MODULE$.toPath(new StringBuilder(1).append(absoluteRootDir).append("/").append(filename2).toString()));
                stream.write(data);
                stream.close();
                File f = new File(FileUtil$.MODULE$.toPath(new StringBuilder(1).append(absoluteRootDir).append("/").append(filename2).toString()));
                f.setReadable(true, false);
                f.setWritable(true, false);
                f.setExecutable(true, false);
                string = Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                string = ErrorUtil$.MODULE$.jsonError(new StringBuilder(20).append("Can't upload file : ").append(e.getMessage()).toString(), 500, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil);
            }
            return string;
        });
    }

    public void rmFiles(String path) {
        String rm_cmd = "rm -rf ";
        if (new File(path).exists()) {
            int processResult = Process$.MODULE$.apply(new StringBuilder(0).append(rm_cmd).append(path).toString()).$bang();
            if (processResult != 0) {
                throw new Exception(new StringBuilder(25).append("Unable to delete files : ").append(path).toString());
            }
            return;
        }
    }

    @Inject
    public SystemController(LogUtil logUtil) {
        this.logUtil = logUtil;
        this.workSpace = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> {
            throw new Exception("No URL_UTILS on .env");
        });
        this.pathRead = JsPath$.MODULE$.$bslash("path").read((Reads)Reads$.MODULE$.StringReads());
        this.uploadFileInput = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("dirPath").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("filename").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("content").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

