/*
 * Decompiled with CFR 0.152.
 */
package util;

import fr.aquasys.utils.StationTypeUtil$;
import java.io.File;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class FolderUtil$ {
    public static final FolderUtil$ MODULE$ = new FolderUtil$();
    private static final Seq<String> picturesExtensions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".jpg", ".JPG", ".jpeg", ".JPEG", ".png", ".PNG", ".gif", ".GIF", ".img", ".IMG", ".jpe", ".JPE", ".bmp", ".BMP", ".tif", ".TIF", ".emf", ".EMF", ".heif", ".HEIF"}));
    private static final Seq<String> documentsExtensions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".doc", ".DOC", ".docx", ".DOCX", ".pdf", ".PDF", ".xls", ".XLS", ".xlsx", ".csv", ".CSV", ".XLSX", ".xlsm", ".XLSM", ".ods", ".xsd", ".XSD", ".ODS", ".odt", ".ODT", ".zip", ".ZIP", ".xml", ".XML", ".odp", ".ODP", ".ppt", ".PPT", ".pptx", ".PPTX", ".txt", ".TXT", ".sql", ".SQL", ".bat", ".jasper", ".BAT", ".kml", ".KML", ".qml", ".QML"}));
    private static final Seq<String> cartoExtensions = new .colon.colon((Object)".kml", (List)new .colon.colon((Object)".KML", (List)Nil$.MODULE$));

    public Seq<String> picturesExtensions() {
        return picturesExtensions;
    }

    public Seq<String> documentsExtensions() {
        return documentsExtensions;
    }

    public Seq<String> cartoExtensions() {
        return cartoExtensions;
    }

    public Seq<File> getListOfFilesWithExtensions(File dir, Seq<String> extensions) {
        if (dir != null) {
            if (dir.listFiles() != null) {
                return (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile())))).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)extensions.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$getListOfFilesWithExtensions$3(file, x$2)))));
            }
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)Nil$.MODULE$;
    }

    public Seq<File> getListOfFilesWithExpression(Seq<File> listOfFile, String expresssion) {
        return (Seq)listOfFile.filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$getListOfFilesWithExpression$1(expresssion, file)));
    }

    public Option<Seq<File>> getAllListOfFilesWithExtensions(File dir, Seq<String> extensions) {
        if (!dir.exists()) {
            return None$.MODULE$;
        }
        Seq<File> listSubDirectory = this.recursiveListFiles(dir);
        if (listSubDirectory != null) {
            if (listSubDirectory.nonEmpty()) {
                Seq listFilesSubdir = (Seq)listSubDirectory.flatMap((Function1 & Serializable)f -> {
                    if (f != null) {
                        if (f.isDirectory()) {
                            return None$.MODULE$;
                        }
                        return new .colon.colon(f, (List)Nil$.MODULE$);
                    }
                    return None$.MODULE$;
                });
                return new Some(listFilesSubdir.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)extensions.exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$getAllListOfFilesWithExtensions$3(f, ext))))));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public boolean isStationCodeExist(String chaine) {
        if (chaine.length() == 10) {
            return chaine.toUpperCase().startsWith("BSS") || chaine.matches("([0-9]{5}[a-zA-Z]{1}[0-9]{4})") || chaine.toUpperCase().contains("ZZ");
        }
        if (chaine.length() == 13) {
            return chaine.startsWith("0") && chaine.matches("([0-9]{13})");
        }
        if (chaine.length() == 8) {
            return chaine.matches("([a-zA-Z0-9]{1}[0-9]{7})");
        }
        if (chaine.length() == 14) {
            return chaine.matches("([0-9]{14})");
        }
        return false;
    }

    public Seq<File> findInDirRec(File dir, Seq<String> extensions, Option<String> codeStation, Seq<String> searchValues) {
        if (searchValues.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq searchValuesFormated = (Seq)searchValues.map((Function1 & Serializable)x$3 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$3.toLowerCase().split("[-,._]")), (Function1 & Serializable)substring -> substring.replaceAll("^[0]*", ""), ClassTag$.MODULE$.apply(String.class))).mkString(" "));
        return this.findInDirsRec((List<File>)new .colon.colon((Object)dir, (List)Nil$.MODULE$), (List<File>)Nil$.MODULE$, extensions, codeStation, (Seq<String>)searchValuesFormated);
    }

    public List<File> findInDirWithRegex(String dirPath, Option<String> regex, boolean deepSearch, boolean dirSearch, Option<String> fileType, Option<String> searchValue) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new Exception(new StringBuilder(26).append("Dirpath does not exists : ").append(dirPath).toString());
        }
        if (deepSearch) {
            return this.findInDirsRecWithRegex((List<File>)new .colon.colon((Object)dir, (List)Nil$.MODULE$), (List<File>)Nil$.MODULE$, (Function1<List<File>, List<File>>)(Function1 & Serializable)files -> FolderUtil$.filterFiles$1(files, regex, searchValue, fileType), dirSearch, searchValue, fileType);
        }
        return FolderUtil$.filterFiles$1(Predef$.MODULE$.wrapRefArray((Object[])dir.listFiles()).toList().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isFile())), regex, searchValue, fileType);
    }

    public List<File> filterFilesType(Option<String> fileType, List<File> files) {
        String string;
        String string2;
        boolean bl = false;
        Some some = null;
        Option<String> option = fileType;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string3 = (String)some.value();
            if ("DOCUMENTS".equals(string3)) {
                return files.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$filterFilesType$1(f)));
            }
        }
        if (bl && "PICTURES".equals(string2 = (String)some.value())) {
            return files.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$filterFilesType$3(f)));
        }
        if (bl && "CARTO".equals(string = (String)some.value())) {
            return files.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$filterFilesType$5(f)));
        }
        return files;
    }

    public List<File> findInDirsRecWithRegex(List<File> dirs, List<File> founds, Function1<List<File>, List<File>> filterFiles, boolean dirSearch, Option<String> searchValue, Option<String> fileType) {
        List list;
        while (true) {
            if (Nil$.MODULE$.equals(list = dirs)) {
                return founds;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            File head = (File)colon2.head();
            List tail = colon2.next$access$1();
            Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])head.listFiles()).toList().partition((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isDirectory()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List dirsOfDir = (List)tuple2._1();
            List files = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dirsOfDir, (Object)files);
            List dirsOfDir2 = (List)tuple22._1();
            List files2 = (List)tuple22._2();
            if (dirSearch) {
                Tuple2 tuple23 = dirsOfDir2.partition((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirsRecWithRegex$2(searchValue, x$11)));
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                List searchDirs = (List)tuple23._1();
                List othersDirs = (List)tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)searchDirs, (Object)othersDirs);
                List searchDirs2 = (List)tuple24._1();
                List othersDirs2 = (List)tuple24._2();
                List<File> searchDirFiles = this.getAllFilesInDirsRec((List<File>)searchDirs2, (List<File>)Nil$.MODULE$, (Function1<List<File>, List<File>>)(Function1 & Serializable)x$13 -> MODULE$.filterFilesType(fileType, (List<File>)x$13), fileType);
                List list2 = (List)((IterableOps)founds.$plus$plus(searchDirFiles)).$plus$plus((IterableOnce)filterFiles.apply((Object)files2));
                founds = list2;
                dirs = (List)tail.$plus$plus((IterableOnce)othersDirs2);
                continue;
            }
            List list3 = (List)founds.$plus$plus((IterableOnce)filterFiles.apply((Object)files2));
            founds = list3;
            dirs = (List)tail.$plus$plus((IterableOnce)dirsOfDir2);
        }
        throw new MatchError(list);
    }

    public List<File> getAllFilesInDirsRec(List<File> dirs, List<File> founds, Function1<List<File>, List<File>> filterFiles, Option<String> fileType) {
        List list;
        while (true) {
            if (Nil$.MODULE$.equals(list = dirs)) {
                return founds;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            File head = (File)colon2.head();
            List tail = colon2.next$access$1();
            Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])head.listFiles()).toList().partition((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isDirectory()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List otherDirs = (List)tuple2._1();
            List files = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)otherDirs, (Object)files);
            List otherDirs2 = (List)tuple22._1();
            List files2 = (List)tuple22._2();
            List list2 = (List)founds.$plus$plus(this.filterFilesType(fileType, (List<File>)files2));
            Function1 & Serializable intersect = (Function1 & Serializable)x$16 -> MODULE$.filterFilesType(fileType, (List<File>)x$16);
            filterFiles = intersect;
            founds = list2;
            dirs = (List)tail.$plus$plus((IterableOnce)otherDirs2);
        }
        throw new MatchError(list);
    }

    public Seq<File> findInDirsRec(List<File> dirs, List<File> founds, Seq<String> extensions, Option<String> codeStation, Seq<String> searchValues) {
        List list;
        while (true) {
            if (Nil$.MODULE$.equals(list = dirs)) {
                return founds;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            File head = (File)colon2.head();
            List tail = colon2.next$access$1();
            if (!head.exists()) {
                dirs = tail;
                continue;
            }
            if (head.isDirectory()) {
                List files = codeStation.isEmpty() ? Predef$.MODULE$.wrapRefArray((Object[])head.listFiles()).toList() : Predef$.MODULE$.wrapRefArray((Object[])head.listFiles()).toList().filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])f.getName().split("[-,._]")), (Function1 & Serializable)chaine -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirsRec$2(codeStation$1, searchValues$1, chaine)))));
                dirs = (List)files.$plus$plus((IterableOnce)tail);
                continue;
            }
            String upperName = head.getName().toUpperCase();
            String nameFormated = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])head.getName().toLowerCase().split("[-,._]")), (Function1 & Serializable)substring -> substring.replaceAll("^[0]*", " "), ClassTag$.MODULE$.apply(String.class))).mkString("");
            if (extensions.exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)upperName.endsWith(ext.toUpperCase()))) && searchValues.exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)nameFormated.contains(new StringBuilder(2).append(" ").append(s).append(" ").toString())))) {
                File file = head;
                founds = (List)founds.$plus$colon((Object)file);
                dirs = tail;
                continue;
            }
            dirs = tail;
        }
        throw new MatchError(list);
    }

    public Seq<File> recursiveListFiles(File dir2) {
        File[] these = dir2.listFiles();
        if (these != null) {
            return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])these), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])these), (Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.isDirectory()))), (Function1 & Serializable)dir -> MODULE$.recursiveListFiles((File)dir), ClassTag$.MODULE$.apply(File.class)), ClassTag$.MODULE$.apply(File.class)));
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)these);
    }

    public Seq<File> getListFromDate(Seq<File> listOfFile, DateTime date) {
        if (listOfFile != null) {
            return (Seq)listOfFile.filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$getListFromDate$1(date, file)));
        }
        return null;
    }

    public Seq<File> getListOfFiles(File dir) {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isFile()))));
    }

    public String isolateCode(String fileName) {
        Option option;
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(50).append("(.*)_.*_\\d_(?:\\d{8}-\\d*|\\d*)_(?:").append(StationTypeUtil$.MODULE$.PIEZOMETRY()).append("|").append(StationTypeUtil$.MODULE$.QUALITY()).append("|").append(StationTypeUtil$.MODULE$.HYDROMETRY()).append("|").append(StationTypeUtil$.MODULE$.PLUVIOMETRY()).append("|").append(StationTypeUtil$.MODULE$.INSTALLATION()).append("|").append(StationTypeUtil$.MODULE$.PRODUCTION()).append("|").append(StationTypeUtil$.MODULE$.DISTRIBUTION()).append(")?_?.*\\..{3}").toString()));
        String string = fileName;
        if (string != null && !(option = pattern.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String code = (String)((LinearSeqOps)option.get()).apply(0);
            return code;
        }
        return (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])fileName.split("_")));
    }

    public static final /* synthetic */ boolean $anonfun$getListOfFilesWithExtensions$3(File file$1, String x$2) {
        return file$1.getName().endsWith(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$getListOfFilesWithExpression$1(String expresssion$1, File file) {
        return file.getName().contains(new StringBuilder(1).append(expresssion$1).append(" ").toString()) || file.getName().contains(new StringBuilder(1).append(expresssion$1).append("_").toString()) || file.getName().contains(new StringBuilder(1).append(expresssion$1).append("-").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getAllListOfFilesWithExtensions$3(File f$1, String ext) {
        return f$1.getName().endsWith(ext);
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$2(Option regex$1, File x$5) {
        return x$5.getName().matches((String)regex$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$4(String sv$1, File x$7) {
        return x$7.getName().toUpperCase().contains(sv$1);
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$6(File f$2, String ext) {
        return f$2.getName().toUpperCase().endsWith(ext.toUpperCase());
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$5(File f) {
        return MODULE$.documentsExtensions().exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$6(f, ext)));
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$8(File f$3, String ext) {
        return f$3.getName().toUpperCase().endsWith(ext.toUpperCase());
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$7(File f) {
        return MODULE$.picturesExtensions().exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$8(f, ext)));
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$10(File f$4, String ext) {
        return f$4.getName().toUpperCase().endsWith(ext.toUpperCase());
    }

    public static final /* synthetic */ boolean $anonfun$findInDirWithRegex$9(File f) {
        return MODULE$.cartoExtensions().exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$10(f, ext)));
    }

    private static final List filterFiles$1(List files, Option regex$1, Option searchValue$1, Option fileType$1) {
        String string;
        String string2;
        Some some;
        String sv;
        List filteredRegex = regex$1.isDefined() && regex$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4)))) ? files.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$2(regex$1, x$5))) : files;
        Option option = searchValue$1.map((Function1 & Serializable)x$6 -> x$6.toUpperCase());
        List filteredSearchValue = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sv = (String)(some = (Some)option).value())) ? filteredRegex.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$4(sv, x$7))) : filteredRegex;
        boolean bl = false;
        Some some2 = null;
        Option option2 = fileType$1;
        if (option2 instanceof Some) {
            bl = true;
            some2 = (Some)option2;
            String string3 = (String)some2.value();
            if ("DOCUMENTS".equals(string3)) {
                return filteredSearchValue.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$5(f)));
            }
        }
        if (bl && "PICTURES".equals(string2 = (String)some2.value())) {
            return filteredSearchValue.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$7(f)));
        }
        if (bl && "CARTO".equals(string = (String)some2.value())) {
            return filteredSearchValue.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$findInDirWithRegex$9(f)));
        }
        return filteredSearchValue;
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesType$2(File f$5, String ext) {
        return f$5.getName().toUpperCase().endsWith(ext.toUpperCase());
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesType$1(File f) {
        return MODULE$.documentsExtensions().exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$filterFilesType$2(f, ext)));
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesType$4(File f$6, String ext) {
        return f$6.getName().toUpperCase().endsWith(ext.toUpperCase());
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesType$3(File f) {
        return MODULE$.picturesExtensions().exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$filterFilesType$4(f, ext)));
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesType$6(File f$7, String ext) {
        return f$7.getName().toUpperCase().endsWith(ext.toUpperCase());
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesType$5(File f) {
        return MODULE$.cartoExtensions().exists((Function1 & Serializable)ext -> BoxesRunTime.boxToBoolean((boolean)FolderUtil$.$anonfun$filterFilesType$6(f, ext)));
    }

    public static final /* synthetic */ boolean $anonfun$findInDirsRecWithRegex$2(Option searchValue$2, File x$11) {
        return x$11.getName().toUpperCase().contains((CharSequence)searchValue$2.getOrElse((Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ boolean $anonfun$findInDirsRec$2(Option codeStation$1, Seq searchValues$1, String chaine) {
        return !MODULE$.isStationCodeExist(chaine) || chaine.contains((CharSequence)codeStation$1.get()) || searchValues$1.exists((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)chaine.contains(v)));
    }

    public static final /* synthetic */ boolean $anonfun$getListFromDate$1(DateTime date$1, File file) {
        if (BoxesRunTime.boxToLong((long)file.lastModified()) != null) {
            DateTime dateFile = new DateTime(file.lastModified());
            Duration duration = new Duration((ReadableInstant)dateFile, (ReadableInstant)date$1);
            return duration.getMillis() <= 0L;
        }
        return false;
    }

    private FolderUtil$() {
    }
}

