/*
 * Decompiled with CFR 0.152.
 */
package play.filters.cors;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.pekko.util.ByteString;
import play.api.LoggerLike;
import play.api.MarkerContext;
import play.api.MarkerContexts;
import play.api.http.HeaderNames$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpVerbs$;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.EssentialAction;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.Execution;
import play.core.Execution$;
import play.filters.cors.CORSConfig;
import play.filters.cors.CORSFilter$Attrs$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001C\u0007\u000f!\u0003\r\tA\u0004\u000b\t\u000bm\u0001A\u0011A\u000f\t\u000f\u0005\u0002!\u0019!D\tE!)\u0011\u0006\u0001D\tU!)q\u0006\u0001D\ta!9q\u0007\u0001b\u0001\n\u0013A\u0004\"B$\u0001\t#A\u0005\"B7\u0001\t\u0013q\u0007\"B9\u0001\t\u0013\u0011\b\"B<\u0001\t\u0013A\b\"\u0002>\u0001\t\u0013Y\b\"B?\u0001\t\u0013q\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\u0013\u0003\n\u001cHO]1di\u000e{%k\u0015)pY&\u001c\u0017P\u0003\u0002\u0010!\u0005!1m\u001c:t\u0015\t\t\"#A\u0004gS2$XM]:\u000b\u0003M\tA\u0001\u001d7bsN\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012A\b\t\u0003-}I!\u0001I\f\u0003\tUs\u0017\u000e^\u0001\u0007Y><w-\u001a:\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0002)K\tQAj\\4hKJd\u0015n[3\u0002\u0015\r|'o]\"p]\u001aLw-F\u0001,!\taS&D\u0001\u000f\u0013\tqcB\u0001\u0006D\u001fJ\u001b6i\u001c8gS\u001e\fA\"\u001a:s_JD\u0015M\u001c3mKJ,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0015\nA\u0001\u001b;ua&\u0011ag\r\u0002\u0011\u0011R$\b/\u0012:s_JD\u0015M\u001c3mKJ\fAcU;qa>\u0014H/\u001a3IiR\u0004X*\u001a;i_\u0012\u001cX#A\u001d\u0011\u0007i\nEI\u0004\u0002<\u007fA\u0011AhF\u0007\u0002{)\u0011a\bH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001;\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n\u00191+\u001a;\u000b\u0005\u0001;\u0002C\u0001\u001eF\u0013\t15I\u0001\u0004TiJLgnZ\u0001\u000eM&dG/\u001a:SKF,Xm\u001d;\u0015\u0007%\u001b\u0007\u000e\u0005\u0003K\u001fFkV\"A&\u000b\u00051k\u0015aB:ue\u0016\fWn\u001d\u0006\u0003\u001d\u0016\nA\u0001\\5cg&\u0011\u0001k\u0013\u0002\f\u0003\u000e\u001cW/\\;mCR|'\u000f\u0005\u0002S76\t1K\u0003\u0002U+\u0006!Q\u000f^5m\u0015\t1v+A\u0003qK.\\wN\u0003\u0002Y3\u00061\u0011\r]1dQ\u0016T\u0011AW\u0001\u0004_J<\u0017B\u0001/T\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u0016\n1!\u001c<d\u0013\t\u0011wL\u0001\u0004SKN,H\u000e\u001e\u0005\u0006I\u001a\u0001\r!Z\u0001\u0005]\u0016DH\u000f\u0005\u0002_M&\u0011qm\u0018\u0002\u0010\u000bN\u001cXM\u001c;jC2\f5\r^5p]\")\u0011N\u0002a\u0001U\u00069!/Z9vKN$\bC\u00010l\u0013\tawLA\u0007SKF,Xm\u001d;IK\u0006$WM]\u0001\u0012Q\u0006tG\r\\3D\u001fJ\u001b&+Z9vKN$HcA%pa\")Am\u0002a\u0001K\")\u0011n\u0002a\u0001U\u0006q\u0011\r\u001a3D_J\u001c\b*Z1eKJ\u001cHcA/tk\")A\u000f\u0003a\u0001;\u00061!/Z:vYRDQA\u001e\u0005A\u0002\u0011\u000bA!Y2b_\u0006Q\u0002.\u00198eY\u0016\u0004&/\u001a$mS\u001eDGoQ(S'J+\u0017/^3tiR\u0011\u0011*\u001f\u0005\u0006S&\u0001\rA[\u0001\u0019Q\u0006tG\r\\3J]Z\fG.\u001b3D\u001fJ\u001b&+Z9vKN$HCA%}\u0011\u0015I'\u00021\u0001k\u00035I7OV1mS\u0012|%/[4j]R\u0019q0!\u0002\u0011\u0007Y\t\t!C\u0002\u0002\u0004]\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\b-\u0001\r\u0001R\u0001\u0007_JLw-\u001b8\u0002\u0019%\u001c8+Y7f\u001fJLw-\u001b8\u0015\u000b}\fi!a\u0004\t\r\u0005\u001dA\u00021\u0001E\u0011\u0015IG\u00021\u0001k\u0001")
public interface AbstractCORSPolicy {
    public void play$filters$cors$AbstractCORSPolicy$_setter_$play$filters$cors$AbstractCORSPolicy$$SupportedHttpMethods_$eq(Set<String> var1);

    public LoggerLike logger();

    public CORSConfig corsConfig();

    public HttpErrorHandler errorHandler();

    public Set<String> play$filters$cors$AbstractCORSPolicy$$SupportedHttpMethods();

    public static /* synthetic */ Accumulator filterRequest$(AbstractCORSPolicy $this, EssentialAction next, RequestHeader request) {
        return $this.filterRequest(next, request);
    }

    /*
     * Unable to fully structure code
     */
    default public Accumulator<ByteString, Result> filterRequest(EssentialAction next, RequestHeader request) {
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            var6_3 = new Tuple2((Object)request.headers().get(HeaderNames$.MODULE$.ORIGIN()), (Object)request.method());
                            if (var6_3 == null || !None$.MODULE$.equals(var7_4 = (Option)var6_3._1())) break block2;
                            v0 = (Accumulator<ByteString, Result>)next.apply((Object)request);
                            break block3;
                        }
                        if (var6_3 == null || !((var8_5 = (Option)var6_3._1()) instanceof Some) || !(originHeader = (String)(var9_6 = (Some)var8_5).value()).isEmpty() && this.isValidOrigin(originHeader)) break block4;
                        v0 = this.corsConfig().serveForbiddenOrigins() ? (Accumulator<ByteString, Result>)next.apply((Object)request) : this.handleInvalidCORSRequest(request);
                        break block3;
                    }
                    if (var6_3 == null || !((var11_8 = (Option)var6_3._1()) instanceof Some) || !this.isSameOrigin(originHeader = (String)(var12_9 = (Some)var11_8).value(), request)) break block5;
                    v0 = (Accumulator)next.apply((Object)request);
                    break block3;
                }
                if (var6_3 == null) break block6;
                var14_11 = (String)var6_3._2();
                v1 = HttpVerbs$.MODULE$.OPTIONS();
                var15_12 = var14_11;
                if (v1 != null ? v1.equals(var15_12) == false : var15_12 != null) break block6;
                var16_13 = request.headers().get(HeaderNames$.MODULE$.ACCESS_CONTROL_REQUEST_METHOD());
                v0 = None$.MODULE$.equals(var16_13) ? this.handleCORSRequest(next, request) : (var16_13 instanceof Some && "".equals(var18_15 = (String)(var17_14 = (Some)var16_13).value()) ? this.handleInvalidCORSRequest(request) : this.handlePreFlightCORSRequest(request));
                break block3;
            }
            if (var6_3 == null) ** GOTO lbl-1000
            method = (String)var6_3._2();
            if (this.play$filters$cors$AbstractCORSPolicy$$SupportedHttpMethods().contains((Object)method)) {
                v0 = this.handleCORSRequest(next, request);
            } else lbl-1000:
            // 2 sources

            {
                v0 = this.handleInvalidCORSRequest(request);
            }
        }
        resultAcc = v0;
        return resultAcc.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$filterRequest$1(play.api.mvc.Result ), (Lplay/api/mvc/Result;)Lplay/api/mvc/Result;)(), (ExecutionContext)Execution$.MODULE$.trampoline());
    }

    private Accumulator<ByteString, Result> handleCORSRequest(EssentialAction next, RequestHeader request) {
        Option originOpt = request.headers().get(HeaderNames$.MODULE$.ORIGIN());
        Predef$.MODULE$.assume(originOpt.isDefined(), (Function0 & Serializable)() -> "The presence of the ORIGIN header should guaranteed at this point.");
        String origin = (String)originOpt.get();
        Option<String> option = this.corsConfig().allowedForOrigin(origin);
        if (None$.MODULE$.equals(option)) {
            if (this.corsConfig().serveForbiddenOrigins()) {
                return (Accumulator)next.apply((Object)request);
            }
            return this.handleInvalidCORSRequest(request);
        }
        if (option instanceof Some) {
            Accumulator accumulator;
            Some some = (Some)option;
            String acao = (String)some.value();
            RequestHeader taggedRequest = request.addAttr(CORSFilter$Attrs$.MODULE$.Origin(), (Object)origin);
            try {
                accumulator = ((Accumulator)next.apply((Object)taggedRequest)).recoverWith((PartialFunction)new Serializable(this, taggedRequest){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ AbstractCORSPolicy $outer;
                    private final RequestHeader taggedRequest$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            A1 A12 = A1;
                            return (B1)this.$outer.errorHandler().onServerError(this.taggedRequest$1, A12);
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable != null;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.taggedRequest$1 = taggedRequest$1;
                    }
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
            }
            catch (Throwable e) {
                accumulator = Accumulator$.MODULE$.done(this.errorHandler().onServerError(taggedRequest, e));
            }
            Accumulator result = accumulator;
            return result.map((Function1 & Serializable)x$1 -> this.addCorsHeaders((Result)x$1, acao), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        throw new MatchError(option);
    }

    private Result addCorsHeaders(Result result, String acao) {
        Builder headerBuilder = package$.MODULE$.Seq().newBuilder();
        Object object = this.corsConfig().supportsCredentials() ? headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_ALLOW_CREDENTIALS()), (Object)"true")) : BoxedUnit.UNIT;
        headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_ALLOW_ORIGIN()), (Object)acao));
        Object object2 = this.corsConfig().exposedHeaders().nonEmpty() ? headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_EXPOSE_HEADERS()), (Object)this.corsConfig().exposedHeaders().mkString(","))) : BoxedUnit.UNIT;
        return result.withHeaders((Seq)headerBuilder.result());
    }

    private Accumulator<ByteString, Result> handlePreFlightCORSRequest(RequestHeader request) {
        Option originOpt = request.headers().get(HeaderNames$.MODULE$.ORIGIN());
        Predef$.MODULE$.assume(originOpt.isDefined(), (Function0 & Serializable)() -> "The presence of the ORIGIN header should guaranteed at this point.");
        String origin = (String)originOpt.get();
        Option<String> option = this.corsConfig().allowedForOrigin(origin);
        if (None$.MODULE$.equals(option)) {
            return this.handleInvalidCORSRequest(request);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String acao = (String)some.value();
            Option option2 = request.headers().get(HeaderNames$.MODULE$.ACCESS_CONTROL_REQUEST_METHOD());
            if (None$.MODULE$.equals(option2)) {
                return this.handleInvalidCORSRequest(request);
            }
            if (option2 instanceof Some) {
                List list;
                Some some2 = (Some)option2;
                String requestMethod = (String)some2.value();
                String accessControlRequestMethod = requestMethod.trim();
                Function1<String, Object> methodPredicate = this.corsConfig().isHttpMethodAllowed();
                if (!this.play$filters$cors$AbstractCORSPolicy$$SupportedHttpMethods().contains((Object)accessControlRequestMethod) || !BoxesRunTime.unboxToBoolean((Object)methodPredicate.apply((Object)accessControlRequestMethod))) {
                    return this.handleInvalidCORSRequest(request);
                }
                Option option3 = request.headers().get(HeaderNames$.MODULE$.ACCESS_CONTROL_REQUEST_HEADERS());
                if (None$.MODULE$.equals(option3)) {
                    list = package$.MODULE$.List().empty();
                } else if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    String headerVal = (String)some3.value();
                    list = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(headerVal.trim()), ','))).map((Function1 & Serializable)x$2 -> x$2.trim().toLowerCase(Locale.ENGLISH)).toList();
                } else {
                    throw new MatchError((Object)option3);
                }
                List accessControlRequestHeaders = list;
                Function1<String, Object> headerPredicate = this.corsConfig().isHttpHeaderAllowed();
                if (!accessControlRequestHeaders.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractCORSPolicy.$anonfun$handlePreFlightCORSRequest$3(headerPredicate, x$3)))) {
                    return this.handleInvalidCORSRequest(request);
                }
                Builder headerBuilder = package$.MODULE$.Seq().newBuilder();
                Object object = this.corsConfig().supportsCredentials() ? headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_ALLOW_CREDENTIALS()), (Object)"true")) : BoxedUnit.UNIT;
                headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_ALLOW_ORIGIN()), (Object)acao));
                Object object2 = this.corsConfig().preflightMaxAge().toSeconds() > 0L ? headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_MAX_AGE()), (Object)Long.toString(this.corsConfig().preflightMaxAge().toSeconds()))) : BoxedUnit.UNIT;
                headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_ALLOW_METHODS()), (Object)accessControlRequestMethod));
                Object object3 = accessControlRequestHeaders.nonEmpty() ? headerBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCESS_CONTROL_ALLOW_HEADERS()), (Object)accessControlRequestHeaders.mkString(","))) : BoxedUnit.UNIT;
                return Accumulator$.MODULE$.done((Object)Results$.MODULE$.Ok().withHeaders((Seq)headerBuilder.result()));
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    private Accumulator<ByteString, Result> handleInvalidCORSRequest(RequestHeader request) {
        this.logger().warn((Function0 & Serializable)() -> "Invalid CORS request;Origin=" + request.headers().get(HeaderNames$.MODULE$.ORIGIN()) + ";Method=" + request.method() + ";" + HeaderNames$.MODULE$.ACCESS_CONTROL_REQUEST_HEADERS() + "=" + request.headers().get(HeaderNames$.MODULE$.ACCESS_CONTROL_REQUEST_HEADERS()), (MarkerContext)MarkerContexts.SecurityMarkerContext$.MODULE$);
        return Accumulator$.MODULE$.done(Future$.MODULE$.successful((Object)Results$.MODULE$.Forbidden()));
    }

    private boolean isValidOrigin(String origin) {
        boolean bl;
        block5: {
            String string = origin;
            String string2 = "null";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
            if (origin.contains("%")) {
                return false;
            }
            try {
                if (new URI(origin).getScheme() != null) {
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            catch (URISyntaxException uRISyntaxException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isSameOrigin(String origin, RequestHeader request) {
        URI originUri = new URI(origin.toLowerCase(Locale.ENGLISH));
        URI hostUri = new URI((request.secure() ? "https://" : "http://") + request.host().toLowerCase(Locale.ENGLISH));
        Tuple3 tuple3 = new Tuple3((Object)originUri.getScheme(), (Object)originUri.getHost(), (Object)BoxesRunTime.boxToInteger((int)originUri.getPort()));
        Tuple3 tuple32 = new Tuple3((Object)hostUri.getScheme(), (Object)hostUri.getHost(), (Object)BoxesRunTime.boxToInteger((int)hostUri.getPort()));
        return !(tuple3 != null ? !tuple3.equals(tuple32) : tuple32 != null);
    }

    public static /* synthetic */ Result $anonfun$filterRequest$1(Result result) {
        return result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{result.header().varyWith((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.ORIGIN()}))}));
    }

    public static /* synthetic */ boolean $anonfun$handlePreFlightCORSRequest$3(Function1 headerPredicate$1, String x$3) {
        return BoxesRunTime.unboxToBoolean((Object)headerPredicate$1.apply((Object)x$3));
    }

    public static void $init$(AbstractCORSPolicy $this) {
        $this.play$filters$cors$AbstractCORSPolicy$_setter_$play$filters$cors$AbstractCORSPolicy$$SupportedHttpMethods_$eq((Set<String>)((Set)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpVerbs$.MODULE$.GET(), HttpVerbs$.MODULE$.POST(), HttpVerbs$.MODULE$.PUT(), HttpVerbs$.MODULE$.PATCH(), HttpVerbs$.MODULE$.DELETE(), HttpVerbs$.MODULE$.HEAD(), HttpVerbs$.MODULE$.OPTIONS()}))));
    }
}

