/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.HydrologicalEventDao;
import events.HydrologicalEventInput;
import events.HydrologicalEventInput$;
import events.HydrologicalEventOutput$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.campaign.domain.input.CampaignInput$;
import fr.aquasys.daeau.hydrometry.domain.HydrologicalEvent;
import fr.aquasys.daeau.hydrometry.domain.HydrologicalEvent$;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.EventUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import station.MailDao;
import util.ErrorUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\t\u0013\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006Y!\b\u0005\tS\u0001\u0011\t\u0011)A\u0006U!AA\u0007\u0001B\u0001B\u0003-Q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015a\u0003>\u0011!\u0019\u0005A!A!\u0002\u0017!\u0005\"\u0002%\u0001\t\u0003I\u0005b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007]\u0002\u0001\u000b\u0011\u0002/\t\u000b=\u0004A\u0011\u00019\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002d\u0001!\t!!\u001a\u00037!KHM]8m_\u001eL7-\u00197Fm\u0016tGoQ8oiJ|G\u000e\\3s\u0015\u0005\u0019\u0012AB3wK:$8o\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-A\u0004m_\u001e,F/\u001b7\u0011\u0005y9S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001B;uS2T!AI\u0012\u0002\u0011I\f'MY5u[FT!\u0001J\u0013\u0002\u000f\u0005\fX/Y:zg*\ta%\u0001\u0002ge&\u0011\u0001f\b\u0002\b\u0019><W\u000b^5m\u0003I\u0019\u0018.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005-\u0012T\"\u0001\u0017\u000b\u00055r\u0013aA5uM*\u0011q\u0006M\u0001\u000fC\u0012l\u0017N\\5tiJ\fG/[8o\u0015\t\t4%A\u0003eC\u0016\fW/\u0003\u00024Y\t\u00112+[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p\u0003YA\u0017\u0010\u001a:pY><\u0017nY1m'R\fG/[8o\t\u0006|\u0007C\u0001\u001c;\u001b\u00059$BA\u00179\u0015\tI\u0004'\u0001\u0006is\u0012\u0014x.\\3uefL!aO\u001c\u0003-!KHM]8m_\u001eL7-\u00197Ti\u0006$\u0018n\u001c8EC>\fq!\\1jY\u0012\u000bw\u000e\u0005\u0002?\u00036\tqHC\u0001A\u0003\u001d\u0019H/\u0019;j_:L!AQ \u0003\u000f5\u000b\u0017\u000e\u001c#b_\u0006!\u0002.\u001f3s_2|w-[2bY\u00163XM\u001c;EC>\u0004\"!\u0012$\u000e\u0003II!a\u0012\n\u0003)!KHM]8m_\u001eL7-\u00197Fm\u0016tG\u000fR1p\u0003\u0019a\u0014N\\5u}Q\t!\n\u0006\u0004L\u00196su\n\u0015\t\u0003\u000b\u0002AQ\u0001\b\u0004A\u0004uAQ!\u000b\u0004A\u0004)BQ\u0001\u000e\u0004A\u0004UBQ\u0001\u0010\u0004A\u0004uBQa\u0011\u0004A\u0004\u0011C#A\u0002*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016AB5oU\u0016\u001cGOC\u0001X\u0003\u0015Q\u0017M^1y\u0013\tIFK\u0001\u0004J]*,7\r^\u0001\u0017Qf$'o\u001c7pO&\u001c\u0017\r\\#wK:$(+Z1egV\tA\fE\u0002^M\"l\u0011A\u0018\u0006\u0003?\u0002\fAA[:p]*\u0011\u0011MY\u0001\u0005Y&\u00147O\u0003\u0002dI\u0006\u0019\u0011\r]5\u000b\u0003\u0015\fA\u0001\u001d7bs&\u0011qM\u0018\u0002\u0006%\u0016\fGm\u001d\t\u0005/%\\7.\u0003\u0002k1\t1A+\u001e9mKJ\u0002\"a\u00067\n\u00055D\"A\u0002#pk\ndW-A\fis\u0012\u0014x\u000e\\8hS\u000e\fG.\u0012<f]R\u0014V-\u00193tA\u0005Iq-\u001a;Fm\u0016tGo\u001d\u000b\tcr\f\u0019!a\u0005\u0002\u0018A\u0011!/\u001f\b\u0003g^\u0004\"\u0001\u001e\r\u000e\u0003UT!A\u001e\u000b\u0002\rq\u0012xn\u001c;?\u0013\tA\b$\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=\u0019\u0011\u0015i\u0018\u00021\u0001\u007f\u0003\u001diWm]:bO\u0016\u0004\"!X@\n\u0007\u0005\u0005aLA\u0004KgZ\u000bG.^3\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b\u00059\u0001.Z1eKJ\u001c\bC\u0002:\u0002\nE\fi!C\u0002\u0002\fm\u00141!T1q!\r9\u0012qB\u0005\u0004\u0003#A\"aA!os\"1\u0011QC\u0005A\u0002E\fa!\\8ek2,\u0007BBA\r\u0013\u0001\u0007\u0011/\u0001\u0003vg\u0016\u0014\u0018\u0001D4fi\u0006cG.\u0012<f]R\u001cH#C9\u0002 \u0005\u0005\u00121EA\u0013\u0011\u0015i(\u00021\u0001\u007f\u0011\u001d\t)A\u0003a\u0001\u0003\u000fAa!!\u0006\u000b\u0001\u0004\t\bBBA\r\u0015\u0001\u0007\u0011/A\nhKR,e/\u001a8ug\nK8)Y7qC&<g\u000eF\u0005r\u0003W\ti#a\f\u00022!)Qp\u0003a\u0001}\"9\u0011QA\u0006A\u0002\u0005\u001d\u0001BBA\u000b\u0017\u0001\u0007\u0011\u000f\u0003\u0004\u0002\u001a-\u0001\r!]\u0001\tO\u0016$XI^3oiRI\u0011/a\u000e\u0002:\u0005m\u0012Q\b\u0005\u0006{2\u0001\rA \u0005\b\u0003\u000ba\u0001\u0019AA\u0004\u0011\u0019\t)\u0002\u0004a\u0001c\"1\u0011\u0011\u0004\u0007A\u0002E\f\u0001\"\u00193e\u000bZ,g\u000e\u001e\u000b\nc\u0006\r\u0013QIA$\u0003\u0013BQ!`\u0007A\u0002yDq!!\u0002\u000e\u0001\u0004\t9\u0001\u0003\u0004\u0002\u00165\u0001\r!\u001d\u0005\u0007\u00033i\u0001\u0019A9\u0002\u0017U\u0004H-\u0019;f\u000bZ,g\u000e\u001e\u000b\nc\u0006=\u0013\u0011KA*\u0003+BQ! \bA\u0002yDq!!\u0002\u000f\u0001\u0004\t9\u0001\u0003\u0004\u0002\u00169\u0001\r!\u001d\u0005\u0007\u00033q\u0001\u0019A9\u0002\u0017\u0011,G.\u001a;f\u000bZ,g\u000e\u001e\u000b\nc\u0006m\u0013QLA0\u0003CBQ!`\bA\u0002yDq!!\u0002\u0010\u0001\u0004\t9\u0001\u0003\u0004\u0002\u0016=\u0001\r!\u001d\u0005\u0007\u00033y\u0001\u0019A9\u0002\u0015M,g\u000e\u001a\"z\u001b\u0006LG\u000eF\u0005r\u0003O\nI'a\u001b\u0002n!)Q\u0010\u0005a\u0001}\"9\u0011Q\u0001\tA\u0002\u0005\u001d\u0001BBA\u000b!\u0001\u0007\u0011\u000f\u0003\u0004\u0002\u001aA\u0001\r!\u001d")
public class HydrologicalEventController {
    private final LogUtil logUtil;
    private final SieauParametersDao sieauParametersDao;
    private final HydrologicalStationDao hydrologicalStationDao;
    private final MailDao mailDao;
    private final HydrologicalEventDao hydrologicalEventDao;
    private final Reads<Tuple2<Object, Object>> hydrologicalEventReads;

    public Reads<Tuple2<Object, Object>> hydrologicalEventReads() {
        return this.hydrologicalEventReads;
    }

    public String getEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(36).append("Error validate Json to get Events :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> HydrologicalEventController.$anonfun$getEvents$2(this, BoxesRunTime.unboxToInt((Object)code)));
    }

    public String getAllEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.hydrologicalEventDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydrologicalEventOutput$.MODULE$.format())).toString();
    }

    public String getEventsByCampaign(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(53).append("Error validate Json to get Events by campaign code :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)id), (Object)user);
            double id2 = tuple22._1$mcD$sp();
            String user2 = (String)tuple22._2();
            $this.logUtil.info(new StringBuilder(52).append("Get Events for hydrological station by campaign code").append(id2).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson($this.hydrologicalEventDao.findByCampaign(id2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydrologicalEvent$.MODULE$.hydrologicalEventWrites())).toString();
        });
    }

    public String getEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydrologicalEventReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)codes -> {
            $this.logUtil.info(new StringBuilder(36).append("Get event ").append(codes._2$mcD$sp()).append(" for hydrological station ").append(codes._1$mcD$sp()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson($this.hydrologicalEventDao.find(codes._1$mcD$sp(), codes._2$mcD$sp()), Writes$.MODULE$.OptionWrites(HydrologicalEvent$.MODULE$.hydrologicalEventWrites())).toString();
        });
    }

    public String addEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(HydrologicalEventInput$.MODULE$.hydrologicalEventReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to add Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            HydrologicalEventInput eventInput = (HydrologicalEventInput)params._1();
            String user = (String)params._2();
            double id = $this.hydrologicalEventDao.insert(eventInput, user);
            $this.logUtil.info(new StringBuilder(44).append("Insert new event for hydrological station : ").append(eventInput.code()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eventId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
        });
    }

    public String updateEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(HydrologicalEvent$.MODULE$.hydrologicalEventUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to add Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            HydrologicalEvent event = (HydrologicalEvent)params._1();
            String user = (String)params._2();
            Option<HydrologicalEvent> option = $this.hydrologicalEventDao.find(event.code(), event.number());
            if (option instanceof Some) {
                $this.hydrologicalEventDao.update(event, user);
                $this.logUtil.info(new StringBuilder(31).append("Update event ").append(event.number()).append(" for piezometer : ").append(event.code()).toString(), $this.logUtil.info$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                $this.logUtil.error(new StringBuilder(66).append("Can't update event cause not found event ").append(event.number()).append(" on hydrological station ").append(event.code()).toString(), $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        });
    }

    public String deleteEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydrologicalEventReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get installation id or event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double stationId = tuple2._1$mcD$sp();
            double eventId = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(stationId, eventId);
            double stationId2 = sp2._1$mcD$sp();
            double eventId2 = sp2._2$mcD$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.hydrologicalEventDao.delete(stationId2, eventId2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String sendByMail(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EventUtil$.MODULE$.eventIdAndStationIdAndEmailRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to send Event by mail :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int eventId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int stationId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Seq emails = (Seq)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)eventId), (Object)BoxesRunTime.boxToInteger((int)stationId), (Object)emails);
            int eventId2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int stationId2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Seq emails2 = (Seq)tuple32._3();
            Option<HydrologicalEvent> option = $this.hydrologicalEventDao.find(stationId2, eventId2);
            if (option instanceof Some) {
                Some some = (Some)option;
                HydrologicalEvent event = (HydrologicalEvent)some.value();
                Option option2 = $this.hydrologicalStationDao.get((double)stationId2);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    HydroStation piezo = (HydroStation)some2.value();
                    Seq parameters = $this.sieauParametersDao.getAll($this.sieauParametersDao.getAll$default$1(), $this.sieauParametersDao.getAll$default$2());
                    emails2.foreach((Function1 & Serializable)email -> {
                        this.mailDao.sendMail(email, event, piezo, (Seq<SieauParameters>)parameters);
                        return BoxedUnit.UNIT;
                    });
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                $this.logUtil.debug(new StringBuilder(23).append("Error hydro: ").append(stationId2).append(" not found").toString(), $this.logUtil.debug$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.debug(new StringBuilder(35).append("Error event: ").append(eventId2).append(" not found for hydro: ").append(stationId2).toString(), $this.logUtil.debug$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getEvents$2(HydrologicalEventController $this, int code) {
        $this.logUtil.info(new StringBuilder(26).append("Get Events for piezometer ").append(code).toString(), $this.logUtil.info$default$2());
        return Json$.MODULE$.toJson($this.hydrologicalEventDao.find(code), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydrologicalEvent$.MODULE$.hydrologicalEventWrites())).toString();
    }

    @Inject
    public HydrologicalEventController(LogUtil logUtil, SieauParametersDao sieauParametersDao, HydrologicalStationDao hydrologicalStationDao, MailDao mailDao, HydrologicalEventDao hydrologicalEventDao) {
        this.logUtil = logUtil;
        this.sieauParametersDao = sieauParametersDao;
        this.hydrologicalStationDao = hydrologicalStationDao;
        this.mailDao = mailDao;
        this.hydrologicalEventDao = hydrologicalEventDao;
        this.hydrologicalEventReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("hydrologicalStationId").read((Reads)Reads$.MODULE$.DoubleReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("eventId").read((Reads)Reads$.MODULE$.DoubleReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

