/*
 * Decompiled with CFR 0.152.
 */
package measures;

import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicMeasure;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicMeasure$;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicMeasureInput;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicMeasureInput$;
import fr.aquasys.daeau.hydrometry.domain.HydrometryMeasures$;
import fr.aquasys.daeau.piezometry.model.measure.DataTypeStatistics$;
import fr.aquasys.daeau.station.domain.MeasuresParams;
import fr.aquasys.daeau.station.domain.MeasuresParams$;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.DateTimeFormatUtil$;
import fr.aquasys.utils.HydrometryUtils$;
import fr.aquasys.utils.StringUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import measures.ChronicHydroSpecificDao;
import measures.HydroChartMeasure;
import measures.HydroMeasuresInput$;
import measures.HydrometerValidationMeasuresInput$;
import measures.HydrosMeasuresInput;
import measures.HydrosMeasuresInput$;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t-b\u0001B\u000f\u001f\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006Y!\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0006m!A\u0001\t\u0001B\u0001B\u0003-\u0011\t\u0003\u0005J\u0001\t\u0005\t\u0015a\u0003K\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\"\u0002,\u0001\t\u00039\u0006b\u00025\u0001\u0005\u0004%\t!\u001b\u0005\b\u0003C\u0001\u0001\u0015!\u0003k\u0011%\t\u0019\u0003\u0001b\u0001\n\u0003\t)\u0003\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0014\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\tI\u000b\u0001C\u0001\u0003WC\u0011\"!.\u0001\u0005\u0004%\t!a.\t\u0011\u0005=\u0007\u0001)A\u0005\u0003sCq!!5\u0001\t\u0003\t\u0019\u000eC\u0005\u0002^\u0002\u0011\r\u0011\"\u0001\u0002`\"A\u00111 \u0001!\u0002\u0013\t\t\u000fC\u0004\u0002~\u0002!\t!a@\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!I!Q\u0003\u0001C\u0002\u0013\u0005!q\u0003\u0005\t\u0005;\u0001\u0001\u0015!\u0003\u0003\u001a!9!q\u0004\u0001\u0005\u0002\t\u0005\"A\u0006%zIJ|7\t\u001b:p]&\u001c7i\u001c8ue>dG.\u001a:\u000b\u0003}\t\u0001\"\\3bgV\u0014Xm]\u0002\u0001'\t\u0001!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\tQ3'D\u0001,\u0015\taS&\u0001\u0003vi&d'B\u0001\u00180\u0003!\u0011\u0018M\u00192ji6\f(B\u0001\u00192\u0003\u001d\t\u0017/^1tsNT\u0011AM\u0001\u0003MJL!\u0001N\u0016\u0003\u000f1{w-\u0016;jY\u0006y\u0001*\u001f3s_\u000eC'o\u001c8jG\u0012\u000bw\u000e\u0005\u00028}5\t\u0001H\u0003\u0002:u\u000591\r\u001b:p]&\u001c'BA\u001e=\u0003)A\u0017\u0010\u001a:p[\u0016$(/\u001f\u0006\u0003{=\nQ\u0001Z1fCVL!a\u0010\u001d\u0003\u001f!KHM]8DQJ|g.[2EC>\f1c\u001d;bi&|g\u000e\u00165sKNDw\u000e\u001c3EC>\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u0007%$hM\u0003\u0002Gy\u000591\u000f^1uS>t\u0017B\u0001%D\u0005M\u0019F/\u0019;j_:$\u0006N]3tQ>dG\rR1p\u0003I\u0019\u0016.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005-{U\"\u0001'\u000b\u0005\u0011k%B\u0001(=\u00039\tG-\\5oSN$(/\u0019;j_:L!\u0001\u0015'\u0003%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\\\u0001\u0010\u0007\"\u0014xN\\5d\u0011f$'o\u001c#b_B\u00111\u000bV\u0007\u0002=%\u0011QK\b\u0002\u0018\u0007\"\u0014xN\\5d\u0011f$'o\\*qK\u000eLg-[2EC>\fa\u0001P5oSRtD#\u0001-\u0015\reS6\fX/_!\t\u0019\u0006\u0001C\u0003)\r\u0001\u000f\u0011\u0006C\u00036\r\u0001\u000fa\u0007C\u0003A\r\u0001\u000f\u0011\tC\u0003J\r\u0001\u000f!\nC\u0003R\r\u0001\u000f!\u000b\u000b\u0002\u0007AB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0007S:TWm\u0019;\u000b\u0003\u0015\fQA[1wCbL!a\u001a2\u0003\r%s'.Z2u\u0003}A\u0017\u0010\u001a:pY><\u0017nY1m'R\fG/[8o\u001b\u0016\f7/\u001e:f%\u0016\fGm]\u000b\u0002UB\u00191\u000e\u001e<\u000e\u00031T!!\u001c8\u0002\t)\u001cxN\u001c\u0006\u0003_B\fA\u0001\\5cg*\u0011\u0011O]\u0001\u0004CBL'\"A:\u0002\tAd\u0017-_\u0005\u0003k2\u0014QAU3bIN\u0004RaI<z\u0003\u0013I!\u0001\u001f\u0013\u0003\rQ+\b\u000f\\33!\rQ\u00181\u0001\b\u0003w~\u0004\"\u0001 \u0013\u000e\u0003uT!A \u0011\u0002\rq\u0012xn\u001c;?\u0013\r\t\t\u0001J\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005A\u0005\u0005\u0004\u0002\f\u0005U\u00111\u0004\b\u0005\u0003\u001b\t\tBD\u0002}\u0003\u001fI\u0011!J\u0005\u0004\u0003'!\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIBA\u0002TKFT1!a\u0005%!\r9\u0014QD\u0005\u0004\u0003?A$\u0001\u0007%zIJ|7\t\u001b:p]&\u001cW*Z1tkJ,\u0017J\u001c9vi\u0006\u0001\u0003.\u001f3s_2|w-[2bYN#\u0018\r^5p]6+\u0017m];sKJ+\u0017\rZ:!\u0003eA\u0017\u0010\u001a:pY><\u0017nY1m\u0007\",7m\u001b#bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u001d\u0002\u0003B6u\u0003S\u0001RaI<\u0002,e\u00042aIA\u0017\u0013\r\ty\u0003\n\u0002\u0004\u0013:$\u0018A\u00075zIJ|Gn\\4jG\u0006d7\t[3dW\u0012\u000bG/\u0019+za\u0016\u0004\u0013aC4fi6+\u0017m];sKN$\u0012\"_A\u001c\u0003\u0003\n\t&!\u0016\t\u000f\u0005e2\u00021\u0001\u0002<\u00059Q.Z:tC\u001e,\u0007cA6\u0002>%\u0019\u0011q\b7\u0003\u000f)\u001bh+\u00197vK\"9\u00111I\u0006A\u0002\u0005\u0015\u0013a\u00025fC\u0012,'o\u001d\t\u0007u\u0006\u001d\u00130a\u0013\n\t\u0005%\u0013q\u0001\u0002\u0004\u001b\u0006\u0004\bcA\u0012\u0002N%\u0019\u0011q\n\u0013\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002T-\u0001\r!_\u0001\u0007[>$W\u000f\\3\t\r\u0005]3\u00021\u0001z\u0003\u0011)8/\u001a:\u0002-\u001d,G\u000fS=ee>lW\r^3sg6+\u0017m];sKN$\u0012\"_A/\u0003?\n\t'a\u0019\t\u000f\u0005eB\u00021\u0001\u0002<!9\u00111\t\u0007A\u0002\u0005\u0015\u0003BBA*\u0019\u0001\u0007\u0011\u0010\u0003\u0004\u0002X1\u0001\r!_\u0001\u000fi>\u001c\u0005.\u0019:u\u001b\u0016\f7/\u001e:f)\u0011\tI'a\u001c\u0011\u0007M\u000bY'C\u0002\u0002ny\u0011\u0011\u0003S=ee>\u001c\u0005.\u0019:u\u001b\u0016\f7/\u001e:f\u0011\u001d\t\t(\u0004a\u0001\u0003g\nq!\\3bgV\u0014X\rE\u00028\u0003kJ1!a\u001e9\u0005MA\u0015\u0010\u001a:p\u0007\"\u0014xN\\5d\u001b\u0016\f7/\u001e:f\u0003A9W\r^'fCN,(/Z:Ti\u0006$8\u000fF\u0005z\u0003{\ny(!!\u0002\u0004\"9\u0011\u0011\b\bA\u0002\u0005m\u0002bBA\"\u001d\u0001\u0007\u0011Q\t\u0005\u0007\u0003'r\u0001\u0019A=\t\r\u0005]c\u00021\u0001z\u0003M\tG\rZ(s+B$\u0017\r^3NK\u0006\u001cXO]3t)%I\u0018\u0011RAF\u0003\u001b\u000by\tC\u0004\u0002:=\u0001\r!a\u000f\t\u000f\u0005\rs\u00021\u0001\u0002F!1\u00111K\bA\u0002eDa!a\u0016\u0010\u0001\u0004I\u0018A\u00079ve\u001e,\u0007*\u001f3s_6,G/\u001a:BY2lU-Y:ve\u0016\u001cH#C=\u0002\u0016\u0006]\u0015\u0011TAN\u0011\u001d\tI\u0004\u0005a\u0001\u0003wAq!a\u0011\u0011\u0001\u0004\t)\u0005\u0003\u0004\u0002TA\u0001\r!\u001f\u0005\u0007\u0003/\u0002\u0002\u0019A=\u00027\u0011,G.\u001a;f\u0011f$'o\\7fi\u0016\u0014\u0018\t\u001c7NK\u0006\u001cXO]3t)%I\u0018\u0011UAR\u0003K\u000b9\u000bC\u0004\u0002:E\u0001\r!a\u000f\t\u000f\u0005\r\u0013\u00031\u0001\u0002F!1\u00111K\tA\u0002eDa!a\u0016\u0012\u0001\u0004I\u0018A\u0007:fg\u0016$\b*\u001f3s_6,G/\u001a:BY2lU-Y:ve\u0016\u001cH#C=\u0002.\u0006=\u0016\u0011WAZ\u0011\u001d\tID\u0005a\u0001\u0003wAq!a\u0011\u0013\u0001\u0004\t)\u0005\u0003\u0004\u0002TI\u0001\r!\u001f\u0005\u0007\u0003/\u0012\u0002\u0019A=\u0002+!LHM]8MCN$X*Z1tkJ,7OU3bIV\u0011\u0011\u0011\u0018\t\u0005WR\fY\fE\u0005$\u0003{\u000b\t-a\u000b\u0002D&\u0019\u0011q\u0018\u0013\u0003\rQ+\b\u000f\\34!\u0019\tY!!\u0006\u0002,A)1%!2\u0002J&\u0019\u0011q\u0019\u0013\u0003\r=\u0003H/[8o!\r\u0019\u00131Z\u0005\u0004\u0003\u001b$#a\u0002\"p_2,\u0017M\\\u0001\u0017Qf$'o\u001c'bgRlU-Y:ve\u0016\u001c(+Z1eA\u0005yq-\u001a;MCN$X*Z1tkJ,7\u000fF\u0005z\u0003+\f9.!7\u0002\\\"9\u0011\u0011H\u000bA\u0002\u0005m\u0002bBA\"+\u0001\u0007\u0011Q\t\u0005\u0007\u0003'*\u0002\u0019A=\t\r\u0005]S\u00031\u0001z\u00039IGm]!oI\u0012\u000bG/\u001a*fC\u0012,\"!!9\u0011\t-$\u00181\u001d\t\u0007G]\f\t-!:\u0011\u000b\r\n)-a:\u0011\t\u0005%\u0018q_\u0007\u0003\u0003WTA!!<\u0002p\u0006!A/[7f\u0015\u0011\t\t0a=\u0002\t)|G-\u0019\u0006\u0003\u0003k\f1a\u001c:h\u0013\u0011\tI0a;\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\fq\"\u001b3t\u0003:$G)\u0019;f%\u0016\fG\rI\u0001\u0019O\u0016$8+\u001b;vCRLwN\u001c'bgRlU-Y:ve\u0016\u001cH#C=\u0003\u0002\t\r!Q\u0001B\u0004\u0011\u001d\tI\u0004\u0007a\u0001\u0003wAq!a\u0011\u0019\u0001\u0004\t)\u0005\u0003\u0004\u0002Ta\u0001\r!\u001f\u0005\u0007\u0003/B\u0002\u0019A=\u0002!\u001d,Go\u00115fG.$\u0015\r^1UsB,G#C=\u0003\u000e\t=!\u0011\u0003B\n\u0011\u001d\tI$\u0007a\u0001\u0003wAq!a\u0011\u001a\u0001\u0004\t)\u0005\u0003\u0004\u0002Te\u0001\r!\u001f\u0005\u0007\u0003/J\u0002\u0019A=\u0002)!LHM]8JI>\u001b7-\u001e:f]\u000e,'+Z1e+\t\u0011I\u0002\u0005\u0003li\nm\u0001\u0003C\u0012\u0002>\u0006-\u00120a\u000b\u0002+!LHM]8JI>\u001b7-\u001e:f]\u000e,'+Z1eA\u00051r-\u001a;Is\u0012\u0014x\u000eT5oW\u0016$W*Z1tkJ,7\u000fF\u0005z\u0005G\u0011)Ca\n\u0003*!9\u0011\u0011\b\u000fA\u0002\u0005m\u0002bBA\"9\u0001\u0007\u0011Q\t\u0005\u0007\u0003'b\u0002\u0019A=\t\r\u0005]C\u00041\u0001z\u0001")
public class HydroChronicController {
    private final LogUtil logUtil;
    private final HydroChronicDao HydroChronicDao;
    private final SieauParametersDao SieauParametersDao;
    private final ChronicHydroSpecificDao ChronicHydroDao;
    private final Reads<Tuple2<String, Seq<HydroChronicMeasureInput>>> hydrologicalStationMeasureReads;
    private final Reads<Tuple2<Object, String>> hydrologicalCheckDataType;
    private final Reads<Tuple3<Seq<Object>, Object, Option<Object>>> hydroLastMeasuresRead;
    private final Reads<Tuple2<Seq<Object>, Option<DateTime>>> idsAndDateRead;
    private final Reads<Tuple3<Object, String, Object>> hydroIdOccurenceRead;

    public Reads<Tuple2<String, Seq<HydroChronicMeasureInput>>> hydrologicalStationMeasureReads() {
        return this.hydrologicalStationMeasureReads;
    }

    public Reads<Tuple2<Object, String>> hydrologicalCheckDataType() {
        return this.hydrologicalCheckDataType;
    }

    public String getMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(HydroMeasuresInput$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(43).append("Error while reading hydro measures input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            int x$1 = input.stationId();
            int x$2 = input.dataType();
            Option<DateTime> x$3 = input.startDate();
            Option<DateTime> x$4 = input.endDate();
            Option<Object> x$5 = input.validOnly();
            Option<List<Object>> x$6 = input.status();
            Option<List<Object>> x$7 = input.qualifications();
            Option<String> x$8 = input.groupFunc();
            Option<DateTime> x$9 = input.calculationStartDate();
            Option<DateTime> x$10 = input.calculationEndDate();
            Option<DateTime> x$11 = input.startEnveloppe();
            Option<DateTime> x$12 = input.endEnveloppe();
            Option<Object> x$13 = input.codepoint();
            Option<Object> x$14 = input.distinctByCodePoint();
            String x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
            Seq x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
            Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
            Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
            Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
            Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
            Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
            Option x$22 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
            Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
            Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
            Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
            Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
            Seq measures = HydrometryUtils$.MODULE$.getHydroMeasures(new MeasuresParams(x$15, x$1, x$16, x$2, x$17, x$3, x$4, x$5, x$7, x$6, x$8, x$18, x$19, x$9, x$10, x$20, x$21, x$13, x$14, x$22, x$11, x$12, x$23, x$24, x$25, x$26), $this.HydroChronicDao, $this.SieauParametersDao);
            if (input.chartMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)measures.map((Function1 & Serializable)m -> StringUtil$.MODULE$.stringify(this.toChartMeasure((HydroChronicMeasure)m).toLight()))).mkString(",")).append("]").toString();
            }
            return new StringBuilder(2).append("[").append(((IterableOnceOps)measures.map((Function1 & Serializable)m -> StringUtil$.MODULE$.stringify(m.toLight()))).mkString(",")).append("]").toString();
        });
    }

    public String getHydrometersMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(HydrosMeasuresInput$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(43).append("Error while reading hydro measures input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Seq measures = (Seq)input.stationIds().flatMap((Function1 & Serializable)stationId -> HydroChronicController.$anonfun$getHydrometersMeasures$3(this, input, BoxesRunTime.unboxToInt((Object)stationId)));
            if (input.chartMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)measures.map((Function1 & Serializable)m -> StringUtil$.MODULE$.stringify(this.toChartMeasure((HydroChronicMeasure)m).toLight()))).mkString(",")).append("]").toString();
            }
            return new StringBuilder(2).append("[").append(((IterableOnceOps)measures.map((Function1 & Serializable)m -> StringUtil$.MODULE$.stringify(m.toLight()))).mkString(",")).append("]").toString();
        });
    }

    private HydroChartMeasure toChartMeasure(HydroChronicMeasure measure) {
        DateTime x$1 = measure.date();
        Option x$2 = measure.value();
        Option x$3 = measure.status();
        Option x$4 = measure.qualification();
        Option x$5 = measure.initialPoint();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)measure.hydroId()));
        int x$7 = measure.codepoint();
        return new HydroChartMeasure((Option<Object>)x$6, x$1, (Option<Object>)x$2, x$7, (Option<Object>)x$3, (Option<Object>)x$4, (Option<Object>)x$5);
    }

    public String getMeasuresStats(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(32).append("Error while reading pluvio id : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)id -> HydroChronicController.$anonfun$getMeasuresStats$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String addOrUpdateMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydrologicalStationMeasureReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error("Error validate Json to get Hydrological measure :\n", $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            Seq hydroChronicMeasures = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)hydroChronicMeasures);
            String user2 = (String)tuple22._1();
            Seq hydroChronicMeasures2 = (Seq)tuple22._2();
            Tuple2 tuple23 = $this.HydroChronicDao.updateMeasures(hydroChronicMeasures2, user2);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int insert = tuple23._1$mcI$sp();
            int update = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(insert, update);
            int insert2 = sp2._1$mcI$sp();
            int update2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)update2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)insert2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String purgeHydrometerAllMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(HydrometerValidationMeasuresInput$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(71).append("Error validate Json to get bss or dates input for raw measures purge :\n").append(message.toString()).append(JsError$.MODULE$.toJson(error).toString()).append(message.toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)input -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.HydroChronicDao.purgeMeasures(input.id(), input.startDate(), input.endDate(), input.dataType(), input.codepoint(), input.selectFilters())), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String deleteHydrometerAllMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)HydroChronicMeasureInput$.MODULE$.format())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(72).append("Error validate Json to get bss or dates input for raw measures delete :\n").append(message.toString()).append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)measures -> {
            int delete = $this.HydroChronicDao.deleteMeasures(measures);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)delete), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String resetHydrometerAllMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(HydrometerValidationMeasuresInput$.MODULE$.format()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(71).append("Error validate Json to get bss or dates input for raw measures reset :\n").append(message.toString()).append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)input -> {
            int insert = $this.HydroChronicDao.resetMeasures(input.id(), input.startDate(), input.endDate(), input.dataType(), input.codepoint(), input.user(), input.selectFilters());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)insert), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple3<Seq<Object>, Object, Option<Object>>> hydroLastMeasuresRead() {
        return this.hydroLastMeasuresRead;
    }

    public String getLastMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydroLastMeasuresRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't read hydro ids list : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Seq ids = (Seq)tuple3._1();
            int dataType = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Option validOnly = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)ids, (Object)BoxesRunTime.boxToInteger((int)dataType), (Object)validOnly);
            Seq ids2 = (Seq)tuple32._1();
            int dataType2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option validOnly2 = (Option)tuple32._3();
            return Json$.MODULE$.toJson(ids2.flatMap((Function1 & Serializable)id -> this.HydroChronicDao.getLastMeasure(BoxesRunTime.unboxToInt((Object)id), dataType2, (Option)None$.MODULE$, (Option)None$.MODULE$, validOnly2, this.HydroChronicDao.getLastMeasure$default$6())), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)HydroChronicMeasure$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple2<Seq<Object>, Option<DateTime>>> idsAndDateRead() {
        return this.idsAndDateRead;
    }

    public String getSituationLastMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idsAndDateRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't read hydro ids list : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> {
            Seq<HydroChronicMeasure> result = $this.ChronicHydroDao.getLastMeasures((Seq<Object>)((Seq)read._1()), (Option<DateTime>)((Option)read._2()));
            return Json$.MODULE$.toJson(result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)HydroChronicMeasure$.MODULE$.format())).toString();
        });
    }

    public String getCheckDataType(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydrologicalCheckDataType()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(32).append("Error while reading pluvio id : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)read -> Json$.MODULE$.toJson((Object)BoxesRunTime.boxToBoolean((boolean)$this.ChronicHydroDao.getCheckDataType(read._1$mcI$sp())), (Writes)Writes$.MODULE$.BooleanWrites()).toString());
    }

    public Reads<Tuple3<Object, String, Object>> hydroIdOccurenceRead() {
        return this.hydroIdOccurenceRead;
    }

    public String getHydroLinkedMeasures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.hydroIdOccurenceRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(61).append("Error validate Json to get id or occurence or nb occurence :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)param -> {
            Tuple3 tuple3 = param;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int id = BoxesRunTime.unboxToInt((Object)tuple3._1());
            String occurence = (String)tuple3._2();
            int nbOccurence = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)id), (Object)occurence, (Object)BoxesRunTime.boxToInteger((int)nbOccurence));
            int id2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            String occurence2 = (String)tuple32._2();
            int nbOccurence2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Seq result = $this.HydroChronicDao.getHydroLinkedMeasures(id2, occurence2, nbOccurence2);
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)HydrometryMeasures$.MODULE$.format())).toString();
        });
    }

    public static final /* synthetic */ Seq $anonfun$getHydrometersMeasures$3(HydroChronicController $this, HydrosMeasuresInput input$1, int stationId) {
        int x$1 = stationId;
        int x$2 = input$1.dataType();
        Option<DateTime> x$3 = input$1.startDate();
        Option<DateTime> x$4 = input$1.endDate();
        Option<Object> x$5 = input$1.validOnly();
        Option<String> x$6 = input$1.groupFunc();
        Option<DateTime> x$7 = input$1.startEnveloppe();
        Option<DateTime> x$8 = input$1.endEnveloppe();
        Option<Object> x$9 = input$1.codepoint();
        Option<Object> x$10 = input$1.distinctByCodePoint();
        String x$11 = MeasuresParams$.MODULE$.$lessinit$greater$default$1();
        Seq x$12 = MeasuresParams$.MODULE$.$lessinit$greater$default$3();
        Option x$13 = MeasuresParams$.MODULE$.$lessinit$greater$default$5();
        Option x$14 = MeasuresParams$.MODULE$.$lessinit$greater$default$9();
        Option x$15 = MeasuresParams$.MODULE$.$lessinit$greater$default$10();
        Option x$16 = MeasuresParams$.MODULE$.$lessinit$greater$default$12();
        Option x$17 = MeasuresParams$.MODULE$.$lessinit$greater$default$13();
        Option x$18 = MeasuresParams$.MODULE$.$lessinit$greater$default$14();
        Option x$19 = MeasuresParams$.MODULE$.$lessinit$greater$default$15();
        Option x$20 = MeasuresParams$.MODULE$.$lessinit$greater$default$16();
        Option x$21 = MeasuresParams$.MODULE$.$lessinit$greater$default$17();
        Option x$22 = MeasuresParams$.MODULE$.$lessinit$greater$default$20();
        Option x$23 = MeasuresParams$.MODULE$.$lessinit$greater$default$23();
        Option x$24 = MeasuresParams$.MODULE$.$lessinit$greater$default$24();
        Option x$25 = MeasuresParams$.MODULE$.$lessinit$greater$default$25();
        Option x$26 = MeasuresParams$.MODULE$.$lessinit$greater$default$26();
        return HydrometryUtils$.MODULE$.getHydroMeasures(new MeasuresParams(x$11, x$1, x$12, x$2, x$13, x$3, x$4, x$5, x$14, x$15, x$6, x$16, x$17, x$18, x$19, x$20, x$21, x$9, x$10, x$22, x$7, x$8, x$23, x$24, x$25, x$26), $this.HydroChronicDao, $this.SieauParametersDao);
    }

    public static final /* synthetic */ String $anonfun$getMeasuresStats$2(HydroChronicController $this, int id) {
        return Json$.MODULE$.toJson((Object)$this.HydroChronicDao.getMeasuresStats(id), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)DataTypeStatistics$.MODULE$.format())).toString();
    }

    @Inject
    public HydroChronicController(LogUtil logUtil, HydroChronicDao HydroChronicDao2, StationThresholdDao stationThresholdDao, SieauParametersDao SieauParametersDao2, ChronicHydroSpecificDao ChronicHydroDao) {
        this.logUtil = logUtil;
        this.HydroChronicDao = HydroChronicDao2;
        this.SieauParametersDao = SieauParametersDao2;
        this.ChronicHydroDao = ChronicHydroDao;
        this.hydrologicalStationMeasureReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("hydroChronicMeasure").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)HydroChronicMeasureInput$.MODULE$.format()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.hydrologicalCheckDataType = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.hydroLastMeasuresRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("dataType").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("validOnly").readNullable((Reads)Reads$.MODULE$.BooleanReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.idsAndDateRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("date").readNullable((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.hydroIdOccurenceRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("occurence").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("nbOccurence").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

