/*
 * Decompiled with CFR 0.152.
 */
package situation;

import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateTimeFormatUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import model.KeyFigure$;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import situation.HydroMeasuresSituation;
import situation.HydroMeasuresSituation$;
import situation.HydroSituation;
import situation.HydroSituation$;
import situation.HydroSituationDays;
import situation.HydroSituationDays$;
import situation.SituationDao;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\t\u0012\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006Y\u0001\b\u0005\tQ\u0001\u0011\t\u0011)A\u0006S!AQ\u0006\u0001B\u0001B\u0003-a\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u0003I\u0001\u0011\u0005\u0011\nC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004v\u0001\t\u0007I\u0011\u0001<\t\u000f\u0005\u001d\u0002\u0001)A\u0005o\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002\"CA\u001b\u0001\t\u0007I\u0011AA\u001c\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005e\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\n\u0003#\u0002!\u0019!C\u0001\u0003'B\u0001\"!\u0018\u0001A\u0003%\u0011Q\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0005M\u0019\u0016\u000e^;bi&|gnQ8oiJ|G\u000e\\3s\u0015\u0005\u0011\u0012!C:jiV\fG/[8o\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"!\b\u0014\u000e\u0003yQ!a\b\u0011\u0002\tU$\u0018\u000e\u001c\u0006\u0003C\t\n\u0001B]1cE&$X.\u001d\u0006\u0003G\u0011\nq!Y9vCNL8OC\u0001&\u0003\t1'/\u0003\u0002(=\t9Aj\\4Vi&d\u0017\u0001D:jiV\fG/[8o\t\u0006|\u0007C\u0001\u0016,\u001b\u0005\t\u0012B\u0001\u0017\u0012\u00051\u0019\u0016\u000e^;bi&|g\u000eR1p\u0003M\u0019H/\u0019;j_:$\u0006N]3tQ>dG\rR1p!\tyc'D\u00011\u0015\t\t$'A\u0002ji\u001aT!a\r\u001b\u0002\u000fM$\u0018\r^5p]*\u0011QGI\u0001\u0006I\u0006,\u0017-^\u0005\u0003oA\u00121c\u0015;bi&|g\u000e\u00165sKNDw\u000e\u001c3EC>\fa\u0001P5oSRtD#\u0001\u001e\u0015\tmbTH\u0010\t\u0003U\u0001AQa\u0007\u0003A\u0004qAQ\u0001\u000b\u0003A\u0004%BQ!\f\u0003A\u00049B#\u0001\u0002!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015AB5oU\u0016\u001cGOC\u0001F\u0003\u0015Q\u0017M^1y\u0013\t9%I\u0001\u0004J]*,7\r^\u0001\u000eO\u0016$8*Z=GS\u001e,(/Z:\u0015\u000b)+6m[7\u0011\u0005-\u0013fB\u0001'Q!\tiu#D\u0001O\u0015\ty5#\u0001\u0004=e>|GOP\u0005\u0003#^\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011k\u0006\u0005\u0006-\u0016\u0001\raV\u0001\b[\u0016\u001c8/Y4f!\tA\u0016-D\u0001Z\u0015\tQ6,\u0001\u0003kg>t'B\u0001/^\u0003\u0011a\u0017NY:\u000b\u0005y{\u0016aA1qS*\t\u0001-\u0001\u0003qY\u0006L\u0018B\u00012Z\u0005\u001dQ5OV1mk\u0016DQ\u0001Z\u0003A\u0002\u0015\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003LM*C\u0017BA4U\u0005\ri\u0015\r\u001d\t\u0003-%L!A[\f\u0003\u0007\u0005s\u0017\u0010C\u0003m\u000b\u0001\u0007!*\u0001\u0004n_\u0012,H.\u001a\u0005\u0006]\u0016\u0001\rAS\u0001\u0005kN,'/\u0001\u000bhKR\u001cu.\u001e8u\u001f\n\u001cXM\u001d<bi&|gn\u001d\u000b\u0006\u0015F\u00148\u000f\u001e\u0005\u0006-\u001a\u0001\ra\u0016\u0005\u0006I\u001a\u0001\r!\u001a\u0005\u0006Y\u001a\u0001\rA\u0013\u0005\u0006]\u001a\u0001\rAS\u0001\u000eg&$X/\u0019;j_:\u0014V-\u00193\u0016\u0003]\u00042\u0001\u0017={\u0013\tI\u0018LA\u0003SK\u0006$7\u000f\u0005\u0005\u0017wvT\u0015qBA\u0011\u0013\taxC\u0001\u0004UkBdW\r\u000e\t\u0004}\u0006-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005i&lWM\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00026pI\u0006T!!!\u0003\u0002\u0007=\u0014x-C\u0002\u0002\u000e}\u0014\u0001\u0002R1uKRKW.\u001a\t\u0007\u0003#\tY\"!\t\u000f\t\u0005M\u0011q\u0003\b\u0004\u001b\u0006U\u0011\"\u0001\r\n\u0007\u0005eq#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0011q\u0004\u0002\u0004'\u0016\f(bAA\r/A\u0019a#a\t\n\u0007\u0005\u0015rCA\u0002J]R\fab]5uk\u0006$\u0018n\u001c8SK\u0006$\u0007%A\thKRD\u0015\u0010\u001a:p'&$X/\u0019;j_:$\u0012BSA\u0017\u0003_\t\t$a\r\t\u000bYK\u0001\u0019A,\t\u000b\u0011L\u0001\u0019A3\t\u000b1L\u0001\u0019\u0001&\t\u000b9L\u0001\u0019\u0001&\u0002\u00171|gnZ%egJ+\u0017\rZ\u000b\u0003\u0003s\u0001B\u0001\u0017=\u0002<A1\u0011\u0011CA\u000e\u0003{\u00012AFA \u0013\r\t\te\u0006\u0002\u0005\u0019>tw-\u0001\u0007m_:<\u0017\nZ:SK\u0006$\u0007%A\fhKRD\u0015\u0010\u001a:p[\u0016$XM]:TSR,\u0018\r^5p]RI!*!\u0013\u0002L\u00055\u0013q\n\u0005\u0006-2\u0001\ra\u0016\u0005\u0006I2\u0001\r!\u001a\u0005\u0006Y2\u0001\rA\u0013\u0005\u0006]2\u0001\rAS\u0001\u0012g&$X/\u0019;j_:$\u0015-_:SK\u0006$WCAA+!\u0011A\u00060a\u0016\u0011\u0017Y\tI&`A\u0011\u0015\u0006=\u0011\u0011E\u0005\u0004\u00037:\"A\u0002+va2,W'\u0001\ntSR,\u0018\r^5p]\u0012\u000b\u0017p\u001d*fC\u0012\u0004\u0013\u0001F4fi\"KHM]8ECf\u001c\u0016\u000e^;bi&|g\u000eF\u0005K\u0003G\n)'a\u001a\u0002j!)ak\u0004a\u0001/\")Am\u0004a\u0001K\")An\u0004a\u0001\u0015\")an\u0004a\u0001\u0015\u0002")
public class SituationController {
    private final LogUtil logUtil;
    private final SituationDao situationDao;
    private final StationThresholdDao stationThresholdDao;
    private final Reads<Tuple4<DateTime, String, Seq<Object>, Object>> situationRead;
    private final Reads<Seq<Object>> longIdsRead;
    private final Reads<Tuple5<DateTime, Object, String, Seq<Object>, Object>> situationDaysRead;

    public String getKeyFigures(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.situationDao.getKeyFigures(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), KeyFigure$.MODULE$.normaleOutputWrites())).toString();
    }

    public String getCountObservations(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.situationDao.getCountObservations(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), KeyFigure$.MODULE$.normaleOutputWrites())).toString();
    }

    public Reads<Tuple4<DateTime, String, Seq<Object>, Object>> situationRead() {
        return this.situationRead;
    }

    public String getHydroSituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.situationRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(29).append("Can't read hydro situation : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)params -> {
            Tuple4 tuple4 = params;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            DateTime date = (DateTime)tuple4._1();
            Seq hydrometersIds = (Seq)tuple4._3();
            int dataType = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple3 tuple3 = new Tuple3((Object)date, (Object)hydrometersIds, (Object)BoxesRunTime.boxToInteger((int)dataType));
            DateTime date2 = (DateTime)tuple3._1();
            Seq hydrometersIds2 = (Seq)tuple3._2();
            int dataType2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Seq thresholds = $this.stationThresholdDao.getAllStationThresholds(StationTypeUtil$.MODULE$.HYDROMETRY());
            Seq<HydroSituation> results = $this.situationDao.getHydroSituation((Seq<Object>)hydrometersIds2, date2, (Seq<StationThreshold>)thresholds, dataType2, $this.situationDao.getHydroSituation$default$5());
            return Json$.MODULE$.toJson(results, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydroSituation$.MODULE$.situationFormat())).toString();
        });
    }

    public Reads<Seq<Object>> longIdsRead() {
        return this.longIdsRead;
    }

    public String getHydrometersSituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.longIdsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(28).append("Can't read hydro ids list : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)hydrometerIds -> {
            Seq<HydroMeasuresSituation> results = $this.situationDao.getHydrometerMeasuresSituation((Seq<Object>)hydrometerIds);
            return Json$.MODULE$.toJson(results, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydroMeasuresSituation$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple5<DateTime, Object, String, Seq<Object>, Object>> situationDaysRead() {
        return this.situationDaysRead;
    }

    public String getHydroDaySituation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.situationDaysRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(34).append("Can't read hydro days situation : ").append(error.toString()).toString(), ErrorUtil$.MODULE$.jsonError$default$2(), ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)params -> {
            Tuple5 tuple5 = params;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            DateTime date = (DateTime)tuple5._1();
            int nbDays = BoxesRunTime.unboxToInt((Object)tuple5._2());
            Seq hydrometersIds = (Seq)tuple5._4();
            int dataType = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple4 tuple4 = new Tuple4((Object)date, (Object)BoxesRunTime.boxToInteger((int)nbDays), (Object)hydrometersIds, (Object)BoxesRunTime.boxToInteger((int)dataType));
            DateTime date2 = (DateTime)tuple4._1();
            int nbDays2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            Seq hydrometersIds2 = (Seq)tuple4._3();
            int dataType2 = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Seq<HydroSituationDays> result = $this.situationDao.getHydroDaySituation((Seq<Object>)hydrometersIds2, dataType2, date2, nbDays2);
            return Json$.MODULE$.toJson(result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydroSituationDays$.MODULE$.format())).toString();
        });
    }

    @Inject
    public SituationController(LogUtil logUtil, SituationDao situationDao, StationThresholdDao stationThresholdDao) {
        this.logUtil = logUtil;
        this.situationDao = situationDao;
        this.stationThresholdDao = stationThresholdDao;
        this.situationRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("date").read((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("hydroIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("dataType").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.longIdsRead = JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.LongReads()));
        this.situationDaysRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("date").read((Reads)DateTimeFormatUtil$.MODULE$.datetimeFormat()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("nbDays").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("hydroIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("dataType").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

