/*
 * Decompiled with CFR 0.152.
 */
package station;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.hydrometry.domain.HydrologicalEvent;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.constant.MailRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.EventUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import play.api.libs.json.JsObject;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u00154A\u0001B\u0003\u0001\u0011!)1\u0004\u0001C\u00019!)\u0001\u0006\u0001C\u0001S!)\u0001\r\u0001C\u0001C\n9Q*Y5m\t\u0006|'\"\u0001\u0004\u0002\u000fM$\u0018\r^5p]\u000e\u00011c\u0001\u0001\n\u001fA\u0011!\"D\u0007\u0002\u0017)\tA\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000f\u0017\t1\u0011I\\=SK\u001a\u0004\"\u0001E\r\u000e\u0003EQ!AE\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0015+\u0005A!/\u00192cSRl\u0017O\u0003\u0002\u0017/\u00059\u0011-];bgf\u001c(\"\u0001\r\u0002\u0005\u0019\u0014\u0018B\u0001\u000e\u0012\u0005!\u0001&o\u001c3vG\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0006Q\t\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u00051\u0011N\u001c6fGRT\u0011!J\u0001\u0006U\u00064\u0018\r_\u0005\u0003O\t\u0012a!\u00138kK\u000e$\u0018\u0001C:f]\u0012l\u0015-\u001b7\u0015\u000b)j#H\u0012(\u0011\u0005)Y\u0013B\u0001\u0017\f\u0005\u0011)f.\u001b;\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u000b\u0015l\u0017-\u001b7\u0011\u0005A:dBA\u00196!\t\u00114\"D\u00014\u0015\t!t!\u0001\u0004=e>|GOP\u0005\u0003m-\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011ag\u0003\u0005\u0006w\t\u0001\r\u0001P\u0001\u0006KZ,g\u000e\u001e\t\u0003{\u0011k\u0011A\u0010\u0006\u0003\u007f\u0001\u000ba\u0001Z8nC&t'BA!C\u0003)A\u0017\u0010\u001a:p[\u0016$(/\u001f\u0006\u0003\u0007V\tQ\u0001Z1fCVL!!\u0012 \u0003#!KHM]8m_\u001eL7-\u00197Fm\u0016tG\u000fC\u0003H\u0005\u0001\u0007\u0001*A\u0003is\u0012\u0014x\u000e\u0005\u0002J\u00196\t!J\u0003\u0002L\u0001\u0006)Qn\u001c3fY&\u0011QJ\u0013\u0002\r\u0011f$'o\\*uCRLwN\u001c\u0005\u0006\u001f\n\u0001\r\u0001U\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bcA)W3:\u0011!\u000b\u0016\b\u0003eMK\u0011\u0001D\u0005\u0003+.\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u00191+Z9\u000b\u0005U[\u0001C\u0001._\u001b\u0005Y&BA&]\u0015\ti&)\u0001\bbI6Lg.[:ue\u0006$\u0018n\u001c8\n\u0005}[&aD*jK\u0006,\b+\u0019:b[\u0016$XM]:\u0002\u001d\u001d,G/T1jY\u000e{g\u000e^3oiR!qFY2e\u0011\u0015Y4\u00011\u0001=\u0011\u001595\u00011\u0001I\u0011\u0015y5\u00011\u0001Q\u0001")
public class MailDao
implements Producer {
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        MailDao mailDao = this;
        synchronized (mailDao) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public void sendMail(String email, HydrologicalEvent event, HydroStation hydro, Seq<SieauParameters> parameters) {
        JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.getMailContent(event, hydro, parameters), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(31).append("[Evenement] ").append(EventUtil$.MODULE$.getEventLabelByMnemonique((String)event.eventType().getOrElse((Function0 & Serializable)() -> ""))).append(" sur la station [").append(hydro.code()).append("] ").append(hydro.name().getOrElse((Function0 & Serializable)() -> "")).toString(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"contact@aquasys.fr", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
        this.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
    }

    public String getMailContent(HydrologicalEvent event, HydroStation hydro, Seq<SieauParameters> parameters) {
        BufferedSource buffer = Source$.MODULE$.fromFile(this.getClass().getResource("/eventMail.html").toURI(), Codec$.MODULE$.fallbackSystemCodec());
        String mailContent = buffer.getLines().mkString("").replace("{stationCode}", (CharSequence)hydro.code().getOrElse((Function0 & Serializable)() -> "")).replace("{stationName}", (CharSequence)hydro.name().getOrElse((Function0 & Serializable)() -> "")).replace("{date}", (CharSequence)event.date().map((Function1 & Serializable)x$1 -> x$1.toString("yyyy/MM/dd")).getOrElse((Function0 & Serializable)() -> "")).replace("{hour}", (CharSequence)event.date().map((Function1 & Serializable)x$2 -> x$2.toString("HH:mm:ss")).getOrElse((Function0 & Serializable)() -> "")).replace("{eventType}", EventUtil$.MODULE$.getEventLabelByMnemonique((String)event.eventType().getOrElse((Function0 & Serializable)() -> ""))).replace("{comment}", (CharSequence)event.comment().getOrElse((Function0 & Serializable)() -> "")).replace("{author}", (CharSequence)event.updateLogin().getOrElse((Function0 & Serializable)() -> "")).replace("{applicationUrl}", (CharSequence)package$.MODULE$.env().getOrElse((Object)"APPLICATION_URL", (Function0 & Serializable)() -> "")).replace("{applicationName}", (CharSequence)parameters.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MailDao.$anonfun$getMailContent$11(p))).flatMap((Function1 & Serializable)p -> p.value()).getOrElse((Function0 & Serializable)() -> "")).replace("{supportEmail}", (CharSequence)parameters.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MailDao.$anonfun$getMailContent$14(p))).flatMap((Function1 & Serializable)p -> p.value()).getOrElse((Function0 & Serializable)() -> "")).replace("{supportAddress}", (CharSequence)parameters.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MailDao.$anonfun$getMailContent$17(p))).flatMap((Function1 & Serializable)p -> p.value()).getOrElse((Function0 & Serializable)() -> "")).replace("{supportPhone}", (CharSequence)parameters.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MailDao.$anonfun$getMailContent$20(p))).flatMap((Function1 & Serializable)p -> p.value()).getOrElse((Function0 & Serializable)() -> ""));
        buffer.close();
        return mailContent;
    }

    public static final /* synthetic */ boolean $anonfun$getMailContent$11(SieauParameters p) {
        String string = p.parameter();
        String string2 = "applicationName";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getMailContent$14(SieauParameters p) {
        String string = p.parameter();
        String string2 = "supportMailAddress";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getMailContent$17(SieauParameters p) {
        String string = p.parameter();
        String string2 = "companyAddress";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getMailContent$20(SieauParameters p) {
        String string = p.parameter();
        String string2 = "supportPhoneNumber";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public MailDao() {
        Producer.$init$((Producer)this);
    }
}

