/*
 * Decompiled with CFR 0.152.
 */
package station;

import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.hydrometry.model.HydroStation;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.daeau.station.threshold.StationThreshold$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u0007\u000f\u0001EA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006Y!\u0007\u0005\tK\u0001\u0011\t\u0011)A\u0006M!A\u0001\u0007\u0001B\u0001B\u0003-\u0011\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004I\u0001\t\u0007I\u0011A%\t\r9\u0004\u0001\u0015!\u0003K\u0011\u001dy\u0007A1A\u0005\u0002ADa\u0001\u001f\u0001!\u0002\u0013\t\b\"B=\u0001\t\u0003Q\bbBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007\u00121\u0003\u00165sKNDw\u000e\u001c3D_:$(o\u001c7mKJT\u0011aD\u0001\bgR\fG/[8o\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"AG\u0012\u000e\u0003mQ!\u0001H\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003=}\t\u0001B]1cE&$X.\u001d\u0006\u0003A\u0005\nq!Y9vCNL8OC\u0001#\u0003\t1'/\u0003\u0002%7\t9Aj\\4Vi&d\u0017A\u00065zIJ|Gn\\4jG\u0006d7\u000b^1uS>tG)Y8\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013aA5uM*\u00111\u0006L\u0001\u000bQf$'o\\7fiJL(BA\u0017 \u0003\u0015!\u0017-Z1v\u0013\ty\u0003F\u0001\fIs\u0012\u0014x\u000e\\8hS\u000e\fGn\u0015;bi&|g\u000eR1p\u0003M\u0019H/\u0019;j_:$\u0006N]3tQ>dG\rR1p!\t\u0011T'D\u00014\u0015\tICG\u0003\u0002\u0010Y%\u0011ag\r\u0002\u0014'R\fG/[8o)\"\u0014Xm\u001d5pY\u0012$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\"BA\u000f\u001f>}A\u00111\bA\u0007\u0002\u001d!)\u0001\u0004\u0002a\u00023!)Q\u0005\u0002a\u0002M!)\u0001\u0007\u0002a\u0002c!\u0012A\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000ba!\u001b8kK\u000e$(\"A#\u0002\u000b)\fg/\u0019=\n\u0005\u001d\u0013%AB%oU\u0016\u001cG/\u0001\nuQJ,7\u000f[8mI&s\u0007/\u001e;SK\u0006$W#\u0001&\u0011\u0007-#f+D\u0001M\u0015\tie*\u0001\u0003kg>t'BA(Q\u0003\u0011a\u0017NY:\u000b\u0005E\u0013\u0016aA1qS*\t1+\u0001\u0003qY\u0006L\u0018BA+M\u0005\u0015\u0011V-\u00193t!\u0011\u0019r+\u0017/\n\u0005a#\"A\u0002+va2,'\u0007\u0005\u0002\u00145&\u00111\f\u0006\u0002\u0007\t>,(\r\\3\u0011\u0007u+\u0007N\u0004\u0002_G:\u0011qLY\u0007\u0002A*\u0011\u0011\rE\u0001\u0007yI|w\u000e\u001e \n\u0003UI!\u0001\u001a\u000b\u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0004'\u0016\f(B\u00013\u0015!\tIG.D\u0001k\u0015\tYG'A\u0005uQJ,7\u000f[8mI&\u0011QN\u001b\u0002\u0011'R\fG/[8o)\"\u0014Xm\u001d5pY\u0012\f1\u0003\u001e5sKNDw\u000e\u001c3J]B,HOU3bI\u0002\n!\u0004\u001e5sKNDw\u000e\u001c3ECR\fG+\u001f9f\u0013:\u0004X\u000f\u001e*fC\u0012,\u0012!\u001d\t\u0004\u0017R\u0013\b#B\nt3Vd\u0016B\u0001;\u0015\u0005\u0019!V\u000f\u001d7fgA\u00111C^\u0005\u0003oR\u00111!\u00138u\u0003m!\bN]3tQ>dG\rR1uCRK\b/Z%oaV$(+Z1eA\u0005Ar-\u001a;Is\u0012\u0014x\u000e\\8hS\u000e\fG\u000e\u00165sKNDw\u000e\u001c3\u0015\u0013m\f9!!\u0005\u0002\"\u0005\u0015\u0002c\u0001?\u0002\u00029\u0011QP \t\u0003?RI!a \u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\tyH\u0003C\u0004\u0002\n%\u0001\r!a\u0003\u0002\u000f5,7o]1hKB\u00191*!\u0004\n\u0007\u0005=AJA\u0004KgZ\u000bG.^3\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016\u00059\u0001.Z1eKJ\u001c\bC\u0002?\u0002\u0018m\fY\"\u0003\u0003\u0002\u001a\u0005\u0015!aA'baB\u00191#!\b\n\u0007\u0005}ACA\u0002B]fDa!a\t\n\u0001\u0004Y\u0018AB7pIVdW\r\u0003\u0004\u0002(%\u0001\ra_\u0001\u0005kN,'/A\rhKRD\u0015\u0010\u001a:pY><\u0017nY1m)\"\u0014Xm\u001d5pY\u0012\u001cH#C>\u0002.\u0005=\u0012\u0011GA\u001a\u0011\u001d\tIA\u0003a\u0001\u0003\u0017Aq!a\u0005\u000b\u0001\u0004\t)\u0002\u0003\u0004\u0002$)\u0001\ra\u001f\u0005\u0007\u0003OQ\u0001\u0019A>\u00029U\u0004H-\u0019;f\u0011f$'o\u001c7pO&\u001c\u0017\r\u001c+ie\u0016\u001c\bn\u001c7egRI10!\u000f\u0002<\u0005u\u0012q\b\u0005\b\u0003\u0013Y\u0001\u0019AA\u0006\u0011\u001d\t\u0019b\u0003a\u0001\u0003+Aa!a\t\f\u0001\u0004Y\bBBA\u0014\u0017\u0001\u000710\u0001\u0013va\u0012\fG/\u001a#bi\u0006$\u0016\u0010]3Is\u0012\u0014x\u000e\\8hS\u000e\fG\u000e\u00165sKNDw\u000e\u001c3t)%Y\u0018QIA$\u0003\u0013\nY\u0005C\u0004\u0002\n1\u0001\r!a\u0003\t\u000f\u0005MA\u00021\u0001\u0002\u0016!1\u00111\u0005\u0007A\u0002mDa!a\n\r\u0001\u0004Y\b")
public class ThresholdController {
    private final LogUtil logUtil;
    private final HydrologicalStationDao hydrologicalStationDao;
    private final StationThresholdDao stationThresholdDao;
    private final Reads<Tuple2<Object, Seq<StationThreshold>>> thresholdInputRead;
    private final Reads<Tuple3<Object, Object, Seq<StationThreshold>>> thresholdDataTypeInputRead;

    public Reads<Tuple2<Object, Seq<StationThreshold>>> thresholdInputRead() {
        return this.thresholdInputRead;
    }

    public Reads<Tuple3<Object, Object, Seq<StationThreshold>>> thresholdDataTypeInputRead() {
        return this.thresholdDataTypeInputRead;
    }

    public String getHydrologicalThreshold(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(54).append("Can't validate id for having hydrological threshold :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> ThresholdController.$anonfun$getHydrologicalThreshold$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String getHydrologicalThresholds(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.stationThresholdDao.getAllStationThresholds("hydrometry"), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationThreshold$.MODULE$.format())).toString();
    }

    public String updateHydrologicalThresholds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.thresholdInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(54).append("Can't validate id for having hydrological threshold :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            Seq thresholds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)id), (Object)thresholds);
            double id2 = tuple22._1$mcD$sp();
            Seq thresholds2 = (Seq)tuple22._2();
            Option option = $this.hydrologicalStationDao.get(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                HydroStation hydro = (HydroStation)some.value();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.stationThresholdDao.update(Double.toString(hydro.id()), "hydrometry", thresholds2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(32).append("Can't find hydrometer with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateDataTypeHydrologicalThresholds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.thresholdDataTypeInputRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(63).append("Can't validate id for having hydrological dataType threshold :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double id = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            int dataType = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Seq thresholds = (Seq)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)id), (Object)BoxesRunTime.boxToInteger((int)dataType), (Object)thresholds);
            double id2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            int dataType2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Seq thresholds2 = (Seq)tuple32._3();
            Option option = $this.hydrologicalStationDao.get(id2);
            if (option instanceof Some) {
                Some some = (Some)option;
                HydroStation hydro = (HydroStation)some.value();
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.stationThresholdDao.updateWithDataType(Double.toString(hydro.id()), StationTypeUtil$.MODULE$.HYDROMETRY(), dataType2, thresholds2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(32).append("Can't find hydrometer with id : ").append(id2).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getHydrologicalThreshold$2(ThresholdController $this, int id) {
        Option option = $this.hydrologicalStationDao.get((double)id);
        if (option instanceof Some) {
            Some some = (Some)option;
            HydroStation hydro = (HydroStation)some.value();
            return Json$.MODULE$.toJson((Object)$this.stationThresholdDao.get(Double.toString(hydro.id()), "hydrometry"), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationThreshold$.MODULE$.format())).toString();
        }
        $this.logUtil.error(new StringBuilder(32).append("Can't find hydrometer with id :\n").append(id).toString(), $this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public ThresholdController(LogUtil logUtil, HydrologicalStationDao hydrologicalStationDao, StationThresholdDao stationThresholdDao) {
        this.logUtil = logUtil;
        this.hydrologicalStationDao = hydrologicalStationDao;
        this.stationThresholdDao = stationThresholdDao;
        this.thresholdInputRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.DoubleReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("thresholds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)StationThreshold$.MODULE$.format()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.thresholdDataTypeInputRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.DoubleReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("dataType").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("thresholds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)StationThreshold$.MODULE$.format()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

