/*
 * Decompiled with CFR 0.152.
 */
package play.filters.components;

import play.components.ConfigurationComponents;
import play.components.CryptoComponents;
import play.components.HttpConfigurationComponents;
import play.components.HttpErrorHandlerComponents;
import play.components.PekkoComponents;
import play.filters.csrf.AddCSRFTokenAction;
import play.filters.csrf.CSRF;
import play.filters.csrf.CSRFAddToken;
import play.filters.csrf.CSRFCheck;
import play.filters.csrf.CSRFConfig;
import play.filters.csrf.CSRFConfig$;
import play.filters.csrf.CSRFErrorHandler;
import play.filters.csrf.CSRFFilter;
import play.filters.csrf.RequireCSRFCheckAction;

public interface CSRFComponents
extends ConfigurationComponents,
CryptoComponents,
HttpConfigurationComponents,
HttpErrorHandlerComponents,
PekkoComponents {
    default public CSRFConfig csrfConfig() {
        return CSRFConfig$.MODULE$.fromConfiguration(this.configuration());
    }

    default public CSRF.TokenProvider csrfTokenProvider() {
        return new CSRF.TokenProviderProvider(this.csrfConfig(), this.csrfTokenSigner().asScala()).get();
    }

    default public AddCSRFTokenAction addCSRFTokenAction() {
        return new AddCSRFTokenAction(this.csrfConfig(), this.sessionConfiguration(), this.csrfTokenProvider(), this.csrfTokenSigner().asScala());
    }

    default public RequireCSRFCheckAction requireCSRFCheckAction() {
        return new RequireCSRFCheckAction(this.csrfConfig(), this.sessionConfiguration(), this.csrfTokenProvider(), this.csrfTokenSigner().asScala(), this.csrfErrorHandler());
    }

    default public CSRFErrorHandler csrfErrorHandler() {
        return new CSRFErrorHandler.DefaultCSRFErrorHandler(new CSRF.CSRFHttpErrorHandler(this.scalaHttpErrorHandler()));
    }

    default public CSRFFilter csrfFilter() {
        return new CSRFFilter(this.csrfConfig(), this.csrfTokenSigner(), this.sessionConfiguration(), this.csrfTokenProvider(), this.csrfErrorHandler(), this.materializer());
    }

    default public CSRFCheck csrfCheck() {
        return new CSRFCheck(this.csrfConfig(), this.csrfTokenSigner().asScala(), this.sessionConfiguration());
    }

    default public CSRFAddToken csrfAddToken() {
        return new CSRFAddToken(this.csrfConfig(), this.csrfTokenSigner().asScala(), this.sessionConfiguration());
    }
}

